// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_values.proto

#include "google/cloud/resourcemanager/v3/tag_values_connection.h"
#include "google/cloud/resourcemanager/v3/internal/tag_values_connection_impl.h"
#include "google/cloud/resourcemanager/v3/internal/tag_values_option_defaults.h"
#include "google/cloud/resourcemanager/v3/internal/tag_values_stub_factory.h"
#include "google/cloud/resourcemanager/v3/internal/tag_values_tracing_connection.h"
#include "google/cloud/resourcemanager/v3/tag_values_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TagValuesConnection::~TagValuesConnection() = default;

StreamRange<google::cloud::resourcemanager::v3::TagValue>
TagValuesConnection::ListTagValues(
    google::cloud::resourcemanager::v3::
        ListTagValuesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::TagValue>>();
}

StatusOr<google::cloud::resourcemanager::v3::TagValue>
TagValuesConnection::GetTagValue(
    google::cloud::resourcemanager::v3::GetTagValueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::resourcemanager::v3::TagValue>
TagValuesConnection::GetNamespacedTagValue(
    google::cloud::resourcemanager::v3::GetNamespacedTagValueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesConnection::CreateTagValue(
    google::cloud::resourcemanager::v3::CreateTagValueRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagValue>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> TagValuesConnection::CreateTagValue(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::CreateTagValueRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesConnection::CreateTagValue(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagValue>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesConnection::UpdateTagValue(
    google::cloud::resourcemanager::v3::UpdateTagValueRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagValue>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> TagValuesConnection::UpdateTagValue(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::UpdateTagValueRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesConnection::UpdateTagValue(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagValue>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesConnection::DeleteTagValue(
    google::cloud::resourcemanager::v3::DeleteTagValueRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagValue>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> TagValuesConnection::DeleteTagValue(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::DeleteTagValueRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesConnection::DeleteTagValue(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagValue>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::iam::v1::Policy> TagValuesConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> TagValuesConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
TagValuesConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<TagValuesConnection> MakeTagValuesConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 TagValuesPolicyOptionList>(options, __func__);
  options =
      resourcemanager_v3_internal::TagValuesDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = resourcemanager_v3_internal::CreateDefaultTagValuesStub(
      std::move(auth), options);
  return resourcemanager_v3_internal::MakeTagValuesTracingConnection(
      std::make_shared<resourcemanager_v3_internal::TagValuesConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
