// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/company_service.proto

#include "google/cloud/talent/v4/internal/company_connection_impl.h"
#include "google/cloud/talent/v4/internal/company_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace talent_v4_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<talent_v4::CompanyServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<talent_v4::CompanyServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<talent_v4::CompanyServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<talent_v4::CompanyServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<talent_v4::CompanyServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

CompanyServiceConnectionImpl::CompanyServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<talent_v4_internal::CompanyServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      CompanyServiceConnection::options())) {}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceConnectionImpl::CreateCompany(
    google::cloud::talent::v4::CreateCompanyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCompany(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::talent::v4::CreateCompanyRequest const& request) {
        return stub_->CreateCompany(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceConnectionImpl::GetCompany(
    google::cloud::talent::v4::GetCompanyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCompany(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::talent::v4::GetCompanyRequest const& request) {
        return stub_->GetCompany(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceConnectionImpl::UpdateCompany(
    google::cloud::talent::v4::UpdateCompanyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCompany(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::talent::v4::UpdateCompanyRequest const& request) {
        return stub_->UpdateCompany(context, options, request);
      },
      *current, request, __func__);
}

Status CompanyServiceConnectionImpl::DeleteCompany(
    google::cloud::talent::v4::DeleteCompanyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCompany(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::talent::v4::DeleteCompanyRequest const& request) {
        return stub_->DeleteCompany(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::talent::v4::Company>
CompanyServiceConnectionImpl::ListCompanies(
    google::cloud::talent::v4::ListCompaniesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListCompanies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::talent::v4::Company>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<talent_v4::CompanyServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::talent::v4::ListCompaniesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::talent::v4::ListCompaniesRequest const&
                       request) {
              return stub->ListCompanies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::talent::v4::ListCompaniesResponse r) {
        std::vector<google::cloud::talent::v4::Company> result(
            r.companies().size());
        auto& messages = *r.mutable_companies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4_internal
}  // namespace cloud
}  // namespace google
