/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jflex.chars.Interval;
import jflex.core.Macros;
import jflex.core.RegExp1;
import jflex.core.RegExp2;
import jflex.core.RegExpException;
import jflex.core.sym;
import jflex.core.unicode.CharClasses;
import jflex.core.unicode.IntCharSet;
import jflex.core.unicode.UnicodeProperties;
import jflex.exceptions.CharClassException;
import jflex.exceptions.GeneratorException;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.option.Options;

public class RegExp {
    int type;

    public RegExp(int type) {
        this.type = type;
    }

    public String print(String tab) {
        return tab + this.toString();
    }

    public String toString() {
        return "type = " + this.typeName();
    }

    public String typeName() {
        return sym.terminalNames[this.type];
    }

    public boolean isCharClass() {
        switch (this.type) {
            case 47: 
            case 55: 
            case 59: {
                return true;
            }
            case 41: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.isCharClass() && binary.r2.isCharClass();
            }
        }
        return false;
    }

    public int size(Macros macros) {
        switch (this.type) {
            case 41: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.size(macros) + binary.r2.size(macros) + 2;
            }
            case 57: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.size(macros) + binary.r2.size(macros);
            }
            case 39: 
            case 40: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) + 2;
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros);
            }
            case 45: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) * content.size(macros);
            }
            case 46: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) * content.size(macros) * 3;
            }
            case 48: 
            case 58: {
                RegExp1 unary = (RegExp1)this;
                return ((String)unary.content).length() + 1;
            }
            case 47: 
            case 59: {
                return 2;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return 2;
            }
            case 49: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).size(macros);
            }
        }
        throw new RegExpException(this);
    }

    static String revString(String s) {
        return new StringBuilder(s).reverse().toString();
    }

    public final RegExp resolveTilde() {
        switch (this.type) {
            case 41: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(41, binary.r1.resolveTilde(), binary.r2.resolveTilde());
            }
            case 57: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(57, binary.r1.resolveTilde(), binary.r2.resolveTilde());
            }
            case 39: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(39, content.resolveTilde());
            }
            case 40: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(40, content.resolveTilde());
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(42, content.resolveTilde());
            }
            case 45: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(45, content.resolveTilde());
            }
            case 46: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = ((RegExp)unary.content).resolveTilde();
                RegExp1 any_star = new RegExp1(39, RegExp.anyChar());
                RegExp1 neg = new RegExp1(45, new RegExp2(57, any_star, new RegExp2(57, content, any_star)));
                return new RegExp2(57, neg, content);
            }
            case 47: 
            case 48: 
            case 55: 
            case 58: 
            case 59: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, unary.content);
            }
        }
        throw new RegExpException(this);
    }

    public static RegExp anyChar() {
        return new RegExp1(55, IntCharSet.allChars());
    }

    public static RegExp1 checkPrimClass(RegExp r) {
        if (!(r instanceof RegExp1) || r.type != 55) {
            throw new CharClassException("Not normalised " + r);
        }
        return (RegExp1)r;
    }

    public static IntCharSet performClassOp(int op, IntCharSet l, IntCharSet r, RegExp ctxt) {
        IntCharSet intersection = l.and(r);
        switch (op) {
            case 32: {
                return intersection;
            }
            case 33: {
                IntCharSet set = IntCharSet.copyOf(l);
                set.sub(intersection);
                return set;
            }
            case 34: {
                IntCharSet set = IntCharSet.copyOf(l);
                set.add(r);
                set.sub(intersection);
                return set;
            }
        }
        throw new RegExpException(ctxt);
    }

    public final RegExp normaliseMacros(Macros m) {
        switch (this.type) {
            case 41: 
            case 57: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(this.type, binary.r1.normaliseMacros(m), binary.r2.normaliseMacros(m));
            }
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(this.type, content.normaliseMacros(m));
            }
            case 52: 
            case 53: {
                RegExp1 unary = (RegExp1)this;
                List contents = (List)unary.content;
                ArrayList<RegExp> newContents = new ArrayList<RegExp>(contents.size());
                for (RegExp r : contents) {
                    RegExp n = r.normaliseMacros(m);
                    newContents.add(n);
                }
                return new RegExp1(this.type, newContents);
            }
            case 54: {
                RegExp1 unary = (RegExp1)this;
                RegExp2 binary = (RegExp2)unary.content;
                RegExp l = binary.r1.normaliseMacros(m);
                RegExp r = binary.r2.normaliseMacros(m);
                return new RegExp1(this.type, new RegExp2(binary.type, l, r));
            }
            case 47: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(this.type, unary.content);
            }
            case 49: {
                RegExp1 unary = (RegExp1)this;
                return m.getDefinition((String)unary.content).normaliseMacros(m);
            }
        }
        throw new RegExpException(this);
    }

    public final RegExp normaliseCCLs(File f, int line) {
        try {
            switch (this.type) {
                case 41: 
                case 57: {
                    RegExp2 binary = (RegExp2)this;
                    return new RegExp2(this.type, binary.r1.normaliseCCLs(f, line), binary.r2.normaliseCCLs(f, line));
                }
                case 39: 
                case 40: 
                case 42: 
                case 45: 
                case 46: {
                    RegExp1 unary = (RegExp1)this;
                    RegExp content = (RegExp)unary.content;
                    return new RegExp1(this.type, content.normaliseCCLs(f, line));
                }
                case 47: 
                case 48: 
                case 55: 
                case 58: 
                case 59: {
                    RegExp1 unary = (RegExp1)this;
                    return new RegExp1(this.type, unary.content);
                }
                case 52: 
                case 53: {
                    RegExp1 unary = (RegExp1)this;
                    List contents = (List)unary.content;
                    IntCharSet set = new IntCharSet();
                    for (RegExp r : contents) {
                        RegExp1 n = RegExp.checkPrimClass(r.normaliseCCLs(f, line));
                        set.add((IntCharSet)n.content);
                    }
                    return new RegExp1(55, this.type == 52 ? set : IntCharSet.complementOf(set));
                }
                case 54: {
                    RegExp1 unary = (RegExp1)this;
                    RegExp2 binary = (RegExp2)unary.content;
                    RegExp1 l = RegExp.checkPrimClass(binary.r1.normaliseCCLs(f, line));
                    IntCharSet setl = (IntCharSet)l.content;
                    RegExp1 r = RegExp.checkPrimClass(binary.r2.normaliseCCLs(f, line));
                    IntCharSet setr = (IntCharSet)r.content;
                    IntCharSet set = RegExp.performClassOp(binary.type, setl, setr, this);
                    return new RegExp1(55, set);
                }
            }
            throw new RegExpException(this);
        }
        catch (CharClassException e) {
            Out.error(f, ErrorMessages.NOT_CHARCLASS, line, -1);
            throw new GeneratorException(e);
        }
    }

    public RegExp expandPreClasses(Map<Integer, IntCharSet> cache, CharClasses cl, boolean caseless) {
        switch (this.type) {
            case 41: 
            case 57: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(this.type, binary.r1.expandPreClasses(cache, cl, caseless), binary.r2.expandPreClasses(cache, cl, caseless));
            }
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(this.type, content.expandPreClasses(cache, cl, caseless));
            }
            case 52: 
            case 53: {
                RegExp1 unary = (RegExp1)this;
                List contents = (List)unary.content;
                ArrayList<RegExp> newContents = new ArrayList<RegExp>(contents.size());
                for (RegExp r : contents) {
                    RegExp n = r.expandPreClasses(cache, cl, caseless);
                    newContents.add(n);
                }
                return new RegExp1(this.type, newContents);
            }
            case 54: {
                RegExp1 unary = (RegExp1)this;
                RegExp2 binary = (RegExp2)unary.content;
                RegExp l = binary.r1.expandPreClasses(cache, cl, caseless);
                RegExp r = binary.r2.expandPreClasses(cache, cl, caseless);
                return new RegExp1(this.type, new RegExp2(binary.type, l, r));
            }
            case 56: {
                RegExp1 unary = (RegExp1)this;
                IntCharSet set = RegExp.getPreClass(cache, cl, (Integer)unary.content);
                return new RegExp1(55, set);
            }
            case 50: {
                RegExp1 unary = (RegExp1)this;
                IntCharSet set = cl.getUnicodeProperties().getIntCharSet((String)unary.content);
                if (caseless) {
                    set = set.getCaseless(cl.getUnicodeProperties());
                }
                return new RegExp1(55, set);
            }
            case 47: 
            case 48: 
            case 55: 
            case 58: 
            case 59: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(this.type, unary.content);
            }
        }
        throw new RegExpException(this);
    }

    private static boolean checkJPartStart(int type, int c) {
        switch (type) {
            case 17: {
                return Character.isJavaIdentifierStart(c);
            }
            case 18: {
                return Character.isJavaIdentifierPart(c);
            }
        }
        return false;
    }

    private static IntCharSet getPreClass(Map<Integer, IntCharSet> preclassCache, CharClasses charClasses, int type) {
        IntCharSet result = preclassCache.get(type);
        if (null == result) {
            UnicodeProperties unicodeProperties = charClasses.getUnicodeProperties();
            switch (type) {
                case 19: {
                    result = unicodeProperties.getIntCharSet("L");
                    break;
                }
                case 20: {
                    result = unicodeProperties.getIntCharSet("Nd");
                    break;
                }
                case 21: {
                    IntCharSet digits = unicodeProperties.getIntCharSet("Nd");
                    result = IntCharSet.ofCharacterRange(0, unicodeProperties.getMaximumCodePoint());
                    result.sub(digits);
                    break;
                }
                case 22: {
                    result = unicodeProperties.getIntCharSet("Uppercase");
                    if (null != result) break;
                    result = unicodeProperties.getIntCharSet("Lu");
                    break;
                }
                case 23: {
                    result = unicodeProperties.getIntCharSet("Lowercase");
                    if (null != result) break;
                    result = unicodeProperties.getIntCharSet("Ll");
                    break;
                }
                case 27: {
                    result = unicodeProperties.getIntCharSet("Whitespace");
                    if (null != result) break;
                    result = unicodeProperties.getIntCharSet("Zs");
                    break;
                }
                case 28: {
                    IntCharSet whitespaceClass = unicodeProperties.getIntCharSet("Whitespace");
                    if (null == whitespaceClass) {
                        whitespaceClass = unicodeProperties.getIntCharSet("Zs");
                    }
                    result = IntCharSet.ofCharacterRange(0, unicodeProperties.getMaximumCodePoint());
                    result.sub(whitespaceClass);
                    break;
                }
                case 29: {
                    IntCharSet alphaClass = unicodeProperties.getIntCharSet("Alphabetic");
                    if (null == alphaClass) {
                        alphaClass = unicodeProperties.getIntCharSet("L");
                    }
                    IntCharSet markClass = unicodeProperties.getIntCharSet("M");
                    IntCharSet digitClass = unicodeProperties.getIntCharSet("Nd");
                    IntCharSet connectorPunctClass = unicodeProperties.getIntCharSet("Pc");
                    if (null == connectorPunctClass) {
                        connectorPunctClass = IntCharSet.ofCharacter(95);
                    }
                    result = IntCharSet.copyOf(alphaClass);
                    result.add(markClass);
                    result.add(digitClass);
                    result.add(connectorPunctClass);
                    break;
                }
                case 30: {
                    IntCharSet alphaClass = unicodeProperties.getIntCharSet("Alphabetic");
                    if (null == alphaClass) {
                        alphaClass = unicodeProperties.getIntCharSet("L");
                    }
                    IntCharSet markClass = unicodeProperties.getIntCharSet("M");
                    IntCharSet digitClass = unicodeProperties.getIntCharSet("Nd");
                    IntCharSet connectorPunctClass = unicodeProperties.getIntCharSet("Pc");
                    if (null == connectorPunctClass) {
                        connectorPunctClass = IntCharSet.ofCharacter(95);
                    }
                    IntCharSet wordClass = IntCharSet.copyOf(alphaClass);
                    wordClass.add(markClass);
                    wordClass.add(digitClass);
                    wordClass.add(connectorPunctClass);
                    result = IntCharSet.ofCharacterRange(0, unicodeProperties.getMaximumCodePoint());
                    result.sub(wordClass);
                    break;
                }
                case 17: 
                case 18: {
                    boolean current;
                    result = new IntCharSet();
                    int c = 0;
                    int start = 0;
                    int last = charClasses.getMaxCharCode();
                    boolean prev = RegExp.checkJPartStart(type, 0);
                    for (c = 1; c < last; ++c) {
                        current = RegExp.checkJPartStart(type, c);
                        if (!prev && current) {
                            start = c;
                        }
                        if (prev && !current) {
                            result.add(new Interval(start, c - 1));
                        }
                        prev = current;
                    }
                    current = RegExp.checkJPartStart(type, c);
                    if (!prev && current) {
                        result.add(new Interval(c, c));
                    }
                    if (prev && current) {
                        result.add(new Interval(start, c));
                    }
                    if (!prev || current) break;
                    result.add(new Interval(start, c - 1));
                    break;
                }
                default: {
                    throw new CharClassException("Unknown predefined char class type: " + type);
                }
            }
            preclassCache.put(type, result);
        }
        return result;
    }

    public final void makeCCLs(CharClasses c, boolean caseless) {
        switch (this.type) {
            case 41: 
            case 57: {
                RegExp2 binary = (RegExp2)this;
                binary.r1.makeCCLs(c, caseless);
                binary.r2.makeCCLs(c, caseless);
                return;
            }
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                content.makeCCLs(c, caseless);
                return;
            }
            case 47: 
            case 59: {
                Integer ch = (Integer)((RegExp1)this).content;
                c.makeClass(ch, caseless);
                return;
            }
            case 48: 
            case 58: {
                String str = (String)((RegExp1)this).content;
                c.makeClass(str, caseless);
                return;
            }
            case 55: {
                RegExp1 unary = (RegExp1)this;
                IntCharSet set = (IntCharSet)unary.content;
                c.makeClass(set, Options.jlex && caseless);
                return;
            }
        }
        throw new CharClassException("makeCCLs: unexpected regexp " + this);
    }

    public final RegExp rev() {
        switch (this.type) {
            case 41: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(41, binary.r1.rev(), binary.r2.rev());
            }
            case 57: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(57, binary.r2.rev(), binary.r1.rev());
            }
            case 39: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(39, content.rev());
            }
            case 40: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(40, content.rev());
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(42, content.rev());
            }
            case 45: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(45, content.rev());
            }
            case 46: {
                RegExp content = this.resolveTilde();
                return content.rev();
            }
            case 48: 
            case 58: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, RegExp.revString((String)unary.content));
            }
            case 47: 
            case 55: 
            case 59: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, unary.content);
            }
        }
        throw new RegExpException(this);
    }
}

