searchData={"items":[{"type":"module","title":"inets","doc":"The Inets services API.\n\nThis module provides the most basic API to the clients and servers that are part\nof the `Inets` application, such as start and stop.\n\n[](){: #common_data_types }","ref":"inets.html"},{"type":"module","title":"Data types - inets","doc":"Type definitions that are used more than once in this module:\n\n`service() = httpc | httpd`\n\n`property() = atom()`","ref":"inets.html#module-data-types"},{"type":"module","title":"See also - inets","doc":"`m:httpc`, `m:httpd`","ref":"inets.html#module-see-also"},{"type":"type","title":"inets.inets_service/0","doc":"","ref":"inets.html#t:inets_service/0"},{"type":"type","title":"inets.service_info/0","doc":"","ref":"inets.html#t:service_info/0"},{"type":"function","title":"inets.service_names/0","doc":"Returns a list of available service names.","ref":"inets.html#service_names/0"},{"type":"function","title":"inets.services/0","doc":"Returns a list of currently running services.\n\n> #### Note {: .info }\n>\n> Services started as `stand_alone` are not listed.","ref":"inets.html#services/0"},{"type":"function","title":"inets.services_info/0","doc":"Returns a list of currently running services where each service is described by\nan `[{Option, Value}]` list. The information in the list is specific for each\nservice and each service has probably its own info function that gives more\ndetails about the service. If specific service info returns `{error, Reason}`,\nInfo will contain Reason term.","ref":"inets.html#services_info/0"},{"type":"function","title":"inets.start/0","doc":"Equivalent to  start/1 .","ref":"inets.html#start/0"},{"type":"function","title":"inets.start/1","doc":"Starts the `Inets` application. Default type is `temporary`. See also\n`m:application`.","ref":"inets.html#start/1"},{"type":"function","title":"inets.start/2","doc":"Equivalent to  start/3 .","ref":"inets.html#start/2"},{"type":"function","title":"inets.start/3","doc":"Dynamically starts an `Inets` service after the `Inets` application has been\nstarted.\n\n> #### Note {: .info }\n>\n> Dynamically started services are not handled by application takeover and\n> failover behavior when `Inets` is run as a distributed application. Nor are\n> they automatically restarted when the `Inets` application is restarted. As\n> long as the `Inets` application is operational, they are supervised and can be\n> soft code upgraded.\n>\n> A service started as `stand_alone`, that is, the service is not started as\n> part of the `Inets` application, lose all OTP application benefits, such as\n> soft upgrade. The `stand_alone`\\-service is linked to the process that started\n> it. Usually some supervision functionality is still in place and in some sense\n> the calling process becomes the top supervisor.\n>\n> #### Warning {: .warning }\n> The stand_alone option is considered deprecated.\n>","ref":"inets.html#start/3"},{"type":"function","title":"inets.stop/0","doc":"Stops the `Inets` application. See also `m:application`.","ref":"inets.html#stop/0"},{"type":"function","title":"inets.stop/2","doc":"Stops a started service of the `Inets` application or takes down a\n`stand_alone`\\-service gracefully. When option `stand_alone` is used in start,\nonly the pid is a valid argument to stop.","ref":"inets.html#stop/2"},{"type":"module","title":"httpc","doc":"An HTTP/1.1 client\n\nThis module provides the API to an HTTP/1.1 compatible client according to\n[RFC 2616](http://www.ietf.org/rfc/rfc2616.txt). Caching is not supported.\n\n> #### Note {: .info }\n>\n> When starting the `Inets` application, a manager process for the default\n> profile is started. The functions in this API that do not explicitly use a\n> profile accesses the default profile. A profile keeps track of proxy options,\n> cookies, and other options that can be applied to more than one request.\n>\n> If the scheme `https` is used, the `SSL` application must be started. When\n> `https` links need to go through a proxy, the CONNECT method extension to\n> HTTP-1.1 is used to establish a tunnel and then the connection is upgraded to\n> TLS. However, \"TLS upgrade\" according to\n> [RFC 2817](http://www.ietf.org/rfc/rfc2817.txt) is not supported.\n>\n> Pipelining is only used if the pipeline time-out is set, otherwise persistent\n> connections without pipelining are used. That is, the client always waits for\n> the previous response before sending the next request.\n\nSome examples are provided in the [Inets User's Guide](http_client.md).","ref":"httpc.html"},{"type":"module","title":"HTTP client service start & stop - httpc","doc":"An HTTP client can be configured to start when starting the `Inets` application\nor started dynamically in runtime by calling the `Inets` application API\n`inets:start(httpc, ServiceConfig)` or `inets:start(httpc, ServiceConfig, How)`,\nsee `m:inets`. The configuration options are as follows:\n\n- **\\{profile, Profile :: atom() | pid()\\}** - Name of the profile. This option\n  is mandatory.\n\n- **\\{data_dir, Path :: string()\\}** - Directory where the profile can save\n  persistent data. If omitted, all cookies are treated as session cookies.\n  `Path` represents a file path or directory path.\n\nThe client can be stopped using [`inets:stop(httpc, Pid)`](`inets:stop/2`) or\n[`inets:stop(httpc, Profile)`](`inets:stop/2`).\n\n> #### Warning {: .warning }\n>\n> Please note that `httpc` normalizes input URIs before internal processing and\n> special care shall be taken when the URI has percent (\"%\") characters. A\n> percent serves as the indicator for percent-encoded octets and it must be\n> percent-encoded as \"%25\" for that octet to be used as data within the URI.\n>\n> For example, in order to send an `HTTP GET` request with the URI\n> `http://localhost/foo%25bar`, the percent character must be percent-encoded\n> when creating the request: `httpc:request(\"http://localhost/foo%2525bar\").`","ref":"httpc.html#module-http-client-service-start-stop"},{"type":"module","title":"See also - httpc","doc":"[RFC 2616](http://www.ietf.org/rfc/rfc2616.txt), `m:inets`, `m:gen_tcp`, `m:ssl`","ref":"httpc.html#module-see-also"},{"type":"function","title":"httpc.cancel_request/1","doc":"Equivalent to  cancel_request/2 .","ref":"httpc.html#cancel_request/1"},{"type":"function","title":"httpc.cancel_request/2","doc":"Cancels an asynchronous HTTP request. Notice that this does not guarantee that\nthe request response is not delivered. Because it is asynchronous, the request\ncan already have been completed when the cancellation arrives.","ref":"httpc.html#cancel_request/2"},{"type":"function","title":"httpc.cookie_header/1","doc":"Equivalent to  cookie_header/2 .","ref":"httpc.html#cookie_header/1"},{"type":"function","title":"httpc.cookie_header/2","doc":"Returns the cookie header that would have been sent when making a request to\n`Url` using profile `Profile`. If no profile is specified, the default profile\nis used.\n\nOption `ipv6_host_with_bracket` deals with how to parse IPv6 addresses. For\ndetails, see argument `Options` of [request/4,5](`request/4`).","ref":"httpc.html#cookie_header/2"},{"type":"function","title":"httpc.cookie_header/3","doc":"Returns the cookie header that would have been sent when making a request to\n`Url` using profile `Profile`. If no profile is specified, the default profile\nis used.\n\nOption `ipv6_host_with_bracket` deals with how to parse IPv6 addresses. For\ndetails, see argument `Options` of [request/4,5](`request/4`).","ref":"httpc.html#cookie_header/3"},{"type":"function","title":"httpc.get_options/1","doc":"Equivalent to  get_options/2 .","ref":"httpc.html#get_options/1"},{"type":"function","title":"httpc.get_options/2","doc":"Retrieves the options currently used by the client.","ref":"httpc.html#get_options/2"},{"type":"function","title":"httpc.info/0","doc":"Equivalent to  info/1 .","ref":"httpc.html#info/0"},{"type":"function","title":"httpc.info/1","doc":"Produces a list of miscellaneous information. Intended for debugging. If no\nprofile is specified, the default profile is used.","ref":"httpc.html#info/1"},{"type":"function","title":"httpc.request/1","doc":"Equivalent to  request/2 .","ref":"httpc.html#request/1"},{"type":"function","title":"httpc.request/2","doc":"Equivalent to [`httpc:request(get, {Url, []}, [], [])`](`request/4`).","ref":"httpc.html#request/2"},{"type":"function","title":"httpc.request/4","doc":"Equivalent to  request/5 .","ref":"httpc.html#request/4"},{"type":"function","title":"httpc.request/5","doc":"Sends an HTTP request. The function can be both synchronous and asynchronous. In\nthe latter case, the function returns `{ok, RequestId}` and then the information\nis delivered to the `receiver` depending on that value.\n\nWhen `Profile` is `stand_alone` only the pid can be used.\n\nHTTP options:\n\n- **`timeout`** - Time-out time for the request.\n\n  The clock starts ticking when the request is sent.\n\n  Time is in milliseconds.\n\n  Default is `infinity`.\n\n- **`connect_timeout`** - Connection time-out time, used during the initial\n  request, when the client is _connecting_ to the server.\n\n  Time is in milliseconds.\n\n  Default is the value of option `timeout`.\n\n- **`ssl`** - This is the `SSL/TLS` connecting configuration option.\n\n  Default value is obtained by calling\n  [`httpc:ssl_verify_host_options(true)`. ](`ssl_verify_host_options/1`). See\n  [ssl:connect/2,3,4](`m:ssl`) for available options.\n\n- **`autoredirect`** - The client automatically retrieves the information from\n  the new URI and returns that as the result, instead of a 30X-result code.\n\n  For some 30X-result codes, automatic redirect is not allowed. In these cases\n  the 30X-result is always returned.\n\n  Default is `true`.\n\n- **`proxy_auth`** - A proxy-authorization header using a tuple where the first\n  element is the `username` and the second element of the tuple is the\n  `password` added to the request.\n\n- **`version`** - Can be used to make the client act as an `HTTP/1.0` client. By\n  default this is an `HTTP/1.1` client. When using `HTTP/1.0` persistent\n  connections are not used.\n\n  Default is the string `\"HTTP/1.1\"`.\n\n- **`relaxed`** - If set to `true`, workarounds for known server deviations from\n  the HTTP-standard are enabled.\n\n  Default is `false`.\n\nOptions details:\n\n- **`sync`** - Option for the request to be synchronous or asynchronous.\n\n  Default is `true`.\n\n- **`stream`** - Streams the body of a 200 or 206 response to the calling\n  process or to a file. When streaming to the calling process using option\n  `self`, the following stream messages are sent to that process:\n  `{http, {RequestId, stream_start, Headers}}, {http, {RequestId, stream, BinBodyPart}}, and {http, {RequestId, stream_end, Headers}}`.\n\n  When streaming to the calling processes using option `{self, once}`, the first\n  message has an extra element, that is,\n  `{http, {RequestId, stream_start, Headers, Pid}}`. This is the process id to\n  be used as an argument to `httpc:stream_next/1` to trigger the next message to\n  be sent to the calling process.\n\n  Notice that chunked encoding can add headers so that there are more headers in\n  the `stream_end` message than in `stream_start`. When streaming to a file and\n  the request is asynchronous, the message `{http, {RequestId, saved_to_file}}`\n  is sent.\n\n  Default is `none`.\n\n- **`body_format`** - Defines if the body is to be delivered as a string or\n  binary. This option is only valid for the synchronous request.\n\n  Default is `string`. Asynchronous requests always use `binary`.\n\n- **`full_result`** - Defines if a \"full result\" is to be returned to the caller\n  (that is, the body, the headers, and the entire status line) or not (the body\n  and the status code).\n\n  Default is `true`.\n\n- **`headers_as_is`** - Defines if the headers provided by the user are to be\n  made lower case or to be regarded as case sensitive.\n\n  The HTTP standard requires them to be case insensitive. Use this feature only\n  if there is no other way to communicate with the server or for testing\n  purpose. When this option is used, no headers are automatically added. All\n  necessary headers must be provided by the user.\n\n  Default is `false`.\n\n- **`socket_opts`** - Socket options to be used for this request.\n\n  See the options used by `m:gen_tcp` and `m:ssl`\n\n  Overrides any value set by function [set_options](`set_options/1`).\n\n  The validity of the options is _not_ checked by the HTTP client they are\n  assumed to be correct and passed on to ssl application and inet driver, which\n  may reject them if they are not correct.\n\n  > #### Note {: .info }\n  >\n  > Persistent connections are not supported when setting the `socket_opts`\n  > option. When `socket_opts` is not set the current implementation assumes the\n  > requests to the same host, port combination will use the same socket\n  > options.\n\n  By default the socket options set by function\n  [set_options/1,2](`set_options/1`) are used when establishing a connection.\n\n- **`receiver`** - Defines how the client delivers the result of an asynchronous\n  request (`sync` has the value `false`).\n\n  - **`t:pid/0`** - Messages are sent to this process in the format\n    `{http, ReplyInfo}`.\n\n  - **`alias/0`** - Messages are sent to this special reference in the format\n    `{http, ReplyInfo}`.\n\n  - **`function/1`** - Information is delivered to the receiver through calls to\n    the provided fun `Receiver(ReplyInfo)`.\n\n  - **`{Module, Function, Args}`** - Information is delivered to the receiver\n    through calls to the callback function\n    [`apply(Module, Function, [ReplyInfo | Args])`](`apply/3`).\n\n  In all of these cases, `ReplyInfo` has the following structure:\n\n  ```erlang\n   {RequestId, saved_to_file}\n   {RequestId, {error, Reason}}\n   {RequestId, Result}\n   {RequestId, stream_start, Headers}\n   {RequestId, stream_start, Headers, HandlerPid}\n   {RequestId, stream, BinBodyPart}\n   {RequestId, stream_end, Headers}\n  ```\n\n  Default is the `pid` of the process calling the request function (`self/0`).\n\n  [](){: #ipv6_host_with_brackets }\n\n- **`ipv6_host_with_brackets`** - Defines when parsing the Host-Port part of an\n  URI with an IPv6 address with brackets, if those brackets are to be retained\n  (`true`) or stripped (`false`).\n\n  Default is `false`.","ref":"httpc.html#request/5"},{"type":"function","title":"httpc.reset_cookies/0","doc":"Equivalent to  reset_cookies/1 .","ref":"httpc.html#reset_cookies/0"},{"type":"function","title":"httpc.reset_cookies/1","doc":"Resets (clears) the cookie database for the specified `Profile`. If no profile\nis specified the default profile is used.","ref":"httpc.html#reset_cookies/1"},{"type":"function","title":"httpc.set_options/1","doc":"Equivalent to  set_options/2 .","ref":"httpc.html#set_options/1"},{"type":"function","title":"httpc.set_options/2","doc":"Sets options to be used for subsequent requests.\n\n- **`HostName`** - Example: \"localhost\" or \"foo.bar.se\"\n\n- **`DomainDesc`** - Example `\"*.Domain\"` or `\"*.ericsson.se\"`\n\n- **`IpAddressDesc`** - Example: \"134.138\" or \"\\[FEDC:BA98\" (all IP addresses\n  starting with 134.138 or FEDC:BA98), \"66.35.250.150\" or\n  \"[2010:836B:4179::836B:4179]\" (a complete IP address). `proxy` defaults to\n  `{undefined, []}`, that is, no proxy is configured and `https_proxy` defaults\n  to the value of `proxy`.\n\n- **`MaxSessions`** - `MaxSessions` Maximum number of persistent connections to\n  a host. Default is `2`.\n\n- **`MaxKeepAlive`** - `MaxKeepAlive` Maximum number of outstanding requests on\n  the same connection to a host. Default is `5`.\n\n- **`KeepAliveTimeout`** - `KeepAliveTimeout` If a persistent connection is idle\n  longer than the `keep_alive_timeout` in milliseconds, the client closes the\n  connection. The server can also have such a time-out but do not take that for\n  granted. Default is `120000` (= 2 min).\n\n- **`MaxPipeline`** - `MaxPipeline` Maximum number of outstanding requests on a\n  pipelined connection to a host. Default is `2`.\n\n- **`PipelineTimeout`** - `PipelineTimeout` If a persistent connection is idle\n  longer than the `pipeline_timeout` in milliseconds, the client closes the\n  connection. Default is `0`, which results in pipelining not being used.\n\n- **`CookieMode`** - If cookies are enabled, all valid cookies are automatically\n  saved in the cookie database of the client manager. If option `verify` is\n  used, function [`store_cookies/2`](`store_cookies/2`) has to be called for the\n  cookies to be saved. Default is `disabled`.\n\n- **`IpFamily`** - Default is `inet`. With `inet6fb4` option, IPv6 will be\n  preferred but if connection fails, an IPv4 fallback connection attempt will be\n  made.\n\n- **`IpAddress`** - If the host has several network interfaces, this option\n  specifies which one to use. See [`gen_tcp:connect/3,4`](`gen_tcp:connect/3`) for\n  details.\n\n- **`Port`** - Example: `8080`. Local port number to use. See\n  [`gen_tcp:connect/3,4`](`gen_tcp:connect/3`) for details.\n\n- **`SocketOpts`** - The options are appended to the socket options used by the\n  client. These are the default values when a new request handler is started\n  (for the initial connect). They are passed directly to the underlying\n  transport (`gen_tcp` or `SSL`) without verification.\n\n  See the options used by `m:gen_tcp` and `m:ssl`\n\n- **`VerboseMode`** - Default is `false`. This option is used to switch on (or\n  off) different levels of Erlang trace on the client. It is a debug feature.\n\n- **`Profile`** - When started `stand_alone` only the pid can be used.\n\n- **`UnixSocket`** - Experimental option for sending HTTP requests over a unix\n  domain socket. The value of `unix_socket` shall be the full path to a unix\n  domain socket file with read/write permissions for the erlang process. Default\n  is `undefined`.\n\n> #### Note {: .info }\n>\n> If possible, the client keeps its connections alive and uses persistent\n> connections with or without pipeline depending on configuration and current\n> circumstances. The HTTP/1.1 specification does not provide a guideline for how\n> many requests that are ideal to be sent on a persistent connection. This\n> depends much on the application.\n>\n> A long queue of requests can cause a user-perceived delay, as earlier requests\n> can take a long time to complete. The HTTP/1.1 specification suggests a limit\n> of two persistent connections per server, which is the default value of option\n> `max_sessions`.\n>\n> The current implementation assumes the requests to the same host, port\n> combination will use the same socket options.","ref":"httpc.html#set_options/2"},{"type":"function","title":"httpc.ssl_verify_host_options/1","doc":"Returns ssl options which can be used to verify the host, uses\n[`public_key:cacerts_get()`](`public_key:cacerts_get/0`) to read CA certicates\nand if `WildcardHostName` is true adds the hostname check from\n[`public_key:public_key:pkix_verify_hostname_match_fun(https)`](`public_key:pkix_verify_hostname_match_fun/1`)\nto the options.","ref":"httpc.html#ssl_verify_host_options/1"},{"type":"function","title":"httpc.store_cookies/2","doc":"Equivalent to  store_cookies/3 .","ref":"httpc.html#store_cookies/2"},{"type":"function","title":"httpc.store_cookies/3","doc":"Saves the cookies defined in `SetCookieHeaders` in the client profile cookie\ndatabase. Call this function if option `cookies` is set to `verify`. If no\nprofile is specified, the default profile is used.","ref":"httpc.html#store_cookies/3"},{"type":"function","title":"httpc.stream_next/1","doc":"Triggers the next message to be streamed, that is, the same behavior as active\nones for sockets.","ref":"httpc.html#stream_next/1"},{"type":"function","title":"httpc.which_cookies/0","doc":"Equivalent to  which_cookies/1 .","ref":"httpc.html#which_cookies/0"},{"type":"function","title":"httpc.which_cookies/1","doc":"Produces a list of the entire cookie database. Intended for debugging/testing\npurposes. If no profile is specified, the default profile is used.","ref":"httpc.html#which_cookies/1"},{"type":"function","title":"httpc.which_sessions/0","doc":"Equivalent to  which_sessions/1 .","ref":"httpc.html#which_sessions/0"},{"type":"function","title":"httpc.which_sessions/1","doc":"This function is intended for debugging only. It produces a slightly processed\ndump of the session database. The first list of the session information tuple\nwill contain session information on an internal format. The last two lists of\nthe session information tuple should always be empty if the code is working as\nintended. If no profile is specified, the default profile is used.","ref":"httpc.html#which_sessions/1"},{"type":"behaviour","title":"httpd","doc":"HTTP server API\n\nAn implementation of an HTTP 1.1 compliant web server, as defined in\n[RFC 2616](http://www.ietf.org/rfc/rfc2616.txt). Provides web server start\noptions, administrative functions, and an Erlang callback API.","ref":"httpd.html"},{"type":"behaviour","title":"Data types - httpd","doc":"Type definitions that are used more than once in this module:\n\n`boolean() = true | false`\n\n`t:string/0` = list of ASCII characters\n\n`path() = string()` representing a file or a directory path\n\n`ip_address() = {N1,N2,N3,N4} % IPv4 | {K1,K2,K3,K4,K5,K6,K7,K8} % IPv6`\n\n`hostname() = string()` representing a host, for example, \"foo.bar.com\"\n\n`property() = atom()`","ref":"httpd.html#module-data-types"},{"type":"behaviour","title":"HTTP server service start & stop - httpd","doc":"A web server can be configured to start when starting the `Inets` application,\nor dynamically in runtime by calling the `Inets` application API\n`inets:start(httpd, ServiceConfig)` or `inets:start(httpd, ServiceConfig, How)`,\nsee `m:inets`. The configuration options, also called properties, are as\nfollows:\n\n[](){: #props_file }","ref":"httpd.html#module-http-server-service-start-stop"},{"type":"behaviour","title":"File Properties - httpd","doc":"When the web server is started at application start time, the properties are to\nbe fetched from a configuration file that can consist of a regular Erlang\nproperty list, that is, `[{Option, Value}]`, where `Option = property() `and\n`Value = term()`, followed by a full stop. If the web server is started\ndynamically at runtime, a file can still be specified but also the complete\nproperty list.\n\n- [](){: #prop_proplist_file } **`{proplist_file, path()}`**  \n  If this property is defined, `Inets` expects to find all other properties\n  defined in this file. The file must include all properties listed under\n  mandatory properties.\n\n> #### Note {: .info }\n>\n> Note support for legacy configuration file with Apache syntax is dropped in\n> OTP-23.\n\n[](){: #props_mand }","ref":"httpd.html#module-file-properties"},{"type":"behaviour","title":"Mandatory Properties - httpd","doc":"- [](){: #prop_port } **`{port, integer()}`**  \n  The port that the HTTP server listen to. If zero is specified as port, an\n  arbitrary available port is picked and function `httpd:info/2` can be used to\n  determine which port was picked.\n\n- [](){: #prop_server_root } **`{server_root, path()}`**  \n  Defines the home directory of the server, where log files, and so on, can be\n  stored. Relative paths specified in other properties refer to this directory.\n\n- [](){: #prop_doc_root } **`{document_root, path()}`**  \n  Defines the top directory for the documents that are available on the HTTP\n  server.\n\n[](){: #props_comm }","ref":"httpd.html#module-mandatory-properties"},{"type":"behaviour","title":"Communication Properties - httpd","doc":"- [](){: #prop_bind_address } **`{bind_address, ip_address() | hostname() |\n  any}`**  \n  Default is `any`\n\n- [](){: #prop_server_name } **`{server_name, string()}`**  \n  The name of your server, normally a fully qualified domain name.\n\n  If not given, this defaults to `net_adm:localhost()`.\n\n- [](){: #profile } **`{profile, atom()}`**  \n  Used together with [`bind_address`](`m:httpd#prop_bind_address`) and\n  [`port`](`m:httpd#prop_port`) to uniquely identify a HTTP server. This can be\n  useful in a virtualized environment, where there can be more that one server\n  that has the same bind_address and port. If this property is not explicitly\n  set, it is assumed that the [`bind_address`](`m:httpd#prop_bind_address`) and\n  [`port`](`m:httpd#prop_port`) uniquely identifies the HTTP server.\n\n- [](){: #prop_socket_type } **`{socket_type, ip_comm | {ip_comm, Config::proplist()} | {ssl, Config::proplist()}}`**  \n  For `ip_comm` configuration options, see `gen_tcp:listen/2`, some options that\n  are used internally by httpd cannot be set.\n\n  For `SSL` configuration options, see `ssl:listen/2`.\n\n  Default is `ip_comm`.\n\n  > #### Note {: .info }\n  >\n  > OTP-25 deprecates the communication properties\n  > `{socket_type, ip_comm | {ip_comm, Config::proplist()} | {essl, Config::proplist()}}`\n  > replacing it by\n  > `{socket_type, ip_comm | {ip_comm, Config::proplist()} | {ssl, Config::proplist()}}`.\n\n- [](){: #prop_ipfamily } **`{ipfamily, inet | inet6}`**  \n  Default is `inet`, legacy option `inet6fb4` no longer makes sense and will be\n  translated to inet.\n\n- [](){: #prop_minimum_bytes_per_second } **`{minimum_bytes_per_second,\n  integer()}`**  \n  If given, sets a minimum of bytes per second value for connections.\n\n  If the value is unreached, the socket closes for that connection.\n\n  The option is good for reducing the risk of \"slow DoS\" attacks.\n\n[](){: #props_api_modules }","ref":"httpd.html#module-communication-properties"},{"type":"behaviour","title":"Erlang Web Server API Modules - httpd","doc":"- [](){: #prop_modules } **`{modules, [atom()]}`**  \n  Defines which modules the HTTP server uses when handling requests. Default is\n  `[mod_alias, mod_auth, mod_esi, mod_actions, mod_cgi, mod_dir, mod_get, mod_head, mod_log, mod_disk_log]`.\n  Notice that some `mod`\\-modules are dependent on others, so the order cannot\n  be entirely arbitrary. See the [Inets Web Server Modules](http_server.md) in\n  the User's Guide for details.\n\n[](){: #props_limit }","ref":"httpd.html#module-erlang-web-server-api-modules"},{"type":"behaviour","title":"Limit properties - httpd","doc":"- [](){: #prop_customize } **`{customize, atom()}`**  \n  A callback module to customize the inets HTTP servers behaviour see\n  `m:httpd_custom_api`\n\n- [](){: #prop_disable_chunked_encoding }\n  **`{disable_chunked_transfer_encoding_send, boolean()}`**  \n  Allows you to disable chunked transfer-encoding when sending a response to an\n  HTTP/1.1 client. Default is `false`.\n\n- [](){: #prop_keep_alive } **`{keep_alive, boolean()}`**  \n  Instructs the server whether to use persistent connections when the client\n  claims to be HTTP/1.1 compliant. Default is `true`.\n\n- [](){: #prop_keep_alive_timeout } **`{keep_alive_timeout, integer()}`**  \n  The number of seconds the server waits for a subsequent request from the\n  client before closing the connection. Default is `150`.\n\n- [](){: #prop_max_body_size } **`{max_body_size, integer()}`**  \n  Limits the size of the message body of an HTTP request. Default is no limit.\n\n- [](){: #prop_max_clients } **`{max_clients, integer()}`**  \n  Limits the number of simultaneous requests that can be supported. Default is\n  `150`.\n\n- [](){: #prop_max_header_size } **`{max_header_size, integer()}`**  \n  Limits the size of the message header of an HTTP request. Default is `10240`.\n\n- [](){: #prop_max_content_length } **`{max_content_length, integer()}`**  \n  Maximum content-length in an incoming request, in bytes. Requests with content\n  larger than this are answered with status 413. Default is `100000000` (100\n  MB).\n\n- [](){: #prop_max_uri } **`{max_uri_size, integer()}`**  \n  Limits the size of the HTTP request URI. Default is no limit.\n\n- [](){: #prop_max_keep_alive_req } **`{max_keep_alive_request, integer()}`**  \n  The number of requests that a client can do on one connection. When the server\n  has responded to the number of requests defined by `max_keep_alive_requests`,\n  the server closes the connection. The server closes it even if there are\n  queued request. Default is no limit.\n\n- [](){: #max_client_body_chunk } **`{max_client_body_chunk, integer()}`**  \n  Enforces chunking of a HTTP PUT or POST body data to be delivered to the\n  mod_esi callback. Note this is not supported for mod_cgi. Default is no limit\n  e.i the whole body is delivered as one entity, which could be very memory\n  consuming. `m:mod_esi`.\n\n[](){: #props_admin }","ref":"httpd.html#module-limit-properties"},{"type":"behaviour","title":"Administrative Properties - httpd","doc":"- [](){: #prop_mime_types } **`{mime_types, [{MimeType, Extension}] | path()}`**  \n  `MimeType = string()` and `Extension = string()`. Files delivered to the\n  client are MIME typed according to RFC 1590. File suffixes are mapped to MIME\n  types before file delivery. The mapping between file suffixes and MIME types\n  can be specified in the property list.\n\n  Mime types can also be read from a file. The file should contain lines in the\n  form `MediaType [Extensions...]`, such as `text/html html htm`. To configure\n  this, specify the path to it, such as `{mime_types, \"/etc/mime.types\"}`.\n\n  If unset, `conf/mime.types` under `server_root` will be used if it exists,\n  otherwise, the default is `[{\"html\",\"text/html\"},{\"htm\",\"text/html\"}]`.\n\n- [](){: #prop_mime_type } **`{mime_type, string()}`**  \n  When the server is asked to provide a document type that cannot be determined\n  by the MIME Type Settings, the server uses this default type.\n\n- [](){: #prop_server_admin } **`{server_admin, string()}`**  \n  Defines the email-address of the server administrator to be included in any\n  error messages returned by the server.\n\n- [](){: #prop_server_tokens } **`{server_tokens,\n  none|prod|major|minor|minimal|os|full|{private, string()}}`**  \n  Defines the look of the value of the server header.\n\n  Example: Assuming the version of `Inets` is 5.8.1, the server header string\n  can look as follows for the different values of server-tokens:\n\n  - **`none`** - \"\" % A Server: header will not be generated\n\n  - **`prod`** - \"inets\"\n\n  - **`major`** - \"inets/5\"\n\n  - **`minor`** - \"inets/5.8\"\n\n  - **`minimal`** - \"inets/5.8.1\"\n\n  - **`os`** - \"inets/5.8.1 (unix)\"\n\n  - **`full`** - \"inets/5.8.1 (unix/linux) OTP/R15B\"\n\n  - **`{private, \"foo/bar\"}`** - \"foo/bar\"\n\n  By default, the value is as before, that is, `minimal`.\n\n- [](){: #prop_logger } **`{logger, Options::list()}`**  \n  Currently only one option is supported:\n\n  - **`{error, ServerID::atom()}`** - Produces\n    [logger events](`t:logger:log_event/0`) on logger\n    [level error](`t:logger:level/0`) under the hierarchical logger\n    [domain:](`t:logger:log_event/0`) `[otp, inets, httpd, ServerID, error]` The\n    built in logger formatting function produces log entries from the error\n    reports:\n\n    ```c\n    #{server_name => string()\n      protocol => internal | 'TCP' | 'TLS' | 'HTTP',\n      transport => \"TCP\" | \"TLS\", %% Present when protocol = 'HTTP'\n      uri => string(), %% Present when protocol = 'HTTP' and URI is valid\n      peer => inet:peername(),\n      host => inet:hostname(),\n      reason => term()\n    }\n    ```\n\n    An example of a log entry with only default settings of logger\n\n    ```text\n    =ERROR REPORT==== 9-Oct-2019::09:33:27.350235 ===\n       Server: My Server\n     Protocol: HTTP\n    Transport: TLS\n          URI: /not_there\n         Host: 127.0.1.1:80\n         Peer: 127.0.0.1:45253\n       Reason: [{statuscode,404},{description,\"Object Not Found\"}]\n    ```\n\n    Using this option makes mod_log and mod_disk_log error logs redundant.\n\n    Add the filter\n\n    ```erlang\n    {fun logger_filters:domain/2,\n    \t{log,equal,[otp,inets, httpd, ServerID, error]}\n    ```\n\n    to appropriate logger handler to handle the events. For example to write the\n    error log from an httpd server with a `ServerID` of `my_server` to a file\n    you can use the following sys.config:\n\n    ```erlang\n    [{kernel,\n     [{logger,\n      [{handler, http_error_test, logger_std_h,\n        #{config => #{ file => \"log/http_error.log\" },\n          filters => [{inets_httpd, {fun logger_filters:domain/2,\n                                     {log, equal,\n                                      [otp, inets, httpd, my_server, error]\n                                     }}}],\n          filter_default => stop }}]}]}].\n    ```\n\n    or if you want to add it to the default logger via an API:\n\n    ```erlang\n    logger:add_handler_filter(default,\n                              inets_httpd,\n                              {fun logger_filters:domain/2,\n                               {log, equal,\n                                [otp, inets, httpd, my_server, error]}}).\n    ```\n\n- [](){: #prop_log_format } **`{log_format, common | combined}`**  \n  Defines if access logs are to be written according to the `common` log format\n  or the extended common log format. The `common` format is one line looking\n  like this: `remotehost rfc931 authuser [date] \"request\" status bytes`.\n\n  Here:\n\n  - **`remotehost`** - Remote.\n\n  - **`rfc931`** - The remote username of the client\n    ([RFC 931](http://www.ietf.org/rfc/rfc931.txt)).\n\n  - **`authuser`** - The username used for authentication.\n\n  - **`[date]`** - Date and time of the request\n    ([RFC 1123](http://www.ietf.org/rfc/rfc1123.txt)).\n\n  - **`\"request\"`** - The request line as it came from the client\n    ([RFC 1945](http://www.ietf.org/rfc/rfc1945.txt)).\n\n  - **`status`** - The HTTP status code returned to the client\n    ([RFC 1945](http://www.ietf.org/rfc/rfc1945.txt)).\n\n  - **`bytes`** - The content-length of the document transferred.\n\n  The `combined` format is one line looking like this:\n  `remotehost rfc931 authuser [date] \"request\" status bytes \"referer\" \"user_agent\"`\n\n  In addition to the earlier:\n\n  - **`\"referer\"`** - The URL the client was on before requesting the URL (if it\n    could not be determined, a minus sign is placed in this field).\n\n  - **`\"user_agent\"`** - The software the client claims to be using (if it could\n    not be determined, a minus sign is placed in this field).\n\n  This affects the access logs written by `mod_log` and `mod_disk_log`.\n\n- [](){: #prop_elog_format } **`{error_log_format, pretty | compact}`**  \n  Default is `pretty`. If the error log is meant to be read directly by a human,\n  `pretty` is the best option.\n\n  `pretty` has a format corresponding to:\n\n  ```erlang\n  io:format(\"[~s] ~s, reason: ~n ~p ~n~n\", [Date, Msg, Reason]).\n  ```\n\n  `compact` has a format corresponding to:\n\n  ```erlang\n  io:format(\"[~s] ~s, reason: ~w ~n\", [Date, Msg, Reason]).\n  ```\n\n  This affects the error logs written by `mod_log` and `mod_disk_log`.\n\n[](){: #props_alias }","ref":"httpd.html#module-administrative-properties"},{"type":"behaviour","title":"URL Aliasing Properties - Requires mod_alias - httpd","doc":"- [](){: #prop_alias } **`{alias, {Alias, RealName}}`**  \n  `Alias = string()` and `RealName = string()`. `alias` allows documents to be\n  stored in the local file system instead of the `document_root` location. URLs\n  with a path beginning with url-path is mapped to local files beginning with\n  directory-filename, for example:\n\n  ```erlang\n  {alias, {\"/image\", \"/ftp/pub/image\"}}\n  ```\n\n  Access to http://your.server.org/image/foo.gif would refer to the file\n  /ftp/pub/image/foo.gif.\n\n- [](){: #prop_re_write } **`{re_write, {Re, Replacement}}`**  \n  `Re = string()` and `Replacement = string()`. `re_write` allows documents to\n  be stored in the local file system instead of the `document_root` location.\n  URLs are rewritten by `re:replace/3` to produce a path in the local\n  file-system, for example:\n\n  ```erlang\n  {re_write, {\"^/[~]([^/]+)(.*)$\", \"/home/\\\\1/public\\\\2\"}}\n  ```\n\n  Access to http://your.server.org/~bob/foo.gif would refer to the file\n  /home/bob/public/foo.gif.\n\n- [](){: #prop_dir_idx } **`{directory_index, [string()]}`**  \n  `directory_index` specifies a list of resources to look for if a client\n  requests a directory using a `/` at the end of the directory name. `file`\n  depicts the name of a file in the directory. Several files can be given, in\n  which case the server returns the first it finds, for example:\n\n  ```erlang\n  {directory_index, [\"index.html\", \"welcome.html\"]}\n  ```\n\n  Access to http://your.server.org/docs/ would return\n  http://your.server.org/docs/index.html or\n  http://your.server.org/docs/welcome.html if index.html does not exist.\n\n[](){: #props_cgi }","ref":"httpd.html#module-url-aliasing-properties-requires-mod_alias"},{"type":"behaviour","title":"CGI Properties - Requires mod_cgi - httpd","doc":"- [](){: #prop_script_alias } **`{script_alias, {Alias, RealName}}`**  \n  `Alias = string()` and `RealName = string()`. Have the same behavior as\n  property `alias`, except that they also mark the target directory as\n  containing CGI scripts. URLs with a path beginning with url-path are mapped to\n  scripts beginning with directory-filename, for example:\n\n  ```text\n  {script_alias, {\"/cgi-bin/\", \"/web/cgi-bin/\"}}\n  ```\n\n  Access to http://your.server.org/cgi-bin/foo would cause the server to run the\n  script /web/cgi-bin/foo.\n\n- [](){: #prop_script_re_write } **`{script_re_write, {Re, Replacement}}`**  \n  `Re = string()` and `Replacement = string()`. Have the same behavior as\n  property `re_write`, except that they also mark the target directory as\n  containing CGI scripts. URLs with a path beginning with url-path are mapped to\n  scripts beginning with directory-filename, for example:\n\n  ```text\n  {script_re_write, {\"^/cgi-bin/(\\\\d+)/\", \"/web/\\\\1/cgi-bin/\"}}\n  ```\n\n  Access to http://your.server.org/cgi-bin/17/foo would cause the server to run\n  the script /web/17/cgi-bin/foo.\n\n- [](){: #prop_script_nocache } **`{script_nocache, boolean()}`**  \n  If `script_nocache` is set to `true`, the HTTP server by default adds the\n  header fields necessary to prevent proxies from caching the page. Generally\n  this is preferred. Default to `false`.\n\n- [](){: #prop_script_timeout } **`{script_timeout, integer()}`**  \n  The time in seconds the web server waits between each chunk of data from the\n  script. If the CGI script does not deliver any data before the timeout, the\n  connection to the client is closed. Default is `15`.\n\n- [](){: #prop_action } **`{action, {MimeType, CgiScript}}`** - requires `mod_actions`  \n  `MimeType = string()` and `CgiScript = string()`. `action` adds an action\n  activating a CGI script whenever a file of a certain MIME type is requested.\n  It propagates the URL and file path of the requested document using the\n  standard CGI PATH_INFO and PATH_TRANSLATED environment variables.\n\n  Example:\n\n  ```text\n  {action, {\"text/plain\", \"/cgi-bin/log_and_deliver_text\"}}\n  ```\n\n- [](){: #prop_script } **`{script, {Method, CgiScript}}`** - requires `mod_actions`  \n  `Method = string()` and `CgiScript = string()`. `script` adds an action\n  activating a CGI script whenever a file is requested using a certain HTTP\n  method. The method is either GET or POST, as defined in\n  [RFC 1945](http://www.ietf.org/rfc/rfc1945.txt). It propagates the URL and\n  file path of the requested document using the standard CGI PATH_INFO and\n  PATH_TRANSLATED environment variables.\n\n  Example:\n\n  ```erlang\n  {script, {\"PUT\", \"/cgi-bin/put\"}}\n  ```\n\n[](){: #props_esi }","ref":"httpd.html#module-cgi-properties-requires-mod_cgi"},{"type":"behaviour","title":"ESI Properties - Requires mod_esi - httpd","doc":"- [](){: #prop_esi_alias } **`{erl_script_alias, {URLPath, [AllowedModule]}}`**  \n  `URLPath = string()` and `AllowedModule = atom()`. `erl_script_alias` marks\n  all URLs matching url-path as erl scheme scripts. A matching URL is mapped\n  into a specific module and function, for example:\n\n  ```erlang\n  {erl_script_alias, {\"/cgi-bin/example\", [httpd_example]}}\n  ```\n\n  A request to http://your.server.org/cgi-bin/example/httpd_example:yahoo would\n  refer to httpd_example:yahoo/3 or, if that does not exist,\n  httpd_example:yahoo/2 and http://your.server.org/cgi-bin/example/other:yahoo\n  would not be allowed to execute.\n\n- [](){: #prop_esi_nocache } **`{erl_script_nocache, boolean()}`**  \n  If `erl_script_nocache` is set to `true`, the server adds HTTP header fields\n  preventing proxies from caching the page. This is generally a good idea for\n  dynamic content, as the content often varies between each request. Default is\n  `false`.\n\n- [](){: #prop_esi_timeout } **`{erl_script_timeout, integer()}`**  \n  If `erl_script_timeout` sets the time in seconds the server waits between each\n  chunk of data to be delivered through `mod_esi:deliver/2`. Default is `15`.\n  This is only relevant for scripts that use the erl scheme.\n\n[](){: #props_log }","ref":"httpd.html#module-esi-properties-requires-mod_esi"},{"type":"behaviour","title":"Log Properties - Requires mod_log - httpd","doc":"- [](){: #prop_elog } **`{error_log, path()}`**  \n  Defines the filename of the error log file to be used to log server errors. If\n  the filename does not begin with a slash (/), it is assumed to be relative to\n  the `server_root`.\n\n- [](){: #prop_slog } **`{security_log, path()}`**  \n  Defines the filename of the access log file to be used to log security events.\n  If the filename does not begin with a slash (/), it is assumed to be relative\n  to the `server_root`.\n\n- [](){: #prop_tlog } **`{transfer_log, path()}`**  \n  Defines the filename of the access log file to be used to log incoming\n  requests. If the filename does not begin with a slash (/), it is assumed to be\n  relative to the `server_root`.\n\n[](){: #props_dlog }","ref":"httpd.html#module-log-properties-requires-mod_log"},{"type":"behaviour","title":"Disk Log Properties - Requires mod_disk_log - httpd","doc":"- [](){: #prop_dlog_format } **`{disk_log_format, internal | external}`**  \n  Defines the file format of the log files. See `disk_log` for details. If the\n  internal file format is used, the log file is repaired after a crash. When a\n  log file is repaired, data can disappear. When the external file format is\n  used, `httpd` does not start if the log file is broken. Default is `external`.\n\n- [](){: #prop_edlog } **`{error_disk_log, path()}`**  \n  Defines the filename of the (`m:disk_log`) error log file to be used to log\n  server errors. If the filename does not begin with a slash (/), it is assumed\n  to be relative to the `server_root`.\n\n- [](){: #prop_edlog_size } **`{error_disk_log_size, {MaxBytes, MaxFiles}}`**  \n  `MaxBytes = integer()` and `MaxFiles = integer()`. Defines the properties of\n  the (`m:disk_log`) error log file. This file is of type wrap log and max bytes\n  is written to each file and max files is used before the first file is\n  truncated and reused.\n\n- [](){: #prop_sdlog } **`{security_disk_log, path()}`**  \n  Defines the filename of the (`m:disk_log`) access log file logging incoming\n  security events, that is, authenticated requests. If the filename does not\n  begin with a slash (/), it is assumed to be relative to the `server_root`.\n\n- [](){: #prop_sdlog_size } **`{security_disk_log_size, {MaxBytes, MaxFiles}}`**  \n  `MaxBytes = integer()` and `MaxFiles = integer()`. Defines the properties of\n  the `m:disk_log` access log file. This file is of type wrap log and max bytes\n  is written to each file and max files is used before the first file is\n  truncated and reused.\n\n- [](){: #prop_tdlog } **`{transfer_disk_log, path()}`**  \n  Defines the filename of the (`m:disk_log`) access log file logging incoming\n  requests. If the filename does not begin with a slash (/), it is assumed to be\n  relative to the `server_root`.\n\n- [](){: #prop_tdlog_size } **`{transfer_disk_log_size, {MaxBytes, MaxFiles}}`**  \n  `MaxBytes = integer()` and `MaxFiles = integer()`. Defines the properties of\n  the `m:disk_log` access log file. This file is of type wrap log and max bytes\n  is written to each file and max files is used before the first file is\n  truncated and reused.\n\n[](){: #props_auth }","ref":"httpd.html#module-disk-log-properties-requires-mod_disk_log"},{"type":"behaviour","title":"Authentication Properties - Requires mod_auth - httpd","doc":"[](){: #prop_dri }\n\n```erlang\n{directory, {path(), [{property(), term()}]}}\n```\n\n[](){: #props_dir }\n\nThe properties for directories are as follows:\n\n- [](){: #prop_allow_from } **`{allow_from, all | [RegxpHostString]}`**  \n  Defines a set of hosts to be granted access to a given directory, for example:\n\n  ```erlang\n  {allow_from, [\"123.34.56.11\", \"150.100.23\"]}\n  ```\n\n  The host `123.34.56.11` and all machines on the `150.100.23` subnet are\n  allowed access.\n\n- [](){: #prop_deny_from } **`{deny_from, all | [RegxpHostString]}`**  \n  Defines a set of hosts to be denied access to a given directory, for example:\n\n  ```text\n  {deny_from, [\"123.34.56.11\", \"150.100.23\"]}\n  ```\n\n  The host `123.34.56.11` and all machines on the `150.100.23` subnet are not\n  allowed access.\n\n- [](){: #prop_auth_type } **`{auth_type, plain | dets | mnesia}`**  \n  Sets the type of authentication database that is used for the directory. The\n  key difference between the different methods is that dynamic data can be saved\n  when Mnesia and Dets are used.\n\n- [](){: #prop_auth_user_file } **`{auth_user_file, path()}`**  \n  Sets the name of a file containing the list of users and passwords for user\n  authentication. The filename can be either absolute or relative to the\n  `server_root`. If using the plain storage method, this file is a plain text\n  file where each line contains a username followed by a colon, followed by the\n  non-encrypted password. If usernames are duplicated, the behavior is\n  undefined.\n\n  Example:\n\n  ```text\n  ragnar:s7Xxv7\n  edward:wwjau8\n  ```\n\n  If the Dets storage method is used, the user database is maintained by Dets\n  and must not be edited by hand. Use the API functions in module `mod_auth` to\n  create/edit the user database. This directive is ignored if the Mnesia storage\n  method is used. For security reasons, ensure that `auth_user_file` is stored\n  outside the document tree of the web server. If it is placed in the directory\n  that it protects, clients can download it.\n\n- [](){: #prop_auth_group_file } **`{auth_group_file, path()}`**  \n  Sets the name of a file containing the list of user groups for user\n  authentication. The filename can be either absolute or relative to the\n  `server_root`. If the plain storage method is used, the group file is a plain\n  text file, where each line contains a group name followed by a colon, followed\n  by the members usernames separated by spaces.\n\n  Example:\n\n  ```text\n  group1: bob joe ante\n  ```\n\n  If the Dets storage method is used, the group database is maintained by Dets\n  and must not be edited by hand. Use the API for module `mod_auth` to\n  create/edit the group database. This directive is ignored if the Mnesia\n  storage method is used. For security reasons, ensure that the\n  `auth_group_file` is stored outside the document tree of the web server. If it\n  is placed in the directory that it protects, clients can download it.\n\n- [](){: #prop_auth_name } **`{auth_name, string()}`**  \n  Sets the name of the authorization realm (auth-domain) for a directory. This\n  string informs the client about which username and password to use.\n\n- [](){: #prop_auth_access_passwd } **`{auth_access_password, string()}`**  \n  If set to other than `\"NoPassword\"`, the password is required for all API calls.\n  If the password is set to `\"DummyPassword\"`, the password must be changed before\n  any other API calls. To secure the authenticating data, the password must be\n  changed after the web server is started. Otherwise it is written in clear text\n  in the configuration file.\n\n- [](){: #prop_req_user } **`{require_user, [string()]}`**  \n  Defines users to grant access to a given directory using a secret password.\n\n- [](){: #prop_req_grp } **`{require_group, [string()]}`**  \n  Defines users to grant access to a given directory using a secret password.\n\n[](){: #props_sec }","ref":"httpd.html#module-authentication-properties-requires-mod_auth"},{"type":"behaviour","title":"Security Properties - Requires mod_security - httpd","doc":"[](){: #prop_sec_dir }\n\n```erlang\n{security_directory, {path(), [{property(), term()}]}}\n```\n\n[](){: #props_sdir }\n\nThe properties for the security directories are as follows:\n\n- [](){: #prop_data_file } **`{data_file, path()}`**  \n  Name of the security data file. The filename can either be absolute or\n  relative to the `server_root`. This file is used to store persistent data for\n  module `mod_security`.\n\n- [](){: #prop_max_retries } **`{max_retries, integer()}`**  \n  Specifies the maximum number of attempts to authenticate a user before the\n  user is blocked out. If a user successfully authenticates while blocked, the\n  user receives a 403 (Forbidden) response from the server. If the user makes a\n  failed attempt while blocked, the server returns 401 (Unauthorized), for\n  security reasons. Default is `3`. Can be set to infinity.\n\n- [](){: #prop_block_time } **`{block_time, integer()}`**  \n  Specifies the number of minutes a user is blocked. After this time has passed,\n  the user automatically regains access. Default is `60`.\n\n- [](){: #prop_fail_exp_time } **`{fail_expire_time, integer()}`**  \n  Specifies the number of minutes a failed user authentication is remembered. If\n  a user authenticates after this time has passed, the previous failed\n  authentications are forgotten. Default is `30`.\n\n- [](){: #prop_auth_timeout } **`{auth_timeout, integer()}`**  \n  Specifies the number of seconds a successful user authentication is\n  remembered. After this time has passed, the authentication is no longer\n  reported. Default is `30`.","ref":"httpd.html#module-security-properties-requires-mod_security"},{"type":"behaviour","title":"Web server API data types - httpd","doc":"The Erlang web server API data types are as follows:\n\n```erlang\nModData = #mod{}\n\n-record(mod, {\n    data = [],\n    socket_type = ip_comm,\n    socket,\n    config_db,\n    method,\n    absolute_uri,\n    request_uri,\n    http_version,\n    request_line,\n    parsed_header = [],\n    entity_body,\n    connection\n}).\n```\n\nTo access the record in your callback-module use:\n\n```erlang\n-include_lib(\"inets/include/httpd.hrl\").\n```\n\nThe fields of record `mod` have the following meaning:\n\n- **`data`** - Type `[{InteractionKey,InteractionValue}]` is used to propagate\n  data between modules. Depicted `interaction_data()` in function type\n  declarations.\n\n- **`socket_type`** - `socket_type()` indicates whether it is an IP socket or an\n  `ssl` socket.\n\n- **`socket`** - The socket, in format `ip_comm` or `ssl`, depending on\n  `socket_type`.\n\n- **`config_db`** - The config file directives stored as key-value tuples in an\n  ETS table. Depicted `config_db()` in function type declarations.\n\n- **`method`** - Type `\"GET\" | \"POST\" | \"HEAD\" | \"TRACE\"`, that is, the HTTP\n  method.\n\n- **`absolute_uri`** - If the request is an HTTP/1.1 request, the URI can be in\n  the absolute URI format. In that case, `httpd` saves the absolute URI in this\n  field. An Example of an absolute URI is\n  `\"http://ServerName:Part/cgi-bin/find.pl?person=jocke\"`\n\n- **`request_uri`** - The `Request-URI` as defined in\n  [RFC 1945](http://www.ietf.org/rfc/rfc1945.txt), for example,\n  `\"/cgi-bin/find.pl?person=jocke\"`.\n\n- **`http_version`** - The `HTTP` version of the request, that is, \"HTTP/1.0\",\n  or \"HTTP/1.1\".\n\n- **`request_line`** - The `Request-Line` as defined\n  in[RFC 1945](http://www.ietf.org/rfc/rfc1945.txt), for example,\n  `\"GET /cgi-bin/find.pl?person=jocke HTTP/1.0\"`.\n\n- **`parsed_header`** - Type `[{HeaderKey,HeaderValue}]`. `parsed_header`\n  contains all HTTP header fields from the HTTP request stored in a list as\n  key-value tuples. See [RFC 2616](http://www.ietf.org/rfc/rfc2616.txt) for a\n  listing of all header fields. For example, the date field is stored as\n  `{\"date\",\"Wed, 15 Oct 1997 14:35:17 GMT\"}`. RFC 2616 defines that HTTP is a\n  case-insensitive protocol and the header fields can be in lower case or upper\n  case. `httpd` ensures that all header field names are in lower case.\n\n- **`entity_body`** - The `entity-Body` as defined in\n  [RFC 2616](http://www.ietf.org/rfc/rfc2616.txt), for example, data sent from a\n  CGI script using the POST method.\n\n- **`connection`** - `true | false`. If set to `true`, the connection to the\n  client is a persistent connection and is not closed when the request is\n  served.","ref":"httpd.html#module-web-server-api-data-types"},{"type":"behaviour","title":"See also - httpd","doc":"[RFC 2616](http://www.ietf.org/rfc/rfc2616.txt), `m:inets`, `m:ssl`","ref":"httpd.html#module-see-also"},{"type":"callback","title":"httpd.do/1","doc":"When a valid request reaches `httpd`, it calls [`do/1`](`c:do/1`) in each\nmodule, defined by the configuration option of `Module`. The function can\ngenerate data for other modules or a response that can be sent back to the\nclient.\n\nThe field `data` in `ModData` is a list. This list is the list returned from the\nlast call to [`do/1`](`c:do/1`).\n\n`Body` is the body of the HTTP response that is sent back to the client. An\nappropriate header is appended to the message. `StatusCode` is the status code\nof the response, see [RFC 2616](http://www.ietf.org/rfc/rfc2616.txt) for the\nappropriate values.\n\n`Head` is a key value list of HTTP header fields. The server constructs an HTTP\nheader from this data. See [RFC 2616](http://www.ietf.org/rfc/rfc2616.txt) for\nthe appropriate value for each header field. If the client is an HTTP/1.0\nclient, the server filters the list so that only HTTP/1.0 header fields are sent\nback to the client.\n\nIf `Body` is returned and equal to `{Fun,Arg}`, the web server tries\n[`apply/2`](`apply/2`) on `Fun` with `Arg` as argument. The web server expects\nthat the fun either returns a list `(Body)` that is an HTTP response, or the\natom `sent` if the HTTP response is sent back to the client. If `close` is\nreturned from the fun, something has gone wrong and the server signals this to\nthe client by closing the connection.","ref":"httpd.html#c:do/1"},{"type":"function","title":"httpd.info/1","doc":"Equivalent to  info/2 .","ref":"httpd.html#info/1"},{"type":"function","title":"httpd.info/2","doc":"Fetches information about the HTTP server. When called with only the pid, all\nproperties are fetched. When called with a list of specific properties, they are\nfetched. The available properties are the same as the start options of the\nserver.\n\n> #### Note {: .info }\n>\n> Pid is the pid returned from `inets:start/[2,3]`. Can also be retrieved form\n> `inets:services/0` and `inets:services_info/0`, see `m:inets`.","ref":"httpd.html#info/2"},{"type":"function","title":"httpd.info/3","doc":"Equivalent to  info/4 .","ref":"httpd.html#info/3"},{"type":"function","title":"httpd.info/4","doc":"Fetches information about the HTTP server. When called with only `Address` and\n`Port`, all properties are fetched. When called with a list of specific\nproperties, they are fetched. The available properties are the same as the start\noptions of the server.\n\n> #### Note {: .info }\n>\n> The `Address` must be the IP address and cannot be the hostname.","ref":"httpd.html#info/4"},{"type":"function","title":"httpd.parse_query/1","doc":"[`parse_query/1`](`parse_query/1`) parses incoming data to `erl` and `eval`\nscripts (see `m:mod_esi`) as defined in the standard URL format, that is, '+'\nbecomes 'space' and decoding of hexadecimal characters (`%xx`).","ref":"httpd.html#parse_query/1"},{"type":"type","title":"httpd.property/0","doc":"","ref":"httpd.html#t:property/0"},{"type":"function","title":"httpd.reload_config/2","doc":"Reloads the HTTP server configuration without restarting the server. Incoming\nrequests are answered with a temporary down message during the reload time.\n\n> #### Note {: .info }\n>\n> Available properties are the same as the start options of the server, but the\n> properties `bind_address` and `port` cannot be changed.\n\nIf mode is disturbing, the server is blocked forcefully, all ongoing requests\nterminates, and the reload starts immediately. If mode is non-disturbing, no new\nconnections are accepted, but ongoing requests are allowed to complete before\nthe reload is done.","ref":"httpd.html#reload_config/2"},{"type":"callback","title":"httpd.remove/1","doc":"When `httpd` is shut down, it tries to execute [`remove/1`](`c:remove/1`) in\neach Erlang web server callback module. The programmer can use this function to\nclean up resources created in the store function.","ref":"httpd.html#c:remove/1"},{"type":"type","title":"httpd.socket_type/0","doc":"","ref":"httpd.html#t:socket_type/0"},{"type":"callback","title":"httpd.store/2","doc":"Checks the validity of the configuration options before saving them in the\ninternal database. This function can also have a side effect, that is, setup of\nnecessary extra resources implied by the configuration option. It can also\nresolve possible dependencies among configuration options by changing the value\nof the option. This function only needs clauses for the options implemented by\nthis particular callback module.","ref":"httpd.html#c:store/2"},{"type":"behaviour","title":"httpd_custom_api","doc":"Behaviour with optional callbacks to customize the inets HTTP server.\n\nThe module implementing this behaviour shall be supplied to to the servers\nconfiguration with the option [customize](`m:httpd#prop_customize`)","ref":"httpd_custom_api.html"},{"type":"callback","title":"httpd_custom_api.request_header/1","doc":"Filter and possible alter HTTP request headers before they are processed by the\nserver.","ref":"httpd_custom_api.html#c:request_header/1"},{"type":"callback","title":"httpd_custom_api.response_default_headers/0","doc":"Provide default headers for the HTTP servers responses. Note that this option\nmay override built-in defaults.","ref":"httpd_custom_api.html#c:response_default_headers/0"},{"type":"callback","title":"httpd_custom_api.response_header/1","doc":"Filter and possible alter HTTP response headers before they are sent to the\nclient.","ref":"httpd_custom_api.html#c:response_header/1"},{"type":"module","title":"httpd_socket","doc":"Communication utility functions to be used by the Erlang web server API\nprogrammer.\n\nThis module provides the Erlang web server API module programmer with utility\nfunctions for generic sockets communication. The appropriate communication\nmechanism is transparently used, that is, `ip_comm` or `ssl`.","ref":"httpd_socket.html"},{"type":"module","title":"See also - httpd_socket","doc":"`m:httpd`","ref":"httpd_socket.html#module-see-also"},{"type":"function","title":"httpd_socket.deliver/3","doc":"`deliver/3` sends `Data` over `Socket` using the specified `SocketType`.\n`Socket` and `SocketType` is to be the socket and the `socket_type` form the\n`mod` record as defined in `httpd.hrl`","ref":"httpd_socket.html#deliver/3"},{"type":"function","title":"httpd_socket.peername/2","doc":"`peername/2` returns the `Port` and `IPAddress` of the remote `Socket`.","ref":"httpd_socket.html#peername/2"},{"type":"function","title":"httpd_socket.resolve/0","doc":"`resolve/0` returns the official `HostName` of the current host.","ref":"httpd_socket.html#resolve/0"},{"type":"module","title":"httpd_util","doc":"Miscellaneous utility functions to be used when implementing Erlang web server\nAPI modules.\n\nThis module provides the Erlang web server API module programmer with\nmiscellaneous utility functions.\n\n> #### Note {: .info }\n>\n> Note the module is only recommended for using with httpd - for other cases it\n> should be considered as deprecated.\n\n[](){: #convert_request_date }","ref":"httpd_util.html"},{"type":"module","title":"See also - httpd_util","doc":"`m:httpd`","ref":"httpd_util.html#module-see-also"},{"type":"function","title":"httpd_util.convert_request_date/1","doc":"`convert_request_date/1` converts `DateString` to\nthe Erlang date format. `DateString` must be in one of the three date formats\ndefined in [RFC 2616](http://www.ietf.org/rfc/rfc2616.txt).","ref":"httpd_util.html#convert_request_date/1"},{"type":"function","title":"httpd_util.create_etag/1","doc":"`create_etag/1` calculates the Etag for a file from its size and time for last\nmodification. `FileInfo` is a record defined in `kernel/include/file.hrl`.","ref":"httpd_util.html#create_etag/1"},{"type":"function","title":"httpd_util.day/1","doc":"`day/1` converts the day of the week (`NthDayOfWeek`) from an integer\n(1-7) to an abbreviated string, that is:\n\n1 = \"Mon\", 2 = \"Tue\", ..., 7 = \"Sat\".","ref":"httpd_util.html#day/1"},{"type":"function","title":"httpd_util.lookup/2","doc":"Equivalent to  lookup/3 .","ref":"httpd_util.html#lookup/2"},{"type":"function","title":"httpd_util.lookup/3","doc":"`lookup` extracts `{Key, Value}` tuples from `ETSTable` and returns the `Value`\nassociated with `Key`. If `ETSTable` is of type `bag`, only the first `Value`\nassociated with `Key` is returned. `lookup/2` returns `undefined`\nand `lookup/3` returns `Undefined` if no `Value` is found.","ref":"httpd_util.html#lookup/3"},{"type":"function","title":"httpd_util.lookup_mime/2","doc":"Equivalent to  lookup_mime/3 .","ref":"httpd_util.html#lookup_mime/2"},{"type":"function","title":"httpd_util.lookup_mime/3","doc":"`lookup_mime` returns the MIME type associated with a specific file suffix as\nspecified in the file `mime.types` (located in the config directory).","ref":"httpd_util.html#lookup_mime/3"},{"type":"function","title":"httpd_util.lookup_mime_default/2","doc":"Equivalent to  lookup_mime_default/3 .","ref":"httpd_util.html#lookup_mime_default/2"},{"type":"function","title":"httpd_util.lookup_mime_default/3","doc":"`lookup_mime_default` returns the MIME type associated with a specific file\nsuffix as specified in the `mime.types` file (located in the config directory).\nIf no appropriate association is found, the value of `DefaultType` is returned.","ref":"httpd_util.html#lookup_mime_default/3"},{"type":"function","title":"httpd_util.message/3","doc":"`message/3` returns an informative HTTP 1.1 status string in\nHTML. Each `StatusCode` requires a specific `PhraseArgs`:\n\n- **`301`** - `t:string/0`: A URL pointing at the new document position.\n\n- **`400 | 401 | 500`** - `none` (no `PhraseArgs`).\n\n- **`403 | 404`** - `t:string/0`: A `Request-URI` as described in\n  [RFC 2616](http://www.ietf.org/rfc/rfc2616.txt).\n\n- **`501`** - `{Method, RequestURI, HTTPVersion}`: The HTTP `Method`,\n  `Request-URI`, and `HTTP-Version` as defined in RFC 2616.\n\n- **`504`** - `t:string/0`: A string describing why the service was unavailable.","ref":"httpd_util.html#message/3"},{"type":"function","title":"httpd_util.month/1","doc":"`month/1` converts the month `NthMonth` as an integer (1-12) to an\nabbreviated string, that is:\n\n1 = \"Jan\", 2 = \"Feb\", ..., 12 = \"Dec\".","ref":"httpd_util.html#month/1"},{"type":"function","title":"httpd_util.multi_lookup/2","doc":"`multi_lookup` extracts all `{Key, Value}` tuples from an `ETSTable` and returns\n_all_ `Values` associated with `Key` in a list.","ref":"httpd_util.html#multi_lookup/2"},{"type":"function","title":"httpd_util.reason_phrase/1","doc":"`reason_phrase` returns `Description` of an HTTP 1.1 `StatusCode`, for example,\n200 is \"OK\" and 201 is \"Created\". For more information, see\n[RFC 2616](http://www.ietf.org/rfc/rfc2616.txt).","ref":"httpd_util.html#reason_phrase/1"},{"type":"function","title":"httpd_util.rfc1123_date/0","doc":"Equivalent to  rfc1123_date/1 .","ref":"httpd_util.html#rfc1123_date/0"},{"type":"function","title":"httpd_util.rfc1123_date/1","doc":"`rfc1123_date/0` returns the current date in RFC 1123 format. `rfc_date/1`\nconverts the date in the Erlang format to the RFC 1123 date format.","ref":"httpd_util.html#rfc1123_date/1"},{"type":"function","title":"httpd_util.split/3","doc":"`split/3` splits `String` in `N` chunks using `RegExp`. `split/3` is equivalent\nto `re:split/3` with the exception that `N` defines the maximum number of\nfields in `FieldList`.","ref":"httpd_util.html#split/3"},{"type":"function","title":"httpd_util.split_path/1","doc":"`split_path/1` splits `RequestLine` in a file reference\n(`Path`), and a `QueryString` or a `PathInfo` string as specified in\n[RFC 2616](http://www.ietf.org/rfc/rfc2616.txt). A `QueryString` is isolated\nfrom `Path` with a question mark (`?`) and `PathInfo` with a slash (/). In the\ncase of a `QueryString`, everything before `?` is a `Path` and everything after\n`?` is a `QueryString`. In the case of a `PathInfo`, `RequestLine` is scanned\nfrom left-to-right on the hunt for longest possible `Path` being a file or a\ndirectory. Everything after the longest possible `Path`, isolated with a `/`, is\nregarded as `PathInfo`","ref":"httpd_util.html#split_path/1"},{"type":"function","title":"httpd_util.split_script_path/1","doc":"`split_script_path/1` is equivalent to `split_path/1` with one exception. If\nthe longest possible path is not a regular, accessible, and executable file,\nthen `not_a_script` is returned.","ref":"httpd_util.html#split_script_path/1"},{"type":"module","title":"mod_alias","doc":"URL aliasing.\n\nErlang web server internal API for handling of, for example, interaction data\nexported by module `mod_alias`.","ref":"mod_alias.html"},{"type":"function","title":"mod_alias.default_index/2","doc":"If `Path` is a directory, `default_index/2`, it starts\nsearching for resources or files that are specified in the config directive\n`DirectoryIndex`. If an appropriate resource or file is found, it is appended to\nthe end of `Path` and then returned. `Path` is returned unaltered if no\nappropriate file is found or if `Path` is not a directory. `config_db()` is the\nserver config file in ETS table format as described in\n[Inets User's Guide](http_server.md).","ref":"mod_alias.html#default_index/2"},{"type":"function","title":"mod_alias.path/3","doc":"`path/3` returns the file `Path` in the `RequestURI` (see\n[RFC 1945](https://www.ietf.org/rfc/rfc1945.txt)). If the interaction data\n`{real_name, {Path, AfterPath}}` has been exported by `mod_alias`, `Path` is\nreturned. If no interaction data has been exported, `ServerRoot` is used to\ngenerate a file `Path`. `config_db()` and `interaction_data()` are as defined in\n[Inets User's Guide](http_server.md).","ref":"mod_alias.html#path/3"},{"type":"function","title":"mod_alias.real_name/3","doc":"`real_name/3` traverses `Aliases`, typically extracted from\n`ConfigDB`, and matches each `FakeName` with `RequestURI`. If a match is found,\n`FakeName` is replaced with `RealName` in the match. The resulting path is split\ninto two parts, `ShortPath` and `AfterPath`, as defined in\n`httpd_util:split_path/1`. `Path` is generated from `ShortPath`, that is, the\nresult from `default_index/2` with `ShortPath` as\nan argument. `config_db()` is the server config file in ETS table format as\ndescribed in [Inets User's Guide](http_server.md).","ref":"mod_alias.html#real_name/3"},{"type":"function","title":"mod_alias.real_script_name/3","doc":"`real_script_name/3` traverses `ScriptAliases`,\ntypically extracted from `ConfigDB`, and matches each `FakeName` with\n`RequestURI`. If a match is found, `FakeName` is replaced with `RealName` in the\nmatch. If the resulting match is not an executable script, `not_a_script` is\nreturned. If it is a script, the resulting script path is in two parts,\n`ShortPath` and `AfterPath`, as defined in `httpd_util:split_script_path/1`.\n`config_db()` is the server config file in ETS table format as described in\n[Inets User's Guide](http_server.md).","ref":"mod_alias.html#real_script_name/3"},{"type":"module","title":"mod_auth","doc":"User authentication using text files, Dets, or Mnesia database.\n\nThis module provides for basic user authentication using textual files, Dets\ndatabases, or Mnesia databases.","ref":"mod_auth.html"},{"type":"module","title":"See also - mod_auth","doc":"`m:httpd`, `m:mod_alias`","ref":"mod_auth.html#module-see-also"},{"type":"function","title":"mod_auth.add_group_member/3","doc":"Equivalent to  add_group_member/5 .","ref":"mod_auth.html#add_group_member/3"},{"type":"function","title":"mod_auth.add_group_member/4","doc":"Equivalent to  add_group_member/5 .","ref":"mod_auth.html#add_group_member/4"},{"type":"function","title":"mod_auth.add_group_member/5","doc":"`add_group_member/3`, `add_group_member/4`, and `add_group_member/5` each adds\na user to a group. If the group does not exist, it is created and the user is\nadded to the group. Upon successful operation, this function returns `true`.\nWhen `add_group_members/3` is called, options `Port` and `Dir` are mandatory.","ref":"mod_auth.html#add_group_member/5"},{"type":"function","title":"mod_auth.add_user/2","doc":"Equivalent to  add_user/6 .","ref":"mod_auth.html#add_user/2"},{"type":"function","title":"mod_auth.add_user/5","doc":"Equivalent to  add_user/6 .","ref":"mod_auth.html#add_user/5"},{"type":"function","title":"mod_auth.add_user/6","doc":"add_user(UserName, Password, UserData, Address, Port, Dir) -> true | {error,\nReason}\n\n`add_user/2, add_user/5`, and [`add_user/6`](`add_user/6`) each adds a user to\nthe user database. If the operation is successful, this function returns `true`.\nIf an error occurs, `{error, Reason}` is returned. When\n[`add_user/2`](`add_user/2`) is called, options `Password`, `UserData`, `Port`,\nand `Dir` are mandatory.","ref":"mod_auth.html#add_user/6"},{"type":"function","title":"mod_auth.delete_group/2","doc":"Equivalent to  delete_group/4 .","ref":"mod_auth.html#delete_group/2"},{"type":"function","title":"mod_auth.delete_group/3","doc":"Equivalent to  delete_group(GroupName, undefined, Port, Dir) .","ref":"mod_auth.html#delete_group/3"},{"type":"function","title":"mod_auth.delete_group/4","doc":"`delete_group/2`, `delete_group/3`, and `delete_group/4` each deletes the group\nspecified and returns `true`. If there is an error, `{error, Reason}` is\nreturned. When `delete_group/2` is called, option `Port` and `Dir` are\nmandatory.","ref":"mod_auth.html#delete_group/4"},{"type":"function","title":"mod_auth.delete_group_member/3","doc":"Equivalent to  delete_group_member/5 .","ref":"mod_auth.html#delete_group_member/3"},{"type":"function","title":"mod_auth.delete_group_member/4","doc":"Equivalent to  delete_group_member/5 .","ref":"mod_auth.html#delete_group_member/4"},{"type":"function","title":"mod_auth.delete_group_member/5","doc":"`delete_group_member/3`, `delete_group_member/4`, and `delete_group_member/5`\neach deletes a user from a group. If the group or the user does not exist, this\nfunction returns an error, otherwise `true`. When `delete_group_member/3` is\ncalled, the options `Port` and `Dir` are mandatory.","ref":"mod_auth.html#delete_group_member/5"},{"type":"function","title":"mod_auth.delete_user/2","doc":"Equivalent to  delete_user/4 .","ref":"mod_auth.html#delete_user/2"},{"type":"function","title":"mod_auth.delete_user/3","doc":"Equivalent to  delete_user/4 .","ref":"mod_auth.html#delete_user/3"},{"type":"function","title":"mod_auth.delete_user/4","doc":"`delete_user/2`, `delete_user/3`, and `delete_user/4` each\ndeletes a user from the user database. If the operation is successful, this\nfunction returns `true`. If an error occurs, `{error, Reason}` is returned. When\n`delete_user/2` is called, options `Port` and `Dir` are\nmandatory.","ref":"mod_auth.html#delete_user/4"},{"type":"function","title":"mod_auth.get_user/2","doc":"Equivalent to  get_user/4 .","ref":"mod_auth.html#get_user/2"},{"type":"function","title":"mod_auth.get_user/3","doc":"Equivalent to  get_user/4 .","ref":"mod_auth.html#get_user/3"},{"type":"function","title":"mod_auth.get_user/4","doc":"`get_user/2`, `get_user/3`, and `get_user/4` each returns an `t:httpd_user/0`\nrecord containing the userdata for a specific user. If the user cannot be\nfound, `{error, Reason}` is returned. When `get_user/2` is called, options\n`Port` and `Dir` are mandatory.","ref":"mod_auth.html#get_user/4"},{"type":"type","title":"mod_auth.httpd_group/0","doc":"","ref":"mod_auth.html#t:httpd_group/0"},{"type":"type","title":"mod_auth.httpd_user/0","doc":"","ref":"mod_auth.html#t:httpd_user/0"},{"type":"function","title":"mod_auth.list_group_members/2","doc":"Equivalent to  list_group_members/4 .","ref":"mod_auth.html#list_group_members/2"},{"type":"function","title":"mod_auth.list_group_members/3","doc":"Equivalent to  list_group_members/4 .","ref":"mod_auth.html#list_group_members/3"},{"type":"function","title":"mod_auth.list_group_members/4","doc":"`list_group_members/2`, `list_group_members/3`, and `list_group_members/4` each\nlists the members of a specified group. If the group does not exist or there is\nan error, `{error, Reason}` is returned. When `list_group_members/2` is called,\noptions `Port` and `Dir` are mandatory.","ref":"mod_auth.html#list_group_members/4"},{"type":"function","title":"mod_auth.list_groups/1","doc":"Equivalent to  list_groups/3 .","ref":"mod_auth.html#list_groups/1"},{"type":"function","title":"mod_auth.list_groups/2","doc":"Equivalent to  list_groups/3 .","ref":"mod_auth.html#list_groups/2"},{"type":"function","title":"mod_auth.list_groups/3","doc":"`list_groups/1`, `list_groups/2`, and `list_groups/3` each lists all the groups\navailable. If there is an error, `{error, Reason}` is returned. When\n`list_groups/1` is called, options `Port` and `Dir` are mandatory.","ref":"mod_auth.html#list_groups/3"},{"type":"function","title":"mod_auth.list_users/1","doc":"Equivalent to  list_users/3 .","ref":"mod_auth.html#list_users/1"},{"type":"function","title":"mod_auth.list_users/2","doc":"Equivalent to  list_users/3 .","ref":"mod_auth.html#list_users/2"},{"type":"function","title":"mod_auth.list_users/3","doc":"`list_users/1`, `list_users/2`, and `list_users/3` each returns a list of users\nin the user database for a specific `Port/Dir`. When `list_users/1` is called,\noptions `Port` and `Dir` are mandatory.","ref":"mod_auth.html#list_users/3"},{"type":"function","title":"mod_auth.update_password/5","doc":"Equivalent to  update_password/6 .","ref":"mod_auth.html#update_password/5"},{"type":"function","title":"mod_auth.update_password/6","doc":"`update_password/5` and `update_password/6` each updates `AuthAccessPassword`\nfor the specified directory. If `NewPassword` is equal to \"NoPassword\", no\npassword is required to change authorisation data. If `NewPassword` is equal to\n\"DummyPassword\", no changes can be done without changing the password first.","ref":"mod_auth.html#update_password/6"},{"type":"behaviour","title":"mod_esi","doc":"Erlang Server Interface\n\nThis module defines the Erlang Server Interface (ESI) API. It is a more\nefficient way of writing Erlang scripts for your `Inets` web server than writing\nthem as common CGI scripts.","ref":"mod_esi.html"},{"type":"function","title":"mod_esi.deliver/2","doc":"Sends data from an ESI script back to the client.\n\nThis function is _only_ intended to be used from functions called by the ESI\ninterface to deliver parts of the content to the user.\n\n> #### Note {: .info }\n>\n> If any HTTP header fields are added by the script, they must be in the first\n> call to [`deliver/2`](`deliver/2`), and the data in the call must be a string.\n> Calls after the headers are complete can contain binary data to reduce copying\n> overhead. Do not assume anything about the data type of `SessionID`.\n> `SessionID` must be the value given as input to the ESI callback function that\n> you implemented.","ref":"mod_esi.html#deliver/2"},{"type":"type","title":"mod_esi.env/0","doc":"Environment data associated with a request.","ref":"mod_esi.html#t:env/0"},{"type":"type","title":"Possible values - mod_esi.env/0","doc":"- **`{server_software, string()}`** - Indicates the inets version.\n\n- **`{server_name, string()}`** - The local hostname.\n\n- **`{gateway_interface, string()}`** - Legacy string used in CGI, just\nignore.\n\n- **`{server_protocol, string()}`** - HTTP version, currently \"HTTP/1.1\"\n\n- **`{server_port, integer()}`** - Servers port number.\n\n- **`{request_method, \"GET\" | \"PUT\" | \"DELETE\" | \"POST\" | \"PATCH\"}`** - HTTP\nrequest method.\n\n- **`{remote_adress, inet:ip_address()}`** - The clients ip address.\n\n- **`{peer_cert, undefined | no_peercert | DER:binary()}`** - For TLS\nconnections where client certificates are used this will be an ASN.1\nDER-encoded X509-certificate as an Erlang binary. If client certificates are\nnot used the value will be `no_peercert`, and if TLS is not used (HTTP or\nconnection is lost due to network failure) the value will be `undefined`.\n\n- **`{script_name, string()}`** - Request URI\n\n- **`{http_LowerCaseHTTPHeaderName, string()}`** - example:\n`{http_content_type, \"text/html\"}`","ref":"mod_esi.html#t:env/0-possible-values"},{"type":"callback","title":"mod_esi.Function/3","doc":"Called by `mod_esi` in response to requests.\n\n`Module` must be found in the code path and export `Function` with an arity of\nthree. An `erl_script_alias` must also be set up in the configuration file for\nthe web server, see [the ESI properties documentation](`m:httpd#prop_esi_alias`).\n\nThe `Module` and `Function` that are called depend on the URL. See [the ESI\nintroductory documentation](http_server.md#esi) for more details.\n\n`mod_esi:deliver/2` shall be used to generate the response to the client, and\n`SessionID` shall be passed as the first argument.","ref":"mod_esi.html#c:Function/3"},{"type":"callback","title":"Chunking - mod_esi.Function/3","doc":"This function may be called several times to chunk the response data. Notice\nthat the first chunk of data sent to the client must at least contain all HTTP\nheader fields that the response will generate. If the first chunk does not\ncontain the _end of HTTP header_, that is, `\"\\r\\n\\r\\n\"`, the server assumes\nthat no HTTP header fields will be generated. This behaviour depends on the\n`httpd` configuration, see below.","ref":"mod_esi.html#c:Function/3-chunking"},{"type":"callback","title":"Parameters - mod_esi.Function/3","doc":"- `SessionID`: request identifier.\n\n  Pass this to `mod_esi:deliver/2` when generating a response.\n\n- `Env`: environment data of the request, see `t:env/0`.\n\n- `Input`: query data of a GET request or the body of a PUT or POST request.\n\n  The default behavior (legacy reasons) for delivering the body, is that the\n  whole body is gathered and converted to a string. But if the httpd config\n  parameter [`max_client_body_chunk`](`m:httpd#max_client_body_chunk`) is set,\n  the body will be delivered as binary chunks instead. The maximum size of the\n  chunks is either [`max_client_body_chunk`](`m:httpd#max_client_body_chunk`) or\n  decided by the client if it uses HTTP chunked encoding to send the body.\n\n  When using the chunking mechanism, this callback must return `{continue,\n  State::term()}` for all calls where `Input` is `{first, Data::binary()}` or\n  `{continue, Data::binary(), State::term()}`. When `Input` is `{last,\n  Data::binary(), State::term()}` the return value will be ignored.\n\n  The input `State` is the last returned `State`, in it the callback can include\n  any data that it needs to keep track of when handling the chunks.\n\n> #### Note {: .info }\n>\n> Note that if the body is small all data may be delivered in only one chunk and\n> then the callback will be called with `{last, Data::binary(), undefined}`\n> without getting called with `{first, Data::binary()}`.","ref":"mod_esi.html#c:Function/3-parameters"},{"type":"callback","title":"Setting a response status - mod_esi.Function/3","doc":"To set the response status code, the special `status` response header can be\nsent. For instance, to acknowledge creation of a resource and send an empty\nJSON response body, one could pass the following:\n\n```erlang\n\"status: 201 Created\\r\\ncontent-type: application/json\\r\\n\\r\\n{}\"\n```","ref":"mod_esi.html#c:Function/3-setting-a-response-status"},{"type":"opaque","title":"mod_esi.session_id/0","doc":"Identifies the requesting client.","ref":"mod_esi.html#t:session_id/0"},{"type":"behaviour","title":"mod_security","doc":"Security Audit and Trailing Functionality","ref":"mod_security.html"},{"type":"function","title":"mod_security.block_user/4","doc":"Equivalent to  block_user/5 .","ref":"mod_security.html#block_user/4"},{"type":"function","title":"mod_security.block_user/5","doc":"[`block_user/4`](`block_user/4`) and [`block_user/5`](`block_user/5`) each\nblocks the user `User` from directory `Dir` for a specified amount of time.","ref":"mod_security.html#block_user/5"},{"type":"callback","title":"mod_security.event/4","doc":"","ref":"mod_security.html#c:event/4"},{"type":"callback","title":"mod_security.event/5","doc":"[`event/4`](`c:event/4`) or [`event/5`](`c:event/5`) is called whenever an event\noccurs in the `mod_security` Erlang web server API module.\n([`event/4`](`c:event/4`) is called if `Address` is undefined, otherwise\n[`event/5`](`c:event/5`). Argument `What` specifies the type of event that has\noccurred and is one of the following reasons:\n\n- **`auth_fail`** - A failed user authentication.\n\n- **`user_block`** - A user is being blocked from access.\n\n- **`user_unblock`** - A user is being removed from the block list.\n\n> #### Note {: .info }\n>\n> The event `user_unblock` is not triggered when a user is removed from the\n> block list explicitly using the `unblock_user` function.","ref":"mod_security.html#c:event/5"},{"type":"function","title":"mod_security.list_auth_users/1","doc":"Equivalent to  list_auth_users/3 .","ref":"mod_security.html#list_auth_users/1"},{"type":"function","title":"mod_security.list_auth_users/2","doc":"Equivalent to  list_auth_users/3 .","ref":"mod_security.html#list_auth_users/2"},{"type":"function","title":"mod_security.list_auth_users/3","doc":"[`list_auth_users/1`](`list_auth_users/1`),\n[`list_auth_users/2`](`list_auth_users/2`), and\n[`list_auth_users/3`](`list_auth_users/3`) each returns a list of users that are\ncurrently authenticated. Authentications are stored for `SecurityAuthTimeout`\nseconds, and then discarded.","ref":"mod_security.html#list_auth_users/3"},{"type":"function","title":"mod_security.list_blocked_users/1","doc":"Equivalent to  list_blocked_users/3 .","ref":"mod_security.html#list_blocked_users/1"},{"type":"function","title":"mod_security.list_blocked_users/2","doc":"Equivalent to  list_blocked_users/3 .","ref":"mod_security.html#list_blocked_users/2"},{"type":"function","title":"mod_security.list_blocked_users/3","doc":"[`list_blocked_users/1`](`list_blocked_users/1`),\n[`list_blocked_users/2`](`list_blocked_users/2`), and\n[`list_blocked_users/3`](`list_blocked_users/3`) each returns a list of users\nthat are currently blocked from access.","ref":"mod_security.html#list_blocked_users/3"},{"type":"function","title":"mod_security.unblock_user/2","doc":"Equivalent to  unblock_user/4 .","ref":"mod_security.html#unblock_user/2"},{"type":"function","title":"mod_security.unblock_user/3","doc":"Equivalent to  unblock_user/4 .","ref":"mod_security.html#unblock_user/3"},{"type":"function","title":"mod_security.unblock_user/4","doc":"[`unblock_user/2`](`unblock_user/2`), [`unblock_user/3`](`unblock_user/3`), and\n[`unblock_user/4`](`unblock_user/4`) each removes the user `User` from the list\nof blocked users for `Port` (and `Dir`).","ref":"mod_security.html#unblock_user/4"},{"type":"module","title":"http_uri","doc":"Old URI utility module, use uri_string instead\n\nThis module is deprecated since OTP 23. Use the module `m:uri_string` to\nproperly handle URIs, this is the recommended module since OTP 21.","ref":"http_uri.html"},{"type":"module","title":"Data types - http_uri","doc":"Type definitions that are related to URI:\n\n- **`uri_part() = [byte()] | binary()`** - Syntax according to the URI\n  definition in RFC 3986, for example, \"http://www.erlang.org/\"\n\nFor more information about URI, see\n[RFC 3986](http://www.ietf.org/rfc/rfc3986.txt).","ref":"http_uri.html#module-data-types"},{"type":"function","title":"http_uri.decode/1","doc":"Decodes a possibly percent encoded URI part\n\n> #### Warning {: .warning }\n>\n> Use `uri_string:unquote/1` instead","ref":"http_uri.html#decode/1"},{"type":"function","title":"http_uri.encode/1","doc":"Performs percent encoding.\n\n> #### Warning {: .warning }\n>\n> Use `uri_string:quote/1` instead","ref":"http_uri.html#encode/1"},{"type":"extras","title":"Inets Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Inets Release Notes","ref":"notes.html"},{"type":"extras","title":"Inets 9.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Replaced calls to deprecated `crypto:start()` with `application:start(crypto)`.\n\n  Own Id: OTP-19485 Aux Id: [PR-8592]\n\n- Enhance specs of timeout for improving documentation and dialyzer analysis.\n\n  Own Id: OTP-19604 Aux Id: [PR-9574]\n\n[PR-8592]: https://github.com/erlang/otp/pull/8592\n[PR-9574]: https://github.com/erlang/otp/pull/9574","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Enhanced http client documentation.\n\n  Own Id: OTP-19520 Aux Id: [PR-9516]\n\n- Enhance made to mod_esi documentation\n\n  Own Id: OTP-19521 Aux Id: [PR-9472]\n\n- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n- Inets Makefiles now create and use dependencies files for .erl files\n\n  Own Id: OTP-19624 Aux Id: [PR-9101]\n\n[PR-9516]: https://github.com/erlang/otp/pull/9516\n[PR-9472]: https://github.com/erlang/otp/pull/9472\n[PR-9670]: https://github.com/erlang/otp/pull/9670\n[PR-9101]: https://github.com/erlang/otp/pull/9101","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Inets 9.3.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Improved robustness of httpd startup procedure.\n\n  Own Id: OTP-19486 Aux Id: ERIERL-1190, [PR-9408]\n\n[PR-9408]: https://github.com/erlang/otp/pull/9408","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"Inets 9.3.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- The HTTP client now correctly takes into account the `full_result` option when returning an asynchronous request.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19158\n\n- A synchronous httpc:request now timeouts after the `Timeout` specified in `HttpOption {timeout, Timeout}`.\n\n  Own Id: OTP-19221 Aux Id: ERIERL-1091, [PR-8788], [PR-8801]\n\n- Fixed a bug where calling httpc:set_options/2 when one of keys: *ipfamily* or *unix_socket*, was not present, would cause the other value to get overriden by the default value. The validation of these options was also improved.\n\n  Own Id: OTP-19379 Aux Id: [PR-8878], [GH-8829]\n\n[PR-8788]: https://github.com/erlang/otp/pull/8788\n[PR-8801]: https://github.com/erlang/otp/pull/8801\n[PR-8878]: https://github.com/erlang/otp/pull/8878\n[GH-8829]: https://github.com/erlang/otp/issues/8829","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- The variable `Env` in the `mod_esi` callback will now have an additional property `{connect_addr, Addr}` indicating on which address the server received a connection.\n\n  Own Id: OTP-19377 Aux Id: ERIERL-1152, [PR-9127]\n\n[PR-9127]: https://github.com/erlang/otp/pull/9127","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"Inets 9.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-3"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- The documentation for the `m:httpd` module has been improved, along with correction of headings and types.\n\n  Own Id: OTP-19171 Aux Id: [PR-8578]\n\n- Userinfo is now properly percent-decoded before usage in headers.\n\n  Own Id: OTP-19172 Aux Id: [PR-8575]\n\n[PR-8578]: https://github.com/erlang/otp/pull/8578\n[PR-8575]: https://github.com/erlang/otp/pull/8575","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"Inets 9.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Introduced a default value for httpd_server name configuration to improve ease of use.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-18641 Aux Id: [PR-7316]\n\n- The `httpd` module has been extended with an API for simple serving directory content over HTTP. With this change, the current working directory can be served like this:\n  \n  ```text\n  erl -S httpd\n  ```\n  \n  An arbitrary directory can be served like this:\n  \n  ```text\n  erl -S httpd serve path/to/dir\n  ```\n\n  Own Id: OTP-18727 Aux Id: [PR-7299]\n\n- Added `-callback` attributes to `m:httpd`, `m:mod_esi`, and `m:mod_security`.\n\n  Own Id: OTP-18786 Aux Id: [PR-7700]\n\n- Inets now uses a relative redirect with an absolute path to prevent whoever is running Inets from having to configure the `ServerName` to match the network-reachable host name of the server.\n\n  Own Id: OTP-18809 Aux Id: [GH-7617], [PR-7678]\n\n- `inets` processes now use `proc_lib:set_label/1` to improve observeability.\n\n  Own Id: OTP-18927 Aux Id: [PR-8029]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- The implementations of `http_uri:encode/1` and `http_uri:decode/1` are now replaced with their equivalent, but bug free versions from module `m:uri_string`, namely `uri_string:quote/1` and `uri_string:unquote/1`.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19022\n\n- With this change, the API specs are updated.\n\n  Own Id: OTP-19033\n\n[PR-7316]: https://github.com/erlang/otp/pull/7316\n[PR-7299]: https://github.com/erlang/otp/pull/7299\n[PR-7700]: https://github.com/erlang/otp/pull/7700\n[GH-7617]: https://github.com/erlang/otp/issues/7617\n[PR-7678]: https://github.com/erlang/otp/pull/7678\n[PR-8029]: https://github.com/erlang/otp/pull/8029\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"Inets 9.1.0.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-1-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"* Fixed a bug where calling httpc:set_options/2 when one of keys: *ipfamily* or *unix_socket*, was not present, would cause the other value to get overriden by the default value. The validation of these options was also improved.\n\n  Own Id: OTP-19379 Aux Id: PR-8878, GH-8829","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"Inets 9.1.0.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-1-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"* With this change, HTTP client, when returning an asynchronous request, now correctly takes into account \\`OptionRequest - full_result\\`\n\n  \\*** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19158\n* With this change, synchronous httpc:request now timeouts after \\`Timeout\\` specified in \\`HttpOption \\{timeout, Timeout\\}\\`\n\n  Own Id: OTP-19221 Aux Id: ERIERL-1091, PR-8788, PR-8801","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"Inets 9.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Replaced unintentional Erlang Public License 1.1 headers in some files with\n  the intended Apache License 2.0 header.\n\n  Own Id: OTP-18815 Aux Id: PR-7780\n\n- Correct IP protocol handling so that redirects always uses correct IP-family\n  options and not fails.\n\n  Own Id: OTP-18855","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- `inets` app starts `ssl` by default\n\n  Own Id: OTP-18735 Aux Id: PR-7596, GH-7580\n\n- Avoid httpd returning 500 internal server error when unable to open a file.\n  404 or 503 will be returned instead.\n\n  Own Id: OTP-18882\n\n- Properly handle documented option mime_type, for backwards compatibility\n  fallback to undocumented option default_type if mime_type is not set.\n\n  Own Id: OTP-18891 Aux Id: PR-7843, GH-7827","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"Inets 9.0.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- With this change, re_write httpd works as expected and does not return error.\n\n  Own Id: OTP-18582 Aux Id: GH-6074,PR-6892\n\n- Fixed a bug so `httpd` does not crash when stopped at the wrong time during\n  TLS connection negotiation, or any other theoretically as slow connection\n  setup.\n\n  Own Id: OTP-18688 Aux Id: ERIERL-962\n\n- Enhance error handling and avoid that the HTTP client hangs on headers\n  provided on the wrong format.\n\n  Own Id: OTP-18694 Aux Id: GH-7482\n\n- With this change, error report generated by httpd during connection setup\n  contains socket type information.\n\n  Own Id: OTP-18704 Aux Id: ERIERL-962, PR-7513, OTP-18688\n\n- Stop and restart of the `httpd` server in the Inets application has been\n  refactored to a more synchronous and OTP supervisor friendly approach.\n\n  This should increase stability and for example avoid a supervisor report from\n  `httpd_connection_sup` about killed child process(es) in some cases when\n  stopping or restarting `httpd`.\n\n  Own Id: OTP-18708 Aux Id: ERIERL-962, OTP-18688","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"Inets 9.0.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Do not make the default ssl options by calling\n  `httpc:ssl_verify_host_options(true)` if ssl options are supplied by the user.\n\n  Own Id: OTP-18604 Aux Id: PR-7306 GH-7303","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"Inets 9.0 - Inets Release Notes","doc":"","ref":"notes.html#inets-9-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Correct timing related pipelining/keepalive queue bug, that could result in\n  unexpected \"socket_remotly_closed\" errors.\n\n  Own Id: OTP-18476 Aux Id: GH-6380","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- By default ssl connections will use options from `ssl_default_options(true)`\n\n  Own Id: OTP-18167\n\n- Runtime dependencies have been updated.\n\n  Own Id: OTP-18350\n\n- Deprecates `dbg:stop_clear/0` because it is simply a function alias to\n  `dbg:stop/0`\n\n  Own Id: OTP-18478 Aux Id: GH-6903\n\n- The implementation has been fixed to use `proc_lib:init_fail/2,3` where\n  appropriate, instead of `proc_lib:init_ack/1,2`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18490 Aux Id: OTP-18471, GH-6339, PR-6843\n\n- IP display string will now always be in lower case, effects ipv6 addresses.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18530\n\n- Removed deprecated functions\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18536\n\n- Update the code in the inets example directory to reflect the latest\n  implementation\n\n  Own Id: OTP-18544 Aux Id: GH-5276","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"Inets 8.3.1.5 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-3-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"* Fixed a bug where calling httpc:set_options/2 when one of keys: *ipfamily* or *unix_socket*, was not present, would cause the other value to get overriden by the default value. The validation of these options was also improved.\n\n  Own Id: OTP-19379 Aux Id: PR-8878, GH-8829","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"Inets 8.3.1.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-3-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"* With this change, HTTP client, when returning an asynchronous request, now correctly takes into account \\`OptionRequest - full_result\\`\n\n  \\*** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19158\n* With this change, synchronous httpc:request now timeouts after \\`Timeout\\` specified in \\`HttpOption \\{timeout, Timeout\\}\\`\n\n  Own Id: OTP-19221 Aux Id: ERIERL-1091, PR-8788, PR-8801","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"Inets 8.3.1.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-3-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"* Fixed runtime dependencies.\n\n  Own Id: OTP-19064","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"Inets 8.3.1.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-3-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- With this change, error report generated by httpd during connection setup\n  contains socket type information.\n\n  Own Id: OTP-18704 Aux Id: ERIERL-962, PR-7513, OTP-18688\n\n- Stop and restart of the `httpd` server in the Inets application has been\n  refactored to a more synchronous and OTP supervisor friendly approach.\n\n  This should increase stability and for example avoid a supervisor report from\n  `httpd_connection_sup` about killed child process(es) in some cases when\n  stopping or restarting `httpd`.\n\n  Own Id: OTP-18708 Aux Id: ERIERL-962, OTP-18688","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"Inets 8.3.1.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fixed a bug so `httpd` does not crash when stopped at the wrong time during\n  TLS connection negotiation, or any other theoretically as slow connection\n  setup.\n\n  Own Id: OTP-18688 Aux Id: ERIERL-962","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Inets 8.3.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Correct timing related pipelining/keepalive queue bug, that could result in\n  unexpected \"socket_remotly_closed\" errors.\n\n  Own Id: OTP-18509 Aux Id: OTP-18476\n\n- With this change, upon remote socket closure current request is added to a\n  retried queue (either pipeline or keep_alive, but not both).\n\n  Own Id: OTP-18545 Aux Id: OTP-18509, ERIERL-937, ERIERL-928","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"Inets 8.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- With this change, handling of URI to a folder, with missing trailing / and a\n  query component present is fixed.\n\n  Own Id: OTP-18472 Aux Id: DAFH-1592","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Adds more type information to the `inets` app, thus improving the errors that\n  static analysis tools can detect.\n\n  The addition of type information to records and the updates to function heads\n  help static analysis tools to understand that some values in the records\n  cannot be `'undefined'`, thus making static tools to type check correctly more\n  modules in the `inets` app\n\n  Own Id: OTP-18390 Aux Id: PR-6661\n\n- Replace size/1 with either tuple_size/1 or byte_size/1\n\n  The [`size/1`](`size/1`) BIF is not optimized by the JIT, and its use can\n  result in worse types for Dialyzer.\n\n  When one knows that the value being tested must be a tuple,\n  [`tuple_size/1`](`tuple_size/1`) should always be preferred.\n\n  When one knows that the value being tested must be a binary,\n  [`byte_size/1`](`byte_size/1`) should be preferred. However,\n  [`byte_size/1`](`byte_size/1`) also accepts a bitstring (rounding up size to a\n  whole number of bytes), so one must make sure that the call to `byte_size/` is\n  preceded by a call to [`is_binary/1`](`is_binary/1`) to ensure that bitstrings\n  are rejected. Note that the compiler removes redundant calls to\n  [`is_binary/1`](`is_binary/1`), so if one is not sure whether previous code\n  had made sure that the argument is a binary, it does not harm to add an\n  [`is_binary/1`](`is_binary/1`) test immediately before the call to\n  [`byte_size/1`](`byte_size/1`).\n\n  Own Id: OTP-18432 Aux Id:\n  GH-6672,PR-6793,PR-6784,PR-6787,PR-6785,PR-6682,PR-6800,PR-6797,PR-6798,PR-6799,PR-6796,PR-6813,PR-6671,PR-6673,PR-6684,PR-6694,GH-6677,PR-6696,PR-6670,PR-6674","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"Inets 8.2.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Ensure graceful shutdown\n\n  Own Id: OTP-18461 Aux Id: ERIERL-890\n\n- Return type of the type specification for function\n  `httpc:cookie_header/{1,2,3}` has been fixed from\n  `-spec cookie_header(url()) -> [{ field(), value() }] | {error, Reason}` to\n  `-spec cookie_header(url()) -> { field(), value() } | {error, Reason}`\n\n  Own Id: OTP-18462 Aux Id: GH-6846","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"Inets 8.2.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- fixes a missing case of the type specification for httpd:info/2/3/4\n\n  Own Id: OTP-18362 Aux Id: GH-6558, ERIERL-895","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Inets 8.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- This change allows body requests to `httpc:request/5` be an `t:iolist/0`\n\n  Own Id: OTP-18250\n\n- addition of type specs in `httpc.erl`\n\n  Own Id: OTP-18251 Aux Id: GH-6245\n\n- httpc: Add support for HTTP 308 status code\n\n  Own Id: OTP-18280 Aux Id: GH-6290, PR-6291","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"Inets 8.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add `httpc:ssl_verify_host_options/1` to help setting default ssl options for\n  the https client.\n\n  Own Id: OTP-18118\n\n- This change fixes dialyzer warnings generated for inets/httpd examples\n  (includes needed adjustment of spec for ssh_sftp module).\n\n  Own Id: OTP-18178 Aux Id: ERIERL-833, ERIERL-834, ERIERL-835\n\n- Remove documentation of no longer supported callback.\n\n  Own Id: OTP-18193 Aux Id: GH-6122","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"Inets 8.0 - Inets Release Notes","doc":"","ref":"notes.html#inets-8-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Adjust uri_string:normalize behavior for URIs with undefined port (URI string\n  with a port colon but no port value or URI map with port => undefined).\n\n  Remove redundant normalization from http_request module.\n\n  Before this change, normalize would not remove port subcomponent in such cases\n  and could for example return \"http://localhost:\" URI.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17627\n\n- Fixed typo in Reason term returned from httpc_handler:handle_http_body.\n\n  After this change, could_not_establish_ssl_tunnel atom is returned within\n  Reason term.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17889\n\n- With this change, inet6fb4 option is documented for inets/httpc. Option can be\n  used when IP family needs to be discovered by a connection attempt.\n\n  Own Id: OTP-18063 Aux Id: ERIERL-798","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- This change removes deprecated functions: http_uri:parse/1, http_uri:parse/2\n  and http_uri:scheme_defaults/0.\n\n  This change delays until OTP-26 removal of deprecated functions:\n  http_uri:encode/1 and http_uri:decode/1.\n\n  This change marks httpd_util:decode_hex/1 and httpd_util:encode_hex/1 as\n  deprecated.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17866\n\n- After this change, connect_timeout value is re-used when upgrading TCP\n  connection to TLS over a proxy.\n\n  Own Id: OTP-17997 Aux Id: GH-5782\n\n- Remove reference to unsupported Apache-like config file from httpd manual.\n\n  Own Id: OTP-18088 Aux Id: GH-5276","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"Inets 7.5.3.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-5-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- With this change, upon remote socket closure current request is added to a\n  retried queue (either pipeline or keep_alive, but not both).\n\n  Own Id: OTP-18545 Aux Id: OTP-18509, ERIERL-937, ERIERL-928","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Inets 7.5.3.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-5-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Correct timing related pipelining/keepalive queue bug, that could result in\n  unexpected \"socket_remotly_closed\" errors.\n\n  Own Id: OTP-18509 Aux Id: OTP-18476","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"Inets 7.5.3.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-5-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- With this change, handling of URI to a folder, with missing trailing / and a\n  query component present is fixed.\n\n  Own Id: OTP-18472 Aux Id: DAFH-1592","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"Inets 7.5.3.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-5-3-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Remove documentation of no longer supported callback.\n\n  Own Id: OTP-18193 Aux Id: GH-6122","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"Inets 7.5.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix handling of erl_script_script option in httpd when atom 'all' is used as\n  AllowedModule.\n\n  Own Id: OTP-18069 Aux Id: ERIERL-805","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Inets 7.5.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- The compilation time is no longer recorded in BEAM files. There remained\n  several undocumented functions that attempted to retrieve compilation times.\n  Those have now been removed.\n\n  Own Id: OTP-17962","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Documentation fix for inets:services_info/0, which now describes that Info\n  might be a Reason term() in case when \\{error, Reason\\} is returned as service\n  info.\n\n  Own Id: OTP-17931 Aux Id: ERIERL-761","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"Inets 7.5.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Avoid intermediate ungraceful shutdown of the HTTP server.\n\n  Own Id: OTP-17922 Aux Id: ERIERL-743","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"Inets 7.5 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Correct HTTP server URI handling to fully rely on uri_string. The server could\n  mistreat some URI paths that in turn could result in incorrect responses being\n  generated.\n\n  Own Id: OTP-17818 Aux Id: ERIERL-731","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Extend header values to httpc:request/5 to allow binary() as well. Make error\n  detection of invalid arguments to httpc:request/5 be more precise so an error\n  is returned in more cases instead of causing a hang or function_clause. Be\n  more precise in documentation regarding the types of arguments being accepted.\n\n  Own Id: OTP-17579 Aux Id: GH-5074","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"Inets 7.4.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Before this change hrefs in dir listing page contained percentage encoded\n  forward slashes which did not work properly with httpd.\n\n  Own Id: OTP-17383 Aux Id: GH-4677\n\n- Restored HTTP headers handling in inets/mod_esi.\n\n  Own Id: OTP-17600\n\n- inets/httpd dir listing icons and other improvements\n\n  Own Id: OTP-17624 Aux Id: GH-4855","ref":"notes.html#fixed-bugs-and-malfunctions-26"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- httpc: Improve performance by removing redundant URI handling\n\n  Own Id: OTP-17460","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"Inets 7.4.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Improved user input handling in inets/mod_esi preventing unnecessary atom\n  creation.\n\n  Own Id: OTP-17490","ref":"notes.html#fixed-bugs-and-malfunctions-27"},{"type":"extras","title":"Inets 7.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-4"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Drop all support for ftp and tftp in inets code.\n\n  Own Id: OTP-16722\n\n- Deprecate following functions in `httpd_util` module: `flatlength/1`,\n  `lhexlist_to_integer/1`, `integer_to_hexlist/1`, `strip/1`, and `suffix/1`.\n\n  Own Id: OTP-16723\n\n- Remove support of HTTP 0.9 in httpd.\n\n  Own Id: OTP-16724\n\n- Remove support of HTTP 0.9 in httpc.\n\n  Own Id: OTP-16725\n\n- Fixed warnings in code matching on underscore prefixed variables.\n\n  Own Id: OTP-17385 Aux Id: OTP-17123","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"Inets 7.3.2.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-3-2-3"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Remove documentation of no longer supported callback.\n\n  Own Id: OTP-18193 Aux Id: GH-6122","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"Inets 7.3.2.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-3-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Restored HTTP headers handling in inets/mod_esi.\n\n  Own Id: OTP-17600","ref":"notes.html#fixed-bugs-and-malfunctions-28"},{"type":"extras","title":"Inets 7.3.2.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-3-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Improved user input handling in inets/mod_esi preventing unnecessary atom\n  creation.\n\n  Own Id: OTP-17490","ref":"notes.html#fixed-bugs-and-malfunctions-29"},{"type":"extras","title":"Inets 7.3.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Solves CVE-2021-27563, that is make sure no form of relative path can be used\n  to go outside webservers directory.\n\n  Own Id: OTP-17205 Aux Id: ERIERL-608\n\n- Make sure HEAD requests rejects directory links\n\n  Own Id: OTP-17220","ref":"notes.html#fixed-bugs-and-malfunctions-30"},{"type":"extras","title":"Inets 7.3.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix an issue about HTML-escaped filename in inets.\n\n  Own Id: OTP-16873 Aux Id: ERL-330","ref":"notes.html#fixed-bugs-and-malfunctions-31"},{"type":"extras","title":"Inets 7.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Clarify the handling of percent encoded characters in http client.\n\n  Own Id: OTP-16650 Aux Id: ERL-1215, PR-2629\n\n- fix crash for undefined port in uri.\n\n  Own Id: OTP-16663 Aux Id: ERL-1241\n\n- Avoid timing issue when setting active once on a socket that is being closed\n  by the peer.\n\n  Own Id: OTP-16735 Aux Id: OTP-16697, ERIERL-496\n\n- Handle message body of response with 1XX status code as next http message.\n\n  Own Id: OTP-16746 Aux Id: ERL-1268\n\n- Fix a crash in http server when setopts is called on a socket closed by the\n  peer.\n\n  Own Id: OTP-16775 Aux Id: ERIERL-519\n\n- A vulnerability in the httpd module (inets application) regarding directory\n  traversal that was introduced in OTP 22.3.1 and corrected in OTP 22.3.4.6. It\n  was also introduced in OTP 23.0 and corrected in OTP 23.1 The vulnerability is\n  registered as CVE-2020-25623\n\n  The vulnerability is only exposed if the http server (httpd) in the inets\n  application is used. The vulnerability makes it possible to read arbitrary\n  files which the Erlang system has read access to with for example a specially\n  prepared http request.\n\n  Own Id: OTP-16790 Aux Id: ERIERL-522","ref":"notes.html#fixed-bugs-and-malfunctions-32"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add support of PATCH method in mod_esi.\n\n  Own Id: OTP-16591 Aux Id: ERIERL-484","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"Inets 7.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Remove support for deprecated functionality. Support for mod_esi eval scheme,\n  mod_htacess, mod_browser, apache config files and deprecated httpd_conf\n  functions are dropped. Module http_uri is deprecated.\n\n  Own Id: OTP-16252\n\n- Refactored the internal handling of deprecated and removed functions.\n\n  Own Id: OTP-16469","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"Inets 7.1.3.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-1-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Corrected an error regarding decode of percent encoded URLs introduced in\n  inets-7.1.3.\n\n  Own Id: OTP-16790 Aux Id: ERIERL-522","ref":"notes.html#fixed-bugs-and-malfunctions-33"},{"type":"extras","title":"Inets 7.1.3.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-1-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix a crash in http server when setopts is called on a socket closed by the\n  peer.\n\n  Own Id: OTP-16775 Aux Id: ERIERL-519","ref":"notes.html#fixed-bugs-and-malfunctions-34"},{"type":"extras","title":"Inets 7.1.3.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-1-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Avoid timing issue when setting active once on a socket that is being closed\n  by the peer.\n\n  Own Id: OTP-16735 Aux Id: OTP-16697, ERIERL-496","ref":"notes.html#fixed-bugs-and-malfunctions-35"},{"type":"extras","title":"Inets 7.1.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Remove use of http_uri and mod_esi eval API.\n\n  This is a backport from OTP 23 that improves the check of URIs to ensure that\n  invalid URIs does not cause vulnerabilities. This will render the deprecated\n  mod_esi eval API unusable as it used URI that does not conform to valid URI\n  syntax.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16556","ref":"notes.html#fixed-bugs-and-malfunctions-36"},{"type":"extras","title":"Inets 7.1.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Inets will honor that valid HTTP headers can not have white space between\n  field-name and the colon.\n\n  Own Id: OTP-16169 Aux Id: ERL-1053\n\n- Changed error propagation in httpc:request/1 to return expected error tuple\n  instead of crashing.\n\n  Own Id: OTP-16290 Aux Id: PR-2437, ERL-1083\n\n- Fix handling of HEAD request with chunked transfer-encoding (httpc).\n\n  Own Id: OTP-16300 Aux Id: ERL-1090","ref":"notes.html#fixed-bugs-and-malfunctions-37"},{"type":"extras","title":"Inets 7.1.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-1-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add HTTP server error logging vi logger\n\n  Own Id: OTP-16019","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"Inets 7.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- httpd - Accept single LF as line terminator\n\n  Own Id: OTP-15893 Aux Id: PR-2206\n\n- mod_esi will now always propagate the actual HTTP status code that it answered\n  with, to later mod-modules, and not in some cases hardcode 200.\n\n  Own Id: OTP-16049 Aux Id: ERIERL-395","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"Inets 7.0.9 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix a regression in http client that causes a crash when request URI has no\n  scheme.\n\n  Own Id: OTP-15930 Aux Id: ERL-969","ref":"notes.html#fixed-bugs-and-malfunctions-38"},{"type":"extras","title":"Inets 7.0.8 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- All incorrect (that is, all) uses of \"can not\" has been corrected to \"cannot\"\n  in source code comments, documentation, examples, and so on.\n\n  Own Id: OTP-14282 Aux Id: PR-1891","ref":"notes.html#fixed-bugs-and-malfunctions-39"},{"type":"extras","title":"Inets 7.0.7.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-7-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add HTTP server error logging vi logger\n\n  Own Id: OTP-16019","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"Inets 7.0.7.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-7-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- mod_esi will now always propagate the actual HTTP status code that it answered\n  with, to later mod-modules, and not in some cases hardcode 200.\n\n  Own Id: OTP-16049 Aux Id: ERIERL-395","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"Inets 7.0.7 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix the internal handling of the option erl_script_timeout in httpd. If\n  explicit erl_script_timeout value was supplied in seconds it was not correctly\n  converted to millisecond units for internal usage.\n\n  This change fixes the handling of erl_script_timeout in all possible\n  configuration scenarios.\n\n  Own Id: OTP-15769 Aux Id: ERIERL-345","ref":"notes.html#fixed-bugs-and-malfunctions-40"},{"type":"extras","title":"Inets 7.0.6 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix the internal handling of the option erl_script_timeout in httpd. When\n  httpd was started with explicit erl_script_timeout, the value of the option\n  was converted to milliseconds before storage. Subsequent calls to httpd:info/1\n  returned the input value multiplied by 1000.\n\n  This change fixes the handing of erl_script_timeout by storing the timeout in\n  seconds and converting to milliseconds before usage.\n\n  Own Id: OTP-15669 Aux Id: ERIERL-321","ref":"notes.html#fixed-bugs-and-malfunctions-41"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Enhance documentation\n\n  Own Id: OTP-15508 Aux Id: ERL-816","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"Inets 7.0.5 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fixed bug that causes a crash in http client when using hostnames (e.g.\n  localhost) with the the option ipv6_host_with_brackets set to true.\n\n  This change also fixes a regression: httpc:request fails with connection error\n  (nxdomain) if option ipv6_host_with_brackets set to true and host component of\n  the URI is an IPv6 address.\n\n  Own Id: OTP-15554 Aux Id: ERIERL-289","ref":"notes.html#fixed-bugs-and-malfunctions-42"},{"type":"extras","title":"Inets 7.0.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Make sure ipv6 addresses with brackets in URIs are converted correctly before\n  passing to lower level functions like gen_tcp and ssl functions. Could cause\n  connection to fail.\n\n  Own Id: OTP-15544 Aux Id: ERIERL-289","ref":"notes.html#fixed-bugs-and-malfunctions-43"},{"type":"extras","title":"Inets 7.0.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fixed http client to not send 'content-length' header in chunked encoded\n  requests.\n\n  Own Id: OTP-15338 Aux Id: ERL-733\n\n- Fixed http client to not drop explicit 'Content-Type' header in requests\n  without a body such as requests with the 'Content-Type' of\n  application/x-www-form-urlencoded.\n\n  Own Id: OTP-15339 Aux Id: ERL-736","ref":"notes.html#fixed-bugs-and-malfunctions-44"},{"type":"extras","title":"Inets 7.0.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Enhance error handling, that is mod_get will return 403 if a path is a\n  directory and not a file.\n\n  Own Id: OTP-15192\n\n- Do not use chunked-encoding with 1xx, 204 and 304 responses when using\n  mod_esi. Old behavior was not compliant with HTTP/1.1 RFC and could cause\n  clients to hang when they received 1xx, 204 or 304 responses that included an\n  empty chunked-encoded body.\n\n  Own Id: OTP-15241\n\n- Add robust handling of chunked-encoded HTTP responses with an empty body (1xx,\n  204, 304). Old behavior could cause the client to hang when connecting to a\n  faulty server implementation.\n\n  Own Id: OTP-15242","ref":"notes.html#fixed-bugs-and-malfunctions-45"},{"type":"extras","title":"Inets 7.0.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Change status code for no mod found to handle request to 501\n\n  Own Id: OTP-15215","ref":"notes.html#fixed-bugs-and-malfunctions-46"},{"type":"extras","title":"Inets 7.0 - Inets Release Notes","doc":"","ref":"notes.html#inets-7-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fixed HTTP content injection bug in httpc (ERL-456).\n\n  Own Id: OTP-14726\n\n- Fixed support for URI-references in HTTP 'Location' header (ERL-333).\n\n  Own Id: OTP-14729\n\n- Fix broken 'Content-Type' handling in httpc (ERL-536).\n\n  Own Id: OTP-15006\n\n- Fix handling of relative paths in the script_alias property of httpd\n  (ERL-574).\n\n  Own Id: OTP-15021\n\n- Fix httpd:reload_config/2 with path() as the first argument (ERL-578).\n\n  Own Id: OTP-15025\n\n- Improved gracefulness.\n\n  Own Id: OTP-15042","ref":"notes.html#fixed-bugs-and-malfunctions-47"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Split inets and create separate ftp and tftp apps.\n\n  Own Id: OTP-14113","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"Inets 6.5.2.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-5-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Do not use chunked-encoding with 1xx, 204 and 304 responses when using\n  mod_esi. Old behavior was not compliant with HTTP/1.1 RFC and could cause\n  clients to hang when they received 1xx, 204 or 304 responses that included an\n  empty chunked-encoded body.\n\n  Own Id: OTP-15241\n\n- Add robust handling of chunked-encoded HTTP responses with an empty body (1xx,\n  204, 304). Old behavior could cause the client to hang when connecting to a\n  faulty server implementation.\n\n  Own Id: OTP-15242","ref":"notes.html#fixed-bugs-and-malfunctions-48"},{"type":"extras","title":"Inets 6.5.2.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-5-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Change status code for no mod found to handle request to 501\n\n  Own Id: OTP-15215","ref":"notes.html#fixed-bugs-and-malfunctions-49"},{"type":"extras","title":"Inets 6.5.2.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-5-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Enhance error handling, that is mod_get will return 403 if a path is a\n  directory and not a file.\n\n  Own Id: OTP-15192","ref":"notes.html#fixed-bugs-and-malfunctions-50"},{"type":"extras","title":"Inets 6.5.2.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-5-2-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Options added for setting low-level properties on the underlying TCP\n  connections. The options are: `sock_ctrl`, `sock_data_act` and\n  `sock_data_pass`. See the manual for details.\n\n  Own Id: OTP-15120 Aux Id: ERIERL-192","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"Inets 6.5.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- inets: httpd - Gracefully handle bad headers\n\n  The option max_headers operated on the individual header length instead of the\n  total length of all headers. Also headers with empty keys are now discarded.\n\n  Own Id: OTP-15092","ref":"notes.html#fixed-bugs-and-malfunctions-51"},{"type":"extras","title":"Inets 6.5.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix broken options handling in httpc (ERL-441).\n\n  Own Id: OTP-15007","ref":"notes.html#fixed-bugs-and-malfunctions-52"},{"type":"extras","title":"Inets 6.5 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- httpc_manager crashes when a long running request is sent on a persistent HTTP\n  connection (keep-alive). Fixed httpc_manager to use proper timeouts on\n  keep-alive connections.\n\n  Own Id: OTP-14908","ref":"notes.html#fixed-bugs-and-malfunctions-53"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add support for unix domain sockets in the http client.\n\n  Own Id: OTP-14854","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"Inets 6.4.5 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- CGI environment variable CONTENT_LENGTH shall be a string\n\n  Own Id: OTP-14679\n\n- In relaxed mode disregard Content-Length header if there is also a\n  Transfer-Encoding header.\n\n  Own Id: OTP-14727\n\n- Eliminated race condition, that could cause http request to sporadically fail\n  to complete successfully, when keep-alive connections are used.\n\n  Own Id: OTP-14783","ref":"notes.html#fixed-bugs-and-malfunctions-54"},{"type":"extras","title":"Inets 6.4.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Correct the handling of location headers so that the status code is not hard\n  coded. This should have been fixed by commit\n  2cc5ba70cbbc6b3ace81a2a0324417c3b65265bb but unfortunately was broken during a\n  code refactoring and unnoticed due to a faulty placed test case.\n\n  Own Id: OTP-14761","ref":"notes.html#fixed-bugs-and-malfunctions-55"},{"type":"extras","title":"Inets 6.4.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-4-3"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Fix broken handling of POST requests\n\n  New chunk mechanism of body data in POST requests added in\n  5d01c70ca399edf28e99dc760506329689fab6ba broke handling of POST body data not\n  using the new mechanism.\n\n  Own Id: OTP-14656\n\n- Make sure ints:stop/2 of the service httpd is synchronous\n\n  Own Id: OTP-14696\n\n- Honor status code returned by ESI script and modernize \"location\" header\n  handling.\n\n  Own Id: OTP-14716","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"Inets 6.4.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Make sure mod_log uses the correct status code\n\n  Own Id: OTP-14510\n\n- Correct behaviour of mod_disk_log to proparly handle repair options\n\n  Own Id: OTP-14530","ref":"notes.html#fixed-bugs-and-malfunctions-56"},{"type":"extras","title":"Inets 6.4.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- http_uri aligned to follow RFC 3986 and not convert \"+\" to space when decoding\n  URIs.\n\n  Own Id: OTP-14573","ref":"notes.html#fixed-bugs-and-malfunctions-57"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Added new option max_client_body_chunk to httpd server to allow chunked\n  delivery of PUT and POST data to mod_esi callback. Note, new mod_esi callback\n  implementation is required.\n\n  Also correct value provided by server_name environment variable\n\n  Own Id: OTP-14450","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"Inets 6.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- httpd_util:rfc1123_date/1 gracefully handle invalid DST dates by returning the\n  original time in the expected rfc1123 format.\n\n  Own Id: OTP-14394","ref":"notes.html#fixed-bugs-and-malfunctions-58"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add unicode binary support to http_uri functions\n\n  Own Id: OTP-14404\n\n- httpc - Change timeout handling so the redirects cause a new timer to be set.\n  This means that a simple redirected request could return after 2\\*timeout\n  milliseconds.\n\n  Own Id: OTP-14429","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"Inets 6.3.9 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- The close of a chunked file reception crashed in a certain timing sequence.\n\n  Own Id: OTP-14391 Aux Id: seq13306","ref":"notes.html#fixed-bugs-and-malfunctions-59"},{"type":"extras","title":"Inets 6.3.8 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3-8"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Added missing release note for inets-6.3.7\n\n  Own Id: OTP-14383","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"Inets 6.3.7 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fixed a bug in ftp that made further operations after a recv_chunk operation\n  impossible.\n\n  Own Id: OTP-14242\n\n- Make default port, 80 and 443, implicit in automatic redirection.\n\n  Own Id: OTP-14301","ref":"notes.html#fixed-bugs-and-malfunctions-60"},{"type":"extras","title":"Inets 6.3.6 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Chunk size decoding could fail. The symptom was that chunk decoding sometimes\n  failed depending on timing of the received stream. If chunk size was split\n  into two different packets decoding would fail.\n\n  Own Id: OTP-13571 Aux Id: ERL-116\n\n- Prevent httpc user process to hang if httpc_handler process terminates\n  unexpectedly\n\n  Own Id: OTP-14091\n\n- Correct Host header, to include port number, when redirecting requests.\n\n  Own Id: OTP-14097\n\n- Shutdown gracefully on connection or TLS handshake errors\n\n  Own Id: OTP-14173 Aux Id: seq13262","ref":"notes.html#fixed-bugs-and-malfunctions-61"},{"type":"extras","title":"Inets 6.3.5 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Correct mistakes in ftp client introduced in inets-6.3.4\n\n  Own Id: OTP-14203 Aux Id: OTP-13982","ref":"notes.html#fixed-bugs-and-malfunctions-62"},{"type":"extras","title":"Inets 6.3.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fixes a bug that makes the ftp client end up in bad state if there is a multi\n  line response from the server and the response number is in the message being\n  sent.\n\n  Own Id: OTP-13960 Aux Id: PR1196\n\n- The ftp client could stop consuming messages when the multiline response\n  handling was corrected.\n\n  Own Id: OTP-13967\n\n- Fix keep-alive https through proxy connections so that all requests, following\n  the first one, will run as expected instead of failing.\n\n  Own Id: OTP-14041\n\n- Fix bug from commit fdfda2fab0921d409789174556582db28141448e that could make\n  listing of group members in mod_auth callbacks fail.\n\n  Own Id: OTP-14082","ref":"notes.html#fixed-bugs-and-malfunctions-63"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Update behavior of httpc:request to match RFC-7231\n\n  Own Id: OTP-13902\n\n- Fixed dialyzer warnings as well as some white-space issues. Thanks to Kostis.\n\n  Own Id: OTP-13982 Aux Id: PR-1207","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"Inets 6.3.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- The legacy option 'inet6fb4' for inets had stopped working. This bug has now\n  been corrected. Fix by Edwin Fine in bugs.erlang.org ERL-200 and Github\n  PR#1132.\n\n  Own Id: OTP-13776 Aux Id: ERL-200 PR-1132","ref":"notes.html#fixed-bugs-and-malfunctions-64"},{"type":"extras","title":"Inets 6.3.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- PUT and DELETE support has been added to mod_esi\n\n  Own Id: OTP-13688 Aux Id: seq13149","ref":"notes.html#improvements-and-new-features-31"},{"type":"extras","title":"Inets 6.3.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- A debug message was accidentally left enabled in the ftp client.\n\n  Own Id: OTP-13712 Aux Id: seq13143","ref":"notes.html#fixed-bugs-and-malfunctions-65"},{"type":"extras","title":"Inets 6.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Ftp client fixes: 1) Corrected a bug that the ftp client gen_server crashed if\n  the listening data socket was closed.\n\n  2. Corrections of ftp client error codes so they are as defined in the\n     reference manual\n\n  Own Id: OTP-13644","ref":"notes.html#fixed-bugs-and-malfunctions-66"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Remove usage of erlang:now().\n\n  Own Id: OTP-12441\n\n- Add handling of DELETE Body to http client.\n\n  Own Id: OTP-13383 Aux Id: PR-972\n\n- Removed references to mod_include and webtool from examples and tests.\n\n  Own Id: OTP-13445 Aux Id: PR-988\n\n- Remove module inets_regexp. Module re should be used instead.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13561","ref":"notes.html#improvements-and-new-features-32"},{"type":"extras","title":"Inets 6.2.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-2-4"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Handle multiple \\\\t in mime types file\n\n  Own Id: OTP-13663 Aux Id: seq13132","ref":"notes.html#improvements-and-new-features-33"},{"type":"extras","title":"Inets 6.2.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-2-3"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Put back unused module inets_regexp and remove it in OTP 19 instead as it is\n  an incompatibility, although it is an undocumented module and should not\n  affect other applications.\n\n  Own Id: OTP-13533","ref":"notes.html#improvements-and-new-features-34"},{"type":"extras","title":"Inets 6.2.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-2-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add environment information item peer_cert to mod_esi\n\n  Own Id: OTP-13510","ref":"notes.html#improvements-and-new-features-35"},{"type":"extras","title":"Inets 6.2.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Mend ipv6_host_with_brackets option in httpc\n\n  Own Id: OTP-13417","ref":"notes.html#fixed-bugs-and-malfunctions-67"},{"type":"extras","title":"Inets 6.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- The TFTP client/server has been fixed to allow file sizes larger than 32MB\n  block by allowing the 16 bit block counter to wrap. Since this is a commonly\n  accepted behavior we regard it as a bug fix.\n\n  Own Id: OTP-13403","ref":"notes.html#fixed-bugs-and-malfunctions-68"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Handle HTTP PATCH method in client.\n\n  Own Id: OTP-13286\n\n- Expected termination should not be logged as an application error.\n\n  Own Id: OTP-13389","ref":"notes.html#improvements-and-new-features-36"},{"type":"extras","title":"Inets 6.1.1.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-1-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Mend ipv6_host_with_brackets option in httpc\n\n  Own Id: OTP-13417","ref":"notes.html#fixed-bugs-and-malfunctions-69"},{"type":"extras","title":"Inets 6.1.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- mod_alias now traverses all aliases picking the longest match and not the\n  first match.\n\n  Own Id: OTP-13248","ref":"notes.html#fixed-bugs-and-malfunctions-70"},{"type":"extras","title":"Inets 6.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Replace obs-folds with spaces instead of failing\n\n  Own Id: OTP-13069\n\n- Add validation fun for URI scheme to http_uri API\n\n  Own Id: OTP-13071\n\n- Handle stream bodies as documented.\n\n  Own Id: OTP-13093\n\n- Correct error handling of mod_esi generated chunks. Send warning headers in\n  chunk trailers instead of generating an unexpected additional 500 request\n  response, when problems, such as a timeout occurs.\n\n  Own Id: OTP-13110\n\n- HTTP client terminates gracefully when an invalid chunked length header is\n  encountered.\n\n  Own Id: OTP-13117","ref":"notes.html#fixed-bugs-and-malfunctions-71"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add default for SNI (Server Name Indication) when running https using the\n  inets HTTP-client.\n\n  Own Id: OTP-12985\n\n- Be forgiving to chunked sizes that have trailing whitespaces as prior\n  implementation was. Also some legacy embedded devices does actually have\n  trailing whitespaces even though this in not according to the spec.\n\n  Own Id: OTP-13116","ref":"notes.html#improvements-and-new-features-37"},{"type":"extras","title":"Inets 6.0.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Improved error handling and gracfully termination when an invalid chunked\n  length header is encountered.\n\n  Own Id: OTP-13061","ref":"notes.html#fixed-bugs-and-malfunctions-72"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add possibility to set socket options, such as nodelay, for httpd. Also phase\n  out legacy option value inet6bf4 for the ipfamily option. This value will be\n  translated to the value inet.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13062","ref":"notes.html#improvements-and-new-features-38"},{"type":"extras","title":"Inets 6.0.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Avoid crash in mod_auth_server and mod_security_server due to using an atom\n  instead of a string when creating a name.\n\n  Own Id: OTP-13022","ref":"notes.html#fixed-bugs-and-malfunctions-73"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add function response_default_headers/0 to httpd customize API, to allow user\n  to specify default values for HTTP response headers.\n\n  Own Id: OTP-13013","ref":"notes.html#improvements-and-new-features-39"},{"type":"extras","title":"Inets 6.0.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix broken socket feature, that is on Linux systems a socket may be opened\n  before starting Erlang and then passed to Erlang's httpd daemon. This is\n  useful as the wrap program can open a privileged port and Erlang does not have\n  to be run as root.\n\n  Own Id: OTP-12875 Aux Id: seq12878\n\n- Fix broken socket feature, that is on Linux systems a socket may be opened\n  before starting Erlang and then passed to Erlangs tftp daemon. This is useful\n  as the wrap program can open a privileged port and Erlang does not have to be\n  run as root.\n\n  Own Id: OTP-12898 Aux Id: seq12900\n\n- httpc_handler should react properly to cancel requests even when the request\n  to be canceled was already finished but httpc_manager did not get notified\n  about that yet.\n\n  Own Id: OTP-12922","ref":"notes.html#fixed-bugs-and-malfunctions-74"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Added format_status function to httpd process to avoid sensitive information\n  to be printed in supervisor logs.\n\n  Own Id: OTP-12976\n\n- Return meaningful error reason disregarding whether a http proxy is used or\n  not.\n\n  Own Id: OTP-12984","ref":"notes.html#improvements-and-new-features-40"},{"type":"extras","title":"Inets 6.0 - Inets Release Notes","doc":"","ref":"notes.html#inets-6-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix race condition in httpc. If the socket is closed by the peer do not try to\n  close it again.\n\n  Own Id: OTP-11845\n\n- Avoid process leak by gracefully terminating httpc request handler process\n  when send operation fails.\n\n  Own Id: OTP-12362\n\n- Reject messages with a Content-Length less than 0\n\n  Own Id: OTP-12739 Aux Id: seq12860\n\n- Let gen_tcp:controlling_process/2 and inet_sctp:connect/\\[45] propagate\n  prim_inet:setopt/3 errors instead of having them generate badmatch exceptions.\n\n  Own Id: OTP-12798","ref":"notes.html#fixed-bugs-and-malfunctions-75"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Remove Server Side Include support from inets, as this is an old technique\n  that has security issues and was not well tested.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12156\n\n- New value in `server_tokens` config for limiting banner grabbing attempts.\n\n  By setting `{server_tokens, none}` in `ServiceConfig` for\n  `inets:start(httpd, ServiceConfig)`, the \"Server:\" header will not be set in\n  messages from the server.\n\n  Own Id: OTP-12661 Aux Id: seq12840\n\n- To enable the HTTP server to run in a virtualized environment, where there can\n  be more that one server that has the same ip-address and port, we add a new\n  option profile.\n\n  Own Id: OTP-12674\n\n- httpc: Fix implementation of graceful shudown to work as intended for keep\n  alive connections not using pipelining.\n\n  Own Id: OTP-12803\n\n- Correct handling of proxy options when using persistent connections.\n\n  Own Id: OTP-12822","ref":"notes.html#improvements-and-new-features-41"},{"type":"extras","title":"Inets 5.10.9 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10-9"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add behaviour with optional callbacks to customize the inets HTTP server.\n\n  Own Id: OTP-12776","ref":"notes.html#improvements-and-new-features-42"},{"type":"extras","title":"Inets 5.10.8 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Reject messages with a Content-Length less than 0\n\n  Own Id: OTP-12739 Aux Id: seq12860","ref":"notes.html#fixed-bugs-and-malfunctions-76"},{"type":"extras","title":"Inets 5.10.7 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10-7"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- New value in `server_tokens` config for limiting banner grabbing attempts.\n\n  By setting `{server_tokens, none}` in `ServiceConfig` for\n  `inets:start(httpd, ServiceConfig)`, the \"Server:\" header will not be set in\n  messages from the server.\n\n  Own Id: OTP-12661 Aux Id: seq12840","ref":"notes.html#improvements-and-new-features-43"},{"type":"extras","title":"Inets 5.10.6 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- inets: parse correctly 'Set-Cookie' header with empty value\n\n  httpc_cookie should parse cookies with empty values and no attributes set in\n  the 'Set-Cookie' headers.\n\n  Own Id: OTP-12455","ref":"notes.html#fixed-bugs-and-malfunctions-77"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add parsing of URI fragments to http_uri:parse\n\n  This fixes a bug in httpc where redirection URIs could lead to bad requests if\n  they contained fragments.\n\n  Own Id: OTP-12398\n\n- httpc: http client now ignores invalid set-cookie headers\n\n  Own Id: OTP-12430","ref":"notes.html#improvements-and-new-features-44"},{"type":"extras","title":"Inets 5.10.5 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- mod_alias now handles https-URIs properly\n\n  Consistent view of configuration parameter keep_alive_timeout, should be\n  presented in the httpd:info/\\[1,2] function in the same unit as it is\n  inputted.\n\n  Own Id: OTP-12436 Aux Id: seq12786","ref":"notes.html#fixed-bugs-and-malfunctions-78"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Gracefully handle invalid content-length headers instead of crashing in\n  list_to_integer.\n\n  Own Id: OTP-12429","ref":"notes.html#improvements-and-new-features-45"},{"type":"extras","title":"Inets 5.10.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fixed a spelling mistake in httpc documentation.\n\n  Own Id: OTP-12221","ref":"notes.html#fixed-bugs-and-malfunctions-79"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Add option \\{ftp_extension, boolean\\} to enable use of extended commands EPSV\n  and EPRT, as specified in RFC 2428, for IPv4 instead of using the legacy\n  commands. Ipv6 cannot be supported without the extended commands.\n\n  Own Id: OTP-12255","ref":"notes.html#improvements-and-new-features-46"},{"type":"extras","title":"Inets 5.10.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix some spelling mistakes in documentation\n\n  Own Id: OTP-12152","ref":"notes.html#fixed-bugs-and-malfunctions-80"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- httpd: Separate timeout for TLS/SSL handshake from keepalive timeout\n\n  Own Id: OTP-12013\n\n- Warning: this is experimental and may disappear or change without previous\n  warning.\n\n  Experimental support for running Quickcheck and PropEr tests from common_test\n  suites is added to common_test. See the reference manual for the new module\n  `ct_property_testing`.\n\n  Experimental property tests are added under\n  `lib/{inet,ssh}/test/property_test`. They can be run directly or from the\n  commont_test suites `inet/ftp_property_test_SUITE.erl` and\n  `ssh/test/ssh_property_test_SUITE.erl`.\n\n  See the code in the `test` directories and the man page for details.\n\n  (Thanks to Tuncer Ayaz for a patch adding Triq)\n\n  Own Id: OTP-12119","ref":"notes.html#improvements-and-new-features-47"},{"type":"extras","title":"Inets 5.10.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- httpc: Fix streaming bugs when handling small responses\n\n  Own Id: OTP-11992","ref":"notes.html#fixed-bugs-and-malfunctions-81"},{"type":"extras","title":"Inets 5.10.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Correct distirbing mode for httpd:reload_config/2\n\n  Own Id: OTP-11914","ref":"notes.html#fixed-bugs-and-malfunctions-82"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Improved handling of invalid strings in the HTTP request line.\n\n  Impact: May improve memory consumption\n\n  Own Id: OTP-11925 Aux Id: Sequence 12601","ref":"notes.html#improvements-and-new-features-48"},{"type":"extras","title":"Inets 5.10 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fixed a spelling mistake in httpc doc (Thanks to Wasif Riaz Malik)\n\n  Own Id: OTP-11538\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744\n\n- ftp now sanitize file name, user name and passwords from   and   tags\n  (Thanks to Sergei Golovan)\n\n  Own Id: OTP-11750\n\n- Corrected error handling in the HTTP client, making it behave more graceful.\n\n  Thanks to Kirilll Zaborsky\n\n  Own Id: OTP-11794\n\n- Support identity transfer-encoding in httpc.\n\n  Thanks to Anthony Ramine\n\n  Own Id: OTP-11802\n\n- Ignore empty Set-Cookie headers to increase interoperability with servers that\n  violate the RFC.\n\n  Thanks to Kirilll Zaborsky\n\n  Own Id: OTP-11803","ref":"notes.html#fixed-bugs-and-malfunctions-83"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- The commit 6189bc07 \"inets: httpc improve pipelining\" has been reverted, as it\n  turned out to break things rather than improve pipelining utilization. It is\n  instead up to the user to configure httpc and use it wisely to be able to get\n  the most out of pipelining.\n\n  Own Id: OTP-11756\n\n- Handle all response codes in httpd_util:message/3\n\n  Own Id: OTP-11838","ref":"notes.html#improvements-and-new-features-49"},{"type":"extras","title":"Inets 5.9.8 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-8"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Mend max_clients check that was broken and avoid too extensive logging that\n  could cause memory problems.\n\n  Own Id: OTP-11557 Aux Id: seq12478","ref":"notes.html#improvements-and-new-features-50"},{"type":"extras","title":"Inets 5.9.7 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix httpd config option 'script_timeout' and fixed httpd config option\n  'keep_alive_timeout'. Thanks to Johannes Weissl.\n\n  Own Id: OTP-11276\n\n- Make httpc:request_cancel/\\[1,2] asynchronous. Previously these functions\n  tried to guarantee request answer would not reach the client, which only\n  worked for some of the use cases. Now these functions are totally asynchronous\n  which makes it the clients responsibility to disregard possible answers to\n  canceled requests.\n\n  Also pipelining implementation has been changed to improve the utilization\n  factor. Further investigation of possible enhancements in this area are\n  planned for later.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11312\n\n- \\[httpd] Add handling of new response for mod_head (otherwise causing\n  case_clause crash). Also updated logging: Removed logging for keep-alive\n  connections timeout (this is a normal occurrence and not an error) and some\n  access-log body size corrections.\n\n  Own Id: OTP-11328","ref":"notes.html#fixed-bugs-and-malfunctions-84"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- The ftp client now supports ftp over tls (ftps).\n\n  Own Id: OTP-11037","ref":"notes.html#improvements-and-new-features-51"},{"type":"extras","title":"Inets 5.9.6 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-6"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- httpc: Allow content body in DELETE requests. Thanks to James Wheare.\n\n  Own Id: OTP-11190\n\n- Add missing brackets to report formatting on ftp_progress process exit. Thanks\n  to Artur Wilniewczyc.\n\n  Own Id: OTP-11202\n\n- Fix some errors in the inets documentation. Thanks to Johannes Weissl.\n\n  Own Id: OTP-11210\n\n- Fix various typos in httpd, inets. Thanks to Tomohiko Aono.\n\n  Own Id: OTP-11226\n\n- Fix httpd config option 'erl_script_nocache'. Thanks to Johannes Weissl.\n\n  Own Id: OTP-11260","ref":"notes.html#improvements-and-new-features-52"},{"type":"extras","title":"Inets 5.9.5 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Reverted incorrect commit that broke cookie handling when using\n  httpc-profiles.\n\n  Own Id: OTP-10956","ref":"notes.html#fixed-bugs-and-malfunctions-85"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Fix http_request:http_headers/1 to send content-length when length is zero.\n  Thanks to CA Meijer.\n\n  Own Id: OTP-10934\n\n- Integrate elliptic curve contribution from Andreas Schultz\n\n  In order to be able to support elliptic curve cipher suites in SSL/TLS,\n  additions to handle elliptic curve infrastructure has been added to public_key\n  and crypto.\n\n  This also has resulted in a rewrite of the crypto API to gain consistency and\n  remove unnecessary overhead. All OTP applications using crypto has been\n  updated to use the new API.\n\n  Impact: Elliptic curve cryptography (ECC) offers equivalent security with\n  smaller key sizes than other public key algorithms. Smaller key sizes result\n  in savings for power, memory, bandwidth, and computational cost that make ECC\n  especially attractive for constrained environments.\n\n  Own Id: OTP-11009\n\n- Fix \\{stream, \\{self, once\\}\\} in httpc to work as expected. Thanks to\n  Masatake Daimon\n\n  Own Id: OTP-11122","ref":"notes.html#improvements-and-new-features-53"},{"type":"extras","title":"Inets 5.9.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-4"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- httpd: The modules option now defaults to the documented value.\n\n  Own Id: OTP-10844\n\n- httpc: Fixed persistent connection implementation that was broken by a patch\n  to R13. The patch made persistent connections behaved the same way as\n  pipelining.\n\n  Own Id: OTP-10845\n\n- httpd: Simplified configuration of ssl in httpd, this also enables all ssl\n  options to be configured. The old and limited way is no longer documented but\n  will be supported for backwards comatibility for some time.\n\n  Own Id: OTP-10846\n\n- Handle correctly the \"No files found or file unavailable\" error code. Thanks\n  to Serge Aleynikov\n\n  Own Id: OTP-10886","ref":"notes.html#improvements-and-new-features-54"},{"type":"extras","title":"Inets 5.9.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-3"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- httpc: The HTTP client now supports HTTPS through proxies\n\n  Own Id: OTP-10256 Aux Id: kunagi-2 \\[ce2e800e-c99f-4050-a1c4-f47023d9c7aa-1]\n\n- Some examples overflowing the width of PDF pages have been corrected.\n\n  Own Id: OTP-10665\n\n- Fix autoredirect for POST requests responding 303. Thanks to Hans Svensson.\n\n  Own Id: OTP-10765","ref":"notes.html#improvements-and-new-features-55"},{"type":"extras","title":"Inets 5.9.2.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-2-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Make log_alert configurable as option in ssl, SSLLogLevel added as option to\n  inets conf file\n\n  Own Id: OTP-11259","ref":"notes.html#improvements-and-new-features-56"},{"type":"extras","title":"Inets 5.9.2.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-2-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Fixed obsolete error report in inets.\n\n  Own Id: OTP-11185 Aux Id: seq12357","ref":"notes.html#improvements-and-new-features-57"},{"type":"extras","title":"Inets 5.9.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Minimum bytes per second\n\n  New option to http server, \\{minimum_bytes_per_second, integer()\\}, for a\n  connection, if it is not reached the socket will close for that specific\n  connection. Can be used to prevent hanging requests from faulty clients.\n\n  Own Id: OTP-10392","ref":"notes.html#improvements-and-new-features-58"},{"type":"extras","title":"Inets 5.9.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Better handling of errorI(s) during update of the session database.\n\n  Also added and updated some debugging functions\n  [which_sessions/0,1](`httpc:which_sessions/0`) and\n  [info/0](`httpc:info/0`).\n\n  Own Id: OTP-10093\n\n  Aux Id: Seq 12062\n\n- Removed R14B compatible version of (inets-service and tftp) behaviour\n  definition.\n\n  Own Id: OTP-10095\n\n- \\[httpc] Documentation of KeepAlive and Pipeline timeout options have been\n  improved.\n\n  Own Id: OTP-10114","ref":"notes.html#improvements-and-new-features-59"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] Cancel request does not work due to incorrect handler table creation\n  (wrong keypos).\n\n  Vyacheslav Vorobyov\n\n  Own Id: OTP-10092","ref":"notes.html#fixed-bugs-and-malfunctions-86"},{"type":"extras","title":"Incompatibilities - Inets Release Notes","doc":"-","ref":"notes.html#incompatibilities"},{"type":"extras","title":"Inets 5.9 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-9"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[httpd] Make the server header configurable with new config option\n  [server_tokens](`m:httpd#prop_server_tokens`). The value of the server header,\n  which was previously hard-coded (at compile time), is now possible to\n  manipulate through the means of the\n  [server_tokens](`m:httpd#prop_server_tokens`) config option.\n\n  Own Id: OTP-9805\n\n- Improve inets support for inets as an included application.\n\n  `inets_app` calls `supervisor:start_link/3` directly rather than calling the\n  root supervisor function `inets_sup:start_link/0`. This precludes using\n  included_applications to start inets without having a wrapper function.\n\n  Jay Nelson\n\n  Own Id: OTP-9960\n\n- \\[httpc] Add function for retrieving current options,\n  [get_options/1,2](`httpc:get_options/1`).\n\n  Own Id: OTP-9979\n\n- Utility module `m:http_uri` now officially supported.\n\n  Also, the `http_uri:parse` function has been extended with more scheme support\n  and a way to provide your own scheme info.\n\n  Own Id: OTP-9983\n\n  Aux Id: Seq 12022","ref":"notes.html#improvements-and-new-features-60"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions-87"},{"type":"extras","title":"Inets 5.8.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-8-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features-61"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[ftp] Fails to open IPv6 connection due to badly formatted IPv6 address in\n  EPRT command. The address part of the command incorrectly contained decimal\n  elements instead of hexadecimal.\n\n  Own Id: OTP-9827\n\n  Aux Id: Seq 11970\n\n- \\[httpc] Bad Keep Alive Mode. When selecting a session, the \"state\" of the\n  session (specifically if the server has responded) was not taken into account.\n\n  Own Id: OTP-9847\n\n- \\[httpc] The client incorrectly streams 404 responses. The documentation\n  specifies that only 200 and 206 responses shall be streamed.\n\n  Shane Evens\n\n  Own Id: OTP-9860","ref":"notes.html#fixed-bugs-and-malfunctions-88"},{"type":"extras","title":"Inets 5.8 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-8"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[ftpc] Add a config option to specify a\n  [data connect timeout](`m:ftp#dtimeout`). That is how long the ftp client will\n  wait for the server to connect to the data socket. If this timeout occurs, an\n  error will be returned to the caller and the ftp client process will be\n  terminated.\n\n  Own Id: OTP-9545\n\n- \\[httpc] Wrong Host header in IPv6 HTTP requests. When a URI with a IPv6 host\n  is parsed, the brackets that encapsulates the address part is removed. This\n  value is then supplied as the host header. This can cause problems with some\n  servers. A workaround for this is to use headers_as_is and provide the host\n  header with the request call. To solve this a new option has been added,\n  [ipv6_host_with_brackets](`m:httpc#ipv6_host_with_brackets`). This option\n  specifies if the host value of the host header shall include the brackets or\n  not. By default, it does not (as before).\n\n  Own Id: OTP-9628","ref":"notes.html#improvements-and-new-features-62"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpd] Fix logging of content length in mod_log.\n\n  Garrett Smith\n\n  Own Id: OTP-9715\n\n- \\[httpd] Sometimes entries in the transfer log was written with the message\n  size as list of numbers. This list was actually the size as a string, e.g.\n  \"123\", written with the control sequence ~w. This has now been corrected so\n  that any string is converted to an integer (if possible).\n\n  Own Id: OTP-9733\n\n- Fixed various problems detected by Dialyzer.\n\n  Own Id: OTP-9736","ref":"notes.html#fixed-bugs-and-malfunctions-89"},{"type":"extras","title":"Incompatibilities - Inets Release Notes","doc":"- \\[httpc] Deprecated interface module `http` has been removed. It has (long)\n  been replaced by http client interface module `m:httpc`.\n\n  Own Id: OTP-9359\n\n- \\[httpc|httpd] The old ssl implementation (based on OpenSSL), has been\n  deprecated. The config option that specified usage of this version of the ssl\n  app, `ossl`, has been removed.\n\n  Own Id: OTP-9522","ref":"notes.html#incompatibilities-1"},{"type":"extras","title":"Inets 5.7.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-7-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features-63"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpd] XSS prevention did not work for hex-encoded URL's.\n\n  Own Id: OTP-9655\n\n- \\[httpd] GET request with malformed header date caused server crash\n  (non-fatal) with no reply to client. Will now result in a reply with status\n  code 400.\n\n  Own Id: OTP-9674\n\n  Aux Id: seq11936","ref":"notes.html#fixed-bugs-and-malfunctions-90"},{"type":"extras","title":"Inets 5.7.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-7-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features-64"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] Parsing of a cookie expire date should be more forgiving. That is, if\n  the parsing fails, the date should be ignored. Also added support for (yet\n  another) date format: \"Tue Jan 01 08:00:01 2036 GMT\".\n\n  Own Id: OTP-9433\n\n- \\[httpc] Rewrote cookie parsing. Among other things solving cookie processing\n  from www.expedia.com.\n\n  Own Id: OTP-9434\n\n- \\[httpd] Fix httpd directory traversal on Windows. Directory traversal was\n  possible on Windows where backward slash is used as directory separator.\n\n  András Veres-Szentkirályi.\n\n  Own Id: OTP-9561","ref":"notes.html#fixed-bugs-and-malfunctions-91"},{"type":"extras","title":"Inets 5.7 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-7"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[httpc|httpd] Added support for IPv6 with ssl.\n\n  Own Id: OTP-5566","ref":"notes.html#improvements-and-new-features-65"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] Remove unnecessary usage of iolist_to_binary when processing body\n  (for PUT and POST).\n\n  Filipe David Manana\n\n  Own Id: OTP-9317\n\n- \\[ftp] FTP client doesn't work with IPv6 host.\n\n  Attila Rajmund Nohl\n\n  Own Id: OTP-9342 Aux Id: seq11853\n\n- \\[httpd] Peer/sockname resolv doesn't work with IPv6 addrs in HTTP.\n\n  Attila Rajmund Nohl.\n\n  Own Id: OTP-9343\n\n- \\[httpc] Clients started stand-alone not properly handled. Also it was not\n  documented how to use them, that is that once started, they are represented by\n  a `t:pid/0` and not by their `profile()`.\n\n  Own Id: OTP-9365","ref":"notes.html#fixed-bugs-and-malfunctions-92"},{"type":"extras","title":"Inets 5.6 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-6"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[httpc] Add support for upload body streaming (PUT and POST).\n\n  For more info, see the definition of the `Body` argument of the\n  [request/4,5](`httpc:request/4`) function.\n\n  Filipe David Manana\n\n  Own Id: OTP-9094\n\n- \\[ftp] Added (type) spec for all exported functions.\n\n  Own Id: OTP-9114 Aux Id: seq11799\n\n- \\[httpd] `mod_esi:deliver/2` made to accept binary data.\n\n  Bernard Duggan\n\n  Own Id: OTP-9123\n\n- \\[httpd] Prevent XSS in error pages. Prevent user controlled input from being\n  interpreted as HTML in error pages by encoding the reserved HTML characters.\n\n  Michael Santos\n\n  Own Id: OTP-9124\n\n- \\[httpd] Improved error messages.\n\n  Ricardo Catalinas Jiménez\n\n  Own Id: OTP-9157\n\n- \\[httpd] Extended support for file descriptors. In order to be able to bind to\n  a privileged port without running the erlang VM as root, the support for using\n  file descriptors has been improved. It is now possible to add the file\n  descriptor to the config (option fd) when calling the\n  [inets:start(httpd, ...)](`inets:start/2`) function.\n\n  Attila Rajmund Nohl\n\n  Own Id: OTP-9202\n\n  Aux Id: seq11819\n\n- The default ssl kind has now been changed to `essl`.\n\n  `ossl` will work for as long as the ssl application supports it.\n\n  See the httpd [socket_type](`m:httpd#props_comm`) communication property or\n  the httpc [request/4,5](`httpc:request/4`) function for more info.\n\n  Own Id: OTP-9230\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***","ref":"notes.html#improvements-and-new-features-66"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpd] Wrong [security property](`m:httpd#props_sec`) names used in\n  documentation.\n\n  `security_data_file` used instead of `data_file`.\n\n  `security_max_retries` used instead of `max_retries`.\n\n  `security_block_time` used instead of `block_time`.\n\n  `security_fail_expire_time` used instead of `fail_expire_time`.\n\n  `security_auth_timeout` used instead of `auth_timeout`.\n\n  Garrett Smith\n\n  Own Id: OTP-9131\n\n- \\[httpd] Fix timeout message generated by mod_esi. When a mod_esi request\n  times out, the code to send a timeout response was incorrect and generated an\n  internal server error as well as an invalid response line.\n\n  Bernard Duggan\n\n  Own Id: OTP-9158\n\n- \\[httpc] httpc manager crashes. When a request results in a retry, the request\n  id will be \"reused\" in the previous implementation a race condition could\n  occur causing the manager to crash.\n\n  This is now avoided by using proc_lib:init_ack and gen_server:enter_loop to\n  allow more advanced initialization of httpc_handlers without blocking the\n  httpc_manger and eliminating extra processes that can cause race conditions.\n\n  Own Id: OTP-9246\n\n- \\[httpc] Issuing a request (`httpc:request`) to an host with the ssl option\n  `{ip, {127,0,0,1}}` results in an handler crash. The reason was that the\n  connect call resulted in an exit with reason `badarg` (this was the same for\n  both `ssl` and `gen_tcp`).\n\n  Exits was not caught. This has now been improved.\n\n  Own Id: OTP-9289\n\n  Aux Id: seq11845","ref":"notes.html#fixed-bugs-and-malfunctions-93"},{"type":"extras","title":"Inets 5.5.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-5-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features-67"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpd] httpd_response:send_chunk handles empty list and empty binary - i.e.\n  no chunk is sent, but it does not handle a list with an empty binary \\[<<>>].\n  This will be sent as an empty chunk - which in turn will be encoded by\n  http_chunk to the same as a final chunk, which will make the http client\n  believe that the end of the page is reached.\n\n  Own Id: OTP-8906","ref":"notes.html#fixed-bugs-and-malfunctions-94"},{"type":"extras","title":"Inets 5.5.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-5-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Miscellaneous inet6 related problems.\n\n  Own Id: OTP-8927\n\n- Updated http-server to make sure URLs in error-messages are URL-encoded. Added\n  support in http-client to use URL-encoding. Also added the missing include\n  directory for the inets application.\n\n  Own Id: OTP-8940\n\n  Aux Id: seq11735","ref":"notes.html#improvements-and-new-features-68"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Fix format_man_pages so it handles all man sections and remove warnings/errors\n  in various man pages.\n\n  Own Id: OTP-8600\n\n- \\[httpc] Pipelined and queued requests not processed when connection closed\n  remotelly.\n\n  Own Id: OTP-8906","ref":"notes.html#fixed-bugs-and-malfunctions-95"},{"type":"extras","title":"Inets 5.5 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] If a request times out (not connect timeout), the handler process\n  exited (normal) but neglected to inform the manager process. For this reason,\n  the manager did not clean up the request table., resulting in a memory leak.\n  Also the manager did not create a monitor for the handler, so in an unforeseen\n  handler crash, this could also create a memory leak.\n\n  Own Id: OTP-8739\n\n- The service tftp was spelled wrong in documentation and in some parts of the\n  code. It should be tftp.\n\n  Own Id: OTP-8741 Aux Id: seq11635\n\n- \\[httpc] Replaced the old http client api module (http) with the new, httpc in\n  the users guide.\n\n  Own Id: OTP-8742","ref":"notes.html#fixed-bugs-and-malfunctions-96"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- Eliminated warnings for auto-imported BIF clashes.\n\n  Own Id: OTP-8840","ref":"notes.html#improvements-and-new-features-69"},{"type":"extras","title":"Inets 5.4 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-4"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[httpc|httpd] - Now allow the use of the \"new\" ssl, by using the `essl` tag\n  instead.\n\n  See the `http_option` option in the [request/4,5](`httpc:request/4`) or the\n  [socket-type](`m:httpd#props_comm`) section of the Communication properties\n  chapter for more info,\n\n  Own Id: OTP-7907\n\n- Deprecated functions designated to be removed in R14 has been removed. Also,\n  some new functions has been marked as deprecated (the old http client api\n  module).\n\n  Own Id: OTP-8564\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n- \\[httpd] - Improved mod_alias. Now able to do better URL rewrites.\n\n  See [URL aliasing properties](`m:httpd#props_alias`) and the\n  [CGI properties](`m:httpd#props_cgi`) section(s) for more info,\n\n  Own Id: OTP-8573","ref":"notes.html#improvements-and-new-features-70"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions-97"},{"type":"extras","title":"Inets 5.3.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-3-3"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features-71"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] - Made cookie handling more case insensitive.\n\n  Own Id: OTP-8609\n\n  Nicolas Thauvin\n\n- \\[httpc|httpd] - Netscape cookie dates can also be given with a 2-digit year\n  (e.g. 06 = 2006).\n\n  Own Id: OTP-8610\n\n  Nicolas Thauvin\n\n- \\[httpd] - Added support (again) for the documented debugging features. See\n  the User's Guide [Configuration](http_server.md#config) chapter for more info.\n\n  Own Id: OTP-8624","ref":"notes.html#fixed-bugs-and-malfunctions-98"},{"type":"extras","title":"Inets 5.3.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-3-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features-72"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] - Memory leak plugged. The profile manager never cleaned up in its\n  handler database. This meant that with each new request handler, another entry\n  was created that was never deleted. Eventually the request id counter (used as\n  a key) would wrap, but the machine would most likely run out of memory before\n  that happened.\n\n  Own Id: OTP-8542\n\n  Lev Walkin\n\n- \\[httpc] - https requests with default port (443) not handled properly.\n\n  Own Id: OTP-8607\n\n  jebu ittiachen","ref":"notes.html#fixed-bugs-and-malfunctions-99"},{"type":"extras","title":"Inets 5.3.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-3-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features-73"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] - Badly formatted error reason for errors occurring during initial\n  connect to a server. Also, the possible error reasons was not properly\n  documented.\n\n  Own Id: OTP-8508\n\n  Aux Id: seq11407\n\n- \\[httpd] - Issues with ESI erl_script_timeout.\n\n  - The `erl_script_timeout` config option is ducumented as a number of seconds.\n    But when parsing the config, in the new format (not a config file), it was\n    handled as if in number of milliseconds.\n  - When the erl-script-timeout time was exceeded, the server incorrectly marked\n    the answer as sent, thereby leaving client hanging (with an incomplete\n    answer). This has been changed, so that now the socket will be closed.\n\n  Own Id: OTP-8509","ref":"notes.html#fixed-bugs-and-malfunctions-100"},{"type":"extras","title":"Inets 5.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-3"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[httpc] - Allow users to pass socket options to the transport module when\n  making requests.\n\n  See the `socket_opts` option in the [request/4](`httpc:request/4`) or\n  [set_options/1,2](`httpc:set_options/1`) for more info,\n\n  Own Id: OTP-8352\n\n- \\[httpc] Fix bug crafting Host header when port is not 80.\n\n  The host header should include the port number as well as the host name when\n  making a request to a server listening on a port other than the HTTP default\n  of 80. Currently, only the host name is included. This is important to make\n  the http client more compliant with the HTTP specification.\n\n  Own Id: OTP-8371\n\n  Kelly McLaughlin\n\n- \\[httpc|httpd] http_chunk data handling/passing improvement.\n\n  This is a modification to the http_chunk module to forward any full chunk\n  received, regardless of whether the size field for the following chunk has\n  been received yet. This allows http_chunk to be used in situations where a\n  long term HTTP connection is used to send periodic status updates as\n  individual chunks. Previously a given chunk would not be forwarded to the\n  client process until the size for the next chunk had been read which rendered\n  the module difficult to use for the scenario described.\n\n  Bernard Duggan\n\n  Own Id: OTP-8351\n\n- Include the inets test suite in the release of the application.\n\n  Own Id: OTP-8349\n\n- \\[httpc] - It is now possible to configure the client to deliver an async\n  reply to more receivers then the calling process.\n\n  See the [receiver](`httpc:request/2`) option for more info,\n\n  Own Id: OTP-8106\n\n- \\[httpd] - Methods \"PUT\" and \"DELETE\" now allowed.\n\n  huntermorris@gmail.com\n\n  Own Id: OTP-8103\n\n- \\[httpc] Several more or less critical fixes:\n\n  - Initial call between the httpc manager and request handler was synchronous.\n\n    When the manager starts a new request handler, this is no longer a\n    synchronous operation. Previously, the new request handler made the\n    connection to the server and issuing of the first request (the reason for\n    starting it) in the gen_server init function. If the connection for some\n    reason \"took some time\", the manager hanged, leaving all other activities by\n    that manager also hanging.\n\n  As a side-effect of these changes, some modules was also renamed, and a new\n  api module, `m:httpc`, has been introduced (the old module `http` is _not_\n  removed, but is now just wrapper for `httpc`).\n\n  Own Id: OTP-8016\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***","ref":"notes.html#improvements-and-new-features-74"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpd] The server did not fully support the documented module callback api.\n  Specifically, the load function should be able to return the atom `ok`, but\n  this was not accepted.\n\n  Own Id: OTP-8359\n\n- Fixing various documentation-related bugs (bad quotes).\n\n  Own Id: OTP-8327\n\n- Fixing minor Dialyzer and copyright problem(s).\n\n  Own Id: OTP-8315\n\n- \\[httpc] - Added basic sanity check of option value combinations.\n\n  adam.kocoloski@gmail.com\n\n  Own Id: OTP-8056","ref":"notes.html#fixed-bugs-and-malfunctions-101"},{"type":"extras","title":"Inets 5.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[ftpc] - Start of the FTP client has been changed in the following way:\n\n  - It is now also possible to start a standalone FTP client process using the\n    re-introduced `ftp:open/2` function.\n\n    This is an alternative to starting the client using the\n    inets service framework.\n\n    The old `ftp:open/1`, undocumented, function, caused the client to be hooken\n    into the inets service supervision framework. This is _no_ longer the case.\n\n    \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  - Previously, the FTP client attempted to use IPv6, unless otherwise\n    instructed (the `ip_v6_disabled` flag), and only used IPv4 if this did not\n    work. This has now been _changed_.\n\n    A new option, [ipfamily](`m:ftp#ipfamily`), has been introduced, with the\n    default value `inet` (IPv4).\n\n    See `ftp:open/2` for more info.\n\n    \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8258\n\n- The documentation is now built with open source tools (_xsltproc_ and _fop_)\n  that exists on most platforms. One visible change is that the frames are\n  removed.\n\n  Own Id: OTP-8249","ref":"notes.html#improvements-and-new-features-75"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] - Streaming to file did not work.\n\n  dizzyd@gmail.com\n\n  Own Id: OTP-8204\n\n- \\[ftpc] - The `ftp:ls/2` function (LIST command) and the\n  `ftp:nlist/2` function (NLST command) with wildcards did not work\n  properly.\n\n  These functions is documented as working on directories, but this is actually\n  not according the standard. The LIST and NLST commands are specified to\n  operate on a directory or other group of files, or a file.\n\n  Previously, an attempt was made to check if the listing returned by the server\n  was actually an error message. This was done by changing remote directory (cd)\n  into the (assumed) \"directory\". This may work if Pathname was actually a\n  directory, but as this is not always the case, this test does not work.\n  Instead, we now return the actual server result and leave the interpretation\n  to the caller.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8247\n\n  Aux Id: seq11407\n\n- \\[httpc] - Fixes various bugs in timeout and keep-alive queue handling.\n\n  - When a queued request times, out the error mssage is sent the owner of the\n    active request.\n  - Requests in the keep-alive queue is forgotten when handler terminates.\n  - Timeout out requests are retried.\n\n  Jean-Sébastien Pédron\n\n  Own Id: OTP-8248\n\n- \\[httpd] - Unnecessarily strict matching when handling closing sockets.\n\n  Own Id: OTP-8280","ref":"notes.html#fixed-bugs-and-malfunctions-102"},{"type":"extras","title":"Inets 5.1.3 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-1-3"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features-76"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] - Raise condition. When http:request is called and httpc_manager\n  selects a session where there's already a pending request, then the connection\n  handler for that session effectively resets its parser, readying it for the\n  response to the second request. But if there are still some inbound packets\n  for the response to the first request, things get confused.\n\n  tomas.abrahamsson@gmail.com\n\n  Own Id: OTP-8154","ref":"notes.html#fixed-bugs-and-malfunctions-103"},{"type":"extras","title":"Inets 5.1.2 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-1-2"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[httpc] - Added http option `connect_timeout` for http client request. The\n  `connect_timeout` option is used for the initial request, when the client\n  connects to the server. Default value is that of the `timeout` option.\n\n  See the [request/4,5](`httpc:request/4`) function for more info.\n\n  Own Id: OTP-7298","ref":"notes.html#improvements-and-new-features-77"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpd] - Failed to create listen socket with invalid option combo. The\n  http-server failed to create its listen socket when the bind-address was an\n  IPv4-address (a tuple of size 4) and the ipfamily option was inet6fb4.\n\n  Own Id: OTP-8118\n\n  Aux Id: seq11321\n\n- \\[httpd] - Removed documentation for non-existing function\n  (httpd_util:header/2,3,4).\n\n  Own Id: OTP-8101","ref":"notes.html#fixed-bugs-and-malfunctions-104"},{"type":"extras","title":"Inets 5.1.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-1-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[httpd] - When starting inets (the web-server) and supplying a descriptor on\n  the command line (example: erl -httpd_8888  ) it is now possible to\n  specify which ip-family to use: `inet | inet6 | inet6fb4`.\n\n  Example: erl -httpd_8888 10|inet6\n\n  When starting the web-server either using a file with property list (the\n  proplist_file) or a an property list, using the ipfamily option:\n  `{ipfamily, inet | inet6 | inet6fb4}`.\n\n  Finally, when starting the web-server using the classical apache-style config\n  file, the `BindAddress` directive has been augmented to allow the\n  specification of the IpFamily: `BindAddress blirk.ericsson.se|inet`\n\n  Default is `inet6fb4` which emulates the behaviour of the previous version.\n\n  See the [Communication properties](`m:httpd#props_comm`) section for more\n  info.\n\n  Own Id: OTP-8069\n\n  Aux Id: seq11086","ref":"notes.html#improvements-and-new-features-78"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- \\[httpc] - Reception of unexpected data causes handler crash.\n\n  Own Id: OTP-8052","ref":"notes.html#fixed-bugs-and-malfunctions-105"},{"type":"extras","title":"Inets 5.1 - Inets Release Notes","doc":"","ref":"notes.html#inets-5-1"},{"type":"extras","title":"Improvements and New Features - Inets Release Notes","doc":"- \\[httpc] Added support for web services using only basic auth, with a token as\n  the user part and no password part.\n\n  twoggle@gmail.com\n\n  Own Id: OTP-7998\n\n- \\[httpc] - Bind HTTP client to IP-addr. It is now possible to specify an\n  alternate ip-address and port to be used when the client connects to the\n  server.\n\n  As a side-effect of this, the option `ipv6` has been removed and replaced by\n  the `ipfamily` option.\n\n  See [http:set_options/1,2](`httpc:set_options/1`) for more info.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8004","ref":"notes.html#improvements-and-new-features-79"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Inets Release Notes","doc":"- Updated guard tests (i.e. is_list(L) instead of list(L) and possibly\n  andalso/orelse instead of \",\"/\";\").\n\n  Own Id: OTP-7994\n\n- \\[httpc] - Remove use of the deprecated regexp module.\n\n  Own Id: OTP-8001\n\n- \\[httpc] - The option `max_keep_alive_length` was not handled properly.\n\n  Own Id: OTP-8005","ref":"notes.html#fixed-bugs-and-malfunctions-106"},{"type":"extras","title":"Introduction","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction","ref":"introduction.html"},{"type":"extras","title":"Purpose - Introduction","doc":"`Inets` is a container for Internet clients and servers including the following:\n\n- An HTTP client and server\n\nThe HTTP client and server are HTTP 1.1 compliant as defined in\n[RFC 2616](http://www.ietf.org/rfc/rfc2616.txt).","ref":"introduction.html#purpose"},{"type":"extras","title":"Prerequisites - Introduction","doc":"It is assumed that the reader is familiar with the Erlang programming language,\nconcepts of OTP, and has a basic understanding of and HTTP protocol.","ref":"introduction.html#prerequisites"},{"type":"extras","title":"Inets","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Inets","ref":"inets_services.html"},{"type":"extras","title":"Service Concept - Inets","doc":"Each client and server in `Inets` is viewed as a service. Services can be\nconfigured to be started at application startup or dynamically in runtime. To\nrun `Inets` as a distributed application that handles application failover and\ntakeover, configure the services to be started at application startup. When\nstarting the `Inets` application, the `Inets` top supervisor starts a number of\nsubsupervisors and worker processes for handling the provided services. When\nstarting services dynamically, new children are added to the supervision tree,\nunless the service is started with the standalone option. In this case the\nservice is linked to the calling process and all OTP application features, such\nas soft upgrade, are lost.\n\nServices to be configured for startup at application startup are to be put into\nthe Erlang node configuration file on the following form:\n\n```erlang\n[{inets, [{services, ListofConfiguredServices}]}].\n```\n\nFor details of what to put in the list of configured services, see the\ndocumentation for the services to be configured.","ref":"inets_services.html#service-concept"},{"type":"extras","title":"HTTP Client","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# HTTP Client","ref":"http_client.html"},{"type":"extras","title":"Configuration - HTTP Client","doc":"The HTTP client default profile is started when the `Inets` application is\nstarted and is then available to all processes on that Erlang node. Other\nprofiles can also be started at application startup, or profiles can be started\nand stopped dynamically in runtime. Each client profile spawns a new process to\nhandle each request, unless a persistent connection can be used with or without\npipelining. The client adds a `host` header and an empty `te` header if there\nare no such headers present in the request.\n\nThe client supports IPv6 as long as the underlying mechanisms also do so.\n\nThe following is to be put in the Erlang node application configuration file to\nstart a profile at application startup:\n\n```erlang\n[{inets, [{services, [{httpc, PropertyList}]}]}]\n```\n\nFor valid properties, see `m:httpc`.","ref":"http_client.html#configuration"},{"type":"extras","title":"Getting Started - HTTP Client","doc":"Start `Inets`:\n\n```erlang\n1> inets:start().\nok\n```\n\nThe following calls use the default client profile. Use the proxy\n`\"www-proxy.mycompany.com:8000\"`, except from requests to localhost. This\napplies to all the following requests.\n\nExample:\n\n```erlang\n2> httpc:set_options([{proxy, {{\"www-proxy.mycompany.com\", 8000},\n[\"localhost\"]}}]).\nok\n```\n\nThe following is an ordinary synchronous request:\n\n```erlang\n3> {ok, {{Version, 200, ReasonPhrase}, Headers, Body}} =\n.. httpc:request(get, {\"http://www.erlang.org\", []}, [], []).\n```\n\nWith all the default values presented, a get request can also be written as\nfollows:\n\n```erlang\n4> {ok, {{Version, 200, ReasonPhrase}, Headers, Body}} =\n.. httpc:request(\"http://www.erlang.org\").\n```\n\nThe following is a https request and with verification of the host:\n\n```erlang\n5> {ok, {{Version, 200, ReasonPhrase}, Headers, Body}} =\n.. httpc:request(get, {\"https://www.erlang.org\", []}, [{ssl, httpc:ssl_verify_host_options(true)}], []).\n```\n\nThe following is an ordinary asynchronous request:\n\n```erlang\n6> {ok, RequestId} =\n.. httpc:request(get, {\"http://www.erlang.org\", []}, [], [{sync, false}]).\n```\n\nThe result is sent to the calling process as `{http, {ReqestId, Result}}`.\n\nIn this case, the calling process is the shell, so the following result is\nreceived:\n\n```erlang\n7> receive {http, {RequestId, Result}} -> ok after 500 -> error end.\nok\n```\n\nThis sends a request with a specified connection header:\n\n```erlang\n8> {ok, {{NewVersion, 200, NewReasonPhrase}, NewHeaders, NewBody}} =\n.. httpc:request(get, {\"http://www.erlang.org\", [{\"connection\", \"close\"}]},\n.. [], []).\n```\n\nThis sends an HTTP request over a unix domain socket (experimental):\n\n```erlang\n9> httpc:set_options([{ipfamily, local}, {unix_socket,\"/tmp/unix_socket/consul_http.sock\"}]).\n10> {ok, {{NewVersion, 200, NewReasonPhrase}, NewHeaders, NewBody}} =\n .. httpc:request(put, {\"http:///v1/kv/foo\", [], [], \"hello\"}, [], []).\n```\n\nStart an HTTP client profile:\n\n```erlang\n10> {ok, Pid} = inets:start(httpc, [{profile, foo}]).\n{ok, <0.45.0>}\n```\n\nThe new profile has no proxy settings, so the connection is refused:\n\n```erlang\n11> httpc:request(\"http://www.erlang.org\", foo).\n{error, econnrefused}\n```\n\nStop the HTTP client profile:\n\n```erlang\n12> inets:stop(httpc, foo).\nok\n```\n\nAlternative way to stop the HTTP client profile:\n\n```erlang\n13> inets:stop(httpc, Pid).\nok\n```","ref":"http_client.html#getting-started"},{"type":"extras","title":"HTTP server","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# HTTP server","ref":"http_server.html"},{"type":"extras","title":"Configuration - HTTP server","doc":"[](){: #config }\n\nThe HTTP server, also referred to as httpd, handles HTTP requests as described\nin [RFC 2616](http://www.ietf.org/rfc/rfc2616.txt) with a few exceptions, such\nas gateway and proxy functionality. The server supports IPv6 as long as the\nunderlying mechanisms also do so.\n\nThe server implements numerous features, such as:\n\n- Secure Sockets Layer (SSL)\n- Erlang Scripting Interface (ESI)\n- Common Gateway Interface (CGI)\n- User Authentication (using Mnesia, Dets or plain text database)\n- Common Logfile Format (with or without disk_log(3) support)\n- URL Aliasing\n- Action Mappings\n- Directory Listings\n\nThe configuration of the server is provided as an Erlang property list.\n\nAs of `Inets` 5\\.0 the HTTP server is an easy to start/stop and customize web\nserver providing the most basic web server functionality. Inets is designed for\nembedded systems and if you want a full-fledged web server there are other\nerlang open source alternatives.\n\nAlmost all server functionality has been implemented using an especially crafted\nserver API, which is described in the Erlang Web Server API. This API can be\nused to enhance the core server functionality, for example with custom logging\nand authentication.\n\nThe following is to be put in the Erlang node application configuration file to\nstart an HTTP server at application startup:\n\n```erlang\n[{inets, [{services, [{httpd, [{proplist_file,\n           \"/var/tmp/server_root/conf/8888_props.conf\"}]},\n          {httpd, [{proplist_file,\n           \"/var/tmp/server_root/conf/8080_props.conf\"}]}]}]}].\n```\n\nThe server is configured using an Erlang property list. For the available\nproperties, see `m:httpd`.\n\nThe available configuration properties are as follows:\n\n```erlang\nhttpd_service() -> {httpd, httpd()}\nhttpd()         -> [httpd_config()]\nhttpd_config()  -> {proplist_file, file()}\n                   {debug, debug()} |\n                   {accept_timeout, integer()}\ndebug()         -> disable | [debug_options()]\ndebug_options() -> {all_functions, modules()} |\n                   {exported_functions, modules()} |\n                   {disable, modules()}\nmodules()       -> [atom()]\n```\n\nHere:\n\n- **`{proplist_file, file()}`** - File containing an Erlang property list,\n  followed by a full stop, describing the HTTP server configuration.\n\n- **`{debug, debug()}`** - Can enable trace on all functions or only exported\n  functions on chosen modules.\n\n- **`{accept_timeout, integer()}`** - Sets the wanted time-out value for the\n  server to set up a request connection.","ref":"http_server.html#configuration"},{"type":"extras","title":"Getting Started - HTTP server","doc":"[](){: #using_http_server_api }\n\nStart `Inets`:\n\n```erlang\n1> inets:start().\nok\n```\n\nStart an HTTP server with minimal required configuration. If you specify port\n`0`, an arbitrary available port is used, and you can use function `info` to\nfind which port number that was picked:\n\n```erlang\n2> {ok, Pid} = inets:start(httpd, [{port, 0}, {server_root,\"/tmp\"},\n.. {document_root,\"/tmp/htdocs\"}, {bind_address, \"localhost\"}]).\n{ok, 0.79.0}\n```\n\nCall `info`:\n\n```erlang\n3> httpd:info(Pid).\n[{mime_types,[{\"html\",\"text/html\"},{\"htm\",\"text/html\"}]},\n {server_name,\"machine.local\"},\n {bind_address, {127,0,0,1}},\n {server_root,\"/tmp\"},\n {port,59408},\n {document_root,\"/tmp/htdocs\"},\n {ipfamily,inet}]\n```\n\nReload the configuration without restarting the server:\n\n```erlang\n4> httpd:reload_config([{port, 59408},\n.. {server_root,\"/tmp/www_test\"}, {document_root,\"/tmp/www_test/htdocs\"},\n.. {bind_address, \"localhost\"}], non_disturbing).\nok.\n```\n\n> #### Note {: .info }\n>\n> `port` and `bind_address` cannot be changed. Clients trying to access the\n> server during the reload get a service temporary unavailable answer.\n\n```erlang\n5> httpd:info(Pid, [server_root, document_root]).\n[{server_root,\"/tmp/www_test\"},{document_root,\"/tmp/www_test/htdocs\"}]\n```\n\n```erlang\n6> ok = inets:stop(httpd, Pid).\n```\n\nAlternative:\n\n```erlang\n6> ok = inets:stop(httpd, {{127,0,0,1}, 59408}).\n```\n\nNotice that `bind_address` must be the IP address reported by function `info`\nand cannot be the hostname that is allowed when putting in `bind_address`.","ref":"http_server.html#getting-started"},{"type":"extras","title":"Dynamic Web Pages - HTTP server","doc":"[](){: #dynamic_we_pages }\n\n`Inets` HTTP server provides two ways of creating dynamic web pages, each with\nits own advantages and disadvantages:\n\n- **_CGI scripts_** - Common Gateway Interface (CGI) scripts can be written in\n  any programming language. CGI scripts are standardized and supported by most\n  web servers. The drawback with CGI scripts is that they are resource-intensive\n  because of their design. CGI requires the server to fork a new OS process for\n  each executable it needs to start.\n\n- **_ESI-functions_** - Erlang Server Interface (ESI) functions provide a tight\n  and efficient interface to the execution of Erlang functions. This interface,\n  on the other hand, is `Inets` specific.","ref":"http_server.html#dynamic-web-pages"},{"type":"extras","title":"CGI Version 1.1, RFC 3875 - HTTP server","doc":"The module `mod_cgi` enables execution of\n[CGI scripts](http://www.ietf.org/rfc/rfc3875.txt) on the server. A file\nmatching the definition of a ScriptAlias config directive is treated as a CGI\nscript. A CGI script is executed by the server and its output is returned to the\nclient.\n\nThe CGI script response comprises a message header and a message body, separated\nby a blank line. The message header contains one or more header fields. The body\ncan be empty.\n\nExample:\n\n```text\n\"Content-Type:text/plain\\nAccept-Ranges:none\\n\\nsome very\n\tplain text\"\n```\n\nThe server interprets the message headers and most of them are transformed into\nHTTP headers and sent back to the client together with the message-body.\n\nSupport for CGI-1.1 is implemented in accordance with\n[RFC 3875](http://www.ietf.org/rfc/rfc3875.txt).","ref":"http_server.html#cgi-version-1-1-rfc-3875"},{"type":"extras","title":"ESI - HTTP server","doc":"The Erlang server interface is implemented by module `mod_esi`.\n\n#### ERL Scheme\n\nThe erl scheme is designed to mimic plain CGI, but without the extra overhead.\nAn URL that calls an Erlang `erl` function has the following syntax (regular\nexpression):\n\n```text\nhttp://your.server.org/***/Module[:/]Function(?QueryString|/PathInfo)\n```\n\n\\*\\*\\* depends on how the ErlScriptAlias config directive has been used.\n\nThe module `Module` referred to must be found in the code path, and it must\ndefine a function `Function` with an arity of two or three. It is preferable to\nimplement a function with arity three, as it permits to send chunks of the web\npage to the client during the generation phase instead of first generating the\nwhole web page and then sending it to the client. The option to implement a\nfunction with arity two is only kept for backwards compatibility reasons. For\nimplementation details of the ESI callback function, see `m:mod_esi`.","ref":"http_server.html#esi"},{"type":"extras","title":"Logging - HTTP server","doc":"Three types of logs are supported: transfer logs, security logs, and error logs.\nThe de-facto standard Common Logfile Format is used for the transfer and\nsecurity logging. There are numerous statistics programs available to analyze\nCommon Logfile Format. The Common Logfile Format looks as follows:\n\n_remotehost rfc931 authuser \\[date] \"request\" status bytes_\n\nHere:\n\n- **_remotehost_** - Remote hostname.\n\n- **_rfc931_** - The client remote username\n  ([RFC 931](http://www.ietf.org/rfc/rfc931.txt)).\n\n- **_authuser_** - The username used for authentication.\n\n- **_\\[date]_** - Date and time of the request\n  ([RFC 1123](http://www.ietf.org/rfc/rfc1123.txt)).\n\n- **_\"request\"_** - The request line exactly as it came from the client\n  ([RFC 1945](http://www.ietf.org/rfc/rfc1945.txt)).\n\n- **_status_** - The HTTP status code returned to the client\n  ([RFC 1945](http://www.ietf.org/rfc/rfc1945.txt)).\n\n- **_bytes_** - The content-length of the document transferred.\n\nInternal server errors are recorded in the error log file. The format of this\nfile is a more unplanned format than the logs using Common Logfile Format, but\nconforms to the following syntax:\n\n_\\[date]_ access to _path_ failed for _remotehost_, reason: _reason_","ref":"http_server.html#logging"},{"type":"extras","title":"Erlang Web Server API - HTTP server","doc":"The process of handling an HTTP request involves several steps, such as:\n\n- Setting up connections, sending and receiving data.\n- URI to filename translation.\n- Authentication/access checks.\n- Retrieving/generating the response.\n- Logging.\n\nTo provide customization and extensibility of the request handling of the HTTP\nservers, most of these steps are handled by one or more modules. These modules\ncan be replaced or removed at runtime and new ones can be added. For each\nrequest, all modules are traversed in the order specified by the module\ndirective in the server configuration file. Some parts, mainly the\ncommunication- related steps, are considered server core functionality and are\nnot implemented using the Erlang web server API. A description of functionality\nimplemented by the Erlang webserver API is described in\n[Section Inets Web Server Modules](http_server.md#Inets_Web_Server_Modules).\n\nA module can use data generated by previous modules in the Erlang webserver API\nmodule sequence or generate data to be used by consecutive Erlang Web Server API\nmodules. This is possible owing to an internal list of key-value tuples,\nreferred to as interaction data.\n\n> #### Note {: .info }\n>\n> Interaction data enforces module dependencies and is to be avoided if\n> possible. This means that the order of modules in the modules property is\n> significant.","ref":"http_server.html#erlang-web-server-api"},{"type":"extras","title":"API Description - HTTP server","doc":"Each module that implements server functionality using the Erlang web server API\nis to implement the following call back functions:\n\n- `do/1` (mandatory) - the function called when a request is to be handled\n- `load/2`\n- `store/2`\n- `remove/1`\n\nThe latter functions are needed only when new config directives are to be\nintroduced. For details, see `m:httpd`.","ref":"http_server.html#api-description"},{"type":"extras","title":"Inets Web Server Modules - HTTP server","doc":"[](){: #Inets_Web_Server_Modules }\n\nThe convention is that all modules implementing some web server functionality\nhas the name `mod_*`. When configuring the web server, an appropriate selection\nof these modules is to be present in the module directive. Notice that there are\nsome interaction dependencies to take into account, so the order of the modules\ncannot be random.","ref":"http_server.html#inets-web-server-modules"},{"type":"extras","title":"mod_action - Filetype/Method-Based Script Execution - HTTP server","doc":"This module runs CGI scripts whenever a file of a certain type or HTTP method\n(see [RFC 1945](http://tools.ietf.org/html/rfc1945)) is requested.\n\nUses the following Erlang Web Server API interaction data:\n\n- `real_name` \\- from `m:mod_alias`.\n\nExports the following Erlang Web Server API interaction data, if possible:\n\n- **`{new_request_uri, RequestURI}`** - An alternative `RequestURI` has been\n  generated.","ref":"http_server.html#mod_action-filetype-method-based-script-execution"},{"type":"extras","title":"mod_alias - URL Aliasing - HTTP server","doc":"The `m:mod_alias` module makes it possible to map different parts of the host\nfile system into the document tree, that is, creates aliases and redirections.\n\nExports the following Erlang Web Server API interaction data, if possible:\n\n- **`{real_name, PathData}`** - `PathData` is the argument used for API function\n  `mod_alias:path/3`.","ref":"http_server.html#mod_alias-url-aliasing"},{"type":"extras","title":"mod_auth - User Authentication - HTTP server","doc":"The `m:mod_auth` module provides for basic user authentication using textual\nfiles, Dets databases as well as Mnesia databases.\n\nUses the following Erlang Web Server API interaction data:\n\n- `real_name` \\- from `m:mod_alias`\n\nExports the following Erlang Web Server API interaction data:\n\n- **`{remote_user, User}`** - The username used for authentication.\n\n#### Mnesia As Authentication Database\n\nIf Mnesia is used as storage method, Mnesia must be started before the HTTP\nserver. The first time Mnesia is started, the schema and the tables must be\ncreated before Mnesia is started. A simple example of a module with two\nfunctions that creates and start Mnesia is provided here. Function\n`first_start/0` is to be used the first time. It creates the schema and the\ntables. `start/0` is to be used in consecutive startups. `start/0` starts Mnesia\nand waits for the tables to be initiated. This function must only be used when\nthe schema and the tables are already created.\n\n```erlang\n-module(mnesia_test).\n-export([start/0,load_data/0]).\n-include_lib(\"mod_auth.hrl\").\n\nfirst_start() ->\n    mnesia:create_schema([node()]),\n    mnesia:start(),\n    mnesia:create_table(httpd_user,\n                        [{type, bag},\n                         {disc_copies, [node()]},\n                         {attributes, record_info(fields,\n                                                  httpd_user)}]),\n    mnesia:create_table(httpd_group,\n                        [{type, bag},\n                         {disc_copies, [node()]},\n                         {attributes, record_info(fields,\n                                                  httpd_group)}]),\n    mnesia:wait_for_tables([httpd_user, httpd_group], 60000).\n\nstart() ->\n    mnesia:start(),\n    mnesia:wait_for_tables([httpd_user, httpd_group], 60000).\n```\n\nTo create the Mnesia tables, we use two records defined in `mod_auth.hrl`, so\nthat file must be included. `first_start/0` creates a schema that specifies on\nwhich nodes the database is to reside. Then it starts Mnesia and creates the\ntables. The first argument is the name of the tables, the second argument is a\nlist of options of how to create the table, see `m:mnesia`, documentation for\nmore information. As the implementation of the `mod_auth_mnesia` saves one row\nfor each user, the type must be `bag`. When the schema and the tables are\ncreated, function `mnesia:start/0` is used to start Mnesia and waits for the\ntables to be loaded. Mnesia uses the directory specified as `mnesia_dir` at\nstartup if specified, otherwise Mnesia uses the current directory. For security\nreasons, ensure that the Mnesia tables are stored outside the document tree of\nthe HTTP server. If they are placed in the directory which it protects, clients\ncan download the tables. Only the Dets and Mnesia storage methods allow writing\nof dynamic user data to disk. `plain` is a read only method.","ref":"http_server.html#mod_auth-user-authentication"},{"type":"extras","title":"mod_cgi - CGI Scripts - HTTP server","doc":"This module handles invoking of CGI scripts.","ref":"http_server.html#mod_cgi-cgi-scripts"},{"type":"extras","title":"mod_dir - Directories - HTTP server","doc":"This module generates an HTML directory listing (Apache-style) if a client sends\na request for a directory instead of a file. This module must be removed from\nthe Modules config directive if directory listings is unwanted.\n\nUses the following Erlang Web Server API interaction data:\n\n- `real_name` \\- from `m:mod_alias`\n\nExports the following Erlang Web Server API interaction data:\n\n- **`{mime_type, MimeType}`** - The file suffix of the incoming URL mapped into\n  a `MimeType`.","ref":"http_server.html#mod_dir-directories"},{"type":"extras","title":"mod_disk_log - Logging Using Disk_Log. - HTTP server","doc":"Standard logging using the \"Common Logfile Format\" and `m:disk_log`.\n\nUses the following Erlang Web Server API interaction data:\n\n- `remote_user` \\- from `mod_auth`","ref":"http_server.html#mod_disk_log-logging-using-disk_log"},{"type":"extras","title":"mod_esi - Erlang Server Interface - HTTP server","doc":"The `m:mod_esi` module implements the Erlang Server Interface (ESI) providing a\ntight and efficient interface to the execution of Erlang functions.\n\nUses the following Erlang web server API interaction data:\n\n- `remote_user` \\- from `mod_auth`\n\nExports the following Erlang web server API interaction data:\n\n- **`{mime_type, MimeType}`** - The file suffix of the incoming URL mapped into\n  a `MimeType`","ref":"http_server.html#mod_esi-erlang-server-interface"},{"type":"extras","title":"mod_get - Regular GET Requests - HTTP server","doc":"This module is responsible for handling GET requests to regular files. GET\nrequests for parts of files is handled by `mod_range`.\n\nUses the following Erlang web server API interaction data:\n\n- `real_name` \\- from `m:mod_alias`","ref":"http_server.html#mod_get-regular-get-requests"},{"type":"extras","title":"mod_head - Regular HEAD Requests - HTTP server","doc":"This module is responsible for handling HEAD requests to regular files. HEAD\nrequests for dynamic content is handled by each module responsible for dynamic\ncontent.\n\nUses the following Erlang Web Server API interaction data:\n\n- `real_name` \\- from `m:mod_alias`","ref":"http_server.html#mod_head-regular-head-requests"},{"type":"extras","title":"mod_log - Logging Using Text Files. - HTTP server","doc":"Standard logging using the \"Common Logfile Format\" and text files.\n\nUses the following Erlang Web Server API interaction data:\n\n- `remote_user` \\- from `mod_auth`","ref":"http_server.html#mod_log-logging-using-text-files"},{"type":"extras","title":"mod_range - Requests with Range Headers - HTTP server","doc":"This module responses to requests for one or many ranges of a file. This is\nespecially useful when downloading large files, as a broken download can be\nresumed.\n\nNotice that request for multiple parts of a document report a size of zero to\nthe log file.\n\nUses the following Erlang Web Server API interaction data:\n\n- `real_name` \\- from `m:mod_alias`","ref":"http_server.html#mod_range-requests-with-range-headers"},{"type":"extras","title":"mod_response_control - Requests with If* Headers - HTTP server","doc":"This module controls that the conditions in the requests are fulfilled. For\nexample, a request can specify that the answer only is of interest if the\ncontent is unchanged since the last retrieval. If the content is changed, the\nrange request is to be converted to a request for the whole file instead.\n\nIf a client sends more than one of the header fields that restricts the servers\nright to respond, the standard does not specify how this is to be handled.\n`m:httpd` controls each field in the following order and if one of the fields\ndoes not match the current state, the request is rejected with a proper\nresponse:\n\n`If-modified`\n\n`If-Unmodified`\n\n`If-Match`\n\n`If-Nomatch`\n\nUses the following Erlang Web Server API interaction data:\n\n- `real_name` \\- from `m:mod_alias`\n\nExports the following Erlang Web Server API interaction data:\n\n- **`{if_range, send_file}`** - The conditions for the range request are not\n  fulfilled. The response must not be treated as a range request, instead it\n  must be treated as an ordinary get request.","ref":"http_server.html#mod_response_control-requests-with-if-headers"},{"type":"extras","title":"mod_security - Security Filter - HTTP server","doc":"The `m:mod_security` module serves as a filter for authenticated requests\nhandled in `m:mod_auth`. It provides a possibility to restrict users from access\nfor a specified amount of time if they fail to authenticate several times. It\nlogs failed authentication as well as blocking of users, and it calls a\nconfigurable callback module when the events occur.\n\nThere is also an API to block or unblock users manually. This API can also list\nblocked users or users who have been authenticated within a configurable amount\nof time.","ref":"http_server.html#mod_security-security-filter"},{"type":"extras","title":"mod_trace - TRACE Request - HTTP server","doc":"`mod_trace` is responsible for handling of TRACE requests. Trace is a new\nrequest method in HTTP/1.1. The intended use of trace requests is for testing.\nThe body of the trace response is the request message that the responding web\nserver or proxy received.","ref":"http_server.html#mod_trace-trace-request"},{"type":"extras","title":"Serving files from the command line - HTTP server","doc":"httpd includes functionality to quickly serve files from the command line. In\nits simplest form, `erl -S httpd` will serve files in the local directory on\nlocalhost.\n\n- **`--port`** - Sets the port to bind on. Defaults to `8000`.\n\n- **`--bind`** - Sets the bind address to listen on. Defaults to `127.0.0.1`.\n\n- **_DIRECTORY_** - Sets the directory to serve data from. Defaults to the\n  current directory.\n\nFor example, to serve files from directory `test_results` on port `4000`:\n\n```text\nerl -S httpd serve --port 4000 test_results\n```\n\nFor a full reference of all options, run `erl -S httpd serve --help`.","ref":"http_server.html#serving-files-from-the-command-line"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}