package org.jabref.gui.collab.stringadd;

import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

import org.jabref.gui.collab.DatabaseChangeDetailsView;
import org.jabref.logic.l10n.Localization;

public final class BibTexStringAddDetailsView extends DatabaseChangeDetailsView {

    public BibTexStringAddDetailsView(BibTexStringAdd stringAdd) {
        VBox container = new VBox();
        Label header = new Label(Localization.lang("Added string"));
        header.getStyleClass().add("sectionHeader");
        container.getChildren().addAll(
                header,
                new Label(Localization.lang("Label: %0", stringAdd.getAddedString().getName())),
                new Label(Localization.lang("Content: %0", stringAdd.getAddedString().getContent()))
        );

        this.setAllAnchorsAndAttachChild(container);
    }
}
