# Gentoo-Dotnet-Maintainer-Tools

Gentoo tool for .NET packages maintenance.

![Gentoo Chest logo](./logo.png "Gentoo Chest")

## About

### Available tools

Version 2 .NET tools:

* gdmt - (a.k.a. "gdmt-launcher") launcher for all GDMT tools
* gdmt-checkcore - list NuPkgs required for building .NET projects using a given SDK
* gdmt-cleantmp - clean .NET artifacts from a given tmpdir
* gdmt-commit - create commits to a ebuild repository
* gdmt-ebuild - wrapper to run the ebuild command faster and for multiple files
* gdmt-genpwsh - generate PowerShell distribution tarball
* gdmt-gensdk - generate .NET SDK distribution tarball
* gdmt-govendor - generate a distribution tarball for GO language packages
* gdmt-license - list project licenses in Gentoo style
* gdmt-pn - show package name of current directory in a ebuild repository
* gdmt-restore - run .NET restore safely
* gdmt-stablereq - file stabilization bug reports
* gdmt-sync - synchronize the ebuild repository and update caches

### GDMT-Ebuild aliases

* cg - config
* cl - clean
* co - compile
* cu - configure
* d - digest
* f - fetch
* h - help
* i - install
* ma - manifest
* me - merge
* pa - package
* pe - prerm
* po - postinst
* pp - prepare
* pr - preinst
* ps - postrm
* q - qmerge
* r - rpm
* s - setup
* t - test
* um - unmerge
* up - unpack

## Installation

### Dependencies

Version 2 .NET dependencies:

* FSharp.Data
* Fabulous.AST
* LibGit2Sharp
* Org.Xgqt.SimpleLog
* System.CommandLine

Additionally following external programs are called by tools from this
repository:

| GDMT           | external executable |
|----------------|---------------------|
| gdmt-checkcore | dotnet              |
| gdmt-commit    | git                 |
| gdmt-ebuild    | ebuild              |
| gdmt-govendor  | tar, xz             |
| gdmt-license   | nuget-license       |
| gdmt-restore   | dotnet              |
| gdmt-stablereq | pkgdev              |
| gdmt-sync      | git, pkgcheck       |

## License

### Code

This software is licensed under the `GPL-2.0-or-later` license.
For more information see the `Copyright` directory.

    Copyright 2023-2024 Gentoo Authors
    Distributed under the terms of the GNU General Public License v2

### Assets

The "Gentoo Chest" logo contributed by [Madiana Argon](https://is-a.cat/@madargon)
is licensed under the CC BY-SA 4.0 license.
