// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package composer provides access to the Cloud Composer API.
//
// For product documentation, see: https://cloud.google.com/composer/
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/composer/v1"
//	...
//	ctx := context.Background()
//	composerService, err := composer.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	composerService, err := composer.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	composerService, err := composer.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package composer // import "google.golang.org/api/composer/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "composer:v1"
const apiName = "composer"
const apiVersion = "v1"
const basePath = "https://composer.googleapis.com/"
const mtlsBasePath = "https://composer.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Environments = NewProjectsLocationsEnvironmentsService(s)
	rs.ImageVersions = NewProjectsLocationsImageVersionsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Environments *ProjectsLocationsEnvironmentsService

	ImageVersions *ProjectsLocationsImageVersionsService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsEnvironmentsService(s *Service) *ProjectsLocationsEnvironmentsService {
	rs := &ProjectsLocationsEnvironmentsService{s: s}
	return rs
}

type ProjectsLocationsEnvironmentsService struct {
	s *Service
}

func NewProjectsLocationsImageVersionsService(s *Service) *ProjectsLocationsImageVersionsService {
	rs := &ProjectsLocationsImageVersionsService{s: s}
	return rs
}

type ProjectsLocationsImageVersionsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

// AllowedIpRange: Allowed IP range with user-provided description.
type AllowedIpRange struct {
	// Description: Optional. User-provided description. It must contain at
	// most 300 characters.
	Description string `json:"description,omitempty"`

	// Value: IP address or range, defined using CIDR notation, of requests
	// that this rule applies to. Examples: `192.168.1.1` or
	// `192.168.0.0/16` or `2001:db8::/32` or
	// `2001:0db8:0000:0042:0000:8a2e:0370:7334`. IP range prefixes should
	// be properly truncated. For example, `1.2.3.4/24` should be truncated
	// to `1.2.3.0/24`. Similarly, for IPv6, `2001:db8::1/32` should be
	// truncated to `2001:db8::/32`.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AllowedIpRange) MarshalJSON() ([]byte, error) {
	type NoMethod AllowedIpRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CheckUpgradeResponse: Message containing information about the result
// of an upgrade check operation.
type CheckUpgradeResponse struct {
	// BuildLogUri: Output only. Url for a docker build log of an upgraded
	// image.
	BuildLogUri string `json:"buildLogUri,omitempty"`

	// ContainsPypiModulesConflict: Output only. Whether build has succeeded
	// or failed on modules conflicts.
	//
	// Possible values:
	//   "CONFLICT_RESULT_UNSPECIFIED" - It is unknown whether build had
	// conflicts or not.
	//   "CONFLICT" - There were python packages conflicts.
	//   "NO_CONFLICT" - There were no python packages conflicts.
	ContainsPypiModulesConflict string `json:"containsPypiModulesConflict,omitempty"`

	// ImageVersion: Composer image for which the build was happening.
	ImageVersion string `json:"imageVersion,omitempty"`

	// PypiConflictBuildLogExtract: Output only. Extract from a docker image
	// build log containing information about pypi modules conflicts.
	PypiConflictBuildLogExtract string `json:"pypiConflictBuildLogExtract,omitempty"`

	// PypiDependencies: Pypi dependencies specified in the environment
	// configuration, at the time when the build was triggered.
	PypiDependencies map[string]string `json:"pypiDependencies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BuildLogUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BuildLogUri") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CheckUpgradeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckUpgradeResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CidrBlock: CIDR block with an optional name.
type CidrBlock struct {
	// CidrBlock: CIDR block that must be specified in CIDR notation.
	CidrBlock string `json:"cidrBlock,omitempty"`

	// DisplayName: User-defined name that identifies the CIDR block.
	DisplayName string `json:"displayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CidrBlock") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CidrBlock") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CidrBlock) MarshalJSON() ([]byte, error) {
	type NoMethod CidrBlock
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatabaseConfig: The configuration of Cloud SQL instance that is used
// by the Apache Airflow software.
type DatabaseConfig struct {
	// MachineType: Optional. Cloud SQL machine type used by Airflow
	// database. It has to be one of: db-n1-standard-2, db-n1-standard-4,
	// db-n1-standard-8 or db-n1-standard-16. If not specified,
	// db-n1-standard-2 will be used. Supported for Cloud Composer
	// environments in versions composer-1.*.*-airflow-*.*.*.
	MachineType string `json:"machineType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MachineType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MachineType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DatabaseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DatabaseFailoverRequest: Request to trigger database failover (only
// for highly resilient environments).
type DatabaseFailoverRequest struct {
}

// DatabaseFailoverResponse: Response for DatabaseFailoverRequest.
type DatabaseFailoverResponse struct {
}

// Date: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values. * A month and day, with a
// zero year (for example, an anniversary). * A year on its own, with a
// zero month and a zero day. * A year and month, with a zero day (for
// example, a credit card expiration date). Related types: *
// google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// EncryptionConfig: The encryption options for the Cloud Composer
// environment and its dependencies.Supported for Cloud Composer
// environments in versions composer-1.*.*-airflow-*.*.*.
type EncryptionConfig struct {
	// KmsKeyName: Optional. Customer-managed Encryption Key available
	// through Google's Key Management Service. Cannot be updated. If not
	// specified, Google-managed key will be used.
	KmsKeyName string `json:"kmsKeyName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KmsKeyName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EncryptionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Environment: An environment for running orchestration tasks.
type Environment struct {
	// Config: Configuration parameters for this environment.
	Config *EnvironmentConfig `json:"config,omitempty"`

	// CreateTime: Output only. The time at which this environment was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Labels: Optional. User-defined labels for this environment. The
	// labels map can contain no more than 64 entries. Entries of the labels
	// map are UTF8 strings that comply with the following restrictions: *
	// Keys must conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform
	// to regexp: [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are
	// additionally constrained to be <= 128 bytes in size.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: The resource name of the environment, in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environment
	// Id}" EnvironmentId must start with a lowercase letter followed by up
	// to 63 lowercase letters, numbers, or hyphens, and cannot end with a
	// hyphen.
	Name string `json:"name,omitempty"`

	// State: The current state of the environment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state of the environment is unknown.
	//   "CREATING" - The environment is in the process of being created.
	//   "RUNNING" - The environment is currently running and healthy. It is
	// ready for use.
	//   "UPDATING" - The environment is being updated. It remains usable
	// but cannot receive additional update requests or be deleted at this
	// time.
	//   "DELETING" - The environment is undergoing deletion. It cannot be
	// used.
	//   "ERROR" - The environment has encountered an error and cannot be
	// used.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. The time at which this environment was last
	// modified.
	UpdateTime string `json:"updateTime,omitempty"`

	// Uuid: Output only. The UUID (Universally Unique IDentifier)
	// associated with this environment. This value is generated when the
	// environment is created.
	Uuid string `json:"uuid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Config") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Environment) MarshalJSON() ([]byte, error) {
	type NoMethod Environment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnvironmentConfig: Configuration information for an environment.
type EnvironmentConfig struct {
	// AirflowByoidUri: Output only. The 'bring your own identity' variant
	// of the URI of the Apache Airflow Web UI hosted within this
	// environment, to be accessed with external identities using workforce
	// identity federation (see Access environments with workforce identity
	// federation
	// (/composer/docs/composer-2/access-environments-with-workforce-identity
	// -federation)).
	AirflowByoidUri string `json:"airflowByoidUri,omitempty"`

	// AirflowUri: Output only. The URI of the Apache Airflow Web UI hosted
	// within this environment (see Airflow web interface
	// (/composer/docs/how-to/accessing/airflow-web-interface)).
	AirflowUri string `json:"airflowUri,omitempty"`

	// DagGcsPrefix: Output only. The Cloud Storage prefix of the DAGs for
	// this environment. Although Cloud Storage objects reside in a flat
	// namespace, a hierarchical file tree can be simulated using
	// "/"-delimited object name prefixes. DAG objects for this environment
	// reside in a simulated directory with the given prefix.
	DagGcsPrefix string `json:"dagGcsPrefix,omitempty"`

	// DatabaseConfig: Optional. The configuration settings for Cloud SQL
	// instance used internally by Apache Airflow software.
	DatabaseConfig *DatabaseConfig `json:"databaseConfig,omitempty"`

	// EncryptionConfig: Optional. The encryption options for the Cloud
	// Composer environment and its dependencies. Cannot be updated.
	EncryptionConfig *EncryptionConfig `json:"encryptionConfig,omitempty"`

	// EnvironmentSize: Optional. The size of the Cloud Composer
	// environment. This field is supported for Cloud Composer environments
	// in versions composer-2.*.*-airflow-*.*.* and newer.
	//
	// Possible values:
	//   "ENVIRONMENT_SIZE_UNSPECIFIED" - The size of the environment is
	// unspecified.
	//   "ENVIRONMENT_SIZE_SMALL" - The environment size is small.
	//   "ENVIRONMENT_SIZE_MEDIUM" - The environment size is medium.
	//   "ENVIRONMENT_SIZE_LARGE" - The environment size is large.
	EnvironmentSize string `json:"environmentSize,omitempty"`

	// GkeCluster: Output only. The Kubernetes Engine cluster used to run
	// this environment.
	GkeCluster string `json:"gkeCluster,omitempty"`

	// MaintenanceWindow: Optional. The maintenance window is the period
	// when Cloud Composer components may undergo maintenance. It is defined
	// so that maintenance is not executed during peak hours or critical
	// time periods. The system will not be under maintenance for every
	// occurrence of this window, but when maintenance is planned, it will
	// be scheduled during the window. The maintenance window period must
	// encompass at least 12 hours per week. This may be split into multiple
	// chunks, each with a size of at least 4 hours. If this value is
	// omitted, the default value for maintenance window will be applied.
	// The default value is Saturday and Sunday 00-06 GMT.
	MaintenanceWindow *MaintenanceWindow `json:"maintenanceWindow,omitempty"`

	// MasterAuthorizedNetworksConfig: Optional. The configuration options
	// for GKE cluster master authorized networks. By default master
	// authorized networks feature is: - in case of private environment:
	// enabled with no external networks allowlisted. - in case of public
	// environment: disabled.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `json:"masterAuthorizedNetworksConfig,omitempty"`

	// NodeConfig: The configuration used for the Kubernetes Engine cluster.
	NodeConfig *NodeConfig `json:"nodeConfig,omitempty"`

	// NodeCount: The number of nodes in the Kubernetes Engine cluster that
	// will be used to run this environment. This field is supported for
	// Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
	NodeCount int64 `json:"nodeCount,omitempty"`

	// PrivateEnvironmentConfig: The configuration used for the Private IP
	// Cloud Composer environment.
	PrivateEnvironmentConfig *PrivateEnvironmentConfig `json:"privateEnvironmentConfig,omitempty"`

	// RecoveryConfig: Optional. The Recovery settings configuration of an
	// environment. This field is supported for Cloud Composer environments
	// in versions composer-2.*.*-airflow-*.*.* and newer.
	RecoveryConfig *RecoveryConfig `json:"recoveryConfig,omitempty"`

	// ResilienceMode: Optional. Resilience mode of the Cloud Composer
	// Environment. This field is supported for Cloud Composer environments
	// in versions composer-2.2.0-airflow-*.*.* and newer.
	//
	// Possible values:
	//   "RESILIENCE_MODE_UNSPECIFIED" - Default mode doesn't change
	// environment parameters.
	//   "HIGH_RESILIENCE" - Enabled High Resilience mode, including Cloud
	// SQL HA.
	ResilienceMode string `json:"resilienceMode,omitempty"`

	// SoftwareConfig: The configuration settings for software inside the
	// environment.
	SoftwareConfig *SoftwareConfig `json:"softwareConfig,omitempty"`

	// WebServerConfig: Optional. The configuration settings for the Airflow
	// web server App Engine instance.
	WebServerConfig *WebServerConfig `json:"webServerConfig,omitempty"`

	// WebServerNetworkAccessControl: Optional. The network-level access
	// control policy for the Airflow web server. If unspecified, no
	// network-level access restrictions will be applied.
	WebServerNetworkAccessControl *WebServerNetworkAccessControl `json:"webServerNetworkAccessControl,omitempty"`

	// WorkloadsConfig: Optional. The workloads configuration settings for
	// the GKE cluster associated with the Cloud Composer environment. The
	// GKE cluster runs Airflow scheduler, web server and workers workloads.
	// This field is supported for Cloud Composer environments in versions
	// composer-2.*.*-airflow-*.*.* and newer.
	WorkloadsConfig *WorkloadsConfig `json:"workloadsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AirflowByoidUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AirflowByoidUri") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EnvironmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EnvironmentConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExecuteAirflowCommandRequest: Execute Airflow Command request.
type ExecuteAirflowCommandRequest struct {
	// Command: Airflow command.
	Command string `json:"command,omitempty"`

	// Parameters: Parameters for the Airflow command/subcommand as an array
	// of arguments. It may contain positional arguments like
	// `["my-dag-id"]`, key-value parameters like `["--foo=bar"]` or
	// `["--foo","bar"]`, or other flags like `["-f"]`.
	Parameters []string `json:"parameters,omitempty"`

	// Subcommand: Airflow subcommand.
	Subcommand string `json:"subcommand,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Command") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Command") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExecuteAirflowCommandRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteAirflowCommandRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExecuteAirflowCommandResponse: Response to
// ExecuteAirflowCommandRequest.
type ExecuteAirflowCommandResponse struct {
	// Error: Error message. Empty if there was no error.
	Error string `json:"error,omitempty"`

	// ExecutionId: The unique ID of the command execution for polling.
	ExecutionId string `json:"executionId,omitempty"`

	// Pod: The name of the pod where the command is executed.
	Pod string `json:"pod,omitempty"`

	// PodNamespace: The namespace of the pod where the command is executed.
	PodNamespace string `json:"podNamespace,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Error") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExecuteAirflowCommandResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteAirflowCommandResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExitInfo: Information about how a command ended.
type ExitInfo struct {
	// Error: Error message. Empty if there was no error.
	Error string `json:"error,omitempty"`

	// ExitCode: The exit code from the command execution.
	ExitCode int64 `json:"exitCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Error") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExitInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ExitInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FetchDatabasePropertiesResponse: Response for
// FetchDatabasePropertiesRequest.
type FetchDatabasePropertiesResponse struct {
	// IsFailoverReplicaAvailable: The availability status of the failover
	// replica. A false status indicates that the failover replica is out of
	// sync. The primary instance can only fail over to the failover replica
	// when the status is true.
	IsFailoverReplicaAvailable bool `json:"isFailoverReplicaAvailable,omitempty"`

	// PrimaryGceZone: The Compute Engine zone that the instance is
	// currently serving from.
	PrimaryGceZone string `json:"primaryGceZone,omitempty"`

	// SecondaryGceZone: The Compute Engine zone that the failover instance
	// is currently serving from for a regional Cloud SQL instance.
	SecondaryGceZone string `json:"secondaryGceZone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "IsFailoverReplicaAvailable") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "IsFailoverReplicaAvailable") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FetchDatabasePropertiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FetchDatabasePropertiesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IPAllocationPolicy: Configuration for controlling how IPs are
// allocated in the GKE cluster running the Apache Airflow software.
type IPAllocationPolicy struct {
	// ClusterIpv4CidrBlock: Optional. The IP address range used to allocate
	// IP addresses to pods in the GKE cluster. For Cloud Composer
	// environments in versions composer-1.*.*-airflow-*.*.*, this field is
	// applicable only when `use_ip_aliases` is true. Set to blank to have
	// GKE choose a range with the default size. Set to /netmask (e.g.
	// `/14`) to have GKE choose a range with a specific netmask. Set to a
	// CIDR (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks
	// (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a
	// specific range to use.
	ClusterIpv4CidrBlock string `json:"clusterIpv4CidrBlock,omitempty"`

	// ClusterSecondaryRangeName: Optional. The name of the GKE cluster's
	// secondary range used to allocate IP addresses to pods. For Cloud
	// Composer environments in versions composer-1.*.*-airflow-*.*.*, this
	// field is applicable only when `use_ip_aliases` is true.
	ClusterSecondaryRangeName string `json:"clusterSecondaryRangeName,omitempty"`

	// ServicesIpv4CidrBlock: Optional. The IP address range of the services
	// IP addresses in this GKE cluster. For Cloud Composer environments in
	// versions composer-1.*.*-airflow-*.*.*, this field is applicable only
	// when `use_ip_aliases` is true. Set to blank to have GKE choose a
	// range with the default size. Set to /netmask (e.g. `/14`) to have GKE
	// choose a range with a specific netmask. Set to a CIDR
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks
	// (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a
	// specific range to use.
	ServicesIpv4CidrBlock string `json:"servicesIpv4CidrBlock,omitempty"`

	// ServicesSecondaryRangeName: Optional. The name of the services'
	// secondary range used to allocate IP addresses to the GKE cluster. For
	// Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
	// this field is applicable only when `use_ip_aliases` is true.
	ServicesSecondaryRangeName string `json:"servicesSecondaryRangeName,omitempty"`

	// UseIpAliases: Optional. Whether or not to enable Alias IPs in the GKE
	// cluster. If `true`, a VPC-native cluster is created. This field is
	// only supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*. Environments in newer versions always
	// use VPC-native GKE clusters.
	UseIpAliases bool `json:"useIpAliases,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ClusterIpv4CidrBlock") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClusterIpv4CidrBlock") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IPAllocationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod IPAllocationPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImageVersion: ImageVersion information
type ImageVersion struct {
	// CreationDisabled: Whether it is impossible to create an environment
	// with the image version.
	CreationDisabled bool `json:"creationDisabled,omitempty"`

	// ImageVersionId: The string identifier of the ImageVersion, in the
	// form: "composer-x.y.z-airflow-a.b.c"
	ImageVersionId string `json:"imageVersionId,omitempty"`

	// IsDefault: Whether this is the default ImageVersion used by Composer
	// during environment creation if no input ImageVersion is specified.
	IsDefault bool `json:"isDefault,omitempty"`

	// ReleaseDate: The date of the version release.
	ReleaseDate *Date `json:"releaseDate,omitempty"`

	// SupportedPythonVersions: supported python versions
	SupportedPythonVersions []string `json:"supportedPythonVersions,omitempty"`

	// UpgradeDisabled: Whether it is impossible to upgrade an environment
	// running with the image version.
	UpgradeDisabled bool `json:"upgradeDisabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreationDisabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationDisabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ImageVersion) MarshalJSON() ([]byte, error) {
	type NoMethod ImageVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Line: Contains information about a single line from logs.
type Line struct {
	// Content: Text content of the log line.
	Content string `json:"content,omitempty"`

	// LineNumber: Number of the line.
	LineNumber int64 `json:"lineNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Line) MarshalJSON() ([]byte, error) {
	type NoMethod Line
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListEnvironmentsResponse: The environments in a project and location.
type ListEnvironmentsResponse struct {
	// Environments: The list of environments returned by a
	// ListEnvironmentsRequest.
	Environments []*Environment `json:"environments,omitempty"`

	// NextPageToken: The page token used to query for the next page if one
	// exists.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Environments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListEnvironmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEnvironmentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListImageVersionsResponse: The ImageVersions in a project and
// location.
type ListImageVersionsResponse struct {
	// ImageVersions: The list of supported ImageVersions in a location.
	ImageVersions []*ImageVersion `json:"imageVersions,omitempty"`

	// NextPageToken: The page token used to query for the next page if one
	// exists.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ImageVersions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageVersions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListImageVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListImageVersionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for
// Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LoadSnapshotRequest: Request to load a snapshot into a Cloud Composer
// environment.
type LoadSnapshotRequest struct {
	// SkipAirflowOverridesSetting: Whether or not to skip setting Airflow
	// overrides when loading the environment's state.
	SkipAirflowOverridesSetting bool `json:"skipAirflowOverridesSetting,omitempty"`

	// SkipEnvironmentVariablesSetting: Whether or not to skip setting
	// environment variables when loading the environment's state.
	SkipEnvironmentVariablesSetting bool `json:"skipEnvironmentVariablesSetting,omitempty"`

	// SkipGcsDataCopying: Whether or not to skip copying Cloud Storage data
	// when loading the environment's state.
	SkipGcsDataCopying bool `json:"skipGcsDataCopying,omitempty"`

	// SkipPypiPackagesInstallation: Whether or not to skip installing Pypi
	// packages when loading the environment's state.
	SkipPypiPackagesInstallation bool `json:"skipPypiPackagesInstallation,omitempty"`

	// SnapshotPath: A Cloud Storage path to a snapshot to load, e.g.:
	// "gs://my-bucket/snapshots/project_location_environment_timestamp".
	SnapshotPath string `json:"snapshotPath,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SkipAirflowOverridesSetting") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SkipAirflowOverridesSetting") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LoadSnapshotRequest) MarshalJSON() ([]byte, error) {
	type NoMethod LoadSnapshotRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LoadSnapshotResponse: Response to LoadSnapshotRequest.
type LoadSnapshotResponse struct {
}

// MaintenanceWindow: The configuration settings for Cloud Composer
// maintenance window. The following example: ``` {
// "startTime":"2019-08-01T01:00:00Z" "endTime":"2019-08-01T07:00:00Z"
// "recurrence":"FREQ=WEEKLY;BYDAY=TU,WE" } ``` would define a
// maintenance window between 01 and 07 hours UTC during each Tuesday
// and Wednesday.
type MaintenanceWindow struct {
	// EndTime: Required. Maintenance window end time. It is used only to
	// calculate the duration of the maintenance window. The value for
	// end-time must be in the future, relative to `start_time`.
	EndTime string `json:"endTime,omitempty"`

	// Recurrence: Required. Maintenance window recurrence. Format is a
	// subset of RFC-5545 (https://tools.ietf.org/html/rfc5545) `RRULE`. The
	// only allowed values for `FREQ` field are `FREQ=DAILY` and
	// `FREQ=WEEKLY;BYDAY=...` Example values: `FREQ=WEEKLY;BYDAY=TU,WE`,
	// `FREQ=DAILY`.
	Recurrence string `json:"recurrence,omitempty"`

	// StartTime: Required. Start time of the first recurrence of the
	// maintenance window.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MaintenanceWindow) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenanceWindow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MasterAuthorizedNetworksConfig: Configuration options for the master
// authorized networks feature. Enabled master authorized networks will
// disallow all external traffic to access Kubernetes master through
// HTTPS except traffic from the given CIDR blocks, Google Compute
// Engine Public IPs and Google Prod IPs.
type MasterAuthorizedNetworksConfig struct {
	// CidrBlocks: Up to 50 external networks that could access Kubernetes
	// master through HTTPS.
	CidrBlocks []*CidrBlock `json:"cidrBlocks,omitempty"`

	// Enabled: Whether or not master authorized networks feature is
	// enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CidrBlocks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CidrBlocks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MasterAuthorizedNetworksConfig) MarshalJSON() ([]byte, error) {
	type NoMethod MasterAuthorizedNetworksConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NetworkingConfig: Configuration options for networking connections in
// the Composer 2 environment.
type NetworkingConfig struct {
	// ConnectionType: Optional. Indicates the user requested specifc
	// connection type between Tenant and Customer projects. You cannot set
	// networking connection type in public IP environment.
	//
	// Possible values:
	//   "CONNECTION_TYPE_UNSPECIFIED" - No specific connection type was
	// requested, so the environment uses the default value corresponding to
	// the rest of its configuration.
	//   "VPC_PEERING" - Requests the use of VPC peerings for connecting the
	// Customer and Tenant projects.
	//   "PRIVATE_SERVICE_CONNECT" - Requests the use of Private Service
	// Connect for connecting the Customer and Tenant projects.
	ConnectionType string `json:"connectionType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConnectionType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectionType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *NetworkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NodeConfig: The configuration information for the Kubernetes Engine
// nodes running the Apache Airflow software.
type NodeConfig struct {
	// DiskSizeGb: Optional. The disk size in GB used for node VMs. Minimum
	// size is 30GB. If unspecified, defaults to 100GB. Cannot be updated.
	// This field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty"`

	// EnableIpMasqAgent: Optional. Deploys 'ip-masq-agent' daemon set in
	// the GKE cluster and defines nonMasqueradeCIDRs equals to pod IP range
	// so IP masquerading is used for all destination addresses, except
	// between pods traffic. See:
	// https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
	EnableIpMasqAgent bool `json:"enableIpMasqAgent,omitempty"`

	// IpAllocationPolicy: Optional. The configuration for controlling how
	// IPs are allocated in the GKE cluster.
	IpAllocationPolicy *IPAllocationPolicy `json:"ipAllocationPolicy,omitempty"`

	// Location: Optional. The Compute Engine zone
	// (/compute/docs/regions-zones) in which to deploy the VMs used to run
	// the Apache Airflow software, specified as a relative resource name
	// (/apis/design/resource_names#relative_resource_name). For example:
	// "projects/{projectId}/zones/{zoneId}". This `location` must belong to
	// the enclosing environment's project and location. If both this field
	// and `nodeConfig.machineType` are specified, `nodeConfig.machineType`
	// must belong to this `location`; if both are unspecified, the service
	// will pick a zone in the Compute Engine region corresponding to the
	// Cloud Composer location, and propagate that choice to both fields. If
	// only one field (`location` or `nodeConfig.machineType`) is specified,
	// the location information from the specified field will be propagated
	// to the unspecified field. This field is supported for Cloud Composer
	// environments in versions composer-1.*.*-airflow-*.*.*.
	Location string `json:"location,omitempty"`

	// MachineType: Optional. The Compute Engine machine type
	// (/compute/docs/machine-types) used for cluster instances, specified
	// as a relative resource name
	// (/apis/design/resource_names#relative_resource_name). For example:
	// "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}".
	// The `machineType` must belong to the enclosing environment's project
	// and location. If both this field and `nodeConfig.location` are
	// specified, this `machineType` must belong to the
	// `nodeConfig.location`; if both are unspecified, the service will pick
	// a zone in the Compute Engine region corresponding to the Cloud
	// Composer location, and propagate that choice to both fields. If
	// exactly one of this field and `nodeConfig.location` is specified, the
	// location information from the specified field will be propagated to
	// the unspecified field. The `machineTypeId` must not be a shared-core
	// machine type (/compute/docs/machine-types#sharedcore). If this field
	// is unspecified, the `machineTypeId` defaults to "n1-standard-1". This
	// field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	MachineType string `json:"machineType,omitempty"`

	// Network: Optional. The Compute Engine network to be used for machine
	// communications, specified as a relative resource name
	// (/apis/design/resource_names#relative_resource_name). For example:
	// "projects/{projectId}/global/networks/{networkId}". If unspecified,
	// the "default" network ID in the environment's project is used. If a
	// Custom Subnet Network (/vpc/docs/vpc#vpc_networks_and_subnets) is
	// provided, `nodeConfig.subnetwork` must also be provided. For Shared
	// VPC (/vpc/docs/shared-vpc) subnetwork requirements, see
	// `nodeConfig.subnetwork`.
	Network string `json:"network,omitempty"`

	// OauthScopes: Optional. The set of Google API scopes to be made
	// available on all node VMs. If `oauth_scopes` is empty, defaults to
	// ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be
	// updated. This field is supported for Cloud Composer environments in
	// versions composer-1.*.*-airflow-*.*.*.
	OauthScopes []string `json:"oauthScopes,omitempty"`

	// ServiceAccount: Optional. The Google Cloud Platform Service Account
	// to be used by the node VMs. If a service account is not specified,
	// the "default" Compute Engine service account is used. Cannot be
	// updated.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// Subnetwork: Optional. The Compute Engine subnetwork to be used for
	// machine communications, specified as a relative resource name
	// (/apis/design/resource_names#relative_resource_name). For example:
	// "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}"
	// If a subnetwork is provided, `nodeConfig.network` must also be
	// provided, and the subnetwork must belong to the enclosing
	// environment's project and location.
	Subnetwork string `json:"subnetwork,omitempty"`

	// Tags: Optional. The list of instance tags applied to all node VMs.
	// Tags are used to identify valid sources or targets for network
	// firewalls. Each tag within the list must comply with RFC1035
	// (https://www.ietf.org/rfc/rfc1035.txt). Cannot be updated.
	Tags []string `json:"tags,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiskSizeGb") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskSizeGb") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NodeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Metadata describing an operation.
type OperationMetadata struct {
	// CreateTime: Output only. The time the operation was submitted to the
	// server.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time when the operation terminated,
	// regardless of its success. This field is unset if the operation is
	// still ongoing.
	EndTime string `json:"endTime,omitempty"`

	// OperationType: Output only. The type of operation being performed.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unused.
	//   "CREATE" - A resource creation operation.
	//   "DELETE" - A resource deletion operation.
	//   "UPDATE" - A resource update operation.
	//   "CHECK" - A resource check operation.
	//   "SAVE_SNAPSHOT" - Saves snapshot of the resource operation.
	//   "LOAD_SNAPSHOT" - Loads snapshot of the resource operation.
	//   "DATABASE_FAILOVER" - Triggers failover of environment's Cloud SQL
	// instance (only for highly resilient environments).
	OperationType string `json:"operationType,omitempty"`

	// Resource: Output only. The resource being operated on, as a relative
	// resource name ( /apis/design/resource_names#relative_resource_name).
	Resource string `json:"resource,omitempty"`

	// ResourceUuid: Output only. The UUID of the resource being operated
	// on.
	ResourceUuid string `json:"resourceUuid,omitempty"`

	// State: Output only. The current operation state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unused.
	//   "PENDING" - The operation has been created but is not yet started.
	//   "RUNNING" - The operation is underway.
	//   "SUCCEEDED" - The operation completed successfully.
	//   "SUCCESSFUL"
	//   "FAILED" - The operation is no longer running but did not succeed.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PollAirflowCommandRequest: Poll Airflow Command request.
type PollAirflowCommandRequest struct {
	// ExecutionId: The unique ID of the command execution.
	ExecutionId string `json:"executionId,omitempty"`

	// NextLineNumber: Line number from which new logs should be fetched.
	NextLineNumber int64 `json:"nextLineNumber,omitempty"`

	// Pod: The name of the pod where the command is executed.
	Pod string `json:"pod,omitempty"`

	// PodNamespace: The namespace of the pod where the command is executed.
	PodNamespace string `json:"podNamespace,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExecutionId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PollAirflowCommandRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PollAirflowCommandRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PollAirflowCommandResponse: Response to PollAirflowCommandRequest.
type PollAirflowCommandResponse struct {
	// ExitInfo: The result exit status of the command.
	ExitInfo *ExitInfo `json:"exitInfo,omitempty"`

	// Output: Output from the command execution. It may not contain the
	// full output and the caller may need to poll for more lines.
	Output []*Line `json:"output,omitempty"`

	// OutputEnd: Whether the command execution has finished and there is no
	// more output.
	OutputEnd bool `json:"outputEnd,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExitInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExitInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PollAirflowCommandResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PollAirflowCommandResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrivateClusterConfig: Configuration options for the private GKE
// cluster in a Cloud Composer environment.
type PrivateClusterConfig struct {
	// EnablePrivateEndpoint: Optional. If `true`, access to the public
	// endpoint of the GKE cluster is denied.
	EnablePrivateEndpoint bool `json:"enablePrivateEndpoint,omitempty"`

	// MasterIpv4CidrBlock: Optional. The CIDR block from which IPv4 range
	// for GKE master will be reserved. If left blank, the default value of
	// '172.16.0.0/23' is used.
	MasterIpv4CidrBlock string `json:"masterIpv4CidrBlock,omitempty"`

	// MasterIpv4ReservedRange: Output only. The IP range in CIDR notation
	// to use for the hosted master network. This range is used for
	// assigning internal IP addresses to the GKE cluster master or set of
	// masters and to the internal load balancer virtual IP. This range must
	// not overlap with any other ranges in use within the cluster's
	// network.
	MasterIpv4ReservedRange string `json:"masterIpv4ReservedRange,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnablePrivateEndpoint") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnablePrivateEndpoint") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PrivateClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateClusterConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrivateEnvironmentConfig: The configuration information for
// configuring a Private IP Cloud Composer environment.
type PrivateEnvironmentConfig struct {
	// CloudComposerConnectionSubnetwork: Optional. When specified, the
	// environment will use Private Service Connect instead of VPC peerings
	// to connect to Cloud SQL in the Tenant Project, and the PSC endpoint
	// in the Customer Project will use an IP address from this subnetwork.
	CloudComposerConnectionSubnetwork string `json:"cloudComposerConnectionSubnetwork,omitempty"`

	// CloudComposerNetworkIpv4CidrBlock: Optional. The CIDR block from
	// which IP range for Cloud Composer Network in tenant project will be
	// reserved. Needs to be disjoint from
	// private_cluster_config.master_ipv4_cidr_block and
	// cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer
	// environments in versions composer-2.*.*-airflow-*.*.* and newer.
	CloudComposerNetworkIpv4CidrBlock string `json:"cloudComposerNetworkIpv4CidrBlock,omitempty"`

	// CloudComposerNetworkIpv4ReservedRange: Output only. The IP range
	// reserved for the tenant project's Cloud Composer network. This field
	// is supported for Cloud Composer environments in versions
	// composer-2.*.*-airflow-*.*.* and newer.
	CloudComposerNetworkIpv4ReservedRange string `json:"cloudComposerNetworkIpv4ReservedRange,omitempty"`

	// CloudSqlIpv4CidrBlock: Optional. The CIDR block from which IP range
	// in tenant project will be reserved for Cloud SQL. Needs to be
	// disjoint from `web_server_ipv4_cidr_block`.
	CloudSqlIpv4CidrBlock string `json:"cloudSqlIpv4CidrBlock,omitempty"`

	// EnablePrivateEnvironment: Optional. If `true`, a Private IP Cloud
	// Composer environment is created. If this field is set to true,
	// `IPAllocationPolicy.use_ip_aliases` must be set to true for Cloud
	// Composer environments in versions composer-1.*.*-airflow-*.*.*.
	EnablePrivateEnvironment bool `json:"enablePrivateEnvironment,omitempty"`

	// EnablePrivatelyUsedPublicIps: Optional. When enabled, IPs from public
	// (non-RFC1918) ranges can be used for
	// `IPAllocationPolicy.cluster_ipv4_cidr_block` and
	// `IPAllocationPolicy.service_ipv4_cidr_block`.
	EnablePrivatelyUsedPublicIps bool `json:"enablePrivatelyUsedPublicIps,omitempty"`

	// NetworkingConfig: Optional. Configuration for the network connections
	// configuration in the environment.
	NetworkingConfig *NetworkingConfig `json:"networkingConfig,omitempty"`

	// PrivateClusterConfig: Optional. Configuration for the private GKE
	// cluster for a Private IP Cloud Composer environment.
	PrivateClusterConfig *PrivateClusterConfig `json:"privateClusterConfig,omitempty"`

	// WebServerIpv4CidrBlock: Optional. The CIDR block from which IP range
	// for web server will be reserved. Needs to be disjoint from
	// `private_cluster_config.master_ipv4_cidr_block` and
	// `cloud_sql_ipv4_cidr_block`. This field is supported for Cloud
	// Composer environments in versions composer-1.*.*-airflow-*.*.*.
	WebServerIpv4CidrBlock string `json:"webServerIpv4CidrBlock,omitempty"`

	// WebServerIpv4ReservedRange: Output only. The IP range reserved for
	// the tenant project's App Engine VMs. This field is supported for
	// Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
	WebServerIpv4ReservedRange string `json:"webServerIpv4ReservedRange,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CloudComposerConnectionSubnetwork") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CloudComposerConnectionSubnetwork") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PrivateEnvironmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateEnvironmentConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RecoveryConfig: The Recovery settings of an environment.
type RecoveryConfig struct {
	// ScheduledSnapshotsConfig: Optional. The configuration for scheduled
	// snapshot creation mechanism.
	ScheduledSnapshotsConfig *ScheduledSnapshotsConfig `json:"scheduledSnapshotsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ScheduledSnapshotsConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ScheduledSnapshotsConfig")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RecoveryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RecoveryConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SaveSnapshotRequest: Request to create a snapshot of a Cloud Composer
// environment.
type SaveSnapshotRequest struct {
	// SnapshotLocation: Location in a Cloud Storage where the snapshot is
	// going to be stored, e.g.: "gs://my-bucket/snapshots".
	SnapshotLocation string `json:"snapshotLocation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SnapshotLocation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SnapshotLocation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SaveSnapshotRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SaveSnapshotRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SaveSnapshotResponse: Response to SaveSnapshotRequest.
type SaveSnapshotResponse struct {
	// SnapshotPath: The fully-resolved Cloud Storage path of the created
	// snapshot, e.g.:
	// "gs://my-bucket/snapshots/project_location_environment_timestamp".
	// This field is populated only if the snapshot creation was successful.
	SnapshotPath string `json:"snapshotPath,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SnapshotPath") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SnapshotPath") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SaveSnapshotResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SaveSnapshotResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ScheduledSnapshotsConfig: The configuration for scheduled snapshot
// creation mechanism.
type ScheduledSnapshotsConfig struct {
	// Enabled: Optional. Whether scheduled snapshots creation is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// SnapshotCreationSchedule: Optional. The cron expression representing
	// the time when snapshots creation mechanism runs. This field is
	// subject to additional validation around frequency of execution.
	SnapshotCreationSchedule string `json:"snapshotCreationSchedule,omitempty"`

	// SnapshotLocation: Optional. The Cloud Storage location for storing
	// automatically created snapshots.
	SnapshotLocation string `json:"snapshotLocation,omitempty"`

	// TimeZone: Optional. Time zone that sets the context to interpret
	// snapshot_creation_schedule.
	TimeZone string `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ScheduledSnapshotsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ScheduledSnapshotsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SchedulerResource: Configuration for resources used by Airflow
// schedulers.
type SchedulerResource struct {
	// Count: Optional. The number of schedulers.
	Count int64 `json:"count,omitempty"`

	// Cpu: Optional. CPU request and limit for a single Airflow scheduler
	// replica.
	Cpu float64 `json:"cpu,omitempty"`

	// MemoryGb: Optional. Memory (GB) request and limit for a single
	// Airflow scheduler replica.
	MemoryGb float64 `json:"memoryGb,omitempty"`

	// StorageGb: Optional. Storage (GB) request and limit for a single
	// Airflow scheduler replica.
	StorageGb float64 `json:"storageGb,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SchedulerResource) MarshalJSON() ([]byte, error) {
	type NoMethod SchedulerResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *SchedulerResource) UnmarshalJSON(data []byte) error {
	type NoMethod SchedulerResource
	var s1 struct {
		Cpu       gensupport.JSONFloat64 `json:"cpu"`
		MemoryGb  gensupport.JSONFloat64 `json:"memoryGb"`
		StorageGb gensupport.JSONFloat64 `json:"storageGb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cpu = float64(s1.Cpu)
	s.MemoryGb = float64(s1.MemoryGb)
	s.StorageGb = float64(s1.StorageGb)
	return nil
}

// SoftwareConfig: Specifies the selection and configuration of software
// inside the environment.
type SoftwareConfig struct {
	// AirflowConfigOverrides: Optional. Apache Airflow configuration
	// properties to override. Property keys contain the section and
	// property names, separated by a hyphen, for example
	// "core-dags_are_paused_at_creation". Section names must not contain
	// hyphens ("-"), opening square brackets ("["), or closing square
	// brackets ("]"). The property name must not be empty and must not
	// contain an equals sign ("=") or semicolon (";"). Section and property
	// names must not contain a period ("."). Apache Airflow configuration
	// property names must be written in snake_case
	// (https://en.wikipedia.org/wiki/Snake_case). Property values can
	// contain any character, and can be written in any lower/upper case
	// format. Certain Apache Airflow configuration property values are
	// blocked (/composer/docs/concepts/airflow-configurations), and cannot
	// be overridden.
	AirflowConfigOverrides map[string]string `json:"airflowConfigOverrides,omitempty"`

	// EnvVariables: Optional. Additional environment variables to provide
	// to the Apache Airflow scheduler, worker, and webserver processes.
	// Environment variable names must match the regular expression
	// `a-zA-Z_*`. They cannot specify Apache Airflow software configuration
	// overrides (they cannot match the regular expression
	// `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
	// following reserved names: * `AIRFLOW_HOME` * `C_FORCE_ROOT` *
	// `CONTAINER_NAME` * `DAGS_FOLDER` * `GCP_PROJECT` * `GCS_BUCKET` *
	// `GKE_CLUSTER_NAME` * `SQL_DATABASE` * `SQL_INSTANCE` * `SQL_PASSWORD`
	// * `SQL_PROJECT` * `SQL_REGION` * `SQL_USER`
	EnvVariables map[string]string `json:"envVariables,omitempty"`

	// ImageVersion: The version of the software running in the environment.
	// This encapsulates both the version of Cloud Composer functionality
	// and the version of Apache Airflow. It must match the regular
	// expression
	// `composer-([0-9]+(\.[0-9]+\.[0-9]+(-preview\.[0-9]+)?)?|latest)-airflo
	// w-([0-9]+(\.[0-9]+(\.[0-9]+)?)?)`. When used as input, the server
	// also checks if the provided version is supported and denies the
	// request for an unsupported version. The Cloud Composer portion of the
	// image version is a full semantic version (https://semver.org), or an
	// alias in the form of major version number or `latest`. When an alias
	// is provided, the server replaces it with the current Cloud Composer
	// version that satisfies the alias. The Apache Airflow portion of the
	// image version is a full semantic version that points to one of the
	// supported Apache Airflow versions, or an alias in the form of only
	// major or major.minor versions specified. When an alias is provided,
	// the server replaces it with the latest Apache Airflow version that
	// satisfies the alias and is supported in the given Cloud Composer
	// version. In all cases, the resolved image version is stored in the
	// same field. See also version list
	// (/composer/docs/concepts/versioning/composer-versions) and versioning
	// overview
	// (/composer/docs/concepts/versioning/composer-versioning-overview).
	ImageVersion string `json:"imageVersion,omitempty"`

	// PypiPackages: Optional. Custom Python Package Index (PyPI) packages
	// to be installed in the environment. Keys refer to the lowercase
	// package name such as "numpy" and values are the lowercase extras and
	// version specifier such as "==1.12.0", "[devel,gcp_api]", or
	// "[devel]>=1.8.2, <1.9.2". To specify a package without pinning it to
	// a version specifier, use the empty string as the value.
	PypiPackages map[string]string `json:"pypiPackages,omitempty"`

	// PythonVersion: Optional. The major version of Python used to run the
	// Apache Airflow scheduler, worker, and webserver processes. Can be set
	// to '2' or '3'. If not specified, the default is '3'. Cannot be
	// updated. This field is only supported for Cloud Composer environments
	// in versions composer-1.*.*-airflow-*.*.*. Environments in newer
	// versions always use Python major version 3.
	PythonVersion string `json:"pythonVersion,omitempty"`

	// SchedulerCount: Optional. The number of schedulers for Airflow. This
	// field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-2.*.*.
	SchedulerCount int64 `json:"schedulerCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AirflowConfigOverrides") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AirflowConfigOverrides")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SoftwareConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SoftwareConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StopAirflowCommandRequest: Stop Airflow Command request.
type StopAirflowCommandRequest struct {
	// ExecutionId: The unique ID of the command execution.
	ExecutionId string `json:"executionId,omitempty"`

	// Force: If true, the execution is terminated forcefully (SIGKILL). If
	// false, the execution is stopped gracefully, giving it time for
	// cleanup.
	Force bool `json:"force,omitempty"`

	// Pod: The name of the pod where the command is executed.
	Pod string `json:"pod,omitempty"`

	// PodNamespace: The namespace of the pod where the command is executed.
	PodNamespace string `json:"podNamespace,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExecutionId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StopAirflowCommandRequest) MarshalJSON() ([]byte, error) {
	type NoMethod StopAirflowCommandRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StopAirflowCommandResponse: Response to StopAirflowCommandRequest.
type StopAirflowCommandResponse struct {
	// IsDone: Whether the execution is still running.
	IsDone bool `json:"isDone,omitempty"`

	// Output: Output message from stopping execution request.
	Output []string `json:"output,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "IsDone") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsDone") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StopAirflowCommandResponse) MarshalJSON() ([]byte, error) {
	type NoMethod StopAirflowCommandResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WebServerConfig: The configuration settings for the Airflow web
// server App Engine instance. Supported for Cloud Composer environments
// in versions composer-1.*.*-airflow-*.*.*
type WebServerConfig struct {
	// MachineType: Optional. Machine type on which Airflow web server is
	// running. It has to be one of: composer-n1-webserver-2,
	// composer-n1-webserver-4 or composer-n1-webserver-8. If not specified,
	// composer-n1-webserver-2 will be used. Value custom is returned only
	// in response, if Airflow web server parameters were manually changed
	// to a non-standard values.
	MachineType string `json:"machineType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MachineType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MachineType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WebServerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WebServerConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WebServerNetworkAccessControl: Network-level access control policy
// for the Airflow web server.
type WebServerNetworkAccessControl struct {
	// AllowedIpRanges: A collection of allowed IP ranges with descriptions.
	AllowedIpRanges []*AllowedIpRange `json:"allowedIpRanges,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowedIpRanges") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowedIpRanges") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *WebServerNetworkAccessControl) MarshalJSON() ([]byte, error) {
	type NoMethod WebServerNetworkAccessControl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WebServerResource: Configuration for resources used by Airflow web
// server.
type WebServerResource struct {
	// Cpu: Optional. CPU request and limit for Airflow web server.
	Cpu float64 `json:"cpu,omitempty"`

	// MemoryGb: Optional. Memory (GB) request and limit for Airflow web
	// server.
	MemoryGb float64 `json:"memoryGb,omitempty"`

	// StorageGb: Optional. Storage (GB) request and limit for Airflow web
	// server.
	StorageGb float64 `json:"storageGb,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cpu") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cpu") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WebServerResource) MarshalJSON() ([]byte, error) {
	type NoMethod WebServerResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *WebServerResource) UnmarshalJSON(data []byte) error {
	type NoMethod WebServerResource
	var s1 struct {
		Cpu       gensupport.JSONFloat64 `json:"cpu"`
		MemoryGb  gensupport.JSONFloat64 `json:"memoryGb"`
		StorageGb gensupport.JSONFloat64 `json:"storageGb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cpu = float64(s1.Cpu)
	s.MemoryGb = float64(s1.MemoryGb)
	s.StorageGb = float64(s1.StorageGb)
	return nil
}

// WorkerResource: Configuration for resources used by Airflow workers.
type WorkerResource struct {
	// Cpu: Optional. CPU request and limit for a single Airflow worker
	// replica.
	Cpu float64 `json:"cpu,omitempty"`

	// MaxCount: Optional. Maximum number of workers for autoscaling.
	MaxCount int64 `json:"maxCount,omitempty"`

	// MemoryGb: Optional. Memory (GB) request and limit for a single
	// Airflow worker replica.
	MemoryGb float64 `json:"memoryGb,omitempty"`

	// MinCount: Optional. Minimum number of workers for autoscaling.
	MinCount int64 `json:"minCount,omitempty"`

	// StorageGb: Optional. Storage (GB) request and limit for a single
	// Airflow worker replica.
	StorageGb float64 `json:"storageGb,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cpu") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cpu") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WorkerResource) MarshalJSON() ([]byte, error) {
	type NoMethod WorkerResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *WorkerResource) UnmarshalJSON(data []byte) error {
	type NoMethod WorkerResource
	var s1 struct {
		Cpu       gensupport.JSONFloat64 `json:"cpu"`
		MemoryGb  gensupport.JSONFloat64 `json:"memoryGb"`
		StorageGb gensupport.JSONFloat64 `json:"storageGb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cpu = float64(s1.Cpu)
	s.MemoryGb = float64(s1.MemoryGb)
	s.StorageGb = float64(s1.StorageGb)
	return nil
}

// WorkloadsConfig: The Kubernetes workloads configuration for GKE
// cluster associated with the Cloud Composer environment. Supported for
// Cloud Composer environments in versions composer-2.*.*-airflow-*.*.*
// and newer.
type WorkloadsConfig struct {
	// Scheduler: Optional. Resources used by Airflow schedulers.
	Scheduler *SchedulerResource `json:"scheduler,omitempty"`

	// WebServer: Optional. Resources used by Airflow web server.
	WebServer *WebServerResource `json:"webServer,omitempty"`

	// Worker: Optional. Resources used by Airflow workers.
	Worker *WorkerResource `json:"worker,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Scheduler") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Scheduler") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WorkloadsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WorkloadsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "composer.projects.locations.environments.create":

type ProjectsLocationsEnvironmentsCreateCall struct {
	s           *Service
	parent      string
	environment *Environment
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Create a new environment.
//
//   - parent: The parent must be of the form
//     "projects/{projectId}/locations/{locationId}".
func (r *ProjectsLocationsEnvironmentsService) Create(parent string, environment *Environment) *ProjectsLocationsEnvironmentsCreateCall {
	c := &ProjectsLocationsEnvironmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.environment = environment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsCreateCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.environment)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/environments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a new environment.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments",
	//   "httpMethod": "POST",
	//   "id": "composer.projects.locations.environments.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The parent must be of the form \"projects/{projectId}/locations/{locationId}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/environments",
	//   "request": {
	//     "$ref": "Environment"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.databaseFailover":

type ProjectsLocationsEnvironmentsDatabaseFailoverCall struct {
	s                       *Service
	environment             string
	databasefailoverrequest *DatabaseFailoverRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// DatabaseFailover: Triggers database failover (only for highly
// resilient environments).
//
//   - environment: Target environment:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) DatabaseFailover(environment string, databasefailoverrequest *DatabaseFailoverRequest) *ProjectsLocationsEnvironmentsDatabaseFailoverCall {
	c := &ProjectsLocationsEnvironmentsDatabaseFailoverCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.environment = environment
	c.databasefailoverrequest = databasefailoverrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsDatabaseFailoverCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsDatabaseFailoverCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsDatabaseFailoverCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsDatabaseFailoverCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsDatabaseFailoverCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsDatabaseFailoverCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.databasefailoverrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+environment}:databaseFailover")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"environment": c.environment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.databaseFailover" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsDatabaseFailoverCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Triggers database failover (only for highly resilient environments).",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}:databaseFailover",
	//   "httpMethod": "POST",
	//   "id": "composer.projects.locations.environments.databaseFailover",
	//   "parameterOrder": [
	//     "environment"
	//   ],
	//   "parameters": {
	//     "environment": {
	//       "description": "Target environment: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+environment}:databaseFailover",
	//   "request": {
	//     "$ref": "DatabaseFailoverRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.delete":

type ProjectsLocationsEnvironmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an environment.
//
//   - name: The environment to delete, in the form:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) Delete(name string) *ProjectsLocationsEnvironmentsDeleteCall {
	c := &ProjectsLocationsEnvironmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Delete an environment.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}",
	//   "httpMethod": "DELETE",
	//   "id": "composer.projects.locations.environments.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The environment to delete, in the form: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.executeAirflowCommand":

type ProjectsLocationsEnvironmentsExecuteAirflowCommandCall struct {
	s                            *Service
	environment                  string
	executeairflowcommandrequest *ExecuteAirflowCommandRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// ExecuteAirflowCommand: Executes Airflow CLI command.
//
//   - environment: The resource name of the environment in the form:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) ExecuteAirflowCommand(environment string, executeairflowcommandrequest *ExecuteAirflowCommandRequest) *ProjectsLocationsEnvironmentsExecuteAirflowCommandCall {
	c := &ProjectsLocationsEnvironmentsExecuteAirflowCommandCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.environment = environment
	c.executeairflowcommandrequest = executeairflowcommandrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsExecuteAirflowCommandCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsExecuteAirflowCommandCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsExecuteAirflowCommandCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsExecuteAirflowCommandCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsExecuteAirflowCommandCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsExecuteAirflowCommandCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.executeairflowcommandrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+environment}:executeAirflowCommand")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"environment": c.environment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.executeAirflowCommand" call.
// Exactly one of *ExecuteAirflowCommandResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ExecuteAirflowCommandResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsExecuteAirflowCommandCall) Do(opts ...googleapi.CallOption) (*ExecuteAirflowCommandResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExecuteAirflowCommandResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Executes Airflow CLI command.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}:executeAirflowCommand",
	//   "httpMethod": "POST",
	//   "id": "composer.projects.locations.environments.executeAirflowCommand",
	//   "parameterOrder": [
	//     "environment"
	//   ],
	//   "parameters": {
	//     "environment": {
	//       "description": "The resource name of the environment in the form: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+environment}:executeAirflowCommand",
	//   "request": {
	//     "$ref": "ExecuteAirflowCommandRequest"
	//   },
	//   "response": {
	//     "$ref": "ExecuteAirflowCommandResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.fetchDatabaseProperties":

type ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall struct {
	s            *Service
	environment  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchDatabaseProperties: Fetches database properties.
//
//   - environment: The resource name of the environment, in the form:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) FetchDatabaseProperties(environment string) *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall {
	c := &ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.environment = environment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall) IfNoneMatch(entityTag string) *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+environment}:fetchDatabaseProperties")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"environment": c.environment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.fetchDatabaseProperties" call.
// Exactly one of *FetchDatabasePropertiesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *FetchDatabasePropertiesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsFetchDatabasePropertiesCall) Do(opts ...googleapi.CallOption) (*FetchDatabasePropertiesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FetchDatabasePropertiesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Fetches database properties.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}:fetchDatabaseProperties",
	//   "httpMethod": "GET",
	//   "id": "composer.projects.locations.environments.fetchDatabaseProperties",
	//   "parameterOrder": [
	//     "environment"
	//   ],
	//   "parameters": {
	//     "environment": {
	//       "description": "Required. The resource name of the environment, in the form: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+environment}:fetchDatabaseProperties",
	//   "response": {
	//     "$ref": "FetchDatabasePropertiesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.get":

type ProjectsLocationsEnvironmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get an existing environment.
//
//   - name: The resource name of the environment to get, in the form:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) Get(name string) *ProjectsLocationsEnvironmentsGetCall {
	c := &ProjectsLocationsEnvironmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEnvironmentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsEnvironmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsGetCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.get" call.
// Exactly one of *Environment or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Environment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsGetCall) Do(opts ...googleapi.CallOption) (*Environment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Environment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get an existing environment.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}",
	//   "httpMethod": "GET",
	//   "id": "composer.projects.locations.environments.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the environment to get, in the form: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Environment"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.list":

type ProjectsLocationsEnvironmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List environments.
//
//   - parent: List environments in the given project and location, in the
//     form: "projects/{projectId}/locations/{locationId}".
func (r *ProjectsLocationsEnvironmentsService) List(parent string) *ProjectsLocationsEnvironmentsListCall {
	c := &ProjectsLocationsEnvironmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of environments to return.
func (c *ProjectsLocationsEnvironmentsListCall) PageSize(pageSize int64) *ProjectsLocationsEnvironmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// next_page_token value returned from a previous List request, if any.
func (c *ProjectsLocationsEnvironmentsListCall) PageToken(pageToken string) *ProjectsLocationsEnvironmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEnvironmentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsEnvironmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsListCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/environments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.list" call.
// Exactly one of *ListEnvironmentsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListEnvironmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsListCall) Do(opts ...googleapi.CallOption) (*ListEnvironmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEnvironmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List environments.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments",
	//   "httpMethod": "GET",
	//   "id": "composer.projects.locations.environments.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of environments to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The next_page_token value returned from a previous List request, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "List environments in the given project and location, in the form: \"projects/{projectId}/locations/{locationId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/environments",
	//   "response": {
	//     "$ref": "ListEnvironmentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsEnvironmentsListCall) Pages(ctx context.Context, f func(*ListEnvironmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "composer.projects.locations.environments.loadSnapshot":

type ProjectsLocationsEnvironmentsLoadSnapshotCall struct {
	s                   *Service
	environment         string
	loadsnapshotrequest *LoadSnapshotRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// LoadSnapshot: Loads a snapshot of a Cloud Composer environment. As a
// result of this operation, a snapshot of environment's specified in
// LoadSnapshotRequest is loaded into the environment.
//
//   - environment: The resource name of the target environment in the
//     form:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) LoadSnapshot(environment string, loadsnapshotrequest *LoadSnapshotRequest) *ProjectsLocationsEnvironmentsLoadSnapshotCall {
	c := &ProjectsLocationsEnvironmentsLoadSnapshotCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.environment = environment
	c.loadsnapshotrequest = loadsnapshotrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsLoadSnapshotCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsLoadSnapshotCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsLoadSnapshotCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsLoadSnapshotCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsLoadSnapshotCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsLoadSnapshotCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.loadsnapshotrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+environment}:loadSnapshot")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"environment": c.environment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.loadSnapshot" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsLoadSnapshotCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Loads a snapshot of a Cloud Composer environment. As a result of this operation, a snapshot of environment's specified in LoadSnapshotRequest is loaded into the environment.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}:loadSnapshot",
	//   "httpMethod": "POST",
	//   "id": "composer.projects.locations.environments.loadSnapshot",
	//   "parameterOrder": [
	//     "environment"
	//   ],
	//   "parameters": {
	//     "environment": {
	//       "description": "The resource name of the target environment in the form: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+environment}:loadSnapshot",
	//   "request": {
	//     "$ref": "LoadSnapshotRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.patch":

type ProjectsLocationsEnvironmentsPatchCall struct {
	s           *Service
	name        string
	environment *Environment
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Update an environment.
//
//   - name: The relative resource name of the environment to update, in
//     the form:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) Patch(name string, environment *Environment) *ProjectsLocationsEnvironmentsPatchCall {
	c := &ProjectsLocationsEnvironmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.environment = environment
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of paths, relative to `Environment`, of fields
// to update. For example, to set the version of scikit-learn to install
// in the environment to 0.19.0 and to remove an existing installation
// of numpy, the `updateMask` parameter would include the following two
// `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
// "config.softwareConfig.pypiPackages.numpy". The included patch
// environment would specify the scikit-learn version as follows: {
// "config":{ "softwareConfig":{ "pypiPackages":{
// "scikit-learn":"==0.19.0" } } } } Note that in the above example, any
// existing PyPI packages other than scikit-learn and numpy will be
// unaffected. Only one update type may be included in a single
// request's `updateMask`. For example, one cannot update both the PyPI
// packages and labels in the same request. However, it is possible to
// update multiple members of a map field simultaneously in the same
// request. For example, to set the labels "label1" and "label2" while
// clearing "label3" (assuming it already exists), one can provide the
// paths "labels.label1", "labels.label2", and "labels.label3" and
// populate the patch environment as follows: { "labels":{
// "label1":"new-label1-value" "label2":"new-label2-value" } } Note that
// in the above example, any existing labels that are not included in
// the `updateMask` will be unaffected. It is also possible to replace
// an entire map field by providing the map field's path in the
// `updateMask`. The new value of the field will be that which is
// provided in the patch environment. For example, to delete all
// pre-existing user-specified PyPI packages and install botocore at
// version 1.7.14, the `updateMask` would contain the path
// "config.softwareConfig.pypiPackages", and the patch environment would
// be the following: { "config":{ "softwareConfig":{ "pypiPackages":{
// "botocore":"==1.7.14" } } } } **Note:** Only the following fields can
// be updated: * `config.softwareConfig.pypiPackages` * Replace all
// custom custom PyPI packages. If a replacement package map is not
// included in `environment`, all custom PyPI packages are cleared. It
// is an error to provide both this mask and a mask specifying an
// individual package. *
// `config.softwareConfig.pypiPackages.`packagename * Update the custom
// PyPI package *packagename*, preserving other packages. To delete the
// package, include it in `updateMask`, and omit the mapping for it in
// `environment.config.softwareConfig.pypiPackages`. It is an error to
// provide both a mask of this form and the
// `config.softwareConfig.pypiPackages` mask. * `labels` * Replace all
// environment labels. If a replacement labels map is not included in
// `environment`, all labels are cleared. It is an error to provide both
// this mask and a mask specifying one or more individual labels. *
// `labels.`labelName * Set the label named *labelName*, while
// preserving other labels. To delete the label, include it in
// `updateMask` and omit its mapping in `environment.labels`. It is an
// error to provide both a mask of this form and the `labels` mask. *
// `config.nodeCount` * Horizontally scale the number of nodes in the
// environment. An integer greater than or equal to 3 must be provided
// in the `config.nodeCount` field. Supported for Cloud Composer
// environments in versions composer-1.*.*-airflow-*.*.*. *
// `config.webServerNetworkAccessControl` * Replace the environment's
// current `WebServerNetworkAccessControl`. *
// `config.softwareConfig.airflowConfigOverrides` * Replace all Apache
// Airflow config overrides. If a replacement config overrides map is
// not included in `environment`, all config overrides are cleared. It
// is an error to provide both this mask and a mask specifying one or
// more individual config overrides. *
// `config.softwareConfig.airflowConfigOverrides.`section-name *
// Override the Apache Airflow config property *name* in the section
// named *section*, preserving other properties. To delete the property
// override, include it in `updateMask` and omit its mapping in
// `environment.config.softwareConfig.airflowConfigOverrides`. It is an
// error to provide both a mask of this form and the
// `config.softwareConfig.airflowConfigOverrides` mask. *
// `config.softwareConfig.envVariables` * Replace all environment
// variables. If a replacement environment variable map is not included
// in `environment`, all custom environment variables are cleared. *
// `config.softwareConfig.schedulerCount` * Horizontally scale the
// number of schedulers in Airflow. A positive integer not greater than
// the number of nodes must be provided in the
// `config.softwareConfig.schedulerCount` field. Supported for Cloud
// Composer environments in versions composer-1.*.*-airflow-2.*.*. *
// `config.databaseConfig.machineType` * Cloud SQL machine type used by
// Airflow database. It has to be one of: db-n1-standard-2,
// db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. Supported
// for Cloud Composer environments in versions
// composer-1.*.*-airflow-*.*.*. * `config.webServerConfig.machineType`
// * Machine type on which Airflow web server is running. It has to be
// one of: composer-n1-webserver-2, composer-n1-webserver-4 or
// composer-n1-webserver-8. Supported for Cloud Composer environments in
// versions composer-1.*.*-airflow-*.*.*.
func (c *ProjectsLocationsEnvironmentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsEnvironmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsPatchCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.environment)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update an environment.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}",
	//   "httpMethod": "PATCH",
	//   "id": "composer.projects.locations.environments.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The relative resource name of the environment to update, in the form: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. A comma-separated list of paths, relative to `Environment`, of fields to update. For example, to set the version of scikit-learn to install in the environment to 0.19.0 and to remove an existing installation of numpy, the `updateMask` parameter would include the following two `paths` values: \"config.softwareConfig.pypiPackages.scikit-learn\" and \"config.softwareConfig.pypiPackages.numpy\". The included patch environment would specify the scikit-learn version as follows: { \"config\":{ \"softwareConfig\":{ \"pypiPackages\":{ \"scikit-learn\":\"==0.19.0\" } } } } Note that in the above example, any existing PyPI packages other than scikit-learn and numpy will be unaffected. Only one update type may be included in a single request's `updateMask`. For example, one cannot update both the PyPI packages and labels in the same request. However, it is possible to update multiple members of a map field simultaneously in the same request. For example, to set the labels \"label1\" and \"label2\" while clearing \"label3\" (assuming it already exists), one can provide the paths \"labels.label1\", \"labels.label2\", and \"labels.label3\" and populate the patch environment as follows: { \"labels\":{ \"label1\":\"new-label1-value\" \"label2\":\"new-label2-value\" } } Note that in the above example, any existing labels that are not included in the `updateMask` will be unaffected. It is also possible to replace an entire map field by providing the map field's path in the `updateMask`. The new value of the field will be that which is provided in the patch environment. For example, to delete all pre-existing user-specified PyPI packages and install botocore at version 1.7.14, the `updateMask` would contain the path \"config.softwareConfig.pypiPackages\", and the patch environment would be the following: { \"config\":{ \"softwareConfig\":{ \"pypiPackages\":{ \"botocore\":\"==1.7.14\" } } } } **Note:** Only the following fields can be updated: * `config.softwareConfig.pypiPackages` * Replace all custom custom PyPI packages. If a replacement package map is not included in `environment`, all custom PyPI packages are cleared. It is an error to provide both this mask and a mask specifying an individual package. * `config.softwareConfig.pypiPackages.`packagename * Update the custom PyPI package *packagename*, preserving other packages. To delete the package, include it in `updateMask`, and omit the mapping for it in `environment.config.softwareConfig.pypiPackages`. It is an error to provide both a mask of this form and the `config.softwareConfig.pypiPackages` mask. * `labels` * Replace all environment labels. If a replacement labels map is not included in `environment`, all labels are cleared. It is an error to provide both this mask and a mask specifying one or more individual labels. * `labels.`labelName * Set the label named *labelName*, while preserving other labels. To delete the label, include it in `updateMask` and omit its mapping in `environment.labels`. It is an error to provide both a mask of this form and the `labels` mask. * `config.nodeCount` * Horizontally scale the number of nodes in the environment. An integer greater than or equal to 3 must be provided in the `config.nodeCount` field. Supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. * `config.webServerNetworkAccessControl` * Replace the environment's current `WebServerNetworkAccessControl`. * `config.softwareConfig.airflowConfigOverrides` * Replace all Apache Airflow config overrides. If a replacement config overrides map is not included in `environment`, all config overrides are cleared. It is an error to provide both this mask and a mask specifying one or more individual config overrides. * `config.softwareConfig.airflowConfigOverrides.`section-name * Override the Apache Airflow config property *name* in the section named *section*, preserving other properties. To delete the property override, include it in `updateMask` and omit its mapping in `environment.config.softwareConfig.airflowConfigOverrides`. It is an error to provide both a mask of this form and the `config.softwareConfig.airflowConfigOverrides` mask. * `config.softwareConfig.envVariables` * Replace all environment variables. If a replacement environment variable map is not included in `environment`, all custom environment variables are cleared. * `config.softwareConfig.schedulerCount` * Horizontally scale the number of schedulers in Airflow. A positive integer not greater than the number of nodes must be provided in the `config.softwareConfig.schedulerCount` field. Supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*. * `config.databaseConfig.machineType` * Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. * `config.webServerConfig.machineType` * Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. Supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "Environment"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.pollAirflowCommand":

type ProjectsLocationsEnvironmentsPollAirflowCommandCall struct {
	s                         *Service
	environment               string
	pollairflowcommandrequest *PollAirflowCommandRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// PollAirflowCommand: Polls Airflow CLI command execution and fetches
// logs.
//
//   - environment: The resource name of the environment in the form:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) PollAirflowCommand(environment string, pollairflowcommandrequest *PollAirflowCommandRequest) *ProjectsLocationsEnvironmentsPollAirflowCommandCall {
	c := &ProjectsLocationsEnvironmentsPollAirflowCommandCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.environment = environment
	c.pollairflowcommandrequest = pollairflowcommandrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsPollAirflowCommandCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsPollAirflowCommandCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsPollAirflowCommandCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsPollAirflowCommandCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsPollAirflowCommandCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsPollAirflowCommandCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.pollairflowcommandrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+environment}:pollAirflowCommand")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"environment": c.environment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.pollAirflowCommand" call.
// Exactly one of *PollAirflowCommandResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *PollAirflowCommandResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsPollAirflowCommandCall) Do(opts ...googleapi.CallOption) (*PollAirflowCommandResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PollAirflowCommandResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Polls Airflow CLI command execution and fetches logs.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}:pollAirflowCommand",
	//   "httpMethod": "POST",
	//   "id": "composer.projects.locations.environments.pollAirflowCommand",
	//   "parameterOrder": [
	//     "environment"
	//   ],
	//   "parameters": {
	//     "environment": {
	//       "description": "The resource name of the environment in the form: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+environment}:pollAirflowCommand",
	//   "request": {
	//     "$ref": "PollAirflowCommandRequest"
	//   },
	//   "response": {
	//     "$ref": "PollAirflowCommandResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.saveSnapshot":

type ProjectsLocationsEnvironmentsSaveSnapshotCall struct {
	s                   *Service
	environment         string
	savesnapshotrequest *SaveSnapshotRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SaveSnapshot: Creates a snapshots of a Cloud Composer environment. As
// a result of this operation, snapshot of environment's state is stored
// in a location specified in the SaveSnapshotRequest.
//
//   - environment: The resource name of the source environment in the
//     form:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) SaveSnapshot(environment string, savesnapshotrequest *SaveSnapshotRequest) *ProjectsLocationsEnvironmentsSaveSnapshotCall {
	c := &ProjectsLocationsEnvironmentsSaveSnapshotCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.environment = environment
	c.savesnapshotrequest = savesnapshotrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsSaveSnapshotCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsSaveSnapshotCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsSaveSnapshotCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsSaveSnapshotCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsSaveSnapshotCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsSaveSnapshotCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.savesnapshotrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+environment}:saveSnapshot")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"environment": c.environment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.saveSnapshot" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsSaveSnapshotCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a snapshots of a Cloud Composer environment. As a result of this operation, snapshot of environment's state is stored in a location specified in the SaveSnapshotRequest.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}:saveSnapshot",
	//   "httpMethod": "POST",
	//   "id": "composer.projects.locations.environments.saveSnapshot",
	//   "parameterOrder": [
	//     "environment"
	//   ],
	//   "parameters": {
	//     "environment": {
	//       "description": "The resource name of the source environment in the form: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+environment}:saveSnapshot",
	//   "request": {
	//     "$ref": "SaveSnapshotRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.environments.stopAirflowCommand":

type ProjectsLocationsEnvironmentsStopAirflowCommandCall struct {
	s                         *Service
	environment               string
	stopairflowcommandrequest *StopAirflowCommandRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// StopAirflowCommand: Stops Airflow CLI command execution.
//
//   - environment: The resource name of the environment in the form:
//     "projects/{projectId}/locations/{locationId}/environments/{environme
//     ntId}".
func (r *ProjectsLocationsEnvironmentsService) StopAirflowCommand(environment string, stopairflowcommandrequest *StopAirflowCommandRequest) *ProjectsLocationsEnvironmentsStopAirflowCommandCall {
	c := &ProjectsLocationsEnvironmentsStopAirflowCommandCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.environment = environment
	c.stopairflowcommandrequest = stopairflowcommandrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEnvironmentsStopAirflowCommandCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsStopAirflowCommandCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEnvironmentsStopAirflowCommandCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsStopAirflowCommandCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEnvironmentsStopAirflowCommandCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsStopAirflowCommandCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.stopairflowcommandrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+environment}:stopAirflowCommand")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"environment": c.environment,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.environments.stopAirflowCommand" call.
// Exactly one of *StopAirflowCommandResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *StopAirflowCommandResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsStopAirflowCommandCall) Do(opts ...googleapi.CallOption) (*StopAirflowCommandResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StopAirflowCommandResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Stops Airflow CLI command execution.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}:stopAirflowCommand",
	//   "httpMethod": "POST",
	//   "id": "composer.projects.locations.environments.stopAirflowCommand",
	//   "parameterOrder": [
	//     "environment"
	//   ],
	//   "parameters": {
	//     "environment": {
	//       "description": "The resource name of the environment in the form: \"projects/{projectId}/locations/{locationId}/environments/{environmentId}\".",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/environments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+environment}:stopAirflowCommand",
	//   "request": {
	//     "$ref": "StopAirflowCommandRequest"
	//   },
	//   "response": {
	//     "$ref": "StopAirflowCommandResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.imageVersions.list":

type ProjectsLocationsImageVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List ImageVersions for provided location.
//
//   - parent: List ImageVersions in the given project and location, in
//     the form: "projects/{projectId}/locations/{locationId}".
func (r *ProjectsLocationsImageVersionsService) List(parent string) *ProjectsLocationsImageVersionsListCall {
	c := &ProjectsLocationsImageVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// IncludePastReleases sets the optional parameter
// "includePastReleases": Whether or not image versions from old
// releases should be included.
func (c *ProjectsLocationsImageVersionsListCall) IncludePastReleases(includePastReleases bool) *ProjectsLocationsImageVersionsListCall {
	c.urlParams_.Set("includePastReleases", fmt.Sprint(includePastReleases))
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of image_versions to return.
func (c *ProjectsLocationsImageVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsImageVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// next_page_token value returned from a previous List request, if any.
func (c *ProjectsLocationsImageVersionsListCall) PageToken(pageToken string) *ProjectsLocationsImageVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsImageVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsImageVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsImageVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsImageVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsImageVersionsListCall) Context(ctx context.Context) *ProjectsLocationsImageVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsImageVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImageVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/imageVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.imageVersions.list" call.
// Exactly one of *ListImageVersionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListImageVersionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsImageVersionsListCall) Do(opts ...googleapi.CallOption) (*ListImageVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListImageVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List ImageVersions for provided location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/imageVersions",
	//   "httpMethod": "GET",
	//   "id": "composer.projects.locations.imageVersions.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "includePastReleases": {
	//       "description": "Whether or not image versions from old releases should be included.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of image_versions to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The next_page_token value returned from a previous List request, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "List ImageVersions in the given project and location, in the form: \"projects/{projectId}/locations/{locationId}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/imageVersions",
	//   "response": {
	//     "$ref": "ListImageVersionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsImageVersionsListCall) Pages(ctx context.Context, f func(*ListImageVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "composer.projects.locations.operations.delete":

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that
// the client is no longer interested in the operation result. It does
// not cancel the operation. If the server doesn't support this method,
// it returns `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.operations.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "DELETE",
	//   "id": "composer.projects.locations.operations.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource to be deleted.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.operations.get":

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "composer.projects.locations.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "composer.projects.locations.operations.list":

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "composer.projects.locations.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "composer.projects.locations.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
