/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.ReplaceCertificateKeyStoreContent;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.PKCS8EncryptionHandler;
import com.unboundid.util.ssl.cert.PKCS8PEMFileReader;
import com.unboundid.util.ssl.cert.PKCS8PrivateKey;
import com.unboundid.util.ssl.cert.X509Certificate;
import com.unboundid.util.ssl.cert.X509PEMFileReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CertificateDataReplaceCertificateKeyStoreContent
extends ReplaceCertificateKeyStoreContent {
    static final byte TYPE_KEY_STORE_CONTENT = -94;
    private static final byte TYPE_CERTIFICATE_CHAIN = -82;
    private static final byte TYPE_PRIVATE_KEY = -81;
    private static final long serialVersionUID = 1771837307666073616L;
    @Nullable
    private final byte[] privateKeyData;
    @NotNull
    private final List<byte[]> certificateChainData;

    public CertificateDataReplaceCertificateKeyStoreContent(@NotNull List<byte[]> certificateChainData, @Nullable byte[] privateKeyData) {
        Validator.ensureNotNullOrEmpty(certificateChainData, "CertificateDataReplaceCertificateKeyStoreContent.certificateChainData must not be null or empty.");
        this.certificateChainData = Collections.unmodifiableList(new ArrayList<byte[]>(certificateChainData));
        this.privateKeyData = privateKeyData;
    }

    public CertificateDataReplaceCertificateKeyStoreContent(@NotNull List<File> certificateChainFiles, @Nullable File privateKeyFile) throws LDAPException {
        this(CertificateDataReplaceCertificateKeyStoreContent.readCertificateChain(certificateChainFiles), privateKeyFile == null ? null : CertificateDataReplaceCertificateKeyStoreContent.readPrivateKey(privateKeyFile));
    }

    public CertificateDataReplaceCertificateKeyStoreContent(@NotNull List<File> certificateChainFiles, @Nullable File privateKeyFile, @Nullable File privateKeyEncryptionPasswordFile) throws LDAPException {
        this(CertificateDataReplaceCertificateKeyStoreContent.readCertificateChain(certificateChainFiles), privateKeyFile == null ? null : CertificateDataReplaceCertificateKeyStoreContent.readPrivateKey(privateKeyFile, privateKeyEncryptionPasswordFile));
    }

    @NotNull
    public static List<byte[]> readCertificateChain(File ... files) throws LDAPException {
        return CertificateDataReplaceCertificateKeyStoreContent.readCertificateChain(Arrays.asList(files));
    }

    @NotNull
    public static List<byte[]> readCertificateChain(@NotNull List<File> files) throws LDAPException {
        Validator.ensureNotNullOrEmpty(files, "CertificateDataReplaceCertificateKeyStoreContent.readCertificateChain.files must not be null or empty.");
        ArrayList<byte[]> encodedCerts = new ArrayList<byte[]>();
        for (File f : files) {
            CertificateDataReplaceCertificateKeyStoreContent.readCertificates(f, encodedCerts);
        }
        return Collections.unmodifiableList(encodedCerts);
    }

    private static void readCertificates(@NotNull File file, @NotNull List<byte[]> encodedCerts) throws LDAPException {
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            bis.mark(1);
            int firstByte = bis.read();
            bis.reset();
            if (firstByte < 0) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ExtOpMessages.ERR_CD_KSC_DECODE_ERR_EMPTY_CERT_FILE.get(file.getAbsolutePath()));
            }
            if (firstByte == 48) {
                CertificateDataReplaceCertificateKeyStoreContent.readDERCertificates(file, bis, encodedCerts);
                return;
            }
            CertificateDataReplaceCertificateKeyStoreContent.readPEMCertificates(file, bis, encodedCerts);
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ExtOpMessages.ERR_CD_KSC_DECODE_ERROR_READING_CERT_FILE.get(file.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readDERCertificates(@NotNull File file, @NotNull InputStream inputStream, @NotNull List<byte[]> encodedCerts) throws LDAPException {
        try (ASN1StreamReader asn1Reader = new ASN1StreamReader(inputStream);){
            while (true) {
                ASN1Element element;
                if ((element = asn1Reader.readElement()) == null) {
                    return;
                }
                encodedCerts.add(element.encode());
                continue;
                break;
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CD_KSC_DECODE_DER_CERT_ERROR.get(file.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readPEMCertificates(@NotNull File file, @NotNull InputStream inputStream, @NotNull List<byte[]> encodedCerts) throws IOException, LDAPException {
        try (X509PEMFileReader pemReader = new X509PEMFileReader(inputStream);){
            while (true) {
                X509Certificate cert;
                if ((cert = pemReader.readCertificate()) == null) {
                    return;
                }
                encodedCerts.add(cert.getX509CertificateBytes());
                continue;
                break;
            }
        }
        catch (CertException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CD_KSC_DECODE_PEM_CERT_ERROR.get(file.getAbsolutePath(), e.getMessage()), e);
        }
    }

    @NotNull
    public static byte[] readPrivateKey(@NotNull File file) throws LDAPException {
        return CertificateDataReplaceCertificateKeyStoreContent.readPrivateKey(file, null);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public static byte[] readPrivateKey(@NotNull File file, @Nullable File encryptionPasswordFile) throws LDAPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static byte[] readDERPrivateKey(@NotNull File file, @NotNull InputStream inputStream, @Nullable char[] encryptionPassword) throws LDAPException {
        try (ASN1StreamReader asn1Reader = new ASN1StreamReader(inputStream);){
            ASN1Element element = asn1Reader.readElement();
            if (asn1Reader.readElement() != null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CD_KSC_DECODE_MULTIPLE_DER_KEYS_IN_FILE.get(file.getAbsolutePath()));
            }
            byte[] elementsBytes = element.encode();
            if (encryptionPassword == null) {
                byte[] byArray = elementsBytes;
                return byArray;
            }
            PKCS8PrivateKey privateKey = PKCS8EncryptionHandler.decryptPrivateKey(elementsBytes, encryptionPassword);
            byte[] byArray = privateKey.getPKCS8PrivateKeyBytes();
            return byArray;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CD_KSC_DECODE_DER_PK_ERROR.get(file.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static byte[] readPEMPrivateKey(@NotNull File file, @NotNull InputStream inputStream, @Nullable char[] encryptionPassword) throws IOException, LDAPException {
        try (PKCS8PEMFileReader pemReader = new PKCS8PEMFileReader(inputStream);){
            PKCS8PrivateKey privateKey = pemReader.readPrivateKey();
            if (pemReader.readPrivateKey(encryptionPassword) != null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CD_KSC_DECODE_MULTIPLE_PEM_KEYS_IN_FILE.get(file.getAbsolutePath()));
            }
            byte[] byArray = privateKey.getPKCS8PrivateKeyBytes();
            return byArray;
        }
        catch (CertException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CD_KSC_DECODE_PEM_PK_ERROR.get(file.getAbsolutePath(), e.getMessage()), e);
        }
    }

    @NotNull
    public List<byte[]> getCertificateChainData() {
        return this.certificateChainData;
    }

    @Nullable
    public byte[] getPrivateKeyData() {
        return this.privateKeyData;
    }

    @NotNull
    static CertificateDataReplaceCertificateKeyStoreContent decodeInternal(@NotNull ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = element.decodeAsSequence().elements();
            ASN1Element[] chainElements = elements[0].decodeAsSequence().elements();
            ArrayList<byte[]> chainBytes = new ArrayList<byte[]>();
            for (ASN1Element e : chainElements) {
                chainBytes.add(e.decodeAsOctetString().getValue());
            }
            byte[] pkBytes = null;
            for (int i = 1; i < elements.length; ++i) {
                if (elements[i].getType() != -81) continue;
                pkBytes = elements[i].decodeAsOctetString().getValue();
            }
            return new CertificateDataReplaceCertificateKeyStoreContent(chainBytes, pkBytes);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CD_KSC_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    @NotNull
    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        ArrayList<ASN1OctetString> chainElements = new ArrayList<ASN1OctetString>(this.certificateChainData.size());
        for (byte[] certBytes : this.certificateChainData) {
            chainElements.add(new ASN1OctetString(certBytes));
        }
        elements.add(new ASN1Sequence(-82, chainElements));
        if (this.privateKeyData != null) {
            elements.add(new ASN1OctetString(-81, this.privateKeyData));
        }
        return new ASN1Sequence(-94, elements);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("CertificateDataReplaceCertificateKeyStoreContent(certificateChainLength=");
        buffer.append(this.certificateChainData.size());
        buffer.append(", privateProvided=");
        buffer.append(this.privateKeyData != null);
        buffer.append(')');
    }
}

