# Contributing

Contributions are welcome, and they are greatly appreciated! Every little bit helps! You can contribute in many ways, not limited to this document.

## Types of Contributions

### Report Bugs

First of all, please check that the bug is not reported yet. If that's already reported then upvote the existing bug instead of opening a new bug report.

Report bugs at https://github.com//issues. If you are reporting a bug, please include:

- Your operating system name and version.
- Any details about your local setup that might be helpful in troubleshooting.
- Detailed steps to reproduce the bug.

### Fix Bugs

Look through the GitHub issues for bugs. Anything tagged with "bug", "good first issue" and "help wanted" is open to whoever wants to implement it.

### Implement Features

Look through the GitHub issues for features. Anything tagged with "enhancement",  "good first issue" and "help wanted" is open to whoever wants to implement it. In case you added a new Rule or Precondition, do not forget to add them to the docs as well.

### Write Documentation

RethinkDB could always use more documentation, whether as part of the official docs, in docstrings, or even on the web in blog posts, articles, and such. To extend the documentation on the website, visit the [www](https://github.com/rethinkdb/www) repo. For extending the docs, you can check the [docs](https://github.com/rethinkdb/docs) repo.

### Submit A Feature

First of all, please check that the feature request is not reported yet. If that's already reported then upvote the existing request instead of opening a new one.

If you are proposing a feature:

- Check if there is an opened feature request for the same idea.
- Explain in detail how it would work.
- Keep the scope as narrow as possible, to make it easier to implement.
- Remember that this is an open-source project, and that contributions are welcome :)

## Pull Request Guidelines

Before you submit a pull request, check that it meets these guidelines:

1. The pull request should include tests (if applicable)
2. If the pull request adds functionality, the docs should be updated too.