/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muclight.MUCLightAffiliation;
import org.jivesoftware.smackx.muclight.MUCLightRoomConfiguration;
import org.jivesoftware.smackx.muclight.element.MUCLightInfoIQ;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class MUCLightInfoIQProvider
extends IqProvider<MUCLightInfoIQ> {
    @Override
    public MUCLightInfoIQ parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        String version = null;
        String roomName = null;
        String subject = null;
        HashMap<String, String> customConfigs = null;
        HashMap<Jid, MUCLightAffiliation> occupants = new HashMap();
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                if (parser.getName().equals("version")) {
                    version = parser.nextText();
                }
                if (parser.getName().equals("configuration")) {
                    int depth = parser.getDepth();
                    while (true) {
                        if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                            if (parser.getName().equals("roomname")) {
                                roomName = parser.nextText();
                                continue;
                            }
                            if (parser.getName().equals("subject")) {
                                subject = parser.nextText();
                                continue;
                            }
                            if (customConfigs == null) {
                                customConfigs = new HashMap<String, String>();
                            }
                            customConfigs.put(parser.getName(), parser.nextText());
                            continue;
                        }
                        if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == depth) break;
                    }
                }
                if (!parser.getName().equals("occupants")) continue;
                occupants = MUCLightInfoIQProvider.iterateOccupants(parser);
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
        }
        return new MUCLightInfoIQ(version, new MUCLightRoomConfiguration(roomName, subject, customConfigs), occupants);
    }

    private static Map<Jid, MUCLightAffiliation> iterateOccupants(XmlPullParser parser) throws XmlPullParserException, IOException {
        HashMap<Jid, MUCLightAffiliation> occupants = new HashMap<Jid, MUCLightAffiliation>();
        int depth = parser.getDepth();
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                if (!parser.getName().equals("user")) continue;
                MUCLightAffiliation affiliation = MUCLightAffiliation.fromString(parser.getAttributeValue("", "affiliation"));
                occupants.put(JidCreate.from(parser.nextText()), affiliation);
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == depth) break;
        }
        return occupants;
    }
}

