/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smackx.eme.element.ExplicitMessageEncryptionElement;
import org.jivesoftware.smackx.hints.element.StoreHint;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.jxmpp.jid.Jid;

public class OmemoMessage {
    private final OmemoElement element;
    private final byte[] messageKey;
    private final byte[] iv;

    OmemoMessage(OmemoElement element, byte[] key, byte[] iv) {
        this.element = element;
        this.messageKey = key;
        this.iv = iv;
    }

    public OmemoElement getElement() {
        return this.element;
    }

    public byte[] getKey() {
        return (byte[])this.messageKey.clone();
    }

    public byte[] getIv() {
        return (byte[])this.iv.clone();
    }

    public static class Received
    extends OmemoMessage {
        private final String message;
        private final OmemoFingerprint sendersFingerprint;
        private final OmemoDevice senderDevice;
        private final boolean preKeyMessage;

        Received(OmemoElement element, byte[] key, byte[] iv, String body, OmemoFingerprint sendersFingerprint, OmemoDevice senderDevice, boolean preKeyMessage) {
            super(element, key, iv);
            this.message = body;
            this.sendersFingerprint = sendersFingerprint;
            this.senderDevice = senderDevice;
            this.preKeyMessage = preKeyMessage;
        }

        public String getBody() {
            return this.message;
        }

        public OmemoFingerprint getSendersFingerprint() {
            return this.sendersFingerprint;
        }

        public OmemoDevice getSenderDevice() {
            return this.senderDevice;
        }

        boolean isPreKeyMessage() {
            return this.preKeyMessage;
        }

        public boolean isKeyTransportMessage() {
            return this.message == null;
        }
    }

    public static class Sent
    extends OmemoMessage {
        private final Set<OmemoDevice> intendedDevices = new HashSet<OmemoDevice>();
        private final Map<OmemoDevice, Throwable> skippedDevices = new HashMap<OmemoDevice, Throwable>();

        Sent(OmemoElement element, byte[] key, byte[] iv, Set<OmemoDevice> intendedDevices, Map<OmemoDevice, Throwable> skippedDevices) {
            super(element, key, iv);
            this.intendedDevices.addAll(intendedDevices);
            this.skippedDevices.putAll(skippedDevices);
        }

        public Set<OmemoDevice> getIntendedDevices() {
            return this.intendedDevices;
        }

        public Map<OmemoDevice, Throwable> getSkippedDevices() {
            return this.skippedDevices;
        }

        public boolean isMissingRecipients() {
            return !this.getSkippedDevices().isEmpty();
        }

        public Message buildMessage(MessageBuilder messageBuilder, Jid recipient) {
            messageBuilder.ofType(Message.Type.chat).to(recipient);
            messageBuilder.addExtension(this.getElement());
            if (OmemoConfiguration.getAddOmemoHintBody()) {
                messageBuilder.setBody("I sent you an OMEMO encrypted message but your client doesn't seem to support that. Find more information on https://conversations.im/omemo");
            }
            StoreHint.set(messageBuilder);
            messageBuilder.addExtension(new ExplicitMessageEncryptionElement("eu.siacs.conversations.axolotl", "OMEMO"));
            return messageBuilder.build();
        }
    }
}

