/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.EntityBareJid;

public class AgentStatus
implements ExtensionElement {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    public static final String ELEMENT_NAME = "agent-status";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    public static final QName QNAME;
    private EntityBareJid workgroupJID;
    private final List<ChatInfo> currentChats = new ArrayList<ChatInfo>();
    private int maxChats = -1;

    AgentStatus() {
    }

    public EntityBareJid getWorkgroupJID() {
        return this.workgroupJID;
    }

    public List<ChatInfo> getCurrentChats() {
        return Collections.unmodifiableList(this.currentChats);
    }

    public int getMaxChats() {
        return this.maxChats;
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String toXML(XmlEnvironment enclosingNamespace) {
        StringBuilder buf = new StringBuilder();
        buf.append('<').append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append('\"');
        if (this.workgroupJID != null) {
            buf.append(" jid=\"").append(this.workgroupJID).append('\"');
        }
        buf.append('>');
        if (this.maxChats != -1) {
            buf.append("<max-chats>").append(this.maxChats).append("</max-chats>");
        }
        if (!this.currentChats.isEmpty()) {
            buf.append("<current-chats xmlns= \"http://jivesoftware.com/protocol/workgroup\">");
            Iterator<ChatInfo> it = this.currentChats.iterator();
            while (it.hasNext()) {
                buf.append(it.next().toXML());
            }
            buf.append("</current-chats>");
        }
        buf.append("</").append(this.getElementName()).append("> ");
        return buf.toString();
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        QNAME = new QName(NAMESPACE, ELEMENT_NAME);
    }

    public static class ChatInfo {
        private final String sessionID;
        private final String userID;
        private final Date date;
        private final String email;
        private final String username;
        private final String question;

        public ChatInfo(String sessionID, String userID, Date date, String email, String username, String question) {
            this.sessionID = sessionID;
            this.userID = userID;
            this.date = date;
            this.email = email;
            this.username = username;
            this.question = question;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public String getUserID() {
            return this.userID;
        }

        public Date getDate() {
            return this.date;
        }

        public String getEmail() {
            return this.email;
        }

        public String getUsername() {
            return this.username;
        }

        public String getQuestion() {
            return this.question;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<chat ");
            if (this.sessionID != null) {
                buf.append(" sessionID=\"").append(this.sessionID).append('\"');
            }
            if (this.userID != null) {
                buf.append(" userID=\"").append(this.userID).append('\"');
            }
            if (this.date != null) {
                buf.append(" startTime=\"");
                SimpleDateFormat simpleDateFormat = UTC_FORMAT;
                synchronized (simpleDateFormat) {
                    buf.append(UTC_FORMAT.format(this.date));
                }
                buf.append('\"');
            }
            if (this.email != null) {
                buf.append(" email=\"").append(this.email).append('\"');
            }
            if (this.username != null) {
                buf.append(" username=\"").append(this.username).append('\"');
            }
            if (this.question != null) {
                buf.append(" question=\"").append(this.question).append('\"');
            }
            buf.append("/>");
            return buf.toString();
        }
    }

    public static class Provider
    extends ExtensionElementProvider<AgentStatus> {
        @Override
        public AgentStatus parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, ParseException {
            AgentStatus agentStatus = new AgentStatus();
            agentStatus.workgroupJID = ParserUtils.getBareJidAttribute(parser, jxmppContext);
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT) {
                    if ("chat".equals(parser.getName())) {
                        ChatInfo chatInfo = Provider.parseChatInfo(parser);
                        agentStatus.currentChats.add(chatInfo);
                        continue;
                    }
                    if (!"max-chats".equals(parser.getName())) continue;
                    agentStatus.maxChats = Integer.parseInt(parser.nextText());
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !AgentStatus.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            return agentStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ChatInfo parseChatInfo(XmlPullParser parser) throws ParseException {
            String sessionID = parser.getAttributeValue("", "sessionID");
            String userID = parser.getAttributeValue("", "userID");
            Date date = null;
            SimpleDateFormat simpleDateFormat = UTC_FORMAT;
            synchronized (simpleDateFormat) {
                date = UTC_FORMAT.parse(parser.getAttributeValue("", "startTime"));
            }
            String email = parser.getAttributeValue("", "email");
            String username = parser.getAttributeValue("", "username");
            String question = parser.getAttributeValue("", "question");
            return new ChatInfo(sessionID, userID, date, email, username, question);
        }
    }
}

