package AmphetaDesk::Versioning;
###############################################################################
# AmphetaDesk                                           (c) 2000-2002 Disobey #
# morbus@disobey.com                      http://www.disobey.com/amphetadesk/ #
###############################################################################
# ABOUT THIS PACKAGE:                                                         #
#   This package handles versioning of AmphetaDesk. Currently, it fiddles     #
#   with downloading a plain text version file for comparison, but it will    #
#   eventually automatically stream and install new releases, as well as back #
#   up old versions for emergency restoration.                                #
#                                                                             #
# LIST OF ROUTINES BELOW:                                                     #
#   check_version - compares the installed version to the latest version.     #
###############################################################################
#        "I simply don't understand how someone can smell like that."         #
###############################################################################

use strict; $|++;
use AmphetaDesk::Settings;
use AmphetaDesk::Utilities;
use AmphetaDesk::WWW;
require Exporter;
use vars qw( @ISA @EXPORT );
@ISA = qw( Exporter );
@EXPORT = qw( check_version );

###############################################################################
# check_version - compares the installed version to the latest version.       #
###############################################################################
# USAGE / PARAMS:                                                             #
#   $results = check_version( );                                              #
#                                                                             #
# NOTES:                                                                      #
#   This routine grabs the text file sitting at "urls_version_current" and    #
#   compares it with the currently installed version, as well as saving the   #
#   the data to "files_version"\}. If they're different, alert the user.      #
#                                                                             #
# RETURNS:                                                                    #
#   0; if we couldn't connect to our $url_version.                            #
#   1; if we've checked the version sucessfully.                              #
###############################################################################

sub check_version {

   # tell the user what's going on.
   note("Checking for a newer version than " . get_setting("app_version") . ".", 1);

   # get the version text file.
   mirror( get_setting("urls_version_current"), get_setting("files_version") ) or return 0;

   # load in our version file.
   my $file_version = get_setting("files_version");
   open(VERSION, "<$file_version") or note("AmphetaDesk couldn't open the version file. Please report the following error to " . get_settings("app_email") . ": $!", 1);
   local $/ = undef; my $raw_data = <VERSION>; close(VERSION);

   # split our raw data on new lines.
   my ($virgin_server_version, $release_date, $release_notes) = split(/[\n\r\f]/, $raw_data);
   $virgin_server_version =~ s/[\n\r\f]//; $release_date =~ s/[\n\r\f]//; $release_notes =~ s/[\n\r\f]//;

   # save into another for transformation.
   my $server_version = $virgin_server_version;
   my $local_version = get_setting("app_version");

   # remove non numbers.
   $server_version =~ s/\D//g; $local_version =~ s/\D//g;

   # compare and notify.
   if ($server_version > $local_version) { 
      note("  AmphetaDesk $virgin_server_version is available!",              1);
      note("  It was released on $release_date.",                             1);
      note("  Release Notes: $release_notes",                                 1);
   } 
   else { 
      note(get_setting("app_version") . " is the latest and greatest version! Good!", 1); 
      note("Visit " . get_setting("app_url") . " for the latest info.",               1); 
   }

   # make a pretty divider for our log file and window.
   note("--------------------------------------------------------------------------------", 1);

   return 1;

}

1;
