/*
*  qm_task.h
*  QUIMUP thread worker class
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_TASK_H
#define QM_TASK_H

#include <mpd/client.h>
#include <QObject>


class qm_workerTask : public QObject
{
    Q_OBJECT

public:
    qm_workerTask();
    ~qm_workerTask();

    void set_tries_delay(int, int ms=50000);
    void set_host_port_tmout(QString , uint , int t=3000);
    void abort_loop();

    mpd_connection *p_conn;

public slots:
     void do_work();

signals:
    void work_done(const uchar &);

private:
    uchar result;
    bool b_success;
    bool b_abort;
    int tries;
    int delay;
    QString server_name;
    uint server_port;
    int timeout;
    QObject *parent;

};

#endif // QM_TASK_H
