
:- use_module(dcg).

% =========================================
% 1) { Cond -> true } : 単純 if-then（Elseなし）
% =========================================
p1 --> [n(N)], { (N > 0 -> true) }, [pos].

% =========================================
% 2) { Cond -> Then ; Else } : if-then-else
% =========================================
p2 --> [n(N)], { (N > 0 -> Tag = pos ; Tag = neg) }, [tag(Tag)].

% =========================================
% 3) { Cond -> X=... ; X=... } : 変数を束縛して後続へ渡す
% =========================================
p3(X) --> [n(N)], { (N mod 2 =:= 0 -> X = even ; X = odd) }, [kind(X)].

% =========================================
% 4) { Cond -> true ; fail } : ガードとして使う（失敗させる）
% =========================================
p4 --> [n(N)], { (N > 0 -> true ; fail) }, [ok].
