# 0.77.0 release notes

**Release date:** 2021-07-21

## How to upgrade

Download and launch the latest version:

<div class="compact" markdown>

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

At the`Z:\>` prompt, run `config -wc` to write the new configuration file. Any
existing settings will be retained, however, extraneous comments will be
dropped.


## Significant changes

### Migrated to the Meson build system

Migrated Staging from autotools to the Meson build system. Those building from
source, please see `BUILD.md` in the repository. See: #854

### macOS and SELinux security policy compliance

Added write-xor-execute page support to comply with the latest macOS and
SELinux security policies

Thanks to *jmarsh* and *Jonathan Campbell* for discussions on vogons.
See: #1031


### Variable expansion in the interactive DOS shell

See: #1059


### Finished FluidSynth integration

FluidSynth is now included in all release binaries. See the [wiki
notes](https://github.com/dosbox-staging/dosbox-staging/wiki/MIDI#fluidsynth)
for how to use it. Run `MIXER /LISTMIDI` in the DOS shell to see your
available soundfonts.

Thanks to:

- *Christian Lestrade* for
  [authoring](https://sourceforge.net/p/dosbox/patches/107/) this support in
  2005, and all subsequent maintainers.

- *Meson* for
  [adding](https://github.com/mesonbuild/fluidsynth/tree/2.2.0) FluidSynth
  to the WrapDB.

### Finished MT-32 integration

The MT-32 emulator is now included in all release binaries. See the [wiki
notes](https://github.com/dosbox-staging/dosbox-staging/wiki/MIDI#mt32emu) for
how to use it. Run `MIXER /LISTMIDI` in the DOS shell to see the available
MT-32 models and versions.

See the list of [*unmissable* MT-32
experiences](https://www.vogons.org/viewtopic.php?f=62&t=77567), courtesy
vogons.org forum user *Shreddoc* and contributors.

Thanks to:

- *Canadacow* for [authoring](https://www.vogons.org/viewtopic.php?p=15519#p15519)
  MT-32 emulation in 2003, *KingGuppy* and *Mok* for the follow-on work, and
  *SergM* who continues to maintain and improve the Munt project today.

- *Meson* for [adding](https://github.com/mesonbuild/mt32emu/tree/2.5.0)
  libmt32emu to the WrapDB.

- *Microsoft* for [adding](https://github.com/microsoft/vcpkg/issues/16813)
  libmt32emu to Vcpkg.

### IBM PS/1 Audio device support

See the [wiki notes](https://github.com/dosbox-staging/dosbox-staging/wiki/Sound-cards#ibm-ps1-audio-card) for how to use it.

Thanks to *JMK* for
[authoring](https://www.vogons.org/viewtopic.php?p=132826#p132826) PS/1 Audio
emulation in 2008.

### Innovation SSI-2001 audio device support

See the [wiki
notes](https://github.com/dosbox-staging/dosbox-staging/wiki/Sound-cards#innovation-ssi-2001)
for how to use it.

Thanks to:

- *Vasyl* for [authoring](https://www.vogons.org/viewtopic.php?p=93689#p93689)
  SSI-2001 emulation in 2006.

- *Dag Lem* for authoring, and *Antti Lankila* and *Leandro Nini* for
  improving the SID chip emulator.

### macOS hotkey changes

Replaced the default ++ctrl+f1++ - ++f12++ hotkeys [on
macOS](https://github.com/dosbox-staging/dosbox-staging/pull/996#issuecomment-834960586)
with ++cmd+f1++ - ++f12++ to reduce conflicts with the OS.

Thanks to *Antti Peltola*, *Burrito78*, and *Kirk Klobe* for guidance and
testing.

### Translation improvements

Added or improved translations for French, Italian, Polish, Russian, and
Spanish.

Thanks to *Draky50110* (fr), *Kappa971* (it), *dreamer* (po), *IlyaIndigo*
(ru), and *Peluchito* (es).

### Improved startup settings

Added `splash_only` to the `startup_verbosity` settings. This shows the splash
but skips the help banner.

### Relative window size support

Three relative window sizes, `small`, `medium`, or `large`, are now understood
by the `windowresolution` config setting. These T-shirt sizes correspond to a
window that's 25%, 50%, or 80% of your desktop's area, regardless of DPI or
type of monitor (be it 720p, 1080p, or 4K).

### Window resizing enabled by default

Window resizing using corner-drag is now auto-enabled on all platforms when
conditions permit.


## Bugfixes

The following user-visible bugs were fixed:

- Will no longer lose focus on Raspberry Pi when launched fullscreen in an Xorg
  session. ([#995](https://github.com/dosbox-staging/dosbox-staging/pull/995))

- Release builds now use `dosbox-staging.conf` as the primary config file instead of
  `dosbox-staging-git.conf`. ([#932](https://github.com/dosbox-staging/dosbox-staging/pull/932))

- Windows release builds once again mount Opus CD-DA tracks, which was a
  regression in 0.76. ([#885](https://github.com/dosbox-staging/dosbox-staging/pull/855))

- `AUTOTYPE` now works with all games. Until now, a subset of games didn't
  respond to its keystrokes.
  ([#942](https://github.com/dosbox-staging/dosbox-staging/pull/942))

- Shoulder triggers on some six-axis controllers, such as the PS4 and
  Logitech's F310 and F710 controllers, can now be mapped.
  ([#944](https://github.com/dosbox-staging/dosbox-staging/pull/944))

- When toggling out of fullscreen mode, in some corner cases this resulted in
  a [blank window](https://github.com/dosbox-staging/dosbox-staging/issues/1094). This
  is now fixed. ([#1096](https://github.com/dosbox-staging/dosbox-staging/pull/1096))


## Contributions

The 0.77 release includes **920** commits plus **35** commits originating from
the DOSBox project.

### DOSBox Staging members

The following members actively supported the project during the 0.77
timeframe:

<div class="compact" markdown>

- Antti Peltola (macOS testing and feedback)
- Brandon Munger (collaborator)
- Burrito78 (macOS testing and feedback)
- GranMinigun (testing and triage)
- kcgen (maintainer)
- Kirk Klobe (maintainer)
- Dennis Lühring (collaborator)
- nemo93 (Wiki maintainer)
- Patryk Obara (maintainer)
- Ruben Genoese (testing and triage)
- Wengier (collaborator)

</div>

### Direct contributors

The following authors, co-authors, wiki editors, translators, testers, and bug reporters directly contributed to the 0.77 release:

<div class="compact" markdown>

- Allofich
- Antti Peltola
- Brandon Munger
- Burrito78
- Dennis Lühring
- Didu
- Draky50110
- Dugan Chen
- eli-schwart
- Emmanuel Gil Peyrot
- Feignint
- Gilles
- GranMinigun
- hail-to-the-ryzen
- IlyaIndigo
- IPeluchito
- jmarsh
- Joshua Krämer
- Kappa971
- kcgen
- Ken Händel
- Kirk Klobe
- mdmallard
- nemo93
- Otto Urpelainen
- Patryk Obara
- Peluchito
- Ruben Genoese
- rhys073
- Sarah Whitman
- Toby Jennings
- warpdesign
- Wengier

</div>

### DOSBox contributors

The following DOSBox authors' SVN commits (r4393 through r4459) were merged during the 0.77 timeframe:

<div class="compact" markdown>

- jmarsh
- Peter Veenstra
- ripsaw8080
- Sjoerd van der Berg

</div>

### Indirect contributors

The following patch or external project authors' sources were merged during the 0.77 timeframe:

<div class="compact" markdown>

- Antti S. Lankila (reSIDfp maintainer)
- Dag Lem (original reSID author)
- David Reid (dr_libs audio codecs author)
- Dean Beeler (original MT-32 patch author)
- Jason Kim (PS/1 patch author)
- Jonathan Campbell (DOSBox-X maintainer)
- nukeykt (Nuked OPL emulator author)
- sergm (Munt and MT-32 patch maintainer)
- Vasyl Tsvirkunov (SS1-2001 patch author)
- Wengier (DOSBox-X maintainer)
- ykhwong (DOSBox Daum maintainer)

</div>


## Thank you

We are extremely grateful for all contributions, including the invaluable improvements merged in from the DOSBox project.

The project maintains original authorship on all commits (including those from upstream, patches, and external projects) to ensure correct attribution is recorded in the version control system.

