/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.media.IMediaBrowserServiceCompat;
import android.support.v4.media.IMediaBrowserServiceCompatCallbacks;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;

public abstract class MediaBrowserServiceCompat
extends Service {
    private static final String TAG = "MediaBrowserServiceCompat";
    private static final boolean DBG = false;
    public static final String SERVICE_INTERFACE = "android.media.browse.MediaBrowserServiceCompat";
    public static final String KEY_MEDIA_ITEM = "media_item";
    private final ArrayMap<IBinder, ConnectionRecord> mConnections = new ArrayMap();
    private final Handler mHandler = new Handler();
    private ServiceBinder mBinder;
    MediaSessionCompat.Token mSession;

    public void onCreate() {
        super.onCreate();
        this.mBinder = new ServiceBinder();
    }

    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
    }

    @Nullable
    public abstract BrowserRoot onGetRoot(@NonNull String var1, int var2, @Nullable Bundle var3);

    public abstract void onLoadChildren(@NonNull String var1, @NonNull Result<List<MediaBrowserCompat.MediaItem>> var2);

    public void onLoadItem(String itemId, Result<MediaBrowserCompat.MediaItem> result) {
        result.sendResult(null);
    }

    public void setSessionToken(final MediaSessionCompat.Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Session token may not be null.");
        }
        if (this.mSession != null) {
            throw new IllegalStateException("The session token has already been set.");
        }
        this.mSession = token;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                for (IBinder key : MediaBrowserServiceCompat.this.mConnections.keySet()) {
                    ConnectionRecord connection = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(key);
                    try {
                        connection.callbacks.onConnect(connection.root.getRootId(), token, connection.root.getExtras());
                    }
                    catch (RemoteException e) {
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)("Connection for " + connection.pkg + " is no longer valid."));
                        MediaBrowserServiceCompat.this.mConnections.remove(key);
                    }
                }
            }
        });
    }

    @Nullable
    public MediaSessionCompat.Token getSessionToken() {
        return this.mSession;
    }

    public void notifyChildrenChanged(final @NonNull String parentId) {
        if (parentId == null) {
            throw new IllegalArgumentException("parentId cannot be null in notifyChildrenChanged");
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                for (IBinder binder : MediaBrowserServiceCompat.this.mConnections.keySet()) {
                    ConnectionRecord connection = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(binder);
                    if (!connection.subscriptions.contains(parentId)) continue;
                    MediaBrowserServiceCompat.this.performLoadChildren(parentId, connection);
                }
            }
        });
    }

    private boolean isValidPackage(String pkg, int uid) {
        if (pkg == null) {
            return false;
        }
        PackageManager pm = this.getPackageManager();
        String[] packages = pm.getPackagesForUid(uid);
        int N = packages.length;
        for (int i = 0; i < N; ++i) {
            if (!packages[i].equals(pkg)) continue;
            return true;
        }
        return false;
    }

    private void addSubscription(String id, ConnectionRecord connection) {
        connection.subscriptions.add(id);
        this.performLoadChildren(id, connection);
    }

    private void performLoadChildren(final String parentId, final ConnectionRecord connection) {
        Result<List<MediaBrowserCompat.MediaItem>> result = new Result<List<MediaBrowserCompat.MediaItem>>((Object)parentId){

            @Override
            void onResultSent(List<MediaBrowserCompat.MediaItem> list) {
                if (list == null) {
                    throw new IllegalStateException("onLoadChildren sent null list for id " + parentId);
                }
                if (MediaBrowserServiceCompat.this.mConnections.get(connection.callbacks.asBinder()) != connection) {
                    return;
                }
                try {
                    connection.callbacks.onLoadChildren(parentId, list);
                }
                catch (RemoteException ex) {
                    Log.w((String)MediaBrowserServiceCompat.TAG, (String)("Calling onLoadChildren() failed for id=" + parentId + " package=" + connection.pkg));
                }
            }
        };
        this.onLoadChildren(parentId, result);
        if (!result.isDone()) {
            throw new IllegalStateException("onLoadChildren must call detach() or sendResult() before returning for package=" + connection.pkg + " id=" + parentId);
        }
    }

    private void performLoadItem(String itemId, final ResultReceiver receiver) {
        Result<MediaBrowserCompat.MediaItem> result = new Result<MediaBrowserCompat.MediaItem>((Object)itemId){

            @Override
            void onResultSent(MediaBrowserCompat.MediaItem item) {
                Bundle bundle = new Bundle();
                bundle.putParcelable(MediaBrowserServiceCompat.KEY_MEDIA_ITEM, (Parcelable)item);
                receiver.send(0, bundle);
            }
        };
        this.onLoadItem(itemId, result);
        if (!result.isDone()) {
            throw new IllegalStateException("onLoadItem must call detach() or sendResult() before returning for id=" + itemId);
        }
    }

    public static final class BrowserRoot {
        private final String mRootId;
        private final Bundle mExtras;

        public BrowserRoot(@NonNull String rootId, @Nullable Bundle extras) {
            if (rootId == null) {
                throw new IllegalArgumentException("The root id in BrowserRoot cannot be null. Use null for BrowserRoot instead.");
            }
            this.mRootId = rootId;
            this.mExtras = extras;
        }

        public String getRootId() {
            return this.mRootId;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }
    }

    private class ServiceBinder
    extends IMediaBrowserServiceCompat.Stub {
        private ServiceBinder() {
        }

        @Override
        public void connect(final String pkg, final Bundle rootHints, final IMediaBrowserServiceCompatCallbacks callbacks) {
            final int uid = Binder.getCallingUid();
            if (!MediaBrowserServiceCompat.this.isValidPackage(pkg, uid)) {
                throw new IllegalArgumentException("Package/uid mismatch: uid=" + uid + " package=" + pkg);
            }
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder b = callbacks.asBinder();
                    MediaBrowserServiceCompat.this.mConnections.remove(b);
                    ConnectionRecord connection = new ConnectionRecord();
                    connection.pkg = pkg;
                    connection.rootHints = rootHints;
                    connection.callbacks = callbacks;
                    connection.root = MediaBrowserServiceCompat.this.onGetRoot(pkg, uid, rootHints);
                    if (connection.root == null) {
                        Log.i((String)MediaBrowserServiceCompat.TAG, (String)("No root for client " + pkg + " from service " + this.getClass().getName()));
                        try {
                            callbacks.onConnectFailed();
                        }
                        catch (RemoteException ex) {
                            Log.w((String)MediaBrowserServiceCompat.TAG, (String)("Calling onConnectFailed() failed. Ignoring. pkg=" + pkg));
                        }
                    } else {
                        try {
                            MediaBrowserServiceCompat.this.mConnections.put(b, connection);
                            if (MediaBrowserServiceCompat.this.mSession != null) {
                                callbacks.onConnect(connection.root.getRootId(), MediaBrowserServiceCompat.this.mSession, connection.root.getExtras());
                            }
                        }
                        catch (RemoteException ex) {
                            Log.w((String)MediaBrowserServiceCompat.TAG, (String)("Calling onConnect() failed. Dropping client. pkg=" + pkg));
                            MediaBrowserServiceCompat.this.mConnections.remove(b);
                        }
                    }
                }
            });
        }

        @Override
        public void disconnect(final IMediaBrowserServiceCompatCallbacks callbacks) {
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder b = callbacks.asBinder();
                    ConnectionRecord old = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.remove(b);
                    if (old != null) {
                        // empty if block
                    }
                }
            });
        }

        @Override
        public void addSubscription(final String id, final IMediaBrowserServiceCompatCallbacks callbacks) {
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder b = callbacks.asBinder();
                    ConnectionRecord connection = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(b);
                    if (connection == null) {
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)("addSubscription for callback that isn't registered id=" + id));
                        return;
                    }
                    MediaBrowserServiceCompat.this.addSubscription(id, connection);
                }
            });
        }

        @Override
        public void removeSubscription(final String id, final IMediaBrowserServiceCompatCallbacks callbacks) {
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder b = callbacks.asBinder();
                    ConnectionRecord connection = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(b);
                    if (connection == null) {
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)("removeSubscription for callback that isn't registered id=" + id));
                        return;
                    }
                    if (!connection.subscriptions.remove(id)) {
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)("removeSubscription called for " + id + " which is not subscribed"));
                    }
                }
            });
        }

        @Override
        public void getMediaItem(final String mediaId, final ResultReceiver receiver) {
            if (TextUtils.isEmpty((CharSequence)mediaId) || receiver == null) {
                return;
            }
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaBrowserServiceCompat.this.performLoadItem(mediaId, receiver);
                }
            });
        }
    }

    public class Result<T> {
        private Object mDebug;
        private boolean mDetachCalled;
        private boolean mSendResultCalled;

        Result(Object debug) {
            this.mDebug = debug;
        }

        public void sendResult(T result) {
            if (this.mSendResultCalled) {
                throw new IllegalStateException("sendResult() called twice for: " + this.mDebug);
            }
            this.mSendResultCalled = true;
            this.onResultSent(result);
        }

        public void detach() {
            if (this.mDetachCalled) {
                throw new IllegalStateException("detach() called when detach() had already been called for: " + this.mDebug);
            }
            if (this.mSendResultCalled) {
                throw new IllegalStateException("detach() called when sendResult() had already been called for: " + this.mDebug);
            }
            this.mDetachCalled = true;
        }

        boolean isDone() {
            return this.mDetachCalled || this.mSendResultCalled;
        }

        void onResultSent(T result) {
        }
    }

    private class ConnectionRecord {
        String pkg;
        Bundle rootHints;
        IMediaBrowserServiceCompatCallbacks callbacks;
        BrowserRoot root;
        HashSet<String> subscriptions = new HashSet();

        private ConnectionRecord() {
        }
    }
}

