//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;
#[cfg(feature = "objc2-core-video")]
use objc2_core_video::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-image-io")]
use objc2_image_io::*;
#[cfg(feature = "objc2-io-surface")]
use objc2_io_surface::*;
#[cfg(feature = "objc2-metal")]
use objc2_metal::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coreimage/ciformat?language=objc)
// NS_TYPED_ENUM
pub type CIFormat = c_int;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatargb8?language=objc)
    pub static kCIFormatARGB8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatbgra8?language=objc)
    pub static kCIFormatBGRA8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgba8?language=objc)
    pub static kCIFormatRGBA8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgbx8?language=objc)
    pub static kCIFormatRGBX8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatabgr8?language=objc)
    pub static kCIFormatABGR8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgbah?language=objc)
    pub static kCIFormatRGBAh: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgba16?language=objc)
    pub static kCIFormatRGBA16: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgbaf?language=objc)
    pub static kCIFormatRGBAf: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgbx16?language=objc)
    pub static kCIFormatRGBX16: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgbxh?language=objc)
    pub static kCIFormatRGBXh: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgbxf?language=objc)
    pub static kCIFormatRGBXf: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgb10?language=objc)
    pub static kCIFormatRGB10: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformata8?language=objc)
    pub static kCIFormatA8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformata16?language=objc)
    pub static kCIFormatA16: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatah?language=objc)
    pub static kCIFormatAh: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformataf?language=objc)
    pub static kCIFormatAf: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatr8?language=objc)
    pub static kCIFormatR8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatr16?language=objc)
    pub static kCIFormatR16: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrh?language=objc)
    pub static kCIFormatRh: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrf?language=objc)
    pub static kCIFormatRf: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrg8?language=objc)
    pub static kCIFormatRG8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrg16?language=objc)
    pub static kCIFormatRG16: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgh?language=objc)
    pub static kCIFormatRGh: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatrgf?language=objc)
    pub static kCIFormatRGf: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatl8?language=objc)
    pub static kCIFormatL8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatl16?language=objc)
    pub static kCIFormatL16: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatlh?language=objc)
    pub static kCIFormatLh: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatlf?language=objc)
    pub static kCIFormatLf: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatla8?language=objc)
    pub static kCIFormatLA8: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatla16?language=objc)
    pub static kCIFormatLA16: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatlah?language=objc)
    pub static kCIFormatLAh: CIFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciformatlaf?language=objc)
    pub static kCIFormatLAf: CIFormat;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreimage/ciimageoption?language=objc)
// NS_TYPED_ENUM
pub type CIImageOption = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagecolorspace?language=objc)
    pub static kCIImageColorSpace: &'static CIImageOption;
}

extern "C" {
    /// A Boolean value to control whether an image created with a CVPixelBuffer or an IOSurface
    /// should be cropped and offset according clean aperture attachments.
    ///
    /// For a `CVPixelBuffer` this will use `kCVImageBufferPreferredCleanApertureKey`
    /// or `kCVImageBufferCleanApertureKey`.
    ///
    /// If the value for this option is:
    /// * True: then image will be cropped and offset to the clean aperture.
    /// * False: then the full image is returned.
    /// * ``CIVector`` : then use it as a `CGRect` to crop and offset.
    /// * Not specified : then it will behave as if False was specified.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageapplycleanaperture?language=objc)
    pub static kCIImageApplyCleanAperture: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagetonemaphdrtosdr?language=objc)
    pub static kCIImageToneMapHDRtoSDR: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageexpandtohdr?language=objc)
    pub static kCIImageExpandToHDR: &'static CIImageOption;
}

extern "C" {
    /// A value for overriding the automatic behavior of the Content Headroom property
    /// when creating an image.
    ///
    /// The value for this key should be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagecontentheadroom?language=objc)
    pub static kCIImageContentHeadroom: &'static CIImageOption;
}

extern "C" {
    /// A value for overriding the automatic behavior of the Content Average Light Level property
    /// when creating an image.
    ///
    /// The value for this key should be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagecontentaveragelightlevel?language=objc)
    pub static kCIImageContentAverageLightLevel: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagenearestsampling?language=objc)
    pub static kCIImageNearestSampling: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagecacheimmediately?language=objc)
    pub static kCIImageCacheImmediately: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageproperties?language=objc)
    pub static kCIImageProperties: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageapplyorientationproperty?language=objc)
    pub static kCIImageApplyOrientationProperty: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagetexturetarget?language=objc)
    #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
    pub static kCIImageTextureTarget: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagetextureformat?language=objc)
    #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
    pub static kCIImageTextureFormat: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageauxiliarydepth?language=objc)
    pub static kCIImageAuxiliaryDepth: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageauxiliarydisparity?language=objc)
    pub static kCIImageAuxiliaryDisparity: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageauxiliaryportraiteffectsmatte?language=objc)
    pub static kCIImageAuxiliaryPortraitEffectsMatte: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageauxiliarysemanticsegmentationskinmatte?language=objc)
    pub static kCIImageAuxiliarySemanticSegmentationSkinMatte: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageauxiliarysemanticsegmentationhairmatte?language=objc)
    pub static kCIImageAuxiliarySemanticSegmentationHairMatte: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageauxiliarysemanticsegmentationteethmatte?language=objc)
    pub static kCIImageAuxiliarySemanticSegmentationTeethMatte: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageauxiliarysemanticsegmentationglassesmatte?language=objc)
    pub static kCIImageAuxiliarySemanticSegmentationGlassesMatte: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageauxiliarysemanticsegmentationskymatte?language=objc)
    pub static kCIImageAuxiliarySemanticSegmentationSkyMatte: &'static CIImageOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageauxiliaryhdrgainmap?language=objc)
    pub static kCIImageAuxiliaryHDRGainMap: &'static CIImageOption;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/ciimage?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIImage;
);

unsafe impl Send for CIImage {}

unsafe impl Sync for CIImage {}

extern_conformance!(
    unsafe impl NSCoding for CIImage {}
);

extern_conformance!(
    unsafe impl NSCopying for CIImage {}
);

unsafe impl CopyingHelper for CIImage {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIImage {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIImage {}
);

impl CIImage {
    extern_methods!(
        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(imageWithCGImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithCGImage(image: &CGImage) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-graphics")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(imageWithCGImage:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithCGImage_options(
            image: &CGImage,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<CIImage>;

        #[cfg(feature = "objc2-image-io")]
        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(imageWithCGImageSource:index:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithCGImageSource_index_options(
            source: &CGImageSource,
            index: usize,
            dict: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-graphics")]
        #[deprecated]
        #[unsafe(method(imageWithCGLayer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithCGLayer(layer: &CGLayer) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-graphics")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[deprecated]
        #[unsafe(method(imageWithCGLayer:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithCGLayer_options(
            layer: &CGLayer,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<CIImage>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        #[unsafe(method(imageWithBitmapData:bytesPerRow:size:format:colorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithBitmapData_bytesPerRow_size_format_colorSpace(
            data: &NSData,
            bytes_per_row: usize,
            size: CGSize,
            format: CIFormat,
            color_space: Option<&CGColorSpace>,
        ) -> Retained<CIImage>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
        #[unsafe(method(imageWithTexture:size:flipped:colorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithTexture_size_flipped_colorSpace(
            name: c_uint,
            size: CGSize,
            flipped: bool,
            color_space: Option<&CGColorSpace>,
        ) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
        #[unsafe(method(imageWithTexture:size:flipped:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithTexture_size_flipped_options(
            name: c_uint,
            size: CGSize,
            flipped: bool,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<CIImage>;

        #[cfg(feature = "objc2-metal")]
        /// # Safety
        ///
        /// - `texture` may need to be synchronized.
        /// - `texture` may be unretained, you must ensure it is kept alive while in use.
        /// - `options` generic should be of the correct type.
        #[unsafe(method(imageWithMTLTexture:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithMTLTexture_options(
            texture: &ProtocolObject<dyn MTLTexture>,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Option<Retained<CIImage>>;

        #[unsafe(method(imageWithContentsOfURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithContentsOfURL(url: &NSURL) -> Option<Retained<CIImage>>;

        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(imageWithContentsOfURL:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithContentsOfURL_options(
            url: &NSURL,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Option<Retained<CIImage>>;

        #[unsafe(method(imageWithData:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithData(data: &NSData) -> Option<Retained<CIImage>>;

        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(imageWithData:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithData_options(
            data: &NSData,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Option<Retained<CIImage>>;

        #[cfg(feature = "objc2-core-video")]
        #[unsafe(method(imageWithCVImageBuffer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithCVImageBuffer(image_buffer: &CVImageBuffer) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-video")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(imageWithCVImageBuffer:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithCVImageBuffer_options(
            image_buffer: &CVImageBuffer,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-video")]
        #[unsafe(method(imageWithCVPixelBuffer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithCVPixelBuffer(pixel_buffer: &CVPixelBuffer) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-video")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(imageWithCVPixelBuffer:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithCVPixelBuffer_options(
            pixel_buffer: &CVPixelBuffer,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<CIImage>;

        #[cfg(feature = "objc2-io-surface")]
        #[unsafe(method(imageWithIOSurface:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithIOSurface(surface: &IOSurfaceRef) -> Retained<CIImage>;

        #[cfg(feature = "objc2-io-surface")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(imageWithIOSurface:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithIOSurface_options(
            surface: &IOSurfaceRef,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<CIImage>;

        #[cfg(feature = "CIColor")]
        #[unsafe(method(imageWithColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithColor(color: &CIColor) -> Retained<CIImage>;

        #[unsafe(method(emptyImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn emptyImage() -> Retained<CIImage>;

        #[unsafe(method(blackImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn blackImage() -> Retained<CIImage>;

        #[unsafe(method(whiteImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn whiteImage() -> Retained<CIImage>;

        #[unsafe(method(grayImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn grayImage() -> Retained<CIImage>;

        #[unsafe(method(redImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn redImage() -> Retained<CIImage>;

        #[unsafe(method(greenImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn greenImage() -> Retained<CIImage>;

        #[unsafe(method(blueImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn blueImage() -> Retained<CIImage>;

        #[unsafe(method(cyanImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn cyanImage() -> Retained<CIImage>;

        #[unsafe(method(magentaImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn magentaImage() -> Retained<CIImage>;

        #[unsafe(method(yellowImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn yellowImage() -> Retained<CIImage>;

        #[unsafe(method(clearImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn clearImage() -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(initWithCGImage:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGImage(this: Allocated<Self>, image: &CGImage) -> Retained<Self>;

        #[cfg(feature = "objc2-core-graphics")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(initWithCGImage:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGImage_options(
            this: Allocated<Self>,
            image: &CGImage,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-image-io")]
        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(initWithCGImageSource:index:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGImageSource_index_options(
            this: Allocated<Self>,
            source: &CGImageSource,
            index: usize,
            dict: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-graphics")]
        #[deprecated = "Use initWithCGImage: instead."]
        #[unsafe(method(initWithCGLayer:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGLayer(this: Allocated<Self>, layer: &CGLayer) -> Retained<Self>;

        #[cfg(feature = "objc2-core-graphics")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[deprecated = "Use initWithCGImage:options instead."]
        #[unsafe(method(initWithCGLayer:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGLayer_options(
            this: Allocated<Self>,
            layer: &CGLayer,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithData(this: Allocated<Self>, data: &NSData) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(initWithData:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithData_options(
            this: Allocated<Self>,
            data: &NSData,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Option<Retained<Self>>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        #[unsafe(method(initWithBitmapData:bytesPerRow:size:format:colorSpace:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBitmapData_bytesPerRow_size_format_colorSpace(
            this: Allocated<Self>,
            data: &NSData,
            bytes_per_row: usize,
            size: CGSize,
            format: CIFormat,
            color_space: Option<&CGColorSpace>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
        #[unsafe(method(initWithTexture:size:flipped:colorSpace:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTexture_size_flipped_colorSpace(
            this: Allocated<Self>,
            name: c_uint,
            size: CGSize,
            flipped: bool,
            color_space: Option<&CGColorSpace>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
        #[unsafe(method(initWithTexture:size:flipped:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTexture_size_flipped_options(
            this: Allocated<Self>,
            name: c_uint,
            size: CGSize,
            flipped: bool,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-metal")]
        /// # Safety
        ///
        /// - `texture` may need to be synchronized.
        /// - `texture` may be unretained, you must ensure it is kept alive while in use.
        /// - `options` generic should be of the correct type.
        #[unsafe(method(initWithMTLTexture:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithMTLTexture_options(
            this: Allocated<Self>,
            texture: &ProtocolObject<dyn MTLTexture>,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithContentsOfURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL(
            this: Allocated<Self>,
            url: &NSURL,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(initWithContentsOfURL:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL_options(
            this: Allocated<Self>,
            url: &NSURL,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "objc2-io-surface")]
        #[unsafe(method(initWithIOSurface:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithIOSurface(
            this: Allocated<Self>,
            surface: &IOSurfaceRef,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-io-surface")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(initWithIOSurface:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithIOSurface_options(
            this: Allocated<Self>,
            surface: &IOSurfaceRef,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-io-surface")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[deprecated]
        #[unsafe(method(initWithIOSurface:plane:format:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithIOSurface_plane_format_options(
            this: Allocated<Self>,
            surface: &IOSurfaceRef,
            plane: usize,
            format: CIFormat,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-video")]
        #[unsafe(method(initWithCVImageBuffer:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCVImageBuffer(
            this: Allocated<Self>,
            image_buffer: &CVImageBuffer,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-video")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(initWithCVImageBuffer:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCVImageBuffer_options(
            this: Allocated<Self>,
            image_buffer: &CVImageBuffer,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-video")]
        #[unsafe(method(initWithCVPixelBuffer:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCVPixelBuffer(
            this: Allocated<Self>,
            pixel_buffer: &CVPixelBuffer,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-video")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(initWithCVPixelBuffer:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCVPixelBuffer_options(
            this: Allocated<Self>,
            pixel_buffer: &CVPixelBuffer,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<Self>;

        #[cfg(feature = "CIColor")]
        #[unsafe(method(initWithColor:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithColor(this: Allocated<Self>, color: &CIColor) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(imageByApplyingTransform:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByApplyingTransform(
            &self,
            matrix: CGAffineTransform,
        ) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(imageByApplyingTransform:highQualityDownsample:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByApplyingTransform_highQualityDownsample(
            &self,
            matrix: CGAffineTransform,
            high_quality_downsample: bool,
        ) -> Retained<CIImage>;

        #[unsafe(method(imageByApplyingOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByApplyingOrientation(&self, orientation: c_int) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(imageTransformForOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageTransformForOrientation(&self, orientation: c_int) -> CGAffineTransform;

        #[cfg(feature = "objc2-image-io")]
        #[unsafe(method(imageByApplyingCGOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByApplyingCGOrientation(
            &self,
            orientation: CGImagePropertyOrientation,
        ) -> Retained<CIImage>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-image-io"))]
        #[unsafe(method(imageTransformForCGOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageTransformForCGOrientation(
            &self,
            orientation: CGImagePropertyOrientation,
        ) -> CGAffineTransform;

        #[unsafe(method(imageByCompositingOverImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByCompositingOverImage(&self, dest: &CIImage) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(imageByCroppingToRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByCroppingToRect(&self, rect: CGRect) -> Retained<CIImage>;

        #[unsafe(method(imageByClampingToExtent))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByClampingToExtent(&self) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(imageByClampingToRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByClampingToRect(&self, rect: CGRect) -> Retained<CIImage>;

        /// # Safety
        ///
        /// `params` generic should be of the correct type.
        #[unsafe(method(imageByApplyingFilter:withInputParameters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByApplyingFilter_withInputParameters(
            &self,
            filter_name: &NSString,
            params: &NSDictionary<NSString, AnyObject>,
        ) -> Retained<CIImage>;

        #[unsafe(method(imageByApplyingFilter:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByApplyingFilter(&self, filter_name: &NSString) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(imageByColorMatchingColorSpaceToWorkingSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByColorMatchingColorSpaceToWorkingSpace(
            &self,
            color_space: &CGColorSpace,
        ) -> Option<Retained<CIImage>>;

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(imageByColorMatchingWorkingSpaceToColorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByColorMatchingWorkingSpaceToColorSpace(
            &self,
            color_space: &CGColorSpace,
        ) -> Option<Retained<CIImage>>;

        #[unsafe(method(imageByPremultiplyingAlpha))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByPremultiplyingAlpha(&self) -> Retained<CIImage>;

        #[unsafe(method(imageByUnpremultiplyingAlpha))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByUnpremultiplyingAlpha(&self) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(imageBySettingAlphaOneInExtent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageBySettingAlphaOneInExtent(&self, extent: CGRect) -> Retained<CIImage>;

        /// Create an image by applying a gaussian blur to the receiver.
        /// - Parameters:
        /// - sigma: The sigma of the gaussian blur to apply to the receiver.
        /// If the sigma is very small (less than `0.16`) then the receiver is returned.
        /// - Returns:
        /// An autoreleased ``CIImage`` instance or the received image.
        #[unsafe(method(imageByApplyingGaussianBlurWithSigma:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByApplyingGaussianBlurWithSigma(
            &self,
            sigma: c_double,
        ) -> Retained<CIImage>;

        /// Return a new image by changing the receiver's metadata properties.
        ///
        /// When you create an image, Core Image sets an image’s properties to a metadata
        /// dictionary as described here: ``properties``.
        /// Use this method to override an image’s metadata properties with new values.
        ///
        /// - Parameters:
        /// - properties: A dictionary of metadata properties akin to the `CGImageSourceCopyPropertiesAtIndex()` function.
        /// - Returns:
        /// An autoreleased ``CIImage`` instance with a copy of the new properties.
        ///
        /// # Safety
        ///
        /// `properties` generic should be of the correct type.
        #[unsafe(method(imageBySettingProperties:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageBySettingProperties(
            &self,
            properties: &NSDictionary,
        ) -> Retained<CIImage>;

        /// Create an image by changing the receiver's sample mode to bilinear interpolation.
        /// - Returns:
        /// An autoreleased ``CIImage`` instance with a bilinear sampling.
        #[unsafe(method(imageBySamplingLinear))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageBySamplingLinear(&self) -> Retained<CIImage>;

        /// Create an image by changing the receiver's sample mode to nearest neighbor.
        /// - Returns:
        /// An autoreleased ``CIImage`` instance with a nearest sampling.
        #[unsafe(method(imageBySamplingNearest))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageBySamplingNearest(&self) -> Retained<CIImage>;

        /// Create an image that inserts a intermediate that is cacheable
        ///
        /// This intermediate will be not be cached if ``kCIContextCacheIntermediates`` is false.
        /// - Returns:
        /// An autoreleased ``CIImage``.
        #[unsafe(method(imageByInsertingIntermediate))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByInsertingIntermediate(&self) -> Retained<CIImage>;

        /// Create an image that inserts a intermediate that is cacheable.
        ///
        /// - Parameters:
        /// - cache: Controls if Core Image caches the returned image.
        /// * `YES` : This intermediate will be cacheable even if
        /// ``kCIContextCacheIntermediates`` is false.
        /// * `NO`  : the intermediate will be not be cached if
        /// ``kCIContextCacheIntermediates`` is false.
        /// - Returns:
        /// An autoreleased ``CIImage``.
        #[unsafe(method(imageByInsertingIntermediate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByInsertingIntermediate_(&self, cache: bool) -> Retained<CIImage>;

        /// Create an image that inserts a intermediate that is cached in tiles
        ///
        /// This intermediate will be cacheable even if ``kCIContextCacheIntermediates`` is false.
        /// - Returns:
        /// An autoreleased ``CIImage``.
        #[unsafe(method(imageByInsertingTiledIntermediate))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByInsertingTiledIntermediate(&self) -> Retained<CIImage>;

        /// Create an image that applies a gain map Core Image image to the received Core Image image.
        ///
        /// The gain map image can be obtained by creating a ``CIImage`` instance from `NSURL`/`NSData`
        /// and setting the ``kCIImageAuxiliaryHDRGainMap`` option set to `
        /// `true``.
        ///
        /// If the gain map ``CIImage`` instance doesn't have the needed ``properties`` metadata,
        /// the received image will be returned as-is.
        ///
        /// - Returns:
        /// An autoreleased ``CIImage`` instance or the received image.
        #[unsafe(method(imageByApplyingGainMap:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByApplyingGainMap(&self, gainmap: &CIImage) -> Retained<CIImage>;

        /// Create an image that applies a gain map Core Image image with a specified headroom to the received Core Image image.
        ///
        /// - Parameters:
        /// - gainmap: The gain map ``CIImage`` instance to apply to the receiver.
        /// - headroom: a float value that specify how much headroom the resulting image should have.
        /// The headroom value will be limited to between 1.0 (i.e. SDR) and
        /// the full headroom allowed by the gain map.
        /// - Returns:
        /// An autoreleased ``CIImage`` instance or the received image.
        #[unsafe(method(imageByApplyingGainMap:headroom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByApplyingGainMap_headroom(
            &self,
            gainmap: &CIImage,
            headroom: c_float,
        ) -> Retained<CIImage>;

        /// Create an image by changing the receiver's contentHeadroom property.
        ///
        /// Changing this value will alter the behavior of the `CIToneMapHeadroom` and `CISystemToneMap` filters.
        /// * If the value is set to 0.0 then the returned image's headroom is unknown.
        /// * If the value is set to 1.0 then the returned image is SDR.
        /// * If the value is set to greater 1.0 then the returned image is HDR.
        /// * Otherwise the returned image's headroom is unknown.
        ///
        /// - Returns:
        /// An autoreleased ``CIImage``.
        #[unsafe(method(imageBySettingContentHeadroom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageBySettingContentHeadroom(&self, headroom: c_float) -> Retained<CIImage>;

        /// Create an image by changing the receiver's contentAverageLightLevel property.
        ///
        /// Changing this value will alter the behavior of the `CIToneMapHeadroom` and `CISystemToneMap` filters.
        /// * If the value is set to 0.0 or less then the returned image's ``contentAverageLightLevel`` is unknown.
        ///
        /// - Returns:
        /// An autoreleased ``CIImage``.
        #[unsafe(method(imageBySettingContentAverageLightLevel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageBySettingContentAverageLightLevel(
            &self,
            average: c_float,
        ) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns a rectangle the defines the bounds of non-(0,0,0,0) pixels in the image.
        /// > Note: the ``extent`` of `CIImage`` may be infinite or have a non-zero origin.
        #[unsafe(method(extent))]
        #[unsafe(method_family = none)]
        pub unsafe fn extent(&self) -> CGRect;

        /// Returns YES if the image is known to have and alpha value of `1.0` over the entire image extent.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(isOpaque))]
        #[unsafe(method_family = none)]
        pub unsafe fn isOpaque(&self) -> bool;

        /// Returns the metadata properties dictionary of the image.
        ///
        /// If the ``CIImage`` was created from `NSURL` or `NSData` then this dictionary is determined by calling `CGImageSourceCopyPropertiesAtIndex()`.
        ///
        /// If the ``CIImage`` was created with the ``kCIImageProperties`` option, then that dictionary is returned.
        ///
        /// If the ``CIImage`` was created by applying ``CIFilter-class`` or ``CIKernel`` then the
        /// properties of the root inputImage will be returned.
        #[unsafe(method(properties))]
        #[unsafe(method_family = none)]
        pub unsafe fn properties(&self) -> Retained<NSDictionary<NSString, AnyObject>>;

        #[cfg(feature = "CIFilterShape")]
        #[unsafe(method(definition))]
        #[unsafe(method_family = none)]
        pub unsafe fn definition(&self) -> Retained<CIFilterShape>;

        #[unsafe(method(url))]
        #[unsafe(method_family = none)]
        pub unsafe fn url(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(colorSpace))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorSpace(&self) -> Option<Retained<CGColorSpace>>;

        /// Returns the content headroom of the image.
        ///
        /// If the image headroom is unknown, then the value 0.0 will be returned.
        ///
        /// If the image headroom is known, then a value greater than or equal to 1.0 will be returned.
        /// A value of 1.0 will be returned if the image is SDR.
        /// A value greater than 1.0 will be returned if the image is HDR.
        ///
        /// The image headroom may known when a CIImage is first initialized.
        /// If the a CIImage is initialized using:
        /// * `NSURL` or `NSData` : the headroom may be determined by associated metadata
        /// or deduced from pixel format or colorSpace information.
        /// * `CGImage` : headroom may be determined by `CGImageGetHeadroomInfo()`
        /// or deduced from pixel format or colorSpace information.
        /// * `IOSurface` : then the headroom will be determined by `kIOSurfaceContentHeadroom`.
        /// or deduced from pixel format or colorSpace information.
        /// * `CVPixelBuffer` : then the headroom will be determined by `kCVImageBufferContentLightLevelInfoKey`.
        /// or deduced from pixel format or colorSpace information.
        /// * `BitmapData` : headroom may be deduced from pixel format or colorSpace information.
        ///
        /// If the image is the result of applying a ``CIFilter-class`` or ``CIKernel``, this method will return `0.0`.
        ///
        /// There are exceptions to this.  Applying a `CIWarpKernel`` or certain ``CIFilter-class``
        /// (e.g. `CIGaussianBlur`, `CILanczosScaleTransform`, `CIAreaAverage` and some others)
        /// to an image will result in a ``CIImage`` instance with the same `contentHeadroom` property value.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(contentHeadroom))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentHeadroom(&self) -> c_float;

        /// Returns the content average light level of the image.
        ///
        /// If the image average light level is unknown, then the value 0.0 will be returned.
        ///
        /// If the image headroom is known, then a value greater than or equal to 0.0 will be returned.
        ///
        /// The image average light level may known when a CIImage is first initialized.
        /// If the a CIImage is initialized with a:
        /// * `CGImage` : then the headroom will be determined by `CGImageGetContentAverageLightLevel()`.
        /// * `CVPixelBuffer` : then the headroom will be determined by `kCVImageBufferContentLightLevelInfoKey`.
        ///
        /// If the image is the result of applying a ``CIFilter-class`` or ``CIKernel``, this property will return `0.0`.
        ///
        /// There are exceptions to this.  Applying a ``CIWarpKernel`` or certain ``CIFilter-class``
        /// (e.g. `CIGaussianBlur`, `CILanczosScaleTransform`, `CIAreaAverage` and some others)
        /// to an image will result in a ``CIImage`` instance with the same `contentAverageLightLevel` property value.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(contentAverageLightLevel))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentAverageLightLevel(&self) -> c_float;

        #[cfg(feature = "objc2-core-video")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(pixelBuffer))]
        #[unsafe(method_family = none)]
        pub unsafe fn pixelBuffer(&self) -> Option<Retained<CVPixelBuffer>>;

        #[cfg(feature = "objc2-core-graphics")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(CGImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn CGImage(&self) -> Option<Retained<CGImage>>;

        #[cfg(feature = "objc2-metal")]
        /// Returns a Metal Texture if the Core Image image was created with a texture.
        ///
        /// This will return non-nil if the image was created with ``/CIImage/imageWithMTLTexture:options:`` and no options.
        /// Otherwise this property will be `nil` you should instead call
        /// ``/CIContext/render:toMTLTexture:commandBuffer:bounds:colorSpace:``.
        /// > Warning: Modifying the contents of this texture will cause the ``CIImage`` instance to render with incorrect results.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(metalTexture))]
        #[unsafe(method_family = none)]
        pub unsafe fn metalTexture(&self) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(regionOfInterestForImage:inRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn regionOfInterestForImage_inRect(
            &self,
            image: &CIImage,
            rect: CGRect,
        ) -> CGRect;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIImage {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreimage/ciimageautoadjustmentoption?language=objc)
// NS_TYPED_ENUM
pub type CIImageAutoAdjustmentOption = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageautoadjustenhance?language=objc)
    pub static kCIImageAutoAdjustEnhance: &'static CIImageAutoAdjustmentOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageautoadjustredeye?language=objc)
    pub static kCIImageAutoAdjustRedEye: &'static CIImageAutoAdjustmentOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageautoadjustfeatures?language=objc)
    pub static kCIImageAutoAdjustFeatures: &'static CIImageAutoAdjustmentOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageautoadjustcrop?language=objc)
    pub static kCIImageAutoAdjustCrop: &'static CIImageAutoAdjustmentOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageautoadjustlevel?language=objc)
    pub static kCIImageAutoAdjustLevel: &'static CIImageAutoAdjustmentOption;
}

/// AutoAdjustment.
impl CIImage {
    extern_methods!(
        #[cfg(feature = "CIFilter")]
        #[unsafe(method(autoAdjustmentFilters))]
        #[unsafe(method_family = none)]
        pub unsafe fn autoAdjustmentFilters(&self) -> Retained<NSArray<CIFilter>>;

        #[cfg(feature = "CIFilter")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(autoAdjustmentFiltersWithOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn autoAdjustmentFiltersWithOptions(
            &self,
            options: Option<&NSDictionary<CIImageAutoAdjustmentOption, AnyObject>>,
        ) -> Retained<NSArray<CIFilter>>;
    );
}

/// LabConversion.
impl CIImage {
    extern_methods!(
        #[unsafe(method(imageByConvertingWorkingSpaceToLab))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByConvertingWorkingSpaceToLab(&self) -> Retained<CIImage>;

        #[unsafe(method(imageByConvertingLabToWorkingSpace))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageByConvertingLabToWorkingSpace(&self) -> Retained<CIImage>;
    );
}
