/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha3

import (
	context "context"

	resourcev1alpha3 "k8s.io/api/resource/v1alpha3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	applyconfigurationsresourcev1alpha3 "k8s.io/client-go/applyconfigurations/resource/v1alpha3"
	gentype "k8s.io/client-go/gentype"
	scheme "k8s.io/client-go/kubernetes/scheme"
)

// ResourceClaimsGetter has a method to return a ResourceClaimInterface.
// A group's client should implement this interface.
type ResourceClaimsGetter interface {
	ResourceClaims(namespace string) ResourceClaimInterface
}

// ResourceClaimInterface has methods to work with ResourceClaim resources.
type ResourceClaimInterface interface {
	Create(ctx context.Context, resourceClaim *resourcev1alpha3.ResourceClaim, opts v1.CreateOptions) (*resourcev1alpha3.ResourceClaim, error)
	Update(ctx context.Context, resourceClaim *resourcev1alpha3.ResourceClaim, opts v1.UpdateOptions) (*resourcev1alpha3.ResourceClaim, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, resourceClaim *resourcev1alpha3.ResourceClaim, opts v1.UpdateOptions) (*resourcev1alpha3.ResourceClaim, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*resourcev1alpha3.ResourceClaim, error)
	List(ctx context.Context, opts v1.ListOptions) (*resourcev1alpha3.ResourceClaimList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *resourcev1alpha3.ResourceClaim, err error)
	Apply(ctx context.Context, resourceClaim *applyconfigurationsresourcev1alpha3.ResourceClaimApplyConfiguration, opts v1.ApplyOptions) (result *resourcev1alpha3.ResourceClaim, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, resourceClaim *applyconfigurationsresourcev1alpha3.ResourceClaimApplyConfiguration, opts v1.ApplyOptions) (result *resourcev1alpha3.ResourceClaim, err error)
	ResourceClaimExpansion
}

// resourceClaims implements ResourceClaimInterface
type resourceClaims struct {
	*gentype.ClientWithListAndApply[*resourcev1alpha3.ResourceClaim, *resourcev1alpha3.ResourceClaimList, *applyconfigurationsresourcev1alpha3.ResourceClaimApplyConfiguration]
}

// newResourceClaims returns a ResourceClaims
func newResourceClaims(c *ResourceV1alpha3Client, namespace string) *resourceClaims {
	return &resourceClaims{
		gentype.NewClientWithListAndApply[*resourcev1alpha3.ResourceClaim, *resourcev1alpha3.ResourceClaimList, *applyconfigurationsresourcev1alpha3.ResourceClaimApplyConfiguration](
			"resourceclaims",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *resourcev1alpha3.ResourceClaim { return &resourcev1alpha3.ResourceClaim{} },
			func() *resourcev1alpha3.ResourceClaimList { return &resourcev1alpha3.ResourceClaimList{} },
			gentype.PrefersProtobuf[*resourcev1alpha3.ResourceClaim](),
		),
	}
}
