##########################################################################
#
# Copyright 2012 Jose Fonseca
# All Rights Reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
##########################################################################/


from .dxgi import *
from .d3d11sdklayers import *


HRESULT = MAKE_HRESULT([
    "D3D11_ERROR_FILE_NOT_FOUND",
    "D3D11_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS",
    "D3D11_ERROR_TOO_MANY_UNIQUE_VIEW_OBJECTS",
    "D3D11_ERROR_DEFERRED_CONTEXT_MAP_WITHOUT_INITIAL_DISCARD",
    "D3DERR_INVALIDCALL",
    "D3DERR_WASSTILLDRAWING",
])


ID3D11DepthStencilState = Interface("ID3D11DepthStencilState", ID3D11DeviceChild)
ID3D11BlendState = Interface("ID3D11BlendState", ID3D11DeviceChild)
ID3D11RasterizerState = Interface("ID3D11RasterizerState", ID3D11DeviceChild)
ID3D11Resource = Interface("ID3D11Resource", ID3D11DeviceChild)
ID3D11Buffer = Interface("ID3D11Buffer", ID3D11Resource)
ID3D11Texture1D = Interface("ID3D11Texture1D", ID3D11Resource)
ID3D11Texture2D = Interface("ID3D11Texture2D", ID3D11Resource)
ID3D11Texture3D = Interface("ID3D11Texture3D", ID3D11Resource)
ID3D11View = Interface("ID3D11View", ID3D11DeviceChild)
ID3D11ShaderResourceView = Interface("ID3D11ShaderResourceView", ID3D11View)
ID3D11RenderTargetView = Interface("ID3D11RenderTargetView", ID3D11View)
ID3D11DepthStencilView = Interface("ID3D11DepthStencilView", ID3D11View)
ID3D11UnorderedAccessView = Interface("ID3D11UnorderedAccessView", ID3D11View)
ID3D11VertexShader = Interface("ID3D11VertexShader", ID3D11DeviceChild)
ID3D11HullShader = Interface("ID3D11HullShader", ID3D11DeviceChild)
ID3D11DomainShader = Interface("ID3D11DomainShader", ID3D11DeviceChild)
ID3D11GeometryShader = Interface("ID3D11GeometryShader", ID3D11DeviceChild)
ID3D11PixelShader = Interface("ID3D11PixelShader", ID3D11DeviceChild)
ID3D11ComputeShader = Interface("ID3D11ComputeShader", ID3D11DeviceChild)
ID3D11InputLayout = Interface("ID3D11InputLayout", ID3D11DeviceChild)
ID3D11SamplerState = Interface("ID3D11SamplerState", ID3D11DeviceChild)
ID3D11Asynchronous = Interface("ID3D11Asynchronous", ID3D11DeviceChild)
ID3D11Query = Interface("ID3D11Query", ID3D11Asynchronous)
ID3D11Predicate = Interface("ID3D11Predicate", ID3D11Query)
ID3D11Counter = Interface("ID3D11Counter", ID3D11Asynchronous)
ID3D11ClassInstance = Interface("ID3D11ClassInstance", ID3D11DeviceChild)
ID3D11ClassLinkage = Interface("ID3D11ClassLinkage", ID3D11DeviceChild)
ID3D11CommandList = Interface("ID3D11CommandList", ID3D11DeviceChild)
ID3D11Device = Interface("ID3D11Device", IUnknown)


D3D11_PRIMITIVE_TOPOLOGY = Enum("D3D11_PRIMITIVE_TOPOLOGY", [
    "D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED",
    "D3D11_PRIMITIVE_TOPOLOGY_POINTLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_LINELIST",
    "D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP",
    "D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST",
    "D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP",
    "D3D11_PRIMITIVE_TOPOLOGY_LINELIST_ADJ",
    "D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ",
    "D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ",
    "D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ",
    "D3D11_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST",
])

D3D11_INPUT_CLASSIFICATION = Enum("D3D11_INPUT_CLASSIFICATION", [
    "D3D11_INPUT_PER_VERTEX_DATA",
    "D3D11_INPUT_PER_INSTANCE_DATA",
])

D3D11_INPUT_ELEMENT_ALIGNED_BYTE_OFFSET = FakeEnum(UINT, [
    "D3D11_APPEND_ALIGNED_ELEMENT",
])

D3D11_INPUT_ELEMENT_DESC = Struct("D3D11_INPUT_ELEMENT_DESC", [
    (LPCSTR, "SemanticName"),
    (UINT, "SemanticIndex"),
    (DXGI_FORMAT, "Format"),
    (UINT, "InputSlot"),
    (D3D11_INPUT_ELEMENT_ALIGNED_BYTE_OFFSET, "AlignedByteOffset"),
    (D3D11_INPUT_CLASSIFICATION, "InputSlotClass"),
    (UINT, "InstanceDataStepRate"),
])

D3D11_FILL_MODE = Enum("D3D11_FILL_MODE", [
    "D3D11_FILL_WIREFRAME",
    "D3D11_FILL_SOLID",
])

D3D11_PRIMITIVE_TOPOLOGY = Enum("D3D11_PRIMITIVE_TOPOLOGY", [
    "D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED",
    "D3D11_PRIMITIVE_TOPOLOGY_POINTLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_LINELIST",
    "D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP",
    "D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST",
    "D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP",
    "D3D11_PRIMITIVE_TOPOLOGY_LINELIST_ADJ",
    "D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ",
    "D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ",
    "D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ",
    "D3D11_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST",
    "D3D11_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST",
])

D3D11_PRIMITIVE = Enum("D3D11_PRIMITIVE", [
    "D3D11_PRIMITIVE_UNDEFINED",
    "D3D11_PRIMITIVE_POINT",
    "D3D11_PRIMITIVE_LINE",
    "D3D11_PRIMITIVE_TRIANGLE",
    "D3D11_PRIMITIVE_LINE_ADJ",
    "D3D11_PRIMITIVE_TRIANGLE_ADJ",
    "D3D11_PRIMITIVE_1_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_2_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_3_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_4_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_5_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_6_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_7_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_8_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_9_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_10_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_11_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_12_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_13_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_14_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_15_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_16_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_17_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_18_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_19_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_20_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_21_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_22_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_23_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_24_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_25_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_26_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_27_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_28_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_29_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_30_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_31_CONTROL_POINT_PATCH",
    "D3D11_PRIMITIVE_32_CONTROL_POINT_PATCH",
])

D3D11_CULL_MODE = Enum("D3D11_CULL_MODE", [
    "D3D11_CULL_NONE",
    "D3D11_CULL_FRONT",
    "D3D11_CULL_BACK",
])

D3D11_SO_DECLARATION_ENTRY = Struct("D3D11_SO_DECLARATION_ENTRY", [
    (UINT, "Stream"),
    (LPCSTR, "SemanticName"),
    (UINT, "SemanticIndex"),
    (BYTE, "StartComponent"),
    (BYTE, "ComponentCount"),
    (BYTE, "OutputSlot"),
])

D3D11_VIEWPORT = Struct("D3D11_VIEWPORT", [
    (FLOAT, "TopLeftX"),
    (FLOAT, "TopLeftY"),
    (FLOAT, "Width"),
    (FLOAT, "Height"),
    (FLOAT, "MinDepth"),
    (FLOAT, "MaxDepth"),
])

D3D11_RESOURCE_DIMENSION = Enum("D3D11_RESOURCE_DIMENSION", [
    "D3D11_RESOURCE_DIMENSION_UNKNOWN",
    "D3D11_RESOURCE_DIMENSION_BUFFER",
    "D3D11_RESOURCE_DIMENSION_TEXTURE1D",
    "D3D11_RESOURCE_DIMENSION_TEXTURE2D",
    "D3D11_RESOURCE_DIMENSION_TEXTURE3D",
])

D3D11_SRV_DIMENSION = Enum("D3D11_SRV_DIMENSION", [
    "D3D11_SRV_DIMENSION_UNKNOWN",
    "D3D11_SRV_DIMENSION_BUFFER",
    "D3D11_SRV_DIMENSION_TEXTURE1D",
    "D3D11_SRV_DIMENSION_TEXTURE1DARRAY",
    "D3D11_SRV_DIMENSION_TEXTURE2D",
    "D3D11_SRV_DIMENSION_TEXTURE2DARRAY",
    "D3D11_SRV_DIMENSION_TEXTURE2DMS",
    "D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY",
    "D3D11_SRV_DIMENSION_TEXTURE3D",
    "D3D11_SRV_DIMENSION_TEXTURECUBE",
    "D3D11_SRV_DIMENSION_TEXTURECUBEARRAY",
    "D3D11_SRV_DIMENSION_BUFFEREX",
])

D3D11_DSV_DIMENSION = Enum("D3D11_DSV_DIMENSION", [
    "D3D11_DSV_DIMENSION_UNKNOWN",
    "D3D11_DSV_DIMENSION_TEXTURE1D",
    "D3D11_DSV_DIMENSION_TEXTURE1DARRAY",
    "D3D11_DSV_DIMENSION_TEXTURE2D",
    "D3D11_DSV_DIMENSION_TEXTURE2DARRAY",
    "D3D11_DSV_DIMENSION_TEXTURE2DMS",
    "D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY",
])

D3D11_RTV_DIMENSION = Enum("D3D11_RTV_DIMENSION", [
    "D3D11_RTV_DIMENSION_UNKNOWN",
    "D3D11_RTV_DIMENSION_BUFFER",
    "D3D11_RTV_DIMENSION_TEXTURE1D",
    "D3D11_RTV_DIMENSION_TEXTURE1DARRAY",
    "D3D11_RTV_DIMENSION_TEXTURE2D",
    "D3D11_RTV_DIMENSION_TEXTURE2DARRAY",
    "D3D11_RTV_DIMENSION_TEXTURE2DMS",
    "D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY",
    "D3D11_RTV_DIMENSION_TEXTURE3D",
])

D3D11_UAV_DIMENSION = Enum("D3D11_UAV_DIMENSION", [
    "D3D11_UAV_DIMENSION_UNKNOWN",
    "D3D11_UAV_DIMENSION_BUFFER",
    "D3D11_UAV_DIMENSION_TEXTURE1D",
    "D3D11_UAV_DIMENSION_TEXTURE1DARRAY",
    "D3D11_UAV_DIMENSION_TEXTURE2D",
    "D3D11_UAV_DIMENSION_TEXTURE2DARRAY",
    "D3D11_UAV_DIMENSION_TEXTURE3D",
])

D3D11_USAGE = Enum("D3D11_USAGE", [
    "D3D11_USAGE_DEFAULT",
    "D3D11_USAGE_IMMUTABLE",
    "D3D11_USAGE_DYNAMIC",
    "D3D11_USAGE_STAGING",
])

D3D11_BIND_FLAG = Flags(UINT, [
    "D3D11_BIND_VERTEX_BUFFER",
    "D3D11_BIND_INDEX_BUFFER",
    "D3D11_BIND_CONSTANT_BUFFER",
    "D3D11_BIND_SHADER_RESOURCE",
    "D3D11_BIND_STREAM_OUTPUT",
    "D3D11_BIND_RENDER_TARGET",
    "D3D11_BIND_DEPTH_STENCIL",
    "D3D11_BIND_UNORDERED_ACCESS",
    "D3D11_BIND_DECODER",
    "D3D11_BIND_VIDEO_ENCODER",
])

D3D11_CPU_ACCESS_FLAG = Flags(UINT, [
    "D3D11_CPU_ACCESS_WRITE",
    "D3D11_CPU_ACCESS_READ",
])

D3D11_RESOURCE_MISC_FLAG = Flags(UINT, [
    "D3D11_RESOURCE_MISC_GENERATE_MIPS",
    "D3D11_RESOURCE_MISC_SHARED",
    "D3D11_RESOURCE_MISC_TEXTURECUBE",
    "D3D11_RESOURCE_MISC_DRAWINDIRECT_ARGS",
    "D3D11_RESOURCE_MISC_BUFFER_ALLOW_RAW_VIEWS",
    "D3D11_RESOURCE_MISC_BUFFER_STRUCTURED",
    "D3D11_RESOURCE_MISC_RESOURCE_CLAMP",
    "D3D11_RESOURCE_MISC_SHARED_KEYEDMUTEX",
    "D3D11_RESOURCE_MISC_GDI_COMPATIBLE",
    "D3D11_RESOURCE_MISC_SHARED_NTHANDLE",
    "D3D11_RESOURCE_MISC_RESTRICTED_CONTENT",
    "D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE",
    "D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE_DRIVER",
    "D3D11_RESOURCE_MISC_GUARDED",
    "D3D11_RESOURCE_MISC_TILE_POOL",
    "D3D11_RESOURCE_MISC_TILED",
    "D3D11_RESOURCE_MISC_HW_PROTECTED",
])

D3D11_MAP = Enum("D3D11_MAP", [
    "D3D11_MAP_READ",
    "D3D11_MAP_WRITE",
    "D3D11_MAP_READ_WRITE",
    "D3D11_MAP_WRITE_DISCARD",
    "D3D11_MAP_WRITE_NO_OVERWRITE",
])

D3D11_MAP_FLAG = Flags(UINT, [
    "D3D11_MAP_FLAG_DO_NOT_WAIT",
])

D3D11_RAISE_FLAG = Flags(UINT, [
    "D3D11_RAISE_FLAG_DRIVER_INTERNAL_ERROR",
])

D3D11_CLEAR_FLAG = Flags(UINT, [
    "D3D11_CLEAR_DEPTH",
    "D3D11_CLEAR_STENCIL",
])

D3D11_RECT = Alias("D3D11_RECT", RECT)
D3D11_BOX = Struct("D3D11_BOX", [
    (UINT, "left"),
    (UINT, "top"),
    (UINT, "front"),
    (UINT, "right"),
    (UINT, "bottom"),
    (UINT, "back"),
])

ID3D11DeviceChild.methods += [
    StdMethod(Void, "GetDevice", [Out(Pointer(ObjPointer(ID3D11Device)), "ppDevice")]),
    StdMethod(HRESULT, "GetPrivateData", [(REFGUID, "guid"), InOut(Pointer(UINT), "pDataSize"), Out(OpaquePointer(Void), "pData")], sideeffects=False),
    StdMethod(HRESULT, "SetPrivateData", [(REFGUID, "guid"), (UINT, "DataSize"), (OpaqueBlob(Const(Void), "DataSize"), "pData")]),
    StdMethod(HRESULT, "SetPrivateDataInterface", [(REFGUID, "guid"), (OpaquePointer(Const(IUnknown)), "pData")], sideeffects=False),
]

D3D11_COMPARISON_FUNC = Enum("D3D11_COMPARISON_FUNC", [
    "D3D11_COMPARISON_NEVER",
    "D3D11_COMPARISON_LESS",
    "D3D11_COMPARISON_EQUAL",
    "D3D11_COMPARISON_LESS_EQUAL",
    "D3D11_COMPARISON_GREATER",
    "D3D11_COMPARISON_NOT_EQUAL",
    "D3D11_COMPARISON_GREATER_EQUAL",
    "D3D11_COMPARISON_ALWAYS",
])

D3D11_DEPTH_WRITE_MASK = Enum("D3D11_DEPTH_WRITE_MASK", [
    "D3D11_DEPTH_WRITE_MASK_ZERO",
    "D3D11_DEPTH_WRITE_MASK_ALL",
])

D3D11_STENCIL_OP = Enum("D3D11_STENCIL_OP", [
    "D3D11_STENCIL_OP_KEEP",
    "D3D11_STENCIL_OP_ZERO",
    "D3D11_STENCIL_OP_REPLACE",
    "D3D11_STENCIL_OP_INCR_SAT",
    "D3D11_STENCIL_OP_DECR_SAT",
    "D3D11_STENCIL_OP_INVERT",
    "D3D11_STENCIL_OP_INCR",
    "D3D11_STENCIL_OP_DECR",
])

D3D11_DEPTH_STENCILOP_DESC = Struct("D3D11_DEPTH_STENCILOP_DESC", [
    (D3D11_STENCIL_OP, "StencilFailOp"),
    (D3D11_STENCIL_OP, "StencilDepthFailOp"),
    (D3D11_STENCIL_OP, "StencilPassOp"),
    (D3D11_COMPARISON_FUNC, "StencilFunc"),
])

D3D11_DEPTH_STENCIL_DESC = Struct("D3D11_DEPTH_STENCIL_DESC", [
    (BOOL, "DepthEnable"),
    (D3D11_DEPTH_WRITE_MASK, "DepthWriteMask"),
    (D3D11_COMPARISON_FUNC, "DepthFunc"),
    (BOOL, "StencilEnable"),
    (UINT8, "StencilReadMask"),
    (UINT8, "StencilWriteMask"),
    (D3D11_DEPTH_STENCILOP_DESC, "FrontFace"),
    (D3D11_DEPTH_STENCILOP_DESC, "BackFace"),
])

ID3D11DepthStencilState.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_DEPTH_STENCIL_DESC), "pDesc")], sideeffects=False),
]

D3D11_BLEND = Enum("D3D11_BLEND", [
    "D3D11_BLEND_ZERO",
    "D3D11_BLEND_ONE",
    "D3D11_BLEND_SRC_COLOR",
    "D3D11_BLEND_INV_SRC_COLOR",
    "D3D11_BLEND_SRC_ALPHA",
    "D3D11_BLEND_INV_SRC_ALPHA",
    "D3D11_BLEND_DEST_ALPHA",
    "D3D11_BLEND_INV_DEST_ALPHA",
    "D3D11_BLEND_DEST_COLOR",
    "D3D11_BLEND_INV_DEST_COLOR",
    "D3D11_BLEND_SRC_ALPHA_SAT",
    "D3D11_BLEND_BLEND_FACTOR",
    "D3D11_BLEND_INV_BLEND_FACTOR",
    "D3D11_BLEND_SRC1_COLOR",
    "D3D11_BLEND_INV_SRC1_COLOR",
    "D3D11_BLEND_SRC1_ALPHA",
    "D3D11_BLEND_INV_SRC1_ALPHA",
])

D3D11_BLEND_OP = Enum("D3D11_BLEND_OP", [
    "D3D11_BLEND_OP_ADD",
    "D3D11_BLEND_OP_SUBTRACT",
    "D3D11_BLEND_OP_REV_SUBTRACT",
    "D3D11_BLEND_OP_MIN",
    "D3D11_BLEND_OP_MAX",
])

D3D11_COLOR_WRITE_ENABLE = Enum("D3D11_COLOR_WRITE_ENABLE", [
    "D3D11_COLOR_WRITE_ENABLE_ALL",
    "D3D11_COLOR_WRITE_ENABLE_RED",
    "D3D11_COLOR_WRITE_ENABLE_GREEN",
    "D3D11_COLOR_WRITE_ENABLE_BLUE",
    "D3D11_COLOR_WRITE_ENABLE_ALPHA",
])

D3D11_RENDER_TARGET_BLEND_DESC = Struct("D3D11_RENDER_TARGET_BLEND_DESC", [
    (BOOL, "BlendEnable"),
    (D3D11_BLEND, "SrcBlend"),
    (D3D11_BLEND, "DestBlend"),
    (D3D11_BLEND_OP, "BlendOp"),
    (D3D11_BLEND, "SrcBlendAlpha"),
    (D3D11_BLEND, "DestBlendAlpha"),
    (D3D11_BLEND_OP, "BlendOpAlpha"),
    (UINT8, "RenderTargetWriteMask"),
])

D3D11_BLEND_DESC = Struct("D3D11_BLEND_DESC", [
    (BOOL, "AlphaToCoverageEnable"),
    (BOOL, "IndependentBlendEnable"),
    (Array(D3D11_RENDER_TARGET_BLEND_DESC, 8), "RenderTarget"),
])

ID3D11BlendState.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_BLEND_DESC), "pDesc")], sideeffects=False),
]

D3D11_RASTERIZER_DESC = Struct("D3D11_RASTERIZER_DESC", [
    (D3D11_FILL_MODE, "FillMode"),
    (D3D11_CULL_MODE, "CullMode"),
    (BOOL, "FrontCounterClockwise"),
    (INT, "DepthBias"),
    (FLOAT, "DepthBiasClamp"),
    (FLOAT, "SlopeScaledDepthBias"),
    (BOOL, "DepthClipEnable"),
    (BOOL, "ScissorEnable"),
    (BOOL, "MultisampleEnable"),
    (BOOL, "AntialiasedLineEnable"),
])

ID3D11RasterizerState.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_RASTERIZER_DESC), "pDesc")], sideeffects=False),
]

D3D11_SUBRESOURCE_DATA = Struct("D3D11_SUBRESOURCE_DATA", [
    (Blob(Const(Void), "_calcSubresourceSize(pDesc, {i}, {self}.SysMemPitch, {self}.SysMemSlicePitch)"), "pSysMem"),
    (UINT, "SysMemPitch"),
    (UINT, "SysMemSlicePitch"),
])

D3D11_MAPPED_SUBRESOURCE = Struct("D3D11_MAPPED_SUBRESOURCE", [
    (LinearPointer(Void, "_MappedSize"), "pData"),
    (UINT, "RowPitch"),
    (UINT, "DepthPitch"),
])

ID3D11Resource.methods += [
    StdMethod(Void, "GetType", [Out(Pointer(D3D11_RESOURCE_DIMENSION), "pResourceDimension")], sideeffects=False),
    StdMethod(Void, "SetEvictionPriority", [(UINT, "EvictionPriority")]),
    StdMethod(UINT, "GetEvictionPriority", [], sideeffects=False),
]

D3D11_BUFFER_DESC = Struct("D3D11_BUFFER_DESC", [
    (UINT, "ByteWidth"),
    (D3D11_USAGE, "Usage"),
    (D3D11_BIND_FLAG, "BindFlags"),
    (D3D11_CPU_ACCESS_FLAG, "CPUAccessFlags"),
    (D3D11_RESOURCE_MISC_FLAG, "MiscFlags"),
    (UINT, "StructureByteStride"),
])

ID3D11Buffer.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_BUFFER_DESC), "pDesc")], sideeffects=False),
]

D3D11_TEXTURE1D_DESC = Struct("D3D11_TEXTURE1D_DESC", [
    (UINT, "Width"),
    (UINT, "MipLevels"),
    (UINT, "ArraySize"),
    (DXGI_FORMAT, "Format"),
    (D3D11_USAGE, "Usage"),
    (D3D11_BIND_FLAG, "BindFlags"),
    (D3D11_CPU_ACCESS_FLAG, "CPUAccessFlags"),
    (D3D11_RESOURCE_MISC_FLAG, "MiscFlags"),
])

ID3D11Texture1D.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_TEXTURE1D_DESC), "pDesc")], sideeffects=False),
]

D3D11_TEXTURE2D_DESC = Struct("D3D11_TEXTURE2D_DESC", [
    (UINT, "Width"),
    (UINT, "Height"),
    (UINT, "MipLevels"),
    (UINT, "ArraySize"),
    (DXGI_FORMAT, "Format"),
    (DXGI_SAMPLE_DESC, "SampleDesc"),
    (D3D11_USAGE, "Usage"),
    (D3D11_BIND_FLAG, "BindFlags"),
    (D3D11_CPU_ACCESS_FLAG, "CPUAccessFlags"),
    (D3D11_RESOURCE_MISC_FLAG, "MiscFlags"),
])

ID3D11Texture2D.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_TEXTURE2D_DESC), "pDesc")], sideeffects=False),
]

D3D11_TEXTURE3D_DESC = Struct("D3D11_TEXTURE3D_DESC", [
    (UINT, "Width"),
    (UINT, "Height"),
    (UINT, "Depth"),
    (UINT, "MipLevels"),
    (DXGI_FORMAT, "Format"),
    (D3D11_USAGE, "Usage"),
    (D3D11_BIND_FLAG, "BindFlags"),
    (D3D11_CPU_ACCESS_FLAG, "CPUAccessFlags"),
    (D3D11_RESOURCE_MISC_FLAG, "MiscFlags"),
])

ID3D11Texture3D.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_TEXTURE3D_DESC), "pDesc")], sideeffects=False),
]

D3D11_TEXTURECUBE_FACE = Enum("D3D11_TEXTURECUBE_FACE", [
    "D3D11_TEXTURECUBE_FACE_POSITIVE_X",
    "D3D11_TEXTURECUBE_FACE_NEGATIVE_X",
    "D3D11_TEXTURECUBE_FACE_POSITIVE_Y",
    "D3D11_TEXTURECUBE_FACE_NEGATIVE_Y",
    "D3D11_TEXTURECUBE_FACE_POSITIVE_Z",
    "D3D11_TEXTURECUBE_FACE_NEGATIVE_Z",
])

ID3D11View.methods += [
    StdMethod(Void, "GetResource", [Out(Pointer(ObjPointer(ID3D11Resource)), "ppResource")]),
]

D3D11_BUFFER_SRV = Struct("D3D11_BUFFER_SRV", [
    (UINT, "FirstElement"),
    (UINT, "NumElements"),
])

D3D11_BUFFEREX_SRV_FLAG = Flags(UINT, [
    "D3D11_BUFFEREX_SRV_FLAG_RAW",
])

D3D11_BUFFEREX_SRV = Struct("D3D11_BUFFEREX_SRV", [
    (UINT, "FirstElement"),
    (UINT, "NumElements"),
    (D3D11_BUFFEREX_SRV_FLAG, "Flags"),
])

D3D11_TEX1D_SRV = Struct("D3D11_TEX1D_SRV", [
    (UINT, "MostDetailedMip"),
    (UINT, "MipLevels"),
])

D3D11_TEX1D_ARRAY_SRV = Struct("D3D11_TEX1D_ARRAY_SRV", [
    (UINT, "MostDetailedMip"),
    (UINT, "MipLevels"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_TEX2D_SRV = Struct("D3D11_TEX2D_SRV", [
    (UINT, "MostDetailedMip"),
    (UINT, "MipLevels"),
])

D3D11_TEX2D_ARRAY_SRV = Struct("D3D11_TEX2D_ARRAY_SRV", [
    (UINT, "MostDetailedMip"),
    (UINT, "MipLevels"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_TEX3D_SRV = Struct("D3D11_TEX3D_SRV", [
    (UINT, "MostDetailedMip"),
    (UINT, "MipLevels"),
])

D3D11_TEXCUBE_SRV = Struct("D3D11_TEXCUBE_SRV", [
    (UINT, "MostDetailedMip"),
    (UINT, "MipLevels"),
])

D3D11_TEXCUBE_ARRAY_SRV = Struct("D3D11_TEXCUBE_ARRAY_SRV", [
    (UINT, "MostDetailedMip"),
    (UINT, "MipLevels"),
    (UINT, "First2DArrayFace"),
    (UINT, "NumCubes"),
])

D3D11_TEX2DMS_SRV = Struct("D3D11_TEX2DMS_SRV", [
    (UINT, "UnusedField_NothingToDefine"),
])

D3D11_TEX2DMS_ARRAY_SRV = Struct("D3D11_TEX2DMS_ARRAY_SRV", [
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_SHADER_RESOURCE_VIEW_DESC = Struct("D3D11_SHADER_RESOURCE_VIEW_DESC", [
    (DXGI_FORMAT, "Format"),
    (D3D11_SRV_DIMENSION, "ViewDimension"),
    (Union("{self}.ViewDimension", [
        ("D3D11_SRV_DIMENSION_BUFFER", D3D11_BUFFER_SRV, "Buffer"),
        ("D3D11_SRV_DIMENSION_TEXTURE1D", D3D11_TEX1D_SRV, "Texture1D"),
        ("D3D11_SRV_DIMENSION_TEXTURE1DARRAY", D3D11_TEX1D_ARRAY_SRV, "Texture1DArray"),
        ("D3D11_SRV_DIMENSION_TEXTURE2D", D3D11_TEX2D_SRV, "Texture2D"),
        ("D3D11_SRV_DIMENSION_TEXTURE2DARRAY", D3D11_TEX2D_ARRAY_SRV, "Texture2DArray"),
        ("D3D11_SRV_DIMENSION_TEXTURE2DMS", D3D11_TEX2DMS_SRV, "Texture2DMS"),
        ("D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY", D3D11_TEX2DMS_ARRAY_SRV, "Texture2DMSArray"),
        ("D3D11_SRV_DIMENSION_TEXTURE3D", D3D11_TEX3D_SRV, "Texture3D"),
        ("D3D11_SRV_DIMENSION_TEXTURECUBE", D3D11_TEXCUBE_SRV, "TextureCube"),
        ("D3D11_SRV_DIMENSION_TEXTURECUBEARRAY", D3D11_TEXCUBE_ARRAY_SRV, "TextureCubeArray"),
        ("D3D11_SRV_DIMENSION_BUFFEREX", D3D11_BUFFEREX_SRV, "BufferEx"),
    ]), None),
])

ID3D11ShaderResourceView.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_SHADER_RESOURCE_VIEW_DESC), "pDesc")], sideeffects=False),
]

D3D11_BUFFER_RTV = Struct("D3D11_BUFFER_RTV", [
    (UINT, "FirstElement"),
    (UINT, "NumElements"),
])

D3D11_TEX1D_RTV = Struct("D3D11_TEX1D_RTV", [
    (UINT, "MipSlice"),
])

D3D11_TEX1D_ARRAY_RTV = Struct("D3D11_TEX1D_ARRAY_RTV", [
    (UINT, "MipSlice"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_TEX2D_RTV = Struct("D3D11_TEX2D_RTV", [
    (UINT, "MipSlice"),
])

D3D11_TEX2DMS_RTV = Struct("D3D11_TEX2DMS_RTV", [
    (UINT, "UnusedField_NothingToDefine"),
])

D3D11_TEX2D_ARRAY_RTV = Struct("D3D11_TEX2D_ARRAY_RTV", [
    (UINT, "MipSlice"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_TEX2DMS_ARRAY_RTV = Struct("D3D11_TEX2DMS_ARRAY_RTV", [
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_TEX3D_RTV = Struct("D3D11_TEX3D_RTV", [
    (UINT, "MipSlice"),
    (UINT, "FirstWSlice"),
    (UINT, "WSize"),
])

D3D11_RENDER_TARGET_VIEW_DESC = Struct("D3D11_RENDER_TARGET_VIEW_DESC", [
    (DXGI_FORMAT, "Format"),
    (D3D11_RTV_DIMENSION, "ViewDimension"),
    (Union("{self}.ViewDimension", [
        ("D3D11_RTV_DIMENSION_BUFFER", D3D11_BUFFER_RTV, "Buffer"),
        ("D3D11_RTV_DIMENSION_TEXTURE1D", D3D11_TEX1D_RTV, "Texture1D"),
        ("D3D11_RTV_DIMENSION_TEXTURE1DARRAY", D3D11_TEX1D_ARRAY_RTV, "Texture1DArray"),
        ("D3D11_RTV_DIMENSION_TEXTURE2D", D3D11_TEX2D_RTV, "Texture2D"),
        ("D3D11_RTV_DIMENSION_TEXTURE2DARRAY", D3D11_TEX2D_ARRAY_RTV, "Texture2DArray"),
        ("D3D11_RTV_DIMENSION_TEXTURE2DMS", D3D11_TEX2DMS_RTV, "Texture2DMS"),
        ("D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY", D3D11_TEX2DMS_ARRAY_RTV, "Texture2DMSArray"),
        ("D3D11_RTV_DIMENSION_TEXTURE3D", D3D11_TEX3D_RTV, "Texture3D"),
    ]), None),
])

ID3D11RenderTargetView.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_RENDER_TARGET_VIEW_DESC), "pDesc")], sideeffects=False),
]

D3D11_TEX1D_DSV = Struct("D3D11_TEX1D_DSV", [
    (UINT, "MipSlice"),
])

D3D11_TEX1D_ARRAY_DSV = Struct("D3D11_TEX1D_ARRAY_DSV", [
    (UINT, "MipSlice"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_TEX2D_DSV = Struct("D3D11_TEX2D_DSV", [
    (UINT, "MipSlice"),
])

D3D11_TEX2D_ARRAY_DSV = Struct("D3D11_TEX2D_ARRAY_DSV", [
    (UINT, "MipSlice"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_TEX2DMS_DSV = Struct("D3D11_TEX2DMS_DSV", [
    (UINT, "UnusedField_NothingToDefine"),
])

D3D11_TEX2DMS_ARRAY_DSV = Struct("D3D11_TEX2DMS_ARRAY_DSV", [
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_DSV_FLAG = Flags(UINT, [
    "D3D11_DSV_READ_ONLY_DEPTH",
    "D3D11_DSV_READ_ONLY_STENCIL",
])

D3D11_DEPTH_STENCIL_VIEW_DESC = Struct("D3D11_DEPTH_STENCIL_VIEW_DESC", [
    (DXGI_FORMAT, "Format"),
    (D3D11_DSV_DIMENSION, "ViewDimension"),
    (D3D11_DSV_FLAG, "Flags"),
    (Union("{self}.ViewDimension", [
        ("D3D11_DSV_DIMENSION_TEXTURE1D", D3D11_TEX1D_DSV, "Texture1D"),
        ("D3D11_DSV_DIMENSION_TEXTURE1DARRAY", D3D11_TEX1D_ARRAY_DSV, "Texture1DArray"),
        ("D3D11_DSV_DIMENSION_TEXTURE2D", D3D11_TEX2D_DSV, "Texture2D"),
        ("D3D11_DSV_DIMENSION_TEXTURE2DARRAY", D3D11_TEX2D_ARRAY_DSV, "Texture2DArray"),
        ("D3D11_DSV_DIMENSION_TEXTURE2DMS", D3D11_TEX2DMS_DSV, "Texture2DMS"),
        ("D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY", D3D11_TEX2DMS_ARRAY_DSV, "Texture2DMSArray"),
    ]), None),
])

ID3D11DepthStencilView.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_DEPTH_STENCIL_VIEW_DESC), "pDesc")], sideeffects=False),
]

D3D11_BUFFER_UAV_FLAG = Flags(UINT, [
    "D3D11_BUFFER_UAV_FLAG_RAW",
    "D3D11_BUFFER_UAV_FLAG_APPEND",
    "D3D11_BUFFER_UAV_FLAG_COUNTER",
])

D3D11_BUFFER_UAV = Struct("D3D11_BUFFER_UAV", [
    (UINT, "FirstElement"),
    (UINT, "NumElements"),
    (D3D11_BUFFER_UAV_FLAG, "Flags"),
])

D3D11_TEX1D_UAV = Struct("D3D11_TEX1D_UAV", [
    (UINT, "MipSlice"),
])

D3D11_TEX1D_ARRAY_UAV = Struct("D3D11_TEX1D_ARRAY_UAV", [
    (UINT, "MipSlice"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_TEX2D_UAV = Struct("D3D11_TEX2D_UAV", [
    (UINT, "MipSlice"),
])

D3D11_TEX2D_ARRAY_UAV = Struct("D3D11_TEX2D_ARRAY_UAV", [
    (UINT, "MipSlice"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_TEX3D_UAV = Struct("D3D11_TEX3D_UAV", [
    (UINT, "MipSlice"),
    (UINT, "FirstWSlice"),
    (UINT, "WSize"),
])

D3D11_UNORDERED_ACCESS_VIEW_DESC = Struct("D3D11_UNORDERED_ACCESS_VIEW_DESC", [
    (DXGI_FORMAT, "Format"),
    (D3D11_UAV_DIMENSION, "ViewDimension"),
    (Union("{self}.ViewDimension", [
        ("D3D11_UAV_DIMENSION_BUFFER", D3D11_BUFFER_UAV, "Buffer"),
        ("D3D11_UAV_DIMENSION_TEXTURE1D", D3D11_TEX1D_UAV, "Texture1D"),
        ("D3D11_UAV_DIMENSION_TEXTURE1DARRAY", D3D11_TEX1D_ARRAY_UAV, "Texture1DArray"),
        ("D3D11_UAV_DIMENSION_TEXTURE2D", D3D11_TEX2D_UAV, "Texture2D"),
        ("D3D11_UAV_DIMENSION_TEXTURE2DARRAY", D3D11_TEX2D_ARRAY_UAV, "Texture2DArray"),
        ("D3D11_UAV_DIMENSION_TEXTURE3D", D3D11_TEX3D_UAV, "Texture3D"),
    ]), None),
])

ID3D11UnorderedAccessView.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_UNORDERED_ACCESS_VIEW_DESC), "pDesc")], sideeffects=False),
]

D3D11_FILTER = Enum("D3D11_FILTER", [
    "D3D11_FILTER_MIN_MAG_MIP_POINT",
    "D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR",
    "D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT",
    "D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR",
    "D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT",
    "D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR",
    "D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT",
    "D3D11_FILTER_MIN_MAG_MIP_LINEAR",
    "D3D11_FILTER_ANISOTROPIC",
    "D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT",
    "D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR",
    "D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT",
    "D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR",
    "D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT",
    "D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR",
    "D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT",
    "D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR",
    "D3D11_FILTER_COMPARISON_ANISOTROPIC",
    "D3D11_FILTER_MINIMUM_MIN_MAG_MIP_POINT",
    "D3D11_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR",
    "D3D11_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT",
    "D3D11_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR",
    "D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT",
    "D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR",
    "D3D11_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT",
    "D3D11_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR",
    "D3D11_FILTER_MINIMUM_ANISOTROPIC",
    "D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_POINT",
    "D3D11_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR",
    "D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT",
    "D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR",
    "D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT",
    "D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR",
    "D3D11_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT",
    "D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR",
    "D3D11_FILTER_MAXIMUM_ANISOTROPIC",
])

D3D11_FILTER_TYPE = Enum("D3D11_FILTER_TYPE", [
    "D3D11_FILTER_TYPE_POINT",
    "D3D11_FILTER_TYPE_LINEAR",
])

D3D11_TEXTURE_ADDRESS_MODE = Enum("D3D11_TEXTURE_ADDRESS_MODE", [
    "D3D11_TEXTURE_ADDRESS_WRAP",
    "D3D11_TEXTURE_ADDRESS_MIRROR",
    "D3D11_TEXTURE_ADDRESS_CLAMP",
    "D3D11_TEXTURE_ADDRESS_BORDER",
    "D3D11_TEXTURE_ADDRESS_MIRROR_ONCE",
])

D3D11_SAMPLER_DESC = Struct("D3D11_SAMPLER_DESC", [
    (D3D11_FILTER, "Filter"),
    (D3D11_TEXTURE_ADDRESS_MODE, "AddressU"),
    (D3D11_TEXTURE_ADDRESS_MODE, "AddressV"),
    (D3D11_TEXTURE_ADDRESS_MODE, "AddressW"),
    (FLOAT, "MipLODBias"),
    (UINT, "MaxAnisotropy"),
    (D3D11_COMPARISON_FUNC, "ComparisonFunc"),
    (Array(FLOAT, 4), "BorderColor"),
    (FLOAT, "MinLOD"),
    (FLOAT, "MaxLOD"),
])

ID3D11SamplerState.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_SAMPLER_DESC), "pDesc")], sideeffects=False),
]

D3D11_FORMAT_SUPPORT = Flags(UINT, [
    "D3D11_FORMAT_SUPPORT_BUFFER",
    "D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER",
    "D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER",
    "D3D11_FORMAT_SUPPORT_SO_BUFFER",
    "D3D11_FORMAT_SUPPORT_TEXTURE1D",
    "D3D11_FORMAT_SUPPORT_TEXTURE2D",
    "D3D11_FORMAT_SUPPORT_TEXTURE3D",
    "D3D11_FORMAT_SUPPORT_TEXTURECUBE",
    "D3D11_FORMAT_SUPPORT_SHADER_LOAD",
    "D3D11_FORMAT_SUPPORT_SHADER_SAMPLE",
    "D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON",
    "D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT",
    "D3D11_FORMAT_SUPPORT_MIP",
    "D3D11_FORMAT_SUPPORT_MIP_AUTOGEN",
    "D3D11_FORMAT_SUPPORT_RENDER_TARGET",
    "D3D11_FORMAT_SUPPORT_BLENDABLE",
    "D3D11_FORMAT_SUPPORT_DEPTH_STENCIL",
    "D3D11_FORMAT_SUPPORT_CPU_LOCKABLE",
    "D3D11_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE",
    "D3D11_FORMAT_SUPPORT_DISPLAY",
    "D3D11_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT",
    "D3D11_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET",
    "D3D11_FORMAT_SUPPORT_MULTISAMPLE_LOAD",
    "D3D11_FORMAT_SUPPORT_SHADER_GATHER",
    "D3D11_FORMAT_SUPPORT_BACK_BUFFER_CAST",
    "D3D11_FORMAT_SUPPORT_TYPED_UNORDERED_ACCESS_VIEW",
    "D3D11_FORMAT_SUPPORT_SHADER_GATHER_COMPARISON",
    "D3D11_FORMAT_SUPPORT_DECODER_OUTPUT",
    "D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_OUTPUT",
    "D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_INPUT",
    "D3D11_FORMAT_SUPPORT_VIDEO_ENCODER",
])

D3D11_FORMAT_SUPPORT2 = Enum("D3D11_FORMAT_SUPPORT2", [
    "D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_ADD",
    "D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS",
    "D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE",
    "D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE",
    "D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX",
    "D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX",
    "D3D11_FORMAT_SUPPORT2_UAV_TYPED_LOAD",
    "D3D11_FORMAT_SUPPORT2_UAV_TYPED_STORE",
    "D3D11_FORMAT_SUPPORT2_OUTPUT_MERGER_LOGIC_OP",
    "D3D11_FORMAT_SUPPORT2_TILED",
    "D3D11_FORMAT_SUPPORT2_SHAREABLE",
])

ID3D11Asynchronous.methods += [
    StdMethod(UINT, "GetDataSize", [], sideeffects=False),
]

D3D11_ASYNC_GETDATA_FLAG = Flags(UINT, [
    "D3D11_ASYNC_GETDATA_DONOTFLUSH",
])

D3D11_QUERY = Enum("D3D11_QUERY", [
    "D3D11_QUERY_EVENT",
    "D3D11_QUERY_OCCLUSION",
    "D3D11_QUERY_TIMESTAMP",
    "D3D11_QUERY_TIMESTAMP_DISJOINT",
    "D3D11_QUERY_PIPELINE_STATISTICS",
    "D3D11_QUERY_OCCLUSION_PREDICATE",
    "D3D11_QUERY_SO_STATISTICS",
    "D3D11_QUERY_SO_OVERFLOW_PREDICATE",
    "D3D11_QUERY_SO_STATISTICS_STREAM0",
    "D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0",
    "D3D11_QUERY_SO_STATISTICS_STREAM1",
    "D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1",
    "D3D11_QUERY_SO_STATISTICS_STREAM2",
    "D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2",
    "D3D11_QUERY_SO_STATISTICS_STREAM3",
    "D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM3",
])

D3D11_QUERY_MISC_FLAG = Flags(UINT, [
    "D3D11_QUERY_MISC_PREDICATEHINT",
])

D3D11_QUERY_DESC = Struct("D3D11_QUERY_DESC", [
    (D3D11_QUERY, "Query"),
    (D3D11_QUERY_MISC_FLAG, "MiscFlags"),
])

ID3D11Query.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_QUERY_DESC), "pDesc")], sideeffects=False),
]

D3D11_QUERY_DATA_TIMESTAMP_DISJOINT = Struct("D3D11_QUERY_DATA_TIMESTAMP_DISJOINT", [
    (UINT64, "Frequency"),
    (BOOL, "Disjoint"),
])

D3D11_QUERY_DATA_PIPELINE_STATISTICS = Struct("D3D11_QUERY_DATA_PIPELINE_STATISTICS", [
    (UINT64, "IAVertices"),
    (UINT64, "IAPrimitives"),
    (UINT64, "VSInvocations"),
    (UINT64, "GSInvocations"),
    (UINT64, "GSPrimitives"),
    (UINT64, "CInvocations"),
    (UINT64, "CPrimitives"),
    (UINT64, "PSInvocations"),
    (UINT64, "HSInvocations"),
    (UINT64, "DSInvocations"),
    (UINT64, "CSInvocations"),
])

D3D11_QUERY_DATA_SO_STATISTICS = Struct("D3D11_QUERY_DATA_SO_STATISTICS", [
    (UINT64, "NumPrimitivesWritten"),
    (UINT64, "PrimitivesStorageNeeded"),
])

D3D11_QUERY_DATA = Polymorphic("_getQueryType(pAsync)", [
    ("D3D11_QUERY_EVENT", Pointer(BOOL)),
    ("D3D11_QUERY_OCCLUSION", Pointer(UINT64)),
    ("D3D11_QUERY_TIMESTAMP", Pointer(UINT64)),
    ("D3D11_QUERY_TIMESTAMP_DISJOINT", Pointer(D3D11_QUERY_DATA_TIMESTAMP_DISJOINT)),
    ("D3D11_QUERY_PIPELINE_STATISTICS", Pointer(D3D11_QUERY_DATA_PIPELINE_STATISTICS)),
    ("D3D11_QUERY_OCCLUSION_PREDICATE", Pointer(BOOL)),
    ("D3D11_QUERY_SO_STATISTICS", Pointer(D3D11_QUERY_DATA_SO_STATISTICS)),
    ("D3D11_QUERY_SO_OVERFLOW_PREDICATE", Pointer(BOOL)),
    ("D3D11_QUERY_SO_STATISTICS_STREAM0", Pointer(D3D11_QUERY_DATA_SO_STATISTICS)),
    ("D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0", Pointer(BOOL)),
    ("D3D11_QUERY_SO_STATISTICS_STREAM1", Pointer(D3D11_QUERY_DATA_SO_STATISTICS)),
    ("D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1", Pointer(BOOL)),
    ("D3D11_QUERY_SO_STATISTICS_STREAM2", Pointer(D3D11_QUERY_DATA_SO_STATISTICS)),
    ("D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2", Pointer(BOOL)),
    ("D3D11_QUERY_SO_STATISTICS_STREAM3", Pointer(D3D11_QUERY_DATA_SO_STATISTICS)),
    ("D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM3", Pointer(BOOL)),
], Blob(Void, "DataSize"), contextLess=False)

D3D11_COUNTER = Enum("D3D11_COUNTER", [
    "D3D11_COUNTER_DEVICE_DEPENDENT_0",
])

D3D11_COUNTER_TYPE = Enum("D3D11_COUNTER_TYPE", [
    "D3D11_COUNTER_TYPE_FLOAT32",
    "D3D11_COUNTER_TYPE_UINT16",
    "D3D11_COUNTER_TYPE_UINT32",
    "D3D11_COUNTER_TYPE_UINT64",
])

D3D11_COUNTER_DESC = Struct("D3D11_COUNTER_DESC", [
    (D3D11_COUNTER, "Counter"),
    (UINT, "MiscFlags"),
])

D3D11_COUNTER_INFO = Struct("D3D11_COUNTER_INFO", [
    (D3D11_COUNTER, "LastDeviceDependentCounter"),
    (UINT, "NumSimultaneousCounters"),
    (UINT8, "NumDetectableParallelUnits"),
])

ID3D11Counter.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_COUNTER_DESC), "pDesc")], sideeffects=False),
]

D3D11_DEVICE_CONTEXT_TYPE = Enum("D3D11_DEVICE_CONTEXT_TYPE", [
    "D3D11_DEVICE_CONTEXT_IMMEDIATE",
    "D3D11_DEVICE_CONTEXT_DEFERRED",
])

D3D11_CLASS_INSTANCE_DESC = Struct("D3D11_CLASS_INSTANCE_DESC", [
    (UINT, "InstanceId"),
    (UINT, "InstanceIndex"),
    (UINT, "TypeId"),
    (UINT, "ConstantBuffer"),
    (UINT, "BaseConstantBufferOffset"),
    (UINT, "BaseTexture"),
    (UINT, "BaseSampler"),
    (BOOL, "Created"),
])


ID3D11ClassInstance.methods += [
    StdMethod(Void, "GetClassLinkage", [Out(Pointer(ObjPointer(ID3D11ClassLinkage)), "ppLinkage")]),
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_CLASS_INSTANCE_DESC), "pDesc")], sideeffects=False),
    StdMethod(Void, "GetInstanceName", [Out(LPSTR, "pInstanceName"), Out(Pointer(SIZE_T), "pBufferLength")], sideeffects=False),
    StdMethod(Void, "GetTypeName", [Out(LPSTR, "pTypeName"), Out(Pointer(SIZE_T), "pBufferLength")], sideeffects=False),
]

ID3D11ClassLinkage.methods += [
    StdMethod(HRESULT, "GetClassInstance", [(LPCSTR, "pClassInstanceName"), (UINT, "InstanceIndex"), Out(Pointer(ObjPointer(ID3D11ClassInstance)), "ppInstance")]),
    StdMethod(HRESULT, "CreateClassInstance", [(LPCSTR, "pClassTypeName"), (UINT, "ConstantBufferOffset"), (UINT, "ConstantVectorOffset"), (UINT, "TextureOffset"), (UINT, "SamplerOffset"), Out(Pointer(ObjPointer(ID3D11ClassInstance)), "ppInstance")]),
]

ID3D11CommandList.methods += [
    StdMethod(UINT, "GetContextFlags", [], sideeffects=False),
]

D3D11_FEATURE_DATA_THREADING = Struct("D3D11_FEATURE_DATA_THREADING", [
    (BOOL, "DriverConcurrentCreates"),
    (BOOL, "DriverCommandLists"),
])

D3D11_FEATURE_DATA_DOUBLES = Struct("D3D11_FEATURE_DATA_DOUBLES", [
    (BOOL, "DoublePrecisionFloatShaderOps"),
])

D3D11_FEATURE_DATA_FORMAT_SUPPORT = Struct("D3D11_FEATURE_DATA_FORMAT_SUPPORT", [
    (DXGI_FORMAT, "InFormat"),
    (D3D11_FORMAT_SUPPORT, "OutFormatSupport"),
])

D3D11_FEATURE_DATA_FORMAT_SUPPORT2 = Struct("D3D11_FEATURE_DATA_FORMAT_SUPPORT2", [
    (DXGI_FORMAT, "InFormat"),
    (D3D11_FORMAT_SUPPORT2, "OutFormatSupport2"),
])

D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS = Struct("D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS", [
    (BOOL, "ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x"),
])

D3D11_FEATURE_DATA_D3D11_OPTIONS = Struct("D3D11_FEATURE_DATA_D3D11_OPTIONS", [
    (BOOL, "OutputMergerLogicOp"),
    (BOOL, "UAVOnlyRenderingForcedSampleCount"),
    (BOOL, "DiscardAPIsSeenByDriver"),
    (BOOL, "FlagsForUpdateAndCopySeenByDriver"),
    (BOOL, "ClearView"),
    (BOOL, "CopyWithOverlap"),
    (BOOL, "ConstantBufferPartialUpdate"),
    (BOOL, "ConstantBufferOffsetting"),
    (BOOL, "MapNoOverwriteOnDynamicConstantBuffer"),
    (BOOL, "MapNoOverwriteOnDynamicBufferSRV"),
    (BOOL, "MultisampleRTVWithForcedSampleCountOne"),
    (BOOL, "SAD4ShaderInstructions"),
    (BOOL, "ExtendedDoublesShaderInstructions"),
    (BOOL, "ExtendedResourceSharing"),
])

D3D11_FEATURE_DATA_ARCHITECTURE_INFO = Struct("D3D11_FEATURE_DATA_ARCHITECTURE_INFO", [
    (BOOL, "TileBasedDeferredRenderer"),
])

D3D11_FEATURE_DATA_D3D9_OPTIONS = Struct("D3D11_FEATURE_DATA_D3D9_OPTIONS", [
    (BOOL, "FullNonPow2TextureSupport"),
])

D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT = Struct("D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT", [
    (BOOL, "SupportsDepthAsTextureWithLessEqualComparisonFilter"),
])

D3D11_SHADER_MIN_PRECISION_SUPPORT = Enum("D3D11_SHADER_MIN_PRECISION_SUPPORT", [
    "D3D11_SHADER_MIN_PRECISION_10_BIT",
    "D3D11_SHADER_MIN_PRECISION_16_BIT",
])

D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT = Struct("D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT", [
    (UINT, "PixelShaderMinPrecision"),
    (UINT, "AllOtherShaderStagesMinPrecision"),
])

D3D11_TILED_RESOURCES_TIER = Enum("D3D11_TILED_RESOURCES_TIER", [
    "D3D11_TILED_RESOURCES_NOT_SUPPORTED",
    "D3D11_TILED_RESOURCES_TIER_1",
    "D3D11_TILED_RESOURCES_TIER_2",
])

D3D11_FEATURE_DATA_D3D11_OPTIONS1 = Struct("D3D11_FEATURE_DATA_D3D11_OPTIONS1", [
    (D3D11_TILED_RESOURCES_TIER, "TiledResourcesTier"),
    (BOOL, "MinMaxFiltering"),
    (BOOL, "ClearViewAlsoSupportsDepthOnlyFormats"),
    (BOOL, "MapOnDefaultBuffers"),
])

D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT = Struct("D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT", [
    (BOOL, "SimpleInstancingSupported"),
])

D3D11_FEATURE_DATA_MARKER_SUPPORT = Struct("D3D11_FEATURE_DATA_MARKER_SUPPORT", [
    (BOOL, "Profile"),
])

D3D11_FEATURE_DATA_D3D9_OPTIONS1 = Struct("D3D11_FEATURE_DATA_D3D9_OPTIONS1", [
    (BOOL, "FullNonPow2TextureSupported"),
    (BOOL, "DepthAsTextureWithLessEqualComparisonFilterSupported"),
    (BOOL, "SimpleInstancingSupported"),
    (BOOL, "TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported"),
])

D3D11_CONSERVATIVE_RASTERIZATION_TIER = Enum("D3D11_CONSERVATIVE_RASTERIZATION_TIER", [
    "D3D11_CONSERVATIVE_RASTERIZATION_NOT_SUPPORTED",
    "D3D11_CONSERVATIVE_RASTERIZATION_TIER_1",
    "D3D11_CONSERVATIVE_RASTERIZATION_TIER_2",
    "D3D11_CONSERVATIVE_RASTERIZATION_TIER_3",
])

D3D11_FEATURE_DATA_D3D11_OPTIONS2 = Struct("D3D11_FEATURE_DATA_D3D11_OPTIONS2", [
    (BOOL, "PSSpecifiedStencilRefSupported"),
    (BOOL, "TypedUAVLoadAdditionalFormats"),
    (BOOL, "ROVsSupported"),
    (D3D11_CONSERVATIVE_RASTERIZATION_TIER, "ConservativeRasterizationTier"),
    (D3D11_TILED_RESOURCES_TIER, "TiledResourcesTier"),
    (BOOL, "MapOnDefaultTextures"),
    (BOOL, "StandardSwizzle"),
    (BOOL, "UnifiedMemoryArchitecture"),
])

D3D11_FEATURE_DATA_D3D11_OPTIONS3 = Struct("D3D11_FEATURE_DATA_D3D11_OPTIONS3", [
    (BOOL, "VPAndRTArrayIndexFromAnyShaderFeedingRasterizer"),
])

D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT = Struct("D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT", [
    (UINT, "MaxGPUVirtualAddressBitsPerResource"),
    (UINT, "MaxGPUVirtualAddressBitsPerProcess"),
])

D3D11_FEATURE_DATA_D3D11_OPTIONS4 = Struct('D3D11_FEATURE_DATA_D3D11_OPTIONS4', [
    (BOOL, 'ExtendedNV12SharedTextureSupported'),
])

D3D11_SHADER_CACHE_SUPPORT_FLAGS = FakeEnum(UINT, [
    "D3D11_SHADER_CACHE_SUPPORT_NONE",
    "D3D11_SHADER_CACHE_SUPPORT_AUTOMATIC_INPROC_CACHE",
    "D3D11_SHADER_CACHE_SUPPORT_AUTOMATIC_DISK_CACHE",
])

D3D11_FEATURE_DATA_SHADER_CACHE = Struct("D3D11_FEATURE_DATA_SHADER_CACHE", [
    (D3D11_SHADER_CACHE_SUPPORT_FLAGS, 'SupportFlags'),
])

D3D11_SHARED_RESOURCE_TIER = Enum("D3D11_SHARED_RESOURCE_TIER", [
    "D3D11_SHARED_RESOURCE_TIER_0",
    "D3D11_SHARED_RESOURCE_TIER_1",
    "D3D11_SHARED_RESOURCE_TIER_2",
])

D3D11_FEATURE_DATA_D3D11_OPTIONS5 = Struct("D3D11_FEATURE_DATA_D3D11_OPTIONS5", [
    (D3D11_SHARED_RESOURCE_TIER, "SharedResourceTier"),
])


D3D11_FEATURE, D3D11_FEATURE_DATA = EnumPolymorphic("D3D11_FEATURE", "Feature", [
    ("D3D11_FEATURE_THREADING", Pointer(D3D11_FEATURE_DATA_THREADING)),
    ("D3D11_FEATURE_DOUBLES", Pointer(D3D11_FEATURE_DATA_DOUBLES)),
    ("D3D11_FEATURE_FORMAT_SUPPORT", Pointer(D3D11_FEATURE_DATA_FORMAT_SUPPORT)),
    ("D3D11_FEATURE_FORMAT_SUPPORT2", Pointer(D3D11_FEATURE_DATA_FORMAT_SUPPORT2)),
    ("D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS", Pointer(D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS)),
    ("D3D11_FEATURE_D3D11_OPTIONS", Pointer(D3D11_FEATURE_DATA_D3D11_OPTIONS)),
    ("D3D11_FEATURE_ARCHITECTURE_INFO", Pointer(D3D11_FEATURE_DATA_ARCHITECTURE_INFO)),
    ("D3D11_FEATURE_D3D9_OPTIONS", Pointer(D3D11_FEATURE_DATA_D3D9_OPTIONS)),
    ("D3D11_FEATURE_SHADER_MIN_PRECISION_SUPPORT", Pointer(D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT)),
    ("D3D11_FEATURE_D3D9_SHADOW_SUPPORT", Pointer(D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT)),
    ("D3D11_FEATURE_D3D11_OPTIONS1", Pointer(D3D11_FEATURE_DATA_D3D11_OPTIONS1)),
    ("D3D11_FEATURE_D3D9_SIMPLE_INSTANCING_SUPPORT", Pointer(D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT)),
    ("D3D11_FEATURE_MARKER_SUPPORT", Pointer(D3D11_FEATURE_DATA_MARKER_SUPPORT)),
    ("D3D11_FEATURE_D3D9_OPTIONS1", Pointer(D3D11_FEATURE_DATA_D3D9_OPTIONS1)),
    ("D3D11_FEATURE_D3D11_OPTIONS2", Pointer(D3D11_FEATURE_DATA_D3D11_OPTIONS2)),
    ("D3D11_FEATURE_D3D11_OPTIONS3", Pointer(D3D11_FEATURE_DATA_D3D11_OPTIONS3)),
    ("D3D11_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT", Pointer(D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT)),
    ("D3D11_FEATURE_D3D11_OPTIONS4", Pointer(D3D11_FEATURE_DATA_D3D11_OPTIONS4)),
    ("D3D11_FEATURE_SHADER_CACHE", Pointer(D3D11_FEATURE_DATA_SHADER_CACHE)),
    ("D3D11_FEATURE_D3D11_OPTIONS5", Pointer(D3D11_FEATURE_DATA_D3D11_OPTIONS5)),
], Blob(Void, "FeatureSupportDataSize"), False)

D3D11_NUM_RTVS = FakeEnum(UINT, [
    "D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL",
])

D3D11_NUM_UAVS = FakeEnum(UINT, [
    "D3D11_KEEP_UNORDERED_ACCESS_VIEWS",
])

D3D11_SAMPLE_MASK = FakeEnum(UINT, [
    "D3D11_DEFAULT_SAMPLE_MASK"
])

ID3D11DeviceContext.methods += [
    StdMethod(Void, "VSSetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "PSSetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), (Array(Const(ObjPointer(ID3D11ShaderResourceView)), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "PSSetShader", [(ObjPointer(ID3D11PixelShader), "pPixelShader"), (Array(Const(ObjPointer(ID3D11ClassInstance)), "NumClassInstances"), "ppClassInstances"), (UINT, "NumClassInstances")]),
    StdMethod(Void, "PSSetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), (Array(Const(ObjPointer(ID3D11SamplerState)), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "VSSetShader", [(ObjPointer(ID3D11VertexShader), "pVertexShader"), (Array(Const(ObjPointer(ID3D11ClassInstance)), "NumClassInstances"), "ppClassInstances"), (UINT, "NumClassInstances")]),
    StdMethod(Void, "DrawIndexed", [(UINT, "IndexCount"), (UINT, "StartIndexLocation"), (INT, "BaseVertexLocation")]),
    StdMethod(Void, "Draw", [(UINT, "VertexCount"), (UINT, "StartVertexLocation")]),
    StdMethod(HRESULT, "Map", [(ObjPointer(ID3D11Resource), "pResource"), (UINT, "Subresource"), (D3D11_MAP, "MapType"), (D3D11_MAP_FLAG, "MapFlags"), Out(Pointer(D3D11_MAPPED_SUBRESOURCE), "pMappedResource")]),
    StdMethod(Void, "Unmap", [(ObjPointer(ID3D11Resource), "pResource"), (UINT, "Subresource")]),
    StdMethod(Void, "PSSetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "IASetInputLayout", [(ObjPointer(ID3D11InputLayout), "pInputLayout")]),
    StdMethod(Void, "IASetVertexBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppVertexBuffers"), (Array(Const(UINT), "NumBuffers"), "pStrides"), (Array(Const(UINT), "NumBuffers"), "pOffsets")]),
    StdMethod(Void, "IASetIndexBuffer", [(ObjPointer(ID3D11Buffer), "pIndexBuffer"), (DXGI_FORMAT, "Format"), (UINT, "Offset")]),
    StdMethod(Void, "DrawIndexedInstanced", [(UINT, "IndexCountPerInstance"), (UINT, "InstanceCount"), (UINT, "StartIndexLocation"), (INT, "BaseVertexLocation"), (UINT, "StartInstanceLocation")]),
    StdMethod(Void, "DrawInstanced", [(UINT, "VertexCountPerInstance"), (UINT, "InstanceCount"), (UINT, "StartVertexLocation"), (UINT, "StartInstanceLocation")]),
    StdMethod(Void, "GSSetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "GSSetShader", [(ObjPointer(ID3D11GeometryShader), "pShader"), (Array(Const(ObjPointer(ID3D11ClassInstance)), "NumClassInstances"), "ppClassInstances"), (UINT, "NumClassInstances")]),
    StdMethod(Void, "IASetPrimitiveTopology", [(D3D11_PRIMITIVE_TOPOLOGY, "Topology")]),
    StdMethod(Void, "VSSetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), (Array(Const(ObjPointer(ID3D11ShaderResourceView)), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "VSSetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), (Array(Const(ObjPointer(ID3D11SamplerState)), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "Begin", [(ObjPointer(ID3D11Asynchronous), "pAsync")]),
    StdMethod(Void, "End", [(ObjPointer(ID3D11Asynchronous), "pAsync")]),
    StdMethod(HRESULT, "GetData", [(ObjPointer(ID3D11Asynchronous), "pAsync"), Out(D3D11_QUERY_DATA, "pData"), (UINT, "DataSize"), (D3D11_ASYNC_GETDATA_FLAG, "GetDataFlags")]),
    StdMethod(Void, "SetPredication", [(ObjPointer(ID3D11Predicate), "pPredicate"), (BOOL, "PredicateValue")]),
    StdMethod(Void, "GSSetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), (Array(Const(ObjPointer(ID3D11ShaderResourceView)), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "GSSetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), (Array(Const(ObjPointer(ID3D11SamplerState)), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "OMSetRenderTargets", [(UINT, "NumViews"), (Array(Const(ObjPointer(ID3D11RenderTargetView)), "NumViews"), "ppRenderTargetViews"), (ObjPointer(ID3D11DepthStencilView), "pDepthStencilView")]),
    StdMethod(Void, "OMSetRenderTargetsAndUnorderedAccessViews", [(UINT, "NumRTVs"), (Array(Const(ObjPointer(ID3D11RenderTargetView)), "NumRTVs == D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL ? 0 : NumRTVs"), "ppRenderTargetViews"), (ObjPointer(ID3D11DepthStencilView), "pDepthStencilView"), (UINT, "UAVStartSlot"), (UINT, "NumUAVs"), (Array(Const(ObjPointer(ID3D11UnorderedAccessView)), "NumUAVs == D3D11_KEEP_UNORDERED_ACCESS_VIEWS ? 0 : NumUAVs"), "ppUnorderedAccessViews"), (Array(Const(UINT), "NumUAVs == D3D11_KEEP_UNORDERED_ACCESS_VIEWS ? 0 : NumUAVs"), "pUAVInitialCounts")]),
    StdMethod(Void, "OMSetBlendState", [(ObjPointer(ID3D11BlendState), "pBlendState"), (Array(Const(FLOAT), 4), "BlendFactor"), (D3D11_SAMPLE_MASK, "SampleMask")]),
    StdMethod(Void, "OMSetDepthStencilState", [(ObjPointer(ID3D11DepthStencilState), "pDepthStencilState"), (UINT, "StencilRef")]),
    StdMethod(Void, "SOSetTargets", [(UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppSOTargets"), (Array(Const(UINT), "NumBuffers"), "pOffsets")]),
    StdMethod(Void, "DrawAuto", []),
    StdMethod(Void, "DrawIndexedInstancedIndirect", [(ObjPointer(ID3D11Buffer), "pBufferForArgs"), (UINT, "AlignedByteOffsetForArgs")]),
    StdMethod(Void, "DrawInstancedIndirect", [(ObjPointer(ID3D11Buffer), "pBufferForArgs"), (UINT, "AlignedByteOffsetForArgs")]),
    StdMethod(Void, "Dispatch", [(UINT, "ThreadGroupCountX"), (UINT, "ThreadGroupCountY"), (UINT, "ThreadGroupCountZ")]),
    StdMethod(Void, "DispatchIndirect", [(ObjPointer(ID3D11Buffer), "pBufferForArgs"), (UINT, "AlignedByteOffsetForArgs")]),
    StdMethod(Void, "RSSetState", [(ObjPointer(ID3D11RasterizerState), "pRasterizerState")]),
    StdMethod(Void, "RSSetViewports", [(UINT, "NumViewports"), (Array(Const(D3D11_VIEWPORT), "NumViewports"), "pViewports")]),
    StdMethod(Void, "RSSetScissorRects", [(UINT, "NumRects"), (Array(Const(D3D11_RECT), "NumRects"), "pRects")]),
    StdMethod(Void, "CopySubresourceRegion", [(ObjPointer(ID3D11Resource), "pDstResource"), (UINT, "DstSubresource"), (UINT, "DstX"), (UINT, "DstY"), (UINT, "DstZ"), (ObjPointer(ID3D11Resource), "pSrcResource"), (UINT, "SrcSubresource"), (Pointer(Const(D3D11_BOX)), "pSrcBox")]),
    StdMethod(Void, "CopyResource", [(ObjPointer(ID3D11Resource), "pDstResource"), (ObjPointer(ID3D11Resource), "pSrcResource")]),
    StdMethod(Void, "UpdateSubresource", [(ObjPointer(ID3D11Resource), "pDstResource"), (UINT, "DstSubresource"), (Pointer(Const(D3D11_BOX)), "pDstBox"), (Blob(Const(Void), "_calcSubresourceSize(pDstResource, DstSubresource, pDstBox, SrcRowPitch, SrcDepthPitch)"), "pSrcData"), (UINT, "SrcRowPitch"), (UINT, "SrcDepthPitch")]),
    StdMethod(Void, "CopyStructureCount", [(ObjPointer(ID3D11Buffer), "pDstBuffer"), (UINT, "DstAlignedByteOffset"), (ObjPointer(ID3D11UnorderedAccessView), "pSrcView")]),
    StdMethod(Void, "ClearRenderTargetView", [(ObjPointer(ID3D11RenderTargetView), "pRenderTargetView"), (Array(Const(FLOAT), 4), "ColorRGBA")]),
    StdMethod(Void, "ClearUnorderedAccessViewUint", [(ObjPointer(ID3D11UnorderedAccessView), "pUnorderedAccessView"), (Array(Const(UINT), 4), "Values")]),
    StdMethod(Void, "ClearUnorderedAccessViewFloat", [(ObjPointer(ID3D11UnorderedAccessView), "pUnorderedAccessView"), (Array(Const(FLOAT), 4), "Values")]),
    StdMethod(Void, "ClearDepthStencilView", [(ObjPointer(ID3D11DepthStencilView), "pDepthStencilView"), (D3D11_CLEAR_FLAG, "ClearFlags"), (FLOAT, "Depth"), (UINT8, "Stencil")]),
    StdMethod(Void, "GenerateMips", [(ObjPointer(ID3D11ShaderResourceView), "pShaderResourceView")]),
    StdMethod(Void, "SetResourceMinLOD", [(ObjPointer(ID3D11Resource), "pResource"), (FLOAT, "MinLOD")]),
    StdMethod(FLOAT, "GetResourceMinLOD", [(ObjPointer(ID3D11Resource), "pResource")], sideeffects=False),
    StdMethod(Void, "ResolveSubresource", [(ObjPointer(ID3D11Resource), "pDstResource"), (UINT, "DstSubresource"), (ObjPointer(ID3D11Resource), "pSrcResource"), (UINT, "SrcSubresource"), (DXGI_FORMAT, "Format")]),
    StdMethod(Void, "ExecuteCommandList", [(ObjPointer(ID3D11CommandList), "pCommandList"), (BOOL, "RestoreContextState")]),
    StdMethod(Void, "HSSetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), (Array(Const(ObjPointer(ID3D11ShaderResourceView)), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "HSSetShader", [(ObjPointer(ID3D11HullShader), "pHullShader"), (Array(Const(ObjPointer(ID3D11ClassInstance)), "NumClassInstances"), "ppClassInstances"), (UINT, "NumClassInstances")]),
    StdMethod(Void, "HSSetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), (Array(Const(ObjPointer(ID3D11SamplerState)), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "HSSetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "DSSetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), (Array(Const(ObjPointer(ID3D11ShaderResourceView)), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "DSSetShader", [(ObjPointer(ID3D11DomainShader), "pDomainShader"), (Array(Const(ObjPointer(ID3D11ClassInstance)), "NumClassInstances"), "ppClassInstances"), (UINT, "NumClassInstances")]),
    StdMethod(Void, "DSSetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), (Array(Const(ObjPointer(ID3D11SamplerState)), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "DSSetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "CSSetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), (Array(Const(ObjPointer(ID3D11ShaderResourceView)), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "CSSetUnorderedAccessViews", [(UINT, "StartSlot"), (UINT, "NumUAVs"), (Array(Const(ObjPointer(ID3D11UnorderedAccessView)), "NumUAVs"), "ppUnorderedAccessViews"), (Array(Const(UINT), "NumUAVs"), "pUAVInitialCounts")]),
    StdMethod(Void, "CSSetShader", [(ObjPointer(ID3D11ComputeShader), "pComputeShader"), (Array(Const(ObjPointer(ID3D11ClassInstance)), "NumClassInstances"), "ppClassInstances"), (UINT, "NumClassInstances")]),
    StdMethod(Void, "CSSetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), (Array(Const(ObjPointer(ID3D11SamplerState)), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "CSSetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "VSGetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "PSGetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), Out(Array(ObjPointer(ID3D11ShaderResourceView), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "PSGetShader", [Out(Pointer(ObjPointer(ID3D11PixelShader)), "ppPixelShader"), Out(Array(ObjPointer(ID3D11ClassInstance), "*pNumClassInstances"), "ppClassInstances"), InOut(Pointer(UINT), "pNumClassInstances")]),
    StdMethod(Void, "PSGetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), Out(Array(ObjPointer(ID3D11SamplerState), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "VSGetShader", [Out(Pointer(ObjPointer(ID3D11VertexShader)), "ppVertexShader"), Out(Array(ObjPointer(ID3D11ClassInstance), "*pNumClassInstances"), "ppClassInstances"), InOut(Pointer(UINT), "pNumClassInstances")]),
    StdMethod(Void, "PSGetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "IAGetInputLayout", [Out(Pointer(ObjPointer(ID3D11InputLayout)), "ppInputLayout")]),
    StdMethod(Void, "IAGetVertexBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppVertexBuffers"), Out(Array(UINT, "NumBuffers"), "pStrides"), Out(Array(UINT, "NumBuffers"), "pOffsets")]),
    StdMethod(Void, "IAGetIndexBuffer", [Out(Pointer(ObjPointer(ID3D11Buffer)), "pIndexBuffer"), Out(Pointer(DXGI_FORMAT), "Format"), Out(Pointer(UINT), "Offset")]),
    StdMethod(Void, "GSGetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "GSGetShader", [Out(Pointer(ObjPointer(ID3D11GeometryShader)), "ppGeometryShader"), Out(Array(ObjPointer(ID3D11ClassInstance), "*pNumClassInstances"), "ppClassInstances"), InOut(Pointer(UINT), "pNumClassInstances")]),
    StdMethod(Void, "IAGetPrimitiveTopology", [Out(Pointer(D3D11_PRIMITIVE_TOPOLOGY), "pTopology")], sideeffects=False),
    StdMethod(Void, "VSGetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), Out(Array(ObjPointer(ID3D11ShaderResourceView), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "VSGetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), Out(Array(ObjPointer(ID3D11SamplerState), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "GetPredication", [Out(Pointer(ObjPointer(ID3D11Predicate)), "ppPredicate"), Out(Pointer(BOOL), "pPredicateValue")]),
    StdMethod(Void, "GSGetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), Out(Array(ObjPointer(ID3D11ShaderResourceView), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "GSGetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), Out(Array(ObjPointer(ID3D11SamplerState), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "OMGetRenderTargets", [(UINT, "NumViews"), Out(Array(ObjPointer(ID3D11RenderTargetView), "NumViews"), "ppRenderTargetViews"), Out(Pointer(ObjPointer(ID3D11DepthStencilView)), "ppDepthStencilView")]),
    StdMethod(Void, "OMGetRenderTargetsAndUnorderedAccessViews", [(D3D11_NUM_RTVS, "NumRTVs"), Out(Array(ObjPointer(ID3D11RenderTargetView), "NumRTVs"), "ppRenderTargetViews"), Out(Pointer(ObjPointer(ID3D11DepthStencilView)), "ppDepthStencilView"), (UINT, "UAVStartSlot"), (D3D11_NUM_UAVS, "NumUAVs"), Out(Array(ObjPointer(ID3D11UnorderedAccessView), "NumUAVs"), "ppUnorderedAccessViews")]),
    StdMethod(Void, "OMGetBlendState", [Out(Pointer(ObjPointer(ID3D11BlendState)), "ppBlendState"), Out(Array(FLOAT, 4), "BlendFactor"), Out(Pointer(D3D11_SAMPLE_MASK), "pSampleMask")]),
    StdMethod(Void, "OMGetDepthStencilState", [Out(Pointer(ObjPointer(ID3D11DepthStencilState)), "ppDepthStencilState"), Out(Pointer(UINT), "pStencilRef")]),
    StdMethod(Void, "SOGetTargets", [(UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppSOTargets")]),
    StdMethod(Void, "RSGetState", [Out(Pointer(ObjPointer(ID3D11RasterizerState)), "ppRasterizerState")]),
    StdMethod(Void, "RSGetViewports", [InOut(Pointer(UINT), "pNumViewports"), Out(Array(D3D11_VIEWPORT, "*pNumViewports"), "pViewports")], sideeffects=False),
    StdMethod(Void, "RSGetScissorRects", [InOut(Pointer(UINT), "pNumRects"), Out(Array(D3D11_RECT, "*pNumRects"), "pRects")], sideeffects=False),
    StdMethod(Void, "HSGetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), Out(Array(ObjPointer(ID3D11ShaderResourceView), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "HSGetShader", [Out(Pointer(ObjPointer(ID3D11HullShader)), "ppHullShader"), Out(Array(ObjPointer(ID3D11ClassInstance), "*pNumClassInstances"), "ppClassInstances"), InOut(Pointer(UINT), "pNumClassInstances")]),
    StdMethod(Void, "HSGetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), Out(Array(ObjPointer(ID3D11SamplerState), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "HSGetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "DSGetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), Out(Array(ObjPointer(ID3D11ShaderResourceView), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "DSGetShader", [Out(Pointer(ObjPointer(ID3D11DomainShader)), "ppDomainShader"), Out(Array(ObjPointer(ID3D11ClassInstance), "*pNumClassInstances"), "ppClassInstances"), InOut(Pointer(UINT), "pNumClassInstances")]),
    StdMethod(Void, "DSGetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), Out(Array(ObjPointer(ID3D11SamplerState), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "DSGetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "CSGetShaderResources", [(UINT, "StartSlot"), (UINT, "NumViews"), Out(Array(ObjPointer(ID3D11ShaderResourceView), "NumViews"), "ppShaderResourceViews")]),
    StdMethod(Void, "CSGetUnorderedAccessViews", [(UINT, "StartSlot"), (UINT, "NumUAVs"), Out(Array(ObjPointer(ID3D11UnorderedAccessView), "NumUAVs"), "ppUnorderedAccessViews")]),
    StdMethod(Void, "CSGetShader", [Out(Pointer(ObjPointer(ID3D11ComputeShader)), "ppComputeShader"), Out(Array(ObjPointer(ID3D11ClassInstance), "*pNumClassInstances"), "ppClassInstances"), InOut(Pointer(UINT), "pNumClassInstances")]),
    StdMethod(Void, "CSGetSamplers", [(UINT, "StartSlot"), (UINT, "NumSamplers"), Out(Array(ObjPointer(ID3D11SamplerState), "NumSamplers"), "ppSamplers")]),
    StdMethod(Void, "CSGetConstantBuffers", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers")]),
    StdMethod(Void, "ClearState", []),
    StdMethod(Void, "Flush", []),
    StdMethod(D3D11_DEVICE_CONTEXT_TYPE, "GetType", [], sideeffects=False),
    StdMethod(UINT, "GetContextFlags", [], sideeffects=False),
    StdMethod(HRESULT, "FinishCommandList", [(BOOL, "RestoreDeferredContextState"), Out(Pointer(ObjPointer(ID3D11CommandList)), "ppCommandList")]),
]

D3D11_CREATE_DEVICE_FLAG = Flags(UINT, [
    "D3D11_CREATE_DEVICE_SINGLETHREADED",
    "D3D11_CREATE_DEVICE_DEBUG",
    "D3D11_CREATE_DEVICE_SWITCH_TO_REF",
    "D3D11_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS",
    "D3D11_CREATE_DEVICE_BGRA_SUPPORT",
    "D3D11_CREATE_DEVICE_DEBUGGABLE",
    "D3D11_CREATE_DEVICE_PREVENT_ALTERING_LAYER_SETTINGS_FROM_REGISTRY",
    "D3D11_CREATE_DEVICE_DISABLE_GPU_TIMEOUT",
    "D3D11_CREATE_DEVICE_VIDEO_SUPPORT",
])

D3D_FEATURE_LEVEL = Enum("D3D_FEATURE_LEVEL", [
    "D3D_FEATURE_LEVEL_9_1",
    "D3D_FEATURE_LEVEL_9_2",
    "D3D_FEATURE_LEVEL_9_3",
    "D3D_FEATURE_LEVEL_10_0",
    "D3D_FEATURE_LEVEL_10_1",
    "D3D_FEATURE_LEVEL_11_0",
    "D3D_FEATURE_LEVEL_11_1",
    "D3D_FEATURE_LEVEL_12_0",
    "D3D_FEATURE_LEVEL_12_1",
])

D3D11_RASTERIZED_STREAM = FakeEnum(UINT, [
    "D3D11_SO_NO_RASTERIZED_STREAM",
])

ID3D11Device.methods += [
    StdMethod(HRESULT, "CreateBuffer", [(Pointer(Const(D3D11_BUFFER_DESC)), "pDesc"), (Array(Const(D3D11_SUBRESOURCE_DATA), 1), "pInitialData"), Out(Pointer(ObjPointer(ID3D11Buffer)), "ppBuffer")]),
    StdMethod(HRESULT, "CreateTexture1D", [(Pointer(Const(D3D11_TEXTURE1D_DESC)), "pDesc"), (Array(Const(D3D11_SUBRESOURCE_DATA), "_getNumSubResources(pDesc)"), "pInitialData"), Out(Pointer(ObjPointer(ID3D11Texture1D)), "ppTexture1D")]),
    StdMethod(HRESULT, "CreateTexture2D", [(Pointer(Const(D3D11_TEXTURE2D_DESC)), "pDesc"), (Array(Const(D3D11_SUBRESOURCE_DATA), "_getNumSubResources(pDesc)"), "pInitialData"), Out(Pointer(ObjPointer(ID3D11Texture2D)), "ppTexture2D")]),
    StdMethod(HRESULT, "CreateTexture3D", [(Pointer(Const(D3D11_TEXTURE3D_DESC)), "pDesc"), (Array(Const(D3D11_SUBRESOURCE_DATA), "_getNumSubResources(pDesc)"), "pInitialData"), Out(Pointer(ObjPointer(ID3D11Texture3D)), "ppTexture3D")]),
    StdMethod(HRESULT, "CreateShaderResourceView", [(ObjPointer(ID3D11Resource), "pResource"), (Pointer(Const(D3D11_SHADER_RESOURCE_VIEW_DESC)), "pDesc"), Out(Pointer(ObjPointer(ID3D11ShaderResourceView)), "ppSRView")]),
    StdMethod(HRESULT, "CreateUnorderedAccessView", [(ObjPointer(ID3D11Resource), "pResource"), (Pointer(Const(D3D11_UNORDERED_ACCESS_VIEW_DESC)), "pDesc"), Out(Pointer(ObjPointer(ID3D11UnorderedAccessView)), "ppUAView")]),
    StdMethod(HRESULT, "CreateRenderTargetView", [(ObjPointer(ID3D11Resource), "pResource"), (Pointer(Const(D3D11_RENDER_TARGET_VIEW_DESC)), "pDesc"), Out(Pointer(ObjPointer(ID3D11RenderTargetView)), "ppRTView")]),
    StdMethod(HRESULT, "CreateDepthStencilView", [(ObjPointer(ID3D11Resource), "pResource"), (Pointer(Const(D3D11_DEPTH_STENCIL_VIEW_DESC)), "pDesc"), Out(Pointer(ObjPointer(ID3D11DepthStencilView)), "ppDepthStencilView")]),
    StdMethod(HRESULT, "CreateInputLayout", [(Array(Const(D3D11_INPUT_ELEMENT_DESC), "NumElements"), "pInputElementDescs"), (UINT, "NumElements"), (Blob(Const(Void), "BytecodeLength"), "pShaderBytecodeWithInputSignature"), (SIZE_T, "BytecodeLength"), Out(Pointer(ObjPointer(ID3D11InputLayout)), "ppInputLayout")]),
    StdMethod(HRESULT, "CreateVertexShader", [(Blob(Const(Void), "BytecodeLength"), "pShaderBytecode"), (SIZE_T, "BytecodeLength"), (ObjPointer(ID3D11ClassLinkage), "pClassLinkage"), Out(Pointer(ObjPointer(ID3D11VertexShader)), "ppVertexShader")]),
    StdMethod(HRESULT, "CreateGeometryShader", [(Blob(Const(Void), "BytecodeLength"), "pShaderBytecode"), (SIZE_T, "BytecodeLength"), (ObjPointer(ID3D11ClassLinkage), "pClassLinkage"), Out(Pointer(ObjPointer(ID3D11GeometryShader)), "ppGeometryShader")]),
    StdMethod(HRESULT, "CreateGeometryShaderWithStreamOutput", [(Blob(Const(Void), "BytecodeLength"), "pShaderBytecode"), (SIZE_T, "BytecodeLength"), (Array(Const(D3D11_SO_DECLARATION_ENTRY), "NumEntries"), "pSODeclaration"), (UINT, "NumEntries"), (Array(Const(UINT), "NumStrides"), "pBufferStrides"), (UINT, "NumStrides"), (D3D11_RASTERIZED_STREAM, "RasterizedStream"), (ObjPointer(ID3D11ClassLinkage), "pClassLinkage"), Out(Pointer(ObjPointer(ID3D11GeometryShader)), "ppGeometryShader")]),
    StdMethod(HRESULT, "CreatePixelShader", [(Blob(Const(Void), "BytecodeLength"), "pShaderBytecode"), (SIZE_T, "BytecodeLength"), (ObjPointer(ID3D11ClassLinkage), "pClassLinkage"), Out(Pointer(ObjPointer(ID3D11PixelShader)), "ppPixelShader")]),
    StdMethod(HRESULT, "CreateHullShader", [(Blob(Const(Void), "BytecodeLength"), "pShaderBytecode"), (SIZE_T, "BytecodeLength"), (ObjPointer(ID3D11ClassLinkage), "pClassLinkage"), Out(Pointer(ObjPointer(ID3D11HullShader)), "ppHullShader")]),
    StdMethod(HRESULT, "CreateDomainShader", [(Blob(Const(Void), "BytecodeLength"), "pShaderBytecode"), (SIZE_T, "BytecodeLength"), (ObjPointer(ID3D11ClassLinkage), "pClassLinkage"), Out(Pointer(ObjPointer(ID3D11DomainShader)), "ppDomainShader")]),
    StdMethod(HRESULT, "CreateComputeShader", [(Blob(Const(Void), "BytecodeLength"), "pShaderBytecode"), (SIZE_T, "BytecodeLength"), (ObjPointer(ID3D11ClassLinkage), "pClassLinkage"), Out(Pointer(ObjPointer(ID3D11ComputeShader)), "ppComputeShader")]),
    StdMethod(HRESULT, "CreateClassLinkage", [Out(Pointer(ObjPointer(ID3D11ClassLinkage)), "ppLinkage")]),
    StdMethod(HRESULT, "CreateBlendState", [(Pointer(Const(D3D11_BLEND_DESC)), "pBlendStateDesc"), Out(Pointer(ObjPointer(ID3D11BlendState)), "ppBlendState")]),
    StdMethod(HRESULT, "CreateDepthStencilState", [(Pointer(Const(D3D11_DEPTH_STENCIL_DESC)), "pDepthStencilDesc"), Out(Pointer(ObjPointer(ID3D11DepthStencilState)), "ppDepthStencilState")]),
    StdMethod(HRESULT, "CreateRasterizerState", [(Pointer(Const(D3D11_RASTERIZER_DESC)), "pRasterizerDesc"), Out(Pointer(ObjPointer(ID3D11RasterizerState)), "ppRasterizerState")]),
    StdMethod(HRESULT, "CreateSamplerState", [(Pointer(Const(D3D11_SAMPLER_DESC)), "pSamplerDesc"), Out(Pointer(ObjPointer(ID3D11SamplerState)), "ppSamplerState")]),
    StdMethod(HRESULT, "CreateQuery", [(Pointer(Const(D3D11_QUERY_DESC)), "pQueryDesc"), Out(Pointer(ObjPointer(ID3D11Query)), "ppQuery")]),
    StdMethod(HRESULT, "CreatePredicate", [(Pointer(Const(D3D11_QUERY_DESC)), "pPredicateDesc"), Out(Pointer(ObjPointer(ID3D11Predicate)), "ppPredicate")]),
    StdMethod(HRESULT, "CreateCounter", [(Pointer(Const(D3D11_COUNTER_DESC)), "pCounterDesc"), Out(Pointer(ObjPointer(ID3D11Counter)), "ppCounter")]),
    StdMethod(HRESULT, "CreateDeferredContext", [(UINT, "ContextFlags"), Out(Pointer(ObjPointer(ID3D11DeviceContext)), "ppDeferredContext")]),
    StdMethod(HRESULT, "OpenSharedResource", [(RAW_HANDLE, "hResource"), (REFIID, "ReturnedInterface"), Out(Pointer(ObjPointer(Void)), "ppResource")]),
    StdMethod(HRESULT, "CheckFormatSupport", [(DXGI_FORMAT, "Format"), Out(Pointer(D3D11_FORMAT_SUPPORT), "pFormatSupport")], sideeffects=False),
    StdMethod(HRESULT, "CheckMultisampleQualityLevels", [(DXGI_FORMAT, "Format"), (UINT, "SampleCount"), Out(Pointer(UINT), "pNumQualityLevels")], sideeffects=False),
    StdMethod(Void, "CheckCounterInfo", [Out(Pointer(D3D11_COUNTER_INFO), "pCounterInfo")], sideeffects=False),
    StdMethod(HRESULT, "CheckCounter", [(Pointer(Const(D3D11_COUNTER_DESC)), "pDesc"), Out(Pointer(D3D11_COUNTER_TYPE), "pType"), Out(Pointer(UINT), "pActiveCounters"), Out(LPSTR, "szName"), Out(Pointer(UINT), "pNameLength"), Out(LPSTR, "szUnits"), Out(Pointer(UINT), "pUnitsLength"), Out(LPSTR, "szDescription"), Out(Pointer(UINT), "pDescriptionLength")], sideeffects=False),
    StdMethod(HRESULT, "CheckFeatureSupport", [(D3D11_FEATURE, "Feature"), Out(D3D11_FEATURE_DATA, "pFeatureSupportData"), (UINT, "FeatureSupportDataSize")], sideeffects=False),
    StdMethod(HRESULT, "GetPrivateData", [(REFGUID, "guid"), InOut(Pointer(UINT), "pDataSize"), Out(OpaquePointer(Void), "pData")], sideeffects=False),
    StdMethod(HRESULT, "SetPrivateData", [(REFGUID, "guid"), (UINT, "DataSize"), (OpaqueBlob(Const(Void), "DataSize"), "pData")]),
    StdMethod(HRESULT, "SetPrivateDataInterface", [(REFGUID, "guid"), (OpaquePointer(Const(IUnknown)), "pData")], sideeffects=False),
    StdMethod(D3D_FEATURE_LEVEL, "GetFeatureLevel", [], sideeffects=False),
    StdMethod(D3D11_CREATE_DEVICE_FLAG, "GetCreationFlags", [], sideeffects=False),
    StdMethod(HRESULT, "GetDeviceRemovedReason", [], sideeffects=False),
    StdMethod(Void, "GetImmediateContext", [Out(Pointer(ObjPointer(ID3D11DeviceContext)), "ppImmediateContext")]),
    StdMethod(HRESULT, "SetExceptionMode", [(D3D11_RAISE_FLAG, "RaiseFlags")]),
    StdMethod(D3D11_RAISE_FLAG, "GetExceptionMode", [], sideeffects=False),
]


D3D_DRIVER_TYPE = Enum("D3D_DRIVER_TYPE", [
    "D3D_DRIVER_TYPE_UNKNOWN",
    "D3D_DRIVER_TYPE_HARDWARE",
    "D3D_DRIVER_TYPE_REFERENCE",
    "D3D_DRIVER_TYPE_NULL",
    "D3D_DRIVER_TYPE_SOFTWARE",
    "D3D_DRIVER_TYPE_WARP",
])


d3d11 = Module("d3d11")

d3d11.addFunctions([
    StdFunction(HRESULT, "D3D11CreateDevice", [(ObjPointer(IDXGIAdapter), "pAdapter"), (D3D_DRIVER_TYPE, "DriverType"), (HMODULE, "Software"), (D3D11_CREATE_DEVICE_FLAG, "Flags"), (Array(Const(D3D_FEATURE_LEVEL), "FeatureLevels"), "pFeatureLevels"), (UINT, "FeatureLevels"), (UINT, "SDKVersion"), Out(Pointer(ObjPointer(ID3D11Device)), "ppDevice"), Out(Pointer(D3D_FEATURE_LEVEL), "pFeatureLevel"), Out(Pointer(ObjPointer(ID3D11DeviceContext)), "ppImmediateContext")]),
    StdFunction(HRESULT, "D3D11CreateDeviceAndSwapChain", [(ObjPointer(IDXGIAdapter), "pAdapter"), (D3D_DRIVER_TYPE, "DriverType"), (HMODULE, "Software"), (D3D11_CREATE_DEVICE_FLAG, "Flags"), (Array(Const(D3D_FEATURE_LEVEL), "FeatureLevels"), "pFeatureLevels"), (UINT, "FeatureLevels"), (UINT, "SDKVersion"), (Pointer(Const(DXGI_SWAP_CHAIN_DESC)), "pSwapChainDesc"), Out(Pointer(ObjPointer(IDXGISwapChain)), "ppSwapChain"), Out(Pointer(ObjPointer(ID3D11Device)), "ppDevice"), Out(Pointer(D3D_FEATURE_LEVEL), "pFeatureLevel"), Out(Pointer(ObjPointer(ID3D11DeviceContext)), "ppImmediateContext")]),
])

d3d11.addInterfaces([
    ID3D11Debug,
    ID3D11InfoQueue,
    ID3D11SwitchToRef,
])


#
# D3D11 Video
#

D3D11_VIDEO_DECODER_DESC = Struct("D3D11_VIDEO_DECODER_DESC", [
    (GUID, "Guid"),
    (UINT, "SampleWidth"),
    (UINT, "SampleHeight"),
    (DXGI_FORMAT, "OutputFormat"),
])

D3D11_VIDEO_DECODER_CONFIG = Struct("D3D11_VIDEO_DECODER_CONFIG", [
    (GUID, "guidConfigBitstreamEncryption"),
    (GUID, "guidConfigMBcontrolEncryption"),
    (GUID, "guidConfigResidDiffEncryption"),
    (UINT, "ConfigBitstreamRaw"),
    (UINT, "ConfigMBcontrolRasterOrder"),
    (UINT, "ConfigResidDiffHost"),
    (UINT, "ConfigSpatialResid8"),
    (UINT, "ConfigResid8Subtraction"),
    (UINT, "ConfigSpatialHost8or9Clipping"),
    (UINT, "ConfigSpatialResidInterleaved"),
    (UINT, "ConfigIntraResidUnsigned"),
    (UINT, "ConfigResidDiffAccelerator"),
    (UINT, "ConfigHostInverseScan"),
    (UINT, "ConfigSpecificIDCT"),
    (UINT, "Config4GroupedCoefs"),
    (USHORT, "ConfigMinRenderTargetBuffCount"),
    (USHORT, "ConfigDecoderSpecific"),
])

D3D11_VIDEO_DECODER_BUFFER_TYPE = Enum("D3D11_VIDEO_DECODER_BUFFER_TYPE", [
    "D3D11_VIDEO_DECODER_BUFFER_PICTURE_PARAMETERS",
    "D3D11_VIDEO_DECODER_BUFFER_MACROBLOCK_CONTROL",
    "D3D11_VIDEO_DECODER_BUFFER_RESIDUAL_DIFFERENCE",
    "D3D11_VIDEO_DECODER_BUFFER_DEBLOCKING_CONTROL",
    "D3D11_VIDEO_DECODER_BUFFER_INVERSE_QUANTIZATION_MATRIX",
    "D3D11_VIDEO_DECODER_BUFFER_SLICE_CONTROL",
    "D3D11_VIDEO_DECODER_BUFFER_BITSTREAM",
    "D3D11_VIDEO_DECODER_BUFFER_MOTION_VECTOR",
    "D3D11_VIDEO_DECODER_BUFFER_FILM_GRAIN",
])

D3D11_AES_CTR_IV = Struct("D3D11_AES_CTR_IV", [
    (UINT64, "IV"),
    (UINT64, "Count"),
])

D3D11_ENCRYPTED_BLOCK_INFO = Struct("D3D11_ENCRYPTED_BLOCK_INFO", [
    (UINT, "NumEncryptedBytesAtBeginning"),
    (UINT, "NumBytesInSkipPattern"),
    (UINT, "NumBytesInEncryptPattern"),
])

D3D11_VIDEO_DECODER_BUFFER_DESC = Struct("D3D11_VIDEO_DECODER_BUFFER_DESC", [
    (D3D11_VIDEO_DECODER_BUFFER_TYPE, "BufferType"),
    (UINT, "BufferIndex"),
    (UINT, "DataOffset"),
    (UINT, "DataSize"),
    (UINT, "FirstMBaddress"),
    (UINT, "NumMBsInBuffer"),
    (UINT, "Width"),
    (UINT, "Height"),
    (UINT, "Stride"),
    (UINT, "ReservedBits"),
    (Blob(Void, "{self}.IVSize"), "pIV"),
    (UINT, "IVSize"),
    (BOOL, "PartialEncryption"),
    (D3D11_ENCRYPTED_BLOCK_INFO, "EncryptedBlockInfo"),
])

D3D11_VIDEO_DECODER_EXTENSION = Struct("D3D11_VIDEO_DECODER_EXTENSION", [
    (UINT, "Function"),
    (Blob(Void, "{self}.PrivateInputDataSize"), "pPrivateInputData"),
    (UINT, "PrivateInputDataSize"),
    (Blob(Void, "{self}.PrivateOutputDataSize"), "pPrivateOutputData"),
    (UINT, "PrivateOutputDataSize"),
    (UINT, "ResourceCount"),
    (Array(ObjPointer(ID3D11Resource), "{self}.ResourceCount"), "ppResourceList"),
])

ID3D11VideoDecoder = Interface("ID3D11VideoDecoder", ID3D11DeviceChild)
ID3D11VideoDecoder.methods += [
    StdMethod(HRESULT, "GetCreationParameters", [Out(Pointer(D3D11_VIDEO_DECODER_DESC), "pVideoDesc"), Out(Pointer(D3D11_VIDEO_DECODER_CONFIG), "pConfig")], sideeffects=False),
    StdMethod(HRESULT, "GetDriverHandle", [Out(Pointer(HANDLE), "pDriverHandle")]),
]

D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT = Flags(UINT, [
    "D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_INPUT",
    "D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_OUTPUT",
])

D3D11_VIDEO_PROCESSOR_DEVICE_CAPS = Flags(UINT, [
    "D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_LINEAR_SPACE",
    "D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_xvYCC",
    "D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_RGB_RANGE_CONVERSION",
    "D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_YCbCr_MATRIX_CONVERSION",
    "D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_NOMINAL_RANGE",
])

D3D11_VIDEO_PROCESSOR_FEATURE_CAPS = Flags(UINT, [
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_FILL",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_CONSTRICTION",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LUMA_KEY",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_PALETTE",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LEGACY",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_STEREO",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ROTATION",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_STREAM",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_PIXEL_ASPECT_RATIO",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_MIRROR",
    "D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_SHADER_USAGE",
])

D3D11_VIDEO_PROCESSOR_FILTER_CAPS = Flags(UINT, [
    "D3D11_VIDEO_PROCESSOR_FILTER_CAPS_BRIGHTNESS",
    "D3D11_VIDEO_PROCESSOR_FILTER_CAPS_CONTRAST",
    "D3D11_VIDEO_PROCESSOR_FILTER_CAPS_HUE",
    "D3D11_VIDEO_PROCESSOR_FILTER_CAPS_SATURATION",
    "D3D11_VIDEO_PROCESSOR_FILTER_CAPS_NOISE_REDUCTION",
    "D3D11_VIDEO_PROCESSOR_FILTER_CAPS_EDGE_ENHANCEMENT",
    "D3D11_VIDEO_PROCESSOR_FILTER_CAPS_ANAMORPHIC_SCALING",
    "D3D11_VIDEO_PROCESSOR_FILTER_CAPS_STEREO_ADJUSTMENT",
])

D3D11_VIDEO_PROCESSOR_FORMAT_CAPS = Flags(UINT, [
    "D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_INTERLACED",
    "D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_PROCAMP",
    "D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_LUMA_KEY",
    "D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_PALETTE_INTERLACED",
])

D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS = Flags(UINT, [
    "D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DENOISE",
    "D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DERINGING",
    "D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_EDGE_ENHANCEMENT",
    "D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_COLOR_CORRECTION",
    "D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_FLESH_TONE_MAPPING",
    "D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_IMAGE_STABILIZATION",
    "D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_SUPER_RESOLUTION",
    "D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_ANAMORPHIC_SCALING",
])

D3D11_VIDEO_PROCESSOR_STEREO_CAPS = Flags(UINT, [
    "D3D11_VIDEO_PROCESSOR_STEREO_CAPS_MONO_OFFSET",
    "D3D11_VIDEO_PROCESSOR_STEREO_CAPS_ROW_INTERLEAVED",
    "D3D11_VIDEO_PROCESSOR_STEREO_CAPS_COLUMN_INTERLEAVED",
    "D3D11_VIDEO_PROCESSOR_STEREO_CAPS_CHECKERBOARD",
    "D3D11_VIDEO_PROCESSOR_STEREO_CAPS_FLIP_MODE",
])

D3D11_VIDEO_PROCESSOR_CAPS = Struct("D3D11_VIDEO_PROCESSOR_CAPS", [
    (D3D11_VIDEO_PROCESSOR_DEVICE_CAPS, "DeviceCaps"),
    (D3D11_VIDEO_PROCESSOR_FEATURE_CAPS, "FeatureCaps"),
    (D3D11_VIDEO_PROCESSOR_FILTER_CAPS, "FilterCaps"),
    (D3D11_VIDEO_PROCESSOR_FORMAT_CAPS, "InputFormatCaps"),
    (D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS, "AutoStreamCaps"),
    (D3D11_VIDEO_PROCESSOR_STEREO_CAPS, "StereoCaps"),
    (UINT, "RateConversionCapsCount"),
    (UINT, "MaxInputStreams"),
    (UINT, "MaxStreamStates"),
])

D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS = Flags(UINT, [
    "D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BLEND",
    "D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BOB",
    "D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_ADAPTIVE",
    "D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_MOTION_COMPENSATION",
    "D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_INVERSE_TELECINE",
    "D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_FRAME_RATE_CONVERSION",
])

D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS = Flags(UINT, [
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32",
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_22",
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2224",
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2332",
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32322",
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_55",
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_64",
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_87",
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_222222222223",
    "D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_OTHER",
])

D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS = Struct("D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS", [
    (UINT, "PastFrames"),
    (UINT, "FutureFrames"),
    (D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS, "ProcessorCaps"),
    (D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS, "ITelecineCaps"),
    (UINT, "CustomRateCount"),
])

D3D11_CONTENT_PROTECTION_CAPS = Flags(UINT, [
    "D3D11_CONTENT_PROTECTION_CAPS_SOFTWARE",
    "D3D11_CONTENT_PROTECTION_CAPS_HARDWARE",
    "D3D11_CONTENT_PROTECTION_CAPS_PROTECTION_ALWAYS_ON",
    "D3D11_CONTENT_PROTECTION_CAPS_PARTIAL_DECRYPTION",
    "D3D11_CONTENT_PROTECTION_CAPS_CONTENT_KEY",
    "D3D11_CONTENT_PROTECTION_CAPS_FRESHEN_SESSION_KEY",
    "D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK",
    "D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK_KEY",
    "D3D11_CONTENT_PROTECTION_CAPS_SEQUENTIAL_CTR_IV",
    "D3D11_CONTENT_PROTECTION_CAPS_ENCRYPT_SLICEDATA_ONLY",
    "D3D11_CONTENT_PROTECTION_CAPS_DECRYPTION_BLT",
    "D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECT_UNCOMPRESSED",
    "D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECTED_MEMORY_PAGEABLE",
    "D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_TEARDOWN",
    "D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_DRM_COMMUNICATION",
])

D3D11_VIDEO_CONTENT_PROTECTION_CAPS = Struct("D3D11_VIDEO_CONTENT_PROTECTION_CAPS", [
    (D3D11_CONTENT_PROTECTION_CAPS, "Caps"),
    (UINT, "KeyExchangeTypeCount"),
    (UINT, "BlockAlignmentSize"),
    (ULONGLONG, "ProtectedMemorySize"),
])

D3D11_VIDEO_PROCESSOR_CUSTOM_RATE = Struct("D3D11_VIDEO_PROCESSOR_CUSTOM_RATE", [
    (DXGI_RATIONAL, "CustomRate"),
    (UINT, "OutputFrames"),
    (BOOL, "InputInterlaced"),
    (UINT, "InputFramesOrFields"),
])

D3D11_VIDEO_PROCESSOR_FILTER = Enum("D3D11_VIDEO_PROCESSOR_FILTER", [
    "D3D11_VIDEO_PROCESSOR_FILTER_BRIGHTNESS",
    "D3D11_VIDEO_PROCESSOR_FILTER_CONTRAST",
    "D3D11_VIDEO_PROCESSOR_FILTER_HUE",
    "D3D11_VIDEO_PROCESSOR_FILTER_SATURATION",
    "D3D11_VIDEO_PROCESSOR_FILTER_NOISE_REDUCTION",
    "D3D11_VIDEO_PROCESSOR_FILTER_EDGE_ENHANCEMENT",
    "D3D11_VIDEO_PROCESSOR_FILTER_ANAMORPHIC_SCALING",
    "D3D11_VIDEO_PROCESSOR_FILTER_STEREO_ADJUSTMENT",
])

D3D11_VIDEO_PROCESSOR_FILTER_RANGE = Struct("D3D11_VIDEO_PROCESSOR_FILTER_RANGE", [
    (Int, "Minimum"),
    (Int, "Maximum"),
    (Int, "Default"),
    (Float, "Multiplier"),
])

D3D11_VIDEO_FRAME_FORMAT = Enum("D3D11_VIDEO_FRAME_FORMAT", [
    "D3D11_VIDEO_FRAME_FORMAT_PROGRESSIVE",
    "D3D11_VIDEO_FRAME_FORMAT_INTERLACED_TOP_FIELD_FIRST",
    "D3D11_VIDEO_FRAME_FORMAT_INTERLACED_BOTTOM_FIELD_FIRST",
])

D3D11_VIDEO_USAGE = Enum("D3D11_VIDEO_USAGE", [
    "D3D11_VIDEO_USAGE_PLAYBACK_NORMAL",
    "D3D11_VIDEO_USAGE_OPTIMAL_SPEED",
    "D3D11_VIDEO_USAGE_OPTIMAL_QUALITY",
])

D3D11_VIDEO_PROCESSOR_CONTENT_DESC = Struct("D3D11_VIDEO_PROCESSOR_CONTENT_DESC", [
    (D3D11_VIDEO_FRAME_FORMAT, "InputFrameFormat"),
    (DXGI_RATIONAL, "InputFrameRate"),
    (UINT, "InputWidth"),
    (UINT, "InputHeight"),
    (DXGI_RATIONAL, "OutputFrameRate"),
    (UINT, "OutputWidth"),
    (UINT, "OutputHeight"),
    (D3D11_VIDEO_USAGE, "Usage"),
])

ID3D11VideoProcessorEnumerator = Interface("ID3D11VideoProcessorEnumerator", ID3D11DeviceChild)
ID3D11VideoProcessorEnumerator.methods += [
    StdMethod(HRESULT, "GetVideoProcessorContentDesc", [Out(Pointer(D3D11_VIDEO_PROCESSOR_CONTENT_DESC), "pContentDesc")], sideeffects=False),
    StdMethod(HRESULT, "CheckVideoProcessorFormat", [(DXGI_FORMAT, "Format"), Out(Pointer(D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT), "pFlags")], sideeffects=False),
    StdMethod(HRESULT, "GetVideoProcessorCaps", [Out(Pointer(D3D11_VIDEO_PROCESSOR_CAPS), "pCaps")], sideeffects=False),
    StdMethod(HRESULT, "GetVideoProcessorRateConversionCaps", [(UINT, "TypeIndex"), Out(Pointer(D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS), "pCaps")], sideeffects=False),
    StdMethod(HRESULT, "GetVideoProcessorCustomRate", [(UINT, "TypeIndex"), (UINT, "CustomRateIndex"), Out(Pointer(D3D11_VIDEO_PROCESSOR_CUSTOM_RATE), "pRate")], sideeffects=False),
    StdMethod(HRESULT, "GetVideoProcessorFilterRange", [(D3D11_VIDEO_PROCESSOR_FILTER, "Filter"), Out(Pointer(D3D11_VIDEO_PROCESSOR_FILTER_RANGE), "pRange")], sideeffects=False),
]

D3D11_VIDEO_COLOR_RGBA = Struct("D3D11_VIDEO_COLOR_RGBA", [
    (Float, "R"),
    (Float, "G"),
    (Float, "B"),
    (Float, "A"),
])

D3D11_VIDEO_COLOR_YCbCrA = Struct("D3D11_VIDEO_COLOR_YCbCrA", [
    (Float, "Y"),
    (Float, "Cb"),
    (Float, "Cr"),
    (Float, "A"),
])

D3D11_VIDEO_COLOR = Struct("D3D11_VIDEO_COLOR", [
    (D3D11_VIDEO_COLOR_YCbCrA, "YCbCr"),
    #(D3D11_VIDEO_COLOR_RGBA, "RGBA"),
])

D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE = FakeEnum(UINT, [
    "D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_UNDEFINED",
    "D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_16_235",
    "D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_0_255",
])

D3D11_VIDEO_PROCESSOR_COLOR_SPACE = Struct("D3D11_VIDEO_PROCESSOR_COLOR_SPACE", [
    (UINT, "Usage"),
    (UINT, "RGB_Range"),
    (UINT, "YCbCr_Matrix"),
    (UINT, "YCbCr_xvYCC"),
    (D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE, "Nominal_Range"),
    (UINT, "Reserved"),
])

D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE = Enum("D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE", [
    "D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_OPAQUE",
    "D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_BACKGROUND",
    "D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_DESTINATION",
    "D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_SOURCE_STREAM",
])

D3D11_VIDEO_PROCESSOR_OUTPUT_RATE = Enum("D3D11_VIDEO_PROCESSOR_OUTPUT_RATE", [
    "D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_NORMAL",
    "D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_HALF",
    "D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_CUSTOM",
])

D3D11_VIDEO_PROCESSOR_STEREO_FORMAT = Enum("D3D11_VIDEO_PROCESSOR_STEREO_FORMAT", [
    "D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO",
    "D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_HORIZONTAL",
    "D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_VERTICAL",
    "D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_SEPARATE",
    "D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO_OFFSET",
    "D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_ROW_INTERLEAVED",
    "D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_COLUMN_INTERLEAVED",
    "D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_CHECKERBOARD",
])

D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE = Enum("D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE", [
    "D3D11_VIDEO_PROCESSOR_STEREO_FLIP_NONE",
    "D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME0",
    "D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME1",
])

D3D11_VIDEO_PROCESSOR_ROTATION = Enum("D3D11_VIDEO_PROCESSOR_ROTATION", [
    "D3D11_VIDEO_PROCESSOR_ROTATION_IDENTITY",
    "D3D11_VIDEO_PROCESSOR_ROTATION_90",
    "D3D11_VIDEO_PROCESSOR_ROTATION_180",
    "D3D11_VIDEO_PROCESSOR_ROTATION_270",
])

ID3D11VideoProcessorInputView = Interface("ID3D11VideoProcessorInputView", ID3D11View)

D3D11_VIDEO_PROCESSOR_STREAM = Struct("D3D11_VIDEO_PROCESSOR_STREAM", [
    (BOOL, "Enable"),
    (UINT, "OutputIndex"),
    (UINT, "InputFrameOrField"),
    (UINT, "PastFrames"),
    (UINT, "FutureFrames"),
    (Array(ObjPointer(ID3D11VideoProcessorInputView), "{self}.PastFrames"), "ppPastSurfaces"),
    (ObjPointer(ID3D11VideoProcessorInputView), "pInputSurface"),
    (Array(ObjPointer(ID3D11VideoProcessorInputView), "{self}.FutureFrames"), "ppFutureSurfaces"),
    (Array(ObjPointer(ID3D11VideoProcessorInputView), "{self}.PastFrames"), "ppPastSurfacesRight"),
    (ObjPointer(ID3D11VideoProcessorInputView), "pInputSurfaceRight"),
    (Array(ObjPointer(ID3D11VideoProcessorInputView), "{self}.FutureFrames"), "ppFutureSurfacesRight"),
])

ID3D11VideoProcessor = Interface("ID3D11VideoProcessor", ID3D11DeviceChild)
ID3D11VideoProcessor.methods += [
    StdMethod(Void, "GetContentDesc", [Out(Pointer(D3D11_VIDEO_PROCESSOR_CONTENT_DESC), "pDesc")], sideeffects=False),
    StdMethod(Void, "GetRateConversionCaps", [Out(Pointer(D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS), "pCaps")], sideeffects=False),
]

D3D11_OMAC = Struct("D3D11_OMAC", [
    (Array(BYTE, 16), "Omac"),
])

D3D11_AUTHENTICATED_CHANNEL_TYPE = Enum("D3D11_AUTHENTICATED_CHANNEL_TYPE", [
    "D3D11_AUTHENTICATED_CHANNEL_D3D11",
    "D3D11_AUTHENTICATED_CHANNEL_DRIVER_SOFTWARE",
    "D3D11_AUTHENTICATED_CHANNEL_DRIVER_HARDWARE",
])

ID3D11AuthenticatedChannel = Interface("ID3D11AuthenticatedChannel", ID3D11DeviceChild)
ID3D11AuthenticatedChannel.methods += [
    StdMethod(HRESULT, "GetCertificateSize", [Out(Pointer(UINT), "pCertificateSize")], sideeffects=False),
    StdMethod(HRESULT, "GetCertificate", [(UINT, "CertificateSize"), Out(Array(BYTE, "CertificateSize"), "pCertificate")], sideeffects=False),
    StdMethod(Void, "GetChannelHandle", [Out(Pointer(HANDLE), "pChannelHandle")]),
]

D3D11_AUTHENTICATED_QUERY_INPUT = Struct("D3D11_AUTHENTICATED_QUERY_INPUT", [
    (GUID, "QueryType"),
    (HANDLE, "hChannel"),
    (UINT, "SequenceNumber"),
])

D3D11_AUTHENTICATED_QUERY_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_OUTPUT", [
    (D3D11_OMAC, "omac"),
    (GUID, "QueryType"),
    (HANDLE, "hChannel"),
    (UINT, "SequenceNumber"),
    (HRESULT, "ReturnCode"),
])

D3D11_AUTHENTICATED_PROTECTION_FLAGS = Struct("D3D11_AUTHENTICATED_PROTECTION_FLAGS", [
    (UINT, "ProtectionEnabled"),
    (UINT, "OverlayOrFullscreenRequired"),
    (UINT, "Reserved"),
])

D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (D3D11_AUTHENTICATED_PROTECTION_FLAGS, "ProtectionFlags"),
])

D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (D3D11_AUTHENTICATED_CHANNEL_TYPE, "ChannelType"),
])

D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (HANDLE, "DeviceHandle"),
])

D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT = Struct("D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT", [
    (D3D11_AUTHENTICATED_QUERY_INPUT, "Input"),
    (HANDLE, "DecoderHandle"),
])

D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (HANDLE, "DecoderHandle"),
    (HANDLE, "CryptoSessionHandle"),
    (HANDLE, "DeviceHandle"),
])

D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (UINT, "RestrictedSharedResourceProcessCount"),
])

D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT = Struct("D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT", [
    (D3D11_AUTHENTICATED_QUERY_INPUT, "Input"),
    (UINT, "ProcessIndex"),
])

D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE = Enum("D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE", [
    "D3D11_PROCESSIDTYPE_UNKNOWN",
    "D3D11_PROCESSIDTYPE_DWM",
    "D3D11_PROCESSIDTYPE_HANDLE",
])

D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (UINT, "ProcessIndex"),
    (D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE, "ProcessIdentifier"),
    (HANDLE, "ProcessHandle"),
])

D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (UINT, "UnrestrictedProtectedSharedResourceCount"),
])

D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT = Struct("D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT", [
    (D3D11_AUTHENTICATED_QUERY_INPUT, "Input"),
    (HANDLE, "DeviceHandle"),
    (HANDLE, "CryptoSessionHandle"),
])

D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (HANDLE, "DeviceHandle"),
    (HANDLE, "CryptoSessionHandle"),
    (UINT, "OutputIDCount"),
])

D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT = Struct("D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT", [
    (D3D11_AUTHENTICATED_QUERY_INPUT, "Input"),
    (HANDLE, "DeviceHandle"),
    (HANDLE, "CryptoSessionHandle"),
    (UINT, "OutputIDIndex"),
])

D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (HANDLE, "DeviceHandle"),
    (HANDLE, "CryptoSessionHandle"),
    (UINT, "OutputIDIndex"),
    (UINT64, "OutputID"),
])

D3D11_BUS_TYPE = Enum("D3D11_BUS_TYPE", [
    "D3D11_BUS_TYPE_OTHER",
    "D3D11_BUS_TYPE_PCI",
    "D3D11_BUS_TYPE_PCIX",
    "D3D11_BUS_TYPE_AGP",
    "D3D11_BUS_TYPE_PCIEXPRESS",
    # XXX: Flags
    "D3D11_BUS_IMPL_MODIFIER_INSIDE_OF_CHIPSET",
    "D3D11_BUS_IMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_CHIP",
    "D3D11_BUS_IMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_SOCKET",
    "D3D11_BUS_IMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR",
    "D3D11_BUS_IMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR_INSIDE_OF_NUAE",
    "D3D11_BUS_IMPL_MODIFIER_NON_STANDARD",
])

D3D11_AUTHENTICATED_QUERY_ACESSIBILITY_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_ACESSIBILITY_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (D3D11_BUS_TYPE, "BusType"),
    (BOOL, "AccessibleInContiguousBlocks"),
    (BOOL, "AccessibleInNonContiguousBlocks"),
])

D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (UINT, "EncryptionGuidCount"),
])

D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT = Struct("D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT", [
    (D3D11_AUTHENTICATED_QUERY_INPUT, "Input"),
    (UINT, "EncryptionGuidIndex"),
])

D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (UINT, "EncryptionGuidIndex"),
    (GUID, "EncryptionGuid"),
])

D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT = Struct("D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT", [
    (D3D11_AUTHENTICATED_QUERY_OUTPUT, "Output"),
    (GUID, "EncryptionGuid"),
])

D3D11_AUTHENTICATED_CONFIGURE_INPUT = Struct("D3D11_AUTHENTICATED_CONFIGURE_INPUT", [
    (D3D11_OMAC, "omac"),
    (GUID, "ConfigureType"),
    (HANDLE, "hChannel"),
    (UINT, "SequenceNumber"),
])

D3D11_AUTHENTICATED_CONFIGURE_OUTPUT = Struct("D3D11_AUTHENTICATED_CONFIGURE_OUTPUT", [
    (D3D11_OMAC, "omac"),
    (GUID, "ConfigureType"),
    (HANDLE, "hChannel"),
    (UINT, "SequenceNumber"),
    (HRESULT, "ReturnCode"),
])

D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT = Struct("D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT", [
    (D3D11_AUTHENTICATED_CONFIGURE_INPUT, "Parameters"),
    (UINT, "StartSequenceQuery"),
    (UINT, "StartSequenceConfigure"),
])

D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT = Struct("D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT", [
    (D3D11_AUTHENTICATED_CONFIGURE_INPUT, "Parameters"),
    (D3D11_AUTHENTICATED_PROTECTION_FLAGS, "Protections"),
])

D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT = Struct("D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT", [
    (D3D11_AUTHENTICATED_CONFIGURE_INPUT, "Parameters"),
    (HANDLE, "DecoderHandle"),
    (HANDLE, "CryptoSessionHandle"),
    (HANDLE, "DeviceHandle"),
])

D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT = Struct("D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT", [
    (D3D11_AUTHENTICATED_CONFIGURE_INPUT, "Parameters"),
    (D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE, "ProcessType"),
    (HANDLE, "ProcessHandle"),
    (BOOL, "AllowAccess"),
])

D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT = Struct("D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT", [
    (D3D11_AUTHENTICATED_CONFIGURE_INPUT, "Parameters"),
    (GUID, "EncryptionGuid"),
])

ID3D11CryptoSession = Interface("ID3D11CryptoSession", ID3D11DeviceChild)
ID3D11CryptoSession.methods += [
    StdMethod(Void, "GetCryptoType", [Out(Pointer(GUID), "pCryptoType")], sideeffects=False),
    StdMethod(Void, "GetDecoderProfile", [Out(Pointer(GUID), "pDecoderProfile")], sideeffects=False),
    StdMethod(HRESULT, "GetCertificateSize", [Out(Pointer(UINT), "pCertificateSize")], sideeffects=False),
    StdMethod(HRESULT, "GetCertificate", [(UINT, "CertificateSize"), Out(Pointer(BYTE), "pCertificate")], sideeffects=False),
    StdMethod(Void, "GetCryptoSessionHandle", [Out(Pointer(HANDLE), "pCryptoSessionHandle")]),
]

D3D11_VDOV_DIMENSION = Enum("D3D11_VDOV_DIMENSION", [
    "D3D11_VDOV_DIMENSION_UNKNOWN",
    "D3D11_VDOV_DIMENSION_TEXTURE2D",
])

D3D11_TEX2D_VDOV = Struct("D3D11_TEX2D_VDOV", [
    (UINT, "ArraySlice"),
])

D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC = Struct("D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC", [
    (GUID, "DecodeProfile"),
    (D3D11_VDOV_DIMENSION, "ViewDimension"),
    (Union("{self}.ViewDimension", [
        ("D3D11_VDOV_DIMENSION_TEXTURE2D", D3D11_TEX2D_VDOV, "Texture2D"),
    ]), None),
])

ID3D11VideoDecoderOutputView = Interface("ID3D11VideoDecoderOutputView", ID3D11View)
ID3D11VideoDecoderOutputView.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC), "pDesc")], sideeffects=None),
]

D3D11_VPIV_DIMENSION = Enum("D3D11_VPIV_DIMENSION", [
    "D3D11_VPIV_DIMENSION_UNKNOWN",
    "D3D11_VPIV_DIMENSION_TEXTURE2D",
])

D3D11_TEX2D_VPIV = Struct("D3D11_TEX2D_VPIV", [
    (UINT, "MipSlice"),
    (UINT, "ArraySlice"),
])

D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC = Struct("D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC", [
    (UINT, "FourCC"),
    (D3D11_VPIV_DIMENSION, "ViewDimension"),
    (Union("{self}.ViewDimension", [
        ("D3D11_VPIV_DIMENSION_TEXTURE2D", D3D11_TEX2D_VPIV, "Texture2D"),
    ]), None),
])

ID3D11VideoProcessorInputView.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC), "pDesc")], sideeffects=None),
]

D3D11_VPOV_DIMENSION = Enum("D3D11_VPOV_DIMENSION", [
    "D3D11_VPOV_DIMENSION_UNKNOWN",
    "D3D11_VPOV_DIMENSION_TEXTURE2D",
    "D3D11_VPOV_DIMENSION_TEXTURE2DARRAY",
])

D3D11_TEX2D_VPOV = Struct("D3D11_TEX2D_VPOV", [
    (UINT, "MipSlice"),
])

D3D11_TEX2D_ARRAY_VPOV = Struct("D3D11_TEX2D_ARRAY_VPOV", [
    (UINT, "MipSlice"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
])

D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC = Struct("D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC", [
    (D3D11_VPOV_DIMENSION, "ViewDimension"),
    (Union("{self}.ViewDimension", [
        ("D3D11_VPOV_DIMENSION_TEXTURE2D", D3D11_TEX2D_VPOV, "Texture2D"),
        ("D3D11_VPOV_DIMENSION_TEXTURE2DARRAY", D3D11_TEX2D_ARRAY_VPOV, "Texture2DArray"),
    ]), None),
])

ID3D11VideoProcessorOutputView = Interface("ID3D11VideoProcessorOutputView", ID3D11View)
ID3D11VideoProcessorOutputView.methods += [
    StdMethod(Void, "GetDesc", [Out(Pointer(D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC), "pDesc")], sideeffects=None),
]

ID3D11VideoContext = Interface("ID3D11VideoContext", ID3D11DeviceChild)
ID3D11VideoContext.methods += [
    StdMethod(HRESULT, "GetDecoderBuffer", [(ObjPointer(ID3D11VideoDecoder), "pDecoder"), (D3D11_VIDEO_DECODER_BUFFER_TYPE, "Type"), Out(Pointer(UINT), "pBufferSize"), Out(Pointer(LinearPointer(Void, "*pBufferSize")), "ppBuffer")]),
    StdMethod(HRESULT, "ReleaseDecoderBuffer", [(ObjPointer(ID3D11VideoDecoder), "pDecoder"), (D3D11_VIDEO_DECODER_BUFFER_TYPE, "Type")]),
    StdMethod(HRESULT, "DecoderBeginFrame", [(ObjPointer(ID3D11VideoDecoder), "pDecoder"), (ObjPointer(ID3D11VideoDecoderOutputView), "pView"), (UINT, "ContentKeySize"), (Blob(Const(Void), "ContentKeySize"), "pContentKey")]),
    StdMethod(HRESULT, "DecoderEndFrame", [(ObjPointer(ID3D11VideoDecoder), "pDecoder")]),
    StdMethod(HRESULT, "SubmitDecoderBuffers", [(ObjPointer(ID3D11VideoDecoder), "pDecoder"), (UINT, "NumBuffers"), (Array(Const(D3D11_VIDEO_DECODER_BUFFER_DESC), "NumBuffers"), "pBufferDesc")]),
    StdMethod(HRESULT, "DecoderExtension", [(ObjPointer(ID3D11VideoDecoder), "pDecoder"), (Pointer(Const(D3D11_VIDEO_DECODER_EXTENSION)), "pExtensionData")]),
    StdMethod(Void, "VideoProcessorSetOutputTargetRect", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (BOOL, "Enable"), (Pointer(Const(RECT)), "pRect")]),
    StdMethod(Void, "VideoProcessorSetOutputBackgroundColor", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (BOOL, "YCbCr"), (Pointer(Const(D3D11_VIDEO_COLOR)), "pColor")]),
    StdMethod(Void, "VideoProcessorSetOutputColorSpace", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (Pointer(Const(D3D11_VIDEO_PROCESSOR_COLOR_SPACE)), "pColorSpace")]),
    StdMethod(Void, "VideoProcessorSetOutputAlphaFillMode", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE, "AlphaFillMode"), (UINT, "StreamIndex")]),
    StdMethod(Void, "VideoProcessorSetOutputConstriction", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (BOOL, "Enable"), (SIZE, "Size")]),
    StdMethod(Void, "VideoProcessorSetOutputStereoMode", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (BOOL, "Enable")]),
    StdMethod(HRESULT, "VideoProcessorSetOutputExtension", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (Pointer(Const(GUID)), "pExtensionGuid"), (UINT, "DataSize"), (Blob(Void, "DataSize"), "pData")]),
    StdMethod(Void, "VideoProcessorGetOutputTargetRect", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), Out(Pointer(BOOL), "Enabled"), Out(Pointer(RECT), "pRect")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetOutputBackgroundColor", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), Out(Pointer(BOOL), "pYCbCr"), Out(Pointer(D3D11_VIDEO_COLOR), "pColor")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetOutputColorSpace", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), Out(Pointer(D3D11_VIDEO_PROCESSOR_COLOR_SPACE), "pColorSpace")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetOutputAlphaFillMode", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), Out(Pointer(D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE), "pAlphaFillMode"), Out(Pointer(UINT), "pStreamIndex")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetOutputConstriction", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), Out(Pointer(BOOL), "pEnabled"), Out(Pointer(SIZE), "pSize")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetOutputStereoMode", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), Out(Pointer(BOOL), "pEnabled")], sideeffects=False),
    StdMethod(HRESULT, "VideoProcessorGetOutputExtension", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (Pointer(Const(GUID)), "pExtensionGuid"), (UINT, "DataSize"), Out(OpaqueBlob(Void, "DataSize"), "pData")], sideeffects=False),
    StdMethod(Void, "VideoProcessorSetStreamFrameFormat", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (D3D11_VIDEO_FRAME_FORMAT, "FrameFormat")]),
    StdMethod(Void, "VideoProcessorSetStreamColorSpace", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (Pointer(Const(D3D11_VIDEO_PROCESSOR_COLOR_SPACE)), "pColorSpace")]),
    StdMethod(Void, "VideoProcessorSetStreamOutputRate", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (D3D11_VIDEO_PROCESSOR_OUTPUT_RATE, "OutputRate"), (BOOL, "RepeatFrame"), (Pointer(Const(DXGI_RATIONAL)), "pCustomRate")]),
    StdMethod(Void, "VideoProcessorSetStreamSourceRect", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (BOOL, "Enable"), (Pointer(Const(RECT)), "pRect")]),
    StdMethod(Void, "VideoProcessorSetStreamDestRect", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (BOOL, "Enable"), (Pointer(Const(RECT)), "pRect")]),
    StdMethod(Void, "VideoProcessorSetStreamAlpha", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (BOOL, "Enable"), (FLOAT, "Alpha")]),
    StdMethod(Void, "VideoProcessorSetStreamPalette", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (UINT, "Count"), (Pointer(Const(UINT)), "pEntries")]),
    StdMethod(Void, "VideoProcessorSetStreamPixelAspectRatio", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (BOOL, "Enable"), (Pointer(Const(DXGI_RATIONAL)), "pSourceAspectRatio"), (Pointer(Const(DXGI_RATIONAL)), "pDestinationAspectRatio")]),
    StdMethod(Void, "VideoProcessorSetStreamLumaKey", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (BOOL, "Enable"), (FLOAT, "Lower"), (FLOAT, "Upper")]),
    StdMethod(Void, "VideoProcessorSetStreamStereoFormat", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (BOOL, "Enable"), (D3D11_VIDEO_PROCESSOR_STEREO_FORMAT, "Format"), (BOOL, "LeftViewFrame0"), (BOOL, "BaseViewFrame0"), (D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE, "FlipMode"), (Int, "MonoOffset")]),
    StdMethod(Void, "VideoProcessorSetStreamAutoProcessingMode", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (BOOL, "Enable")]),
    StdMethod(Void, "VideoProcessorSetStreamFilter", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (D3D11_VIDEO_PROCESSOR_FILTER, "Filter"), (BOOL, "Enable"), (Int, "Level")]),
    StdMethod(HRESULT, "VideoProcessorSetStreamExtension", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (Pointer(Const(GUID)), "pExtensionGuid"), (UINT, "DataSize"), (Blob(Void, "DataSize"), "pData")]),
    StdMethod(Void, "VideoProcessorGetStreamFrameFormat", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(D3D11_VIDEO_FRAME_FORMAT), "pFrameFormat")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamColorSpace", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(D3D11_VIDEO_PROCESSOR_COLOR_SPACE), "pColorSpace")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamOutputRate", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(D3D11_VIDEO_PROCESSOR_OUTPUT_RATE), "pOutputRate"), Out(Pointer(BOOL), "pRepeatFrame"), Out(Pointer(DXGI_RATIONAL), "pCustomRate")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamSourceRect", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(BOOL), "pEnabled"), Out(Pointer(RECT), "pRect")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamDestRect", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(BOOL), "pEnabled"), Out(Pointer(RECT), "pRect")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamAlpha", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(BOOL), "pEnabled"), Out(Pointer(FLOAT), "pAlpha")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamPalette", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (UINT, "Count"), Out(Array(UINT, "Count"), "pEntries")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamPixelAspectRatio", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(BOOL), "pEnabled"), Out(Pointer(DXGI_RATIONAL), "pSourceAspectRatio"), Out(Pointer(DXGI_RATIONAL), "pDestinationAspectRatio")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamLumaKey", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(BOOL), "pEnabled"), Out(Pointer(FLOAT), "pLower"), Out(Pointer(FLOAT), "pUpper")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamStereoFormat", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(BOOL), "pEnable"), Out(Pointer(D3D11_VIDEO_PROCESSOR_STEREO_FORMAT), "pFormat"), Out(Pointer(BOOL), "pLeftViewFrame0"), Out(Pointer(BOOL), "pBaseViewFrame0"), Out(Pointer(D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE), "pFlipMode"), Out(Pointer(Int), "MonoOffset")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamAutoProcessingMode", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(BOOL), "pEnabled")], sideeffects=False),
    StdMethod(Void, "VideoProcessorGetStreamFilter", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (D3D11_VIDEO_PROCESSOR_FILTER, "Filter"), Out(Pointer(BOOL), "pEnabled"), Out(Pointer(Int), "pLevel")], sideeffects=False),
    StdMethod(HRESULT, "VideoProcessorGetStreamExtension", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (Pointer(Const(GUID)), "pExtensionGuid"), (UINT, "DataSize"), Out(OpaqueBlob(Void, "DataSize"), "pData")], sideeffects=False), # FIXME
    StdMethod(HRESULT, "VideoProcessorBlt", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (ObjPointer(ID3D11VideoProcessorOutputView), "pView"), (UINT, "OutputFrame"), (UINT, "StreamCount"), (Array(Const(D3D11_VIDEO_PROCESSOR_STREAM), "StreamCount"), "pStreams")]),
    StdMethod(HRESULT, "NegotiateCryptoSessionKeyExchange", [(ObjPointer(ID3D11CryptoSession), "pCryptoSession"), (UINT, "DataSize"), Out(OpaqueBlob(Void, "DataSize"), "pData")], sideeffects=False), # FIXME
    StdMethod(Void, "EncryptionBlt", [(ObjPointer(ID3D11CryptoSession), "pCryptoSession"), (ObjPointer(ID3D11Texture2D), "pSrcSurface"), (ObjPointer(ID3D11Texture2D), "pDstSurface"), (UINT, "IVSize"), Out(OpaqueBlob(Void, "IVSize"), "pIV")], sideeffects=False), # FIXME
    StdMethod(Void, "DecryptionBlt", [(ObjPointer(ID3D11CryptoSession), "pCryptoSession"), (ObjPointer(ID3D11Texture2D), "pSrcSurface"), (ObjPointer(ID3D11Texture2D), "pDstSurface"), (Pointer(D3D11_ENCRYPTED_BLOCK_INFO), "pEncryptedBlockInfo"), (UINT, "ContentKeySize"), (Blob(Const(Void), "ContentKeySize"), "pContentKey"), (UINT, "IVSize"), Out(OpaqueBlob(Void, "IVSize"), "pIV")], sideeffects=False), # FIXME
    StdMethod(Void, "StartSessionKeyRefresh", [(ObjPointer(ID3D11CryptoSession), "pCryptoSession"), (UINT, "RandomNumberSize"), Out(OpaqueBlob(Void, "RandomNumberSize"), "pRandomNumber")], sideeffects=False), # FIXME
    StdMethod(Void, "FinishSessionKeyRefresh", [(ObjPointer(ID3D11CryptoSession), "pCryptoSession")]),
    StdMethod(HRESULT, "GetEncryptionBltKey", [(ObjPointer(ID3D11CryptoSession), "pCryptoSession"), (UINT, "KeySize"), Out(OpaqueBlob(Void, "KeySize"), "pReadbackKey")], sideeffects=False), # FIXME
    StdMethod(HRESULT, "NegotiateAuthenticatedChannelKeyExchange", [(ObjPointer(ID3D11AuthenticatedChannel), "pChannel"), (UINT, "DataSize"), Out(OpaqueBlob(Void, "DataSize"), "pData")], sideeffects=False), # FIXME
    StdMethod(HRESULT, "QueryAuthenticatedChannel", [(ObjPointer(ID3D11AuthenticatedChannel), "pChannel"), (UINT, "InputSize"), (Blob(Const(Void), "InputSize"), "pInput"), (UINT, "OutputSize"), Out(OpaqueBlob(Void, "OutputSize"), "pOutput")], sideeffects=False), # FIXME
    StdMethod(HRESULT, "ConfigureAuthenticatedChannel", [(ObjPointer(ID3D11AuthenticatedChannel), "pChannel"), (UINT, "InputSize"), (Blob(Const(Void), "InputSize"), "pInput"), Out(Pointer(D3D11_AUTHENTICATED_CONFIGURE_OUTPUT), "pOutput")]),
    StdMethod(Void, "VideoProcessorSetStreamRotation", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), (BOOL, "Enable"), (D3D11_VIDEO_PROCESSOR_ROTATION, "Rotation")]),
    StdMethod(Void, "VideoProcessorGetStreamRotation", [(ObjPointer(ID3D11VideoProcessor), "pVideoProcessor"), (UINT, "StreamIndex"), Out(Pointer(BOOL), "pEnable"), Out(Pointer(D3D11_VIDEO_PROCESSOR_ROTATION), "pRotation")], sideeffects=False),
]

ID3D11VideoDevice = Interface("ID3D11VideoDevice", IUnknown)
ID3D11VideoDevice.methods += [
    StdMethod(HRESULT, "CreateVideoDecoder", [(Pointer(Const(D3D11_VIDEO_DECODER_DESC)), "pVideoDesc"), (Pointer(Const(D3D11_VIDEO_DECODER_CONFIG)), "pConfig"), Out(Pointer(ObjPointer(ID3D11VideoDecoder)), "ppDecoder")]),
    StdMethod(HRESULT, "CreateVideoProcessor", [(ObjPointer(ID3D11VideoProcessorEnumerator), "pEnum"), (UINT, "RateConversionIndex"), Out(Pointer(ObjPointer(ID3D11VideoProcessor)), "ppVideoProcessor")]),
    StdMethod(HRESULT, "CreateAuthenticatedChannel", [(D3D11_AUTHENTICATED_CHANNEL_TYPE, "ChannelType"), Out(Pointer(ObjPointer(ID3D11AuthenticatedChannel)), "ppAuthenticatedChannel")]),
    StdMethod(HRESULT, "CreateCryptoSession", [(Pointer(Const(GUID)), "pCryptoType"), (Pointer(Const(GUID)), "pDecoderProfile"), (Pointer(Const(GUID)), "pKeyExchangeType"), Out(Pointer(ObjPointer(ID3D11CryptoSession)), "ppCryptoSession")]),
    StdMethod(HRESULT, "CreateVideoDecoderOutputView", [(ObjPointer(ID3D11Resource), "pResource"), (Pointer(Const(D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC)), "pDesc"), Out(Pointer(ObjPointer(ID3D11VideoDecoderOutputView)), "ppVDOVView")]),
    StdMethod(HRESULT, "CreateVideoProcessorInputView", [(ObjPointer(ID3D11Resource), "pResource"), (ObjPointer(ID3D11VideoProcessorEnumerator), "pEnum"), (Pointer(Const(D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC)), "pDesc"), Out(Pointer(ObjPointer(ID3D11VideoProcessorInputView)), "ppVPIView")]),
    StdMethod(HRESULT, "CreateVideoProcessorOutputView", [(ObjPointer(ID3D11Resource), "pResource"), (ObjPointer(ID3D11VideoProcessorEnumerator), "pEnum"), (Pointer(Const(D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC)), "pDesc"), Out(Pointer(ObjPointer(ID3D11VideoProcessorOutputView)), "ppVPOView")]),
    StdMethod(HRESULT, "CreateVideoProcessorEnumerator", [(Pointer(Const(D3D11_VIDEO_PROCESSOR_CONTENT_DESC)), "pDesc"), Out(Pointer(ObjPointer(ID3D11VideoProcessorEnumerator)), "ppEnum")]),
    StdMethod(UINT, "GetVideoDecoderProfileCount", [], sideeffects=False),
    StdMethod(HRESULT, "GetVideoDecoderProfile", [(UINT, "Index"), Out(Pointer(GUID), "pDecoderProfile")], sideeffects=False),
    StdMethod(HRESULT, "CheckVideoDecoderFormat", [(Pointer(Const(GUID)), "pDecoderProfile"), (DXGI_FORMAT, "Format"), Out(Pointer(BOOL), "pSupported")], sideeffects=False),
    StdMethod(HRESULT, "GetVideoDecoderConfigCount", [(Pointer(Const(D3D11_VIDEO_DECODER_DESC)), "pDesc"), Out(Pointer(UINT), "pCount")]),
    StdMethod(HRESULT, "GetVideoDecoderConfig", [(Pointer(Const(D3D11_VIDEO_DECODER_DESC)), "pDesc"), (UINT, "Index"), Out(Pointer(D3D11_VIDEO_DECODER_CONFIG), "pConfig")], sideeffects=False),
    StdMethod(HRESULT, "GetContentProtectionCaps", [(Pointer(Const(GUID)), "pCryptoType"), (Pointer(Const(GUID)), "pDecoderProfile"), Out(Pointer(D3D11_VIDEO_CONTENT_PROTECTION_CAPS), "pCaps")], sideeffects=False),
    StdMethod(HRESULT, "CheckCryptoKeyExchange", [(Pointer(Const(GUID)), "pCryptoType"), (Pointer(Const(GUID)), "pDecoderProfile"), (UINT, "Index"), Out(Pointer(GUID), "pKeyExchangeType")]),
    StdMethod(HRESULT, "SetPrivateData", [(REFGUID, "guid"), (UINT, "DataSize"), (OpaqueBlob(Const(Void), "DataSize"), "pData")]),
    StdMethod(HRESULT, "SetPrivateDataInterface", [(REFGUID, "guid"), (OpaquePointer(Const(IUnknown)), "pData")], sideeffects=False),
]

d3d11.addInterfaces([
    ID3D11VideoContext,
    ID3D11VideoDevice,
])



#
# D3D11.1
#

D3D_MIN_PRECISION = Enum("D3D_MIN_PRECISION", [
    "D3D_MIN_PRECISION_DEFAULT",
    "D3D_MIN_PRECISION_FLOAT_16",
    "D3D_MIN_PRECISION_FLOAT_2_8",
    "D3D_MIN_PRECISION_RESERVED",
    "D3D_MIN_PRECISION_SINT_16",
    "D3D_MIN_PRECISION_UINT_16",
    "D3D_MIN_PRECISION_ANY_16",
    "D3D_MIN_PRECISION_ANY_10",
])

D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK = Struct('D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK', [
    (UINT, 'ClearSize'),
    (UINT, 'EncryptedSize'),
])

D3D11_VIDEO_DECODER_BUFFER_DESC1 = Struct('D3D11_VIDEO_DECODER_BUFFER_DESC1', [
    (D3D11_VIDEO_DECODER_BUFFER_TYPE, 'BufferType'),
    (UINT, 'DataOffset'),
    (UINT, 'DataSize'),
    (Blob(Void, "{self}.IVSize"), "pIV"),
    (UINT, 'IVSize'),
    (Pointer(D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK), 'pSubSampleMappingBlock'),
    (UINT, 'SubSampleMappingCount'),
])

D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION = Struct('D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION', [
    (Pointer(ID3D11CryptoSession), 'pCryptoSession'),
    (UINT, 'BlobSize'),
    (Blob(Void, '{self}.BlobSize'), 'pBlob'),
    (Pointer(GUID), 'pKeyInfoId'),
    (UINT, 'PrivateDataSize'),
    (Blob(Void, '{self}.PrivateDataSize'), 'pPrivateData'),
])

D3D11_VIDEO_DECODER_CAPS = Enum('D3D11_VIDEO_DECODER_CAPS', [
    'D3D11_VIDEO_DECODER_CAPS_DOWNSAMPLE',
    'D3D11_VIDEO_DECODER_CAPS_NON_REAL_TIME',
    'D3D11_VIDEO_DECODER_CAPS_DOWNSAMPLE_DYNAMIC',
    'D3D11_VIDEO_DECODER_CAPS_DOWNSAMPLE_REQUIRED',
    'D3D11_VIDEO_DECODER_CAPS_UNSUPPORTED',
])

D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS = Enum('D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS', [
    'D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINT_MULTIPLANE_OVERLAY_ROTATION',
    'D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINT_MULTIPLANE_OVERLAY_RESIZE',
    'D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINT_MULTIPLANE_OVERLAY_COLOR_SPACE_CONVERSION',
    'D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINT_TRIPLE_BUFFER_OUTPUT',
])

D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT = Struct('D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT', [
    (BOOL, 'Enable'),
    (UINT, 'Width'),
    (UINT, 'Height'),
    (DXGI_FORMAT, 'Format'),
])

D3D11_CRYPTO_SESSION_STATUS = Enum('D3D11_CRYPTO_SESSION_STATUS', [
    'D3D11_CRYPTO_SESSION_STATUS_OK',
    'D3D11_CRYPTO_SESSION_STATUS_KEY_LOST',
    'D3D11_CRYPTO_SESSION_STATUS_KEY_AND_CONTENT_LOST',
])

D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA = Struct('D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA', [
    (UINT, 'PrivateDataSize'),
    (UINT, 'HWProtectionDataSize'),
    (Array(BYTE, 4), 'pbInput'),
])

D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA = Struct('D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA', [
    (UINT, 'PrivateDataSize'),
    (UINT, 'MaxHWProtectionDataSize'),
    (UINT, 'HWProtectionDataSize'),
    (UINT64, 'TransportTime'),
    (UINT64, 'ExecutionTime'),
    (Array(BYTE, 4), 'pbOutput'),
])

D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA = Struct('D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA', [
    (UINT, 'HWProtectionFunctionID'),
    (Pointer(D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA), 'pInputData'),
    (Pointer(D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA), 'pOutputData'),
    (HRESULT, 'Status'),
])

D3D11_VIDEO_SAMPLE_DESC = Struct('D3D11_VIDEO_SAMPLE_DESC', [
    (UINT, 'Width'),
    (UINT, 'Height'),
    (DXGI_FORMAT, 'Format'),
    (DXGI_COLOR_SPACE_TYPE, 'ColorSpace'),
])

ID3D11BlendState1 = Interface("ID3D11BlendState1", ID3D11BlendState)
ID3D11RasterizerState1 = Interface("ID3D11RasterizerState1", ID3D11RasterizerState)
ID3DDeviceContextState = Interface("ID3DDeviceContextState", ID3D11DeviceChild)
ID3D11DeviceContext1 = Interface("ID3D11DeviceContext1", ID3D11DeviceContext)
ID3D11VideoContext1 = Interface('ID3D11VideoContext1', ID3D11VideoContext)
ID3D11VideoDevice1 = Interface('ID3D11VideoDevice1', ID3D11VideoDevice)
ID3D11VideoProcessorEnumerator1 = Interface('ID3D11VideoProcessorEnumerator1', ID3D11VideoProcessorEnumerator)
ID3D11Device1 = Interface("ID3D11Device1", ID3D11Device)
ID3DUserDefinedAnnotation = Interface("ID3DUserDefinedAnnotation", IUnknown)

D3D11_COPY_FLAGS = Flags(UINT, [
    "D3D11_COPY_NO_OVERWRITE",
    "D3D11_COPY_DISCARD",
])

D3D11_LOGIC_OP = Enum("D3D11_LOGIC_OP", [
    "D3D11_LOGIC_OP_CLEAR",
    "D3D11_LOGIC_OP_SET",
    "D3D11_LOGIC_OP_COPY",
    "D3D11_LOGIC_OP_COPY_INVERTED",
    "D3D11_LOGIC_OP_NOOP",
    "D3D11_LOGIC_OP_INVERT",
    "D3D11_LOGIC_OP_AND",
    "D3D11_LOGIC_OP_NAND",
    "D3D11_LOGIC_OP_OR",
    "D3D11_LOGIC_OP_NOR",
    "D3D11_LOGIC_OP_XOR",
    "D3D11_LOGIC_OP_EQUIV",
    "D3D11_LOGIC_OP_AND_REVERSE",
    "D3D11_LOGIC_OP_AND_INVERTED",
    "D3D11_LOGIC_OP_OR_REVERSE",
    "D3D11_LOGIC_OP_OR_INVERTED",
])

D3D11_RENDER_TARGET_BLEND_DESC1 = Struct("D3D11_RENDER_TARGET_BLEND_DESC1", [
    (BOOL, "BlendEnable"),
    (BOOL, "LogicOpEnable"),
    (D3D11_BLEND, "SrcBlend"),
    (D3D11_BLEND, "DestBlend"),
    (D3D11_BLEND_OP, "BlendOp"),
    (D3D11_BLEND, "SrcBlendAlpha"),
    (D3D11_BLEND, "DestBlendAlpha"),
    (D3D11_BLEND_OP, "BlendOpAlpha"),
    (D3D11_LOGIC_OP, "LogicOp"),
    (UINT8, "RenderTargetWriteMask"),
])

D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT = 8

D3D11_BLEND_DESC1 = Struct("D3D11_BLEND_DESC1", [
    (BOOL, "AlphaToCoverageEnable"),
    (BOOL, "IndependentBlendEnable"),
    (Array(D3D11_RENDER_TARGET_BLEND_DESC1, D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT), "RenderTarget"),
])

ID3D11BlendState1.methods += [
    StdMethod(Void, "GetDesc1", [Out(Pointer(D3D11_BLEND_DESC1), "pDesc")], sideeffects=False),
]

D3D11_RASTERIZER_DESC1 = Struct("D3D11_RASTERIZER_DESC1", [
    (D3D11_FILL_MODE, "FillMode"),
    (D3D11_CULL_MODE, "CullMode"),
    (BOOL, "FrontCounterClockwise"),
    (INT, "DepthBias"),
    (FLOAT, "DepthBiasClamp"),
    (FLOAT, "SlopeScaledDepthBias"),
    (BOOL, "DepthClipEnable"),
    (BOOL, "ScissorEnable"),
    (BOOL, "MultisampleEnable"),
    (BOOL, "AntialiasedLineEnable"),
    (UINT, "ForcedSampleCount"),
])

ID3D11RasterizerState1.methods += [
    StdMethod(Void, "GetDesc1", [Out(Pointer(D3D11_RASTERIZER_DESC1), "pDesc")], sideeffects=False),
]

D3D11_1_CREATE_DEVICE_CONTEXT_STATE_FLAG = Flags(UINT, [
    "D3D11_1_CREATE_DEVICE_CONTEXT_STATE_SINGLETHREADED",
])

ID3D11DeviceContext1.methods += [
    StdMethod(Void, "CopySubresourceRegion1", [(ObjPointer(ID3D11Resource), "pDstResource"), (UINT, "DstSubresource"), (UINT, "DstX"), (UINT, "DstY"), (UINT, "DstZ"), (ObjPointer(ID3D11Resource), "pSrcResource"), (UINT, "SrcSubresource"), (Pointer(Const(D3D11_BOX)), "pSrcBox"), (D3D11_COPY_FLAGS, "CopyFlags")]),
    StdMethod(Void, "UpdateSubresource1", [(ObjPointer(ID3D11Resource), "pDstResource"), (UINT, "DstSubresource"), (Pointer(Const(D3D11_BOX)), "pDstBox"), (Blob(Const(Void), "_calcSubresourceSize(pDstResource, DstSubresource, pDstBox, SrcRowPitch, SrcDepthPitch)"), "pSrcData"), (UINT, "SrcRowPitch"), (UINT, "SrcDepthPitch"), (D3D11_COPY_FLAGS, "CopyFlags")]),
    StdMethod(Void, "DiscardResource", [(ObjPointer(ID3D11Resource), "pResource")]),
    StdMethod(Void, "DiscardView", [(ObjPointer(ID3D11View), "pResourceView")]),
    StdMethod(Void, "DiscardView1", [(ObjPointer(ID3D11View), "pResourceView"), (Array(Const(D3D11_RECT), "NumRects"), "pRect"), (UINT, "NumRects")]),
    StdMethod(Void, "VSSetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers"), (Array(Const(UINT), "NumBuffers"), "pFirstConstant"), (Array(Const(UINT), "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "HSSetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers"), (Array(Const(UINT), "NumBuffers"), "pFirstConstant"), (Array(Const(UINT), "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "DSSetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers"), (Array(Const(UINT), "NumBuffers"), "pFirstConstant"), (Array(Const(UINT), "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "GSSetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers"), (Array(Const(UINT), "NumBuffers"), "pFirstConstant"), (Array(Const(UINT), "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "PSSetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers"), (Array(Const(UINT), "NumBuffers"), "pFirstConstant"), (Array(Const(UINT), "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "CSSetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), (Array(Const(ObjPointer(ID3D11Buffer)), "NumBuffers"), "ppConstantBuffers"), (Array(Const(UINT), "NumBuffers"), "pFirstConstant"), (Array(Const(UINT), "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "VSGetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers"), Out(Array(UINT, "NumBuffers"), "pFirstConstant"), Out(Array(UINT, "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "HSGetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers"), Out(Array(UINT, "NumBuffers"), "pFirstConstant"), Out(Array(UINT, "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "DSGetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers"), Out(Array(UINT, "NumBuffers"), "pFirstConstant"), Out(Array(UINT, "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "GSGetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers"), Out(Array(UINT, "NumBuffers"), "pFirstConstant"), Out(Array(UINT, "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "PSGetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers"), Out(Array(UINT, "NumBuffers"), "pFirstConstant"), Out(Array(UINT, "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "CSGetConstantBuffers1", [(UINT, "StartSlot"), (UINT, "NumBuffers"), Out(Array(ObjPointer(ID3D11Buffer), "NumBuffers"), "ppConstantBuffers"), Out(Array(UINT, "NumBuffers"), "pFirstConstant"), Out(Array(UINT, "NumBuffers"), "pNumConstants")]),
    StdMethod(Void, "SwapDeviceContextState", [(ObjPointer(ID3DDeviceContextState), "pState"), Out(Pointer(ObjPointer(ID3DDeviceContextState)), "ppPreviousState")]),
    StdMethod(Void, "ClearView", [(ObjPointer(ID3D11View), "pView"), (Array(Const(FLOAT), 4), "Color"), (Array(Const(D3D11_RECT), "NumRects"), "pRect"), (UINT, "NumRects")]),
]

ID3D11VideoContext1.methods += [
    StdMethod(HRESULT, 'SubmitDecoderBuffers1', [(ObjPointer(ID3D11VideoDecoder), 'pDecoder'), (UINT, 'NumBuffers'), (Array(Const(D3D11_VIDEO_DECODER_BUFFER_DESC1), 'NumBuffers'), 'pBufferDesc')]),
    StdMethod(HRESULT, 'GetDataForNewHardwareKey', [(ObjPointer(ID3D11CryptoSession), 'pCryptoSession'), (UINT, 'PrivateInputSize'), (Blob(Const(Void), 'PrivateInputSize'), 'pPrivatInputData'), Out(Pointer(UINT64), 'pPrivateOutputData')]),
    StdMethod(HRESULT, 'CheckCryptoSessionStatus', [(ObjPointer(ID3D11CryptoSession), 'pCryptoSession'), Out(Pointer(D3D11_CRYPTO_SESSION_STATUS), 'pStatus')]),
    StdMethod(HRESULT, 'DecoderEnableDownsampling', [(ObjPointer(ID3D11VideoDecoder), 'pDecoder'), (DXGI_COLOR_SPACE_TYPE, 'InputColorSpace'), (Pointer(Const(D3D11_VIDEO_SAMPLE_DESC)), 'pOutputDesc'), (UINT, 'ReferenceFrameCount')]),
    StdMethod(HRESULT, 'DecoderUpdateDownsampling', [(ObjPointer(ID3D11VideoDecoder), 'pDecoder'), (Pointer(Const(D3D11_VIDEO_SAMPLE_DESC)), 'pOutputDesc')]),
    StdMethod(Void, 'VideoProcessorSetOutputColorSpace1', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (DXGI_COLOR_SPACE_TYPE, 'ColorSpace')]),
    StdMethod(Void, 'VideoProcessorSetOutputShaderUsage', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (BOOL, 'ShaderUsage')]),
    StdMethod(Void, 'VideoProcessorGetOutputColorSpace1', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), Out(Pointer(DXGI_COLOR_SPACE_TYPE), 'pColorSpace')], sideeffects=False),
    StdMethod(Void, 'VideoProcessorGetOutputShaderUsage', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), Out(Pointer(BOOL), 'pShaderUsage')], sideeffects=False),
    StdMethod(Void, 'VideoProcessorSetStreamColorSpace1', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (UINT, 'StreamIndex'), (DXGI_COLOR_SPACE_TYPE, 'ColorSpace')]),
    StdMethod(Void, 'VideoProcessorSetStreamMirror', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (UINT, 'StreamIndex'), (BOOL, 'Enable'), (BOOL, 'FlipHorizontal'), (BOOL, 'FlipVertical')]),
    StdMethod(Void, 'VideoProcessorGetStreamColorSpace1', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (UINT, 'StreamIndex'), Out(Pointer(DXGI_COLOR_SPACE_TYPE), 'pColorSpace')], sideeffects=False),
    StdMethod(Void, 'VideoProcessorGetStreamMirror', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (UINT, 'StreamIndex'), Out(Pointer(BOOL), 'pEnable'), Out(Pointer(BOOL), 'pFlipHorizontal'), Out(Pointer(BOOL), 'pFlipVertical')]),
    StdMethod(HRESULT, 'VideoProcessorGetBehaviorHints', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (UINT, 'OutputWidth'), (UINT, 'OutputHeight'), (DXGI_FORMAT, 'OutputFormat'), (UINT, 'StreamCount'), (Pointer(Const(D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT)), 'pStreams'), Out(Pointer(UINT), 'pBehaviorHints')], sideeffects=False),
]

ID3D11VideoDevice1.methods += [
    StdMethod(HRESULT, 'GetCryptoSessionPrivateDataSize', [(Pointer(Const(GUID)), 'pCryptoType'), (Pointer(Const(GUID)), 'pDecoderProfile'), (Pointer(Const(GUID)), 'pKeyExchangeType'), Out(Pointer(UINT), 'pPrivateInputSize'), Out(Pointer(UINT), 'pPrivateOutputSize')], sideeffects=False),
    StdMethod(HRESULT, 'GetVideoDecoderCaps', [(Pointer(Const(GUID)), 'pDecoderProfile'), (UINT, 'SampleWidth'), (UINT, 'SampleHeight'), (Pointer(Const(DXGI_RATIONAL)), 'pFrameRate'), (UINT, 'BitRate'), (Pointer(Const(GUID)), 'pCryptoType'), Out(Pointer(UINT), 'pDecoderCaps')], sideeffects=False),
    StdMethod(HRESULT, 'CheckVideoDecoderDownsampling', [(Pointer(Const(D3D11_VIDEO_DECODER_DESC)), 'pInputDesc'), (DXGI_COLOR_SPACE_TYPE, 'InputColorSpace'), (Pointer(Const(D3D11_VIDEO_DECODER_CONFIG)), 'pInputConfig'), (Pointer(Const(DXGI_RATIONAL)), 'pFrameRate'), (Pointer(Const(D3D11_VIDEO_SAMPLE_DESC)), 'pOutputDesc'), Out(Pointer(BOOL), 'pSupported'), Out(Pointer(BOOL), 'pRealTimeHint')], sideeffects=False),
    StdMethod(HRESULT, 'RecommendVideoDecoderDownsampleParameters', [(Pointer(Const(D3D11_VIDEO_DECODER_DESC)), 'pInputDesc'), (DXGI_COLOR_SPACE_TYPE, 'InputColorSpace'), (Pointer(Const(D3D11_VIDEO_DECODER_CONFIG)), 'pInputConfig'), (Pointer(Const(DXGI_RATIONAL)), 'pFrameRate'), Out(Pointer(D3D11_VIDEO_SAMPLE_DESC), 'pRecommendedOutputDesc')], sideeffects=False),
]

ID3D11VideoProcessorEnumerator1.methods += [
    StdMethod(HRESULT, 'CheckVideoProcessorFormatConversion', [(DXGI_FORMAT, 'InputFormat'), (DXGI_COLOR_SPACE_TYPE, 'InputColorSpace'), (DXGI_FORMAT, 'OutputFormat'), (DXGI_COLOR_SPACE_TYPE, 'OutputColorSpace'), Out(Pointer(BOOL), 'pSupported')], sideeffects=False),
]

ID3D11Device1.methods += [
    StdMethod(Void, "GetImmediateContext1", [Out(Pointer(ObjPointer(ID3D11DeviceContext1)), "ppImmediateContext")]),
    StdMethod(HRESULT, "CreateDeferredContext1", [(UINT, "ContextFlags"), Out(Pointer(ObjPointer(ID3D11DeviceContext1)), "ppDeferredContext")]),
    StdMethod(HRESULT, "CreateBlendState1", [(Pointer(Const(D3D11_BLEND_DESC1)), "pBlendStateDesc"), Out(Pointer(ObjPointer(ID3D11BlendState1)), "ppBlendState")]),
    StdMethod(HRESULT, "CreateRasterizerState1", [(Pointer(Const(D3D11_RASTERIZER_DESC1)), "pRasterizerDesc"), Out(Pointer(ObjPointer(ID3D11RasterizerState1)), "ppRasterizerState")]),
    StdMethod(HRESULT, "CreateDeviceContextState", [(D3D11_1_CREATE_DEVICE_CONTEXT_STATE_FLAG, "Flags"), (Array(Const(D3D_FEATURE_LEVEL), "FeatureLevels"), "pFeatureLevels"), (UINT, "FeatureLevels"), (UINT, "SDKVersion"), (REFIID, "EmulatedInterface"), Out(Pointer(D3D_FEATURE_LEVEL), "pChosenFeatureLevel"), Out(Pointer(ObjPointer(ID3DDeviceContextState)), "ppContextState")]),
    StdMethod(HRESULT, "OpenSharedResource1", [(HANDLE, "hResource"), (REFIID, "ReturnedInterface"), Out(Pointer(ObjPointer(Void)), "ppResource")]),
    StdMethod(HRESULT, "OpenSharedResourceByName", [(LPCWSTR, "lpName"), (DXGI_SHARED_RESOURCE_FLAG, "dwDesiredAccess"), (REFIID, "ReturnedInterface"), Out(Pointer(ObjPointer(Void)), "ppResource")]),
]

ID3DUserDefinedAnnotation.methods += [
    StdMethod(INT, "BeginEvent", [(LPCWSTR, "Name")], sideeffects=False),
    StdMethod(INT, "EndEvent", [], sideeffects=False),
    StdMethod(Void, "SetMarker", [(LPCWSTR, "Name")], sideeffects=False),
    StdMethod(BOOL, "GetStatus", [], sideeffects=False),
]

ID3D11DebugTest = Interface('ID3D11DebugTest', IUnknown)
ID3D11DebugTest.methods += [
    StdMethod(Void, 'PreventFurtherExecutionOnError', [(BOOL, 'Enable')]),
    StdMethod(Void, 'VSSetConstantBuffer14', [(ObjPointer(ID3D11Buffer), 'pCB14')]),
    StdMethod(Void, 'HSSetConstantBuffer14', [(ObjPointer(ID3D11Buffer), 'pCB14')]),
    StdMethod(Void, 'DSSetConstantBuffer14', [(ObjPointer(ID3D11Buffer), 'pCB14')]),
    StdMethod(Void, 'GSSetConstantBuffer14', [(ObjPointer(ID3D11Buffer), 'pCB14')]),
    StdMethod(Void, 'PSSetConstantBuffer14', [(ObjPointer(ID3D11Buffer), 'pCB14')]),
    StdMethod(Void, 'CSSetConstantBuffer14', [(ObjPointer(ID3D11Buffer), 'pCB14')]),
]

d3d11.addInterfaces([
    ID3D11Device1,
    ID3D11VideoProcessorEnumerator1,
    ID3DUserDefinedAnnotation,
    ID3D11DebugTest,
])



#
# D3D11.2
#

D3D11_TILED_RESOURCE_COORDINATE = Struct("D3D11_TILED_RESOURCE_COORDINATE", [
    (UINT, "X"),
    (UINT, "Y"),
    (UINT, "Z"),
    (UINT, "Subresource"),
])

D3D11_TILE_REGION_SIZE = Struct("D3D11_TILE_REGION_SIZE", [
    (UINT, "NumTiles"),
    (BOOL, "bUseBox"),
    (UINT, "Width"),
    (UINT16, "Height"),
    (UINT16, "Depth"),
])

D3D11_TILE_MAPPING_FLAG = Flags(UINT, [
    "D3D11_TILE_MAPPING_NO_OVERWRITE",
])

D3D11_TILE_RANGE_FLAG = Flags(UINT, [
    "D3D11_TILE_RANGE_NULL",
    "D3D11_TILE_RANGE_SKIP",
    "D3D11_TILE_RANGE_REUSE_SINGLE_TILE",
])

D3D11_SUBRESOURCE_TILING = Struct("D3D11_SUBRESOURCE_TILING", [
    (UINT, "WidthInTiles"),
    (UINT16, "HeightInTiles"),
    (UINT16, "DepthInTiles"),
    (FakeEnum(UINT, ["D3D11_PACKED_TILE"]), "StartTileIndexInOverallResource"),
])

D3D11_TILE_SHAPE = Struct("D3D11_TILE_SHAPE", [
    (UINT, "WidthInTexels"),
    (UINT, "HeightInTexels"),
    (UINT, "DepthInTexels"),
])

D3D11_PACKED_MIP_DESC = Struct("D3D11_PACKED_MIP_DESC", [
    (UINT8, "NumStandardMips"),
    (UINT8, "NumPackedMips"),
    (UINT, "NumTilesForPackedMips"),
    (UINT, "StartTileIndexInOverallResource"),
])

D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_FLAG = Flags(UINT, [
    "D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_TILED_RESOURCE",
])

D3D11_TILE_COPY_FLAG = Flags(UINT, [
    "D3D11_TILE_COPY_NO_OVERWRITE",
    "D3D11_TILE_COPY_LINEAR_BUFFER_TO_SWIZZLED_TILED_RESOURCE",
    "D3D11_TILE_COPY_SWIZZLED_TILED_RESOURCE_TO_LINEAR_BUFFER",
])

ID3D11DeviceContext2 = Interface("ID3D11DeviceContext2", ID3D11DeviceContext1)
ID3D11DeviceContext2.methods += [
    StdMethod(HRESULT, "UpdateTileMappings", [(ObjPointer(ID3D11Resource), "pTiledResource"), (UINT, "NumTiledResourceRegions"), (Array(Const(D3D11_TILED_RESOURCE_COORDINATE), "NumTiledResourceRegions"), "pTiledResourceRegionStartCoordinates"), (Array(Const(D3D11_TILE_REGION_SIZE), "NumTiledResourceRegions"), "pTiledResourceRegionSizes"), (ObjPointer(ID3D11Buffer), "pTilePool"), (UINT, "NumRanges"), (Array(Const(D3D11_TILE_RANGE_FLAG), "NumRanges"), "pRangeFlags"), (Array(Const(UINT), "NumRanges"), "pTilePoolStartOffsets"), (Array(Const(UINT), "NumRanges"), "pRangeTileCounts"), (D3D11_TILE_MAPPING_FLAG, "Flags")]),
    StdMethod(HRESULT, "CopyTileMappings", [(ObjPointer(ID3D11Resource), "pDestTiledResource"), (Pointer(Const(D3D11_TILED_RESOURCE_COORDINATE)), "pDestRegionStartCoordinate"), (ObjPointer(ID3D11Resource), "pSourceTiledResource"), (Pointer(Const(D3D11_TILED_RESOURCE_COORDINATE)), "pSourceRegionStartCoordinate"), (Pointer(Const(D3D11_TILE_REGION_SIZE)), "pTileRegionSize"), (D3D11_TILE_MAPPING_FLAG, "Flags")]),
    StdMethod(Void, "CopyTiles", [(ObjPointer(ID3D11Resource), "pTiledResource"), (Pointer(Const(D3D11_TILED_RESOURCE_COORDINATE)), "pTileRegionStartCoordinate"), (Pointer(Const(D3D11_TILE_REGION_SIZE)), "pTileRegionSize"), (ObjPointer(ID3D11Buffer), "pBuffer"), (UINT64, "BufferStartOffsetInBytes"), (D3D11_TILE_COPY_FLAG, "Flags")]),
    StdMethod(Void, "UpdateTiles", [(ObjPointer(ID3D11Resource), "pDestTiledResource"), (Pointer(Const(D3D11_TILED_RESOURCE_COORDINATE)), "pDestTileRegionStartCoordinate"), (Pointer(Const(D3D11_TILE_REGION_SIZE)), "pDestTileRegionSize"), (OpaquePointer(Const(Void)), "pSourceTileData"), (D3D11_TILE_COPY_FLAG, "Flags")]), # FIXME
    StdMethod(HRESULT, "ResizeTilePool", [(ObjPointer(ID3D11Buffer), "pTilePool"), (UINT64, "NewSizeInBytes")]),
    StdMethod(Void, "TiledResourceBarrier", [(ObjPointer(ID3D11DeviceChild), "pTiledResourceOrViewAccessBeforeBarrier"), (ObjPointer(ID3D11DeviceChild), "pTiledResourceOrViewAccessAfterBarrier")]),
    StdMethod(BOOL, "IsAnnotationEnabled", [], sideeffects=False),
    StdMethod(Void, "SetMarkerInt", [(LPCWSTR, "pLabel"), (INT, "Data")]),
    StdMethod(Void, "BeginEventInt", [(LPCWSTR, "pLabel"), (INT, "Data")]),
    StdMethod(Void, "EndEvent", []),
]

ID3D11Device2 = Interface("ID3D11Device2", ID3D11Device1)
ID3D11Device2.methods += [
    StdMethod(Void, "GetImmediateContext2", [Out(Pointer(ObjPointer(ID3D11DeviceContext2)), "ppImmediateContext")]),
    StdMethod(HRESULT, "CreateDeferredContext2", [(UINT, "ContextFlags"), Out(Pointer(ObjPointer(ID3D11DeviceContext2)), "ppDeferredContext")]),
    StdMethod(Void, "GetResourceTiling", [(ObjPointer(ID3D11Resource), "pTiledResource"), Out(Pointer(UINT), "pNumTilesForEntireResource"), Out(Pointer(D3D11_PACKED_MIP_DESC), "pPackedMipDesc"), Out(Pointer(D3D11_TILE_SHAPE), "pStandardTileShapeForNonPackedMips"), Out(Pointer(UINT), "pNumSubresourceTilings"), (UINT, "FirstSubresourceTilingToGet"), Out(Pointer(D3D11_SUBRESOURCE_TILING), "pSubresourceTilingsForNonPackedMips")]),
    StdMethod(HRESULT, "CheckMultisampleQualityLevels1", [(DXGI_FORMAT, "Format"), (UINT, "SampleCount"), (D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_FLAG, "Flags"), Out(Pointer(UINT), "pNumQualityLevels")], sideeffects=False),
]

d3d11.addInterfaces([
    ID3D11Device2,
    ID3D11DeviceContext2,
])



#
# D3D11.3
#

D3D11_CONTEXT_TYPE = Enum("D3D11_CONTEXT_TYPE", [
    "D3D11_CONTEXT_TYPE_ALL",
    "D3D11_CONTEXT_TYPE_3D",
    "D3D11_CONTEXT_TYPE_COMPUTE",
    "D3D11_CONTEXT_TYPE_COPY",
    "D3D11_CONTEXT_TYPE_VIDEO",
])

D3D11_TEXTURE_LAYOUT = Enum("D3D11_TEXTURE_LAYOUT", [
    "D3D11_TEXTURE_LAYOUT_UNDEFINED",
    "D3D11_TEXTURE_LAYOUT_ROW_MAJOR",
    "D3D11_TEXTURE_LAYOUT_64K_STANDARD_SWIZZLE",
])

D3D11_TEXTURE2D_DESC1 = Struct("D3D11_TEXTURE2D_DESC1", [
    (UINT, "Width"),
    (UINT, "Height"),
    (UINT, "MipLevels"),
    (UINT, "ArraySize"),
    (DXGI_FORMAT, "Format"),
    (DXGI_SAMPLE_DESC, "SampleDesc"),
    (D3D11_USAGE, "Usage"),
    (D3D11_BIND_FLAG, "BindFlags"),
    (D3D11_CPU_ACCESS_FLAG, "CPUAccessFlags"),
    (D3D11_RESOURCE_MISC_FLAG, "MiscFlags"),
    (D3D11_TEXTURE_LAYOUT, "TextureLayout"),
])

ID3D11Texture2D1 = Interface("ID3D11Texture2D1", ID3D11Texture2D)
ID3D11Texture2D1.methods += [
    StdMethod(Void, "GetDesc1", [Out(Pointer(D3D11_TEXTURE2D_DESC1), "pDesc")], sideeffects=False),
]
D3D11_TEXTURE3D_DESC1 = Struct("D3D11_TEXTURE3D_DESC1", [
    (UINT, "Width"),
    (UINT, "Height"),
    (UINT, "Depth"),
    (UINT, "MipLevels"),
    (DXGI_FORMAT, "Format"),
    (D3D11_USAGE, "Usage"),
    (D3D11_BIND_FLAG, "BindFlags"),
    (D3D11_CPU_ACCESS_FLAG, "CPUAccessFlags"),
    (D3D11_RESOURCE_MISC_FLAG, "MiscFlags"),
    (D3D11_TEXTURE_LAYOUT, "TextureLayout"),
])

ID3D11Texture3D1 = Interface("ID3D11Texture3D1", ID3D11Texture3D)
ID3D11Texture3D1.methods += [
    StdMethod(Void, "GetDesc1", [Out(Pointer(D3D11_TEXTURE3D_DESC1), "pDesc")], sideeffects=False),
]

D3D11_CONSERVATIVE_RASTERIZATION_MODE = Enum("D3D11_CONSERVATIVE_RASTERIZATION_MODE", [
    "D3D11_CONSERVATIVE_RASTERIZATION_MODE_OFF",
    "D3D11_CONSERVATIVE_RASTERIZATION_MODE_ON",
])

D3D11_RASTERIZER_DESC2 = Struct("D3D11_RASTERIZER_DESC2", [
    (D3D11_FILL_MODE, "FillMode"),
    (D3D11_CULL_MODE, "CullMode"),
    (BOOL, "FrontCounterClockwise"),
    (INT, "DepthBias"),
    (FLOAT, "DepthBiasClamp"),
    (FLOAT, "SlopeScaledDepthBias"),
    (BOOL, "DepthClipEnable"),
    (BOOL, "ScissorEnable"),
    (BOOL, "MultisampleEnable"),
    (BOOL, "AntialiasedLineEnable"),
    (UINT, "ForcedSampleCount"),
    (D3D11_CONSERVATIVE_RASTERIZATION_MODE, "ConservativeRaster"),
])

ID3D11RasterizerState2 = Interface("ID3D11RasterizerState2", ID3D11RasterizerState1)
ID3D11RasterizerState2.methods += [
    StdMethod(Void, "GetDesc2", [Out(Pointer(D3D11_RASTERIZER_DESC2), "pDesc")], sideeffects=False),
]

D3D11_TEX2D_SRV1 = Struct("D3D11_TEX2D_SRV1", [
    (UINT, "MostDetailedMip"),
    (UINT, "MipLevels"),
    (UINT, "PlaneSlice"),
])

D3D11_TEX2D_ARRAY_SRV1 = Struct("D3D11_TEX2D_ARRAY_SRV1", [
    (UINT, "MostDetailedMip"),
    (UINT, "MipLevels"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
    (UINT, "PlaneSlice"),
])

D3D11_SHADER_RESOURCE_VIEW_DESC1 = Struct("D3D11_SHADER_RESOURCE_VIEW_DESC1", [
    (DXGI_FORMAT, "Format"),
    (D3D11_SRV_DIMENSION, "ViewDimension"),
    (Union("{self}.ViewDimension", [
        ("D3D11_SRV_DIMENSION_BUFFER", D3D11_BUFFER_SRV, "Buffer"),
        ("D3D11_SRV_DIMENSION_TEXTURE1D", D3D11_TEX1D_SRV, "Texture1D"),
        ("D3D11_SRV_DIMENSION_TEXTURE1DARRAY", D3D11_TEX1D_ARRAY_SRV, "Texture1DArray"),
        ("D3D11_SRV_DIMENSION_TEXTURE2D", D3D11_TEX2D_SRV1, "Texture2D"),
        ("D3D11_SRV_DIMENSION_TEXTURE2DARRAY", D3D11_TEX2D_ARRAY_SRV1, "Texture2DArray"),
        ("D3D11_SRV_DIMENSION_TEXTURE2DMS", D3D11_TEX2DMS_SRV, "Texture2DMS"),
        ("D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY", D3D11_TEX2DMS_ARRAY_SRV, "Texture2DMSArray"),
        ("D3D11_SRV_DIMENSION_TEXTURE3D", D3D11_TEX3D_SRV, "Texture3D"),
        ("D3D11_SRV_DIMENSION_TEXTURECUBE", D3D11_TEXCUBE_SRV, "TextureCube"),
        ("D3D11_SRV_DIMENSION_TEXTURECUBEARRAY", D3D11_TEXCUBE_ARRAY_SRV, "TextureCubeArray"),
        ("D3D11_SRV_DIMENSION_BUFFEREX", D3D11_BUFFEREX_SRV, "BufferEx"),
    ]), None),
])


ID3D11ShaderResourceView1 = Interface("ID3D11ShaderResourceView1", ID3D11ShaderResourceView)
ID3D11ShaderResourceView1.methods += [
    StdMethod(Void, "GetDesc1", [Out(Pointer(D3D11_SHADER_RESOURCE_VIEW_DESC1), "pDesc1")], sideeffects=False),
]

D3D11_TEX2D_RTV1 = Struct("D3D11_TEX2D_RTV1", [
    (UINT, "MipSlice"),
    (UINT, "PlaneSlice"),
])

D3D11_TEX2D_ARRAY_RTV1 = Struct("D3D11_TEX2D_ARRAY_RTV1", [
    (UINT, "MipSlice"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
    (UINT, "PlaneSlice"),
])

D3D11_RENDER_TARGET_VIEW_DESC1 = Struct("D3D11_RENDER_TARGET_VIEW_DESC1", [
    (DXGI_FORMAT, "Format"),
    (D3D11_RTV_DIMENSION, "ViewDimension"),
    (Union("{self}.ViewDimension", [
        ("D3D11_RTV_DIMENSION_BUFFER", D3D11_BUFFER_RTV, "Buffer"),
        ("D3D11_RTV_DIMENSION_TEXTURE1D", D3D11_TEX1D_RTV, "Texture1D"),
        ("D3D11_RTV_DIMENSION_TEXTURE1DARRAY", D3D11_TEX1D_ARRAY_RTV, "Texture1DArray"),
        ("D3D11_RTV_DIMENSION_TEXTURE2D", D3D11_TEX2D_RTV1, "Texture2D"),
        ("D3D11_RTV_DIMENSION_TEXTURE2DARRAY", D3D11_TEX2D_ARRAY_RTV1, "Texture2DArray"),
        ("D3D11_RTV_DIMENSION_TEXTURE2DMS", D3D11_TEX2DMS_RTV, "Texture2DMS"),
        ("D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY", D3D11_TEX2DMS_ARRAY_RTV, "Texture2DMSArray"),
        ("D3D11_RTV_DIMENSION_TEXTURE3D", D3D11_TEX3D_RTV, "Texture3D"),
    ]), None),
])

ID3D11RenderTargetView1 = Interface("ID3D11RenderTargetView1", ID3D11RenderTargetView)
ID3D11RenderTargetView1.methods += [
    StdMethod(Void, "GetDesc1", [Out(Pointer(D3D11_RENDER_TARGET_VIEW_DESC1), "pDesc1")], sideeffects=False),
]

D3D11_TEX2D_UAV1 = Struct("D3D11_TEX2D_UAV1", [
    (UINT, "MipSlice"),
    (UINT, "PlaneSlice"),
])

D3D11_TEX2D_ARRAY_UAV1 = Struct("D3D11_TEX2D_ARRAY_UAV1", [
    (UINT, "MipSlice"),
    (UINT, "FirstArraySlice"),
    (UINT, "ArraySize"),
    (UINT, "PlaneSlice"),
])

D3D11_UNORDERED_ACCESS_VIEW_DESC1 = Struct("D3D11_UNORDERED_ACCESS_VIEW_DESC1", [
    (DXGI_FORMAT, "Format"),
    (D3D11_UAV_DIMENSION, "ViewDimension"),
    (Union("{self}.ViewDimension", [
        ("D3D11_UAV_DIMENSION_BUFFER", D3D11_BUFFER_UAV, "Buffer"),
        ("D3D11_UAV_DIMENSION_TEXTURE1D", D3D11_TEX1D_UAV, "Texture1D"),
        ("D3D11_UAV_DIMENSION_TEXTURE1DARRAY", D3D11_TEX1D_ARRAY_UAV, "Texture1DArray"),
        ("D3D11_UAV_DIMENSION_TEXTURE2D", D3D11_TEX2D_UAV1, "Texture2D"),
        ("D3D11_UAV_DIMENSION_TEXTURE2DARRAY", D3D11_TEX2D_ARRAY_UAV1, "Texture2DArray"),
        ("D3D11_UAV_DIMENSION_TEXTURE3D", D3D11_TEX3D_UAV, "Texture3D"),
    ]), None),
])

ID3D11UnorderedAccessView1 = Interface("ID3D11UnorderedAccessView1", ID3D11UnorderedAccessView)
ID3D11UnorderedAccessView1.methods += [
    StdMethod(Void, "GetDesc1", [Out(Pointer(D3D11_UNORDERED_ACCESS_VIEW_DESC1), "pDesc1")], sideeffects=False),
]

D3D11_QUERY_DESC1 = Struct("D3D11_QUERY_DESC1", [
    (D3D11_QUERY, "Query"),
    (D3D11_QUERY_MISC_FLAG, "MiscFlags"),
    (D3D11_CONTEXT_TYPE, "ContextType"),
])

ID3D11Query1 = Interface("ID3D11Query1", ID3D11Query)
ID3D11Query1.methods += [
    StdMethod(Void, "GetDesc1", [Out(Pointer(D3D11_QUERY_DESC1), "pDesc1")], sideeffects=False),
]

ID3D11DeviceContext3 = Interface("ID3D11DeviceContext3", ID3D11DeviceContext2)
ID3D11DeviceContext3.methods += [
    StdMethod(Void, "Flush1", [(D3D11_CONTEXT_TYPE, "ContextType"), (HANDLE, "hEvent")]),
    StdMethod(Void, "SetHardwareProtectionState", [(BOOL, "HwProtectionEnable")]),
    StdMethod(Void, "GetHardwareProtectionState", [Out(Pointer(BOOL), "pHwProtectionEnable")], sideeffects=False),
]

ID3D11Fence = Interface('ID3D11Fence', ID3D11DeviceChild)
ID3D11Fence.methods += [
    StdMethod(HRESULT, 'CreateSharedHandle', [(Pointer(Const(SECURITY_ATTRIBUTES)), 'pAttributes'), (DWORD, 'dwAccess'), (LPCWSTR, 'lpName'), Out(Pointer(HANDLE), 'pHandle')]),
    StdMethod(UINT64, 'GetCompletedValue', []),
    StdMethod(HRESULT, 'SetEventOnCompletion', [(UINT64, 'Value'), (HANDLE, 'hEvent')]),
]

ID3D11DeviceContext4 = Interface('ID3D11DeviceContext4', ID3D11DeviceContext3)
ID3D11DeviceContext4.methods += [
    StdMethod(HRESULT, 'Signal', [(ObjPointer(ID3D11Fence), 'pFence'), (UINT64, 'Value')]),
    StdMethod(HRESULT, 'Wait', [(ObjPointer(ID3D11Fence), 'pFence'), (UINT64, 'Value')]),
]

ID3D11Device3 = Interface("ID3D11Device3", ID3D11Device2)
ID3D11Device3.methods += [
    StdMethod(HRESULT, "CreateTexture2D1", [(Pointer(Const(D3D11_TEXTURE2D_DESC1)), "pDesc1"), (Array(Const(D3D11_SUBRESOURCE_DATA), "_getNumSubResources(pDesc1)"), "pInitialData"), Out(Pointer(ObjPointer(ID3D11Texture2D1)), "ppTexture2D")]),
    StdMethod(HRESULT, "CreateTexture3D1", [(Pointer(Const(D3D11_TEXTURE3D_DESC1)), "pDesc1"), (Array(Const(D3D11_SUBRESOURCE_DATA), "_getNumSubResources(pDesc1)"), "pInitialData"), Out(Pointer(ObjPointer(ID3D11Texture3D1)), "ppTexture3D")]),
    StdMethod(HRESULT, "CreateRasterizerState2", [(Pointer(Const(D3D11_RASTERIZER_DESC2)), "pRasterizerDesc"), Out(Pointer(ObjPointer(ID3D11RasterizerState2)), "ppRasterizerState")]),
    StdMethod(HRESULT, "CreateShaderResourceView1", [(ObjPointer(ID3D11Resource), "pResource"), (Pointer(Const(D3D11_SHADER_RESOURCE_VIEW_DESC1)), "pDesc1"), Out(Pointer(ObjPointer(ID3D11ShaderResourceView1)), "ppSRView1")]),
    StdMethod(HRESULT, "CreateUnorderedAccessView1", [(ObjPointer(ID3D11Resource), "pResource"), (Pointer(Const(D3D11_UNORDERED_ACCESS_VIEW_DESC1)), "pDesc1"), Out(Pointer(ObjPointer(ID3D11UnorderedAccessView1)), "ppUAView1")]),
    StdMethod(HRESULT, "CreateRenderTargetView1", [(ObjPointer(ID3D11Resource), "pResource"), (Pointer(Const(D3D11_RENDER_TARGET_VIEW_DESC1)), "pDesc1"), Out(Pointer(ObjPointer(ID3D11RenderTargetView1)), "ppRTView1")]),
    StdMethod(HRESULT, "CreateQuery1", [(Pointer(Const(D3D11_QUERY_DESC1)), "pQueryDesc1"), Out(Pointer(ObjPointer(ID3D11Query1)), "ppQuery1")]),
    StdMethod(Void, "GetImmediateContext3", [Out(Pointer(ObjPointer(ID3D11DeviceContext3)), "ppImmediateContext")]),
    StdMethod(HRESULT, "CreateDeferredContext3", [(UINT, "ContextFlags"), Out(Pointer(ObjPointer(ID3D11DeviceContext3)), "ppDeferredContext")]),
    StdMethod(Void, "WriteToSubresource", [(ObjPointer(ID3D11Resource), "pDstResource"), (UINT, "DstSubresource"), (Pointer(Const(D3D11_BOX)), "pDstBox"), (Blob(Const(Void), '_calcSubresourceSize(pDstResource, DstSubresource, pDstBox, SrcRowPitch, SrcDepthPitch)'), "pSrcData"), (UINT, "SrcRowPitch"), (UINT, "SrcDepthPitch")]),
    StdMethod(Void, "ReadFromSubresource", [Out(OpaquePointer(Void), "pDstData"), (UINT, "DstRowPitch"), (UINT, "DstDepthPitch"), (ObjPointer(ID3D11Resource), "pSrcResource"), (UINT, "SrcSubresource"), (Pointer(Const(D3D11_BOX)), "pSrcBox")], sideeffects=False), # FIXME
]

d3d11.addInterfaces([
    ID3D11Device3,
    ID3D11DeviceContext3,
    ID3D11DeviceContext4, # Requires Windows 10.0.15021 SDK
])


#
# D3D11.4
#

D3D11_FENCE_FLAG = Enum('D3D11_FENCE_FLAG', [
    'D3D11_FENCE_FLAG_NONE',
    'D3D11_FENCE_FLAG_SHARED',
    'D3D11_FENCE_FLAG_SHARED_CROSS_ADAPTER',
    'D3D11_FENCE_FLAG_NON_MONITORED',
])

ID3D11Device4 = Interface('ID3D11Device4', ID3D11Device3)
ID3D11Device5 = Interface('ID3D11Device5', ID3D11Device4)
ID3D11Multithread = Interface('ID3D11Multithread', IUnknown)
ID3D11VideoContext2 = Interface('ID3D11VideoContext2', ID3D11VideoContext1)

ID3D11Device4.methods += [
    StdMethod(HRESULT, 'RegisterDeviceRemovedEvent', [(HANDLE, 'hEvent'), Out(Pointer(DWORD), 'pdwCookie')], sideeffects=False),
    StdMethod(Void, 'UnregisterDeviceRemoved', [(DWORD, 'dwCookie')], sideeffects=False),
]

ID3D11Device5.methods += [
    StdMethod(HRESULT, 'OpenSharedFence', [(HANDLE, 'hFence'), (REFIID, 'ReturnedInterface'), Out(Pointer(ObjPointer(Void)), 'ppFence')]),
    StdMethod(HRESULT, 'CreateFence', [(UINT64, 'InitialValue'), (D3D11_FENCE_FLAG, 'Flags'), (REFIID, 'ReturnedInterface'), Out(Pointer(ObjPointer(Void)), 'ppFence')]),
]

ID3D11Multithread.methods += [
    StdMethod(Void, 'Enter', []),
    StdMethod(Void, 'Leave', []),
    StdMethod(BOOL, 'SetMultithreadProtected', [(BOOL, 'bMTProtect')]),
    StdMethod(BOOL, 'GetMultithreadProtected', [], sideeffects=False),
]

ID3D11VideoContext2.methods += [
    StdMethod(Void, 'VideoProcessorSetOutputHDRMetaData', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (DXGI_HDR_METADATA_TYPE, 'Type'), (UINT, 'Size'), (Blob(Const(Void), 'Size'), 'pHDRMetaData')]),
    StdMethod(Void, 'VideoProcessorGetOutputHDRMetaData', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), Out(Pointer(DXGI_HDR_METADATA_TYPE), 'pType'), (UINT, 'Size'), Out(OpaqueBlob(Void, 'Size'), 'pMetaData')], sideeffects=False),
    StdMethod(Void, 'VideoProcessorSetStreamHDRMetaData', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (UINT, 'StreamIndex'), (DXGI_HDR_METADATA_TYPE, 'Type'), (UINT, 'Size'), (Blob(Const(Void), 'Size'), 'pHDRMetaData')]),
    StdMethod(Void, 'VideoProcessorGetStreamHDRMetaData', [(ObjPointer(ID3D11VideoProcessor), 'pVideoProcessor'), (UINT, 'StreamIndex'), Out(Pointer(DXGI_HDR_METADATA_TYPE), 'pType'), (UINT, 'Size'), Out(Blob(Void, 'Size'), 'pMetaData')], sideeffects=False),
]

PFN_DESTRUCTION_CALLBACK = Opaque("PFN_DESTRUCTION_CALLBACK")

ID3DDestructionNotifier = Interface('ID3DDestructionNotifier', IUnknown)

ID3DDestructionNotifier.methods += [
    StdMethod(HRESULT, 'RegisterDestructionCallback', [(PFN_DESTRUCTION_CALLBACK, 'callbackFn'), (OpaquePointer(Void), 'pData'), Out(Pointer(UINT), 'pCallbackID')], sideeffects=False),
    StdMethod(HRESULT, 'UnregisterDestructionCallback', [(UINT, 'callbackID')], sideeffects=False),
]

IUseCounted = Interface('IUseCounted', IUnknown)
IUseCounted.methods += [
    StdMethod(ULONG, 'UCAddUse', []),
    StdMethod(ULONG, 'UCReleaseUse', []),
    StdMethod(Void, 'UCBreakCyclicReferences', []),
    StdMethod(Void, 'UCEstablishCyclicReferences', []),
    StdMethod(Void, 'UCDestroy', []),
]

ILayeredUseCounted = Interface('ILayeredUseCounted', IUseCounted)

ID3D11LayeredUseCounted = Interface('ID3D11LayeredUseCounted', ILayeredUseCounted)

IUseCounted2 = Interface('IUseCounted2', IUseCounted)
IUseCounted2.methods += [
    StdMethod(HRESULT, 'UCQueryInterface', [(UINT, 'flags'), (REFIID, 'riid'), Out(Pointer(ObjPointer(Void)), 'ppvObj')]),
]

d3d11.addInterfaces([
    ID3D11Device4,
    ID3D11Device5, # Requires Windows 10.0.15021 SDK
    ID3D11Multithread,
    ID3D11VideoContext2,
    ID3DDestructionNotifier,
    ID3D11LayeredUseCounted,
    IUseCounted2,
])
