## This Source Code Form is subject to the terms of the Mozilla Public
## License, v. 2.0. If a copy of the MPL was not distributed with this
## file, You can obtain one at https://mozilla.org/MPL/2.0/.
##
## Copyright (c) 2007-2026 Broadcom. All Rights Reserved. The term “Broadcom” refers to Broadcom Inc. and/or its subsidiaries.  All rights reserved.

defmodule RabbitMQ.CLI.Diagnostics.Commands.ObserverCommand do
  @behaviour RabbitMQ.CLI.CommandBehaviour
  use RabbitMQ.CLI.DefaultOutput

  def switches(), do: [interval: :integer]
  def aliases(), do: [i: :interval]

  def merge_defaults(args, opts) do
    {args, Map.merge(%{interval: 5}, opts)}
  end

  use RabbitMQ.CLI.Core.AcceptsNoPositionalArguments

  @dialyzer {:nowarn_function, run: 2}
  def run([], %{node: node_name, interval: interval}) do
    case :rabbit_misc.rpc_call(node_name, :observer_cli, :start, [interval * 1000], :infinity) do
      :ok -> {:ok, "Disconnected from #{node_name}."}
      :quit -> {:ok, "Disconnected from #{node_name}."}
      other -> other
    end
  end

  def help_section(), do: :observability_and_health_checks

  def description(), do: "Starts a CLI observer interface on the target node"

  def usage, do: "observer [--interval <seconds>]"

  def usage_additional() do
    [
      ["--interval <seconds>", "Update interval to use, in seconds"]
    ]
  end

  def banner(_, %{node: node_name}) do
    "Starting a CLI observer interface on node #{node_name}..."
  end
end
