/*
 * Copyright (c) 2016 Google, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * <a href="https://truth.dev" target="_top">Truth</a> is a library for performing assertions in
 * tests:
 *
 * <pre>{@code
 * assertThat(notificationText).contains("testuser@google.com");
 * }</pre>
 *
 * <p>Truth is owned and maintained by the <a href="http://github.com/google/guava"
 * target="_top">Guava</a> team. It is used in the majority of the tests in Google’s own codebase.
 *
 * <p>For more information, see <a href="https://truth.dev" target="_top">our introduction</a> and
 * other docs.
 */
@CheckReturnValue
@NullMarked
package com.google.common.truth;

import com.google.errorprone.annotations.CheckReturnValue;
import org.jspecify.annotations.NullMarked;
