//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlresourcekey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "NSString")]
pub type NSURLResourceKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfilescheme?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileScheme: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlkeysofunsetvalueskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLKeysOfUnsetValuesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlnamekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLNameKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurllocalizednamekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLLocalizedNameKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisregularfilekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsRegularFileKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisdirectorykey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsDirectoryKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlissymboliclinkkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsSymbolicLinkKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisvolumekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsVolumeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlispackagekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsPackageKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisapplicationkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsApplicationKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlapplicationisscriptablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLApplicationIsScriptableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlissystemimmutablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsSystemImmutableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisuserimmutablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsUserImmutableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlishiddenkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsHiddenKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlhashiddenextensionkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLHasHiddenExtensionKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcreationdatekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLCreationDateKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcontentaccessdatekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLContentAccessDateKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcontentmodificationdatekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLContentModificationDateKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlattributemodificationdatekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLAttributeModificationDateKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurllinkcountkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLLinkCountKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlparentdirectoryurlkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLParentDirectoryURLKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeurlkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeURLKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurltypeidentifierkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLTypeIdentifierKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcontenttypekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLContentTypeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurllocalizedtypedescriptionkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLLocalizedTypeDescriptionKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurllabelnumberkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLLabelNumberKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurllabelcolorkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLLabelColorKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurllocalizedlabelkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLLocalizedLabelKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurleffectiveiconkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLEffectiveIconKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcustomiconkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLCustomIconKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourceidentifierkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceIdentifierKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeidentifierkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIdentifierKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlpreferredioblocksizekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLPreferredIOBlockSizeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisreadablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsReadableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurliswritablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsWritableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisexecutablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsExecutableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfilesecuritykey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileSecurityKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisexcludedfrombackupkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsExcludedFromBackupKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurltagnameskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLTagNamesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlpathkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLPathKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcanonicalpathkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLCanonicalPathKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlismounttriggerkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsMountTriggerKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlgenerationidentifierkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLGenerationIdentifierKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurldocumentidentifierkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLDocumentIdentifierKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurladdedtodirectorydatekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLAddedToDirectoryDateKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlquarantinepropertieskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLQuarantinePropertiesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetypekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceTypeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileidentifierkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileIdentifierKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfilecontentidentifierkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileContentIdentifierKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlmaysharefilecontentkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLMayShareFileContentKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlmayhaveextendedattributeskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLMayHaveExtendedAttributesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlispurgeablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsPurgeableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlissparsekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsSparseKey: &'static NSURLResourceKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetype?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSURLFileResourceType = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetypenamedpipe?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceTypeNamedPipe: &'static NSURLFileResourceType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetypecharacterspecial?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceTypeCharacterSpecial: &'static NSURLFileResourceType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetypedirectory?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceTypeDirectory: &'static NSURLFileResourceType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetypeblockspecial?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceTypeBlockSpecial: &'static NSURLFileResourceType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetyperegular?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceTypeRegular: &'static NSURLFileResourceType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetypesymboliclink?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceTypeSymbolicLink: &'static NSURLFileResourceType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetypesocket?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceTypeSocket: &'static NSURLFileResourceType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileresourcetypeunknown?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileResourceTypeUnknown: &'static NSURLFileResourceType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlthumbnaildictionarykey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLThumbnailDictionaryKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlthumbnailkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLThumbnailKey: &'static NSURLResourceKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlthumbnaildictionaryitem?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "NSString")]
pub type NSURLThumbnailDictionaryItem = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsthumbnail1024x1024sizekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSThumbnail1024x1024SizeKey: &'static NSURLThumbnailDictionaryItem;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfilesizekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileSizeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileallocatedsizekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileAllocatedSizeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurltotalfilesizekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLTotalFileSizeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurltotalfileallocatedsizekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLTotalFileAllocatedSizeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisaliasfilekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsAliasFileKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileprotectionkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileProtectionKey: &'static NSURLResourceKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileprotectiontype?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSURLFileProtectionType = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileprotectionnone?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileProtectionNone: &'static NSURLFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileprotectioncomplete?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileProtectionComplete: &'static NSURLFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileprotectioncompleteunlessopen?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileProtectionCompleteUnlessOpen: &'static NSURLFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileprotectioncompleteuntilfirstuserauthentication?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileProtectionCompleteUntilFirstUserAuthentication:
        &'static NSURLFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlfileprotectioncompletewhenuserinactive?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLFileProtectionCompleteWhenUserInactive: &'static NSURLFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurldirectoryentrycountkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLDirectoryEntryCountKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumelocalizedformatdescriptionkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeLocalizedFormatDescriptionKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumetotalcapacitykey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeTotalCapacityKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeavailablecapacitykey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeAvailableCapacityKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeresourcecountkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeResourceCountKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportspersistentidskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsPersistentIDsKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportssymboliclinkskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsSymbolicLinksKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportshardlinkskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsHardLinksKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsjournalingkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsJournalingKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeisjournalingkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsJournalingKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportssparsefileskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsSparseFilesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportszerorunskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsZeroRunsKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportscasesensitivenameskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsCaseSensitiveNamesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportscasepreservednameskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsCasePreservedNamesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsrootdirectorydateskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsRootDirectoryDatesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsvolumesizeskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsVolumeSizesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsrenamingkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsRenamingKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsadvisoryfilelockingkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsAdvisoryFileLockingKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsextendedsecuritykey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsExtendedSecurityKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeisbrowsablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsBrowsableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumemaximumfilesizekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeMaximumFileSizeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeisejectablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsEjectableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeisremovablekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsRemovableKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeisinternalkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsInternalKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeisautomountedkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsAutomountedKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeislocalkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsLocalKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeisreadonlykey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsReadOnlyKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumecreationdatekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeCreationDateKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeurlforremountingkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeURLForRemountingKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeuuidstringkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeUUIDStringKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumenamekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeNameKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumelocalizednamekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeLocalizedNameKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeisencryptedkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsEncryptedKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeisrootfilesystemkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeIsRootFileSystemKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportscompressionkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsCompressionKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsfilecloningkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsFileCloningKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsswaprenamingkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsSwapRenamingKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsexclusiverenamingkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsExclusiveRenamingKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsimmutablefileskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsImmutableFilesKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsaccesspermissionskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsAccessPermissionsKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesupportsfileprotectionkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSupportsFileProtectionKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeavailablecapacityforimportantusagekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeAvailableCapacityForImportantUsageKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumeavailablecapacityforopportunisticusagekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeAvailableCapacityForOpportunisticUsageKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumetypenamekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeTypeNameKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumesubtypekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeSubtypeKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlvolumemountfromlocationkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLVolumeMountFromLocationKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlisubiquitousitemkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLIsUbiquitousItemKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemhasunresolvedconflictskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemHasUnresolvedConflictsKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemisdownloadedkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemIsDownloadedKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemisdownloadingkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemIsDownloadingKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemisuploadedkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemIsUploadedKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemisuploadingkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemIsUploadingKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitempercentdownloadedkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemPercentDownloadedKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitempercentuploadedkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemPercentUploadedKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemdownloadingstatuskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemDownloadingStatusKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemdownloadingerrorkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemDownloadingErrorKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemuploadingerrorkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemUploadingErrorKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemdownloadrequestedkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemDownloadRequestedKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemcontainerdisplaynamekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemContainerDisplayNameKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemisexcludedfromsynckey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemIsExcludedFromSyncKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemissharedkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemIsSharedKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditemcurrentuserrolekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousSharedItemCurrentUserRoleKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditemcurrentuserpermissionskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousSharedItemCurrentUserPermissionsKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditemownernamecomponentskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousSharedItemOwnerNameComponentsKey: &'static NSURLResourceKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditemmostrecenteditornamecomponentskey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousSharedItemMostRecentEditorNameComponentsKey:
        &'static NSURLResourceKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemdownloadingstatus?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSURLUbiquitousItemDownloadingStatus = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemdownloadingstatusnotdownloaded?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemDownloadingStatusNotDownloaded:
        &'static NSURLUbiquitousItemDownloadingStatus;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemdownloadingstatusdownloaded?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemDownloadingStatusDownloaded:
        &'static NSURLUbiquitousItemDownloadingStatus;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousitemdownloadingstatuscurrent?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousItemDownloadingStatusCurrent:
        &'static NSURLUbiquitousItemDownloadingStatus;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditemrole?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSURLUbiquitousSharedItemRole = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditemroleowner?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousSharedItemRoleOwner: &'static NSURLUbiquitousSharedItemRole;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditemroleparticipant?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousSharedItemRoleParticipant: &'static NSURLUbiquitousSharedItemRole;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditempermissions?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSURLUbiquitousSharedItemPermissions = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditempermissionsreadonly?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousSharedItemPermissionsReadOnly:
        &'static NSURLUbiquitousSharedItemPermissions;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlubiquitousshareditempermissionsreadwrite?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLUbiquitousSharedItemPermissionsReadWrite:
        &'static NSURLUbiquitousSharedItemPermissions;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlbookmarkcreationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLBookmarkCreationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSURLBookmarkCreationOptions: NSUInteger {
#[deprecated = "Not supported"]
        #[doc(alias = "NSURLBookmarkCreationPreferFileIDResolution")]
        const PreferFileIDResolution = 1<<8;
        #[doc(alias = "NSURLBookmarkCreationMinimalBookmark")]
        const MinimalBookmark = 1<<9;
        #[doc(alias = "NSURLBookmarkCreationSuitableForBookmarkFile")]
        const SuitableForBookmarkFile = 1<<10;
        #[doc(alias = "NSURLBookmarkCreationWithSecurityScope")]
        const WithSecurityScope = 1<<11;
        #[doc(alias = "NSURLBookmarkCreationSecurityScopeAllowOnlyReadAccess")]
        const SecurityScopeAllowOnlyReadAccess = 1<<12;
        #[doc(alias = "NSURLBookmarkCreationWithoutImplicitSecurityScope")]
        const WithoutImplicitSecurityScope = 1<<29;
    }
}

unsafe impl Encode for NSURLBookmarkCreationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSURLBookmarkCreationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlbookmarkresolutionoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLBookmarkResolutionOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSURLBookmarkResolutionOptions: NSUInteger {
        #[doc(alias = "NSURLBookmarkResolutionWithoutUI")]
        const WithoutUI = 1<<8;
        #[doc(alias = "NSURLBookmarkResolutionWithoutMounting")]
        const WithoutMounting = 1<<9;
        #[doc(alias = "NSURLBookmarkResolutionWithSecurityScope")]
        const WithSecurityScope = 1<<10;
        #[doc(alias = "NSURLBookmarkResolutionWithoutImplicitStartAccessing")]
        const WithoutImplicitStartAccessing = 1<<15;
    }
}

unsafe impl Encode for NSURLBookmarkResolutionOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSURLBookmarkResolutionOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlbookmarkfilecreationoptions?language=objc)
pub type NSURLBookmarkFileCreationOptions = NSUInteger;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurl?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURL;
);

unsafe impl Send for NSURL {}

unsafe impl Sync for NSURL {}

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSURL {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURL {}

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSURL {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSURL {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSURL {}

impl NSURL {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[deprecated = "Use NSURLComponents instead, which lets you create a valid URL with any valid combination of URL components and subcomponents (not just scheme, host and path), and lets you set components and subcomponents with either percent-encoded or un-percent-encoded strings."]
        #[unsafe(method(initWithScheme:host:path:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithScheme_host_path(
            this: Allocated<Self>,
            scheme: &NSString,
            host: Option<&NSString>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initFileURLWithPath:isDirectory:relativeToURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initFileURLWithPath_isDirectory_relativeToURL(
            this: Allocated<Self>,
            path: &NSString,
            is_dir: bool,
            base_url: Option<&NSURL>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initFileURLWithPath:relativeToURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initFileURLWithPath_relativeToURL(
            this: Allocated<Self>,
            path: &NSString,
            base_url: Option<&NSURL>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initFileURLWithPath:isDirectory:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initFileURLWithPath_isDirectory(
            this: Allocated<Self>,
            path: &NSString,
            is_dir: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initFileURLWithPath:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initFileURLWithPath(this: Allocated<Self>, path: &NSString)
            -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fileURLWithPath:isDirectory:relativeToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileURLWithPath_isDirectory_relativeToURL(
            path: &NSString,
            is_dir: bool,
            base_url: Option<&NSURL>,
        ) -> Retained<NSURL>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fileURLWithPath:relativeToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileURLWithPath_relativeToURL(
            path: &NSString,
            base_url: Option<&NSURL>,
        ) -> Retained<NSURL>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fileURLWithPath:isDirectory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileURLWithPath_isDirectory(path: &NSString, is_dir: bool)
            -> Retained<NSURL>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fileURLWithPath:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileURLWithPath(path: &NSString) -> Retained<NSURL>;

        #[unsafe(method(initFileURLWithFileSystemRepresentation:isDirectory:relativeToURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initFileURLWithFileSystemRepresentation_isDirectory_relativeToURL(
            this: Allocated<Self>,
            path: NonNull<c_char>,
            is_dir: bool,
            base_url: Option<&NSURL>,
        ) -> Retained<Self>;

        #[unsafe(method(fileURLWithFileSystemRepresentation:isDirectory:relativeToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileURLWithFileSystemRepresentation_isDirectory_relativeToURL(
            path: NonNull<c_char>,
            is_dir: bool,
            base_url: Option<&NSURL>,
        ) -> Retained<NSURL>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithString:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithString(
            this: Allocated<Self>,
            url_string: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithString:relativeToURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithString_relativeToURL(
            this: Allocated<Self>,
            url_string: &NSString,
            base_url: Option<&NSURL>,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(URLWithString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLWithString(url_string: &NSString) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(URLWithString:relativeToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLWithString_relativeToURL(
            url_string: &NSString,
            base_url: Option<&NSURL>,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        /// Initializes an `NSURL` with a URL string and the option to add (or skip) IDNA- and percent-encoding of invalid characters.
        /// If `encodingInvalidCharacters` is false, and the URL string is invalid according to RFC 3986, `nil` is returned.
        /// If `encodingInvalidCharacters` is true, `NSURL` will try to encode the string to create a valid URL.
        /// If the URL string is still invalid after encoding, `nil` is returned.
        ///
        /// - Parameter URLString: The URL string.
        /// - Parameter encodingInvalidCharacters: True if `NSURL` should try to encode an invalid URL string, false otherwise.
        /// - Returns: An `NSURL` instance for a valid URL, or `nil` if the URL is invalid.
        #[unsafe(method(initWithString:encodingInvalidCharacters:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithString_encodingInvalidCharacters(
            this: Allocated<Self>,
            url_string: &NSString,
            encoding_invalid_characters: bool,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        /// Initializes and returns a newly created `NSURL` with a URL string and the option to add (or skip) IDNA- and percent-encoding of invalid characters.
        /// If `encodingInvalidCharacters` is false, and the URL string is invalid according to RFC 3986, `nil` is returned.
        /// If `encodingInvalidCharacters` is true, `NSURL` will try to encode the string to create a valid URL.
        /// If the URL string is still invalid after encoding, `nil` is returned.
        ///
        /// - Parameter URLString: The URL string.
        /// - Parameter encodingInvalidCharacters: True if `NSURL` should try to encode an invalid URL string, false otherwise.
        /// - Returns: An `NSURL` instance for a valid URL, or `nil` if the URL is invalid.
        #[unsafe(method(URLWithString:encodingInvalidCharacters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLWithString_encodingInvalidCharacters(
            url_string: &NSString,
            encoding_invalid_characters: bool,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(initWithDataRepresentation:relativeToURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDataRepresentation_relativeToURL(
            this: Allocated<Self>,
            data: &NSData,
            base_url: Option<&NSURL>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(URLWithDataRepresentation:relativeToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLWithDataRepresentation_relativeToURL(
            data: &NSData,
            base_url: Option<&NSURL>,
        ) -> Retained<NSURL>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(initAbsoluteURLWithDataRepresentation:relativeToURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initAbsoluteURLWithDataRepresentation_relativeToURL(
            this: Allocated<Self>,
            data: &NSData,
            base_url: Option<&NSURL>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(absoluteURLWithDataRepresentation:relativeToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn absoluteURLWithDataRepresentation_relativeToURL(
            data: &NSData,
            base_url: Option<&NSURL>,
        ) -> Retained<NSURL>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(dataRepresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataRepresentation(&self) -> Retained<NSData>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(absoluteString))]
        #[unsafe(method_family = none)]
        pub unsafe fn absoluteString(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(relativeString))]
        #[unsafe(method_family = none)]
        pub unsafe fn relativeString(&self) -> Retained<NSString>;

        #[unsafe(method(baseURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn baseURL(&self) -> Option<Retained<NSURL>>;

        #[unsafe(method(absoluteURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn absoluteURL(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(scheme))]
        #[unsafe(method_family = none)]
        pub unsafe fn scheme(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(resourceSpecifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn resourceSpecifier(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(host))]
        #[unsafe(method_family = none)]
        pub unsafe fn host(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSValue")]
        #[unsafe(method(port))]
        #[unsafe(method_family = none)]
        pub unsafe fn port(&self) -> Option<Retained<NSNumber>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(user))]
        #[unsafe(method_family = none)]
        pub unsafe fn user(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(password))]
        #[unsafe(method_family = none)]
        pub unsafe fn password(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(path))]
        #[unsafe(method_family = none)]
        pub unsafe fn path(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fragment))]
        #[unsafe(method_family = none)]
        pub unsafe fn fragment(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[deprecated = "The parameterString method is deprecated. Post deprecation for applications linked with or after the macOS 10.15, and for all iOS, watchOS, and tvOS applications, parameterString will always return nil, and the path method will return the complete path including the semicolon separator and params component if the URL string contains them."]
        #[unsafe(method(parameterString))]
        #[unsafe(method_family = none)]
        pub unsafe fn parameterString(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(query))]
        #[unsafe(method_family = none)]
        pub unsafe fn query(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(relativePath))]
        #[unsafe(method_family = none)]
        pub unsafe fn relativePath(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(hasDirectoryPath))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasDirectoryPath(&self) -> bool;

        #[unsafe(method(getFileSystemRepresentation:maxLength:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getFileSystemRepresentation_maxLength(
            &self,
            buffer: NonNull<c_char>,
            max_buffer_length: NSUInteger,
        ) -> bool;

        #[unsafe(method(fileSystemRepresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileSystemRepresentation(&self) -> NonNull<c_char>;

        #[unsafe(method(isFileURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFileURL(&self) -> bool;

        #[unsafe(method(standardizedURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn standardizedURL(&self) -> Option<Retained<NSURL>>;

        #[unsafe(method(isFileReferenceURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFileReferenceURL(&self) -> bool;

        #[unsafe(method(fileReferenceURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileReferenceURL(&self) -> Option<Retained<NSURL>>;

        #[unsafe(method(filePathURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn filePathURL(&self) -> Option<Retained<NSURL>>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(getResourceValue:forKey:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn getResourceValue_forKey_error(
            &self,
            value: &mut Option<Retained<AnyObject>>,
            key: &NSURLResourceKey,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(
            feature = "NSArray",
            feature = "NSDictionary",
            feature = "NSError",
            feature = "NSString"
        ))]
        #[unsafe(method(resourceValuesForKeys:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn resourceValuesForKeys_error(
            &self,
            keys: &NSArray<NSURLResourceKey>,
        ) -> Result<Retained<NSDictionary<NSURLResourceKey, AnyObject>>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(setResourceValue:forKey:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResourceValue_forKey_error(
            &self,
            value: Option<&AnyObject>,
            key: &NSURLResourceKey,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSError", feature = "NSString"))]
        #[unsafe(method(setResourceValues:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResourceValues_error(
            &self,
            keyed_values: &NSDictionary<NSURLResourceKey, AnyObject>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(removeCachedResourceValueForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeCachedResourceValueForKey(&self, key: &NSURLResourceKey);

        #[unsafe(method(removeAllCachedResourceValues))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllCachedResourceValues(&self);

        #[cfg(feature = "NSString")]
        #[unsafe(method(setTemporaryResourceValue:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTemporaryResourceValue_forKey(
            &self,
            value: Option<&AnyObject>,
            key: &NSURLResourceKey,
        );

        #[cfg(all(
            feature = "NSArray",
            feature = "NSData",
            feature = "NSError",
            feature = "NSString"
        ))]
        #[unsafe(method(bookmarkDataWithOptions:includingResourceValuesForKeys:relativeToURL:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn bookmarkDataWithOptions_includingResourceValuesForKeys_relativeToURL_error(
            &self,
            options: NSURLBookmarkCreationOptions,
            keys: Option<&NSArray<NSURLResourceKey>>,
            relative_url: Option<&NSURL>,
        ) -> Result<Retained<NSData>, Retained<NSError>>;

        #[cfg(all(feature = "NSData", feature = "NSError"))]
        #[unsafe(method(initByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initByResolvingBookmarkData_options_relativeToURL_bookmarkDataIsStale_error(
            this: Allocated<Self>,
            bookmark_data: &NSData,
            options: NSURLBookmarkResolutionOptions,
            relative_url: Option<&NSURL>,
            is_stale: *mut Bool,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSData", feature = "NSError"))]
        #[unsafe(method(URLByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLByResolvingBookmarkData_options_relativeToURL_bookmarkDataIsStale_error(
            bookmark_data: &NSData,
            options: NSURLBookmarkResolutionOptions,
            relative_url: Option<&NSURL>,
            is_stale: *mut Bool,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(
            feature = "NSArray",
            feature = "NSData",
            feature = "NSDictionary",
            feature = "NSString"
        ))]
        #[unsafe(method(resourceValuesForKeys:fromBookmarkData:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resourceValuesForKeys_fromBookmarkData(
            keys: &NSArray<NSURLResourceKey>,
            bookmark_data: &NSData,
        ) -> Option<Retained<NSDictionary<NSURLResourceKey, AnyObject>>>;

        #[cfg(all(feature = "NSData", feature = "NSError"))]
        #[unsafe(method(writeBookmarkData:toURL:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeBookmarkData_toURL_options_error(
            bookmark_data: &NSData,
            bookmark_file_url: &NSURL,
            options: NSURLBookmarkFileCreationOptions,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSData", feature = "NSError"))]
        #[unsafe(method(bookmarkDataWithContentsOfURL:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn bookmarkDataWithContentsOfURL_error(
            bookmark_file_url: &NSURL,
        ) -> Result<Retained<NSData>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(URLByResolvingAliasFileAtURL:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLByResolvingAliasFileAtURL_options_error(
            url: &NSURL,
            options: NSURLBookmarkResolutionOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[unsafe(method(startAccessingSecurityScopedResource))]
        #[unsafe(method_family = none)]
        pub unsafe fn startAccessingSecurityScopedResource(&self) -> bool;

        #[unsafe(method(stopAccessingSecurityScopedResource))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopAccessingSecurityScopedResource(&self);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSURL {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// NSPromisedItems.
impl NSURL {
    extern_methods!(
        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(getPromisedItemResourceValue:forKey:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn getPromisedItemResourceValue_forKey_error(
            &self,
            value: &mut Option<Retained<AnyObject>>,
            key: &NSURLResourceKey,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(
            feature = "NSArray",
            feature = "NSDictionary",
            feature = "NSError",
            feature = "NSString"
        ))]
        #[unsafe(method(promisedItemResourceValuesForKeys:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn promisedItemResourceValuesForKeys_error(
            &self,
            keys: &NSArray<NSURLResourceKey>,
        ) -> Result<Retained<NSDictionary<NSURLResourceKey, AnyObject>>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(checkPromisedItemIsReachableAndReturnError:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkPromisedItemIsReachableAndReturnError(
            &self,
        ) -> Result<(), Retained<NSError>>;
    );
}

/// NSItemProvider.
impl NSURL {
    extern_methods!();
}

#[cfg(feature = "NSItemProvider")]
unsafe impl NSItemProviderReading for NSURL {}

#[cfg(feature = "NSItemProvider")]
unsafe impl NSItemProviderWriting for NSURL {}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlqueryitem?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLQueryItem;
);

unsafe impl Send for NSURLQueryItem {}

unsafe impl Sync for NSURLQueryItem {}

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSURLQueryItem {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLQueryItem {}

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSURLQueryItem {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSURLQueryItem {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSURLQueryItem {}

impl NSURLQueryItem {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithName:value:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithName_value(
            this: Allocated<Self>,
            name: &NSString,
            value: Option<&NSString>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(queryItemWithName:value:))]
        #[unsafe(method_family = none)]
        pub unsafe fn queryItemWithName_value(
            name: &NSString,
            value: Option<&NSString>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(value))]
        #[unsafe(method_family = none)]
        pub unsafe fn value(&self) -> Option<Retained<NSString>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSURLQueryItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlcomponents?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLComponents;
);

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLComponents {}

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSURLComponents {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSURLComponents {}

impl NSURLComponents {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initWithURL:resolvingAgainstBaseURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithURL_resolvingAgainstBaseURL(
            this: Allocated<Self>,
            url: &NSURL,
            resolve: bool,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(componentsWithURL:resolvingAgainstBaseURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn componentsWithURL_resolvingAgainstBaseURL(
            url: &NSURL,
            resolve: bool,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithString:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithString(
            this: Allocated<Self>,
            url_string: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(componentsWithString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn componentsWithString(url_string: &NSString) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        /// Initializes an `NSURLComponents` with a URL string and the option to add (or skip) IDNA- and percent-encoding of invalid characters.
        /// If `encodingInvalidCharacters` is false, and the URL string is invalid according to RFC 3986, `nil` is returned.
        /// If `encodingInvalidCharacters` is true, `NSURLComponents` will try to encode the string to create a valid URL.
        /// If the URL string is still invalid after encoding, `nil` is returned.
        ///
        /// - Parameter URLString: The URL string.
        /// - Parameter encodingInvalidCharacters: True if `NSURLComponents` should try to encode an invalid URL string, false otherwise.
        /// - Returns: An `NSURLComponents` instance for a valid URL, or `nil` if the URL is invalid.
        #[unsafe(method(initWithString:encodingInvalidCharacters:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithString_encodingInvalidCharacters(
            this: Allocated<Self>,
            url_string: &NSString,
            encoding_invalid_characters: bool,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        /// Initializes and returns a newly created `NSURLComponents` with a URL string and the option to add (or skip) IDNA- and percent-encoding of invalid characters.
        /// If `encodingInvalidCharacters` is false, and the URL string is invalid according to RFC 3986, `nil` is returned.
        /// If `encodingInvalidCharacters` is true, `NSURLComponents` will try to encode the string to create a valid URL.
        /// If the URL string is still invalid after encoding, nil is returned.
        ///
        /// - Parameter URLString: The URL string.
        /// - Parameter encodingInvalidCharacters: True if `NSURLComponents` should try to encode an invalid URL string, false otherwise.
        /// - Returns: An `NSURLComponents` instance for a valid URL, or `nil` if the URL is invalid.
        #[unsafe(method(componentsWithString:encodingInvalidCharacters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn componentsWithString_encodingInvalidCharacters(
            url_string: &NSString,
            encoding_invalid_characters: bool,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(URL))]
        #[unsafe(method_family = none)]
        pub unsafe fn URL(&self) -> Option<Retained<NSURL>>;

        #[unsafe(method(URLRelativeToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLRelativeToURL(&self, base_url: Option<&NSURL>) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(string))]
        #[unsafe(method_family = none)]
        pub unsafe fn string(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(scheme))]
        #[unsafe(method_family = none)]
        pub unsafe fn scheme(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`scheme`][Self::scheme].
        #[unsafe(method(setScheme:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setScheme(&self, scheme: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(user))]
        #[unsafe(method_family = none)]
        pub unsafe fn user(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`user`][Self::user].
        #[unsafe(method(setUser:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUser(&self, user: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(password))]
        #[unsafe(method_family = none)]
        pub unsafe fn password(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`password`][Self::password].
        #[unsafe(method(setPassword:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPassword(&self, password: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(host))]
        #[unsafe(method_family = none)]
        pub unsafe fn host(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`host`][Self::host].
        #[unsafe(method(setHost:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHost(&self, host: Option<&NSString>);

        #[cfg(feature = "NSValue")]
        #[unsafe(method(port))]
        #[unsafe(method_family = none)]
        pub unsafe fn port(&self) -> Option<Retained<NSNumber>>;

        #[cfg(feature = "NSValue")]
        /// Setter for [`port`][Self::port].
        #[unsafe(method(setPort:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPort(&self, port: Option<&NSNumber>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(path))]
        #[unsafe(method_family = none)]
        pub unsafe fn path(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`path`][Self::path].
        #[unsafe(method(setPath:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPath(&self, path: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(query))]
        #[unsafe(method_family = none)]
        pub unsafe fn query(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`query`][Self::query].
        #[unsafe(method(setQuery:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setQuery(&self, query: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(fragment))]
        #[unsafe(method_family = none)]
        pub unsafe fn fragment(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`fragment`][Self::fragment].
        #[unsafe(method(setFragment:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFragment(&self, fragment: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(percentEncodedUser))]
        #[unsafe(method_family = none)]
        pub unsafe fn percentEncodedUser(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`percentEncodedUser`][Self::percentEncodedUser].
        #[unsafe(method(setPercentEncodedUser:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPercentEncodedUser(&self, percent_encoded_user: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(percentEncodedPassword))]
        #[unsafe(method_family = none)]
        pub unsafe fn percentEncodedPassword(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`percentEncodedPassword`][Self::percentEncodedPassword].
        #[unsafe(method(setPercentEncodedPassword:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPercentEncodedPassword(&self, percent_encoded_password: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[deprecated = "Use encodedHost instead"]
        #[unsafe(method(percentEncodedHost))]
        #[unsafe(method_family = none)]
        pub unsafe fn percentEncodedHost(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`percentEncodedHost`][Self::percentEncodedHost].
        #[deprecated = "Use encodedHost instead"]
        #[unsafe(method(setPercentEncodedHost:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPercentEncodedHost(&self, percent_encoded_host: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(percentEncodedPath))]
        #[unsafe(method_family = none)]
        pub unsafe fn percentEncodedPath(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`percentEncodedPath`][Self::percentEncodedPath].
        #[unsafe(method(setPercentEncodedPath:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPercentEncodedPath(&self, percent_encoded_path: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(percentEncodedQuery))]
        #[unsafe(method_family = none)]
        pub unsafe fn percentEncodedQuery(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`percentEncodedQuery`][Self::percentEncodedQuery].
        #[unsafe(method(setPercentEncodedQuery:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPercentEncodedQuery(&self, percent_encoded_query: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(percentEncodedFragment))]
        #[unsafe(method_family = none)]
        pub unsafe fn percentEncodedFragment(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`percentEncodedFragment`][Self::percentEncodedFragment].
        #[unsafe(method(setPercentEncodedFragment:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPercentEncodedFragment(&self, percent_encoded_fragment: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodedHost))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodedHost(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`encodedHost`][Self::encodedHost].
        #[unsafe(method(setEncodedHost:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEncodedHost(&self, encoded_host: Option<&NSString>);

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfScheme))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfScheme(&self) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfUser))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfUser(&self) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfPassword))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfPassword(&self) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfHost))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfHost(&self) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfPort))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfPort(&self) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfPath))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfPath(&self) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfQuery))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfQuery(&self) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfFragment))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfFragment(&self) -> NSRange;

        #[cfg(feature = "NSArray")]
        #[unsafe(method(queryItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn queryItems(&self) -> Option<Retained<NSArray<NSURLQueryItem>>>;

        #[cfg(feature = "NSArray")]
        /// Setter for [`queryItems`][Self::queryItems].
        #[unsafe(method(setQueryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setQueryItems(&self, query_items: Option<&NSArray<NSURLQueryItem>>);

        #[cfg(feature = "NSArray")]
        #[unsafe(method(percentEncodedQueryItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn percentEncodedQueryItems(&self) -> Option<Retained<NSArray<NSURLQueryItem>>>;

        #[cfg(feature = "NSArray")]
        /// Setter for [`percentEncodedQueryItems`][Self::percentEncodedQueryItems].
        #[unsafe(method(setPercentEncodedQueryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPercentEncodedQueryItems(
            &self,
            percent_encoded_query_items: Option<&NSArray<NSURLQueryItem>>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl NSURLComponents {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// NSURLUtilities.
#[cfg(feature = "NSCharacterSet")]
impl NSCharacterSet {
    extern_methods!(
        #[unsafe(method(URLUserAllowedCharacterSet))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLUserAllowedCharacterSet() -> Retained<NSCharacterSet>;

        #[unsafe(method(URLPasswordAllowedCharacterSet))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLPasswordAllowedCharacterSet() -> Retained<NSCharacterSet>;

        #[unsafe(method(URLHostAllowedCharacterSet))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLHostAllowedCharacterSet() -> Retained<NSCharacterSet>;

        #[unsafe(method(URLPathAllowedCharacterSet))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLPathAllowedCharacterSet() -> Retained<NSCharacterSet>;

        #[unsafe(method(URLQueryAllowedCharacterSet))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLQueryAllowedCharacterSet() -> Retained<NSCharacterSet>;

        #[unsafe(method(URLFragmentAllowedCharacterSet))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLFragmentAllowedCharacterSet() -> Retained<NSCharacterSet>;
    );
}

/// NSURLUtilities.
#[cfg(feature = "NSString")]
impl NSString {
    extern_methods!(
        #[cfg(feature = "NSCharacterSet")]
        #[unsafe(method(stringByAddingPercentEncodingWithAllowedCharacters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByAddingPercentEncodingWithAllowedCharacters(
            &self,
            allowed_characters: &NSCharacterSet,
        ) -> Option<Retained<NSString>>;

        #[unsafe(method(stringByRemovingPercentEncoding))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByRemovingPercentEncoding(&self) -> Option<Retained<NSString>>;

        #[deprecated = "Use -stringByAddingPercentEncodingWithAllowedCharacters: instead, which always uses the recommended UTF-8 encoding, and which encodes for a specific URL component or subcomponent since each URL component or subcomponent has different rules for what characters are valid."]
        #[unsafe(method(stringByAddingPercentEscapesUsingEncoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByAddingPercentEscapesUsingEncoding(
            &self,
            enc: NSStringEncoding,
        ) -> Option<Retained<NSString>>;

        #[deprecated = "Use -stringByRemovingPercentEncoding instead, which always uses the recommended UTF-8 encoding."]
        #[unsafe(method(stringByReplacingPercentEscapesUsingEncoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByReplacingPercentEscapesUsingEncoding(
            &self,
            enc: NSStringEncoding,
        ) -> Option<Retained<NSString>>;
    );
}

/// NSURLPathUtilities.
impl NSURL {
    extern_methods!(
        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(fileURLWithPathComponents:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileURLWithPathComponents(
            components: &NSArray<NSString>,
        ) -> Option<Retained<NSURL>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(pathComponents))]
        #[unsafe(method_family = none)]
        pub unsafe fn pathComponents(&self) -> Option<Retained<NSArray<NSString>>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(lastPathComponent))]
        #[unsafe(method_family = none)]
        pub unsafe fn lastPathComponent(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(pathExtension))]
        #[unsafe(method_family = none)]
        pub unsafe fn pathExtension(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(URLByAppendingPathComponent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLByAppendingPathComponent(
            &self,
            path_component: &NSString,
        ) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(URLByAppendingPathComponent:isDirectory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLByAppendingPathComponent_isDirectory(
            &self,
            path_component: &NSString,
            is_directory: bool,
        ) -> Option<Retained<NSURL>>;

        #[unsafe(method(URLByDeletingLastPathComponent))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLByDeletingLastPathComponent(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(URLByAppendingPathExtension:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLByAppendingPathExtension(
            &self,
            path_extension: &NSString,
        ) -> Option<Retained<NSURL>>;

        #[unsafe(method(URLByDeletingPathExtension))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLByDeletingPathExtension(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(checkResourceIsReachableAndReturnError:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkResourceIsReachableAndReturnError(
            &self,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(URLByStandardizingPath))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLByStandardizingPath(&self) -> Option<Retained<NSURL>>;

        #[unsafe(method(URLByResolvingSymlinksInPath))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLByResolvingSymlinksInPath(&self) -> Option<Retained<NSURL>>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilesecurity?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSFileSecurity;
);

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSFileSecurity {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSFileSecurity {}

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSFileSecurity {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSFileSecurity {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSFileSecurity {}

impl NSFileSecurity {
    extern_methods!(
        #[cfg(feature = "NSCoder")]
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSFileSecurity {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// NSURLLoading.
impl NSURL {
    extern_methods!(
        #[cfg(feature = "NSData")]
        #[deprecated = "Use NSURLConnection instead"]
        #[unsafe(method(resourceDataUsingCache:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resourceDataUsingCache(
            &self,
            should_use_cache: bool,
        ) -> Option<Retained<NSData>>;

        #[deprecated = "Use NSURLConnection instead"]
        #[unsafe(method(loadResourceDataNotifyingClient:usingCache:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadResourceDataNotifyingClient_usingCache(
            &self,
            client: &AnyObject,
            should_use_cache: bool,
        );

        #[cfg(feature = "NSString")]
        #[deprecated = "Use NSURLConnection instead"]
        #[unsafe(method(propertyForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn propertyForKey(&self, property_key: &NSString)
            -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSData")]
        #[deprecated = "Use NSURLConnection instead"]
        #[unsafe(method(setResourceData:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResourceData(&self, data: &NSData) -> bool;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use NSURLConnection instead"]
        #[unsafe(method(setProperty:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setProperty_forKey(
            &self,
            property: &AnyObject,
            property_key: &NSString,
        ) -> bool;

        #[cfg(feature = "NSURLHandle")]
        #[deprecated = "Use NSURLConnection instead"]
        #[unsafe(method(URLHandleUsingCache:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLHandleUsingCache(
            &self,
            should_use_cache: bool,
        ) -> Option<Retained<NSURLHandle>>;
    );
}
