#!/bin/sh -e
# fuzz/kcov/bin/syz-vm.sh: Boot the syzkaller VM.
#
# Copyright (c) 2026 Ali Polatel <alip@chesswob.org>
# SPDX-License-Identifier: GPL-3.0

set -e

KERNEL="${HOME}"/fuzz/img/vmlinuz-6.18.10+deb14-amd64
INITRD="${HOME}"/fuzz/img/initrd.img-6.18.10+deb14-amd64
VM_IMG="${HOME}"/fuzz/img/syd_fuzz.qcow2

SSH=10022
CPU=$(nproc)
MEM=4G
CMD='root=LABEL=syd-root console=ttyS0 apparmor=0 net.ifnames=0 ro'

for f in "$VM_IMG" "$KERNEL" "$INITRD"; do
    if [ ! -e "$f" ]; then
        printf 'File not found: %s\n' "$f" >&2
        exit 1
    fi
done

exec qemu-system-x86_64 \
    -serial mon:stdio -nographic \
    -enable-kvm -cpu host -smp "$CPU" -m "$MEM" \
    -kernel "$KERNEL" -initrd "$INITRD" -append "$CMD" \
    -drive "file=${VM_IMG},format=qcow2,if=virtio,discard=unmap" \
    -nic "user,model=virtio,hostfwd=tcp::${SSH}-:22"
