static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2007 Étienne Bersac <bersace03@laposte.net>                     \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2013 Daniel Sabo                                                 \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_format (format, _(\"Output format\"), NULL)                          \n"
"  description(_(\"The babl format of the output\"))                           \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE convert-format.c                                     \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *self)                                                 \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (self);                                 \n"
"                                                                              \n"
"  if (o->format)                                                              \n"
"    gegl_operation_set_format (self, \"output\", o->format);                  \n"
"  else                                                                        \n"
"    gegl_operation_set_format (self, \"output\", gegl_operation_get_source_format (self, \"input\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation        *operation,                                     \n"
"         GeglOperationContext *context,                                       \n"
"         const gchar          *output_prop,                                   \n"
"         const GeglRectangle  *roi,                                           \n"
"         gint                  level)                                         \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglBuffer *input;                                                          \n"
"  GeglBuffer *output;                                                         \n"
"                                                                              \n"
"  input  = gegl_operation_context_get_source (context, \"input\");            \n"
"                                                                              \n"
"  if (gegl_buffer_get_format (input) != o->format)                            \n"
"    {                                                                         \n"
"      output = gegl_operation_context_get_target (context, \"output\");       \n"
"      gegl_buffer_copy (input, roi, GEGL_ABYSS_NONE,                          \n"
"                        output, roi);                                         \n"
"      g_object_unref (input);                                                 \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_operation_context_take_object (context, \"output\", G_OBJECT (input));\n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"                                                                              \n"
"  operation_class->prepare  = prepare;                                        \n"
"  operation_class->process  = process;                                        \n"
"  operation_class->no_cache = FALSE;                                          \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"                \"name\",       \"gegl:convert-format\",                      \n"
"                \"title\",      _(\"Convert Format\"),                        \n"
"                \"categories\", \"core:color\",                               \n"
"                \"description\", _(\"Convert the data to the specified format\"),\n"
"                NULL);                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
