/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include <cassert>

#include "MOBIParser.h"

#include "libebook_utils.h"

namespace libebook
{

namespace
{

static const unsigned MOBI_TYPE = PDX_CODE("BOOK");
static const unsigned MOBI_CREATOR = PDX_CODE("MOBI");

}

MOBIParser::MOBIParser(librevenge::RVNGInputStream *const input, librevenge::RVNGTextInterface *const document)
  : PDXParser(input, document, MOBI_TYPE, MOBI_CREATOR)
{
  assert(input);
  // TODO: implement me
  throw UnsupportedFormat();
}

MOBIParser::~MOBIParser()
{
}

bool MOBIParser::checkType(const unsigned type, const unsigned creator)
{
  return (MOBI_TYPE == type) && (MOBI_CREATOR == creator);
}

void MOBIParser::readAppInfoRecord(librevenge::RVNGInputStream *)
{
  // nothing needed
}

void MOBIParser::readSortInfoRecord(librevenge::RVNGInputStream *)
{
  // nothing needed
}

void MOBIParser::readIndexRecord(librevenge::RVNGInputStream *const record)
{
  // TODO: implement me
  (void) record;
}

void MOBIParser::readDataRecord(librevenge::RVNGInputStream *const record, const bool last)
{
  // TODO: implement me
  (void) record;
  (void) last;
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
