#!/bin/csh
#
#		logo.csh <file of blocks> <type>
#		<type> = ps | pdf | gif
#	Makes postscript logos & converts them to gif format
#  The files colors, marks, wave and default.amino.frq must be in
#  the current directory
#	

set TMP = ../tmp
#/opt/sfw/share/ghostscript/6.52/lib/gs_fonts.ps
#/opt/sfw/esp/share/ghostscript/7.05/lib/gs_fonts.ps
setenv GS_LIB /opt/sfw/share/ghostscript

setenv LD_LIBRARY_PATH /usr/openwin/lib:/usr/dt/lib:/usr/lib:/usr/ucblib:/opt/sfw/lib:/usr/local/lib
set path = ($path /opt/sfw/bin)

#---------Make all the logos----------------------------------------------
unalias rm
unalias cp
\cp colors colors.$$

#   This creates one logo PS file for each block in the file $1
#	They have odd names - logo.$$<blockname>
if ( ($#argv > 0) && (-e $1) ) then
   ./blimps-bin/matrix_logob $1 - $$ > /dev/null
else
   echo "Content-type: text/html"
   echo ""
   echo "Logo error: Input file $1 not found"
   exit
endif
#		matrix_logob used to remove these files
rm colors.$$* symvec.$$* makelogop.$$* >& /dev/null

#-------------------------------------------------------------------------
#	See if any logo files were created
#	If so, merge them all into one big postscript file
set logos = (logo.$$*)
if ($#logos < 1) then
	echo "Content-type: text/html"
	echo ""
	echo "Logo error: No logos produced"
	exit
endif

#-------------------------------------------------------------------------
#	Show the logos
if ($#argv < 2) then
   set type = "gif"
else
   set type = $2
endif
if ($type == "ps") then
   echo "Content-type: application/postscript"
   echo ""
   cat logo.$$*
   rm logo.$$* >& /dev/null
else
   if ($type == "pdf") then
      foreach logo ($logos)
	convert -crop 612x300\!+0+0 ps:$logo pdf:$TMP/$logo.pdf
	rm -f $logo
      end
      echo "Content-type: application/pdf"
      echo ""
      set logos = ($TMP/logo.$$*.pdf)
      montage +frame +shadow +label -geometry 612x300\!+0+0 -tile 1x$#logos $logos $TMP/$$.logos.pdf
      cat $TMP/$$.logos.pdf
      rm $TMP/$$.logos.pdf $TMP/logo.$$*.pdf >& /dev/null
   else
      #	Crop off blank bottom & convert to gif format
      #	Logos are about 612 pixels wide by 792 pixels high
      foreach logo ($logos)
	convert -crop 612x300\!+0+0 ps:$logo $logo.gif
	rm -f $logo
      end

      #-------------------------------------------------------------------------
      #	Group them on a page; it may be a long page
      set logos = (logo.$$*.gif)
      montage +frame +shadow +label -geometry 612x300\!+0+0 -tile 1x$#logos $logos $TMP/$$.logos.gif
      rm -f logo.$$*.gif

      if (-e $TMP/$$.logos.gif) then
         #---------------Now show the combined logos ----------------------
         echo "Content-type: image/gif"
         echo "" 
         cat $TMP/$$.logos.gif
      else
         echo "Content-type: text/html"
         echo ""
         echo "Logo error: No gif file produced"
      endif

#-------------------------------------------------------------------------

   endif
endif
exit(0)
