#! /bin/sh
MANGLEDIR=`pwd`/mangle.tmp
MODULO=2048
CURDIR=`pwd`

set -e

[ $# -eq 1 ] || { echo specify pristine tar-ball as argument; exit 1; }

[ -r $1 ] || { echo tar-ball $1 is not readable; exit 2; }

rm -fr $MANGLEDIR
mkdir $MANGLEDIR

gzip -d <"$1" | {
  cd $MANGLEDIR
  tar xf -

  cd vice*
  rm -f doc/vice.chm
  find data/* -type f -exec wc -c '{}' ';' | while read SIZE FILE; do
    if [ $SIZE -eq $(( ( $SIZE / $MODULO ) * $MODULO )) ] || [ "$FILE" = "data/PRINTER/mps803.bin" ] ; then
      echo mangling $FILE $SIZE 1>&2
      echo dummy > $FILE
    fi
  done
  # replace non-free font
  echo replace font 1>&2
  rm data/common/C64_Pro_Mono-STYLE.ttf 1>&2
#  sed -i 's/C64_Pro_Mono-STYLE.ttf/CBM.ttf/' data/common/Makefile.am data/common/Makefile.in src/arch/shared/archdep_cbmfont.c 1>&2
  cp $CURDIR/debian/font/C64_Pro_Mono-STYLE.ttf data/common/ 1>&2
  # remove ConvertUTF.{c,h}
  echo remove non-free linenoise-ng files 1>&2
  rm ./src/lib/linenoise-ng/ConvertUTF.cpp ./src/lib/linenoise-ng/ConvertUTF.h
  cd ..

  tar cf - * 
} | bzip2 -c9 >"$1.mangled"

rm -fr $MANGLEDIR

echo Complete with:  mv "$1.mangled" "$1.bz2"

exit 0
