/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _GODUNOV_F_H_
#define _GODUNOV_F_H_

/*
** $Id: GODUNOV_F.H,v 1.5 2002/04/26 22:10:01 lijewski Exp $
*/

#define BL_FAA_TYPE(u) Real* u, ARLIM_P(u), ARLIM_P(u)
#define BL_BOXARG_TYPE(bx) const int*, const int*
#define BL_FAA(u) u.dataPtr(),ARLIM(u.loVect()),ARLIM(u.hiVect())
#define BL_FAAN(u,n) u.dataPtr(n),ARLIM(u.loVect()),ARLIM(u.hiVect())
#define BL_BOXARG(b) b.loVect(), b.hiVect() 

#include "integrator.fh"

#ifdef BL_LANG_FORT
#    define FORT_XTRACE         xtrace
#    define FORT_YTRACE         ytrace
#    define FORT_DIVF           divf
#    define FORT_COPYSTATE      copystate
#    define FORT_DIVUNODE       divunode
#    define FORT_FLATENX        flatenx
#    define FORT_FLATENY        flateny
#    define FORT_SLOPEX         slopex
#    define FORT_SLOPEY         slopey
#    define FORT_UPDATEX        updatex
#    define FORT_UPDATEY        updatey
#    define FORT_METRICS        metrics
#    define FORT_RIEMANN        riemann
#    define FORT_PRIMITIVES     primitives
#if(BL_SPACEDIM == 3)
#    define FORT_FLATENZ        flatenz
#    define FORT_UPDATEZ        updatez
#    define FORT_SLOPEZ         slopez
#    define FORT_ZTRACE         ztrace
#endif
#else
#  ifdef BL_FORT_USE_UPPERCASE
#    define FORT_XTRACE         XTRACE
#    define FORT_YTRACE         YTRACE
#    define FORT_DIVF           DIVF
#    define FORT_COPYSTATE      COPYSTATE
#    define FORT_DIVUNODE       DIVUNODE
#    define FORT_FLATENX        FLATENX
#    define FORT_FLATENY        FLATENY
#    define FORT_SLOPEX         SLOPEX
#    define FORT_SLOPEY         SLOPEY
#    define FORT_UPDATEX        UPDATEX
#    define FORT_UPDATEY        UPDATEY
#    define FORT_METRICS        METRICS
#    define FORT_RIEMANN        RIEMANN
#    define FORT_PRIMITIVES     PRIMITIVES
#  if(BL_SPACEDIM == 3)
#    define FORT_UPDATEZ        UPDATEZ
#    define FORT_SLOPEZ         SLOPEZ
#    define FORT_ZTRACE         ZTRACE
#    define FORT_FLATENZ        FLATENZ
#  endif
#  else
#  ifdef BL_FORT_USE_LOWERCASE
#    define FORT_XTRACE         xtrace
#    define FORT_YTRACE         ytrace
#    define FORT_DIVF           divf
#    define FORT_COPYSTATE      copystate
#    define FORT_DIVUNODE       divunode
#    define FORT_FLATENX        flatenx
#    define FORT_FLATENY        flateny
#    define FORT_SLOPEX         slopex
#    define FORT_SLOPEY         slopey
#    define FORT_UPDATEX        updatex
#    define FORT_UPDATEY        updatey
#    define FORT_METRICS        metrics
#    define FORT_RIEMANN        riemann
#    define FORT_PRIMITIVES     primitives
#  if(BL_SPACEDIM == 3)
#    define FORT_FLATENZ        flatenz
#    define FORT_UPDATEZ        updatez
#    define FORT_SLOPEZ         slopez
#    define FORT_ZTRACE         ztrace
#  endif
#  else
#    define FORT_XTRACE         xtrace_
#    define FORT_YTRACE         ytrace_
#    define FORT_DIVF           divf_
#    define FORT_COPYSTATE      copystate_
#    define FORT_DIVUNODE       divunode_
#    define FORT_FLATENX        flatenx_
#    define FORT_FLATENY        flateny_
#    define FORT_SLOPEX         slopex_
#    define FORT_SLOPEY         slopey_
#    define FORT_UPDATEX        updatex_
#    define FORT_UPDATEY        updatey_
#    define FORT_METRICS        metrics_
#    define FORT_RIEMANN        riemann_
#    define FORT_PRIMITIVES     primitives_
#  if(BL_SPACEDIM == 3)
#    define FORT_FLATENZ        flatenz_
#    define FORT_UPDATEZ        updatez_
#    define FORT_SLOPEZ         slopez_
#    define FORT_ZTRACE         ztrace_
#  endif
#  endif
#  endif

extern "C"
{
      void FORT_XTRACE(
                BL_FAA_TYPE(q),
                BL_FAA_TYPE(qx),
                BL_FAA_TYPE(c),
                BL_FAA_TYPE(enth),
                BL_FAA_TYPE(qbarl),
                BL_FAA_TYPE(qbarr),
                BL_FAA_TYPE(dloga),
                BL_FAA_TYPE(courno),
                BL_BOXARG_TYPE(bx),
                const Real*, Real* ,int*, int*, int* );
      void FORT_YTRACE(
                BL_FAA_TYPE(q),
                BL_FAA_TYPE(qy),
                BL_FAA_TYPE(c),
                BL_FAA_TYPE(enth),
                BL_FAA_TYPE(qbarb),
                BL_FAA_TYPE(qbart),
                BL_FAA_TYPE(dloga),
                BL_FAA_TYPE(courno),
                BL_BOXARG_TYPE(bx),
                const Real*, Real* ,int*, int*, int* );
#if(BL_SPACEDIM==3)
      void FORT_ZTRACE(
                BL_FAA_TYPE(q),
                BL_FAA_TYPE(qz),
                BL_FAA_TYPE(c),
                BL_FAA_TYPE(enth),
                BL_FAA_TYPE(qbarb),
                BL_FAA_TYPE(qbart),
                BL_FAA_TYPE(dloga),
                BL_FAA_TYPE(courno),
                BL_BOXARG_TYPE(bx),
                const Real*, Real* ,int*, int*, int* );
#endif
      void FORT_DIVF(
                BL_FAA_TYPE(state),
                BL_FAA_TYPE(div_f),
                BL_FAA_TYPE(xflux),
                BL_FAA_TYPE(yflux),
                BL_BOXARG_TYPE(bx),
                const Real*,const Real*,int* );
      void FORT_COPYSTATE(
                BL_FAA_TYPE(state),
                BL_FAA_TYPE(levelState),
                BL_BOXARG_TYPE(bx),
                int* );
      void FORT_DIVUNODE (
                BL_FAA_TYPE(state),
                BL_FAA_TYPE(divu),
                const Real*,
                int*, int*);
      void FORT_FLATENX (
                BL_FAA_TYPE(q),
                 BL_FAA_TYPE(flatnx),
                 BL_FAA_TYPE(dp),
                 BL_FAA_TYPE(z),
                 BL_FAA_TYPE(chi),
                 BL_FAA_TYPE(p),
                 BL_FAA_TYPE(c),
                 int* );
      void FORT_FLATENY (
                BL_FAA_TYPE(q),
                 BL_FAA_TYPE(flatny),
                 BL_FAA_TYPE(dp),
                 BL_FAA_TYPE(z),
                 BL_FAA_TYPE(chi),
                 BL_FAA_TYPE(p),
                 BL_FAA_TYPE(c),
                 int* );
#if(BL_SPACEDIM==3)
      void FORT_FLATENZ (
                BL_FAA_TYPE(q),
                 BL_FAA_TYPE(flatnz),
                 BL_FAA_TYPE(dp),
                 BL_FAA_TYPE(z),
                 BL_FAA_TYPE(chi),
                 BL_FAA_TYPE(p),
                 BL_FAA_TYPE(c),
                 int* );
#endif
      void FORT_SLOPEX (
                BL_FAA_TYPE(q),
                BL_FAA_TYPE(qx),
                BL_FAA_TYPE(flatnx),
                BL_FAA_TYPE(qcen),
                BL_FAA_TYPE(qsgn),
                BL_FAA_TYPE(qlim),
                BL_FAA_TYPE(dfq),
                int*, int* );
      void FORT_SLOPEY (
                BL_FAA_TYPE(q),
                BL_FAA_TYPE(qy),
                BL_FAA_TYPE(flatny),
                BL_FAA_TYPE(qcen),
                BL_FAA_TYPE(qsgn),
                BL_FAA_TYPE(qlim),
                BL_FAA_TYPE(dfq),
                int*, int* );
#if(BL_SPACEDIM==3)
      void FORT_SLOPEZ (
                BL_FAA_TYPE(q),
                BL_FAA_TYPE(qz),
                BL_FAA_TYPE(flatnz),
                BL_FAA_TYPE(qcen),
                BL_FAA_TYPE(qsgn),
                BL_FAA_TYPE(qlim),
                BL_FAA_TYPE(dfq),
                int*, int* );
#endif
      void FORT_METRICS (
                BL_FAA_TYPE(vol),
                BL_FAA_TYPE(dloga),
                BL_FAA_TYPE(area),
                BL_BOXARG_TYPE(bx),
                const Real*, int* );
      void FORT_UPDATEX (
                BL_FAA_TYPE(state),
                BL_FAA_TYPE(xflux),
                BL_FAA_TYPE(pgdnv),
                BL_FAA_TYPE(divu),
                BL_FAA_TYPE(area),
                BL_FAA_TYPE(vol),
                BL_BOXARG_TYPE(bx),
                const Real*,const Real*,int*, int*, int*, int* );
      void FORT_UPDATEY (
                BL_FAA_TYPE(state),
                BL_FAA_TYPE(yflux),
                BL_FAA_TYPE(pgdnv),
                BL_FAA_TYPE(divu),
                BL_FAA_TYPE(area),
                BL_FAA_TYPE(vol),
                BL_BOXARG_TYPE(bx),
                const Real*,const Real*,int*, int*, int*, int* );
#if(BL_SPACEDIM==3)
      void FORT_UPDATEZ (
                BL_FAA_TYPE(state),
                BL_FAA_TYPE(zflux),
                BL_FAA_TYPE(pgdnv),
                BL_FAA_TYPE(divu),
                BL_FAA_TYPE(area),
                BL_FAA_TYPE(vol),
                BL_BOXARG_TYPE(bx),
                const Real*,const Real*,int*, int*, int*, int* );
#endif
      void FORT_RIEMANN (
                BL_FAA_TYPE(qbarl),
                BL_FAA_TYPE(qbarr),
                BL_FAA_TYPE(xflux),
                BL_FAA_TYPE(q0),
                BL_FAA_TYPE(q4),
                BL_FAA_TYPE(q6),
                BL_FAA_TYPE(c),
                BL_FAA_TYPE(csml),
                BL_FAA_TYPE(gamc),
                BL_FAA_TYPE(rgdnv),
                BL_FAA_TYPE(ugdnv),
                BL_FAA_TYPE(pgdnv),
                BL_FAA_TYPE(egdnv),
                BL_FAA_TYPE(utgdnv),
#if(NADV>0)
                BL_FAA_TYPE(advgdnv),
#endif
                BL_FAA_TYPE(ustar),
                BL_BOXARG_TYPE(bx),
                int*, int*, int* );
      void FORT_PRIMITIVES (
                BL_FAA_TYPE(state),
                BL_FAA_TYPE(q),
                BL_FAA_TYPE(p),
                BL_FAA_TYPE(c),
                BL_FAA_TYPE(csml),
                BL_FAA_TYPE(gamc),
                BL_BOXARG_TYPE(bx),
                int*, int*, int*, int* );
}
#endif

#endif /*_GODUNOV_F_H_*/
