/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef  _Contour_H_
#define  _Contour_H_

#include <iostream>
#include <fstream>

#include <Box.H>
#include <ContFrame.H>
#include <Grid.H>

#ifdef HAS_WINDOWS

//
//@Man:
/*@Doc:  This class generates run-time on-screen contour plots
      and/or postscript contour plots, as determined by the
      inputs flag.  It is called from main().
*/
//@Memo: Governs the drawing of contours.

class Contour {

//@ManDoc: Output operator
    friend std::ostream& operator << (std::ostream &os, Contour &cont);

public:
//@ManDoc: Constructor 
    Contour();

//@ManDoc: Destructor
    ~Contour();

//@ManDoc: Manually clear Contour space
    void clear();

//@ManDoc: Draw the contour plot
    void drawCont(Grid &grid, int nstep, Real time);

//@ManDoc: Is it doing contour plots?
    bool doingContour();

private:
//@ManDoc: The top of the list of contour plots to be drawn.
    ContFrame *first;

};
#endif
#endif
