/*
 * makeopts.c
 *
 * Create a C source file containing an initialized string with the
 * compiler options used to compile VolPack.
 *
 * Copyright (c) 1994 The Board of Trustees of The Leland Stanford
 * Junior University.  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice and this permission notice appear in
 * all copies of this software and that you do not sell the software.
 * Commercial licensing is available by contacting the author.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Author:
 *    Phil Lacroute
 *    Computer Systems Laboratory
 *    Electrical Engineering Dept.
 *    Stanford University
 *
 * This version of the VolPack library is a modified version of the
 * original available from Stanford University.  Modifications were
 * made by the Center for Computational Sciences and Engineering,
 * Lawrence Berkeley National Laboratory.  Modifications to VolPack
 * (c) 2000 The Regents of the University of California (through
 * E.O. Lawrence Berkeley National Laboratory), subject to approval by
 * the U.S. Department of Energy.  Your use of this software is under
 * license from Stanford University with respect to the underlying
 * original VolPack code (see copyright notice and permission above)
 * and The Regents of the University of California with respect to
 * modifications thereto (see AmrVis license.txt file for applicable
 * license terms).  Contact Berkeley Lab's Center for Computational
 * Sciences and Engineering at webmaster@mothra.lbl.gov or Berkeley
 * Lab's Technology Transfer Department at TTD@lbl.gov for questions
 * or to receive more information.
 *
 */

/*
 * $Date: 2000/10/02 18:12:02 $
 * $Revision: 1.3 $
 */

#include <stdio.h>
#include <stdlib.h>

/*
 * Usage: makeopts output_file [compiler_options ...]
 */

int
main(argc, argv)
int argc;
char **argv;
{
    FILE *fp;
    int c;

    if (argc < 2) {
	fprintf(stderr, "Usage: %s output_file [compiler_options ...]\n",
		argv[0]);
	exit(1);
    }
    if ((fp = fopen(argv[1], "w")) == NULL) {
	fprintf(stderr, "%s: could not open %s\n", argv[0], argv[1]);
	exit(1);
    }
    fprintf(fp, "/*\n");
    fprintf(fp,
	    " * DO NOT EDIT THIS FILE! It was created automatically by %s.\n",
	    argv[0]);
    fprintf(fp, " */\n\n");
    fprintf(fp, "char *vpCompilerOptions = \"");
    for (c = 2; c < argc; c++) {
	if (c > 2)
	    fprintf(fp, " ");
	fprintf(fp, "%s", argv[c]);
    }
    fprintf(fp, "\";\n");
    exit(0);
}
