/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 *
 * Use is subject to the GNU Lesser General Public License, Version 2.1,
 * February 1999, which is contained in the read-me file named
 * "README_GNU_LGPL." This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2.1 of the License, or (at your
 * option) any later version. This library is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA.
 *
 * locale setting for panel utils 
 *
 * NOTE: as we want to make sure that all of the lcd utils know
 *       about each other, this is almost intentionally 
 *       single-threaded.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <libintl.h>
#include "lcdutils.h"

#define LOCALEFILE "/etc/cobalt/locale"
#define TEXTDOMAIN "panel-utils"
#define DOMAINDIR  "/usr/share/locale"

extern int _nl_msg_cat_cntr;

void lcd_setlocale(void) {
	unsigned char   language[32];
	FILE *fp;
	
	if ((fp = fopen(LOCALEFILE, "r"))) {
		fscanf(fp, "%s", language);
		fclose(fp);
	} else {
		strcpy(language, "en_US");
	}
	
	setenv("LANGUAGE", language, 1);
	++_nl_msg_cat_cntr;
	setlocale(LC_ALL, "");
	bindtextdomain(TEXTDOMAIN, DOMAINDIR);
	textdomain(TEXTDOMAIN);
}

