package aQute.bnd.set;

import java.io.*;
import java.util.*;

import aQute.lib.osgi.*;

public class Group extends Processor {
    List<Analyzer> analyzers = new ArrayList<Analyzer>();

    public Group(Processor parent) {
        super(parent);
    }

    void add(File jar) throws Exception {
        add(new Jar(jar));
    }

    void add(Jar jar) throws Exception {
        Analyzer analyzer = new Analyzer(this);
        analyzer.setJar(jar);
        analyzer.analyze();
        analyzers.add(analyzer);
    }

    void analyze() {
        circular();
    }

    Map<String, List<Analyzer>> exports;

    void circular() {
        // Create an index for all exporters package -> analyzers
        for (Analyzer analyzer : analyzers) {
            Set<String> ps = analyzer.getExports().keySet();
            for (String p : ps) {
                if (exports.containsKey(p))
                    exports.get(p).add(analyzer);
                else
                    exports.put(p, Arrays.asList(analyzer));
            }
        }

        List<String> paths = new ArrayList<String>();
        for (Analyzer analyzer : analyzers) {   
            traverse(new Path(null, ".", analyzer), paths );
        }

    }

    static class Path {
        final Analyzer analyzer;
        final String   pack;
        final Path     previous;
        
        public Path(Path path, String pack, Analyzer analyzer) {
            this.analyzer = analyzer;
            this.previous = path;
            this.pack = pack;
        }

        boolean visited(Analyzer analyzer) {
            return this.analyzer == analyzer || previous == null || previous.visited(analyzer);
        }
    }

    void traverse(Path path,
            List<String> paths) {
        
        try {
            for (String p : path.analyzer.getImports().keySet()) {
                List<Analyzer> from = exports.get(p);
                if (from != null) {
                    for (Analyzer f : from) {
                        
           //             traverse(f, visited, paths);
                    }
                }
            }
        } finally {
         //   visited.remove(analyzer);
        }
    }
}
