// Package batch implements the Azure ARM Batch service API version 2020-09-01.12.0.
//
// A client for issuing REST requests to the Azure Batch service.
package batch

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// BaseClient is the base client for Batch.
type BaseClient struct {
	autorest.Client
	BatchURL string
}

// New creates an instance of the BaseClient client.
func New(batchURL string) BaseClient {
	return NewWithoutDefaults(batchURL)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(batchURL string) BaseClient {
	return BaseClient{
		Client:   autorest.NewClientWithUserAgent(UserAgent()),
		BatchURL: batchURL,
	}
}
