package rfc3961

import "testing"

func TestFixWeakKey(t *testing.T) {
	var weakKeys = []struct {
		key      []byte
		lastbyte byte
	}{
		{[]byte{0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01}, byte(0xF1)},
		{[]byte{0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE}, byte(0x0E)},
		{[]byte{0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1}, byte(0x01)},
		{[]byte{0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E}, byte(0xFE)},
		{[]byte{0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E}, byte(0xFE)},
		{[]byte{0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x01}, byte(0xF1)},
		{[]byte{0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1}, byte(0x01)},
		{[]byte{0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x01}, byte(0xF1)},
		{[]byte{0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE}, byte(0x0E)},
		{[]byte{0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01}, byte(0xF1)},
		{[]byte{0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1}, byte(0x01)},
		{[]byte{0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E}, byte(0xFE)},
		{[]byte{0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE}, byte(0x0E)},
		{[]byte{0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E}, byte(0xFE)},
		{[]byte{0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE}, byte(0x0E)},
		{[]byte{0xFE, 0x2F, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1}, byte(0xF1)}, // Non weak key
	}
	for i, k := range weakKeys {
		b := fixWeakKey(k.key)
		if b[7] != weakKeys[i].lastbyte {
			t.Errorf("key not fixed correctly %X - %X", b, weakKeys[i].lastbyte)
		}
	}
}
