/*========================== begin_copyright_notice ============================

Copyright (C) 2017-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

INLINE char2 __attribute__((overloadable)) __spirv_ocl_shuffle(char2 v, char2 m) {
  char2 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  return ret;
}

INLINE char2 __attribute__((overloadable)) __spirv_ocl_shuffle(char4 v, char2 m) {
  char2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  return ret;
}

INLINE char2 __attribute__((overloadable)) __spirv_ocl_shuffle(char8 v, char2 m) {
  char2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  return ret;
}

INLINE char2 __attribute__((overloadable)) __spirv_ocl_shuffle(char16 v, char2 m) {
  char2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  return ret;
}

INLINE char4 __attribute__((overloadable)) __spirv_ocl_shuffle(char2 v, char4 m) {
  char4 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  return ret;
}

INLINE char4 __attribute__((overloadable)) __spirv_ocl_shuffle(char4 v, char4 m) {
  char4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  return ret;
}

INLINE char4 __attribute__((overloadable)) __spirv_ocl_shuffle(char8 v, char4 m) {
  char4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  return ret;
}

INLINE char4 __attribute__((overloadable)) __spirv_ocl_shuffle(char16 v, char4 m) {
  char4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  return ret;
}

INLINE char8 __attribute__((overloadable)) __spirv_ocl_shuffle(char2 v, char8 m) {
  char8 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  return ret;
}

INLINE char8 __attribute__((overloadable)) __spirv_ocl_shuffle(char4 v, char8 m) {
  char8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  return ret;
}

INLINE char8 __attribute__((overloadable)) __spirv_ocl_shuffle(char8 v, char8 m) {
  char8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  return ret;
}

INLINE char8 __attribute__((overloadable)) __spirv_ocl_shuffle(char16 v, char8 m) {
  char8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  return ret;
}

INLINE char16 __attribute__((overloadable)) __spirv_ocl_shuffle(char2 v, char16 m) {
  char16 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x1) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1) == 0x1) ? v.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x1) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1) == 0x1) ? v.s1 : ret.s9;

  ret.sa = ((m.sa & 0x1) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1) == 0x1) ? v.s1 : ret.sa;

  ret.sb = ((m.sb & 0x1) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1) == 0x1) ? v.s1 : ret.sb;

  ret.sc = ((m.sc & 0x1) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1) == 0x1) ? v.s1 : ret.sc;

  ret.sd = ((m.sd & 0x1) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1) == 0x1) ? v.s1 : ret.sd;

  ret.se = ((m.se & 0x1) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x1) == 0x1) ? v.s1 : ret.se;

  ret.sf = ((m.sf & 0x1) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1) == 0x1) ? v.s1 : ret.sf;

  return ret;
}

INLINE char16 __attribute__((overloadable)) __spirv_ocl_shuffle(char4 v, char16 m) {
  char16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v.s3 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v.s3 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v.s3 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v.s3 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v.s3 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v.s3 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v.s3 : ret.sf;

  return ret;
}

INLINE char16 __attribute__((overloadable)) __spirv_ocl_shuffle(char8 v, char16 m) {
  char16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v.s7 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v.s7 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v.s7 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v.s7 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v.s7 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v.s7 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v.s7 : ret.sf;

  return ret;
}

INLINE char16 __attribute__((overloadable)) __spirv_ocl_shuffle(char16 v, char16 m) {
  char16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v.sa : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v.sb : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v.sc : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v.sd : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v.se : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v.sf : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v.sa : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v.sb : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v.sc : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v.sd : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v.se : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v.sf : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v.s8 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v.s9 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v.sa : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v.sb : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v.sc : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v.sd : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v.se : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v.sf : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v.s8 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v.s9 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v.sa : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v.sb : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v.sc : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v.sd : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v.se : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v.sf : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v.s8 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v.s9 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v.sa : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v.sb : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v.sc : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v.sd : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v.se : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v.sf : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v.s8 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v.s9 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v.sa : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v.sb : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v.sc : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v.sd : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v.se : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v.sf : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v.s8 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v.s9 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v.sa : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v.sb : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v.sc : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v.sd : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v.se : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v.sf : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v.s8 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v.s9 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v.sa : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v.sb : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v.sc : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v.sd : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v.se : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v.sf : ret.sf;

  return ret;
}


INLINE short2 __attribute__((overloadable)) __spirv_ocl_shuffle(short2 v, short2 m) {
  short2 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  return ret;
}

INLINE short2 __attribute__((overloadable)) __spirv_ocl_shuffle(short4 v, short2 m) {
  short2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  return ret;
}

INLINE short2 __attribute__((overloadable)) __spirv_ocl_shuffle(short8 v, short2 m) {
  short2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  return ret;
}

INLINE short2 __attribute__((overloadable)) __spirv_ocl_shuffle(short16 v, short2 m) {
  short2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  return ret;
}

INLINE short4 __attribute__((overloadable)) __spirv_ocl_shuffle(short2 v, short4 m) {
  short4 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  return ret;
}

INLINE short4 __attribute__((overloadable)) __spirv_ocl_shuffle(short4 v, short4 m) {
  short4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  return ret;
}

INLINE short4 __attribute__((overloadable)) __spirv_ocl_shuffle(short8 v, short4 m) {
  short4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  return ret;
}

INLINE short4 __attribute__((overloadable)) __spirv_ocl_shuffle(short16 v, short4 m) {
  short4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  return ret;
}

INLINE short8 __attribute__((overloadable)) __spirv_ocl_shuffle(short2 v, short8 m) {
  short8 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  return ret;
}

INLINE short8 __attribute__((overloadable)) __spirv_ocl_shuffle(short4 v, short8 m) {
  short8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  return ret;
}

INLINE short8 __attribute__((overloadable)) __spirv_ocl_shuffle(short8 v, short8 m) {
  short8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  return ret;
}

INLINE short8 __attribute__((overloadable)) __spirv_ocl_shuffle(short16 v, short8 m) {
  short8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  return ret;
}

INLINE short16 __attribute__((overloadable)) __spirv_ocl_shuffle(short2 v, short16 m) {
  short16 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x1) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1) == 0x1) ? v.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x1) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1) == 0x1) ? v.s1 : ret.s9;

  ret.sa = ((m.sa & 0x1) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1) == 0x1) ? v.s1 : ret.sa;

  ret.sb = ((m.sb & 0x1) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1) == 0x1) ? v.s1 : ret.sb;

  ret.sc = ((m.sc & 0x1) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1) == 0x1) ? v.s1 : ret.sc;

  ret.sd = ((m.sd & 0x1) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1) == 0x1) ? v.s1 : ret.sd;

  ret.se = ((m.se & 0x1) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x1) == 0x1) ? v.s1 : ret.se;

  ret.sf = ((m.sf & 0x1) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1) == 0x1) ? v.s1 : ret.sf;

  return ret;
}

INLINE short16 __attribute__((overloadable)) __spirv_ocl_shuffle(short4 v, short16 m) {
  short16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v.s3 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v.s3 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v.s3 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v.s3 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v.s3 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v.s3 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v.s3 : ret.sf;

  return ret;
}

INLINE short16 __attribute__((overloadable)) __spirv_ocl_shuffle(short8 v, short16 m) {
  short16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v.s7 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v.s7 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v.s7 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v.s7 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v.s7 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v.s7 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v.s7 : ret.sf;

  return ret;
}

INLINE short16 __attribute__((overloadable)) __spirv_ocl_shuffle(short16 v, short16 m) {
  short16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v.sa : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v.sb : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v.sc : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v.sd : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v.se : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v.sf : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v.sa : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v.sb : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v.sc : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v.sd : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v.se : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v.sf : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v.s8 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v.s9 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v.sa : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v.sb : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v.sc : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v.sd : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v.se : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v.sf : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v.s8 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v.s9 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v.sa : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v.sb : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v.sc : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v.sd : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v.se : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v.sf : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v.s8 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v.s9 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v.sa : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v.sb : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v.sc : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v.sd : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v.se : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v.sf : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v.s8 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v.s9 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v.sa : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v.sb : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v.sc : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v.sd : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v.se : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v.sf : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v.s8 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v.s9 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v.sa : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v.sb : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v.sc : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v.sd : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v.se : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v.sf : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v.s8 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v.s9 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v.sa : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v.sb : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v.sc : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v.sd : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v.se : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v.sf : ret.sf;

  return ret;
}

INLINE int2 __attribute__((overloadable)) __spirv_ocl_shuffle(int2 v, int2 m) {
  int2 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  return ret;
}

INLINE int2 __attribute__((overloadable)) __spirv_ocl_shuffle(int4 v, int2 m) {
  int2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  return ret;
}

INLINE int2 __attribute__((overloadable)) __spirv_ocl_shuffle(int8 v, int2 m) {
  int2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  return ret;
}

INLINE int2 __attribute__((overloadable)) __spirv_ocl_shuffle(int16 v, int2 m) {
  int2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  return ret;
}

INLINE int4 __attribute__((overloadable)) __spirv_ocl_shuffle(int2 v, int4 m) {
  int4 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  return ret;
}

INLINE int4 __attribute__((overloadable)) __spirv_ocl_shuffle(int4 v, int4 m) {
  int4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  return ret;
}

INLINE int4 __attribute__((overloadable)) __spirv_ocl_shuffle(int8 v, int4 m) {
  int4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  return ret;
}

INLINE int4 __attribute__((overloadable)) __spirv_ocl_shuffle(int16 v, int4 m) {
  int4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  return ret;
}

INLINE int8 __attribute__((overloadable)) __spirv_ocl_shuffle(int2 v, int8 m) {
  int8 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  return ret;
}

INLINE int8 __attribute__((overloadable)) __spirv_ocl_shuffle(int4 v, int8 m) {
  int8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  return ret;
}

INLINE int8 __attribute__((overloadable)) __spirv_ocl_shuffle(int8 v, int8 m) {
  int8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  return ret;
}

INLINE int8 __attribute__((overloadable)) __spirv_ocl_shuffle(int16 v, int8 m) {
  int8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  return ret;
}

INLINE int16 __attribute__((overloadable)) __spirv_ocl_shuffle(int2 v, int16 m) {
  int16 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x1) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1) == 0x1) ? v.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x1) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1) == 0x1) ? v.s1 : ret.s9;

  ret.sa = ((m.sa & 0x1) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1) == 0x1) ? v.s1 : ret.sa;

  ret.sb = ((m.sb & 0x1) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1) == 0x1) ? v.s1 : ret.sb;

  ret.sc = ((m.sc & 0x1) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1) == 0x1) ? v.s1 : ret.sc;

  ret.sd = ((m.sd & 0x1) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1) == 0x1) ? v.s1 : ret.sd;

  ret.se = ((m.se & 0x1) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x1) == 0x1) ? v.s1 : ret.se;

  ret.sf = ((m.sf & 0x1) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1) == 0x1) ? v.s1 : ret.sf;

  return ret;
}

INLINE int16 __attribute__((overloadable)) __spirv_ocl_shuffle(int4 v, int16 m) {
  int16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v.s3 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v.s3 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v.s3 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v.s3 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v.s3 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v.s3 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v.s3 : ret.sf;

  return ret;
}

INLINE int16 __attribute__((overloadable)) __spirv_ocl_shuffle(int8 v, int16 m) {
  int16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v.s7 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v.s7 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v.s7 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v.s7 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v.s7 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v.s7 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v.s7 : ret.sf;

  return ret;
}

INLINE int16 __attribute__((overloadable)) __spirv_ocl_shuffle(int16 v, int16 m) {
  int16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v.sa : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v.sb : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v.sc : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v.sd : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v.se : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v.sf : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v.sa : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v.sb : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v.sc : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v.sd : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v.se : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v.sf : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v.s8 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v.s9 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v.sa : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v.sb : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v.sc : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v.sd : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v.se : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v.sf : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v.s8 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v.s9 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v.sa : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v.sb : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v.sc : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v.sd : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v.se : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v.sf : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v.s8 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v.s9 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v.sa : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v.sb : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v.sc : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v.sd : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v.se : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v.sf : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v.s8 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v.s9 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v.sa : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v.sb : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v.sc : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v.sd : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v.se : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v.sf : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v.s8 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v.s9 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v.sa : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v.sb : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v.sc : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v.sd : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v.se : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v.sf : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v.s8 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v.s9 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v.sa : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v.sb : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v.sc : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v.sd : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v.se : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v.sf : ret.sf;

  return ret;
}

INLINE long2 __attribute__((overloadable)) __spirv_ocl_shuffle(long2 v, long2 m) {
  long2 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  return ret;
}

INLINE long2 __attribute__((overloadable)) __spirv_ocl_shuffle(long4 v, long2 m) {
  long2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  return ret;
}

INLINE long2 __attribute__((overloadable)) __spirv_ocl_shuffle(long8 v, long2 m) {
  long2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  return ret;
}

INLINE long2 __attribute__((overloadable)) __spirv_ocl_shuffle(long16 v, long2 m) {
  long2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  return ret;
}

INLINE long4 __attribute__((overloadable)) __spirv_ocl_shuffle(long2 v, long4 m) {
  long4 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  return ret;
}

INLINE long4 __attribute__((overloadable)) __spirv_ocl_shuffle(long4 v, long4 m) {
  long4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  return ret;
}

INLINE long4 __attribute__((overloadable)) __spirv_ocl_shuffle(long8 v, long4 m) {
  long4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  return ret;
}

INLINE long4 __attribute__((overloadable)) __spirv_ocl_shuffle(long16 v, long4 m) {
  long4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  return ret;
}

INLINE long8 __attribute__((overloadable)) __spirv_ocl_shuffle(long2 v, long8 m) {
  long8 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  return ret;
}

INLINE long8 __attribute__((overloadable)) __spirv_ocl_shuffle(long4 v, long8 m) {
  long8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  return ret;
}

INLINE long8 __attribute__((overloadable)) __spirv_ocl_shuffle(long8 v, long8 m) {
  long8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  return ret;
}

INLINE long8 __attribute__((overloadable)) __spirv_ocl_shuffle(long16 v, long8 m) {
  long8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  return ret;
}

INLINE long16 __attribute__((overloadable)) __spirv_ocl_shuffle(long2 v, long16 m) {
  long16 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x1) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1) == 0x1) ? v.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x1) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1) == 0x1) ? v.s1 : ret.s9;

  ret.sa = ((m.sa & 0x1) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1) == 0x1) ? v.s1 : ret.sa;

  ret.sb = ((m.sb & 0x1) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1) == 0x1) ? v.s1 : ret.sb;

  ret.sc = ((m.sc & 0x1) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1) == 0x1) ? v.s1 : ret.sc;

  ret.sd = ((m.sd & 0x1) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1) == 0x1) ? v.s1 : ret.sd;

  ret.se = ((m.se & 0x1) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x1) == 0x1) ? v.s1 : ret.se;

  ret.sf = ((m.sf & 0x1) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1) == 0x1) ? v.s1 : ret.sf;

  return ret;
}

INLINE long16 __attribute__((overloadable)) __spirv_ocl_shuffle(long4 v, long16 m) {
  long16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v.s3 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v.s3 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v.s3 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v.s3 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v.s3 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v.s3 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v.s3 : ret.sf;

  return ret;
}

INLINE long16 __attribute__((overloadable)) __spirv_ocl_shuffle(long8 v, long16 m) {
  long16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v.s7 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v.s7 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v.s7 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v.s7 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v.s7 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v.s7 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v.s7 : ret.sf;

  return ret;
}

INLINE long16 __attribute__((overloadable)) __spirv_ocl_shuffle(long16 v, long16 m) {
  long16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v.sa : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v.sb : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v.sc : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v.sd : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v.se : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v.sf : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v.sa : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v.sb : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v.sc : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v.sd : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v.se : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v.sf : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v.s8 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v.s9 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v.sa : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v.sb : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v.sc : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v.sd : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v.se : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v.sf : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v.s8 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v.s9 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v.sa : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v.sb : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v.sc : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v.sd : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v.se : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v.sf : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v.s8 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v.s9 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v.sa : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v.sb : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v.sc : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v.sd : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v.se : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v.sf : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v.s8 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v.s9 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v.sa : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v.sb : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v.sc : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v.sd : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v.se : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v.sf : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v.s8 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v.s9 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v.sa : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v.sb : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v.sc : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v.sd : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v.se : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v.sf : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v.s8 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v.s9 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v.sa : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v.sb : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v.sc : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v.sd : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v.se : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v.sf : ret.sf;

  return ret;
}

INLINE float2 __attribute__((overloadable)) __spirv_ocl_shuffle(float2 v, int2 m) {
  float2 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  return ret;
}

INLINE float2 __attribute__((overloadable)) __spirv_ocl_shuffle(float4 v, int2 m) {
  float2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  return ret;
}

INLINE float2 __attribute__((overloadable)) __spirv_ocl_shuffle(float8 v, int2 m) {
  float2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  return ret;
}

INLINE float2 __attribute__((overloadable)) __spirv_ocl_shuffle(float16 v, int2 m) {
  float2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  return ret;
}

INLINE float4 __attribute__((overloadable)) __spirv_ocl_shuffle(float2 v, int4 m) {
  float4 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  return ret;
}

INLINE float4 __attribute__((overloadable)) __spirv_ocl_shuffle(float4 v, int4 m) {
  float4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  return ret;
}

INLINE float4 __attribute__((overloadable)) __spirv_ocl_shuffle(float8 v, int4 m) {
  float4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  return ret;
}

INLINE float4 __attribute__((overloadable)) __spirv_ocl_shuffle(float16 v, int4 m) {
  float4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  return ret;
}

INLINE float8 __attribute__((overloadable)) __spirv_ocl_shuffle(float2 v, int8 m) {
  float8 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  return ret;
}

INLINE float8 __attribute__((overloadable)) __spirv_ocl_shuffle(float4 v, int8 m) {
  float8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  return ret;
}

INLINE float8 __attribute__((overloadable)) __spirv_ocl_shuffle(float8 v, int8 m) {
  float8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  return ret;
}

INLINE float8 __attribute__((overloadable)) __spirv_ocl_shuffle(float16 v, int8 m) {
  float8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  return ret;
}

INLINE float16 __attribute__((overloadable)) __spirv_ocl_shuffle(float2 v, int16 m) {
  float16 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x1) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1) == 0x1) ? v.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x1) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1) == 0x1) ? v.s1 : ret.s9;

  ret.sa = ((m.sa & 0x1) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1) == 0x1) ? v.s1 : ret.sa;

  ret.sb = ((m.sb & 0x1) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1) == 0x1) ? v.s1 : ret.sb;

  ret.sc = ((m.sc & 0x1) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1) == 0x1) ? v.s1 : ret.sc;

  ret.sd = ((m.sd & 0x1) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1) == 0x1) ? v.s1 : ret.sd;

  ret.se = ((m.se & 0x1) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x1) == 0x1) ? v.s1 : ret.se;

  ret.sf = ((m.sf & 0x1) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1) == 0x1) ? v.s1 : ret.sf;

  return ret;
}

INLINE float16 __attribute__((overloadable)) __spirv_ocl_shuffle(float4 v, int16 m) {
  float16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v.s3 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v.s3 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v.s3 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v.s3 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v.s3 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v.s3 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v.s3 : ret.sf;

  return ret;
}

INLINE float16 __attribute__((overloadable)) __spirv_ocl_shuffle(float8 v, int16 m) {
  float16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v.s7 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v.s7 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v.s7 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v.s7 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v.s7 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v.s7 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v.s7 : ret.sf;

  return ret;
}

INLINE float16 __attribute__((overloadable)) __spirv_ocl_shuffle(float16 v, int16 m) {
  float16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v.sa : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v.sb : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v.sc : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v.sd : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v.se : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v.sf : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v.sa : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v.sb : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v.sc : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v.sd : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v.se : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v.sf : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v.s8 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v.s9 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v.sa : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v.sb : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v.sc : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v.sd : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v.se : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v.sf : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v.s8 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v.s9 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v.sa : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v.sb : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v.sc : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v.sd : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v.se : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v.sf : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v.s8 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v.s9 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v.sa : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v.sb : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v.sc : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v.sd : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v.se : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v.sf : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v.s8 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v.s9 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v.sa : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v.sb : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v.sc : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v.sd : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v.se : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v.sf : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v.s8 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v.s9 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v.sa : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v.sb : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v.sc : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v.sd : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v.se : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v.sf : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v.s8 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v.s9 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v.sa : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v.sb : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v.sc : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v.sd : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v.se : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v.sf : ret.sf;

  return ret;
}

INLINE char2 __attribute__((overloadable)) __spirv_ocl_shuffle2(char2 v0, char2 v1, char2 m) {
  char2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  return ret;
}

INLINE char2 __attribute__((overloadable)) __spirv_ocl_shuffle2(char4 v0, char4 v1, char2 m) {
  char2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  return ret;
}

INLINE char2 __attribute__((overloadable)) __spirv_ocl_shuffle2(char8 v0, char8 v1, char2 m) {
  char2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  return ret;
}

INLINE char2 __attribute__((overloadable)) __spirv_ocl_shuffle2(char16 v0, char16 v1, char2 m) {
  char2 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  return ret;
}

INLINE char4 __attribute__((overloadable)) __spirv_ocl_shuffle2(char2 v0, char2 v1, char4 m) {
  char4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  return ret;
}

INLINE char4 __attribute__((overloadable)) __spirv_ocl_shuffle2(char4 v0, char4 v1, char4 m) {
  char4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  return ret;
}

INLINE char4 __attribute__((overloadable)) __spirv_ocl_shuffle2(char8 v0, char8 v1, char4 m) {
  char4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  return ret;
}

INLINE char4 __attribute__((overloadable)) __spirv_ocl_shuffle2(char16 v0, char16 v1, char4 m) {
  char4 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  return ret;
}

INLINE char8 __attribute__((overloadable)) __spirv_ocl_shuffle2(char2 v0, char2 v1, char8 m) {
  char8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  return ret;
}

INLINE char8 __attribute__((overloadable)) __spirv_ocl_shuffle2(char4 v0, char4 v1, char8 m) {
  char8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  return ret;
}

INLINE char8 __attribute__((overloadable)) __spirv_ocl_shuffle2(char8 v0, char8 v1, char8 m) {
  char8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  return ret;
}

INLINE char8 __attribute__((overloadable)) __spirv_ocl_shuffle2(char16 v0, char16 v1, char8 m) {
  char8 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  return ret;
}

INLINE char16 __attribute__((overloadable)) __spirv_ocl_shuffle2(char2 v0, char2 v1, char16 m) {
  char16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v1.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v1.s1 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v1.s1 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v1.s1 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v1.s1 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v1.s1 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v1.s1 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v1.s1 : ret.sf;

  return ret;
}

INLINE char16 __attribute__((overloadable)) __spirv_ocl_shuffle2(char4 v0, char4 v1, char16 m) {
  char16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v1.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v1.s3 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v1.s3 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v1.s3 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v1.s3 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v1.s3 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v1.s3 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v1.s3 : ret.sf;

  return ret;
}

INLINE char16 __attribute__((overloadable)) __spirv_ocl_shuffle2(char8 v0, char8 v1, char16 m) {
  char16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v1.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v1.s7 : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v1.s7 : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v1.s7 : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v1.s7 : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v1.s7 : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v1.s7 : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v1.s7 : ret.sf;

  return ret;
}

INLINE char16 __attribute__((overloadable)) __spirv_ocl_shuffle2(char16 v0, char16 v1, char16 m) {
  char16 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  ret.s8 = ((m.s8 & 0x1f) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x8) ? v0.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x9) ? v0.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xa) ? v0.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xb) ? v0.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xc) ? v0.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xd) ? v0.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xe) ? v0.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xf) ? v0.sf : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x10) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x11) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x12) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x13) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x14) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x15) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x16) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x17) ? v1.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x18) ? v1.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x19) ? v1.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1a) ? v1.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1b) ? v1.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1c) ? v1.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1d) ? v1.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1e) ? v1.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1f) ? v1.sf : ret.s8;

  ret.s9 = ((m.s9 & 0x1f) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x8) ? v0.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x9) ? v0.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xa) ? v0.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xb) ? v0.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xc) ? v0.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xd) ? v0.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xe) ? v0.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xf) ? v0.sf : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x10) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x11) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x12) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x13) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x14) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x15) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x16) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x17) ? v1.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x18) ? v1.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x19) ? v1.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1a) ? v1.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1b) ? v1.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1c) ? v1.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1d) ? v1.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1e) ? v1.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1f) ? v1.sf : ret.s9;

  ret.sa = ((m.sa & 0x1f) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x8) ? v0.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x9) ? v0.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xa) ? v0.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xb) ? v0.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xc) ? v0.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xd) ? v0.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xe) ? v0.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xf) ? v0.sf : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x10) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x11) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x12) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x13) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x14) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x15) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x16) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x17) ? v1.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x18) ? v1.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x19) ? v1.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1a) ? v1.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1b) ? v1.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1c) ? v1.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1d) ? v1.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1e) ? v1.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1f) ? v1.sf : ret.sa;

  ret.sb = ((m.sb & 0x1f) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x8) ? v0.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x9) ? v0.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xa) ? v0.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xb) ? v0.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xc) ? v0.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xd) ? v0.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xe) ? v0.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xf) ? v0.sf : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x10) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x11) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x12) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x13) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x14) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x15) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x16) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x17) ? v1.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x18) ? v1.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x19) ? v1.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1a) ? v1.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1b) ? v1.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1c) ? v1.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1d) ? v1.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1e) ? v1.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1f) ? v1.sf : ret.sb;

  ret.sc = ((m.sc & 0x1f) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x8) ? v0.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x9) ? v0.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xa) ? v0.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xb) ? v0.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xc) ? v0.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xd) ? v0.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xe) ? v0.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xf) ? v0.sf : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x10) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x11) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x12) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x13) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x14) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x15) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x16) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x17) ? v1.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x18) ? v1.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x19) ? v1.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1a) ? v1.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1b) ? v1.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1c) ? v1.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1d) ? v1.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1e) ? v1.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1f) ? v1.sf : ret.sc;

  ret.sd = ((m.sd & 0x1f) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x8) ? v0.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x9) ? v0.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xa) ? v0.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xb) ? v0.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xc) ? v0.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xd) ? v0.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xe) ? v0.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xf) ? v0.sf : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x10) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x11) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x12) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x13) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x14) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x15) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x16) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x17) ? v1.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x18) ? v1.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x19) ? v1.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1a) ? v1.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1b) ? v1.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1c) ? v1.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1d) ? v1.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1e) ? v1.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1f) ? v1.sf : ret.sd;

  ret.se = ((m.se & 0x1f) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x8) ? v0.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x9) ? v0.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0xa) ? v0.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0xb) ? v0.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0xc) ? v0.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0xd) ? v0.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0xe) ? v0.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0xf) ? v0.sf : ret.se;
  ret.se = ((m.se & 0x1f) == 0x10) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x11) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x12) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x13) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x14) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x15) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x16) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x17) ? v1.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x18) ? v1.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x19) ? v1.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1a) ? v1.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1b) ? v1.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1c) ? v1.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1d) ? v1.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1e) ? v1.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1f) ? v1.sf : ret.se;

  ret.sf = ((m.sf & 0x1f) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x8) ? v0.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x9) ? v0.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xa) ? v0.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xb) ? v0.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xc) ? v0.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xd) ? v0.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xe) ? v0.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xf) ? v0.sf : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x10) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x11) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x12) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x13) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x14) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x15) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x16) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x17) ? v1.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x18) ? v1.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x19) ? v1.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1a) ? v1.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1b) ? v1.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1c) ? v1.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1d) ? v1.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1e) ? v1.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1f) ? v1.sf : ret.sf;

  return ret;
}

INLINE short2 __attribute__((overloadable)) __spirv_ocl_shuffle2(short2 v0, short2 v1, short2 m) {
  short2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  return ret;
}

INLINE short2 __attribute__((overloadable)) __spirv_ocl_shuffle2(short4 v0, short4 v1, short2 m) {
  short2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  return ret;
}

INLINE short2 __attribute__((overloadable)) __spirv_ocl_shuffle2(short8 v0, short8 v1, short2 m) {
  short2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  return ret;
}

INLINE short2 __attribute__((overloadable)) __spirv_ocl_shuffle2(short16 v0, short16 v1, short2 m) {
  short2 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  return ret;
}

INLINE short4 __attribute__((overloadable)) __spirv_ocl_shuffle2(short2 v0, short2 v1, short4 m) {
  short4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  return ret;
}

INLINE short4 __attribute__((overloadable)) __spirv_ocl_shuffle2(short4 v0, short4 v1, short4 m) {
  short4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  return ret;
}

INLINE short4 __attribute__((overloadable)) __spirv_ocl_shuffle2(short8 v0, short8 v1, short4 m) {
  short4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  return ret;
}

INLINE short4 __attribute__((overloadable)) __spirv_ocl_shuffle2(short16 v0, short16 v1, short4 m) {
  short4 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  return ret;
}

INLINE short8 __attribute__((overloadable)) __spirv_ocl_shuffle2(short2 v0, short2 v1, short8 m) {
  short8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  return ret;
}

INLINE short8 __attribute__((overloadable)) __spirv_ocl_shuffle2(short4 v0, short4 v1, short8 m) {
  short8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  return ret;
}

INLINE short8 __attribute__((overloadable)) __spirv_ocl_shuffle2(short8 v0, short8 v1, short8 m) {
  short8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  return ret;
}

INLINE short8 __attribute__((overloadable)) __spirv_ocl_shuffle2(short16 v0, short16 v1, short8 m) {
  short8 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  return ret;
}

INLINE short16 __attribute__((overloadable)) __spirv_ocl_shuffle2(short2 v0, short2 v1, short16 m) {
  short16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v1.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v1.s1 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v1.s1 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v1.s1 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v1.s1 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v1.s1 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v1.s1 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v1.s1 : ret.sf;

  return ret;
}

INLINE short16 __attribute__((overloadable)) __spirv_ocl_shuffle2(short4 v0, short4 v1, short16 m) {
  short16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v1.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v1.s3 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v1.s3 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v1.s3 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v1.s3 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v1.s3 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v1.s3 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v1.s3 : ret.sf;

  return ret;
}

INLINE short16 __attribute__((overloadable)) __spirv_ocl_shuffle2(short8 v0, short8 v1, short16 m) {
  short16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v1.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v1.s7 : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v1.s7 : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v1.s7 : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v1.s7 : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v1.s7 : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v1.s7 : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v1.s7 : ret.sf;

  return ret;
}

INLINE short16 __attribute__((overloadable)) __spirv_ocl_shuffle2(short16 v0, short16 v1, short16 m) {
  short16 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  ret.s8 = ((m.s8 & 0x1f) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x8) ? v0.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x9) ? v0.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xa) ? v0.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xb) ? v0.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xc) ? v0.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xd) ? v0.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xe) ? v0.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xf) ? v0.sf : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x10) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x11) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x12) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x13) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x14) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x15) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x16) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x17) ? v1.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x18) ? v1.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x19) ? v1.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1a) ? v1.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1b) ? v1.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1c) ? v1.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1d) ? v1.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1e) ? v1.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1f) ? v1.sf : ret.s8;

  ret.s9 = ((m.s9 & 0x1f) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x8) ? v0.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x9) ? v0.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xa) ? v0.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xb) ? v0.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xc) ? v0.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xd) ? v0.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xe) ? v0.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xf) ? v0.sf : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x10) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x11) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x12) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x13) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x14) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x15) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x16) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x17) ? v1.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x18) ? v1.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x19) ? v1.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1a) ? v1.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1b) ? v1.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1c) ? v1.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1d) ? v1.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1e) ? v1.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1f) ? v1.sf : ret.s9;

  ret.sa = ((m.sa & 0x1f) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x8) ? v0.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x9) ? v0.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xa) ? v0.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xb) ? v0.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xc) ? v0.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xd) ? v0.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xe) ? v0.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xf) ? v0.sf : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x10) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x11) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x12) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x13) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x14) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x15) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x16) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x17) ? v1.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x18) ? v1.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x19) ? v1.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1a) ? v1.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1b) ? v1.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1c) ? v1.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1d) ? v1.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1e) ? v1.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1f) ? v1.sf : ret.sa;

  ret.sb = ((m.sb & 0x1f) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x8) ? v0.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x9) ? v0.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xa) ? v0.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xb) ? v0.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xc) ? v0.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xd) ? v0.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xe) ? v0.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xf) ? v0.sf : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x10) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x11) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x12) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x13) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x14) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x15) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x16) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x17) ? v1.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x18) ? v1.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x19) ? v1.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1a) ? v1.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1b) ? v1.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1c) ? v1.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1d) ? v1.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1e) ? v1.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1f) ? v1.sf : ret.sb;

  ret.sc = ((m.sc & 0x1f) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x8) ? v0.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x9) ? v0.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xa) ? v0.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xb) ? v0.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xc) ? v0.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xd) ? v0.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xe) ? v0.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xf) ? v0.sf : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x10) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x11) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x12) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x13) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x14) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x15) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x16) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x17) ? v1.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x18) ? v1.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x19) ? v1.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1a) ? v1.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1b) ? v1.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1c) ? v1.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1d) ? v1.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1e) ? v1.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1f) ? v1.sf : ret.sc;

  ret.sd = ((m.sd & 0x1f) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x8) ? v0.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x9) ? v0.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xa) ? v0.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xb) ? v0.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xc) ? v0.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xd) ? v0.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xe) ? v0.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xf) ? v0.sf : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x10) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x11) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x12) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x13) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x14) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x15) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x16) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x17) ? v1.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x18) ? v1.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x19) ? v1.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1a) ? v1.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1b) ? v1.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1c) ? v1.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1d) ? v1.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1e) ? v1.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1f) ? v1.sf : ret.sd;

  ret.se = ((m.se & 0x1f) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x8) ? v0.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x9) ? v0.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0xa) ? v0.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0xb) ? v0.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0xc) ? v0.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0xd) ? v0.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0xe) ? v0.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0xf) ? v0.sf : ret.se;
  ret.se = ((m.se & 0x1f) == 0x10) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x11) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x12) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x13) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x14) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x15) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x16) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x17) ? v1.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x18) ? v1.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x19) ? v1.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1a) ? v1.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1b) ? v1.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1c) ? v1.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1d) ? v1.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1e) ? v1.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1f) ? v1.sf : ret.se;

  ret.sf = ((m.sf & 0x1f) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x8) ? v0.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x9) ? v0.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xa) ? v0.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xb) ? v0.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xc) ? v0.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xd) ? v0.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xe) ? v0.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xf) ? v0.sf : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x10) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x11) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x12) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x13) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x14) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x15) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x16) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x17) ? v1.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x18) ? v1.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x19) ? v1.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1a) ? v1.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1b) ? v1.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1c) ? v1.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1d) ? v1.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1e) ? v1.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1f) ? v1.sf : ret.sf;

  return ret;
}

INLINE int2 __attribute__((overloadable)) __spirv_ocl_shuffle2(int2 v0, int2 v1, int2 m) {
  int2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  return ret;
}

INLINE int2 __attribute__((overloadable)) __spirv_ocl_shuffle2(int4 v0, int4 v1, int2 m) {
  int2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  return ret;
}

INLINE int2 __attribute__((overloadable)) __spirv_ocl_shuffle2(int8 v0, int8 v1, int2 m) {
  int2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  return ret;
}

INLINE int2 __attribute__((overloadable)) __spirv_ocl_shuffle2(int16 v0, int16 v1, int2 m) {
  int2 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  return ret;
}

INLINE int4 __attribute__((overloadable)) __spirv_ocl_shuffle2(int2 v0, int2 v1, int4 m) {
  int4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  return ret;
}

INLINE int4 __attribute__((overloadable)) __spirv_ocl_shuffle2(int4 v0, int4 v1, int4 m) {
  int4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  return ret;
}

INLINE int4 __attribute__((overloadable)) __spirv_ocl_shuffle2(int8 v0, int8 v1, int4 m) {
  int4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  return ret;
}

INLINE int4 __attribute__((overloadable)) __spirv_ocl_shuffle2(int16 v0, int16 v1, int4 m) {
  int4 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  return ret;
}

INLINE int8 __attribute__((overloadable)) __spirv_ocl_shuffle2(int2 v0, int2 v1, int8 m) {
  int8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  return ret;
}

INLINE int8 __attribute__((overloadable)) __spirv_ocl_shuffle2(int4 v0, int4 v1, int8 m) {
  int8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  return ret;
}

INLINE int8 __attribute__((overloadable)) __spirv_ocl_shuffle2(int8 v0, int8 v1, int8 m) {
  int8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  return ret;
}

INLINE int8 __attribute__((overloadable)) __spirv_ocl_shuffle2(int16 v0, int16 v1, int8 m) {
  int8 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  return ret;
}

INLINE int16 __attribute__((overloadable)) __spirv_ocl_shuffle2(int2 v0, int2 v1, int16 m) {
  int16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v1.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v1.s1 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v1.s1 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v1.s1 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v1.s1 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v1.s1 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v1.s1 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v1.s1 : ret.sf;

  return ret;
}

INLINE int16 __attribute__((overloadable)) __spirv_ocl_shuffle2(int4 v0, int4 v1, int16 m) {
  int16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v1.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v1.s3 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v1.s3 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v1.s3 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v1.s3 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v1.s3 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v1.s3 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v1.s3 : ret.sf;

  return ret;
}

INLINE int16 __attribute__((overloadable)) __spirv_ocl_shuffle2(int8 v0, int8 v1, int16 m) {
  int16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v1.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v1.s7 : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v1.s7 : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v1.s7 : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v1.s7 : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v1.s7 : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v1.s7 : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v1.s7 : ret.sf;

  return ret;
}

INLINE int16 __attribute__((overloadable)) __spirv_ocl_shuffle2(int16 v0, int16 v1, int16 m) {
  int16 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  ret.s8 = ((m.s8 & 0x1f) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x8) ? v0.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x9) ? v0.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xa) ? v0.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xb) ? v0.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xc) ? v0.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xd) ? v0.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xe) ? v0.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xf) ? v0.sf : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x10) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x11) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x12) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x13) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x14) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x15) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x16) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x17) ? v1.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x18) ? v1.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x19) ? v1.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1a) ? v1.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1b) ? v1.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1c) ? v1.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1d) ? v1.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1e) ? v1.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1f) ? v1.sf : ret.s8;

  ret.s9 = ((m.s9 & 0x1f) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x8) ? v0.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x9) ? v0.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xa) ? v0.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xb) ? v0.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xc) ? v0.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xd) ? v0.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xe) ? v0.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xf) ? v0.sf : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x10) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x11) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x12) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x13) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x14) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x15) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x16) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x17) ? v1.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x18) ? v1.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x19) ? v1.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1a) ? v1.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1b) ? v1.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1c) ? v1.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1d) ? v1.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1e) ? v1.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1f) ? v1.sf : ret.s9;

  ret.sa = ((m.sa & 0x1f) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x8) ? v0.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x9) ? v0.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xa) ? v0.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xb) ? v0.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xc) ? v0.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xd) ? v0.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xe) ? v0.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xf) ? v0.sf : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x10) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x11) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x12) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x13) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x14) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x15) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x16) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x17) ? v1.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x18) ? v1.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x19) ? v1.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1a) ? v1.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1b) ? v1.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1c) ? v1.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1d) ? v1.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1e) ? v1.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1f) ? v1.sf : ret.sa;

  ret.sb = ((m.sb & 0x1f) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x8) ? v0.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x9) ? v0.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xa) ? v0.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xb) ? v0.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xc) ? v0.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xd) ? v0.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xe) ? v0.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xf) ? v0.sf : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x10) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x11) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x12) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x13) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x14) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x15) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x16) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x17) ? v1.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x18) ? v1.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x19) ? v1.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1a) ? v1.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1b) ? v1.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1c) ? v1.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1d) ? v1.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1e) ? v1.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1f) ? v1.sf : ret.sb;

  ret.sc = ((m.sc & 0x1f) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x8) ? v0.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x9) ? v0.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xa) ? v0.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xb) ? v0.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xc) ? v0.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xd) ? v0.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xe) ? v0.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xf) ? v0.sf : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x10) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x11) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x12) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x13) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x14) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x15) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x16) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x17) ? v1.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x18) ? v1.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x19) ? v1.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1a) ? v1.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1b) ? v1.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1c) ? v1.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1d) ? v1.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1e) ? v1.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1f) ? v1.sf : ret.sc;

  ret.sd = ((m.sd & 0x1f) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x8) ? v0.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x9) ? v0.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xa) ? v0.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xb) ? v0.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xc) ? v0.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xd) ? v0.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xe) ? v0.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xf) ? v0.sf : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x10) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x11) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x12) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x13) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x14) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x15) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x16) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x17) ? v1.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x18) ? v1.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x19) ? v1.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1a) ? v1.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1b) ? v1.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1c) ? v1.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1d) ? v1.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1e) ? v1.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1f) ? v1.sf : ret.sd;

  ret.se = ((m.se & 0x1f) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x8) ? v0.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x9) ? v0.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0xa) ? v0.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0xb) ? v0.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0xc) ? v0.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0xd) ? v0.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0xe) ? v0.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0xf) ? v0.sf : ret.se;
  ret.se = ((m.se & 0x1f) == 0x10) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x11) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x12) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x13) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x14) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x15) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x16) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x17) ? v1.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x18) ? v1.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x19) ? v1.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1a) ? v1.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1b) ? v1.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1c) ? v1.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1d) ? v1.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1e) ? v1.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1f) ? v1.sf : ret.se;

  ret.sf = ((m.sf & 0x1f) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x8) ? v0.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x9) ? v0.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xa) ? v0.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xb) ? v0.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xc) ? v0.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xd) ? v0.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xe) ? v0.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xf) ? v0.sf : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x10) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x11) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x12) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x13) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x14) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x15) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x16) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x17) ? v1.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x18) ? v1.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x19) ? v1.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1a) ? v1.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1b) ? v1.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1c) ? v1.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1d) ? v1.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1e) ? v1.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1f) ? v1.sf : ret.sf;

  return ret;
}

INLINE long2 __attribute__((overloadable)) __spirv_ocl_shuffle2(long2 v0, long2 v1, long2 m) {
  long2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  return ret;
}

INLINE long2 __attribute__((overloadable)) __spirv_ocl_shuffle2(long4 v0, long4 v1, long2 m) {
  long2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  return ret;
}

INLINE long2 __attribute__((overloadable)) __spirv_ocl_shuffle2(long8 v0, long8 v1, long2 m) {
  long2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  return ret;
}

INLINE long2 __attribute__((overloadable)) __spirv_ocl_shuffle2(long16 v0, long16 v1, long2 m) {
  long2 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  return ret;
}

INLINE long4 __attribute__((overloadable)) __spirv_ocl_shuffle2(long2 v0, long2 v1, long4 m) {
  long4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  return ret;
}

INLINE long4 __attribute__((overloadable)) __spirv_ocl_shuffle2(long4 v0, long4 v1, long4 m) {
  long4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  return ret;
}

INLINE long4 __attribute__((overloadable)) __spirv_ocl_shuffle2(long8 v0, long8 v1, long4 m) {
  long4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  return ret;
}

INLINE long4 __attribute__((overloadable)) __spirv_ocl_shuffle2(long16 v0, long16 v1, long4 m) {
  long4 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  return ret;
}

INLINE long8 __attribute__((overloadable)) __spirv_ocl_shuffle2(long2 v0, long2 v1, long8 m) {
  long8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  return ret;
}

INLINE long8 __attribute__((overloadable)) __spirv_ocl_shuffle2(long4 v0, long4 v1, long8 m) {
  long8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  return ret;
}

INLINE long8 __attribute__((overloadable)) __spirv_ocl_shuffle2(long8 v0, long8 v1, long8 m) {
  long8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  return ret;
}

INLINE long8 __attribute__((overloadable)) __spirv_ocl_shuffle2(long16 v0, long16 v1, long8 m) {
  long8 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  return ret;
}

INLINE long16 __attribute__((overloadable)) __spirv_ocl_shuffle2(long2 v0, long2 v1, long16 m) {
  long16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v1.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v1.s1 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v1.s1 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v1.s1 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v1.s1 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v1.s1 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v1.s1 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v1.s1 : ret.sf;

  return ret;
}

INLINE long16 __attribute__((overloadable)) __spirv_ocl_shuffle2(long4 v0, long4 v1, long16 m) {
  long16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v1.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v1.s3 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v1.s3 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v1.s3 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v1.s3 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v1.s3 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v1.s3 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v1.s3 : ret.sf;

  return ret;
}

INLINE long16 __attribute__((overloadable)) __spirv_ocl_shuffle2(long8 v0, long8 v1, long16 m) {
  long16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v1.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v1.s7 : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v1.s7 : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v1.s7 : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v1.s7 : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v1.s7 : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v1.s7 : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v1.s7 : ret.sf;

  return ret;
}

INLINE long16 __attribute__((overloadable)) __spirv_ocl_shuffle2(long16 v0, long16 v1, long16 m) {
  long16 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  ret.s8 = ((m.s8 & 0x1f) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x8) ? v0.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x9) ? v0.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xa) ? v0.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xb) ? v0.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xc) ? v0.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xd) ? v0.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xe) ? v0.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xf) ? v0.sf : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x10) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x11) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x12) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x13) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x14) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x15) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x16) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x17) ? v1.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x18) ? v1.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x19) ? v1.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1a) ? v1.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1b) ? v1.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1c) ? v1.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1d) ? v1.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1e) ? v1.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1f) ? v1.sf : ret.s8;

  ret.s9 = ((m.s9 & 0x1f) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x8) ? v0.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x9) ? v0.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xa) ? v0.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xb) ? v0.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xc) ? v0.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xd) ? v0.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xe) ? v0.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xf) ? v0.sf : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x10) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x11) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x12) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x13) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x14) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x15) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x16) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x17) ? v1.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x18) ? v1.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x19) ? v1.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1a) ? v1.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1b) ? v1.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1c) ? v1.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1d) ? v1.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1e) ? v1.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1f) ? v1.sf : ret.s9;

  ret.sa = ((m.sa & 0x1f) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x8) ? v0.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x9) ? v0.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xa) ? v0.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xb) ? v0.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xc) ? v0.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xd) ? v0.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xe) ? v0.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xf) ? v0.sf : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x10) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x11) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x12) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x13) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x14) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x15) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x16) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x17) ? v1.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x18) ? v1.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x19) ? v1.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1a) ? v1.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1b) ? v1.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1c) ? v1.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1d) ? v1.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1e) ? v1.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1f) ? v1.sf : ret.sa;

  ret.sb = ((m.sb & 0x1f) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x8) ? v0.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x9) ? v0.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xa) ? v0.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xb) ? v0.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xc) ? v0.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xd) ? v0.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xe) ? v0.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xf) ? v0.sf : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x10) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x11) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x12) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x13) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x14) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x15) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x16) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x17) ? v1.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x18) ? v1.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x19) ? v1.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1a) ? v1.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1b) ? v1.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1c) ? v1.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1d) ? v1.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1e) ? v1.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1f) ? v1.sf : ret.sb;

  ret.sc = ((m.sc & 0x1f) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x8) ? v0.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x9) ? v0.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xa) ? v0.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xb) ? v0.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xc) ? v0.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xd) ? v0.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xe) ? v0.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xf) ? v0.sf : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x10) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x11) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x12) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x13) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x14) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x15) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x16) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x17) ? v1.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x18) ? v1.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x19) ? v1.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1a) ? v1.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1b) ? v1.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1c) ? v1.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1d) ? v1.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1e) ? v1.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1f) ? v1.sf : ret.sc;

  ret.sd = ((m.sd & 0x1f) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x8) ? v0.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x9) ? v0.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xa) ? v0.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xb) ? v0.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xc) ? v0.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xd) ? v0.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xe) ? v0.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xf) ? v0.sf : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x10) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x11) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x12) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x13) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x14) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x15) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x16) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x17) ? v1.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x18) ? v1.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x19) ? v1.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1a) ? v1.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1b) ? v1.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1c) ? v1.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1d) ? v1.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1e) ? v1.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1f) ? v1.sf : ret.sd;

  ret.se = ((m.se & 0x1f) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x8) ? v0.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x9) ? v0.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0xa) ? v0.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0xb) ? v0.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0xc) ? v0.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0xd) ? v0.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0xe) ? v0.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0xf) ? v0.sf : ret.se;
  ret.se = ((m.se & 0x1f) == 0x10) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x11) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x12) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x13) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x14) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x15) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x16) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x17) ? v1.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x18) ? v1.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x19) ? v1.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1a) ? v1.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1b) ? v1.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1c) ? v1.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1d) ? v1.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1e) ? v1.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1f) ? v1.sf : ret.se;

  ret.sf = ((m.sf & 0x1f) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x8) ? v0.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x9) ? v0.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xa) ? v0.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xb) ? v0.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xc) ? v0.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xd) ? v0.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xe) ? v0.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xf) ? v0.sf : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x10) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x11) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x12) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x13) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x14) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x15) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x16) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x17) ? v1.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x18) ? v1.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x19) ? v1.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1a) ? v1.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1b) ? v1.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1c) ? v1.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1d) ? v1.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1e) ? v1.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1f) ? v1.sf : ret.sf;

  return ret;
}

INLINE float2 __attribute__((overloadable)) __spirv_ocl_shuffle2(float2 v0, float2 v1, int2 m) {
  float2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  return ret;
}

INLINE float2 __attribute__((overloadable)) __spirv_ocl_shuffle2(float4 v0, float4 v1, int2 m) {
  float2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  return ret;
}

INLINE float2 __attribute__((overloadable)) __spirv_ocl_shuffle2(float8 v0, float8 v1, int2 m) {
  float2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  return ret;
}

INLINE float2 __attribute__((overloadable)) __spirv_ocl_shuffle2(float16 v0, float16 v1, int2 m) {
  float2 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  return ret;
}

INLINE float4 __attribute__((overloadable)) __spirv_ocl_shuffle2(float2 v0, float2 v1, int4 m) {
  float4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  return ret;
}

INLINE float4 __attribute__((overloadable)) __spirv_ocl_shuffle2(float4 v0, float4 v1, int4 m) {
  float4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  return ret;
}

INLINE float4 __attribute__((overloadable)) __spirv_ocl_shuffle2(float8 v0, float8 v1, int4 m) {
  float4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  return ret;
}

INLINE float4 __attribute__((overloadable)) __spirv_ocl_shuffle2(float16 v0, float16 v1, int4 m) {
  float4 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  return ret;
}

INLINE float8 __attribute__((overloadable)) __spirv_ocl_shuffle2(float2 v0, float2 v1, int8 m) {
  float8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  return ret;
}

INLINE float8 __attribute__((overloadable)) __spirv_ocl_shuffle2(float4 v0, float4 v1, int8 m) {
  float8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  return ret;
}

INLINE float8 __attribute__((overloadable)) __spirv_ocl_shuffle2(float8 v0, float8 v1, int8 m) {
  float8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  return ret;
}

INLINE float8 __attribute__((overloadable)) __spirv_ocl_shuffle2(float16 v0, float16 v1, int8 m) {
  float8 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  return ret;
}

INLINE float16 __attribute__((overloadable)) __spirv_ocl_shuffle2(float2 v0, float2 v1, int16 m) {
  float16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v1.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v1.s1 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v1.s1 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v1.s1 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v1.s1 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v1.s1 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v1.s1 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v1.s1 : ret.sf;

  return ret;
}

INLINE float16 __attribute__((overloadable)) __spirv_ocl_shuffle2(float4 v0, float4 v1, int16 m) {
  float16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v1.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v1.s3 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v1.s3 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v1.s3 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v1.s3 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v1.s3 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v1.s3 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v1.s3 : ret.sf;

  return ret;
}

INLINE float16 __attribute__((overloadable)) __spirv_ocl_shuffle2(float8 v0, float8 v1, int16 m) {
  float16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v1.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v1.s7 : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v1.s7 : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v1.s7 : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v1.s7 : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v1.s7 : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v1.s7 : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v1.s7 : ret.sf;

  return ret;
}

INLINE float16 __attribute__((overloadable)) __spirv_ocl_shuffle2(float16 v0, float16 v1, int16 m) {
  float16 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  ret.s8 = ((m.s8 & 0x1f) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x8) ? v0.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x9) ? v0.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xa) ? v0.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xb) ? v0.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xc) ? v0.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xd) ? v0.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xe) ? v0.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xf) ? v0.sf : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x10) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x11) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x12) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x13) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x14) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x15) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x16) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x17) ? v1.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x18) ? v1.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x19) ? v1.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1a) ? v1.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1b) ? v1.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1c) ? v1.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1d) ? v1.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1e) ? v1.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1f) ? v1.sf : ret.s8;

  ret.s9 = ((m.s9 & 0x1f) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x8) ? v0.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x9) ? v0.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xa) ? v0.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xb) ? v0.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xc) ? v0.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xd) ? v0.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xe) ? v0.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xf) ? v0.sf : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x10) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x11) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x12) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x13) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x14) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x15) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x16) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x17) ? v1.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x18) ? v1.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x19) ? v1.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1a) ? v1.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1b) ? v1.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1c) ? v1.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1d) ? v1.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1e) ? v1.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1f) ? v1.sf : ret.s9;

  ret.sa = ((m.sa & 0x1f) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x8) ? v0.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x9) ? v0.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xa) ? v0.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xb) ? v0.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xc) ? v0.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xd) ? v0.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xe) ? v0.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xf) ? v0.sf : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x10) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x11) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x12) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x13) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x14) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x15) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x16) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x17) ? v1.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x18) ? v1.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x19) ? v1.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1a) ? v1.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1b) ? v1.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1c) ? v1.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1d) ? v1.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1e) ? v1.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1f) ? v1.sf : ret.sa;

  ret.sb = ((m.sb & 0x1f) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x8) ? v0.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x9) ? v0.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xa) ? v0.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xb) ? v0.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xc) ? v0.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xd) ? v0.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xe) ? v0.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xf) ? v0.sf : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x10) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x11) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x12) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x13) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x14) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x15) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x16) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x17) ? v1.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x18) ? v1.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x19) ? v1.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1a) ? v1.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1b) ? v1.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1c) ? v1.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1d) ? v1.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1e) ? v1.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1f) ? v1.sf : ret.sb;

  ret.sc = ((m.sc & 0x1f) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x8) ? v0.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x9) ? v0.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xa) ? v0.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xb) ? v0.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xc) ? v0.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xd) ? v0.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xe) ? v0.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xf) ? v0.sf : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x10) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x11) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x12) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x13) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x14) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x15) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x16) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x17) ? v1.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x18) ? v1.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x19) ? v1.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1a) ? v1.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1b) ? v1.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1c) ? v1.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1d) ? v1.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1e) ? v1.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1f) ? v1.sf : ret.sc;

  ret.sd = ((m.sd & 0x1f) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x8) ? v0.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x9) ? v0.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xa) ? v0.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xb) ? v0.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xc) ? v0.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xd) ? v0.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xe) ? v0.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xf) ? v0.sf : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x10) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x11) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x12) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x13) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x14) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x15) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x16) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x17) ? v1.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x18) ? v1.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x19) ? v1.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1a) ? v1.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1b) ? v1.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1c) ? v1.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1d) ? v1.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1e) ? v1.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1f) ? v1.sf : ret.sd;

  ret.se = ((m.se & 0x1f) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x8) ? v0.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x9) ? v0.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0xa) ? v0.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0xb) ? v0.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0xc) ? v0.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0xd) ? v0.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0xe) ? v0.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0xf) ? v0.sf : ret.se;
  ret.se = ((m.se & 0x1f) == 0x10) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x11) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x12) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x13) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x14) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x15) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x16) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x17) ? v1.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x18) ? v1.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x19) ? v1.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1a) ? v1.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1b) ? v1.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1c) ? v1.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1d) ? v1.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1e) ? v1.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1f) ? v1.sf : ret.se;

  ret.sf = ((m.sf & 0x1f) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x8) ? v0.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x9) ? v0.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xa) ? v0.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xb) ? v0.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xc) ? v0.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xd) ? v0.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xe) ? v0.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xf) ? v0.sf : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x10) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x11) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x12) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x13) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x14) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x15) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x16) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x17) ? v1.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x18) ? v1.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x19) ? v1.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1a) ? v1.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1b) ? v1.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1c) ? v1.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1d) ? v1.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1e) ? v1.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1f) ? v1.sf : ret.sf;

  return ret;
}

#if defined(cl_khr_fp16)

/// Half Shuffle functions
INLINE half2 __attribute__((overloadable)) __spirv_ocl_shuffle(half2 v, short2 m) {
  half2 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  return ret;
}

INLINE half2 __attribute__((overloadable)) __spirv_ocl_shuffle(half4 v, short2 m) {
  half2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  return ret;
}

INLINE half2 __attribute__((overloadable)) __spirv_ocl_shuffle(half8 v, short2 m) {
  half2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  return ret;
}

INLINE half2 __attribute__((overloadable)) __spirv_ocl_shuffle(half16 v, short2 m) {
  half2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  return ret;
}

INLINE half4 __attribute__((overloadable)) __spirv_ocl_shuffle(half2 v, short4 m) {
  half4 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  return ret;
}

INLINE half4 __attribute__((overloadable)) __spirv_ocl_shuffle(half4 v, short4 m) {
  half4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  return ret;
}

INLINE half4 __attribute__((overloadable)) __spirv_ocl_shuffle(half8 v, short4 m) {
  half4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  return ret;
}

INLINE half4 __attribute__((overloadable)) __spirv_ocl_shuffle(half16 v, short4 m) {
  half4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  return ret;
}

INLINE half8 __attribute__((overloadable)) __spirv_ocl_shuffle(half2 v, short8 m) {
  half8 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  return ret;
}

INLINE half8 __attribute__((overloadable)) __spirv_ocl_shuffle(half4 v, short8 m) {
  half8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  return ret;
}

INLINE half8 __attribute__((overloadable)) __spirv_ocl_shuffle(half8 v, short8 m) {
  half8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  return ret;
}

INLINE half8 __attribute__((overloadable)) __spirv_ocl_shuffle(half16 v, short8 m) {
  half8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  return ret;
}

INLINE half16 __attribute__((overloadable)) __spirv_ocl_shuffle(half2 v, short16 m) {
  half16 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x1) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1) == 0x1) ? v.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x1) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1) == 0x1) ? v.s1 : ret.s9;

  ret.sa = ((m.sa & 0x1) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1) == 0x1) ? v.s1 : ret.sa;

  ret.sb = ((m.sb & 0x1) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1) == 0x1) ? v.s1 : ret.sb;

  ret.sc = ((m.sc & 0x1) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1) == 0x1) ? v.s1 : ret.sc;

  ret.sd = ((m.sd & 0x1) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1) == 0x1) ? v.s1 : ret.sd;

  ret.se = ((m.se & 0x1) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x1) == 0x1) ? v.s1 : ret.se;

  ret.sf = ((m.sf & 0x1) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1) == 0x1) ? v.s1 : ret.sf;

  return ret;
}

INLINE half16 __attribute__((overloadable)) __spirv_ocl_shuffle(half4 v, short16 m) {
  half16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v.s3 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v.s3 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v.s3 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v.s3 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v.s3 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v.s3 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v.s3 : ret.sf;

  return ret;
}

INLINE half16 __attribute__((overloadable)) __spirv_ocl_shuffle(half8 v, short16 m) {
  half16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v.s7 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v.s7 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v.s7 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v.s7 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v.s7 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v.s7 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v.s7 : ret.sf;

  return ret;
}

INLINE half16 __attribute__((overloadable)) __spirv_ocl_shuffle(half16 v, short16 m) {
  half16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v.sa : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v.sb : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v.sc : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v.sd : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v.se : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v.sf : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v.sa : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v.sb : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v.sc : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v.sd : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v.se : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v.sf : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v.s8 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v.s9 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v.sa : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v.sb : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v.sc : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v.sd : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v.se : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v.sf : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v.s8 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v.s9 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v.sa : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v.sb : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v.sc : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v.sd : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v.se : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v.sf : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v.s8 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v.s9 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v.sa : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v.sb : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v.sc : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v.sd : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v.se : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v.sf : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v.s8 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v.s9 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v.sa : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v.sb : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v.sc : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v.sd : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v.se : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v.sf : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v.s8 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v.s9 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v.sa : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v.sb : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v.sc : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v.sd : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v.se : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v.sf : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v.s8 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v.s9 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v.sa : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v.sb : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v.sc : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v.sd : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v.se : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v.sf : ret.sf;

  return ret;
}

// Shuffle2
INLINE half2 __attribute__((overloadable)) __spirv_ocl_shuffle2(half2 v0, half2 v1, short2 m) {
  half2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  return ret;
}

INLINE half2 __attribute__((overloadable)) __spirv_ocl_shuffle2(half4 v0, half4 v1, short2 m) {
  half2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  return ret;
}

INLINE half2 __attribute__((overloadable)) __spirv_ocl_shuffle2(half8 v0, half8 v1, short2 m) {
  half2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  return ret;
}

INLINE half2 __attribute__((overloadable)) __spirv_ocl_shuffle2(half16 v0, half16 v1, short2 m) {
  half2 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  return ret;
}

INLINE half4 __attribute__((overloadable)) __spirv_ocl_shuffle2(half2 v0, half2 v1, short4 m) {
  half4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  return ret;
}

INLINE half4 __attribute__((overloadable)) __spirv_ocl_shuffle2(half4 v0, half4 v1, short4 m) {
  half4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  return ret;
}

INLINE half4 __attribute__((overloadable)) __spirv_ocl_shuffle2(half8 v0, half8 v1, short4 m) {
  half4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  return ret;
}

INLINE half4 __attribute__((overloadable)) __spirv_ocl_shuffle2(half16 v0, half16 v1, short4 m) {
  half4 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  return ret;
}

INLINE half8 __attribute__((overloadable)) __spirv_ocl_shuffle2(half2 v0, half2 v1, short8 m) {
  half8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  return ret;
}

INLINE half8 __attribute__((overloadable)) __spirv_ocl_shuffle2(half4 v0, half4 v1, short8 m) {
  half8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  return ret;
}

INLINE half8 __attribute__((overloadable)) __spirv_ocl_shuffle2(half8 v0, half8 v1, short8 m) {
  half8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  return ret;
}

INLINE half8 __attribute__((overloadable)) __spirv_ocl_shuffle2(half16 v0, half16 v1, short8 m) {
  half8 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  return ret;
}

INLINE half16 __attribute__((overloadable)) __spirv_ocl_shuffle2(half2 v0, half2 v1, short16 m) {
  half16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v1.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v1.s1 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v1.s1 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v1.s1 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v1.s1 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v1.s1 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v1.s1 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v1.s1 : ret.sf;

  return ret;
}

INLINE half16 __attribute__((overloadable)) __spirv_ocl_shuffle2(half4 v0, half4 v1, short16 m) {
  half16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v1.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v1.s3 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v1.s3 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v1.s3 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v1.s3 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v1.s3 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v1.s3 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v1.s3 : ret.sf;

  return ret;
}

INLINE half16 __attribute__((overloadable)) __spirv_ocl_shuffle2(half8 v0, half8 v1, short16 m) {
  half16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v1.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v1.s7 : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v1.s7 : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v1.s7 : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v1.s7 : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v1.s7 : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v1.s7 : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v1.s7 : ret.sf;

  return ret;
}

INLINE half16 __attribute__((overloadable)) __spirv_ocl_shuffle2(half16 v0, half16 v1, short16 m) {
  half16 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  ret.s8 = ((m.s8 & 0x1f) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x8) ? v0.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x9) ? v0.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xa) ? v0.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xb) ? v0.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xc) ? v0.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xd) ? v0.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xe) ? v0.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xf) ? v0.sf : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x10) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x11) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x12) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x13) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x14) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x15) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x16) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x17) ? v1.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x18) ? v1.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x19) ? v1.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1a) ? v1.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1b) ? v1.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1c) ? v1.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1d) ? v1.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1e) ? v1.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1f) ? v1.sf : ret.s8;

  ret.s9 = ((m.s9 & 0x1f) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x8) ? v0.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x9) ? v0.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xa) ? v0.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xb) ? v0.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xc) ? v0.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xd) ? v0.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xe) ? v0.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xf) ? v0.sf : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x10) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x11) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x12) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x13) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x14) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x15) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x16) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x17) ? v1.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x18) ? v1.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x19) ? v1.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1a) ? v1.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1b) ? v1.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1c) ? v1.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1d) ? v1.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1e) ? v1.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1f) ? v1.sf : ret.s9;

  ret.sa = ((m.sa & 0x1f) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x8) ? v0.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x9) ? v0.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xa) ? v0.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xb) ? v0.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xc) ? v0.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xd) ? v0.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xe) ? v0.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xf) ? v0.sf : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x10) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x11) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x12) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x13) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x14) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x15) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x16) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x17) ? v1.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x18) ? v1.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x19) ? v1.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1a) ? v1.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1b) ? v1.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1c) ? v1.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1d) ? v1.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1e) ? v1.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1f) ? v1.sf : ret.sa;

  ret.sb = ((m.sb & 0x1f) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x8) ? v0.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x9) ? v0.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xa) ? v0.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xb) ? v0.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xc) ? v0.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xd) ? v0.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xe) ? v0.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xf) ? v0.sf : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x10) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x11) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x12) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x13) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x14) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x15) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x16) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x17) ? v1.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x18) ? v1.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x19) ? v1.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1a) ? v1.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1b) ? v1.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1c) ? v1.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1d) ? v1.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1e) ? v1.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1f) ? v1.sf : ret.sb;

  ret.sc = ((m.sc & 0x1f) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x8) ? v0.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x9) ? v0.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xa) ? v0.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xb) ? v0.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xc) ? v0.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xd) ? v0.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xe) ? v0.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xf) ? v0.sf : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x10) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x11) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x12) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x13) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x14) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x15) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x16) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x17) ? v1.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x18) ? v1.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x19) ? v1.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1a) ? v1.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1b) ? v1.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1c) ? v1.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1d) ? v1.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1e) ? v1.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1f) ? v1.sf : ret.sc;

  ret.sd = ((m.sd & 0x1f) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x8) ? v0.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x9) ? v0.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xa) ? v0.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xb) ? v0.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xc) ? v0.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xd) ? v0.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xe) ? v0.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xf) ? v0.sf : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x10) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x11) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x12) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x13) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x14) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x15) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x16) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x17) ? v1.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x18) ? v1.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x19) ? v1.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1a) ? v1.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1b) ? v1.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1c) ? v1.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1d) ? v1.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1e) ? v1.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1f) ? v1.sf : ret.sd;

  ret.se = ((m.se & 0x1f) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x8) ? v0.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x9) ? v0.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0xa) ? v0.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0xb) ? v0.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0xc) ? v0.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0xd) ? v0.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0xe) ? v0.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0xf) ? v0.sf : ret.se;
  ret.se = ((m.se & 0x1f) == 0x10) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x11) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x12) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x13) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x14) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x15) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x16) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x17) ? v1.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x18) ? v1.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x19) ? v1.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1a) ? v1.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1b) ? v1.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1c) ? v1.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1d) ? v1.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1e) ? v1.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1f) ? v1.sf : ret.se;

  ret.sf = ((m.sf & 0x1f) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x8) ? v0.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x9) ? v0.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xa) ? v0.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xb) ? v0.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xc) ? v0.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xd) ? v0.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xe) ? v0.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xf) ? v0.sf : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x10) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x11) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x12) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x13) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x14) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x15) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x16) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x17) ? v1.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x18) ? v1.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x19) ? v1.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1a) ? v1.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1b) ? v1.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1c) ? v1.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1d) ? v1.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1e) ? v1.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1f) ? v1.sf : ret.sf;

  return ret;
}

#endif // defined(cl_khr_fp16)

#if defined(cl_khr_fp64)

/// Double Shuffle functions
INLINE double2 __attribute__((overloadable)) __spirv_ocl_shuffle(double2 v, long2 m) {
  double2 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  return ret;
}

INLINE double2 __attribute__((overloadable)) __spirv_ocl_shuffle(double4 v, long2 m) {
  double2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  return ret;
}

INLINE double2 __attribute__((overloadable)) __spirv_ocl_shuffle(double8 v, long2 m) {
  double2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  return ret;
}

INLINE double2 __attribute__((overloadable)) __spirv_ocl_shuffle(double16 v, long2 m) {
  double2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  return ret;
}

INLINE double4 __attribute__((overloadable)) __spirv_ocl_shuffle(double2 v, long4 m) {
  double4 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  return ret;
}

INLINE double4 __attribute__((overloadable)) __spirv_ocl_shuffle(double4 v, long4 m) {
  double4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  return ret;
}

INLINE double4 __attribute__((overloadable)) __spirv_ocl_shuffle(double8 v, long4 m) {
  double4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  return ret;
}

INLINE double4 __attribute__((overloadable)) __spirv_ocl_shuffle(double16 v, long4 m) {
  double4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  return ret;
}

INLINE double8 __attribute__((overloadable)) __spirv_ocl_shuffle(double2 v, long8 m) {
  double8 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  return ret;
}

INLINE double8 __attribute__((overloadable)) __spirv_ocl_shuffle(double4 v, long8 m) {
  double8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  return ret;
}

INLINE double8 __attribute__((overloadable)) __spirv_ocl_shuffle(double8 v, long8 m) {
  double8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  return ret;
}

INLINE double8 __attribute__((overloadable)) __spirv_ocl_shuffle(double16 v, long8 m) {
  double8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  return ret;
}

INLINE double16 __attribute__((overloadable)) __spirv_ocl_shuffle(double2 v, long16 m) {
  double16 ret = 0;
  ret.s0 = ((m.s0 & 0x1) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1) == 0x1) ? v.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x1) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1) == 0x1) ? v.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x1) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1) == 0x1) ? v.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x1) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1) == 0x1) ? v.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x1) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1) == 0x1) ? v.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x1) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1) == 0x1) ? v.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x1) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1) == 0x1) ? v.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x1) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1) == 0x1) ? v.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x1) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1) == 0x1) ? v.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x1) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1) == 0x1) ? v.s1 : ret.s9;

  ret.sa = ((m.sa & 0x1) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1) == 0x1) ? v.s1 : ret.sa;

  ret.sb = ((m.sb & 0x1) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1) == 0x1) ? v.s1 : ret.sb;

  ret.sc = ((m.sc & 0x1) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1) == 0x1) ? v.s1 : ret.sc;

  ret.sd = ((m.sd & 0x1) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1) == 0x1) ? v.s1 : ret.sd;

  ret.se = ((m.se & 0x1) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x1) == 0x1) ? v.s1 : ret.se;

  ret.sf = ((m.sf & 0x1) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1) == 0x1) ? v.s1 : ret.sf;

  return ret;
}

INLINE double16 __attribute__((overloadable)) __spirv_ocl_shuffle(double4 v, long16 m) {
  double16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v.s3 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v.s3 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v.s3 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v.s3 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v.s3 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v.s3 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v.s3 : ret.sf;

  return ret;
}

INLINE double16 __attribute__((overloadable)) __spirv_ocl_shuffle(double8 v, long16 m) {
  double16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v.s7 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v.s7 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v.s7 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v.s7 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v.s7 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v.s7 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v.s7 : ret.sf;

  return ret;
}

INLINE double16 __attribute__((overloadable)) __spirv_ocl_shuffle(double16 v, long16 m) {
  double16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v.sa : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v.sb : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v.sc : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v.sd : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v.se : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v.sf : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v.sa : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v.sb : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v.sc : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v.sd : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v.se : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v.sf : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v.sa : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v.sb : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v.sc : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v.sd : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v.se : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v.sf : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v.sa : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v.sb : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v.sc : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v.sd : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v.se : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v.sf : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v.sa : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v.sb : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v.sc : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v.sd : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v.se : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v.sf : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v.sa : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v.sb : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v.sc : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v.sd : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v.se : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v.sf : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v.sa : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v.sb : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v.sc : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v.sd : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v.se : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v.sf : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v.sa : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v.sb : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v.sc : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v.sd : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v.se : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v.sf : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v.sa : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v.sb : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v.sc : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v.sd : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v.se : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v.sf : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v.sa : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v.sb : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v.sc : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v.sd : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v.se : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v.sf : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v.s8 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v.s9 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v.sa : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v.sb : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v.sc : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v.sd : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v.se : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v.sf : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v.s8 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v.s9 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v.sa : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v.sb : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v.sc : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v.sd : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v.se : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v.sf : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v.s8 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v.s9 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v.sa : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v.sb : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v.sc : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v.sd : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v.se : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v.sf : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v.s8 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v.s9 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v.sa : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v.sb : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v.sc : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v.sd : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v.se : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v.sf : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v.s8 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v.s9 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v.sa : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v.sb : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v.sc : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v.sd : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v.se : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v.sf : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v.s8 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v.s9 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v.sa : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v.sb : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v.sc : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v.sd : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v.se : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v.sf : ret.sf;

  return ret;
}

// Shuffle2
INLINE double2 __attribute__((overloadable)) __spirv_ocl_shuffle2(double2 v0, double2 v1, long2 m) {
  double2 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  return ret;
}

INLINE double2 __attribute__((overloadable)) __spirv_ocl_shuffle2(double4 v0, double4 v1, long2 m) {
  double2 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  return ret;
}

INLINE double2 __attribute__((overloadable)) __spirv_ocl_shuffle2(double8 v0, double8 v1, long2 m) {
  double2 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  return ret;
}

INLINE double2 __attribute__((overloadable)) __spirv_ocl_shuffle2(double16 v0, double16 v1, long2 m) {
  double2 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  return ret;
}

INLINE double4 __attribute__((overloadable)) __spirv_ocl_shuffle2(double2 v0, double2 v1, long4 m) {
  double4 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  return ret;
}

INLINE double4 __attribute__((overloadable)) __spirv_ocl_shuffle2(double4 v0, double4 v1, long4 m) {
  double4 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  return ret;
}

INLINE double4 __attribute__((overloadable)) __spirv_ocl_shuffle2(double8 v0, double8 v1, long4 m) {
  double4 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  return ret;
}

INLINE double4 __attribute__((overloadable)) __spirv_ocl_shuffle2(double16 v0, double16 v1, long4 m) {
  double4 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  return ret;
}

INLINE double8 __attribute__((overloadable)) __spirv_ocl_shuffle2(double2 v0, double2 v1, long8 m) {
  double8 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  return ret;
}

INLINE double8 __attribute__((overloadable)) __spirv_ocl_shuffle2(double4 v0, double4 v1, long8 m) {
  double8 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  return ret;
}

INLINE double8 __attribute__((overloadable)) __spirv_ocl_shuffle2(double8 v0, double8 v1, long8 m) {
  double8 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  return ret;
}

INLINE double8 __attribute__((overloadable)) __spirv_ocl_shuffle2(double16 v0, double16 v1, long8 m) {
  double8 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  return ret;
}

INLINE double16 __attribute__((overloadable)) __spirv_ocl_shuffle2(double2 v0, double2 v1, long16 m) {
  double16 ret = 0;
  ret.s0 = ((m.s0 & 0x3) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x2) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x3) == 0x3) ? v1.s1 : ret.s0;

  ret.s1 = ((m.s1 & 0x3) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x2) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x3) == 0x3) ? v1.s1 : ret.s1;

  ret.s2 = ((m.s2 & 0x3) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x2) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x3) == 0x3) ? v1.s1 : ret.s2;

  ret.s3 = ((m.s3 & 0x3) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x2) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x3) == 0x3) ? v1.s1 : ret.s3;

  ret.s4 = ((m.s4 & 0x3) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x2) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x3) == 0x3) ? v1.s1 : ret.s4;

  ret.s5 = ((m.s5 & 0x3) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x2) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x3) == 0x3) ? v1.s1 : ret.s5;

  ret.s6 = ((m.s6 & 0x3) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x2) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x3) == 0x3) ? v1.s1 : ret.s6;

  ret.s7 = ((m.s7 & 0x3) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x2) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x3) == 0x3) ? v1.s1 : ret.s7;

  ret.s8 = ((m.s8 & 0x3) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x2) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x3) == 0x3) ? v1.s1 : ret.s8;

  ret.s9 = ((m.s9 & 0x3) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x2) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x3) == 0x3) ? v1.s1 : ret.s9;

  ret.sa = ((m.sa & 0x3) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x2) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x3) == 0x3) ? v1.s1 : ret.sa;

  ret.sb = ((m.sb & 0x3) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x2) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x3) == 0x3) ? v1.s1 : ret.sb;

  ret.sc = ((m.sc & 0x3) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x2) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x3) == 0x3) ? v1.s1 : ret.sc;

  ret.sd = ((m.sd & 0x3) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x2) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x3) == 0x3) ? v1.s1 : ret.sd;

  ret.se = ((m.se & 0x3) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x3) == 0x2) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x3) == 0x3) ? v1.s1 : ret.se;

  ret.sf = ((m.sf & 0x3) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x2) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x3) == 0x3) ? v1.s1 : ret.sf;

  return ret;
}

INLINE double16 __attribute__((overloadable)) __spirv_ocl_shuffle2(double4 v0, double4 v1, long16 m) {
  double16 ret = 0;
  ret.s0 = ((m.s0 & 0x7) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x4) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x5) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x6) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x7) == 0x7) ? v1.s3 : ret.s0;

  ret.s1 = ((m.s1 & 0x7) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x4) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x5) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x6) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x7) == 0x7) ? v1.s3 : ret.s1;

  ret.s2 = ((m.s2 & 0x7) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x4) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x5) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x6) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x7) == 0x7) ? v1.s3 : ret.s2;

  ret.s3 = ((m.s3 & 0x7) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x4) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x5) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x6) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x7) == 0x7) ? v1.s3 : ret.s3;

  ret.s4 = ((m.s4 & 0x7) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x4) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x5) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x6) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x7) == 0x7) ? v1.s3 : ret.s4;

  ret.s5 = ((m.s5 & 0x7) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x4) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x5) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x6) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x7) == 0x7) ? v1.s3 : ret.s5;

  ret.s6 = ((m.s6 & 0x7) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x4) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x5) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x6) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x7) == 0x7) ? v1.s3 : ret.s6;

  ret.s7 = ((m.s7 & 0x7) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x4) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x5) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x6) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x7) == 0x7) ? v1.s3 : ret.s7;

  ret.s8 = ((m.s8 & 0x7) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x4) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x5) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x6) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x7) == 0x7) ? v1.s3 : ret.s8;

  ret.s9 = ((m.s9 & 0x7) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x4) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x5) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x6) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x7) == 0x7) ? v1.s3 : ret.s9;

  ret.sa = ((m.sa & 0x7) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x4) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x5) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x6) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x7) == 0x7) ? v1.s3 : ret.sa;

  ret.sb = ((m.sb & 0x7) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x4) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x5) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x6) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x7) == 0x7) ? v1.s3 : ret.sb;

  ret.sc = ((m.sc & 0x7) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x4) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x5) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x6) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x7) == 0x7) ? v1.s3 : ret.sc;

  ret.sd = ((m.sd & 0x7) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x4) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x5) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x6) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x7) == 0x7) ? v1.s3 : ret.sd;

  ret.se = ((m.se & 0x7) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x7) == 0x4) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x7) == 0x5) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x7) == 0x6) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x7) == 0x7) ? v1.s3 : ret.se;

  ret.sf = ((m.sf & 0x7) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x4) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x5) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x6) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x7) == 0x7) ? v1.s3 : ret.sf;

  return ret;
}

INLINE double16 __attribute__((overloadable)) __spirv_ocl_shuffle2(double8 v0, double8 v1, long16 m) {
  double16 ret = 0;
  ret.s0 = ((m.s0 & 0xf) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x8) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0x9) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xa) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xb) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xc) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xd) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xe) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0xf) == 0xf) ? v1.s7 : ret.s0;

  ret.s1 = ((m.s1 & 0xf) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x8) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0x9) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xa) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xb) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xc) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xd) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xe) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0xf) == 0xf) ? v1.s7 : ret.s1;

  ret.s2 = ((m.s2 & 0xf) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x8) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0x9) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xa) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xb) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xc) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xd) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xe) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0xf) == 0xf) ? v1.s7 : ret.s2;

  ret.s3 = ((m.s3 & 0xf) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x8) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0x9) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xa) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xb) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xc) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xd) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xe) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0xf) == 0xf) ? v1.s7 : ret.s3;

  ret.s4 = ((m.s4 & 0xf) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x8) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0x9) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xa) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xb) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xc) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xd) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xe) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0xf) == 0xf) ? v1.s7 : ret.s4;

  ret.s5 = ((m.s5 & 0xf) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x8) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0x9) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xa) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xb) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xc) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xd) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xe) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0xf) == 0xf) ? v1.s7 : ret.s5;

  ret.s6 = ((m.s6 & 0xf) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x8) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0x9) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xa) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xb) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xc) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xd) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xe) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0xf) == 0xf) ? v1.s7 : ret.s6;

  ret.s7 = ((m.s7 & 0xf) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x8) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0x9) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xa) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xb) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xc) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xd) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xe) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0xf) == 0xf) ? v1.s7 : ret.s7;

  ret.s8 = ((m.s8 & 0xf) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x8) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0x9) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xa) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xb) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xc) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xd) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xe) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0xf) == 0xf) ? v1.s7 : ret.s8;

  ret.s9 = ((m.s9 & 0xf) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x8) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0x9) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xa) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xb) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xc) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xd) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xe) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0xf) == 0xf) ? v1.s7 : ret.s9;

  ret.sa = ((m.sa & 0xf) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x8) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0x9) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xa) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xb) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xc) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xd) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xe) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0xf) == 0xf) ? v1.s7 : ret.sa;

  ret.sb = ((m.sb & 0xf) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x8) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0x9) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xa) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xb) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xc) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xd) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xe) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0xf) == 0xf) ? v1.s7 : ret.sb;

  ret.sc = ((m.sc & 0xf) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x8) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0x9) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xa) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xb) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xc) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xd) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xe) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0xf) == 0xf) ? v1.s7 : ret.sc;

  ret.sd = ((m.sd & 0xf) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x8) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0x9) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xa) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xb) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xc) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xd) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xe) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0xf) == 0xf) ? v1.s7 : ret.sd;

  ret.se = ((m.se & 0xf) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0xf) == 0x8) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0xf) == 0x9) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0xf) == 0xa) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0xf) == 0xb) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0xf) == 0xc) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0xf) == 0xd) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0xf) == 0xe) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0xf) == 0xf) ? v1.s7 : ret.se;

  ret.sf = ((m.sf & 0xf) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x8) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0x9) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xa) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xb) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xc) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xd) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xe) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0xf) == 0xf) ? v1.s7 : ret.sf;

  return ret;
}

INLINE double16 __attribute__((overloadable)) __spirv_ocl_shuffle2(double16 v0, double16 v1, long16 m) {
  double16 ret = 0;
  ret.s0 = ((m.s0 & 0x1f) == 0x0) ? v0.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1) ? v0.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x2) ? v0.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x3) ? v0.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x4) ? v0.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x5) ? v0.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x6) ? v0.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x7) ? v0.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x8) ? v0.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x9) ? v0.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xa) ? v0.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xb) ? v0.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xc) ? v0.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xd) ? v0.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xe) ? v0.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0xf) ? v0.sf : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x10) ? v1.s0 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x11) ? v1.s1 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x12) ? v1.s2 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x13) ? v1.s3 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x14) ? v1.s4 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x15) ? v1.s5 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x16) ? v1.s6 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x17) ? v1.s7 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x18) ? v1.s8 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x19) ? v1.s9 : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1a) ? v1.sa : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1b) ? v1.sb : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1c) ? v1.sc : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1d) ? v1.sd : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1e) ? v1.se : ret.s0;
  ret.s0 = ((m.s0 & 0x1f) == 0x1f) ? v1.sf : ret.s0;

  ret.s1 = ((m.s1 & 0x1f) == 0x0) ? v0.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1) ? v0.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x2) ? v0.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x3) ? v0.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x4) ? v0.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x5) ? v0.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x6) ? v0.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x7) ? v0.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x8) ? v0.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x9) ? v0.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xa) ? v0.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xb) ? v0.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xc) ? v0.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xd) ? v0.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xe) ? v0.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0xf) ? v0.sf : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x10) ? v1.s0 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x11) ? v1.s1 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x12) ? v1.s2 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x13) ? v1.s3 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x14) ? v1.s4 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x15) ? v1.s5 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x16) ? v1.s6 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x17) ? v1.s7 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x18) ? v1.s8 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x19) ? v1.s9 : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1a) ? v1.sa : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1b) ? v1.sb : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1c) ? v1.sc : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1d) ? v1.sd : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1e) ? v1.se : ret.s1;
  ret.s1 = ((m.s1 & 0x1f) == 0x1f) ? v1.sf : ret.s1;

  ret.s2 = ((m.s2 & 0x1f) == 0x0) ? v0.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1) ? v0.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x2) ? v0.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x3) ? v0.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x4) ? v0.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x5) ? v0.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x6) ? v0.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x7) ? v0.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x8) ? v0.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x9) ? v0.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xa) ? v0.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xb) ? v0.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xc) ? v0.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xd) ? v0.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xe) ? v0.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0xf) ? v0.sf : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x10) ? v1.s0 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x11) ? v1.s1 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x12) ? v1.s2 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x13) ? v1.s3 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x14) ? v1.s4 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x15) ? v1.s5 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x16) ? v1.s6 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x17) ? v1.s7 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x18) ? v1.s8 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x19) ? v1.s9 : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1a) ? v1.sa : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1b) ? v1.sb : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1c) ? v1.sc : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1d) ? v1.sd : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1e) ? v1.se : ret.s2;
  ret.s2 = ((m.s2 & 0x1f) == 0x1f) ? v1.sf : ret.s2;

  ret.s3 = ((m.s3 & 0x1f) == 0x0) ? v0.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1) ? v0.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x2) ? v0.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x3) ? v0.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x4) ? v0.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x5) ? v0.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x6) ? v0.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x7) ? v0.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x8) ? v0.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x9) ? v0.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xa) ? v0.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xb) ? v0.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xc) ? v0.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xd) ? v0.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xe) ? v0.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0xf) ? v0.sf : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x10) ? v1.s0 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x11) ? v1.s1 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x12) ? v1.s2 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x13) ? v1.s3 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x14) ? v1.s4 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x15) ? v1.s5 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x16) ? v1.s6 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x17) ? v1.s7 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x18) ? v1.s8 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x19) ? v1.s9 : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1a) ? v1.sa : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1b) ? v1.sb : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1c) ? v1.sc : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1d) ? v1.sd : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1e) ? v1.se : ret.s3;
  ret.s3 = ((m.s3 & 0x1f) == 0x1f) ? v1.sf : ret.s3;

  ret.s4 = ((m.s4 & 0x1f) == 0x0) ? v0.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1) ? v0.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x2) ? v0.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x3) ? v0.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x4) ? v0.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x5) ? v0.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x6) ? v0.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x7) ? v0.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x8) ? v0.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x9) ? v0.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xa) ? v0.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xb) ? v0.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xc) ? v0.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xd) ? v0.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xe) ? v0.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0xf) ? v0.sf : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x10) ? v1.s0 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x11) ? v1.s1 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x12) ? v1.s2 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x13) ? v1.s3 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x14) ? v1.s4 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x15) ? v1.s5 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x16) ? v1.s6 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x17) ? v1.s7 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x18) ? v1.s8 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x19) ? v1.s9 : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1a) ? v1.sa : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1b) ? v1.sb : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1c) ? v1.sc : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1d) ? v1.sd : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1e) ? v1.se : ret.s4;
  ret.s4 = ((m.s4 & 0x1f) == 0x1f) ? v1.sf : ret.s4;

  ret.s5 = ((m.s5 & 0x1f) == 0x0) ? v0.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1) ? v0.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x2) ? v0.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x3) ? v0.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x4) ? v0.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x5) ? v0.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x6) ? v0.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x7) ? v0.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x8) ? v0.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x9) ? v0.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xa) ? v0.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xb) ? v0.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xc) ? v0.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xd) ? v0.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xe) ? v0.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0xf) ? v0.sf : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x10) ? v1.s0 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x11) ? v1.s1 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x12) ? v1.s2 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x13) ? v1.s3 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x14) ? v1.s4 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x15) ? v1.s5 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x16) ? v1.s6 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x17) ? v1.s7 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x18) ? v1.s8 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x19) ? v1.s9 : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1a) ? v1.sa : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1b) ? v1.sb : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1c) ? v1.sc : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1d) ? v1.sd : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1e) ? v1.se : ret.s5;
  ret.s5 = ((m.s5 & 0x1f) == 0x1f) ? v1.sf : ret.s5;

  ret.s6 = ((m.s6 & 0x1f) == 0x0) ? v0.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1) ? v0.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x2) ? v0.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x3) ? v0.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x4) ? v0.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x5) ? v0.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x6) ? v0.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x7) ? v0.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x8) ? v0.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x9) ? v0.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xa) ? v0.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xb) ? v0.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xc) ? v0.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xd) ? v0.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xe) ? v0.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0xf) ? v0.sf : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x10) ? v1.s0 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x11) ? v1.s1 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x12) ? v1.s2 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x13) ? v1.s3 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x14) ? v1.s4 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x15) ? v1.s5 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x16) ? v1.s6 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x17) ? v1.s7 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x18) ? v1.s8 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x19) ? v1.s9 : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1a) ? v1.sa : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1b) ? v1.sb : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1c) ? v1.sc : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1d) ? v1.sd : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1e) ? v1.se : ret.s6;
  ret.s6 = ((m.s6 & 0x1f) == 0x1f) ? v1.sf : ret.s6;

  ret.s7 = ((m.s7 & 0x1f) == 0x0) ? v0.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1) ? v0.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x2) ? v0.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x3) ? v0.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x4) ? v0.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x5) ? v0.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x6) ? v0.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x7) ? v0.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x8) ? v0.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x9) ? v0.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xa) ? v0.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xb) ? v0.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xc) ? v0.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xd) ? v0.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xe) ? v0.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0xf) ? v0.sf : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x10) ? v1.s0 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x11) ? v1.s1 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x12) ? v1.s2 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x13) ? v1.s3 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x14) ? v1.s4 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x15) ? v1.s5 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x16) ? v1.s6 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x17) ? v1.s7 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x18) ? v1.s8 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x19) ? v1.s9 : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1a) ? v1.sa : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1b) ? v1.sb : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1c) ? v1.sc : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1d) ? v1.sd : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1e) ? v1.se : ret.s7;
  ret.s7 = ((m.s7 & 0x1f) == 0x1f) ? v1.sf : ret.s7;

  ret.s8 = ((m.s8 & 0x1f) == 0x0) ? v0.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1) ? v0.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x2) ? v0.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x3) ? v0.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x4) ? v0.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x5) ? v0.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x6) ? v0.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x7) ? v0.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x8) ? v0.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x9) ? v0.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xa) ? v0.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xb) ? v0.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xc) ? v0.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xd) ? v0.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xe) ? v0.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0xf) ? v0.sf : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x10) ? v1.s0 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x11) ? v1.s1 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x12) ? v1.s2 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x13) ? v1.s3 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x14) ? v1.s4 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x15) ? v1.s5 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x16) ? v1.s6 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x17) ? v1.s7 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x18) ? v1.s8 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x19) ? v1.s9 : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1a) ? v1.sa : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1b) ? v1.sb : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1c) ? v1.sc : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1d) ? v1.sd : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1e) ? v1.se : ret.s8;
  ret.s8 = ((m.s8 & 0x1f) == 0x1f) ? v1.sf : ret.s8;

  ret.s9 = ((m.s9 & 0x1f) == 0x0) ? v0.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1) ? v0.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x2) ? v0.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x3) ? v0.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x4) ? v0.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x5) ? v0.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x6) ? v0.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x7) ? v0.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x8) ? v0.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x9) ? v0.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xa) ? v0.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xb) ? v0.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xc) ? v0.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xd) ? v0.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xe) ? v0.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0xf) ? v0.sf : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x10) ? v1.s0 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x11) ? v1.s1 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x12) ? v1.s2 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x13) ? v1.s3 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x14) ? v1.s4 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x15) ? v1.s5 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x16) ? v1.s6 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x17) ? v1.s7 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x18) ? v1.s8 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x19) ? v1.s9 : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1a) ? v1.sa : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1b) ? v1.sb : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1c) ? v1.sc : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1d) ? v1.sd : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1e) ? v1.se : ret.s9;
  ret.s9 = ((m.s9 & 0x1f) == 0x1f) ? v1.sf : ret.s9;

  ret.sa = ((m.sa & 0x1f) == 0x0) ? v0.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1) ? v0.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x2) ? v0.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x3) ? v0.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x4) ? v0.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x5) ? v0.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x6) ? v0.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x7) ? v0.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x8) ? v0.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x9) ? v0.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xa) ? v0.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xb) ? v0.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xc) ? v0.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xd) ? v0.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xe) ? v0.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0xf) ? v0.sf : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x10) ? v1.s0 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x11) ? v1.s1 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x12) ? v1.s2 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x13) ? v1.s3 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x14) ? v1.s4 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x15) ? v1.s5 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x16) ? v1.s6 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x17) ? v1.s7 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x18) ? v1.s8 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x19) ? v1.s9 : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1a) ? v1.sa : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1b) ? v1.sb : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1c) ? v1.sc : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1d) ? v1.sd : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1e) ? v1.se : ret.sa;
  ret.sa = ((m.sa & 0x1f) == 0x1f) ? v1.sf : ret.sa;

  ret.sb = ((m.sb & 0x1f) == 0x0) ? v0.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1) ? v0.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x2) ? v0.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x3) ? v0.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x4) ? v0.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x5) ? v0.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x6) ? v0.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x7) ? v0.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x8) ? v0.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x9) ? v0.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xa) ? v0.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xb) ? v0.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xc) ? v0.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xd) ? v0.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xe) ? v0.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0xf) ? v0.sf : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x10) ? v1.s0 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x11) ? v1.s1 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x12) ? v1.s2 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x13) ? v1.s3 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x14) ? v1.s4 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x15) ? v1.s5 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x16) ? v1.s6 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x17) ? v1.s7 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x18) ? v1.s8 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x19) ? v1.s9 : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1a) ? v1.sa : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1b) ? v1.sb : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1c) ? v1.sc : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1d) ? v1.sd : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1e) ? v1.se : ret.sb;
  ret.sb = ((m.sb & 0x1f) == 0x1f) ? v1.sf : ret.sb;

  ret.sc = ((m.sc & 0x1f) == 0x0) ? v0.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1) ? v0.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x2) ? v0.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x3) ? v0.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x4) ? v0.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x5) ? v0.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x6) ? v0.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x7) ? v0.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x8) ? v0.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x9) ? v0.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xa) ? v0.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xb) ? v0.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xc) ? v0.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xd) ? v0.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xe) ? v0.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0xf) ? v0.sf : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x10) ? v1.s0 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x11) ? v1.s1 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x12) ? v1.s2 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x13) ? v1.s3 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x14) ? v1.s4 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x15) ? v1.s5 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x16) ? v1.s6 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x17) ? v1.s7 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x18) ? v1.s8 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x19) ? v1.s9 : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1a) ? v1.sa : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1b) ? v1.sb : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1c) ? v1.sc : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1d) ? v1.sd : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1e) ? v1.se : ret.sc;
  ret.sc = ((m.sc & 0x1f) == 0x1f) ? v1.sf : ret.sc;

  ret.sd = ((m.sd & 0x1f) == 0x0) ? v0.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1) ? v0.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x2) ? v0.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x3) ? v0.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x4) ? v0.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x5) ? v0.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x6) ? v0.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x7) ? v0.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x8) ? v0.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x9) ? v0.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xa) ? v0.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xb) ? v0.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xc) ? v0.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xd) ? v0.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xe) ? v0.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0xf) ? v0.sf : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x10) ? v1.s0 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x11) ? v1.s1 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x12) ? v1.s2 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x13) ? v1.s3 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x14) ? v1.s4 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x15) ? v1.s5 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x16) ? v1.s6 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x17) ? v1.s7 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x18) ? v1.s8 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x19) ? v1.s9 : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1a) ? v1.sa : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1b) ? v1.sb : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1c) ? v1.sc : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1d) ? v1.sd : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1e) ? v1.se : ret.sd;
  ret.sd = ((m.sd & 0x1f) == 0x1f) ? v1.sf : ret.sd;

  ret.se = ((m.se & 0x1f) == 0x0) ? v0.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1) ? v0.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x2) ? v0.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x3) ? v0.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x4) ? v0.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x5) ? v0.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x6) ? v0.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x7) ? v0.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x8) ? v0.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x9) ? v0.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0xa) ? v0.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0xb) ? v0.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0xc) ? v0.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0xd) ? v0.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0xe) ? v0.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0xf) ? v0.sf : ret.se;
  ret.se = ((m.se & 0x1f) == 0x10) ? v1.s0 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x11) ? v1.s1 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x12) ? v1.s2 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x13) ? v1.s3 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x14) ? v1.s4 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x15) ? v1.s5 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x16) ? v1.s6 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x17) ? v1.s7 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x18) ? v1.s8 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x19) ? v1.s9 : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1a) ? v1.sa : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1b) ? v1.sb : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1c) ? v1.sc : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1d) ? v1.sd : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1e) ? v1.se : ret.se;
  ret.se = ((m.se & 0x1f) == 0x1f) ? v1.sf : ret.se;

  ret.sf = ((m.sf & 0x1f) == 0x0) ? v0.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1) ? v0.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x2) ? v0.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x3) ? v0.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x4) ? v0.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x5) ? v0.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x6) ? v0.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x7) ? v0.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x8) ? v0.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x9) ? v0.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xa) ? v0.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xb) ? v0.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xc) ? v0.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xd) ? v0.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xe) ? v0.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0xf) ? v0.sf : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x10) ? v1.s0 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x11) ? v1.s1 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x12) ? v1.s2 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x13) ? v1.s3 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x14) ? v1.s4 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x15) ? v1.s5 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x16) ? v1.s6 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x17) ? v1.s7 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x18) ? v1.s8 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x19) ? v1.s9 : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1a) ? v1.sa : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1b) ? v1.sb : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1c) ? v1.sc : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1d) ? v1.sd : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1e) ? v1.se : ret.sf;
  ret.sf = ((m.sf & 0x1f) == 0x1f) ? v1.sf : ret.sf;

  return ret;
}

#endif // defined(cl_khr_fp64)
