/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2004-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl>
 *
 */


#ifndef _VERIFY_LOG_H
#define _VERIFY_LOG_H

/**
 * internal log levels */
#define L_ERROR  0  /* errors */
#define L_WARN   1  /* all unusual */
#define L_INFO   2  /* all status changes etc. */
#define L_DEBUG  3  /* all, including trace */

/**
 * Logs log message with format string msg on loglevel msg_level
 */
#ifdef __GNUC__
void verify_log( int msg_level, const char *msg, ...)
    __attribute__((format(printf, 2, 3)));
#else
void verify_log( int msg_level, const char *msg, ...);
#endif

/**
 * Logs log message, first printing operation, then format string msg on
 * loglevel LOG_ERROR
 */
#ifdef __GNUC__
void verify_error( const char *operation, const char *msg, ...)
    __attribute__((format(printf, 2, 3)));
#else
void verify_error( const char *operation, const char *msg, ...);
#endif


#ifndef ENABLE_LCMAPS_LOGGING
/**
 * Set loglevel to log_lvl (only used when in non-LCMAPS mode)
 */
void verify_set_log_level (int log_lvl);

/**
 * Returns loglevel (only used when in non-LCMAPS mode)
 */
int verify_get_log_level (void);
#endif /* ENABLE_LCMAPS_LOGGING */


#endif /* _VERIFY_LOG_H */
