/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.util.NoSuchElementException;

import net.noderunner.exml.ElementRule.ElementRuleState;

/**
 * Element rule stack.
 * @author Elias Ross
 */
class RuleStack {

	private Stack<ElementRuleState> stack = ArrayStack.create();
	
	/**
	 * Constructs a new RuleStack.
	 */
    public RuleStack() {
    }
    
    /**
     * Encounters a new element, creates a new rule state.
     * @param e element visited
     * @return
     * @throws ElementRuleException if encounter is invalid
     */
    public ElementRuleState startElement() {
		ElementRuleState state = new ElementRuleState();
		stack.push(state);
		return state;
    }
    
    /**
     * Encounters the end of an element.
     */
    public void endElement() {
    	stack.pop();
    }
    
    /**
     * Returns the current element rule state.
     * @throws NoSuchElementException if no state is present
     */
    public ElementRuleState state() {
    	return stack.peek();
    }
	
}
