using System;
using System.Runtime.InteropServices;
 
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html Base class for SBML Level 3 package plug-ins.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * The SBMLExtension class is a component of the libSBML package extension
 * mechanism.  It is an abstract class that is extended by each package
 * extension implementation. @if clike The SBMLExtension class provides
 * methods for managing common attributes of package extensions (e.g.,
 * package name, package version), registration of instantiated
 * SBasePluginCreator objects, and initialization/registration of package
 * extensions when the library code for the package is loaded. @endif
 *
 * @if clike
 * @section sbmlextension-howto How to extend SBMLExtension for a package implementation
 *
 * 
 * Each package implementation must contain a class that extends
 * SBMLExtension.  For example, the class <code>GroupsExtension</code> serves
 * this purpose for the SBML Level&nbsp;3 @em Groups package extension in
 * libSBML. The following subsections detail the basic steps involved in
 * implementing such an extended class.
 *
 * @subsection ext-getpackagename 1. Define the getPackageName() method
 *
 * Define a method named <code>getPackageName()</code> that returns the
 * name of the package as a string.  The following is an example from the
 * implementation of the Groups package extension:
@code{.cpp}
string GroupsExtension::getPackageName ()
{
      static string pkgName = 'groups';
      return pkgName;
}
@endcode
 *
 *
 * @subsection ext-version-methods 2. Define methods returning package version information
 *
 * Define a set of methods that return the default SBML Level, SBML
 * Version and version of the package.  These methods must be named
 * <code>getDefaultLevel()</code>, <code>getDefaultVersion()</code> and
 * <code>getDefaultPackageVersion()</code>, respectively.  The following
 * are examples drawn from the Groups package implementation:
@code{.cpp}
unsigned int GroupsExtension::getDefaultLevel()
{
      return 3;
}
unsigned int GroupsExtension::getDefaultVersion()
{
      return 1;
}
unsigned int GroupsExtension::getDefaultPackageVersion()
{
      return 1;
}
@endcode
 *
 *
 * @subsection ext-ns 3. Define methods returning the package namespace URIs
 *
 * Define methods that return strings representing the XML namespace URI
 * for the package.  One method should be defined for each SBML Level/Version
 * combination for which the package can be used.  For instance, if a package
 * is only usable in SBML Level&nbsp;3 Version&nbsp;1, and the libSBML
 * extension for the package implements version&nbsp;1 of the package, the
 * necessary method is <code>getXmlnsL3V1V1()</code>.  
@code{.cpp}
string GroupsExtension::getXmlnsL3V1V1 ()
{
      static string xmlns = 'http://www.sbml.org/sbml/level3/version1/groups/version1';
      return xmlns;
}
@endcode
 *
 * Define other similar methods to return additional namespace URIs if the
 * package extension implements other package versions or supports other SBML
 * Level/Version combinations.
 *
 *
 * @subsection ext-virtual 4. Override basic pure virtual methods
 *
 * Override the following pure virtual methods on SBMLExtension:
 *
 * @li <code>virtual string getName() =0</code>. This
 * method returns the nickname of the package (e.g., 'layout',
 * 'groups').
 *
 * @li <code>virtual unsigned int getLevel(string &uri) 
 * =0</code>. This method returns the SBML Level with the given URI of
 * this package.
 *
 * @li <code>virtual unsigned int getVersion(string &uri)
 * =0</code>. This method returns the SBML Version with the given
 * URI of this package.
 *
 * @li <code>virtual unsigned int getPackageVersion(string
 * &uri) =0</code>. This method returns the package version with
 * the given URI of this package.
 *
 * @li <code>virtual unsigned int getURI(unsigned int sbmlLevel,
 * unsigned int sbmlVersion, unsigned int pkgVersion) =0</code>.
 * This method returns the URI (namespace) of the package corresponding
 * to the combination of the given SBML Level, SBML Version, and package
 * version
 *
 * @li <code>virtual SBMLExtension clone() = 0</code>. This
 * method creates and returns a deep copy of this derived object.
 *
 * As an example, the following are the versions of these methods for
 * the Groups package:
 * @code{.cpp}
string GroupsExtension::getName() 
{
  return getPackageName();
}

unsigned int GroupsExtension::getLevel(string &uri) 
{
  if (uri == getXmlnsL3V1V1())
    return 3;
  else
    return 0;
}

unsigned int GroupsExtension::getVersion(string &uri) 
{
  if (uri == getXmlnsL3V1V1())
    return 1;
  else
    return 0;
}

unsigned int GroupsExtension::getPackageVersion(string &uri) 
{
  if (uri == getXmlnsL3V1V1())
    return 1;
  else
    return 0;
}

string GroupsExtension::getURI(unsigned int sbmlLevel,
                                           unsigned int sbmlVersion,
                                           unsigned int pkgVersion) 
{
  if (sbmlLevel == 3 && sbmlVersion == 1 && pkgVersion == 1)
    return getXmlnsL3V1V1();

  static string empty = '';
  return empty;
}

GroupsExtension* GroupsExtension::clone() 
{
  return new GroupsExtension(*this);
}
@endcode
 *
 * Constructor, copy constructor, and destructor methods also must be
 * overridden if additional data members are defined in the derived class.
 *
 *
 * @subsection ext-typedef 5. Create SBMLExtensionNamespaces-related definitions
 *
 * Define typedef and template instantiation code for a package-specific
 * subclass of the SBMLExtensionNamespaces template class.  The
 * SBMLExtensionNamespaces template class is a derived class of
 * SBMLNamespaces and can be used as an argument of constructors of
 * SBase-derived classes defined in the package extensions.
 *
 * <ol>
 *
 * <li> Define a typedef.  For example, the typedef for
 * <code>GroupsExtension</code> is implemented in the file
 * <code>GroupsExtension.h</code> as follows:
@code{.cpp}
// GroupsPkgNamespaces is derived from the SBMLNamespaces class.
// It is used when creating a Groups package object of a class
// derived from SBase.
typedef SBMLExtensionNamespaces<GroupsExtension> GroupsPkgNamespaces;
@endcode
 * </li>
 *
 * <li> Define a template instantiation for the typedef.  For example, the
 * template instantiation code for <code>GroupsExtension is</code> implemented
 * in the file <code>GroupsExtension.cpp</code> as follows:
@code{.cpp}
template class LIBSBML_EXTERN SBMLExtensionNamespaces<GroupsExtension>;
@endcode
 * </li>
 *
 * </ol>
 *
 * Here is example of how the resulting class is used.  The definitions above
 * allow a <code>GroupsPkgNamespaces</code> object to be used when creating a
 * new <code>Group</code> object.  The <code>GroupsPkgNamespaces</code> is
 * handed to the constructor as an argument, as shown below:
@code{.cpp}
GroupPkgNamespaces gpns(3, 1, 1);  // SBML Level, Version, & pkg version.
Group g = new Group(&gpns);        // Creates a Group object.
@endcode
 *
 * The <code>GroupsPkgNamespaces</code> object can also be used when creating
 * an SBMLDocument object with the Groups package.  The code fragment
 * below shows an example of this:
@code{.cpp}
   GroupsPkgNamespaces gpns(3, 1, 1);
   SBMLDocument doc;
   doc  = new SBMLDocument(&gnps);
@endcode
 *
 *
 * @subsection ext-virtual-ns 6. Override the method getSBMLExtensionNamespaces()
 *
 * Override the pure virtual method <code>getSBMLExtensionNamespaces()</code>,
 * which returns an SBMLNamespaces derived object.  For example, the method
 * is overridden in the class <code>GroupsExtension</code> as follows:
@code{.cpp}
SBMLNamespaces
GroupsExtension::getSBMLExtensionNamespaces(string &uri) 
{
  GroupsPkgNamespaces* pkgns = null;
  if ( uri == getXmlnsL3V1V1())
  {
    pkgns = new GroupsPkgNamespaces(3, 1, 1);
  }
  return pkgns;
}
@endcode
 *
 *
 * @subsection ext-enum 7. Define an enumeration for the package object type codes
 *
 * Define an enum type for representing the type code of the objects defined
 * in the package extension.  For example, the enumeration
 * <code>SBMLGroupsTypeCode_t</code> for the Groups package is defined in
 * <code>GroupsExtension.h</code> as follows:
@code{.cpp}
typedef enum
{
   SBML_GROUPS_GROUP  = 500
 , SBML_GROUPS_MEMBER = 501
} SBMLGroupsTypeCode_t;
@endcode
 *
 * In the enumeration above, <code>SBML_GROUPS_GROUP</code> corresponds to
 * the <code>Group</code> class (for the <code>&lt;group&gt;</code> element
 * defined by the SBML Level&nbsp;3 Groups package) and
 * <code>SBML_GROUPS_MEMBER</code> corresponds to the <code>Member</code>
 * class (for the <code>&lt;member&gt;</code> element defined by the
 * Level&nbsp;3 Groups package), respectively.
 *
 * Similarly, #SBMLLayoutTypeCode_t for the Layout package is defined in
 * the file <code>LayoutExtension.h</code> as follows:
 *
@code{.cpp}
typedef enum
{
   SBML_LAYOUT_BOUNDINGBOX           = 100
 , SBML_LAYOUT_COMPARTMENTGLYPH      = 101
 , SBML_LAYOUT_CUBICBEZIER           = 102
 , SBML_LAYOUT_CURVE                 = 103
 , SBML_LAYOUT_DIMENSIONS            = 104
 , SBML_LAYOUT_GRAPHICALOBJECT       = 105
 , SBML_LAYOUT_LAYOUT                = 106
 , SBML_LAYOUT_LINESEGMENT           = 107
 , SBML_LAYOUT_POINT                 = 108
 , SBML_LAYOUT_REACTIONGLYPH         = 109
 , SBML_LAYOUT_SPECIESGLYPH          = 110
 , SBML_LAYOUT_SPECIESREFERENCEGLYPH = 111
 , SBML_LAYOUT_TEXTGLYPH             = 112
} SBMLLayoutTypeCode_t;
@endcode
 *
 * These enum values are returned by corresponding <code>getTypeCode()</code>
 * methods.  (E.g., <code>SBML_GROUPS_GROUP</code> is returned in
 * <code>Group::getTypeCode()</code>.)
 *
 * Note that libSBML does not require that type codes are unique across all
 * packages&mdash;the same type codes may be used within individual package
 * extensions.  LibSBML development must permit this because package
 * implementations are developed by separate groups at different times;
 * coordinating the type codes used is impractical.  It does mean that
 * callers must check two things when identifying objects: to distinguish the
 * type codes of different packages, callers much check not only the return
 * value of the method <code>getTypeCode()</code> method but also that of the
 * method <code>getPackageName()</code>.  Here is an example of doing that:
@code{.cpp}
void example (SBase sb)
{
  string pkgName = sb->getPackageName();
  if (pkgName == 'core') {
    switch (sb->getTypeCode()) {
      case SBML_MODEL:
         ....
         break;
      case SBML_REACTION:
         ....
    }
  }
  else if (pkgName == 'layout') {
    switch (sb->getTypeCode()) {
      case SBML_LAYOUT_LAYOUT:
         ....
         break;
      case SBML_LAYOUT_REACTIONGLYPH:
         ....
    }
  }
  else if (pkgName == 'groups') {
    switch (sb->getTypeCode()) {
      case SBML_GROUPS_GROUP:
         ....
         break;
      case SBML_GROUPS_MEMBER:
         ....
    }
  }
  ...
}
@endcode
 *
 * Readers may have noticed that in the #SBMLLayoutTypeCode_t and
 * <code>SBMLGroupsTypeCode_t</code> enumerations above, unique values
 * are in fact assigned to the enumeration values.  This can be convenient
 * when it can be arranged, but it is not required by libSBML.
 *
 *
 * @subsection ext-virtual-typecodes 8. Override the method getStringFromTypeCode()
 *
 * Override the pure virtual method <code>getStringFromTypeCode()</code>,
 * which returns a string corresponding to the given type code.  Here is an
 * example, again drawn from the implementation of the Groups package:
@code{.cpp}
virtual string SBMLExtension::(int typeCode) ;
@endcode
 *
 * For example, the method for the Groups extension is implemented as
 * shown below:
@code{.cpp}
static string SBML_GROUPS_TYPECODE_STRINGS[] =
{
    'Group'
  , 'Member'
};

string GroupsExtension::getStringFromTypeCode(int typeCode) 
{
  int min = SBML_GROUPS_GROUP;
  int max = SBML_GROUPS_MEMBER;

  if (typeCode < min || typeCode > max)
  {
    return '(Unknown SBML Groups Type)';
  }

  return SBML_GROUPS_TYPECODE_STRINGS[typeCode - min];
}
@endcode
 *
 *
 * @subsection ext-init 9. Implement an init() method
 *
 * Implement a <code>static void init()</code> method in the derived class.
 * This method serves to encapsulate initialization code that creates an
 * instance of the derived class and registration code that registers the
 * instance with the SBMLExtensionRegistry class.
 *
 * For example, the <code>init()</code> method for the Groups package is
 * implemented as follows:
@code{.cpp}
void GroupsExtension::init()
{
  // 1. Check if the Groups package has already been registered.

  if ( SBMLExtensionRegistry::getInstance().isRegistered(getPackageName()) )
  {
    // do nothing;
    return;
  }

  // 2. Create an SBMLExtension derived object.

  GroupsExtension gext;

  // 3. Create SBasePluginCreator-derived objects. The derived classes
  // can be instantiated by using the following template class:
  //
  //   template<class SBasePluginType> class SBasePluginCreator
  //
  // The constructor of the creator class takes two arguments:
  //
  // 1) SBaseExtensionPoint: extension point to which the plugin connects
  // 2) std::vector<string>: a vector that contains a list of URI
  // (package versions) supported by the plugin object.
  //
  // For example, two plugin objects are required as part of the Groups
  // implementation: one plugged into SBMLDocument and one into Model.
  // For the former, since the specification for the SBML Groups package
  // mandates that the 'required' flag is always 'false', the existing
  // SBMLDocumentPluginNotRequired class can be used as-is as part of
  // the implementation.  For Model, since the lists of supported
  // package versions (currently only SBML L3V1 Groups V1) are equal
  // in the both plugin objects, the same vector can be handed to each
  // constructor.

  std::vector<string> pkgURIs;
  pkgURIs.push_back(getXmlnsL3V1V1());

  SBaseExtensionPoint docExtPoint('core', SBML_DOCUMENT);
  SBaseExtensionPoint modelExtPoint('core', SBML_MODEL);

  SBasePluginCreator<GroupsSBMLDocumentPlugin, GroupsExtension> docPluginCreator(docExtPoint, pkgURIs);
  SBasePluginCreator<GroupsModelPlugin, GroupsExtension> modelPluginCreator(modelExtPoint, pkgURIs);

  // 4. Add the above objects to the SBMLExtension-derived object.

  gext.addSBasePluginCreator(&docPluginCreator);
  gext.addSBasePluginCreator(&modelPluginCreator);

  // 5. Register the SBMLExtension-derived object with the extension
  // registry, SBMLExtensionRegistry.

  int result = SBMLExtensionRegistry::getInstance().addExtension(&gext);
  if (result != LIBSBML_OPERATION_SUCCESS)
  {
    std::cerr << '[Error] GroupsExtension::init() failed.' << std::endl;
  }
}
@endcode
 *
 *
 * @subsection ext-extensionregister 10. Instantiate a SBMLExtensionRegister object
 *
 * Instantiate a global SBMLExtensionRegister object using the
 * class derived from SBMLExtension (discussed above).  Here is an example for
 * the Groups package extension, for the object <code>GroupsExtension</code>.
 * This could is placed in the <code>GroupsExtension.cpp</code>:
@code{.cpp}
static SBMLExtensionRegister<GroupsExtension> groupsExtensionRegister;
@endcode
 *
 * The <code>init()</code> method on <code>GroupsExtension</code> is
 * automatically invoked when the 'register' object is instantiated.  This
 * results in initialization and registration of the package extension
 * with libSBML.
 *
 *
 * @else
 *
 * @section ext-basics Basic principles of SBML package extensions in libSBML
 *
 * 
 * SBML Level&nbsp;3's package structure permits modular extensions to the
 * core SBML format.  In libSBML, support for SBML Level&nbsp;3 packages is
 * provided through optional <em>package extensions</em> that can be plugged
 * into libSBML at the time it is built/compiled.  Users of libSBML can thus
 * choose which extensions are enabled in their software applications.
 *
 * LibSBML defines a number of classes that developers of package extensions
 * can use to implement support for an SBML Level&nbsp;3 package.  These
 * classes make it easier to extend libSBML objects with new attributes
 * and/or subobjects as needed by a particular Level&nbsp;3 package.
 * Three overall categories of classes make up libSBML's facilities for
 * implementing package extensions.  There are (1) classes that serve as base
 * classes meant to be subclassed, (2) template classes meant to be
 * instantiated rather than subclassed, and (3) support classes that provide
 * utility features. A given package implementation for libSBML will take
 * the form of code using these and other libSBML classes, placed in a
 * subdirectory of <code>src/sbml/packages/</code>.
 *
 * The basic libSBML distribution includes a number of package extensions
 * implementing support for officially-endorsed SBML Level&nbsp;3 packages;
 * among these are <em>Flux Balance Constraints</em> ('fbc'),
 * <em>Hierarchical %Model Composition</em> ('comp'), <em>%Layout</em>
 * ('layout'), and <em>Qualitative Models</em> ('qual').  They can serve as
 * working examples for developers working to implement other packages.
 *
 * Extensions in libSBML can currently only be implemented in C++ or C;
 * there is no mechanism to implement them first in languages such as
 * Java or Python.  However, once implemented in C++ or C, language
 * interfaces can be generated semi-automatically using the framework in
 * place in libSBML.  (The approach is based on using <a target='_blank'
 * href='http://www.swig.org'>SWIG</a> and facilities in libSBML's build
 * system.)
 *
 *
 * @endif
 *
 * @section sbmlextension-l2-special Special handling for SBML Level&nbsp;2
 *
 * 
 * Due to the historical background of the SBML %Layout package, libSBML
 * implements special behavior for that package: it @em always creates a
 * %Layout plugin object for any SBML Level&nbsp;2 document it reads in,
 * regardless of whether that document actually uses %Layout constructs.  This
 * is unlike the case for SBML Level&nbsp;3 documents that use %Layout; for
 * them, libSBML will @em not create a plugin object unless the document
 * actually declares the use of the %Layout package (via the usual Level&nbsp;3
 * namespace declaration for Level&nbsp;3 packages).
 *
 * This has the following consequence.  If an application queries for the
 * presence of %Layout in an SBML Level&nbsp;2 document by testing only for
 * the existence of the plugin object, <strong>it will always get a positive
 * result</strong>; in other words, the presence of a %Layout extension
 * object is not an indication of whether a read-in Level&nbsp;2 document
 * does or does not use SBML %Layout.  Instead, callers have to query
 * explicitly for the existence of layout information.  An example of such a
 * query is the following code:
 * @if cpp
@code{.cpp}
// Assume 'm' below is a Model object.
LayoutModelPlugin* lmp = static_cast<LayoutModelPlugin*>(m->getPlugin('layout'));
if (lmp != null)
{
  unsigned int numLayouts = lmp->getNumLayouts();
  // If numLayouts is greater than zero, then the model uses Layout.
}
@endcode
@endif
@if python
@code{.py}
# Assume 'doc' below is an SBMLDocument object.
m = doc.getModel()
if m != None:
    layoutPlugin = m.getPlugin('layout')
    if layoutPlugin != None:
        numLayouts = layoutPlugin.getNumLayouts()
        # If numLayouts is greater than zero, then the model uses Layout.
@endcode
@endif
@if java
@code{.java}
// Assume 'doc' below is an SBMLDocument object.
Model m = doc.getModel();
LayoutModelPlugin lmp = (LayoutModelPlugin) m.getPlugin('layout');
if (lmp != null)
{
  int numLayouts = lmp.getNumLayouts();
  // If numLayouts is greater than zero, then the model uses Layout.
}
@endcode
@endif
@if csharp
@code{.cs}
// Assume 'doc' below is an SBMLDocument object.
Model m = doc.getModel();
LayoutModelPlugin lmp = (LayoutModelPlugin) m.getPlugin('layout');
if (lmp != null)
{
  int numLayouts = lmp.getNumLayouts();
  // If numLayouts is greater than zero, then the model uses Layout.
}
@endcode
@endif
 *
 * The special, always-available Level&nbsp;2 %Layout behavior was motivated
 * by a desire to support legacy applications.  In SBML Level&nbsp;3, the
 * %Layout package uses the normal SBML Level&nbsp;3 scheme of requiring
 * declarations on the SBML document element.  This means that upon reading a
 * model, libSBML knows right away whether it contains layout information.
 * In SBML Level&nbsp;2, there is no top-level declaration because layout is
 * stored as annotations in the body of the model.  Detecting the presence of
 * layout information when reading a Level&nbsp;2 model requires parsing the
 * annotations.  For efficiency reasons, libSBML normally does not parse
 * annotations automatically when reading a model.  However, applications
 * that predated the introduction of Level&nbsp;3 %Layout and the updated
 * version of libSBML never had to do anything special to enable parsing
 * layout; the facilities were always available for every Level&nbsp;2 model
 * as long as libSBML was compiled with %Layout support.  To avoid burdening
 * developers of legacy applications with the need to modify their software,
 * libSBML provides backward compatibility by always preloading the %Layout
 * package extension when reading Level&nbsp;2 models.  The same applies to
 * the creation of Level&nbsp;2 models: with the plugin-oriented libSBML,
 * applications normally would have to take deliberate steps to activate
 * package code, instantiate objects, manage namespaces, and so on.  LibSBML
 * again loads the %Layout package plugin automatically when creating a
 * Level&nbsp;2 model, thereby making the APIs available to legacy
 * applications without further work on their part.
 *
 * @if clike
 * The mechanisms for triggering this Level&nbsp;2-specific behavior
 * involves a set of virtual methods on the SBMLExtension class that must
 * be implemented by individual package extensions.  These methods are
 * SBMLExtension::addL2Namespaces(),
 * SBMLExtension::removeL2Namespaces(), and
 * SBMLExtension::enableL2NamespaceForDocument().
 * @endif
 *
 *
 */

public class SBMLExtension : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal SBMLExtension(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(SBMLExtension obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (SBMLExtension obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~SBMLExtension() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_SBMLExtension(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  public virtual SBasePlugin DowncastSBasePlugin(IntPtr cPtr, bool owner)
  {
    if (cPtr.Equals(IntPtr.Zero)) return null;
	return new SBasePlugin(cPtr, owner);
  }

  public virtual SBase DowncastSBase(IntPtr cPtr, bool owner)
  {
    if (cPtr.Equals(IntPtr.Zero)) return null;	  
    return new SBase(cPtr, owner);
  }

  
/**
   * Returns the number of SBasePluginCreatorBase objects stored in this
   * object.
   *
   * @return the total number of SBasePluginCreatorBase objects stored in
   * this SBMLExtension-derived object.
   */ public
 int getNumOfSBasePlugins() {
    int ret = libsbmlPINVOKE.SBMLExtension_getNumOfSBasePlugins(swigCPtr);
    return ret;
  }

  
/**
   * Returns the number of supported package namespace URIs.
   *
   * @return the number of supported package XML namespace URIs of this
   * package extension.
   */ public
 long getNumOfSupportedPackageURI() { return (long)libsbmlPINVOKE.SBMLExtension_getNumOfSupportedPackageURI(swigCPtr); }

  
/**
   * Returns @c true if the given XML namespace URI is supported by this
   * package extension.
   *
   * @return @c true if the given XML namespace URI (equivalent to a package
   * version) is supported by this package extension, @c false otherwise.
   */ public
 bool isSupported(string uri) {
    bool ret = libsbmlPINVOKE.SBMLExtension_isSupported(swigCPtr, uri);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns the nth XML namespace URI.
   *
   * @param n the index number of the namespace URI being sought.

   * @return a string representing the XML namespace URI understood to be
   * supported by this package.  An empty string will be returned if there is
   * no nth URI.
   */ public
 string getSupportedPackageURI(long n) {
    string ret = libsbmlPINVOKE.SBMLExtension_getSupportedPackageURI(swigCPtr, n);
    return ret;
  }

  
/**
   * Creates and returns a deep copy of this SBMLExtension object.
   *
   * @return a (deep) copy of this SBMLExtension object.
   *
   *
 * @note
 * This is a method that package extension implementations must override.
 * See the libSBML documentation on extending libSBML to support SBML
 * packages for more information on this topic.
 *
 *
   */ public new
 SBMLExtension clone() {
        SBMLExtension ret
	    = (SBMLExtension) libsbml.DowncastExtension(libsbmlPINVOKE.SBMLExtension_clone(swigCPtr), true);
        return ret;
}

  
/**
   * Returns the nickname of this package.
   *
   * This returns the short-form name of an SBML Level&nbsp;3 package
   * implemented by a given SBMLExtension-derived class.  Examples of
   * such names are 'layout', 'fbc', etc.
   *
   * @return a string, the nickname of SBML package.
   *
   *
 * @note
 * This is a method that package extension implementations must override.
 * See the libSBML documentation on extending libSBML to support SBML
 * packages for more information on this topic.
 *
 *
   */ public new
 string getName() {
    string ret = libsbmlPINVOKE.SBMLExtension_getName(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML namespace URI for a given Level and Version.
   *
   * @param sbmlLevel the SBML Level.
   * @param sbmlVersion the SBML Version.
   * @param pkgVersion the version of the package.
   *
   * @return a string, the XML namespace URI for the package for the given
   * SBML Level, SBML Version, and package version.
   *
   *
 * @note
 * This is a method that package extension implementations must override.
 * See the libSBML documentation on extending libSBML to support SBML
 * packages for more information on this topic.
 *
 *
   */ public new
 string getURI(long sbmlLevel, long sbmlVersion, long pkgVersion) {
    string ret = libsbmlPINVOKE.SBMLExtension_getURI(swigCPtr, sbmlLevel, sbmlVersion, pkgVersion);
    return ret;
  }

  
/**
   * Returns the SBML Level associated with the given XML namespace URI.
   *
   * @param uri the string of URI that represents a version of the package.
   *
   * @return the SBML Level associated with the given URI of this package.
   *
   *
 * @note
 * This is a method that package extension implementations must override.
 * See the libSBML documentation on extending libSBML to support SBML
 * packages for more information on this topic.
 *
 *
   */ public new
 long getLevel(string uri) { return (long)libsbmlPINVOKE.SBMLExtension_getLevel(swigCPtr, uri); }

  
/**
   * Returns the SBML Version associated with the given XML namespace URI.
   *
   * @param uri the string of URI that represents a version of the package.
   *
   * @return the SBML Version associated with the given URI of this package.
   *
   *
 * @note
 * This is a method that package extension implementations must override.
 * See the libSBML documentation on extending libSBML to support SBML
 * packages for more information on this topic.
 *
 *
   */ public new
 long getVersion(string uri) { return (long)libsbmlPINVOKE.SBMLExtension_getVersion(swigCPtr, uri); }

  
/**
   * Returns the package version associated with the given XML namespace URI.
   *
   * @param uri the string of URI that represents a version of this package.
   *
   * @return the package version associated with the given URI of this package.
   *
   *
 * @note
 * This is a method that package extension implementations must override.
 * See the libSBML documentation on extending libSBML to support SBML
 * packages for more information on this topic.
 *
 *
   */ public new
 long getPackageVersion(string uri) { return (long)libsbmlPINVOKE.SBMLExtension_getPackageVersion(swigCPtr, uri); }

  
/**
   * Returns a string representation of a type code.
   *
   * This method takes a numerical type code @p typeCode for a component
   * object implemented by this package extension, and returns a string
   * representing that type code.
   *
   * @param typeCode the type code to turn into a string.
   *
   * @return the string representation of @p typeCode.
   *
   *
 * @note
 * This is a method that package extension implementations must override.
 * See the libSBML documentation on extending libSBML to support SBML
 * packages for more information on this topic.
 *
 *
   */ public new
 string getStringFromTypeCode(int typeCode) {
    string ret = libsbmlPINVOKE.SBMLExtension_getStringFromTypeCode(swigCPtr, typeCode);
    return ret;
  }

  
/**
   * Returns a specialized SBMLNamespaces object corresponding to a given
   * namespace URI.
   *
   * LibSBML package extensions each define a subclass of
   * @if clike SBMLExtensionNamespaces @else SBMLNamespaces@endif.
   * @if clike This object has the form
   * @verbatim
SBMLExtensionNamespaces<class SBMLExtensionType>
@endverbatim
   * For example, this kind of object for the Layout package is
   * @verbatim
SBMLExtensionNamespaces<LayoutExtension>
@endverbatim
@endif
   * The present method returns the appropriate object corresponding
   * to the given XML namespace URI in argument @p uri.
   *
   * @param uri the namespace URI that represents one of versions of the
   * package implemented in this extension.
   *
   * @return an @if clike SBMLExtensionNamespaces @else SBMLNamespaces @endif 
   * object, or @c null if the given @p uri is not defined in the
   * corresponding package.
   *
   *
 * @note
 * This is a method that package extension implementations must override.
 * See the libSBML documentation on extending libSBML to support SBML
 * packages for more information on this topic.
 *
 *
   */ public new
 SBMLNamespaces getSBMLExtensionNamespaces(string uri) {
	SBMLNamespaces ret
	    = (SBMLNamespaces) libsbml.DowncastSBMLNamespaces(libsbmlPINVOKE.SBMLExtension_getSBMLExtensionNamespaces(swigCPtr, uri), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
/**
   * Enable or disable this package.
   *
   * @param isEnabled flag indicating whether to enable (if @c true) or
   * disable (@c false) this package extension.
   *
   * @return @c true if this call succeeded; @c false otherwise.
   */ public
 bool setEnabled(bool isEnabled) {
    bool ret = libsbmlPINVOKE.SBMLExtension_setEnabled(swigCPtr, isEnabled);
    return ret;
  }

  
/**
   * Returns @c true if this package is enabled.
   *
   * @return @c true if this package is enabled, @c false otherwise.
   */ public
 bool isEnabled() {
    bool ret = libsbmlPINVOKE.SBMLExtension_isEnabled(swigCPtr);
    return ret;
  }

  
/**
   * Removes the package's Level&nbsp;2 namespace(s).
   *
   * @ifnot clike @internal @endif
   *
   *
 * 
 * This method is related to special facilities designed to support
 * legacy behaviors surrounding SBML Level&nbsp;2 models.  Due to the
 * historical background of the SBML %Layout package, libSBML implements
 * special behavior for that package: it @em always creates a %Layout
 * plugin object for any SBML Level&nbsp;2 document it reads in,
 * regardless of whether that document actually uses %Layout constructs.
 * Since Level&nbsp;2 does not use namespaces on the top level of the
 * SBML document object, libSBML simply keys off the fact that the model
 * is a Level&nbsp;2 model.  To allow the extensions for the %Layout and
 * %Render (and possibly other) packages to support this behavior, the
 * SBMLExtension class contains special methods to allow packages to
 * hook themselves into the Level&nbsp;2 parsing apparatus when necessary.
 *
 * @if clike
 * This virtual method should be overridden by all package extensions
 * that want to serialize to an SBML Level&nbsp;2 annotation.  In
 * Level&nbsp;2, the XML namespace declaration for the package is not
 * placed on the top-level SBML document object but rather inside
 * individual annotations.  addL2Namespaces() is invoked automatically
 * for Level&nbsp;2 documents when an SBMLExtensionNamespace object is
 * created; removeL2Namespaces() is automatically invoked by
 * SBMLDocument to prevent the namespace(s) from being put on the
 * top-level SBML Level&nbsp;2 element (because Level&nbsp;2 doesn't
 * support namespaces there); and enableL2NamespaceForDocument() is
 * called automatically when any SBML document (of any Level/Version) is
 * read in.
 * @endif
   *
   * @param xmlns an XMLNamespaces object that will be used for the annotation.
   * Implementations should override this method with something that removes
   * the package's namespace(s) from the set of namespaces in @p xmlns.  For
   * instance, here is the code from the %Layout package extension:
   * @code{.cpp}
for (int n = 0; n < xmlns->getNumNamespaces(); n++)
{
  if (xmlns->getURI(n) == LayoutExtension::getXmlnsL2())
    xmlns->remove(n);
}
@endcode
   */ public new
 void removeL2Namespaces(XMLNamespaces xmlns) {
    libsbmlPINVOKE.SBMLExtension_removeL2Namespaces(swigCPtr, XMLNamespaces.getCPtr(xmlns));
  }

  
/**
   * Adds the package's Level&nbsp;2 namespace(s).
   *
   * @ifnot clike @internal @endif
   *
   *
 * 
 * This method is related to special facilities designed to support
 * legacy behaviors surrounding SBML Level&nbsp;2 models.  Due to the
 * historical background of the SBML %Layout package, libSBML implements
 * special behavior for that package: it @em always creates a %Layout
 * plugin object for any SBML Level&nbsp;2 document it reads in,
 * regardless of whether that document actually uses %Layout constructs.
 * Since Level&nbsp;2 does not use namespaces on the top level of the
 * SBML document object, libSBML simply keys off the fact that the model
 * is a Level&nbsp;2 model.  To allow the extensions for the %Layout and
 * %Render (and possibly other) packages to support this behavior, the
 * SBMLExtension class contains special methods to allow packages to
 * hook themselves into the Level&nbsp;2 parsing apparatus when necessary.
 *
 * @if clike
 * This virtual method should be overridden by all package extensions
 * that want to serialize to an SBML Level&nbsp;2 annotation.  In
 * Level&nbsp;2, the XML namespace declaration for the package is not
 * placed on the top-level SBML document object but rather inside
 * individual annotations.  addL2Namespaces() is invoked automatically
 * for Level&nbsp;2 documents when an SBMLExtensionNamespace object is
 * created; removeL2Namespaces() is automatically invoked by
 * SBMLDocument to prevent the namespace(s) from being put on the
 * top-level SBML Level&nbsp;2 element (because Level&nbsp;2 doesn't
 * support namespaces there); and enableL2NamespaceForDocument() is
 * called automatically when any SBML document (of any Level/Version) is
 * read in.
 * @endif
   *
   * @param xmlns an XMLNamespaces object that will be used for the annotation.
   * Implementation should override this method with something that adds
   * the package's namespace(s) to the set of namespaces in @p xmlns.  For
   * instance, here is the code from the %Layout package extension:
   * @code{.cpp}
if (!xmlns->containsUri( LayoutExtension::getXmlnsL2()))
  xmlns->add(LayoutExtension::getXmlnsL2(), 'layout');
@endcode
   */ public new
 void addL2Namespaces(XMLNamespaces xmlns) {
    libsbmlPINVOKE.SBMLExtension_addL2Namespaces(swigCPtr, XMLNamespaces.getCPtr(xmlns));
  }

  
/**
   * Called to enable the package on the SBMLDocument object.
   *
   * @ifnot clike @internal @endif
   *
   *
 * 
 * This method is related to special facilities designed to support
 * legacy behaviors surrounding SBML Level&nbsp;2 models.  Due to the
 * historical background of the SBML %Layout package, libSBML implements
 * special behavior for that package: it @em always creates a %Layout
 * plugin object for any SBML Level&nbsp;2 document it reads in,
 * regardless of whether that document actually uses %Layout constructs.
 * Since Level&nbsp;2 does not use namespaces on the top level of the
 * SBML document object, libSBML simply keys off the fact that the model
 * is a Level&nbsp;2 model.  To allow the extensions for the %Layout and
 * %Render (and possibly other) packages to support this behavior, the
 * SBMLExtension class contains special methods to allow packages to
 * hook themselves into the Level&nbsp;2 parsing apparatus when necessary.
 *
 * @if clike
 * This virtual method should be overridden by all package extensions
 * that want to serialize to an SBML Level&nbsp;2 annotation.  In
 * Level&nbsp;2, the XML namespace declaration for the package is not
 * placed on the top-level SBML document object but rather inside
 * individual annotations.  addL2Namespaces() is invoked automatically
 * for Level&nbsp;2 documents when an SBMLExtensionNamespace object is
 * created; removeL2Namespaces() is automatically invoked by
 * SBMLDocument to prevent the namespace(s) from being put on the
 * top-level SBML Level&nbsp;2 element (because Level&nbsp;2 doesn't
 * support namespaces there); and enableL2NamespaceForDocument() is
 * called automatically when any SBML document (of any Level/Version) is
 * read in.
 * @endif
   *
   * @param doc the SBMLDocument object for the model.
   * Implementations should override this method with something that
   * enables the package based on the package's namespace(s). For example,
   * here is the code from the %Layout package extension:
   * @code{.cpp}
if (doc->getLevel() == 2)
  doc->enablePackage(LayoutExtension::getXmlnsL2(), 'layout', true);
@endcode
   */ public new
 void enableL2NamespaceForDocument(SBMLDocument doc) {
    libsbmlPINVOKE.SBMLExtension_enableL2NamespaceForDocument(swigCPtr, SBMLDocument.getCPtr(doc));
  }

  
/**
   * Indicates whether this extension is being used by the given SBMLDocument.
   *
   * The default implementation returns @c true.  This means that when a
   * document had this extension enabled, it will not be possible to convert
   * it to SBML Level&nbsp;2 as we cannot make sure that the extension can be
   * converted.
   *
   * @param doc the SBML document to test.
   *
   * @return a boolean indicating whether the extension is actually being
   * used by the document.
   */ public new
 bool isInUse(SBMLDocument doc) {
    bool ret = libsbmlPINVOKE.SBMLExtension_isInUse(swigCPtr, SBMLDocument.getCPtr(doc));
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 bool hasMultipleVersions() {
    bool ret = libsbmlPINVOKE.SBMLExtension_hasMultipleVersions(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 long getErrorTableIndex(long errorId) { return (long)libsbmlPINVOKE.SBMLExtension_getErrorTableIndex(swigCPtr, errorId); }

  
/** */ /* libsbml-internal */ public new
 long getErrorIdOffset() { return (long)libsbmlPINVOKE.SBMLExtension_getErrorIdOffset(swigCPtr); }

  
/** */ /* libsbml-internal */ public
 long getSeverity(long index, long pkgVersion) { return (long)libsbmlPINVOKE.SBMLExtension_getSeverity(swigCPtr, index, pkgVersion); }

  
/** */ /* libsbml-internal */ public
 long getCategory(long index) { return (long)libsbmlPINVOKE.SBMLExtension_getCategory(swigCPtr, index); }

  
/** */ /* libsbml-internal */ public
 string getMessage(long index, long pkgVersion, string details) {
    string ret = libsbmlPINVOKE.SBMLExtension_getMessage(swigCPtr, index, pkgVersion, details);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 string getShortMessage(long index) {
    string ret = libsbmlPINVOKE.SBMLExtension_getShortMessage(swigCPtr, index);
    return ret;
  }

}

}
