/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  An error, warning or other diagnostic.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * When a libSBML operation on SBML content results in an error, or when
 * there is something wrong with the SBML content, the problems are
 * reported as {@link SBMLError} objects.  These are generally stored in an
 * {@link SBMLErrorLog} object; this log object, in turn, is kept in the
 * {@link SBMLDocument} object containing the SBML content.  Applications can
 * obtain the list of logged errors using {@link SBMLDocument#getErrorLog()} and
 * then use the methods provided by {@link SBMLErrorLog} to access individual
 * {@link SBMLError} objects.  (Note that despite the word 'error' in the name,
 * {@link SBMLError} objects are used to represent not only 'true' errors, but also
 * warnings and some informational diagnostics.  The name is a historical
 * hold-over from early versions of libSBML, in which the object really was
 * only used to report errors.)
 <p>
 * Each {@link SBMLError} object instance has an identification number that
 * identifies the nature of the problem.  This 'error id' number will be up
 * to five digits long, and it will come from one of two sets of static
 * integer constants defined in the interface class <code><a
 * href='libsbmlConstants.html'> libsbmlConstants</a></code>: either the
 * SBML error identifiers <a class='el' href='#SBMLErrorCode_t'> (described
 * below)</a> or the XML error identifiers (described in the documentation
 * for the class <code><a href='XMLError.html'> {@link XMLError}</a></code>).  The
 * former set of constants includes all the SBML validation rule numbers
 * listed in the appendices of the SBML specification documents, as well as
 * some additional libSBML-specific error codes.
 <p>
 * Error codes are useful mainly for software.  For human readers,
 * {@link SBMLError} also includes text messages that describe the nature of a
 * given problem.  The messages can be accessed using
 * {@link SBMLError#getShortMessage()} and {@link SBMLError#getMessage()}.  The former
 * provides a brief one-line description of the issue, while
 * {@link SBMLError#getMessage()} provides a more detailed text, including (if
 * appropriate) references to sections of the SBML specifications where
 * relevant topics are discussed.  These text strings are suitable for
 * displaying to human users.
 <p>
 * An {@link SBMLError} object also contains a category code; its value may be
 * retrieved using the method {@link SBMLError#getCategory()}.  Category values
 * are drawn from a set of static integer constants
 * defined in <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>,
 * and having names beginning with the characters
 * <code>LIBSBML_CAT_</code>.  The list of possible codes is described in a
 * separate section below.  Categories are used to partition errors into
 * distinct conceptual groups.  This is principally used by the libSBML
 * validation system to group classes of validation checks.  For example,
 * {@link libsbmlConstants#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY}
 * is the category for tests that check identifier consistency;
 * {@link libsbmlConstants#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY}
 * is the category for MathML consistency checking; and
 * so on.
 <p>
 * In addition, {@link SBMLError} also has a severity code.  Its value may be
 * retrieved using the method {@link SBMLError#getSeverity()}.  The possible
 * severity values are the same as those reported by <code><a href='XMLError.html'>XMLError</a></code>.
 * Severity levels currently range from informational
 * ({@link libsbmlConstants#LIBSBML_SEV_INFO LIBSBML_SEV_INFO})
 * to fatal errors
 * ({@link libsbmlConstants#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL}).
 * They can be
 * used by an application to evaluate how serious a given problem
 * is.
 <p>
 * {@link SBMLError} also tracks the Level&nbsp;3 package extension, if any, was
 * responsible for a given warning or error.  Each diagnostic code logged by
 * an libSBML extension for SBML Level&nbsp;3 packages includes a record of
 * the package that logged it.  It can be retrieved using
 * {@link SBMLError#getPackage()}.  The information is a simple text string; the
 * string will be the nickname of the package, such as <code>'comp'</code> for the
 * Hierarchical Model Composition package, <code>'fbc'</code> for the Flux Balance
 * Constraints package, and so on.  If the value returned by
 * {@link SBMLError#getPackage()} is an empty string or has the value <code>'core'</code>,
 * then the error came from libSBML core.
 <p>
 * Finally, {@link SBMLError} records the line and column near where the problem
 * occurred in the SBML content.  The values may be retrieved using the
 * methods {@link SBMLError#getLine()} and {@link SBMLError#getColumn()}.  We say 'near',
 * because a lot of factors affect how accurate the line/column information
 * ultimately is.  For example, different XML parsers have different
 * conventions for which line and column number they report for a
 * particular problem (which makes a difference when a problem involves an
 * opening XML tag on one line and a closing tag on another line).  In some
 * situations, some parsers report invalid line and/or column numbers
 * altogether.  If this occurs, libSBML sets the line and/or column number
 * in the {@link SBMLError} object to the the value of the maximum unsigned long
 * integer representable on the platform where libSBML is running.  (This
 * is equal to the constant named <code>ULONG_MAX</code> in C and C++.)
 * The probability that a true line or column number in an SBML model would
 * equal this value is vanishingly small; thus, if an application
 * encounters these values in an {@link XMLError} object, it can assume no valid
 * line/column number could be provided by libSBML in that situation.
 <p>
 * <h3><a class='anchor'
 * name='SBMLErrorCode_t'>Error codes associated with {@link SBMLError} objects</a></h3>
 <p>
 * The error and warning codes returned by libSBML are listed in the table
 * below.  The method {@link SBMLError#getErrorId()} returns the error code of a
 * given {@link SBMLError} object instance.  In the libSBML Java language
 * interface, these error identifiers are currently
 * implemented as static integer constants defined in the interface class
 * <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>.  This
 * is admittedly not an ideal approach from the standpoint of modern Java
 * programming, but it was necessary to work around the lack of
 * enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
 * use a proper Java enumeration type to define the error identifiers.
 <p>
 * In this table, the right-hand columns titled 'L1V1', 'L1V2', etc. refer
 * to Levels and Versions of the SBML specifications, and the entries in
 * each column refer to whether the severity of the condition in that
 * particular Level+Version of SBML.  The codes stand for the following:
 <p>
 * <table cellspacing='1' cellpadding='2' border='0' class='normal-font'>
 * <tr><td class='s-na'></td><td>= Not applicable</td></tr>
 * <tr><td class='s-warning'></td><td>= Warning</td></tr>
 * <tr><td class='s-error'></td><td>= Error</td></tr>
 * <tr><td class='s-fatal'></td><td>= Fatal</td></tr>
 * </table>
 <p>
 * The text shown in the 'Meaning' is the text returned by the
 * {@link SBMLError#getShortMessage()} method on a given {@link SBMLError} object.  A
 * longer and (hopefully) clearer explanation of the issue is returned by
 * {@link SBMLError#getMessage()}.
 <p>
 * The error codes come from different lists depending on whether they're
 * from libSBML core or from an SBML Level&nbsp;3 package extension.
 <p>
 * However, in the language interfaces other than C++, all
 * libSBML error codes are ultimately represented as integer constants rather
 * than separate enumerations lists, and they are all stored in a single
 * interface class.  Codes from different libSBML extensions have names that
 * begin with the package's nickname, such as <code>Qual</code> for
 * the Qualitative Models package, <code>Layout</code> for the Layout
 * package, and so on.  If the name of a code does not begin with one of
 * the package nicknames (<code>Layout</code>, <code>Fbc</code>,
 * <code>Comp</code>, <code>Qual</code>, etc.), then it is a code
 * from libSBML core.
 <p>
 * <p>
<table id='sbmlerror-table'
       class='text-table small-font alt-row-colors'
       width='95%' cellspacing='1' cellpadding='2' border='0'>
 <tr style='background: lightgray' class='normal-font'>
     <th valign='bottom'><strong>Enumerator</strong></th>
     <th valign='bottom'><strong>Meaning</strong></th>
     <th align='center' width='10'>L1 V1</th>
     <th align='center' width='10'>L1 V2</th>
     <th align='center' width='10'>L2 V1</th>
     <th align='center' width='10'>L2 V2</th>
     <th align='center' width='10'>L2 V3</th>
     <th align='center' width='10'>L2 V4</th>
     <th align='center' width='10'>L3 V1</th>
     <th align='center' width='10'>L3 V2</th>
 </tr>
<tr><td class='code'>{@link libsbmlConstants#XMLUnknownError XMLUnknownError}</td>
<td class='meaning'>Unknown error</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLOutOfMemory XMLOutOfMemory}</td>
<td class='meaning'>Out of memory</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLFileUnreadable XMLFileUnreadable}</td>
<td class='meaning'>File unreadable</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLFileUnwritable XMLFileUnwritable}</td>
<td class='meaning'>File unwritable</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLFileOperationError XMLFileOperationError}</td>
<td class='meaning'>File operation error</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLNetworkAccessError XMLNetworkAccessError}</td>
<td class='meaning'>Network access error</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InternalXMLParserError InternalXMLParserError}</td>
<td class='meaning'>Internal XML parser error</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UnrecognizedXMLParserCode UnrecognizedXMLParserCode}</td>
<td class='meaning'>Unrecognized XML parser code</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLTranscoderError XMLTranscoderError}</td>
<td class='meaning'>Transcoder error</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingXMLDecl MissingXMLDecl}</td>
<td class='meaning'>Missing XML declaration</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingXMLEncoding MissingXMLEncoding}</td>
<td class='meaning'>Missing XML encoding attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLDecl BadXMLDecl}</td>
<td class='meaning'>Bad XML declaration</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLDOCTYPE BadXMLDOCTYPE}</td>
<td class='meaning'>Bad XML DOCTYPE</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidCharInXML InvalidCharInXML}</td>
<td class='meaning'>Invalid character</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadlyFormedXML BadlyFormedXML}</td>
<td class='meaning'>Badly formed XML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UnclosedXMLToken UnclosedXMLToken}</td>
<td class='meaning'>Unclosed token</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidXMLConstruct InvalidXMLConstruct}</td>
<td class='meaning'>Invalid XML construct</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLTagMismatch XMLTagMismatch}</td>
<td class='meaning'>XML tag mismatch</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateXMLAttribute DuplicateXMLAttribute}</td>
<td class='meaning'>Duplicate attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UndefinedXMLEntity UndefinedXMLEntity}</td>
<td class='meaning'>Undefined XML entity</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadProcessingInstruction BadProcessingInstruction}</td>
<td class='meaning'>Bad XML processing instruction</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLPrefix BadXMLPrefix}</td>
<td class='meaning'>Bad XML prefix</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLPrefixValue BadXMLPrefixValue}</td>
<td class='meaning'>Bad XML prefix value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingXMLRequiredAttribute MissingXMLRequiredAttribute}</td>
<td class='meaning'>Missing required attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLAttributeTypeMismatch XMLAttributeTypeMismatch}</td>
<td class='meaning'>Attribute type mismatch</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLBadUTF8Content XMLBadUTF8Content}</td>
<td class='meaning'>Bad UTF8 content</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingXMLAttributeValue MissingXMLAttributeValue}</td>
<td class='meaning'>Missing attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLAttributeValue BadXMLAttributeValue}</td>
<td class='meaning'>Bad attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLAttribute BadXMLAttribute}</td>
<td class='meaning'>Bad XML attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UnrecognizedXMLElement UnrecognizedXMLElement}</td>
<td class='meaning'>Unrecognized XML element</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLComment BadXMLComment}</td>
<td class='meaning'>Bad XML comment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLDeclLocation BadXMLDeclLocation}</td>
<td class='meaning'>Bad XML declaration location</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLUnexpectedEOF XMLUnexpectedEOF}</td>
<td class='meaning'>Unexpected EOF</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLIDValue BadXMLIDValue}</td>
<td class='meaning'>Bad XML ID value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLIDRef BadXMLIDRef}</td>
<td class='meaning'>Bad XML IDREF</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UninterpretableXMLContent UninterpretableXMLContent}</td>
<td class='meaning'>Uninterpretable XML content</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadXMLDocumentStructure BadXMLDocumentStructure}</td>
<td class='meaning'>Bad XML document structure</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidAfterXMLContent InvalidAfterXMLContent}</td>
<td class='meaning'>Invalid content after XML content</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLExpectedQuotedString XMLExpectedQuotedString}</td>
<td class='meaning'>Expected quoted string</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLEmptyValueNotPermitted XMLEmptyValueNotPermitted}</td>
<td class='meaning'>Empty value not permitted</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLBadNumber XMLBadNumber}</td>
<td class='meaning'>Bad number</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLBadColon XMLBadColon}</td>
<td class='meaning'>Colon character not permitted</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingXMLElements MissingXMLElements}</td>
<td class='meaning'>Missing XML elements</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#XMLContentEmpty XMLContentEmpty}</td>
<td class='meaning'>Empty XML content</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UnknownError UnknownError}</td>
<td class='meaning'>Encountered unknown internal libSBML error</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NotUTF8 NotUTF8}</td>
<td class='meaning'>File does not use UTF-8 encoding</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UnrecognizedElement UnrecognizedElement}</td>
<td class='meaning'>Encountered unrecognized element</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NotSchemaConformant NotSchemaConformant}</td>
<td class='meaning'>Document does not conform to the SBML XML schema</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3NotSchemaConformant L3NotSchemaConformant}</td>
<td class='meaning'>Document is not well-formed XML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidMathElement InvalidMathElement}</td>
<td class='meaning'>Invalid MathML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DisallowedMathMLSymbol DisallowedMathMLSymbol}</td>
<td class='meaning'>Disallowed MathML symbol found</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DisallowedMathMLEncodingUse DisallowedMathMLEncodingUse}</td>
<td class='meaning'>Use of the MathML 'encoding' attribute is not allowed on this element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DisallowedDefinitionURLUse DisallowedDefinitionURLUse}</td>
<td class='meaning'>Use of the MathML 'definitionURL' attribute is not allowed on this element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadCsymbolDefinitionURLValue BadCsymbolDefinitionURLValue}</td>
<td class='meaning'>Invalid <code>&lt;csymbol&gt;</code> 'definitionURL' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DisallowedMathTypeAttributeUse DisallowedMathTypeAttributeUse}</td>
<td class='meaning'>Use of the MathML 'type' attribute is not allowed on this element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DisallowedMathTypeAttributeValue DisallowedMathTypeAttributeValue}</td>
<td class='meaning'>Disallowed MathML 'type' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LambdaOnlyAllowedInFunctionDef LambdaOnlyAllowedInFunctionDef}</td>
<td class='meaning'>Use of <code>&lt;lambda&gt;</code> not permitted outside of {@link FunctionDefinition} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BooleanOpsNeedBooleanArgs BooleanOpsNeedBooleanArgs}</td>
<td class='meaning'>Non-Boolean argument given to Boolean operator</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NumericOpsNeedNumericArgs NumericOpsNeedNumericArgs}</td>
<td class='meaning'>Non-numerical argument given to numerical operator</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ArgsToEqNeedSameType ArgsToEqNeedSameType}</td>
<td class='meaning'>Arguments to <code>&lt;eq&gt;</code> and <code>&lt;neq&gt;</code> must have the same data types</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#PiecewiseNeedsConsistentTypes PiecewiseNeedsConsistentTypes}</td>
<td class='meaning'>Terms in a <code>&lt;piecewise&gt;</code> expression must have consistent data types</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#PieceNeedsBoolean PieceNeedsBoolean}</td>
<td class='meaning'>The second argument of a <code>&lt;piece&gt;</code> expression must yield a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ApplyCiMustBeUserFunction ApplyCiMustBeUserFunction}</td>
<td class='meaning'>A <code>&lt;ci&gt;</code> element in this context must refer to a function definition</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ApplyCiMustBeModelComponent ApplyCiMustBeModelComponent}</td>
<td class='meaning'>A <code>&lt;ci&gt;</code> element in this context must refer to a model component</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#KineticLawParametersAreLocalOnly KineticLawParametersAreLocalOnly}</td>
<td class='meaning'>Cannot use a {@link KineticLaw} local parameter outside of its local scope</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MathResultMustBeNumeric MathResultMustBeNumeric}</td>
<td class='meaning'>A formula's result in this context must be a numerical value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OpsNeedCorrectNumberOfArgs OpsNeedCorrectNumberOfArgs}</td>
<td class='meaning'>Incorrect number of arguments given to MathML operator</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidNoArgsPassedToFunctionDef InvalidNoArgsPassedToFunctionDef}</td>
<td class='meaning'>Incorrect number of arguments given to function invocation</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DisallowedMathUnitsUse DisallowedMathUnitsUse}</td>
<td class='meaning'>Attribute 'units' is only permitted on <code>&lt;cn&gt;</code> elements</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidUnitsValue InvalidUnitsValue}</td>
<td class='meaning'>Invalid value given for the 'units' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CiCannotReference0DCompartment CiCannotReference0DCompartment}</td>
<td class='meaning'>A <code>&lt;ci&gt;</code> element cannot reference a 0D compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RateOfTargetMustBeCi RateOfTargetMustBeCi}</td>
<td class='meaning'>A 'rateOf' <code>&lt;csymbol&gt;</code> must target only a single <code>&lt;ci&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RateOfTargetCannotBeAssigned RateOfTargetCannotBeAssigned}</td>
<td class='meaning'>The target of a 'rateOf' <code>&lt;csymbol&gt;</code> cannot be assigned</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RateOfSpeciesTargetCompartmentNot RateOfSpeciesTargetCompartmentNot}</td>
<td class='meaning'>Compartments of non-substance <code>&lt;species&gt;</code> referenced by 'rateOf' must not vary</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateComponentId DuplicateComponentId}</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateUnitDefinitionId DuplicateUnitDefinitionId}</td>
<td class='meaning'>Duplicate unit definition 'id' attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateLocalParameterId DuplicateLocalParameterId}</td>
<td class='meaning'>Duplicate local parameter 'id' attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MultipleAssignmentOrRateRules MultipleAssignmentOrRateRules}</td>
<td class='meaning'>Multiple rules for the same variable are not allowed</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MultipleEventAssignmentsForId MultipleEventAssignmentsForId}</td>
<td class='meaning'>Multiple event assignments for the same variable are not allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EventAndAssignmentRuleForId EventAndAssignmentRuleForId}</td>
<td class='meaning'>An event assignment and an assignment rule must not have the same value for 'variable'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateMetaId DuplicateMetaId}</td>
<td class='meaning'>Duplicate 'metaid' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSBOTermSyntax InvalidSBOTermSyntax}</td>
<td class='meaning'>Invalid syntax for an 'sboTerm' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidMetaidSyntax InvalidMetaidSyntax}</td>
<td class='meaning'>Invalid syntax for a 'metaid' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidIdSyntax InvalidIdSyntax}</td>
<td class='meaning'>Invalid syntax for an 'id' attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidUnitIdSyntax InvalidUnitIdSyntax}</td>
<td class='meaning'>Invalid syntax for the identifier of a unit</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidNameSyntax InvalidNameSyntax}</td>
<td class='meaning'>Invalid syntax for a 'name' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DanglingUnitReference DanglingUnitReference}</td>
<td class='meaning'>Dangling reference to a unit.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingAnnotationNamespace MissingAnnotationNamespace}</td>
<td class='meaning'>Missing declaration of the XML namespace for the annotation</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateAnnotationNamespaces DuplicateAnnotationNamespaces}</td>
<td class='meaning'>Multiple annotations using the same XML namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SBMLNamespaceInAnnotation SBMLNamespaceInAnnotation}</td>
<td class='meaning'>The SBML XML namespace cannot be used in an Annotation object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MultipleAnnotations MultipleAnnotations}</td>
<td class='meaning'>Only one Annotation object is permitted under a given SBML object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InconsistentArgUnits InconsistentArgUnits}</td>
<td class='meaning'>The units of the function call's arguments are not consistent with its definition</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InconsistentKineticLawUnitsL3 InconsistentKineticLawUnitsL3}</td>
<td class='meaning'>The kinetic law's units are inconsistent with those of other kinetic laws in the model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AssignRuleCompartmentMismatch AssignRuleCompartmentMismatch}</td>
<td class='meaning'>Mismatched units in assignment rule for compartment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AssignRuleSpeciesMismatch AssignRuleSpeciesMismatch}</td>
<td class='meaning'>Mismatched units in assignment rule for species</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AssignRuleParameterMismatch AssignRuleParameterMismatch}</td>
<td class='meaning'>Mismatched units in assignment rule for parameter</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AssignRuleStoichiometryMismatch AssignRuleStoichiometryMismatch}</td>
<td class='meaning'>Mismatched units in assignment rule for stoichiometry</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InitAssignCompartmenMismatch InitAssignCompartmenMismatch}</td>
<td class='meaning'>Mismatched units in initial assignment to compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InitAssignSpeciesMismatch InitAssignSpeciesMismatch}</td>
<td class='meaning'>Mismatched units in initial assignment to species</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InitAssignParameterMismatch InitAssignParameterMismatch}</td>
<td class='meaning'>Mismatched units in initial assignment to parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InitAssignStoichiometryMismatch InitAssignStoichiometryMismatch}</td>
<td class='meaning'>Mismatched units in initial assignment to stoichiometry</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RateRuleCompartmentMismatch RateRuleCompartmentMismatch}</td>
<td class='meaning'>Mismatched units in rate rule for compartment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RateRuleSpeciesMismatch RateRuleSpeciesMismatch}</td>
<td class='meaning'>Mismatched units in rate rule for species</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RateRuleParameterMismatch RateRuleParameterMismatch}</td>
<td class='meaning'>Mismatched units in rate rule for parameter</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RateRuleStoichiometryMismatch RateRuleStoichiometryMismatch}</td>
<td class='meaning'>Mismatched units in rate rule for stoichiometry</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#KineticLawNotSubstancePerTime KineticLawNotSubstancePerTime}</td>
<td class='meaning'>The units of the kinetic law are not 'substance'/'time'</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpeciesInvalidExtentUnits SpeciesInvalidExtentUnits}</td>
<td class='meaning'>The species' units are not consistent with units of extent</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DelayUnitsNotTime DelayUnitsNotTime}</td>
<td class='meaning'>The units of the delay expression are not units of time</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EventAssignCompartmentMismatch EventAssignCompartmentMismatch}</td>
<td class='meaning'>Mismatched units in event assignment for compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EventAssignSpeciesMismatch EventAssignSpeciesMismatch}</td>
<td class='meaning'>Mismatched units in event assignment for species</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EventAssignParameterMismatch EventAssignParameterMismatch}</td>
<td class='meaning'>Mismatched units in event assignment for parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EventAssignStoichiometryMismatch EventAssignStoichiometryMismatch}</td>
<td class='meaning'>Mismatched units in event assignment for stoichiometry</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#PriorityUnitsNotDimensionless PriorityUnitsNotDimensionless}</td>
<td class='meaning'>The units of a priority expression must be 'dimensionless'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OverdeterminedSystem OverdeterminedSystem}</td>
<td class='meaning'>The model is overdetermined</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidModelSBOTerm InvalidModelSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link Model} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidFunctionDefSBOTerm InvalidFunctionDefSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link FunctionDefinition} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidParameterSBOTerm InvalidParameterSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link Parameter} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidInitAssignSBOTerm InvalidInitAssignSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an {@link InitialAssignment} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidRuleSBOTerm InvalidRuleSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link Rule} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidConstraintSBOTerm InvalidConstraintSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link Constraint} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidReactionSBOTerm InvalidReactionSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link Reaction} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSpeciesReferenceSBOTerm InvalidSpeciesReferenceSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link SpeciesReference} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidKineticLawSBOTerm InvalidKineticLawSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link KineticLaw} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidEventSBOTerm InvalidEventSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an {@link Event} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidEventAssignmentSBOTerm InvalidEventAssignmentSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an {@link EventAssignment} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidCompartmentSBOTerm InvalidCompartmentSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link Compartment} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSpeciesSBOTerm InvalidSpeciesSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link Species} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidCompartmentTypeSBOTerm InvalidCompartmentTypeSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link CompartmentType} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSpeciesTypeSBOTerm InvalidSpeciesTypeSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link SpeciesType} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidTriggerSBOTerm InvalidTriggerSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an {@link Event} Trigger object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidDelaySBOTerm InvalidDelaySBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an {@link Event} Delay object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidLocalParameterSBOTerm InvalidLocalParameterSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a {@link LocalParameter} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSBMLElementSBOTerm InvalidSBMLElementSBOTerm}</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for the <code>&lt;sbml&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NotesNotInXHTMLNamespace NotesNotInXHTMLNamespace}</td>
<td class='meaning'>Notes must be placed in the XHTML XML namespace</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NotesContainsXMLDecl NotesContainsXMLDecl}</td>
<td class='meaning'>XML declarations are not permitted in Notes objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NotesContainsDOCTYPE NotesContainsDOCTYPE}</td>
<td class='meaning'>XML DOCTYPE elements are not permitted in Notes objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidNotesContent InvalidNotesContent}</td>
<td class='meaning'>Invalid notes content found</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyOneNotesElementAllowed OnlyOneNotesElementAllowed}</td>
<td class='meaning'>Only one Notes subobject is permitted on a given SBML object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidNamespaceOnSBML InvalidNamespaceOnSBML}</td>
<td class='meaning'>Invalid XML namespace for the SBML container element</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingOrInconsistentLevel MissingOrInconsistentLevel}</td>
<td class='meaning'>Missing or inconsistent value for the 'level' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingOrInconsistentVersion MissingOrInconsistentVersion}</td>
<td class='meaning'>Missing or inconsistent value for the 'version' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#PackageNSMustMatch PackageNSMustMatch}</td>
<td class='meaning'>Inconsistent or invalid SBML Level/Version for the package namespace declaration</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LevelPositiveInteger LevelPositiveInteger}</td>
<td class='meaning'>The 'level' attribute must have a positive integer value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#VersionPositiveInteger VersionPositiveInteger}</td>
<td class='meaning'>The 'version' attribute must have a positive integer value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnSBML AllowedAttributesOnSBML}</td>
<td class='meaning'>Invalid attribute found on the SBML container element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3PackageOnLowerSBML L3PackageOnLowerSBML}</td>
<td class='meaning'>An L3 package ns found on the SBML container element</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingModel MissingModel}</td>
<td class='meaning'>No model definition found</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#IncorrectOrderInModel IncorrectOrderInModel}</td>
<td class='meaning'>Incorrect ordering of components within the {@link Model} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EmptyListElement EmptyListElement}</td>
<td class='meaning'>Empty ListOf___ object found</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NeedCompartmentIfHaveSpecies NeedCompartmentIfHaveSpecies}</td>
<td class='meaning'>The presence of a species requires a compartment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneOfEachListOf OneOfEachListOf}</td>
<td class='meaning'>Only one of each kind of ListOf___ object is allowed inside a {@link Model} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyFuncDefsInListOfFuncDefs OnlyFuncDefsInListOfFuncDefs}</td>
<td class='meaning'>Only {@link FunctionDefinition}, Notes and Annotation objects are allowed in {@link ListOfFunctionDefinitions}</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyUnitDefsInListOfUnitDefs OnlyUnitDefsInListOfUnitDefs}</td>
<td class='meaning'>Only {@link UnitDefinition}, Notes and Annotation objects are allowed in {@link ListOfUnitDefinitions} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyCompartmentsInListOfCompartments OnlyCompartmentsInListOfCompartments}</td>
<td class='meaning'>Only {@link Compartment}, Notes and Annotation objects are allowed in {@link ListOfCompartments} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlySpeciesInListOfSpecies OnlySpeciesInListOfSpecies}</td>
<td class='meaning'>Only {@link Species}, Notes and Annotation objects are allowed in {@link ListOfSpecies} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyParametersInListOfParameters OnlyParametersInListOfParameters}</td>
<td class='meaning'>Only {@link Parameter}, Notes and Annotation objects are allowed in {@link ListOfParameters} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyInitAssignsInListOfInitAssigns OnlyInitAssignsInListOfInitAssigns}</td>
<td class='meaning'>Only {@link InitialAssignment}, Notes and Annotation objects are allowed in {@link ListOfInitialAssignments} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyRulesInListOfRules OnlyRulesInListOfRules}</td>
<td class='meaning'>Only {@link Rule}, Notes and Annotation objects are allowed in {@link ListOfRules} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyConstraintsInListOfConstraints OnlyConstraintsInListOfConstraints}</td>
<td class='meaning'>Only {@link Constraint}, Notes and Annotation objects are allowed in {@link ListOfConstraints} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyReactionsInListOfReactions OnlyReactionsInListOfReactions}</td>
<td class='meaning'>Only {@link Reaction}, Notes and Annotation objects are allowed in {@link ListOfReactions} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyEventsInListOfEvents OnlyEventsInListOfEvents}</td>
<td class='meaning'>Only {@link Event}, Notes and Annotation objects are allowed in {@link ListOfEvents} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3ConversionFactorOnModel L3ConversionFactorOnModel}</td>
<td class='meaning'>A 'conversionFactor' attribute value must reference a {@link Parameter} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3TimeUnitsOnModel L3TimeUnitsOnModel}</td>
<td class='meaning'>Invalid 'timeUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3VolumeUnitsOnModel L3VolumeUnitsOnModel}</td>
<td class='meaning'>Invalid 'volumeUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3AreaUnitsOnModel L3AreaUnitsOnModel}</td>
<td class='meaning'>Invalid 'areaUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3LengthUnitsOnModel L3LengthUnitsOnModel}</td>
<td class='meaning'>Invalid 'lengthUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3ExtentUnitsOnModel L3ExtentUnitsOnModel}</td>
<td class='meaning'>Invalid 'extentUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnModel AllowedAttributesOnModel}</td>
<td class='meaning'>Invalid attribute found on the {@link Model} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfFuncs AllowedAttributesOnListOfFuncs}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfFunctionDefinitions} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfUnitDefs AllowedAttributesOnListOfUnitDefs}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfUnitDefinitions} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfComps AllowedAttributesOnListOfComps}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfCompartments} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfSpecies AllowedAttributesOnListOfSpecies}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfSpecies} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfParams AllowedAttributesOnListOfParams}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfParameters} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfInitAssign AllowedAttributesOnListOfInitAssign}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfInitialAssignments} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfRules AllowedAttributesOnListOfRules}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfRules} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfConstraints AllowedAttributesOnListOfConstraints}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfConstraints} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfReactions AllowedAttributesOnListOfReactions}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfReactions} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfEvents AllowedAttributesOnListOfEvents}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfEvents} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3V2SubstanceUnitsOnModel L3V2SubstanceUnitsOnModel}</td>
<td class='meaning'>Invalid 'substanceUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FunctionDefMathNotLambda FunctionDefMathNotLambda}</td>
<td class='meaning'>Invalid expression found in the function definition</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidApplyCiInLambda InvalidApplyCiInLambda}</td>
<td class='meaning'>Invalid forward reference in the MathML <code>&lt;apply&gt;</code><code>&lt;ci&gt;</code>...<code>&lt;/ci&gt;</code><code>&lt;/apply&gt;</code> expression</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RecursiveFunctionDefinition RecursiveFunctionDefinition}</td>
<td class='meaning'>Recursive function definitions are not permitted</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidCiInLambda InvalidCiInLambda}</td>
<td class='meaning'>Invalid <code>&lt;ci&gt;</code> reference found inside the <code>&lt;lambda&gt;</code> mathematical formula</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidFunctionDefReturnType InvalidFunctionDefReturnType}</td>
<td class='meaning'>A function's return type must be either a number or a Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMathElementPerFunc OneMathElementPerFunc}</td>
<td class='meaning'>A {@link FunctionDefinition} object may contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnFunc AllowedAttributesOnFunc}</td>
<td class='meaning'>Invalid attribute found on the {@link FunctionDefinition} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidUnitDefId InvalidUnitDefId}</td>
<td class='meaning'>Invalid 'id' attribute value for a {@link UnitDefinition} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSubstanceRedefinition InvalidSubstanceRedefinition}</td>
<td class='meaning'>Invalid redefinition of built-in type 'substance'</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidLengthRedefinition InvalidLengthRedefinition}</td>
<td class='meaning'>Invalid redefinition of built-in type 'length'</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidAreaRedefinition InvalidAreaRedefinition}</td>
<td class='meaning'>Invalid redefinition of built-in type name 'area'</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidTimeRedefinition InvalidTimeRedefinition}</td>
<td class='meaning'>Invalid redefinition of built-in type name 'time'</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidVolumeRedefinition InvalidVolumeRedefinition}</td>
<td class='meaning'>Invalid redefinition of built-in type name 'volume'</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#VolumeLitreDefExponentNotOne VolumeLitreDefExponentNotOne}</td>
<td class='meaning'>Must use 'exponent'=1 when defining 'volume' in terms of litres</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#VolumeMetreDefExponentNot3 VolumeMetreDefExponentNot3}</td>
<td class='meaning'>Must use 'exponent'=3 when defining 'volume' in terms of metres</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EmptyListOfUnits EmptyListOfUnits}</td>
<td class='meaning'>An empty list of {@link Unit} objects is not permitted in a {@link UnitDefinition} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidUnitKind InvalidUnitKind}</td>
<td class='meaning'>Invalid value for the 'kind' attribute of a {@link UnitDefinition} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OffsetNoLongerValid OffsetNoLongerValid}</td>
<td class='meaning'>Unit attribute 'offset' is not supported in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CelsiusNoLongerValid CelsiusNoLongerValid}</td>
<td class='meaning'>Unit name 'Celsius' is not defined in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EmptyUnitListElement EmptyUnitListElement}</td>
<td class='meaning'>A {@link ListOfUnits} object must not be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneListOfUnitsPerUnitDef OneListOfUnitsPerUnitDef}</td>
<td class='meaning'>At most one {@link ListOfUnits} object is allowed inside a {@link UnitDefinition} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyUnitsInListOfUnits OnlyUnitsInListOfUnits}</td>
<td class='meaning'>Only {@link Unit}, Notes and Annotation objects are allowed in {@link ListOfUnits} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnUnitDefinition AllowedAttributesOnUnitDefinition}</td>
<td class='meaning'>Invalid attribute found on the {@link UnitDefinition} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfUnits AllowedAttributesOnListOfUnits}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfUnits} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnUnit AllowedAttributesOnUnit}</td>
<td class='meaning'>Invalid attribute found on the {@link Unit} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ZeroDimensionalCompartmentSize ZeroDimensionalCompartmentSize}</td>
<td class='meaning'>Invalid use of the 'size' attribute for a zero-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ZeroDimensionalCompartmentUnits ZeroDimensionalCompartmentUnits}</td>
<td class='meaning'>Invalid use of the 'units' attribute for a zero-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ZeroDimensionalCompartmentConst ZeroDimensionalCompartmentConst}</td>
<td class='meaning'>Zero-dimensional compartments must be defined to be constant</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UndefinedOutsideCompartment UndefinedOutsideCompartment}</td>
<td class='meaning'>Invalid value for the 'outside' attribute of a {@link Compartment} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RecursiveCompartmentContainment RecursiveCompartmentContainment}</td>
<td class='meaning'>Recursive nesting of compartments via the 'outside' attribute is not permitted</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ZeroDCompartmentContainment ZeroDCompartmentContainment}</td>
<td class='meaning'>Invalid nesting of zero-dimensional compartments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#Invalid1DCompartmentUnits Invalid1DCompartmentUnits}</td>
<td class='meaning'>Invalid value for the 'units' attribute of a one-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#Invalid2DCompartmentUnits Invalid2DCompartmentUnits}</td>
<td class='meaning'>Invalid value for the 'units' attribute of a two-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#Invalid3DCompartmentUnits Invalid3DCompartmentUnits}</td>
<td class='meaning'>Invalid value for the 'units' attribute of a three-dimensional compartment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidCompartmentTypeRef InvalidCompartmentTypeRef}</td>
<td class='meaning'>Invalid value for the 'compartmentType' attribute of a compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneDimensionalCompartmentUnits OneDimensionalCompartmentUnits}</td>
<td class='meaning'>No units defined for 1-D compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#TwoDimensionalCompartmentUnits TwoDimensionalCompartmentUnits}</td>
<td class='meaning'>No units defined for 2-D compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ThreeDimensionalCompartmentUnits ThreeDimensionalCompartmentUnits}</td>
<td class='meaning'>No units defined for 3-D {@link Compartment} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnCompartment AllowedAttributesOnCompartment}</td>
<td class='meaning'>Invalid attribute found on {@link Compartment} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoUnitsOnCompartment NoUnitsOnCompartment}</td>
<td class='meaning'>No units defined for {@link Compartment} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSpeciesCompartmentRef InvalidSpeciesCompartmentRef}</td>
<td class='meaning'>Invalid value found for {@link Species} 'compartment' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#HasOnlySubsNoSpatialUnits HasOnlySubsNoSpatialUnits}</td>
<td class='meaning'>Attribute 'spatialSizeUnits' must not be set if 'hasOnlySubstanceUnits'='true'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSpatialUnitsInZeroD NoSpatialUnitsInZeroD}</td>
<td class='meaning'>Attribute 'spatialSizeUnits' must not be set if the compartment is zero-dimensional</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoConcentrationInZeroD NoConcentrationInZeroD}</td>
<td class='meaning'>Attribute 'initialConcentration' must not be set if the compartment is zero-dimensional</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpatialUnitsInOneD SpatialUnitsInOneD}</td>
<td class='meaning'>Invalid value for 'spatialSizeUnits' attribute of a one-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpatialUnitsInTwoD SpatialUnitsInTwoD}</td>
<td class='meaning'>Invalid value for the 'spatialSizeUnits' attribute of a two-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpatialUnitsInThreeD SpatialUnitsInThreeD}</td>
<td class='meaning'>Invalid value for the 'spatialSizeUnits' attribute of a three-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSpeciesSusbstanceUnits InvalidSpeciesSusbstanceUnits}</td>
<td class='meaning'>Invalid value for a {@link Species} 'units' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BothAmountAndConcentrationSet BothAmountAndConcentrationSet}</td>
<td class='meaning'>Cannot set both 'initialConcentration' and 'initialAmount' attributes simultaneously</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NonBoundarySpeciesAssignedAndUsed NonBoundarySpeciesAssignedAndUsed}</td>
<td class='meaning'>Cannot use a non-boundary species in both reactions and rules simultaneously</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NonConstantSpeciesUsed NonConstantSpeciesUsed}</td>
<td class='meaning'>Cannot use a constant, non-boundary species as a reactant or product</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSpeciesTypeRef InvalidSpeciesTypeRef}</td>
<td class='meaning'>Invalid value for the 'speciesType' attribute of a species</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MultSpeciesSameTypeInCompartment MultSpeciesSameTypeInCompartment}</td>
<td class='meaning'>Cannot have multiple species of the same species type in the same compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingSpeciesCompartment MissingSpeciesCompartment}</td>
<td class='meaning'>Missing value for the 'compartment' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpatialSizeUnitsRemoved SpatialSizeUnitsRemoved}</td>
<td class='meaning'>Attribute 'spatialSizeUnits' is not supported in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SubstanceUnitsOnSpecies SubstanceUnitsOnSpecies}</td>
<td class='meaning'>No substance units defined for the species</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConversionFactorOnSpecies ConversionFactorOnSpecies}</td>
<td class='meaning'>Invalid value for the 'conversionFactor' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnSpecies AllowedAttributesOnSpecies}</td>
<td class='meaning'>Invalid attribute found on {@link Species} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidParameterUnits InvalidParameterUnits}</td>
<td class='meaning'>Invalid value for the 'units' attribute of a {@link Parameter} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ParameterUnits ParameterUnits}</td>
<td class='meaning'>No units defined for the parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConversionFactorMustConstant ConversionFactorMustConstant}</td>
<td class='meaning'>A conversion factor must reference a {@link Parameter} object declared to be a constant</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnParameter AllowedAttributesOnParameter}</td>
<td class='meaning'>Invalid attribute found on {@link Parameter} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidInitAssignSymbol InvalidInitAssignSymbol}</td>
<td class='meaning'>Invalid value for the 'symbol' attribute of an {@link InitialAssignment} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MultipleInitAssignments MultipleInitAssignments}</td>
<td class='meaning'>Multiple initial assignments for the same 'symbol' value are not allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InitAssignmentAndRuleForSameId InitAssignmentAndRuleForSameId}</td>
<td class='meaning'>Cannot set a value using both an initial assignment and an assignment rule simultaneously</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMathElementPerInitialAssign OneMathElementPerInitialAssign}</td>
<td class='meaning'>An {@link InitialAssignment} object may contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnInitialAssign AllowedAttributesOnInitialAssign}</td>
<td class='meaning'>Invalid attribute found on an {@link InitialAssignment} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InitAssignmentCannotRef0DComp InitAssignmentCannotRef0DComp}</td>
<td class='meaning'>InitialAssignment cannot reference 0D compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidAssignRuleVariable InvalidAssignRuleVariable}</td>
<td class='meaning'>Invalid value for the 'variable' attribute of an {@link AssignmentRule} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidRateRuleVariable InvalidRateRuleVariable}</td>
<td class='meaning'>Invalid value for the 'variable' attribute of a {@link RateRule} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AssignmentToConstantEntity AssignmentToConstantEntity}</td>
<td class='meaning'>An assignment rule cannot assign an entity declared to be constant</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RateRuleForConstantEntity RateRuleForConstantEntity}</td>
<td class='meaning'>A rate rule cannot assign an entity declared to be constant</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CircularRuleDependency CircularRuleDependency}</td>
<td class='meaning'>Circular dependencies involving rules and reactions are not permitted</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMathElementPerRule OneMathElementPerRule}</td>
<td class='meaning'>A rule object may contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnAssignRule AllowedAttributesOnAssignRule}</td>
<td class='meaning'>Invalid attribute found on an {@link AssignmentRule} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnRateRule AllowedAttributesOnRateRule}</td>
<td class='meaning'>Invalid attribute found on a {@link RateRule} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnAlgRule AllowedAttributesOnAlgRule}</td>
<td class='meaning'>Invalid attribute found on an {@link AlgebraicRule} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RuleCannotRef0DComp RuleCannotRef0DComp}</td>
<td class='meaning'>Rule cannot reference 0D compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CircularDependencyRateOf CircularDependencyRateOf}</td>
<td class='meaning'>Circular dependencies are not permitted in {@link RateRule} and {@link KineticLaw} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConstraintMathNotBoolean ConstraintMathNotBoolean}</td>
<td class='meaning'>A {@link Constraint} object's <code>&lt;math&gt;</code> must evaluate to a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#IncorrectOrderInConstraint IncorrectOrderInConstraint}</td>
<td class='meaning'>Subobjects inside the {@link Constraint} object are not in the prescribed order</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConstraintNotInXHTMLNamespace ConstraintNotInXHTMLNamespace}</td>
<td class='meaning'>A {@link Constraint}'s Message subobject must be in the XHTML XML namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConstraintContainsXMLDecl ConstraintContainsXMLDecl}</td>
<td class='meaning'>XML declarations are not permitted within {@link Constraint}'s Message objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConstraintContainsDOCTYPE ConstraintContainsDOCTYPE}</td>
<td class='meaning'>XML DOCTYPE elements are not permitted within {@link Constraint}'s Message objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidConstraintContent InvalidConstraintContent}</td>
<td class='meaning'>Invalid content for a {@link Constraint} object's Message object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMathElementPerConstraint OneMathElementPerConstraint}</td>
<td class='meaning'>A {@link Constraint} object may contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMessageElementPerConstraint OneMessageElementPerConstraint}</td>
<td class='meaning'>A {@link Constraint} object can only have one Message subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnConstraint AllowedAttributesOnConstraint}</td>
<td class='meaning'>Invalid attribute found on {@link Constraint} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoReactantsOrProducts NoReactantsOrProducts}</td>
<td class='meaning'>Cannot have a reaction with neither reactants nor products</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#IncorrectOrderInReaction IncorrectOrderInReaction}</td>
<td class='meaning'>Subobjects inside the {@link Reaction} object are not in the prescribed order</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EmptyListInReaction EmptyListInReaction}</td>
<td class='meaning'>Reaction components, if present, cannot be empty</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidReactantsProductsList InvalidReactantsProductsList}</td>
<td class='meaning'>Invalid object found in the list of reactants or products</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidModifiersList InvalidModifiersList}</td>
<td class='meaning'>Invalid object found in the list of modifiers</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneSubElementPerReaction OneSubElementPerReaction}</td>
<td class='meaning'>A {@link Reaction} object can only contain one of each allowed type of object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompartmentOnReaction CompartmentOnReaction}</td>
<td class='meaning'>Invalid value for the {@link Reaction} 'compartment' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnReaction AllowedAttributesOnReaction}</td>
<td class='meaning'>Invalid attribute for a {@link Reaction} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSpeciesReference InvalidSpeciesReference}</td>
<td class='meaning'>Invalid 'species' attribute value in {@link SpeciesReference} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BothStoichiometryAndMath BothStoichiometryAndMath}</td>
<td class='meaning'>The 'stoichiometry' attribute and {@link StoichiometryMath} subobject are mutually exclusive</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnSpeciesReference AllowedAttributesOnSpeciesReference}</td>
<td class='meaning'>Invalid attribute found on the {@link SpeciesReference} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnModifier AllowedAttributesOnModifier}</td>
<td class='meaning'>Invalid attribute found on the {@link ModifierSpeciesReference} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UndeclaredSpeciesRef UndeclaredSpeciesRef}</td>
<td class='meaning'>Unknown species referenced in the kinetic law <code>&lt;math&gt;</code> formula</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#IncorrectOrderInKineticLaw IncorrectOrderInKineticLaw}</td>
<td class='meaning'>Incorrect ordering of components in the {@link KineticLaw} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EmptyListInKineticLaw EmptyListInKineticLaw}</td>
<td class='meaning'>The list of parameters, if present, cannot be empty</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NonConstantLocalParameter NonConstantLocalParameter}</td>
<td class='meaning'>Parameters local to a {@link KineticLaw} object must have a 'constant' attribute value of 'true'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SubsUnitsNoLongerValid SubsUnitsNoLongerValid}</td>
<td class='meaning'>Attribute 'substanceUnits' is not supported in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#TimeUnitsNoLongerValid TimeUnitsNoLongerValid}</td>
<td class='meaning'>Attribute 'timeUnits' is not supported in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneListOfPerKineticLaw OneListOfPerKineticLaw}</td>
<td class='meaning'>Only one {@link ListOfLocalParameters} object is permitted within a {@link KineticLaw} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyLocalParamsInListOfLocalParams OnlyLocalParamsInListOfLocalParams}</td>
<td class='meaning'>Only {@link LocalParameter}, Notes and Annotation objects are allowed in ListOfLocalParameter objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfLocalParam AllowedAttributesOnListOfLocalParam}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfLocalParameters} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMathPerKineticLaw OneMathPerKineticLaw}</td>
<td class='meaning'>Only one <code>&lt;math&gt;</code> element is allowed in a {@link KineticLaw} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UndeclaredSpeciesInStoichMath UndeclaredSpeciesInStoichMath}</td>
<td class='meaning'>Unknown species referenced in the {@link StoichiometryMath} object's <code>&lt;math&gt;</code> formula</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnKineticLaw AllowedAttributesOnKineticLaw}</td>
<td class='meaning'>Invalid attribute found on the {@link KineticLaw} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfSpeciesRef AllowedAttributesOnListOfSpeciesRef}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfSpeciesReferences} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfMods AllowedAttributesOnListOfMods}</td>
<td class='meaning'>Invalid attribute found on the ListOfModifiers object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3V2FastDeprecated L3V2FastDeprecated}</td>
<td class='meaning'>Fast attribute deprecated</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnLocalParameter AllowedAttributesOnLocalParameter}</td>
<td class='meaning'>Invalid attribute found on the {@link LocalParameter} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LocalParameterShadowsSpecies LocalParameterShadowsSpecies}</td>
<td class='meaning'>Invalid attribute found on the {@link LocalParameter} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingTriggerInEvent MissingTriggerInEvent}</td>
<td class='meaning'>The {@link Event} object is missing a {@link Trigger} subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#TriggerMathNotBoolean TriggerMathNotBoolean}</td>
<td class='meaning'>A {@link Trigger} object's <code>&lt;math&gt;</code> expression must evaluate to a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingEventAssignment MissingEventAssignment}</td>
<td class='meaning'>The {@link Event} object is missing an {@link EventAssignment} subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#TimeUnitsEvent TimeUnitsEvent}</td>
<td class='meaning'>Units referenced by 'timeUnits' attribute are not compatible with units of time</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#IncorrectOrderInEvent IncorrectOrderInEvent}</td>
<td class='meaning'>Incorrect ordering of components in {@link Event} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ValuesFromTriggerTimeNeedDelay ValuesFromTriggerTimeNeedDelay}</td>
<td class='meaning'>Attribute 'useValuesFromTriggerTime'='false', but the {@link Event} object does not define a delay</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DelayNeedsValuesFromTriggerTime DelayNeedsValuesFromTriggerTime}</td>
<td class='meaning'>The use of a {@link Delay} object requires the {@link Event} attribute 'useValuesFromTriggerTime'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMathPerTrigger OneMathPerTrigger}</td>
<td class='meaning'>A {@link Trigger} object may have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMathPerDelay OneMathPerDelay}</td>
<td class='meaning'>A {@link Delay} object may have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidEventAssignmentVariable InvalidEventAssignmentVariable}</td>
<td class='meaning'>Invalid 'variable' attribute value in {@link Event} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EventAssignmentForConstantEntity EventAssignmentForConstantEntity}</td>
<td class='meaning'>An {@link EventAssignment} object cannot assign to a component having attribute 'constant'='true'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMathPerEventAssignment OneMathPerEventAssignment}</td>
<td class='meaning'>An {@link EventAssignment} object may have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnEventAssignment AllowedAttributesOnEventAssignment}</td>
<td class='meaning'>Invalid attribute found on the {@link EventAssignment} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyOneDelayPerEvent OnlyOneDelayPerEvent}</td>
<td class='meaning'>An {@link Event} object can only have one {@link Delay} subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneListOfEventAssignmentsPerEvent OneListOfEventAssignmentsPerEvent}</td>
<td class='meaning'>An {@link Event} object can only have one {@link ListOfEventAssignments} subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyEventAssignInListOfEventAssign OnlyEventAssignInListOfEventAssign}</td>
<td class='meaning'>Only {@link EventAssignment}, Notes and Annotation objects are allowed in {@link ListOfEventAssignments}</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnListOfEventAssign AllowedAttributesOnListOfEventAssign}</td>
<td class='meaning'>Invalid attribute found on the {@link ListOfEventAssignments} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnEvent AllowedAttributesOnEvent}</td>
<td class='meaning'>Invalid attribute found on the {@link Event} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnTrigger AllowedAttributesOnTrigger}</td>
<td class='meaning'>Invalid attribute found on the {@link Trigger} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnDelay AllowedAttributesOnDelay}</td>
<td class='meaning'>Invalid attribute found on the {@link Delay} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#PersistentNotBoolean PersistentNotBoolean}</td>
<td class='meaning'>The {@link Trigger} attribute 'persistent' must evaluate to a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InitialValueNotBoolean InitialValueNotBoolean}</td>
<td class='meaning'>The {@link Trigger} attribute 'initialValue' must evaluate to a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OnlyOnePriorityPerEvent OnlyOnePriorityPerEvent}</td>
<td class='meaning'>An {@link Event} object can only have one {@link Priority} subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OneMathPerPriority OneMathPerPriority}</td>
<td class='meaning'>A {@link Priority} object may have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AllowedAttributesOnPriority AllowedAttributesOnPriority}</td>
<td class='meaning'>Invalid attribute found on the {@link Priority} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompartmentShouldHaveSize CompartmentShouldHaveSize}</td>
<td class='meaning'>It's best to define a size for every compartment in a model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpeciesShouldHaveValue SpeciesShouldHaveValue}</td>
<td class='meaning'>It's best to define an initial amount or initial concentration for every species in a model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ParameterShouldHaveUnits ParameterShouldHaveUnits}</td>
<td class='meaning'>It's best to declare units for every parameter in a model</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ParameterShouldHaveValue ParameterShouldHaveValue}</td>
<td class='meaning'>It's best to declare values for every parameter in a model</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LocalParameterShadowsId LocalParameterShadowsId}</td>
<td class='meaning'>Local parameters defined within a kinetic law shadow global object symbols</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CannotConvertToL1V1 CannotConvertToL1V1}</td>
<td class='meaning'>Cannot convert to SBML Level 1 Version 1</td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoEventsInL1 NoEventsInL1}</td>
<td class='meaning'>SBML Level 1 does not support events</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoFunctionDefinitionsInL1 NoFunctionDefinitionsInL1}</td>
<td class='meaning'>SBML Level 1 does not support function definitions</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoConstraintsInL1 NoConstraintsInL1}</td>
<td class='meaning'>SBML Level 1 does not support constraints</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoInitialAssignmentsInL1 NoInitialAssignmentsInL1}</td>
<td class='meaning'>SBML Level 1 does not support initial assignments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSpeciesTypesInL1 NoSpeciesTypesInL1}</td>
<td class='meaning'>SBML Level 1 does not support species types</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoCompartmentTypeInL1 NoCompartmentTypeInL1}</td>
<td class='meaning'>SBML Level 1 does not support compartment types</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoNon3DCompartmentsInL1 NoNon3DCompartmentsInL1}</td>
<td class='meaning'>SBML Level 1 only supports three-dimensional compartments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoFancyStoichiometryMathInL1 NoFancyStoichiometryMathInL1}</td>
<td class='meaning'>SBML Level 1 does not support non-integer nor non-rational stoichiometry formulas</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoNonIntegerStoichiometryInL1 NoNonIntegerStoichiometryInL1}</td>
<td class='meaning'>SBML Level 1 does not support non-integer 'stoichiometry' attribute values</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoUnitMultipliersOrOffsetsInL1 NoUnitMultipliersOrOffsetsInL1}</td>
<td class='meaning'>SBML Level 1 does not support multipliers or offsets in unit definitions</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpeciesCompartmentRequiredInL1 SpeciesCompartmentRequiredInL1}</td>
<td class='meaning'>In SBML Level 1, a value for 'compartment' is mandatory in species definitions</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSpeciesSpatialSizeUnitsInL1 NoSpeciesSpatialSizeUnitsInL1}</td>
<td class='meaning'>SBML Level 1 does not support species 'spatialSizeUnits' settings</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSBOTermsInL1 NoSBOTermsInL1}</td>
<td class='meaning'>SBML Level 1 does not support the 'sboTerm' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#StrictUnitsRequiredInL1 StrictUnitsRequiredInL1}</td>
<td class='meaning'>SBML Level 1 requires strict unit consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConversionFactorNotInL1 ConversionFactorNotInL1}</td>
<td class='meaning'>SBML Level 1 does not support the 'conversionFactor' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompartmentNotOnL1Reaction CompartmentNotOnL1Reaction}</td>
<td class='meaning'>SBML Level 1 does not support the 'compartment' attribute on {@link Reaction} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ExtentUnitsNotSubstance ExtentUnitsNotSubstance}</td>
<td class='meaning'>Units of extent must be compatible with units of substance</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GlobalUnitsNotDeclared GlobalUnitsNotDeclared}</td>
<td class='meaning'>Global units must be refer to unit kind or unitDefinition</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#HasOnlySubstanceUnitsNotinL1 HasOnlySubstanceUnitsNotinL1}</td>
<td class='meaning'>The concept of hasOnlySubstanceUnits was not available in SBML Level 1</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AvogadroNotSupported AvogadroNotSupported}</td>
<td class='meaning'>Avogadro not supported in Levels 2 and 1</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoConstraintsInL2v1 NoConstraintsInL2v1}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support {@link Constraint} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoInitialAssignmentsInL2v1 NoInitialAssignmentsInL2v1}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support {@link InitialAssignment} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSpeciesTypeInL2v1 NoSpeciesTypeInL2v1}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support {@link SpeciesType} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoCompartmentTypeInL2v1 NoCompartmentTypeInL2v1}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support {@link CompartmentType} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSBOTermsInL2v1 NoSBOTermsInL2v1}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'sboTerm' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoIdOnSpeciesReferenceInL2v1 NoIdOnSpeciesReferenceInL2v1}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'id' attribute on {@link SpeciesReference} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoDelayedEventAssignmentInL2v1 NoDelayedEventAssignmentInL2v1}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'useValuesFromTriggerTime' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#StrictUnitsRequiredInL2v1 StrictUnitsRequiredInL2v1}</td>
<td class='meaning'>SBML Level 2 Version 1 requires strict unit consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#IntegerSpatialDimensions IntegerSpatialDimensions}</td>
<td class='meaning'>SBML Level 2 Version 1 requires that compartments have spatial dimensions of 0-3</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#StoichiometryMathNotYetSupported StoichiometryMathNotYetSupported}</td>
<td class='meaning'>Conversion to {@link StoichiometryMath} objects not yet supported</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#PriorityLostFromL3 PriorityLostFromL3}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support priorities on {@link Event} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NonPersistentNotSupported NonPersistentNotSupported}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'persistent' attribute on {@link Trigger} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InitialValueFalseEventNotSupported InitialValueFalseEventNotSupported}</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'initialValue' attribute on {@link Trigger} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SBOTermNotUniversalInL2v2 SBOTermNotUniversalInL2v2}</td>
<td class='meaning'>The 'sboTerm' attribute is invalid for this component in SBML Level 2 Version 2</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoUnitOffsetInL2v2 NoUnitOffsetInL2v2}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoKineticLawTimeUnitsInL2v2 NoKineticLawTimeUnitsInL2v2}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoKineticLawSubstanceUnitsInL2v2 NoKineticLawSubstanceUnitsInL2v2}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoDelayedEventAssignmentInL2v2 NoDelayedEventAssignmentInL2v2}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'useValuesFromTriggerTime' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ModelSBOBranchChangedBeyondL2v2 ModelSBOBranchChangedBeyondL2v2}</td>
<td class='meaning'>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#StrictUnitsRequiredInL2v2 StrictUnitsRequiredInL2v2}</td>
<td class='meaning'>SBML Level 2 Version 2 requires strict unit consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#StrictSBORequiredInL2v2 StrictSBORequiredInL2v2}</td>
<td class='meaning'>SBML Level 2 Version 2 requires strict {@link SBO} term consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateAnnotationInvalidInL2v2 DuplicateAnnotationInvalidInL2v2}</td>
<td class='meaning'>Duplicate top-level annotations are invalid in SBML Level 2 Version 2</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoUnitOffsetInL2v3 NoUnitOffsetInL2v3}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoKineticLawTimeUnitsInL2v3 NoKineticLawTimeUnitsInL2v3}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoKineticLawSubstanceUnitsInL2v3 NoKineticLawSubstanceUnitsInL2v3}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSpeciesSpatialSizeUnitsInL2v3 NoSpeciesSpatialSizeUnitsInL2v3}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on {@link Species} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoEventTimeUnitsInL2v3 NoEventTimeUnitsInL2v3}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoDelayedEventAssignmentInL2v3 NoDelayedEventAssignmentInL2v3}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'useValuesFromTriggerTime' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ModelSBOBranchChangedBeyondL2v3 ModelSBOBranchChangedBeyondL2v3}</td>
<td class='meaning'>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#StrictUnitsRequiredInL2v3 StrictUnitsRequiredInL2v3}</td>
<td class='meaning'>SBML Level 2 Version 3 requires strict unit consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#StrictSBORequiredInL2v3 StrictSBORequiredInL2v3}</td>
<td class='meaning'>SBML Level 2 Version 3 requires strict {@link SBO} term consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateAnnotationInvalidInL2v3 DuplicateAnnotationInvalidInL2v3}</td>
<td class='meaning'>Duplicate top-level annotations are invalid in SBML Level 2 Version 3</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoUnitOffsetInL2v4 NoUnitOffsetInL2v4}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoKineticLawTimeUnitsInL2v4 NoKineticLawTimeUnitsInL2v4}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoKineticLawSubstanceUnitsInL2v4 NoKineticLawSubstanceUnitsInL2v4}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSpeciesSpatialSizeUnitsInL2v4 NoSpeciesSpatialSizeUnitsInL2v4}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on {@link Species} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoEventTimeUnitsInL2v4 NoEventTimeUnitsInL2v4}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ModelSBOBranchChangedInL2v4 ModelSBOBranchChangedInL2v4}</td>
<td class='meaning'>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateAnnotationInvalidInL2v4 DuplicateAnnotationInvalidInL2v4}</td>
<td class='meaning'>Duplicate top-level annotations are invalid in SBML Level 2 Version 4</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSpeciesTypeInL3v1 NoSpeciesTypeInL3v1}</td>
<td class='meaning'>SBML Level 3 Version 1 does not support {@link SpeciesType} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoCompartmentTypeInL3v1 NoCompartmentTypeInL3v1}</td>
<td class='meaning'>SBML Level 3 Version 1 does not support {@link CompartmentType} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoUnitOffsetInL3v1 NoUnitOffsetInL3v1}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoKineticLawTimeUnitsInL3v1 NoKineticLawTimeUnitsInL3v1}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoKineticLawSubstanceUnitsInL3v1 NoKineticLawSubstanceUnitsInL3v1}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoSpeciesSpatialSizeUnitsInL3v1 NoSpeciesSpatialSizeUnitsInL3v1}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on {@link Species} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoEventTimeUnitsInL3v1 NoEventTimeUnitsInL3v1}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ModelSBOBranchChangedInL3v1 ModelSBOBranchChangedInL3v1}</td>
<td class='meaning'>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DuplicateAnnotationInvalidInL3v1 DuplicateAnnotationInvalidInL3v1}</td>
<td class='meaning'>Duplicate top-level annotations are invalid in SBML Level 3 Version 1</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoCompartmentOutsideInL3v1 NoCompartmentOutsideInL3v1}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'outside' attribute on {@link Compartment} objects</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoStoichiometryMathInL3v1 NoStoichiometryMathInL3v1}</td>
<td class='meaning'>This Level+Version of SBML does not support the {@link StoichiometryMath} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DoubleExponentNotSupported DoubleExponentNotSupported}</td>
<td class='meaning'>Exponent of type double not supported in Levels 2 and 1.</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MathMLElementNotSupported MathMLElementNotSupported}</td>
<td class='meaning'>This MathML element is only permitted in L3V2</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EmptyListOfElementNotSupported EmptyListOfElementNotSupported}</td>
<td class='meaning'>Empty '{@link ListOf}' element is only permitted in L3V2</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingMathElementNotSupported MissingMathElementNotSupported}</td>
<td class='meaning'>Missing <code>&lt;math&gt;</code> element is only permitted in L3V2</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingTriggerElementNotSupported MissingTriggerElementNotSupported}</td>
<td class='meaning'>missing <code>&lt;trigger&gt;</code> element is only permitted in L3V2</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BooleanNumericDiscrepancy BooleanNumericDiscrepancy}</td>
<td class='meaning'>Interchange of Boolean and numeric values only permitted in L3V2</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#IdNameSBaseInL3V2 IdNameSBaseInL3V2}</td>
<td class='meaning'>Conversion will lose attributes only available in L3V2 and higher</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MissingParticipantsNotSupported MissingParticipantsNotSupported}</td>
<td class='meaning'>Omission of both <code>&lt;listOfReactants&gt;</code> and <code>&lt;listOfProducts&gt;</code> is only valid in L3V2</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConvertibleMathInitialAssignment ConvertibleMathInitialAssignment}</td>
<td class='meaning'>Some L3V2-specific MathML elements are not permitted in {@link InitialAssignment} objects</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FastReactionsNotSupported FastReactionsNotSupported}</td>
<td class='meaning'>Conversion of reactions employing the 'fast' attribute is not supported</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidSBMLLevelVersion InvalidSBMLLevelVersion}</td>
<td class='meaning'>Unknown Level+Version combination of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AnnotationNotesNotAllowedLevel1 AnnotationNotesNotAllowedLevel1}</td>
<td class='meaning'>Annotation objects on the SBML container element are not permitted in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidRuleOrdering InvalidRuleOrdering}</td>
<td class='meaning'>Invalid ordering of rules</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RequiredPackagePresent RequiredPackagePresent}</td>
<td class='meaning'>The SBML document requires an SBML Level 3 package unavailable in this software</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UnrequiredPackagePresent UnrequiredPackagePresent}</td>
<td class='meaning'>The SBML document uses an SBML Level 3 package unavailable in this software</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#PackageRequiredShouldBeFalse PackageRequiredShouldBeFalse}</td>
<td class='meaning'>This package expects required to be false</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SubsUnitsAllowedInKL SubsUnitsAllowedInKL}</td>
<td class='meaning'>Disallowed value for attribute 'substanceUnits' on {@link KineticLaw} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#TimeUnitsAllowedInKL TimeUnitsAllowedInKL}</td>
<td class='meaning'>Disallowed value for attribute 'timeUnits' on {@link KineticLaw} object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FormulaInLevel1KL FormulaInLevel1KL}</td>
<td class='meaning'>Only predefined functions are allowed in SBML Level 1 formulas</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3SubstanceUnitsOnModel L3SubstanceUnitsOnModel}</td>
<td class='meaning'>Invalid 'substanceUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#StoichiometryMathMissingMath StoichiometryMathMissingMath}</td>
<td class='meaning'>The <code>&lt;stoichiometryMath&gt;</code> element must contain a <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#TimeUnitsRemoved TimeUnitsRemoved}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadMathML BadMathML}</td>
<td class='meaning'>Invalid MathML expression</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FailedMathMLReadOfDouble FailedMathMLReadOfDouble}</td>
<td class='meaning'>Missing or invalid floating-point number in MathML expression</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FailedMathMLReadOfInteger FailedMathMLReadOfInteger}</td>
<td class='meaning'>Missing or invalid integer in MathML expression</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FailedMathMLReadOfExponential FailedMathMLReadOfExponential}</td>
<td class='meaning'>Missing or invalid exponential expression in MathML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FailedMathMLReadOfRational FailedMathMLReadOfRational}</td>
<td class='meaning'>Missing or invalid rational expression in MathML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#BadMathMLNodeType BadMathMLNodeType}</td>
<td class='meaning'>Invalid MathML element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidMathMLAttribute InvalidMathMLAttribute}</td>
<td class='meaning'>Invalid MathML attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoTimeSymbolInFunctionDef NoTimeSymbolInFunctionDef}</td>
<td class='meaning'>Use of <code>&lt;csymbol&gt;</code> for 'time' not allowed within {@link FunctionDefinition} objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NoBodyInFunctionDef NoBodyInFunctionDef}</td>
<td class='meaning'>There must be a <code>&lt;lambda&gt;</code> body within the <code>&lt;math&gt;</code> element of a {@link FunctionDefinition} object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#DanglingUnitSIdRef DanglingUnitSIdRef}</td>
<td class='meaning'>Units must refer to valid unit or unitDefinition</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RDFMissingAboutTag RDFMissingAboutTag}</td>
<td class='meaning'>RDF missing the <code>&lt;about&gt;</code> tag</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RDFEmptyAboutTag RDFEmptyAboutTag}</td>
<td class='meaning'>RDF empty <code>&lt;about&gt;</code> tag</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RDFAboutTagNotMetaid RDFAboutTagNotMetaid}</td>
<td class='meaning'>RDF <code>&lt;about&gt;</code> tag is not metaid</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RDFNotCompleteModelHistory RDFNotCompleteModelHistory}</td>
<td class='meaning'>RDF does not contain valid {@link ModelHistory}</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#RDFNotModelHistory RDFNotModelHistory}</td>
<td class='meaning'>RDF does not result in a {@link ModelHistory}</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#AnnotationNotElement AnnotationNotElement}</td>
<td class='meaning'>Annotation must contain element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NestedAnnotationNotAllowed NestedAnnotationNotAllowed}</td>
<td class='meaning'>Nested annotations not allowed</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UndeclaredUnits UndeclaredUnits}</td>
<td class='meaning'>Missing unit declarations on parameters or literal numbers in expression</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UndeclaredTimeUnitsL3 UndeclaredTimeUnitsL3}</td>
<td class='meaning'>Unable to verify consistency of units: the unit of time has not been declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UndeclaredExtentUnitsL3 UndeclaredExtentUnitsL3}</td>
<td class='meaning'>Unable to verify consistency of units: the units of reaction extent have not been declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UndeclaredObjectUnitsL3 UndeclaredObjectUnitsL3}</td>
<td class='meaning'>Unable to verify consistency of units: encountered a model entity with no declared units</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CannotVerifyUnitsObjectNoMath CannotVerifyUnitsObjectNoMath}</td>
<td class='meaning'>Unable to verify consistency of units: encountered an object with no <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UnrecognisedSBOTerm UnrecognisedSBOTerm}</td>
<td class='meaning'>Unrecognized 'sboTerm' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ObseleteSBOTerm ObseleteSBOTerm}</td>
<td class='meaning'>Obsolete 'sboTerm' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#IncorrectCompartmentSpatialDimensions IncorrectCompartmentSpatialDimensions}</td>
<td class='meaning'>In SBML Level 1, only three-dimensional compartments are allowed</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompartmentTypeNotValidAttribute CompartmentTypeNotValidAttribute}</td>
<td class='meaning'>CompartmentType objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConstantNotValidAttribute ConstantNotValidAttribute}</td>
<td class='meaning'>This Level+Version of SBML does not support the 'constant' attribute on this component</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MetaIdNotValidAttribute MetaIdNotValidAttribute}</td>
<td class='meaning'>Attribute 'metaid' is not available in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SBOTermNotValidAttributeBeforeL2V3 SBOTermNotValidAttributeBeforeL2V3}</td>
<td class='meaning'>The 'sboTerm' attribute is not available on this component before SBML Level 2 Version 3</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidL1CompartmentUnits InvalidL1CompartmentUnits}</td>
<td class='meaning'>Invalid units for a compartment in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L1V1CompartmentVolumeReqd L1V1CompartmentVolumeReqd}</td>
<td class='meaning'>In SBML Level 1, a compartment's volume must be specified</td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompartmentTypeNotValidComponent CompartmentTypeNotValidComponent}</td>
<td class='meaning'>CompartmentType objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConstraintNotValidComponent ConstraintNotValidComponent}</td>
<td class='meaning'>Constraint objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#EventNotValidComponent EventNotValidComponent}</td>
<td class='meaning'>Event objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SBOTermNotValidAttributeBeforeL2V2 SBOTermNotValidAttributeBeforeL2V2}</td>
<td class='meaning'>The 'sboTerm' attribute is invalid for this component before Level 2 Version 2</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FuncDefNotValidComponent FuncDefNotValidComponent}</td>
<td class='meaning'>FunctionDefinition objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InitialAssignNotValidComponent InitialAssignNotValidComponent}</td>
<td class='meaning'>InitialAssignment objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#VariableNotValidAttribute VariableNotValidAttribute}</td>
<td class='meaning'>Attribute 'variable' is not available on this component in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#UnitsNotValidAttribute UnitsNotValidAttribute}</td>
<td class='meaning'>Attribute 'units' is not available on this component in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#ConstantSpeciesNotValidAttribute ConstantSpeciesNotValidAttribute}</td>
<td class='meaning'>Attribute 'constant' is not available on {@link Species} objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpatialSizeUnitsNotValidAttribute SpatialSizeUnitsNotValidAttribute}</td>
<td class='meaning'>Attribute 'spatialSizeUnits' is not available on {@link Species} objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpeciesTypeNotValidAttribute SpeciesTypeNotValidAttribute}</td>
<td class='meaning'>Attribute 'speciesType' is not available on {@link Species} objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#HasOnlySubsUnitsNotValidAttribute HasOnlySubsUnitsNotValidAttribute}</td>
<td class='meaning'>Attribute 'hasOnlySubstanceUnits' is not available on {@link Species} objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#IdNotValidAttribute IdNotValidAttribute}</td>
<td class='meaning'>Attribute 'id' is not available on {@link SpeciesReference} objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#NameNotValidAttribute NameNotValidAttribute}</td>
<td class='meaning'>Attribute 'name' is not available on {@link SpeciesReference} objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#SpeciesTypeNotValidComponent SpeciesTypeNotValidComponent}</td>
<td class='meaning'>The {@link SpeciesType} object is not supported in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#StoichiometryMathNotValidComponent StoichiometryMathNotValidComponent}</td>
<td class='meaning'>The {@link StoichiometryMath} object is not supported in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#MultiplierNotValidAttribute MultiplierNotValidAttribute}</td>
<td class='meaning'>Attribute 'multiplier' on {@link Unit} objects is not supported in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#OffsetNotValidAttribute OffsetNotValidAttribute}</td>
<td class='meaning'>Attribute 'offset' on {@link Unit} objects is only available in SBML Level 2 Version 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3SpatialDimensionsUnset L3SpatialDimensionsUnset}</td>
<td class='meaning'>No value given for 'spatialDimensions' attribute; assuming a value of 3</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#PackageConversionNotSupported PackageConversionNotSupported}</td>
<td class='meaning'>Conversion of SBML Level 3 package constructs is not yet supported</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#InvalidTargetLevelVersion InvalidTargetLevelVersion}</td>
<td class='meaning'>The requested SBML Level/Version combination is not known to exist</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#L3NotSupported L3NotSupported}</td>
<td class='meaning'>SBML Level 3 is not yet supported</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompUnknown CompUnknown}</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompNSUndeclared CompNSUndeclared}</td>
<td class='meaning'>The comp ns is not correctly declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompElementNotInNs CompElementNotInNs}</td>
<td class='meaning'>Element not in comp namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompDuplicateComponentId CompDuplicateComponentId}</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompUniqueModelIds CompUniqueModelIds}</td>
<td class='meaning'>Model and ExternalModelDefinitions must have unique ids</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompUniquePortIds CompUniquePortIds}</td>
<td class='meaning'>Ports must have unique ids</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidSIdSyntax CompInvalidSIdSyntax}</td>
<td class='meaning'>Invalid SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidSubmodelRefSyntax CompInvalidSubmodelRefSyntax}</td>
<td class='meaning'>Invalid submodelRef syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidDeletionSyntax CompInvalidDeletionSyntax}</td>
<td class='meaning'>Invalid deletion syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidConversionFactorSyntax CompInvalidConversionFactorSyntax}</td>
<td class='meaning'>Invalid conversionFactor syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidNameSyntax CompInvalidNameSyntax}</td>
<td class='meaning'>Invalid name syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedUnitsShouldMatch CompReplacedUnitsShouldMatch}</td>
<td class='meaning'>Units of replaced elements should match replacement units.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompOneListOfReplacedElements CompOneListOfReplacedElements}</td>
<td class='meaning'>Only one <code>&lt;listOfReplacedElements&gt;</code> allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOReplaceElementsAllowedElements CompLOReplaceElementsAllowedElements}</td>
<td class='meaning'>Allowed children of <code>&lt;listOfReplacedElements&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOReplacedElementsAllowedAttribs CompLOReplacedElementsAllowedAttribs}</td>
<td class='meaning'>Allowed <code>&lt;listOfReplacedElements&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompEmptyLOReplacedElements CompEmptyLOReplacedElements}</td>
<td class='meaning'><code>&lt;listOfReplacedElements&gt;</code> must not be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompOneReplacedByElement CompOneReplacedByElement}</td>
<td class='meaning'>Only one <code>&lt;replacedBy&gt;</code> object allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompAttributeRequiredMissing CompAttributeRequiredMissing}</td>
<td class='meaning'>Required comp:required attribute on <code>&lt;sbml&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompAttributeRequiredMustBeBoolean CompAttributeRequiredMustBeBoolean}</td>
<td class='meaning'>The comp:required attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompRequiredTrueIfElementsRemain CompRequiredTrueIfElementsRemain}</td>
<td class='meaning'>The comp:required attribute must be 'true' if math changes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompRequiredFalseIfAllElementsReplaced CompRequiredFalseIfAllElementsReplaced}</td>
<td class='meaning'>The comp:required attribute must be 'false' if math does not change</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompOneListOfModelDefinitions CompOneListOfModelDefinitions}</td>
<td class='meaning'>Only one <code>&lt;listOfModelDefinitions&gt;</code> allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompEmptyLOModelDefs CompEmptyLOModelDefs}</td>
<td class='meaning'><code>&lt;listOfModelDefinitions&gt;</code> and <code>&lt;listOfExternalModelDefinitions&gt;</code> must not be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOModelDefsAllowedElements CompLOModelDefsAllowedElements}</td>
<td class='meaning'>Only <code>&lt;modelDefinitions&gt;</code> in <code>&lt;listOfModelDefinitions&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOExtModelDefsAllowedElements CompLOExtModelDefsAllowedElements}</td>
<td class='meaning'>Only <code>&lt;externalModelDefinitions&gt;</code> in <code>&lt;listOfExternalModelDefinitions&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOModelDefsAllowedAttributes CompLOModelDefsAllowedAttributes}</td>
<td class='meaning'>Allowed <code>&lt;listOfModelDefinitions&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOExtModDefsAllowedAttributes CompLOExtModDefsAllowedAttributes}</td>
<td class='meaning'>Allowed <code>&lt;listOfExternalModelDefinitions&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompOneListOfExtModelDefinitions CompOneListOfExtModelDefinitions}</td>
<td class='meaning'>Only one <code>&lt;listOfExternalModelDefinitions&gt;</code> allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompAttributeRequiredMustBeTrue CompAttributeRequiredMustBeTrue}</td>
<td class='meaning'>The comp:required attribute must be 'true'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompExtModDefAllowedCoreAttributes CompExtModDefAllowedCoreAttributes}</td>
<td class='meaning'>Allowed <code>&lt;externalModelDefinitions&gt;</code> core attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompExtModDefAllowedElements CompExtModDefAllowedElements}</td>
<td class='meaning'>Allowed <code>&lt;externalModelDefinitions&gt;</code> elements</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompExtModDefAllowedAttributes CompExtModDefAllowedAttributes}</td>
<td class='meaning'>Allowed <code>&lt;externalModelDefinitions&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReferenceMustBeL3 CompReferenceMustBeL3}</td>
<td class='meaning'>External models must be L3</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompModReferenceMustIdOfModel CompModReferenceMustIdOfModel}</td>
<td class='meaning'>'modelRef' must be the 'id' of a model in the 'source' document</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompExtModMd5DoesNotMatch CompExtModMd5DoesNotMatch}</td>
<td class='meaning'>MD5 checksum does not match the 'source' document</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidSourceSyntax CompInvalidSourceSyntax}</td>
<td class='meaning'>The 'comp:source' attribute must be of type 'anyURI'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidModelRefSyntax CompInvalidModelRefSyntax}</td>
<td class='meaning'>The 'comp:modelRef' attribute must have the syntax of 'SId'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidMD5Syntax CompInvalidMD5Syntax}</td>
<td class='meaning'>The 'comp:md5' attribute must have the syntax of 'string'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompCircularExternalModelReference CompCircularExternalModelReference}</td>
<td class='meaning'>Circular reference in <code>&lt;externalModelDefinition&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompOneListOfOnModel CompOneListOfOnModel}</td>
<td class='meaning'>Only one <code>&lt;listOfSubmodels&gt;</code> and one <code>&lt;listOfPorts&gt;</code> allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompNoEmptyListOfOnModel CompNoEmptyListOfOnModel}</td>
<td class='meaning'>No empty listOf elements allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOSubmodelsAllowedElements CompLOSubmodelsAllowedElements}</td>
<td class='meaning'>Allowed elements on <code>&lt;listOfSubmodels&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOPortsAllowedElements CompLOPortsAllowedElements}</td>
<td class='meaning'>Allowed elements on <code>&lt;listOfPorts&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOSubmodelsAllowedAttributes CompLOSubmodelsAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on <code>&lt;listOfSubmodels&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLOPortsAllowedAttributes CompLOPortsAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on <code>&lt;listOfPorts&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompSubmodelAllowedCoreAttributes CompSubmodelAllowedCoreAttributes}</td>
<td class='meaning'>Allowed core attributes on <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompSubmodelAllowedElements CompSubmodelAllowedElements}</td>
<td class='meaning'>Allowed elements on <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompOneListOfDeletionOnSubmodel CompOneListOfDeletionOnSubmodel}</td>
<td class='meaning'>Only one <code>&lt;listOfDeletions&gt;</code> on a <code>&lt;submodel&gt;</code> allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompSubmodelNoEmptyLODeletions CompSubmodelNoEmptyLODeletions}</td>
<td class='meaning'>No empty listOfDeletions elements allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLODeletionsAllowedElements CompLODeletionsAllowedElements}</td>
<td class='meaning'>Allowed elements on <code>&lt;listOfDeletions&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLODeletionAllowedAttributes CompLODeletionAllowedAttributes}</td>
<td class='meaning'>Allowed <code>&lt;listOfDeletions&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompSubmodelAllowedAttributes CompSubmodelAllowedAttributes}</td>
<td class='meaning'>Allowed <code>&lt;submodel&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompModReferenceSyntax CompModReferenceSyntax}</td>
<td class='meaning'>'comp:modelRef' must conform to SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidTimeConvFactorSyntax CompInvalidTimeConvFactorSyntax}</td>
<td class='meaning'>'comp:timeConversionFactor' must conform to SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidExtentConvFactorSyntax CompInvalidExtentConvFactorSyntax}</td>
<td class='meaning'>'comp:extentConversionFactor' must conform to SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompSubmodelMustReferenceModel CompSubmodelMustReferenceModel}</td>
<td class='meaning'>The 'comp:modelRef' attribute must reference a model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompSubmodelCannotReferenceSelf CompSubmodelCannotReferenceSelf}</td>
<td class='meaning'>The 'comp:modelRef' attribute cannot reference own model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompModCannotCircularlyReferenceSelf CompModCannotCircularlyReferenceSelf}</td>
<td class='meaning'><code>&lt;model&gt;</code> may not reference <code>&lt;submodel&gt;</code> that references itself.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompTimeConversionMustBeParameter CompTimeConversionMustBeParameter}</td>
<td class='meaning'>The 'comp:timeConversionFactor' must reference a parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompExtentConversionMustBeParameter CompExtentConversionMustBeParameter}</td>
<td class='meaning'>The 'comp:extentConversionFactor' must reference a parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompPortRefMustReferencePort CompPortRefMustReferencePort}</td>
<td class='meaning'>The 'comp:portRef' attribute must be the 'id' of a <code>&lt;port&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompIdRefMustReferenceObject CompIdRefMustReferenceObject}</td>
<td class='meaning'>The 'comp:idRef' attribute must be the 'id' of a model element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompUnitRefMustReferenceUnitDef CompUnitRefMustReferenceUnitDef}</td>
<td class='meaning'>The 'comp:unitRef' attribute must be the 'id' of a {@link UnitDefinition}</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompMetaIdRefMustReferenceObject CompMetaIdRefMustReferenceObject}</td>
<td class='meaning'>The 'comp:metaIdRef' attribute must be the 'metaid' of an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompParentOfSBRefChildMustBeSubmodel CompParentOfSBRefChildMustBeSubmodel}</td>
<td class='meaning'>If <code>&lt;sBaseRef&gt;</code> has a child <code>&lt;sBaseRef&gt;</code> its parent must be a <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidPortRefSyntax CompInvalidPortRefSyntax}</td>
<td class='meaning'>The 'comp:portRef' attribute must have the syntax of an SBML SId</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidIdRefSyntax CompInvalidIdRefSyntax}</td>
<td class='meaning'>The 'comp:idRef' attribute must have the syntax of an SBML SId</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidUnitRefSyntax CompInvalidUnitRefSyntax}</td>
<td class='meaning'>The 'comp:unitRef' attribute must have the syntax of an SBML SId</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompInvalidMetaIdRefSyntax CompInvalidMetaIdRefSyntax}</td>
<td class='meaning'>The 'comp:metaIdRef' attribute must have the syntax of an XML ID</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompOneSBaseRefOnly CompOneSBaseRefOnly}</td>
<td class='meaning'>Only one <code>&lt;sbaseRef&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompDeprecatedSBaseRefSpelling CompDeprecatedSBaseRefSpelling}</td>
<td class='meaning'>The spelling 'sbaseRef' is deprecated</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompSBaseRefMustReferenceObject CompSBaseRefMustReferenceObject}</td>
<td class='meaning'>An SBaseRef must reference an object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompSBaseRefMustReferenceOnlyOneObject CompSBaseRefMustReferenceOnlyOneObject}</td>
<td class='meaning'>An SBaseRef must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompNoMultipleReferences CompNoMultipleReferences}</td>
<td class='meaning'>Objects may not be referenced by mutiple SBaseRef constructs.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompPortMustReferenceObject CompPortMustReferenceObject}</td>
<td class='meaning'>Port must reference an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompPortMustReferenceOnlyOneObject CompPortMustReferenceOnlyOneObject}</td>
<td class='meaning'>Port must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompPortAllowedAttributes CompPortAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on a Port</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompPortReferencesUnique CompPortReferencesUnique}</td>
<td class='meaning'>Port definitions must be unique.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompDeletionMustReferenceObject CompDeletionMustReferenceObject}</td>
<td class='meaning'>Deletion must reference an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompDeletionMustReferOnlyOneObject CompDeletionMustReferOnlyOneObject}</td>
<td class='meaning'>Deletion must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompDeletionAllowedAttributes CompDeletionAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on a Deletion</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedElementMustRefObject CompReplacedElementMustRefObject}</td>
<td class='meaning'>ReplacedElement must reference an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedElementMustRefOnlyOne CompReplacedElementMustRefOnlyOne}</td>
<td class='meaning'>ReplacedElement must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedElementAllowedAttributes CompReplacedElementAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on <code>&lt;replacedElement&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedElementSubModelRef CompReplacedElementSubModelRef}</td>
<td class='meaning'>The 'comp:submodelRef' attribute must point to a <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedElementDeletionRef CompReplacedElementDeletionRef}</td>
<td class='meaning'>The 'comp:deletion' attribute must point to a <code>&lt;deletion&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedElementConvFactorRef CompReplacedElementConvFactorRef}</td>
<td class='meaning'>The 'comp:conversionFactor attribute must point to a <code>&lt;parameter&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedElementSameReference CompReplacedElementSameReference}</td>
<td class='meaning'>No <code>&lt;replacedElement&gt;</code> refer to same object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedElementNoDelAndConvFact CompReplacedElementNoDelAndConvFact}</td>
<td class='meaning'>No <code>&lt;replacedElement&gt;</code> with deletion and conversionfactor</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedByMustRefObject CompReplacedByMustRefObject}</td>
<td class='meaning'>ReplacedBy must reference an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedByMustRefOnlyOne CompReplacedByMustRefOnlyOne}</td>
<td class='meaning'>ReplacedBy must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedByAllowedAttributes CompReplacedByAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on <code>&lt;replacedBy&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompReplacedBySubModelRef CompReplacedBySubModelRef}</td>
<td class='meaning'>The 'comp:submodelRef' attribute must point to a <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompMustReplaceSameClass CompMustReplaceSameClass}</td>
<td class='meaning'>Replaced classes must match.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompMustReplaceIDs CompMustReplaceIDs}</td>
<td class='meaning'>Replaced IDs must be replaced with IDs.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompMustReplaceMetaIDs CompMustReplaceMetaIDs}</td>
<td class='meaning'>Replaced metaids must be replaced with metaids.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompMustReplacePackageIDs CompMustReplacePackageIDs}</td>
<td class='meaning'>Replaced package IDs must be replaced with package IDs.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompUnresolvedReference CompUnresolvedReference}</td>
<td class='meaning'>Unresolved reference.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompNoModelInReference CompNoModelInReference}</td>
<td class='meaning'>No model in referenced document.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompExtModDefBad CompExtModDefBad}</td>
<td class='meaning'>Referenced <code>&lt;externalModelDefinition&gt;</code> unresolvable.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompModelFlatteningFailed CompModelFlatteningFailed}</td>
<td class='meaning'>Model failed to flatten.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompFlatModelNotValid CompFlatModelNotValid}</td>
<td class='meaning'>Flat model not valid.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompLineNumbersUnreliable CompLineNumbersUnreliable}</td>
<td class='meaning'>Line numbers unreliable.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompFlatteningNotRecognisedReqd CompFlatteningNotRecognisedReqd}</td>
<td class='meaning'>Flattening not implemented for required package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompFlatteningNotRecognisedNotReqd CompFlatteningNotRecognisedNotReqd}</td>
<td class='meaning'>Flattening not implemented for unrequired package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompFlatteningNotImplementedNotReqd CompFlatteningNotImplementedNotReqd}</td>
<td class='meaning'>Flattening not implemented for unrequired package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompFlatteningNotImplementedReqd CompFlatteningNotImplementedReqd}</td>
<td class='meaning'>Flattening not implemented for required package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompFlatteningWarning CompFlatteningWarning}</td>
<td class='meaning'>Flattening reference may come from package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompDeprecatedDeleteFunction CompDeprecatedDeleteFunction}</td>
<td class='meaning'>The performDeletions functions is deprecated.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompDeprecatedReplaceFunction CompDeprecatedReplaceFunction}</td>
<td class='meaning'>The performReplacementsAndConversions fuctions is deprecated.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompDeletedReplacement CompDeletedReplacement}</td>
<td class='meaning'>Element deleted before a subelement could be replaced.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompIdRefMayReferenceUnknownPackage CompIdRefMayReferenceUnknownPackage}</td>
<td class='meaning'>The 'comp:idRef' attribute must be the 'id' of a model element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#CompMetaIdRefMayReferenceUnknownPkg CompMetaIdRefMayReferenceUnknownPkg}</td>
<td class='meaning'>The 'comp:metaIdRef' attribute must be the 'metaid' of a model element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcUnknown FbcUnknown}</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcNSUndeclared FbcNSUndeclared}</td>
<td class='meaning'>The fbc ns is not correctly declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcElementNotInNs FbcElementNotInNs}</td>
<td class='meaning'>Element not in fbc namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcDuplicateComponentId FbcDuplicateComponentId}</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcSBMLSIdSyntax FbcSBMLSIdSyntax}</td>
<td class='meaning'>Invalid 'id' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcAttributeRequiredMissing FbcAttributeRequiredMissing}</td>
<td class='meaning'>Required fbc:required attribute on <code>&lt;sbml&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcAttributeRequiredMustBeBoolean FbcAttributeRequiredMustBeBoolean}</td>
<td class='meaning'>The fbc:required attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcRequiredFalse FbcRequiredFalse}</td>
<td class='meaning'>The fbc:required attribute must be 'false'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcOnlyOneEachListOf FbcOnlyOneEachListOf}</td>
<td class='meaning'>One of each list of allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcNoEmptyListOfs FbcNoEmptyListOfs}</td>
<td class='meaning'>ListOf elements cannot be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcLOFluxBoundsAllowedElements FbcLOFluxBoundsAllowedElements}</td>
<td class='meaning'>Allowed elements on ListOfFluxBounds</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcLOObjectivesAllowedElements FbcLOObjectivesAllowedElements}</td>
<td class='meaning'>Allowed elements on ListOfObjectives</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcLOFluxBoundsAllowedAttributes FbcLOFluxBoundsAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on ListOfFluxBounds</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcLOObjectivesAllowedAttributes FbcLOObjectivesAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on ListOfObjectives</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcActiveObjectiveSyntax FbcActiveObjectiveSyntax}</td>
<td class='meaning'>Type of activeObjective attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcActiveObjectiveRefersObjective FbcActiveObjectiveRefersObjective}</td>
<td class='meaning'>ActiveObjective must reference Objective</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcModelMustHaveStrict FbcModelMustHaveStrict}</td>
<td class='meaning'>'Strict' attribute required on <code>&lt;model&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcModelStrictMustBeBoolean FbcModelStrictMustBeBoolean}</td>
<td class='meaning'>'Strict' attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcLOGeneProductsAllowedElements FbcLOGeneProductsAllowedElements}</td>
<td class='meaning'>Allowed elements on ListOfGeneProducts</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcLOGeneProductsAllowedAttributes FbcLOGeneProductsAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on ListOfGeneProducts</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcSpeciesAllowedL3Attributes FbcSpeciesAllowedL3Attributes}</td>
<td class='meaning'>Species allowed attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcSpeciesChargeMustBeInteger FbcSpeciesChargeMustBeInteger}</td>
<td class='meaning'>Charge must be integer</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcSpeciesFormulaMustBeString FbcSpeciesFormulaMustBeString}</td>
<td class='meaning'>Chemical formula must be string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxBoundAllowedL3Attributes FbcFluxBoundAllowedL3Attributes}</td>
<td class='meaning'><code>&lt;fluxBound&gt;</code> may only have 'metaId' and 'sboTerm' from L3 namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxBoundAllowedElements FbcFluxBoundAllowedElements}</td>
<td class='meaning'><code>&lt;fluxBound&gt;</code> may only have <code>&lt;notes&gt;</code> and <code>&lt;annotations&gt;</code> from L3 Core</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxBoundRequiredAttributes FbcFluxBoundRequiredAttributes}</td>
<td class='meaning'>Invalid attribute found on <code>&lt;fluxBound&gt;</code> object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxBoundRectionMustBeSIdRef FbcFluxBoundRectionMustBeSIdRef}</td>
<td class='meaning'>Datatype for 'fbc:reaction' must be SIdRef</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxBoundNameMustBeString FbcFluxBoundNameMustBeString}</td>
<td class='meaning'>The attribute 'fbc:name' must be of the data type string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxBoundOperationMustBeEnum FbcFluxBoundOperationMustBeEnum}</td>
<td class='meaning'>The attribute 'fbc:operation' must be of data type FbcOperation</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxBoundValueMustBeDouble FbcFluxBoundValueMustBeDouble}</td>
<td class='meaning'>The attribute 'fbc:value' must be of the data type double</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxBoundReactionMustExist FbcFluxBoundReactionMustExist}</td>
<td class='meaning'>'fbc:reaction' must refer to valid reaction</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxBoundsForReactionConflict FbcFluxBoundsForReactionConflict}</td>
<td class='meaning'>Conflicting set of FluxBounds for a reaction</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcObjectiveAllowedL3Attributes FbcObjectiveAllowedL3Attributes}</td>
<td class='meaning'><code>&lt;objective&gt;</code> may only have 'metaId' and 'sboTerm' from L3 namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcObjectiveAllowedElements FbcObjectiveAllowedElements}</td>
<td class='meaning'><code>&lt;objective&gt;</code> may only have <code>&lt;notes&gt;</code> and <code>&lt;annotations&gt;</code> from L3 Core</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcObjectiveRequiredAttributes FbcObjectiveRequiredAttributes}</td>
<td class='meaning'>Invalid attribute found on <code>&lt;objective&gt;</code> object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcObjectiveNameMustBeString FbcObjectiveNameMustBeString}</td>
<td class='meaning'>The attribute 'fbc:name' must be of the data type string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcObjectiveTypeMustBeEnum FbcObjectiveTypeMustBeEnum}</td>
<td class='meaning'>The attribute 'fbc:type' must be of data type FbcType.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcObjectiveOneListOfObjectives FbcObjectiveOneListOfObjectives}</td>
<td class='meaning'>An <code>&lt;objective&gt;</code> must have one <code>&lt;listOfFluxObjectives&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcObjectiveLOFluxObjMustNotBeEmpty FbcObjectiveLOFluxObjMustNotBeEmpty}</td>
<td class='meaning'><code>&lt;listOfFluxObjectives&gt;</code> subobject must not be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcObjectiveLOFluxObjOnlyFluxObj FbcObjectiveLOFluxObjOnlyFluxObj}</td>
<td class='meaning'>Invalid element found in <code>&lt;listOfFluxObjectives&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcObjectiveLOFluxObjAllowedAttribs FbcObjectiveLOFluxObjAllowedAttribs}</td>
<td class='meaning'><code>&lt;listOfFluxObjectives&gt;</code> may only have 'metaId' and 'sboTerm' from L3 core</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxObjectAllowedL3Attributes FbcFluxObjectAllowedL3Attributes}</td>
<td class='meaning'><code>&lt;fluxObjective&gt;</code> may only have 'metaId' and 'sboTerm' from L3 namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxObjectAllowedElements FbcFluxObjectAllowedElements}</td>
<td class='meaning'><code>&lt;fluxObjective&gt;</code> may only have <code>&lt;notes&gt;</code> and <code>&lt;annotations&gt;</code> from L3 Core</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxObjectRequiredAttributes FbcFluxObjectRequiredAttributes}</td>
<td class='meaning'>Invalid attribute found on <code>&lt;fluxObjective&gt;</code> object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxObjectNameMustBeString FbcFluxObjectNameMustBeString}</td>
<td class='meaning'>The attribute 'fbc:name' must be of the data type string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxObjectReactionMustBeSIdRef FbcFluxObjectReactionMustBeSIdRef}</td>
<td class='meaning'>Datatype for 'fbc:reaction' must be SIdRef</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxObjectReactionMustExist FbcFluxObjectReactionMustExist}</td>
<td class='meaning'>'fbc:reaction' must refer to valid reaction</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxObjectCoefficientMustBeDouble FbcFluxObjectCoefficientMustBeDouble}</td>
<td class='meaning'>The attribute 'fbc:coefficient' must be of the data type double</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcFluxObjectCoefficientWhenStrict FbcFluxObjectCoefficientWhenStrict}</td>
<td class='meaning'>The 'fbc:coefficient' must be declared when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionOnlyOneGeneProdAss FbcReactionOnlyOneGeneProdAss}</td>
<td class='meaning'>One GeneProductAssociation in a {@link Reaction}</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionAllowedAttributes FbcReactionAllowedAttributes}</td>
<td class='meaning'>Fbc attributes on a {@link Reaction}</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionLwrBoundSIdRef FbcReactionLwrBoundSIdRef}</td>
<td class='meaning'>LowerBound must be SIdRef</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionUpBoundSIdRef FbcReactionUpBoundSIdRef}</td>
<td class='meaning'>UpperBound must be SIdRef</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionLwrBoundRefExists FbcReactionLwrBoundRefExists}</td>
<td class='meaning'>LowerBound must point to {@link Parameter}</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionUpBoundRefExists FbcReactionUpBoundRefExists}</td>
<td class='meaning'>UpperBound must point to {@link Parameter}</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionMustHaveBoundsStrict FbcReactionMustHaveBoundsStrict}</td>
<td class='meaning'>Reaction must have bounds when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionConstantBoundsStrict FbcReactionConstantBoundsStrict}</td>
<td class='meaning'>Reaction bounds constant when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionBoundsMustHaveValuesStrict FbcReactionBoundsMustHaveValuesStrict}</td>
<td class='meaning'>Reaction bounds must have values when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionBoundsNotAssignedStrict FbcReactionBoundsNotAssignedStrict}</td>
<td class='meaning'>Reaction bounds not assigned when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionLwrBoundNotInfStrict FbcReactionLwrBoundNotInfStrict}</td>
<td class='meaning'>LowerBound cannot be INF when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionUpBoundNotNegInfStrict FbcReactionUpBoundNotNegInfStrict}</td>
<td class='meaning'>UpperBound cannot be -INF when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcReactionLwrLessThanUpStrict FbcReactionLwrLessThanUpStrict}</td>
<td class='meaning'>LowerBound less than upperBound when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcSpeciesReferenceConstantStrict FbcSpeciesReferenceConstantStrict}</td>
<td class='meaning'>SpeciesReferences must be constant when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcSpeciesRefsStoichMustBeRealStrict FbcSpeciesRefsStoichMustBeRealStrict}</td>
<td class='meaning'>Stoichiometry of SpeciesReferences must be real valued when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcSpeciesRefNotAssignedStrict FbcSpeciesRefNotAssignedStrict}</td>
<td class='meaning'>SpeciesReference not target of {@link InitialAssignment} when strict</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdAssocAllowedCoreAttribs FbcGeneProdAssocAllowedCoreAttribs}</td>
<td class='meaning'>Allowed core attributes on <code>&lt;GeneProductAssociation&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdAssocAllowedCoreElements FbcGeneProdAssocAllowedCoreElements}</td>
<td class='meaning'>Allowed core elements on <code>&lt;GeneProductAssociation&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdAssocAllowedAttribs FbcGeneProdAssocAllowedAttribs}</td>
<td class='meaning'>Allowed fbc attributes on <code>&lt;GeneProductAssociation&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdAssocIdSyntax FbcGeneProdAssocIdSyntax}</td>
<td class='meaning'>'fbc:id' must have SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdAssocContainsOneElement FbcGeneProdAssocContainsOneElement}</td>
<td class='meaning'><code>&lt;GeneProductAssociation&gt;</code> must contain one concrete object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdAssocNameMustBeString FbcGeneProdAssocNameMustBeString}</td>
<td class='meaning'>'fbc:name' must be string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdRefAllowedCoreAttribs FbcGeneProdRefAllowedCoreAttribs}</td>
<td class='meaning'>Allowed core attributes on <code>&lt;GeneProductRef&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdRefAllowedCoreElements FbcGeneProdRefAllowedCoreElements}</td>
<td class='meaning'>Allowed core elements on <code>&lt;GeneProductRef&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdRefAllowedAttribs FbcGeneProdRefAllowedAttribs}</td>
<td class='meaning'>Allowed fbc attributes on <code>&lt;GeneProductRef&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdRefGeneProductSIdRef FbcGeneProdRefGeneProductSIdRef}</td>
<td class='meaning'>'fbc:geneProduct' must be SIdRef</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProdRefGeneProductExists FbcGeneProdRefGeneProductExists}</td>
<td class='meaning'>'fbc:geneProduct' must point to existing <code>&lt;GeneProduct&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcAndAllowedCoreAttributes FbcAndAllowedCoreAttributes}</td>
<td class='meaning'>Allowed core attributes on <code>&lt;And&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcAndAllowedCoreElements FbcAndAllowedCoreElements}</td>
<td class='meaning'>Allowed core attributes on <code>&lt;And&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcAndTwoChildren FbcAndTwoChildren}</td>
<td class='meaning'><code>&lt;And&gt;</code> must have at least two child elements</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcOrAllowedCoreAttributes FbcOrAllowedCoreAttributes}</td>
<td class='meaning'>Allowed core attributes on <code>&lt;Or&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcOrAllowedCoreElements FbcOrAllowedCoreElements}</td>
<td class='meaning'>Allowed core elements on <code>&lt;Or&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcOrTwoChildren FbcOrTwoChildren}</td>
<td class='meaning'><code>&lt;Or&gt;</code> must have at least two child elements</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProductAllowedCoreAttributes FbcGeneProductAllowedCoreAttributes}</td>
<td class='meaning'>Allowed core attributes on <code>&lt;GeneProduct&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProductAllowedCoreElements FbcGeneProductAllowedCoreElements}</td>
<td class='meaning'>Allowed core elements on <code>&lt;GeneProduct&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProductAllowedAttributes FbcGeneProductAllowedAttributes}</td>
<td class='meaning'>Allowed fbc attributes on <code>&lt;GeneProduct&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProductLabelMustBeString FbcGeneProductLabelMustBeString}</td>
<td class='meaning'>'fbc:label' must be string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProductLabelMustBeUnique FbcGeneProductLabelMustBeUnique}</td>
<td class='meaning'>'fbc:label' must be unique</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProductNameMustBeString FbcGeneProductNameMustBeString}</td>
<td class='meaning'>'fbc:name' must be string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#FbcGeneProductAssocSpeciesMustExist FbcGeneProductAssocSpeciesMustExist}</td>
<td class='meaning'>'fbc:associatedSpecies' must point to existing <code>&lt;species&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualUnknown QualUnknown}</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualNSUndeclared QualNSUndeclared}</td>
<td class='meaning'>The qual ns is not correctly declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualElementNotInNs QualElementNotInNs}</td>
<td class='meaning'>Element not in qual namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualFunctionTermBool QualFunctionTermBool}</td>
<td class='meaning'>FunctionTerm should return Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualMathCSymbolDisallowed QualMathCSymbolDisallowed}</td>
<td class='meaning'>CSymbol time or delay not allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualDuplicateComponentId QualDuplicateComponentId}</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualAttributeRequiredMissing QualAttributeRequiredMissing}</td>
<td class='meaning'>Required qual:required attribute on <code>&lt;sbml&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualAttributeRequiredMustBeBoolean QualAttributeRequiredMustBeBoolean}</td>
<td class='meaning'>The qual:required attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualRequiredTrueIfTransitions QualRequiredTrueIfTransitions}</td>
<td class='meaning'>The qual:required attribute must be 'true' if math changes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOneListOfTransOrQS QualOneListOfTransOrQS}</td>
<td class='meaning'>Only one <code>&lt;listOfTransitions&gt;</code> or <code>&lt;listOfQualitativeSpeciesgt;</code> allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualEmptyLONotAllowed QualEmptyLONotAllowed}</td>
<td class='meaning'>Empty <code>&lt;listOfTransitions&gt;</code> or <code>&lt;listOfQualitativeSpeciesgt;</code> not allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualLOTransitiondAllowedElements QualLOTransitiondAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfTransitions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualLOQualSpeciesAllowedElements QualLOQualSpeciesAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfTransitions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualLOQualSpeciesAllowedAttributes QualLOQualSpeciesAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfQualitativeSpeciesgt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualLOTransitionsAllowedAttributes QualLOTransitionsAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfTransitions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualQualSpeciesAllowedCoreAttributes QualQualSpeciesAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;qualitativeSpeciesgt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualQualSpeciesAllowedElements QualQualSpeciesAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;qualitativeSpeciesgt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualQualSpeciesAllowedAttributes QualQualSpeciesAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;qualitativeSpeciesgt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualConstantMustBeBool QualConstantMustBeBool}</td>
<td class='meaning'>Attribute 'constant' on <code>&lt;qualitativeSpeciesgt;</code> must be Boolean.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualNameMustBeString QualNameMustBeString}</td>
<td class='meaning'>Attribute 'name' on <code>&lt;qualitativeSpeciesgt;</code> must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInitialLevelMustBeInt QualInitialLevelMustBeInt}</td>
<td class='meaning'>Attribute 'initialLevel' on <code>&lt;qualitativeSpeciesgt;</code> must be integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualMaxLevelMustBeInt QualMaxLevelMustBeInt}</td>
<td class='meaning'>Attribute 'maxLevel' on <code>&lt;qualitativeSpeciesgt;</code> must be integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualCompartmentMustReferExisting QualCompartmentMustReferExisting}</td>
<td class='meaning'>Attribute 'compartment' on <code>&lt;qualitativeSpeciesgt;</code> must reference compartment.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInitialLevelCannotExceedMax QualInitialLevelCannotExceedMax}</td>
<td class='meaning'>Attribute 'initialLevel' on <code>&lt;qualitativeSpeciesgt;</code> cannot exceed maxLevel.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualConstantQSCannotBeOutput QualConstantQSCannotBeOutput}</td>
<td class='meaning'>Constant <code>&lt;qualitativeSpeciesgt;</code> cannot be an Output.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualQSAssignedOnlyOnce QualQSAssignedOnlyOnce}</td>
<td class='meaning'>A <code>&lt;qualitativeSpeciesgt;</code> can only be assigned once.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInitalLevelNotNegative QualInitalLevelNotNegative}</td>
<td class='meaning'>Attribute 'initialLevel' on <code>&lt;qualitativeSpeciesgt;</code> cannot be negative.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualMaxLevelNotNegative QualMaxLevelNotNegative}</td>
<td class='meaning'>Attribute 'maxLevel' on <code>&lt;qualitativeSpeciesgt;</code> cannot be negative.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionAllowedCoreAttributes QualTransitionAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;transition&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionAllowedElements QualTransitionAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;transition&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionAllowedAttributes QualTransitionAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;transition&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionNameMustBeString QualTransitionNameMustBeString}</td>
<td class='meaning'>Attribute 'name' on <code>&lt;transition&gt;</code> must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionLOElements QualTransitionLOElements}</td>
<td class='meaning'>ListOf elements on <code>&lt;transition&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionEmptyLOElements QualTransitionEmptyLOElements}</td>
<td class='meaning'>ListOf elements on <code>&lt;transition&gt;</code> not empty.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionLOInputElements QualTransitionLOInputElements}</td>
<td class='meaning'>Elements on <code>&lt;listOfInputs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionLOOutputElements QualTransitionLOOutputElements}</td>
<td class='meaning'>Elements on <code>&lt;listOfOutputs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionLOFuncTermElements QualTransitionLOFuncTermElements}</td>
<td class='meaning'>Elements on <code>&lt;listOfFunctionTerms&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionLOInputAttributes QualTransitionLOInputAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfInputs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionLOOutputAttributes QualTransitionLOOutputAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfOutputs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionLOFuncTermAttributes QualTransitionLOFuncTermAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfFunctionTerms&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionLOFuncTermExceedMax QualTransitionLOFuncTermExceedMax}</td>
<td class='meaning'><code>&lt;listOfFunctionTerms&gt;</code> cannot make qualitativeSpecies exceed maxLevel.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualTransitionLOFuncTermNegative QualTransitionLOFuncTermNegative}</td>
<td class='meaning'><code>&lt;listOfFunctionTerms&gt;</code> cannot make qualitativeSpecies negative.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputAllowedCoreAttributes QualInputAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;input&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputAllowedElements QualInputAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;input&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputAllowedAttributes QualInputAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;input&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputNameMustBeString QualInputNameMustBeString}</td>
<td class='meaning'>Attribute 'name' on <code>&lt;input&gt;</code> must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputSignMustBeSignEnum QualInputSignMustBeSignEnum}</td>
<td class='meaning'>Attribute 'sign' on <code>&lt;input&gt;</code> must be enum.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputTransEffectMustBeInputEffect QualInputTransEffectMustBeInputEffect}</td>
<td class='meaning'>Attribute 'transitionEffect' on <code>&lt;input&gt;</code> must be enum.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputThreshMustBeInteger QualInputThreshMustBeInteger}</td>
<td class='meaning'>Attribute 'thresholdLevel' on <code>&lt;input&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputQSMustBeExistingQS QualInputQSMustBeExistingQS}</td>
<td class='meaning'>Attribute 'qualitativeSpecies' on <code>&lt;input&gt;</code> must refer to existing</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputConstantCannotBeConsumed QualInputConstantCannotBeConsumed}</td>
<td class='meaning'>Constant <code>&lt;input&gt;</code> cannot be consumed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualInputThreshMustBeNonNegative QualInputThreshMustBeNonNegative}</td>
<td class='meaning'>Attribute 'thresholdLevel' on <code>&lt;input&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputAllowedCoreAttributes QualOutputAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;output&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputAllowedElements QualOutputAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;output&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputAllowedAttributes QualOutputAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;output&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputNameMustBeString QualOutputNameMustBeString}</td>
<td class='meaning'>Attribute 'name' on <code>&lt;output&gt;</code> must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputTransEffectMustBeOutput QualOutputTransEffectMustBeOutput}</td>
<td class='meaning'>Attribute 'transitionEffect' on <code>&lt;output&gt;</code> must be enum.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputLevelMustBeInteger QualOutputLevelMustBeInteger}</td>
<td class='meaning'>Attribute 'outputLevel' on <code>&lt;output&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputQSMustBeExistingQS QualOutputQSMustBeExistingQS}</td>
<td class='meaning'>Attribute 'qualitativeSpecies' on <code>&lt;output&gt;</code> must refer to existing</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputConstantMustBeFalse QualOutputConstantMustBeFalse}</td>
<td class='meaning'>Constant 'qualitativeSpecies' cannot be <code>&lt;output&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputProductionMustHaveLevel QualOutputProductionMustHaveLevel}</td>
<td class='meaning'><code>&lt;output&gt;</code> being produced must have level</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualOutputLevelMustBeNonNegative QualOutputLevelMustBeNonNegative}</td>
<td class='meaning'>Attribute 'outputLevel' on <code>&lt;output&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualDefaultTermAllowedCoreAttributes QualDefaultTermAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;defaultTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualDefaultTermAllowedElements QualDefaultTermAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;defaultTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualDefaultTermAllowedAttributes QualDefaultTermAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;defaultTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualDefaultTermResultMustBeInteger QualDefaultTermResultMustBeInteger}</td>
<td class='meaning'>Attribute 'resultLevel' on <code>&lt;defaultTerm&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualDefaultTermResultMustBeNonNeg QualDefaultTermResultMustBeNonNeg}</td>
<td class='meaning'>Attribute 'resultLevel' on <code>&lt;defaultTerm&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualFuncTermAllowedCoreAttributes QualFuncTermAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;functionTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualFuncTermAllowedElements QualFuncTermAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;functionTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualFuncTermAllowedAttributes QualFuncTermAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;functionTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualFuncTermOnlyOneMath QualFuncTermOnlyOneMath}</td>
<td class='meaning'>Only one <code>&lt;math&gt;</code> on <code>&lt;functionTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualFuncTermResultMustBeInteger QualFuncTermResultMustBeInteger}</td>
<td class='meaning'>Attribute 'resultLevel' on <code>&lt;functionTerm&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#QualFuncTermResultMustBeNonNeg QualFuncTermResultMustBeNonNeg}</td>
<td class='meaning'>Attribute 'resultLevel' on <code>&lt;functionTerm&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsUnknown GroupsUnknown}</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsNSUndeclared GroupsNSUndeclared}</td>
<td class='meaning'>The Groups namespace is not correctly declared.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsElementNotInNs GroupsElementNotInNs}</td>
<td class='meaning'>Element not in Groups namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsDuplicateComponentId GroupsDuplicateComponentId}</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsIdSyntaxRule GroupsIdSyntaxRule}</td>
<td class='meaning'>Invalid SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsAttributeRequiredMissing GroupsAttributeRequiredMissing}</td>
<td class='meaning'>Required groups:required attribute on <code>&lt;sbml&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsAttributeRequiredMustBeBoolean GroupsAttributeRequiredMustBeBoolean}</td>
<td class='meaning'>The groups:required attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsAttributeRequiredMustHaveValue GroupsAttributeRequiredMustHaveValue}</td>
<td class='meaning'>The groups:required attribute must be 'false'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsModelAllowedElements GroupsModelAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;model&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsModelEmptyLOElements GroupsModelEmptyLOElements}</td>
<td class='meaning'>No Empty {@link ListOf} elements allowed on <code>&lt;Modelgt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsModelLOGroupsAllowedCoreElements GroupsModelLOGroupsAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;model&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsModelLOGroupsAllowedCoreAttributes GroupsModelLOGroupsAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;model&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupAllowedCoreAttributes GroupsGroupAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;group&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupAllowedCoreElements GroupsGroupAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;group&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupAllowedAttributes GroupsGroupAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;group&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupAllowedElements GroupsGroupAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;group&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupKindMustBeGroupKindEnum GroupsGroupKindMustBeGroupKindEnum}</td>
<td class='meaning'>Kind attribute must be GroupKind.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupNameMustBeString GroupsGroupNameMustBeString}</td>
<td class='meaning'>Name attribute must be String.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupEmptyLOElements GroupsGroupEmptyLOElements}</td>
<td class='meaning'>No Empty {@link ListOf} elements allowed on <code>&lt;group&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupLOMembersAllowedCoreElements GroupsGroupLOMembersAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;listOfMembers&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupLOMembersAllowedCoreAttributes GroupsGroupLOMembersAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;listOfMembers&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsGroupLOMembersAllowedAttributes GroupsGroupLOMembersAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfMembers&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsLOMembersNameMustBeString GroupsLOMembersNameMustBeString}</td>
<td class='meaning'>Name attribute must be String.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsLOMembersConsistentReferences GroupsLOMembersConsistentReferences}</td>
<td class='meaning'>Consistent references by multiple <code>&lt;member&gt;</code> objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsNotCircularReferences GroupsNotCircularReferences}</td>
<td class='meaning'>Circular references by multiple <code>&lt;member&gt;</code> objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsMemberAllowedCoreAttributes GroupsMemberAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;member&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsMemberAllowedCoreElements GroupsMemberAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;member&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsMemberAllowedAttributes GroupsMemberAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;member&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsMemberNameMustBeString GroupsMemberNameMustBeString}</td>
<td class='meaning'>Name attribute must be String.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsMemberIdRefMustBeSBase GroupsMemberIdRefMustBeSBase}</td>
<td class='meaning'>Attribute 'idRef' must point to {@link SBase} object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsMemberMetaIdRefMustBeSBase GroupsMemberMetaIdRefMustBeSBase}</td>
<td class='meaning'>Attribute 'metaIdRef' must point to {@link SBase} object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsMemberIdRefMustBeSId GroupsMemberIdRefMustBeSId}</td>
<td class='meaning'>Attribute 'idRef' must be type 'SId'.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#GroupsMemberMetaIdRefMustBeID GroupsMemberMetaIdRefMustBeID}</td>
<td class='meaning'>Attribute 'metaIdRef' must be type 'ID'.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutUnknownError LayoutUnknownError}</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutNSUndeclared LayoutNSUndeclared}</td>
<td class='meaning'>The layout ns is not correctly declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutElementNotInNs LayoutElementNotInNs}</td>
<td class='meaning'>Element not in layout namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutDuplicateComponentId LayoutDuplicateComponentId}</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSIdSyntax LayoutSIdSyntax}</td>
<td class='meaning'>'id' attribute incorrect syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutXsiTypeAllowedLocations LayoutXsiTypeAllowedLocations}</td>
<td class='meaning'>'xsi:type' allowed locations</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutXsiTypeSyntax LayoutXsiTypeSyntax}</td>
<td class='meaning'>'xsi:type' attribute incorrect syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutAttributeRequiredMissing LayoutAttributeRequiredMissing}</td>
<td class='meaning'>Required layout:required attribute on <code>&lt;sbml&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutAttributeRequiredMustBeBoolean LayoutAttributeRequiredMustBeBoolean}</td>
<td class='meaning'>The layout:required attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRequiredFalse LayoutRequiredFalse}</td>
<td class='meaning'>The layout:required attribute must be 'false'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutOnlyOneLOLayouts LayoutOnlyOneLOLayouts}</td>
<td class='meaning'>Only one listOfLayouts on <code>&lt;model&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOLayoutsNotEmpty LayoutLOLayoutsNotEmpty}</td>
<td class='meaning'>ListOf elements cannot be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOLayoutsAllowedElements LayoutLOLayoutsAllowedElements}</td>
<td class='meaning'>Allowed elements on ListOfLayouts</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOLayoutsAllowedAttributes LayoutLOLayoutsAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on ListOfLayouts</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLayoutAllowedElements LayoutLayoutAllowedElements}</td>
<td class='meaning'>Allowed elements on Layout</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLayoutAllowedCoreAttributes LayoutLayoutAllowedCoreAttributes}</td>
<td class='meaning'>Allowed core attributes on Layout</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutOnlyOneEachListOf LayoutOnlyOneEachListOf}</td>
<td class='meaning'>Only one each listOf on <code>&lt;layout&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutNoEmptyListOfs LayoutNoEmptyListOfs}</td>
<td class='meaning'>ListOf elements cannot be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLayoutAllowedAttributes LayoutLayoutAllowedAttributes}</td>
<td class='meaning'><code>&lt;layout&gt;</code> must have 'id' and may have 'name'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLayoutNameMustBeString LayoutLayoutNameMustBeString}</td>
<td class='meaning'>'name' must be string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOCompGlyphAllowedAttributes LayoutLOCompGlyphAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfCompartmentGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOCompGlyphAllowedElements LayoutLOCompGlyphAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfCompartmentGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOSpeciesGlyphAllowedAttributes LayoutLOSpeciesGlyphAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfSpeciesGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOSpeciesGlyphAllowedElements LayoutLOSpeciesGlyphAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfSpeciesGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLORnGlyphAllowedAttributes LayoutLORnGlyphAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfReactionGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLORnGlyphAllowedElements LayoutLORnGlyphAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfReactionGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOAddGOAllowedAttribut LayoutLOAddGOAllowedAttribut}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfAdditionalGraphicalObjectGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOAddGOAllowedElements LayoutLOAddGOAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfAdditionalGraphicalObjectGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLayoutMustHaveDimensions LayoutLayoutMustHaveDimensions}</td>
<td class='meaning'>Layout must have <code>&lt;dimensions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOTextGlyphAllowedAttributes LayoutLOTextGlyphAllowedAttributes}</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfTextGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOTextGlyphAllowedElements LayoutLOTextGlyphAllowedElements}</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfTextGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGOAllowedCoreElements LayoutGOAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;graphicalObject&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGOAllowedCoreAttributes LayoutGOAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;graphicalObject&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGOAllowedElements LayoutGOAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;graphicalObject&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGOAllowedAttributes LayoutGOAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;graphicalObject&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGOMetaIdRefMustBeIDREF LayoutGOMetaIdRefMustBeIDREF}</td>
<td class='meaning'>Layout 'metaidRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGOMetaIdRefMustReferenceObject LayoutGOMetaIdRefMustReferenceObject}</td>
<td class='meaning'>Layout 'metaidRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGOMustContainBoundingBox LayoutGOMustContainBoundingBox}</td>
<td class='meaning'>A <code>&lt;graphicalObject&gt;</code> must contain a <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGAllowedCoreElements LayoutCGAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;compartmentGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGAllowedCoreAttributes LayoutCGAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;compartmentGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGAllowedElements LayoutCGAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;compartmentGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGAllowedAttributes LayoutCGAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;compartmentGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGMetaIdRefMustBeIDREF LayoutCGMetaIdRefMustBeIDREF}</td>
<td class='meaning'>Layout 'metaidRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGMetaIdRefMustReferenceObject LayoutCGMetaIdRefMustReferenceObject}</td>
<td class='meaning'>Layout 'metaidRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGCompartmentSyntax LayoutCGCompartmentSyntax}</td>
<td class='meaning'>CompartmentGlyph 'compartment' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGCompartmentMustRefComp LayoutCGCompartmentMustRefComp}</td>
<td class='meaning'>CompartmentGlyph compartment must reference existing compartment.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGNoDuplicateReferences LayoutCGNoDuplicateReferences}</td>
<td class='meaning'>CompartmentGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCGOrderMustBeDouble LayoutCGOrderMustBeDouble}</td>
<td class='meaning'>CompartmentGlyph order must be double.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSGAllowedCoreElements LayoutSGAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;speciesGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSGAllowedCoreAttributes LayoutSGAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;speciesGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSGAllowedElements LayoutSGAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;speciesGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSGAllowedAttributes LayoutSGAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;speciesGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSGMetaIdRefMustBeIDREF LayoutSGMetaIdRefMustBeIDREF}</td>
<td class='meaning'>Layout 'metaidRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSGMetaIdRefMustReferenceObject LayoutSGMetaIdRefMustReferenceObject}</td>
<td class='meaning'>Layout 'metaidRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSGSpeciesSyntax LayoutSGSpeciesSyntax}</td>
<td class='meaning'>SpeciesGlyph 'species' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSGSpeciesMustRefSpecies LayoutSGSpeciesMustRefSpecies}</td>
<td class='meaning'>SpeciesGlyph species must reference existing species.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSGNoDuplicateReferences LayoutSGNoDuplicateReferences}</td>
<td class='meaning'>SpeciesGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRGAllowedCoreElements LayoutRGAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;reactionGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRGAllowedCoreAttributes LayoutRGAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;reactionGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRGAllowedElements LayoutRGAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;reactionGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRGAllowedAttributes LayoutRGAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;reactionGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRGMetaIdRefMustBeIDREF LayoutRGMetaIdRefMustBeIDREF}</td>
<td class='meaning'>Layout 'metaidRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRGMetaIdRefMustReferenceObject LayoutRGMetaIdRefMustReferenceObject}</td>
<td class='meaning'>Layout 'metaidRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRGReactionSyntax LayoutRGReactionSyntax}</td>
<td class='meaning'>ReactionGlyph 'reaction' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRGReactionMustRefReaction LayoutRGReactionMustRefReaction}</td>
<td class='meaning'>ReactionGlyph reaction must reference existing reaction.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutRGNoDuplicateReferences LayoutRGNoDuplicateReferences}</td>
<td class='meaning'>ReactionGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOSpeciesRefGlyphAllowedElements LayoutLOSpeciesRefGlyphAllowedElements}</td>
<td class='meaning'>Allowed elements on ListOfSpeciesReferenceGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOSpeciesRefGlyphAllowedAttribs LayoutLOSpeciesRefGlyphAllowedAttribs}</td>
<td class='meaning'>Allowed attributes on ListOfSpeciesReferenceGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOSpeciesRefGlyphNotEmpty LayoutLOSpeciesRefGlyphNotEmpty}</td>
<td class='meaning'>ListOfSpeciesReferenceGlyphs not empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGGAllowedCoreElements LayoutGGAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;generalGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGGAllowedCoreAttributes LayoutGGAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;generalGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGGAllowedElements LayoutGGAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;generalGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGGAllowedAttributes LayoutGGAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;generalGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGGMetaIdRefMustBeIDREF LayoutGGMetaIdRefMustBeIDREF}</td>
<td class='meaning'>Layout 'metaidRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGGMetaIdRefMustReferenceObject LayoutGGMetaIdRefMustReferenceObject}</td>
<td class='meaning'>Layout 'metaidRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGGReferenceSyntax LayoutGGReferenceSyntax}</td>
<td class='meaning'>GeneralGlyph 'reference' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGGReferenceMustRefObject LayoutGGReferenceMustRefObject}</td>
<td class='meaning'>GeneralGlyph 'reference' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutGGNoDuplicateReferences LayoutGGNoDuplicateReferences}</td>
<td class='meaning'>GeneralGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOReferenceGlyphAllowedElements LayoutLOReferenceGlyphAllowedElements}</td>
<td class='meaning'>Allowed elements on ListOfReferenceGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOReferenceGlyphAllowedAttribs LayoutLOReferenceGlyphAllowedAttribs}</td>
<td class='meaning'>Allowed attributes on ListOfReferenceGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOSubGlyphAllowedElements LayoutLOSubGlyphAllowedElements}</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOSubGlyphAllowedAttribs LayoutLOSubGlyphAllowedAttribs}</td>
<td class='meaning'>Allowed attributes on ListOfSubGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGAllowedCoreElements LayoutTGAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;textGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGAllowedCoreAttributes LayoutTGAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;textGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGAllowedElements LayoutTGAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;textGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGAllowedAttributes LayoutTGAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;textGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGMetaIdRefMustBeIDREF LayoutTGMetaIdRefMustBeIDREF}</td>
<td class='meaning'>Layout 'metaidRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGMetaIdRefMustReferenceObject LayoutTGMetaIdRefMustReferenceObject}</td>
<td class='meaning'>Layout 'metaidRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGOriginOfTextSyntax LayoutTGOriginOfTextSyntax}</td>
<td class='meaning'>TextGlyph 'originOfText' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGOriginOfTextMustRefObject LayoutTGOriginOfTextMustRefObject}</td>
<td class='meaning'>TextGlyph 'originOfText' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGNoDuplicateReferences LayoutTGNoDuplicateReferences}</td>
<td class='meaning'>TextGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGGraphicalObjectSyntax LayoutTGGraphicalObjectSyntax}</td>
<td class='meaning'>TextGlyph 'graphicalObject' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGGraphicalObjectMustRefObject LayoutTGGraphicalObjectMustRefObject}</td>
<td class='meaning'>TextGlyph 'graphicalObject' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutTGTextMustBeString LayoutTGTextMustBeString}</td>
<td class='meaning'>TextGlyph 'text' must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGAllowedCoreElements LayoutSRGAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;speciesReferenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGAllowedCoreAttributes LayoutSRGAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;speciesReferenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGAllowedElements LayoutSRGAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;speciesReferenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGAllowedAttributes LayoutSRGAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;speciesReferenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGMetaIdRefMustBeIDREF LayoutSRGMetaIdRefMustBeIDREF}</td>
<td class='meaning'>Layout 'metaidRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGMetaIdRefMustReferenceObject LayoutSRGMetaIdRefMustReferenceObject}</td>
<td class='meaning'>Layout 'metaidRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGSpeciesReferenceSyntax LayoutSRGSpeciesReferenceSyntax}</td>
<td class='meaning'>SpeciesReferenceGlyph 'speciesReference' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGSpeciesRefMustRefObject LayoutSRGSpeciesRefMustRefObject}</td>
<td class='meaning'>SpeciesReferenceGlyph 'speciesReference' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGNoDuplicateReferences LayoutSRGNoDuplicateReferences}</td>
<td class='meaning'>SpeciesReferenceGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGSpeciesGlyphSyntax LayoutSRGSpeciesGlyphSyntax}</td>
<td class='meaning'>SpeciesReferenceGlyph 'speciesGlyph' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGSpeciesGlyphMustRefObject LayoutSRGSpeciesGlyphMustRefObject}</td>
<td class='meaning'>SpeciesReferenceGlyph 'speciesGlyph' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutSRGRoleSyntax LayoutSRGRoleSyntax}</td>
<td class='meaning'>SpeciesReferenceGlyph 'role' must be string from enumeration.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGAllowedCoreElements LayoutREFGAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;referenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGAllowedCoreAttributes LayoutREFGAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;referenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGAllowedElements LayoutREFGAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;referenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGAllowedAttributes LayoutREFGAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;referenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGMetaIdRefMustBeIDREF LayoutREFGMetaIdRefMustBeIDREF}</td>
<td class='meaning'>Layout 'metaidRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGMetaIdRefMustReferenceObject LayoutREFGMetaIdRefMustReferenceObject}</td>
<td class='meaning'>Layout 'metaidRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGReferenceSyntax LayoutREFGReferenceSyntax}</td>
<td class='meaning'>ReferenceGlyph 'reference' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGReferenceMustRefObject LayoutREFGReferenceMustRefObject}</td>
<td class='meaning'>ReferenceGlyph 'reference' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGNoDuplicateReferences LayoutREFGNoDuplicateReferences}</td>
<td class='meaning'>ReferenceGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGGlyphSyntax LayoutREFGGlyphSyntax}</td>
<td class='meaning'>ReferenceGlyph 'glyph' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGGlyphMustRefObject LayoutREFGGlyphMustRefObject}</td>
<td class='meaning'>ReferenceGlyph 'glyph' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutREFGRoleSyntax LayoutREFGRoleSyntax}</td>
<td class='meaning'>ReferenceGlyph 'role' must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutPointAllowedCoreElements LayoutPointAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;point&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutPointAllowedCoreAttributes LayoutPointAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;point&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutPointAllowedAttributes LayoutPointAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;point&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutPointAttributesMustBeDouble LayoutPointAttributesMustBeDouble}</td>
<td class='meaning'>Layout 'x', 'y' and 'z' must be double.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutBBoxAllowedCoreElements LayoutBBoxAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutBBoxAllowedCoreAttributes LayoutBBoxAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutBBoxAllowedElements LayoutBBoxAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutBBoxAllowedAttributes LayoutBBoxAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutBBoxConsistent3DDefinition LayoutBBoxConsistent3DDefinition}</td>
<td class='meaning'>Layout consistent dimensions on a <code>&lt;boundingBox&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCurveAllowedCoreElements LayoutCurveAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;curve&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCurveAllowedCoreAttributes LayoutCurveAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;curve&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCurveAllowedElements LayoutCurveAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;curve&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCurveAllowedAttributes LayoutCurveAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;curve&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOCurveSegsAllowedAttributes LayoutLOCurveSegsAllowedAttributes}</td>
<td class='meaning'>Allowed attributes on ListOfCurveSegments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOCurveSegsAllowedElements LayoutLOCurveSegsAllowedElements}</td>
<td class='meaning'>Allowed elements on ListOfCurveSegments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLOCurveSegsNotEmpty LayoutLOCurveSegsNotEmpty}</td>
<td class='meaning'>No empty ListOfCurveSegments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLSegAllowedCoreElements LayoutLSegAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;lineSegment&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLSegAllowedCoreAttributes LayoutLSegAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;lineSegment&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLSegAllowedElements LayoutLSegAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;lineSegment&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutLSegAllowedAttributes LayoutLSegAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;lineSegment&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCBezAllowedCoreElements LayoutCBezAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;cubicBezier&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCBezAllowedCoreAttributes LayoutCBezAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;cubicBezier&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCBezAllowedElements LayoutCBezAllowedElements}</td>
<td class='meaning'>Layout elements allowed on <code>&lt;cubicBezier&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutCBezAllowedAttributes LayoutCBezAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;cubicBezier&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutDimsAllowedCoreElements LayoutDimsAllowedCoreElements}</td>
<td class='meaning'>Core elements allowed on <code>&lt;dimensions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutDimsAllowedCoreAttributes LayoutDimsAllowedCoreAttributes}</td>
<td class='meaning'>Core attributes allowed on <code>&lt;dimensions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutDimsAllowedAttributes LayoutDimsAllowedAttributes}</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;dimensions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>{@link libsbmlConstants#LayoutDimsAttributesMustBeDouble LayoutDimsAttributesMustBeDouble}</td>
<td class='meaning'>Layout 'width', 'height' and 'depth' must be double.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
</table>
 <p>
 * <h3><a class='anchor'
 * name='SBMLErrorCategory_t'>Category codes associated with {@link SBMLError} objects</a></h3>
 <p>
 * As discussed above, each {@link SBMLError} object contains a value for a
 * category identifier, describing the type of issue that the {@link SBMLError}
 * object represents.  The category can be retrieved from an {@link SBMLError}
 * object using the method {@link SBMLError#getCategory()}.  The following table
 * lists each possible value and a brief description of its meaning.
 <p>
 * As is the case with the error codes, in the libSBML Java language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface class
 * {@link libsbmlConstants}.
 <p>
 * The following table lists each possible value and a brief description of
 * its meaning.
 <p>
 * <center>
 * <table width='90%' cellspacing='1' cellpadding='4' border='0'  class='text-table normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th>Enumerator</td>
 *      <th>Meaning</td>
 *  </tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_SBML LIBSBML_CAT_SBML}</td><td>General error not falling into
 * another category below.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_SBML_L1_COMPAT LIBSBML_CAT_SBML_L1_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model from SBML Level&nbsp;2 to SBML
 * Level&nbsp;1.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_SBML_L2V1_COMPAT LIBSBML_CAT_SBML_L2V1_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;1.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_SBML_L2V2_COMPAT LIBSBML_CAT_SBML_L2V2_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;2.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_GENERAL_CONSISTENCY LIBSBML_CAT_GENERAL_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating general SBML constructs.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 2xxxx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating symbol identifiers in a model.
 * With respect to the SBML specification, these concern failures in
 * applying the validation rules numbered 103xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating the units of measurement on
 * quantities in a model.  With respect to the SBML specification, these
 * concern failures in applying the validation rules numbered 105xx in the
 * Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating MathML formulas in a model.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 102xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_SBO_CONSISTENCY LIBSBML_CAT_SBO_CONSISTENCY}</td><td>Category of errors
 * that can occur while validating {@link SBO} identifiers in a model.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 107xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_OVERDETERMINED_MODEL LIBSBML_CAT_OVERDETERMINED_MODEL}</td><td>Error in the
 * system of equations in the model: the system is overdetermined,
 * therefore violating a tenet of proper SBML.  With respect to the SBML
 * specification, this is validation rule #10601 in the SBML Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_SBML_L2V3_COMPAT LIBSBML_CAT_SBML_L2V3_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;3.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_MODELING_PRACTICE LIBSBML_CAT_MODELING_PRACTICE}</td><td>Category of
 * warnings about recommended good practices involving SBML and
 * computational modeling.  (These are tests performed by libSBML and do
 * not have equivalent SBML validation rules.)</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_INTERNAL_CONSISTENCY LIBSBML_CAT_INTERNAL_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating libSBML's internal representation
 * of SBML constructs. (These are tests performed by libSBML and do
 * not have equivalent SBML validation rules.)</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_SBML_L2V4_COMPAT LIBSBML_CAT_SBML_L2V4_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;4.</td></tr>
 * <tr><td>{@link libsbmlConstants#LIBSBML_CAT_SBML_L3V1_COMPAT LIBSBML_CAT_SBML_L3V1_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;3
 * Version&nbsp;1.</td></tr>
 <p>
 * </table>
 * </center>
 <p>
 * <h3><a class='anchor'
 * name='SBMLErrorSeverity_t'>Severity codes associated with {@link SBMLError}
 * objects</h3>
 <p>
 * In libSBML version 5.18.0
 * there are no additional severity codes beyond those defined by {@link XMLError}.
 * They are implemented as static integer constants defined in the interface
 * class <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>,
 * and have names beginning with <code>LIBSBML_SEV_</code>.
 */

public class SBMLError extends XMLError {
   private long swigCPtr;

   protected SBMLError(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SBMLError_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SBMLError obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLError obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLError(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column, long severity, long category, String arg8, long pkgVersion) {
    this(libsbmlJNI.new_SBMLError__SWIG_0(errorId, level, version, details, line, column, severity, category, arg8, pkgVersion), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column, long severity, long category, String arg8) {
    this(libsbmlJNI.new_SBMLError__SWIG_1(errorId, level, version, details, line, column, severity, category, arg8), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column, long severity, long category) {
    this(libsbmlJNI.new_SBMLError__SWIG_2(errorId, level, version, details, line, column, severity, category), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column, long severity) {
    this(libsbmlJNI.new_SBMLError__SWIG_3(errorId, level, version, details, line, column, severity), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column) {
    this(libsbmlJNI.new_SBMLError__SWIG_4(errorId, level, version, details, line, column), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line) {
    this(libsbmlJNI.new_SBMLError__SWIG_5(errorId, level, version, details, line), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details) {
    this(libsbmlJNI.new_SBMLError__SWIG_6(errorId, level, version, details), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version) {
    this(libsbmlJNI.new_SBMLError__SWIG_7(errorId, level, version), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level) {
    this(libsbmlJNI.new_SBMLError__SWIG_8(errorId, level), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId) {
    this(libsbmlJNI.new_SBMLError__SWIG_9(errorId), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model.
   <p>
   * @param version the SBML Version within the Level of the SBML model.
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError() {
    this(libsbmlJNI.new_SBMLError__SWIG_10(), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link SBMLError}.
   <p>
   * @param orig the instance to copy.
   */ public
 SBMLError(SBMLError orig) {
    this(libsbmlJNI.new_SBMLError__SWIG_11(SBMLError.getCPtr(orig), orig), true);
  }

}
