/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::DSMCBaseCloud

Description
    Virtual abstract base class for templated DSMCCloud

SourceFiles
    DSMCBaseCloud.C

\*---------------------------------------------------------------------------*/

#ifndef DSMCBaseCloud_H
#define DSMCBaseCloud_H

#include "volFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                       Class DSMCBaseCloud Declaration
\*---------------------------------------------------------------------------*/

class DSMCBaseCloud
{
    // Private Member Functions

        //- No copy construct
        DSMCBaseCloud(const DSMCBaseCloud&) = delete;

        //- No copy assignment
        void operator=(const DSMCBaseCloud&) = delete;


public:

    //- Runtime type information
    TypeName("DSMCBaseCloud");

    // Constructors

        //- Null constructor
        DSMCBaseCloud();

    //- Destructor
    virtual ~DSMCBaseCloud();
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
