<?php

declare(strict_types = 1);

use \PHPUnit\Framework\TestCase;

class SpycTest extends TestCase
{
    public function testDumpLoad(): void
    {
        $data = [
            'foo' => 'bar',
            'bar' => [
                'option1',
                'option2'
            ]
        ];

        $yaml = Spyc::YAMLDump($data, 4, 60);
        $loadedData = Spyc::YAMLLoadString($yaml);
        $this->assertSame($data, $loadedData);
    }
}
