;-------------------------------------------------------------------------------
; The GIMP -- an image manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
;-------------------------------------------------------------------------------
; pysycache-puzzle-mask.scm : a script for make jigsaw pieces from a model
; Copyright (C) 2006 Vincent DEROO (vincent.pysycache@free.fr)
;-------------------------------------------------------------------------------
;
;
; This program is free software; you can redistribute it and/or 
; modify it under the terms of the GNU General Public License 
; as published by the Free Software Foundation; either version 2 
; of the License, or (at your option) any later version. 
; 
; This program is distributed in the hope that it will be useful, 
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details. 
; 
; You should have received a copy of the GNU General Public License 
; along with this program; if not, write to the Free Software 
; Foundation, Inc. : 
; 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
;-------------------------------------------------------------------------------


       
;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
(define (script-fu-pysycache-make-piece2
	img
	draw
	x
	y
	filesvg
	)

	(let*	(
			;recuperation de la taille de l'image originale
			(ImgWidth (car (gimp-image-width img)))
			(ImgHeight (car (gimp-image-height img)))

			;copie de l'image
			(MyImg (car (gimp-image-duplicate img)))
			(MyDraw (car (gimp-image-get-active-drawable MyImg)))

			;image transparent
			(MyImgResult (car (gimp-image-new ImgWidth ImgHeight RGB)))
			(MyLayResult (car (gimp-layer-new MyImgResult ImgWidth ImgHeight RGB-IMAGE "ResultLayer" 0 NORMAL-MODE)))
			(MyDrawResult )
			
			(LayPiece )
			(nvodraw )
			(LayPieceNvo )
			(displayResult )
			(LayPieceFinal )
			(drawfinal )
			(lb )
		)

		;image qui recevra le resultat du copier/coller
		(gimp-image-add-layer MyImgResult MyLayResult -1)
		(set! MyDrawResult (car (gimp-image-get-active-drawable MyImgResult)))
		(gimp-drawable-fill MyDrawResult 3)

		;selectionner la piece
		(gimp-fuzzy-select MyDraw x y 15 0 FALSE FALSE 0 FALSE)
		
		;inverser la selection
		(gimp-selection-invert MyImg)
		
		;colorier
		(gimp-drawable-fill MyDraw 0)
		
		;tout selectionner
		(gimp-edit-copy MyDraw)

		;copier
		(set! nvodraw (car (gimp-image-get-active-drawable MyImg)))
		(gimp-edit-copy nvodraw)
 
 		;coller en tant que nouveau		
		(set! LayPieceNvo (car (gimp-edit-paste MyDrawResult 0) ))	
		(gimp-floating-sel-to-layer LayPieceNvo)

		(set! nvodraw3 (car (gimp-image-get-active-drawable MyImgResult)))
		(gimp-edit-copy nvodraw3)

		(set! displayResult (car (gimp-display-new MyImgResult)))
  
		(gimp-file-save RUN-NONINTERACTIVE MyImgResult nvodraw3 filesvg filesvg)
	
		(gimp-display-delete displayResult)
		(gimp-image-delete MyImg)
	)
)


(define (script-fu-pysycache-build-pieces-jigsaw
	img
	draw
	dirjigsaw
	bgkcolor
	nbcol
	nbrow
	)
	
	
	(gimp-context-set-foreground bgkcolor)

	(let*	(
			;recuperation de la taille de l'image originale
			(ImgWidth (car (gimp-image-width img)))
			(ImgHeight (car (gimp-image-height img)))
			(nbx (/ ImgWidth nbcol))
			(nbx2 (/ nbx 2))
			(nby (/ ImgHeight nbrow))
			(nby2 (/ nby 2))
			)
		
		
		(set! x 0)
		(while (< x nbcol)
			(set! y 0)
			
			(while (< y nbrow)
			
				;si unix
;				(set! filesvg (string-append dirjigsaw "/" "0" (number->string (+ y 1) ) "-0" (number->string (+ x 1) ) ".png" )   )
				;si windows
				(set! filesvg (string-append dirjigsaw "\\" "0" (number->string (+ y 1) ) "-0" (number->string (+ x 1) ) ".png" )   )
				(script-fu-pysycache-make-piece2 img draw (+ nbx2 (* x nbx)) (+ nby2 (* y nby)) filesvg )

				(set! y (+ y 1))
			)
			
			(set! x (+ x 1))
		)
	)
	(gimp-message "Pieces have been made" )
)





;-------------------------------------------------------------------------------
; Register in the Gimp menus
;-------------------------------------------------------------------------------
(script-fu-register "script-fu-pysycache-build-pieces-jigsaw"
		    _"<Image>/Script-Fu/Pysycache/Theme Jigsaw - Sharp pieces..."
		    "Make jigsaw pieces from a model for the Jigsaw activity "
		    "Vincent DEROO (contact.pysycache@free.fr)"
		    "Vincent DEROO"
		    "30/06/2006 - v 0.9"
		    "RGB GRAY RGBA GRAYA"
			
		    
		    SF-IMAGE "Image" 0
		    SF-DRAWABLE "Drawable" 0

		    SF-DIRNAME "Jigsaw directory" (string-append "" gimp-directory "/scripts/Elements-For-Themes/themes-jigsaw/3x3/modele1/")
			SF-COLOR "Color of the background" '(30 30 30)
    
			SF-ADJUSTMENT "Column number" '(2 0 100 1 10 0 1)
			SF-ADJUSTMENT "Row number" '(2 0 100 1 10 0 1)
			
            
            )
