# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterInformationProtectionPoliciesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_information_protection_policies_get(self, resource_group):
        response = self.client.information_protection_policies.get(
            scope="str",
            information_protection_policy_name="str",
            api_version="2017-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_information_protection_policies_create_or_update(self, resource_group):
        response = self.client.information_protection_policies.create_or_update(
            scope="str",
            information_protection_policy_name="str",
            information_protection_policy={
                "id": "str",
                "informationTypes": {
                    "str": {
                        "custom": bool,
                        "description": "str",
                        "displayName": "str",
                        "enabled": bool,
                        "keywords": [{"canBeNumeric": bool, "custom": bool, "excluded": bool, "pattern": "str"}],
                        "order": 0,
                        "recommendedLabelId": "str",
                    }
                },
                "labels": {
                    "str": {"description": "str", "displayName": "str", "enabled": bool, "order": 0, "rank": "str"}
                },
                "lastModifiedUtc": "2020-02-20 00:00:00",
                "name": "str",
                "type": "str",
                "version": "str",
            },
            api_version="2017-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_information_protection_policies_list(self, resource_group):
        response = self.client.information_protection_policies.list(
            scope="str",
            api_version="2017-08-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
