// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/vertex_rag_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A query to retrieve relevant contexts.
type RagQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The query to retrieve contexts.
	// Currently only text query is supported.
	//
	// Types that are assignable to Query:
	//
	//	*RagQuery_Text
	Query isRagQuery_Query `protobuf_oneof:"query"`
	// Optional. The number of contexts to retrieve.
	SimilarityTopK int32 `protobuf:"varint,2,opt,name=similarity_top_k,json=similarityTopK,proto3" json:"similarity_top_k,omitempty"`
}

func (x *RagQuery) Reset() {
	*x = RagQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RagQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagQuery) ProtoMessage() {}

func (x *RagQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagQuery.ProtoReflect.Descriptor instead.
func (*RagQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescGZIP(), []int{0}
}

func (m *RagQuery) GetQuery() isRagQuery_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *RagQuery) GetText() string {
	if x, ok := x.GetQuery().(*RagQuery_Text); ok {
		return x.Text
	}
	return ""
}

func (x *RagQuery) GetSimilarityTopK() int32 {
	if x != nil {
		return x.SimilarityTopK
	}
	return 0
}

type isRagQuery_Query interface {
	isRagQuery_Query()
}

type RagQuery_Text struct {
	// Optional. The query in text format to get relevant contexts.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

func (*RagQuery_Text) isRagQuery_Query() {}

// Request message for
// [VertexRagService.RetrieveContexts][google.cloud.aiplatform.v1beta1.VertexRagService.RetrieveContexts].
type RetrieveContextsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data Source to retrieve contexts.
	//
	// Types that are assignable to DataSource:
	//
	//	*RetrieveContextsRequest_VertexRagStore_
	DataSource isRetrieveContextsRequest_DataSource `protobuf_oneof:"data_source"`
	// Required. The resource name of the Location from which to retrieve
	// RagContexts. The users must have permission to make a call in the project.
	// Format:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Single RAG retrieve query.
	Query *RagQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *RetrieveContextsRequest) Reset() {
	*x = RetrieveContextsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveContextsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveContextsRequest) ProtoMessage() {}

func (x *RetrieveContextsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveContextsRequest.ProtoReflect.Descriptor instead.
func (*RetrieveContextsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescGZIP(), []int{1}
}

func (m *RetrieveContextsRequest) GetDataSource() isRetrieveContextsRequest_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (x *RetrieveContextsRequest) GetVertexRagStore() *RetrieveContextsRequest_VertexRagStore {
	if x, ok := x.GetDataSource().(*RetrieveContextsRequest_VertexRagStore_); ok {
		return x.VertexRagStore
	}
	return nil
}

func (x *RetrieveContextsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *RetrieveContextsRequest) GetQuery() *RagQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

type isRetrieveContextsRequest_DataSource interface {
	isRetrieveContextsRequest_DataSource()
}

type RetrieveContextsRequest_VertexRagStore_ struct {
	// The data source for Vertex RagStore.
	VertexRagStore *RetrieveContextsRequest_VertexRagStore `protobuf:"bytes,2,opt,name=vertex_rag_store,json=vertexRagStore,proto3,oneof"`
}

func (*RetrieveContextsRequest_VertexRagStore_) isRetrieveContextsRequest_DataSource() {}

// Relevant contexts for one query.
type RagContexts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All its contexts.
	Contexts []*RagContexts_Context `protobuf:"bytes,1,rep,name=contexts,proto3" json:"contexts,omitempty"`
}

func (x *RagContexts) Reset() {
	*x = RagContexts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RagContexts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagContexts) ProtoMessage() {}

func (x *RagContexts) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagContexts.ProtoReflect.Descriptor instead.
func (*RagContexts) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescGZIP(), []int{2}
}

func (x *RagContexts) GetContexts() []*RagContexts_Context {
	if x != nil {
		return x.Contexts
	}
	return nil
}

// Response message for
// [VertexRagService.RetrieveContexts][google.cloud.aiplatform.v1beta1.VertexRagService.RetrieveContexts].
type RetrieveContextsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The contexts of the query.
	Contexts *RagContexts `protobuf:"bytes,1,opt,name=contexts,proto3" json:"contexts,omitempty"`
}

func (x *RetrieveContextsResponse) Reset() {
	*x = RetrieveContextsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveContextsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveContextsResponse) ProtoMessage() {}

func (x *RetrieveContextsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveContextsResponse.ProtoReflect.Descriptor instead.
func (*RetrieveContextsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescGZIP(), []int{3}
}

func (x *RetrieveContextsResponse) GetContexts() *RagContexts {
	if x != nil {
		return x.Contexts
	}
	return nil
}

// The data source for Vertex RagStore.
type RetrieveContextsRequest_VertexRagStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Deprecated. Please use rag_resources to specify the data
	// source.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_service.proto.
	RagCorpora []string `protobuf:"bytes,1,rep,name=rag_corpora,json=ragCorpora,proto3" json:"rag_corpora,omitempty"`
	// Optional. The representation of the rag source. It can be used to specify
	// corpus only or ragfiles. Currently only support one corpus or multiple
	// files from one corpus. In the future we may open up multiple corpora
	// support.
	RagResources []*RetrieveContextsRequest_VertexRagStore_RagResource `protobuf:"bytes,3,rep,name=rag_resources,json=ragResources,proto3" json:"rag_resources,omitempty"`
	// Optional. Only return contexts with vector distance smaller than the
	// threshold.
	VectorDistanceThreshold *float64 `protobuf:"fixed64,2,opt,name=vector_distance_threshold,json=vectorDistanceThreshold,proto3,oneof" json:"vector_distance_threshold,omitempty"`
}

func (x *RetrieveContextsRequest_VertexRagStore) Reset() {
	*x = RetrieveContextsRequest_VertexRagStore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveContextsRequest_VertexRagStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveContextsRequest_VertexRagStore) ProtoMessage() {}

func (x *RetrieveContextsRequest_VertexRagStore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveContextsRequest_VertexRagStore.ProtoReflect.Descriptor instead.
func (*RetrieveContextsRequest_VertexRagStore) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescGZIP(), []int{1, 0}
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_service.proto.
func (x *RetrieveContextsRequest_VertexRagStore) GetRagCorpora() []string {
	if x != nil {
		return x.RagCorpora
	}
	return nil
}

func (x *RetrieveContextsRequest_VertexRagStore) GetRagResources() []*RetrieveContextsRequest_VertexRagStore_RagResource {
	if x != nil {
		return x.RagResources
	}
	return nil
}

func (x *RetrieveContextsRequest_VertexRagStore) GetVectorDistanceThreshold() float64 {
	if x != nil && x.VectorDistanceThreshold != nil {
		return *x.VectorDistanceThreshold
	}
	return 0
}

// The definition of the Rag resource.
type RetrieveContextsRequest_VertexRagStore_RagResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. RagCorpora resource name.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	RagCorpus string `protobuf:"bytes,1,opt,name=rag_corpus,json=ragCorpus,proto3" json:"rag_corpus,omitempty"`
	// Optional. rag_file_id. The files should be in the same rag_corpus set
	// in rag_corpus field.
	RagFileIds []string `protobuf:"bytes,2,rep,name=rag_file_ids,json=ragFileIds,proto3" json:"rag_file_ids,omitempty"`
}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) Reset() {
	*x = RetrieveContextsRequest_VertexRagStore_RagResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveContextsRequest_VertexRagStore_RagResource) ProtoMessage() {}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveContextsRequest_VertexRagStore_RagResource.ProtoReflect.Descriptor instead.
func (*RetrieveContextsRequest_VertexRagStore_RagResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) GetRagCorpus() string {
	if x != nil {
		return x.RagCorpus
	}
	return ""
}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) GetRagFileIds() []string {
	if x != nil {
		return x.RagFileIds
	}
	return nil
}

// A context of the query.
type RagContexts_Context struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For vertex RagStore, if the file is imported from Cloud Storage or Google
	// Drive, source_uri will be original file URI in Cloud Storage or Google
	// Drive; if file is uploaded, source_uri will be file display name.
	SourceUri string `protobuf:"bytes,1,opt,name=source_uri,json=sourceUri,proto3" json:"source_uri,omitempty"`
	// The text chunk.
	Text string `protobuf:"bytes,2,opt,name=text,proto3" json:"text,omitempty"`
	// The distance between the query vector and the context text vector.
	Distance float64 `protobuf:"fixed64,3,opt,name=distance,proto3" json:"distance,omitempty"`
}

func (x *RagContexts_Context) Reset() {
	*x = RagContexts_Context{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RagContexts_Context) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagContexts_Context) ProtoMessage() {}

func (x *RagContexts_Context) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagContexts_Context.ProtoReflect.Descriptor instead.
func (*RagContexts_Context) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescGZIP(), []int{2, 0}
}

func (x *RagContexts_Context) GetSourceUri() string {
	if x != nil {
		return x.SourceUri
	}
	return ""
}

func (x *RagContexts_Context) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *RagContexts_Context) GetDistance() float64 {
	if x != nil {
		return x.Distance
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5d,
	0x0a, 0x08, 0x52, 0x61, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79,
	0x54, 0x6f, 0x70, 0x4b, 0x42, 0x07, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0xc7, 0x05,
	0x0a, 0x17, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x73, 0x0a, 0x10, 0x76, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x48, 0x00, 0x52, 0x0e,
	0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x44, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x1a, 0x9e, 0x03, 0x0a, 0x0e, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x26, 0x0a, 0x0b, 0x72, 0x61,
	0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x0a, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x12, 0x7d, 0x0a, 0x0d, 0x72, 0x61, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x52, 0x61, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x61, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x44, 0x0a, 0x19, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x17, 0x76, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x88, 0x01, 0x01, 0x1a, 0x80, 0x01, 0x0a, 0x0b, 0x52, 0x61, 0x67, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x72, 0x61, 0x67, 0x5f, 0x63,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x09, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x0c, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x76,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xb9, 0x01, 0x0a, 0x0b, 0x52, 0x61, 0x67, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x1a, 0x58, 0x0a, 0x07, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x55, 0x72, 0x69, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x22, 0x64, 0x0a, 0x18, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x48, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52,
	0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x32, 0xc0, 0x02, 0x0a, 0x10, 0x56, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xdc,
	0x01, 0x0a, 0x10, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a,
	0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x1a, 0x4d, 0xca,
	0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xec, 0x01, 0x0a,
	0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x42, 0x15, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42,
	0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_goTypes = []interface{}{
	(*RagQuery)(nil),                                           // 0: google.cloud.aiplatform.v1beta1.RagQuery
	(*RetrieveContextsRequest)(nil),                            // 1: google.cloud.aiplatform.v1beta1.RetrieveContextsRequest
	(*RagContexts)(nil),                                        // 2: google.cloud.aiplatform.v1beta1.RagContexts
	(*RetrieveContextsResponse)(nil),                           // 3: google.cloud.aiplatform.v1beta1.RetrieveContextsResponse
	(*RetrieveContextsRequest_VertexRagStore)(nil),             // 4: google.cloud.aiplatform.v1beta1.RetrieveContextsRequest.VertexRagStore
	(*RetrieveContextsRequest_VertexRagStore_RagResource)(nil), // 5: google.cloud.aiplatform.v1beta1.RetrieveContextsRequest.VertexRagStore.RagResource
	(*RagContexts_Context)(nil),                                // 6: google.cloud.aiplatform.v1beta1.RagContexts.Context
}
var file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_depIdxs = []int32{
	4, // 0: google.cloud.aiplatform.v1beta1.RetrieveContextsRequest.vertex_rag_store:type_name -> google.cloud.aiplatform.v1beta1.RetrieveContextsRequest.VertexRagStore
	0, // 1: google.cloud.aiplatform.v1beta1.RetrieveContextsRequest.query:type_name -> google.cloud.aiplatform.v1beta1.RagQuery
	6, // 2: google.cloud.aiplatform.v1beta1.RagContexts.contexts:type_name -> google.cloud.aiplatform.v1beta1.RagContexts.Context
	2, // 3: google.cloud.aiplatform.v1beta1.RetrieveContextsResponse.contexts:type_name -> google.cloud.aiplatform.v1beta1.RagContexts
	5, // 4: google.cloud.aiplatform.v1beta1.RetrieveContextsRequest.VertexRagStore.rag_resources:type_name -> google.cloud.aiplatform.v1beta1.RetrieveContextsRequest.VertexRagStore.RagResource
	1, // 5: google.cloud.aiplatform.v1beta1.VertexRagService.RetrieveContexts:input_type -> google.cloud.aiplatform.v1beta1.RetrieveContextsRequest
	3, // 6: google.cloud.aiplatform.v1beta1.VertexRagService.RetrieveContexts:output_type -> google.cloud.aiplatform.v1beta1.RetrieveContextsResponse
	6, // [6:7] is the sub-list for method output_type
	5, // [5:6] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RagQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveContextsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RagContexts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveContextsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveContextsRequest_VertexRagStore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveContextsRequest_VertexRagStore_RagResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RagContexts_Context); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*RagQuery_Text)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*RetrieveContextsRequest_VertexRagStore_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes[4].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_vertex_rag_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VertexRagServiceClient is the client API for VertexRagService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VertexRagServiceClient interface {
	// Retrieves relevant contexts for a query.
	RetrieveContexts(ctx context.Context, in *RetrieveContextsRequest, opts ...grpc.CallOption) (*RetrieveContextsResponse, error)
}

type vertexRagServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVertexRagServiceClient(cc grpc.ClientConnInterface) VertexRagServiceClient {
	return &vertexRagServiceClient{cc}
}

func (c *vertexRagServiceClient) RetrieveContexts(ctx context.Context, in *RetrieveContextsRequest, opts ...grpc.CallOption) (*RetrieveContextsResponse, error) {
	out := new(RetrieveContextsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagService/RetrieveContexts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VertexRagServiceServer is the server API for VertexRagService service.
type VertexRagServiceServer interface {
	// Retrieves relevant contexts for a query.
	RetrieveContexts(context.Context, *RetrieveContextsRequest) (*RetrieveContextsResponse, error)
}

// UnimplementedVertexRagServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVertexRagServiceServer struct {
}

func (*UnimplementedVertexRagServiceServer) RetrieveContexts(context.Context, *RetrieveContextsRequest) (*RetrieveContextsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveContexts not implemented")
}

func RegisterVertexRagServiceServer(s *grpc.Server, srv VertexRagServiceServer) {
	s.RegisterService(&_VertexRagService_serviceDesc, srv)
}

func _VertexRagService_RetrieveContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagServiceServer).RetrieveContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagService/RetrieveContexts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagServiceServer).RetrieveContexts(ctx, req.(*RetrieveContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VertexRagService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.VertexRagService",
	HandlerType: (*VertexRagServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RetrieveContexts",
			Handler:    _VertexRagService_RetrieveContexts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/vertex_rag_service.proto",
}
