/**
 * \file pappsomspp/processing/cbor/psm/psmcborutils.h
 * \date 16/09/2025
 * \author Olivier Langella
 * \brief PSM CBOR utilities
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once

#include <QCborMap>
#include "pappsomspp/core/massspectrum/qualifiedmassspectrum.h"
#include "pappsomspp/export-import-config.h"

namespace pappso
{
namespace cbor
{
namespace psm
{
/**
 * @brief utilities to help managing data in PSM CBOR data file
 */
class PMSPP_LIB_DECL PsmCborUtils
{
  public:
  struct PsmProteinRef
  {
    QString accession;
    std::vector<std::size_t> positions;
  };


  static void
  prepareCborScanWithSpectrum(QCborMap &cbor_scan,
                              const pappso::QualifiedMassSpectrum &ms2_qualified_mass_spectrum);

  static void prepareCborScanWithSpectrumAndPeakList(
    QCborMap &cbor_scan, const pappso::QualifiedMassSpectrum &ms2_qualified_mass_spectrum);


  static std::vector<PsmProteinRef> getPsmProteinRefList(const QCborMap &cbor_psm);
  static void setPsmProteinRefList(QCborMap &cbor_psm,
                                   const std::vector<PsmProteinRef> &protein_ref_list);

  static void mergePsmProteinRefList(QCborMap &cbor_psm_destination,
                                     const QCborMap &cbor_psm_source);
};

} // namespace psm
} // namespace cbor
} // namespace pappso
