/**
 * Loader generated by glad 2.0.0-beta on Sun Jun 26 11:35:02 2022
 *
 * Generator: C/C++
 * Specification: egl
 * Extensions: 5
 *
 * APIs:
 *  - egl=1.5
 *
 * Options:
 *  - ALIAS = True
 *  - DEBUG = False
 *  - HEADER_ONLY = True
 *  - LOADER = True
 *  - MX = False
 *  - MX_GLOBAL = False
 *  - ON_DEMAND = False
 *
 * Commandline:
 *    --api='egl=1.5' --extensions='EGL_KHR_cl_event2,EGL_KHR_fence_sync,EGL_KHR_image,EGL_KHR_image_base,EGL_KHR_reusable_sync' c --alias --header-only --loader
 *
 * Online:
 *    http://glad.sh/#api=egl%3D1.5&extensions=EGL_KHR_cl_event2%2CEGL_KHR_fence_sync%2CEGL_KHR_image%2CEGL_KHR_image_base%2CEGL_KHR_reusable_sync&generator=c&options=ALIAS%2CHEADER_ONLY%2CLOADER
 *
 */

#ifndef SF_GLAD_EGL_H_
#define SF_GLAD_EGL_H_


#define SF_GLAD_EGL
#define GLAD_OPTION_EGL_ALIAS
#define GLAD_OPTION_EGL_HEADER_ONLY
#define GLAD_OPTION_EGL_LOADER

#ifdef __cplusplus
extern "C" {
#endif

#ifndef GLAD_PLATFORM_H_
#define GLAD_PLATFORM_H_

#ifndef GLAD_PLATFORM_WIN32
  #if defined(_WIN32) || defined(__WIN32__) || defined(WIN32) || defined(__MINGW32__)
    #define GLAD_PLATFORM_WIN32 1
  #else
    #define GLAD_PLATFORM_WIN32 0
  #endif
#endif

#ifndef GLAD_PLATFORM_APPLE
  #ifdef __APPLE__
    #define GLAD_PLATFORM_APPLE 1
  #else
    #define GLAD_PLATFORM_APPLE 0
  #endif
#endif

#ifndef GLAD_PLATFORM_EMSCRIPTEN
  #ifdef __EMSCRIPTEN__
    #define GLAD_PLATFORM_EMSCRIPTEN 1
  #else
    #define GLAD_PLATFORM_EMSCRIPTEN 0
  #endif
#endif

#ifndef GLAD_PLATFORM_UWP
  #if defined(_MSC_VER) && !defined(GLAD_INTERNAL_HAVE_WINAPIFAMILY)
    #ifdef __has_include
      #if __has_include(<winapifamily.h>)
        #define GLAD_INTERNAL_HAVE_WINAPIFAMILY 1
      #endif
    #elif _MSC_VER >= 1700 && !_USING_V110_SDK71_
      #define GLAD_INTERNAL_HAVE_WINAPIFAMILY 1
    #endif
  #endif

  #ifdef GLAD_INTERNAL_HAVE_WINAPIFAMILY
    #include <winapifamily.h>
    #if !WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) && WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)
      #define GLAD_PLATFORM_UWP 1
    #endif
  #endif

  #ifndef GLAD_PLATFORM_UWP
    #define GLAD_PLATFORM_UWP 0
  #endif
#endif

#ifdef __GNUC__
  #define GLAD_GNUC_EXTENSION __extension__
#else
  #define GLAD_GNUC_EXTENSION
#endif

#ifndef GLAD_API_CALL
  #if defined(GLAD_API_CALL_EXPORT)
    #if GLAD_PLATFORM_WIN32 || defined(__CYGWIN__)
      #if defined(GLAD_API_CALL_EXPORT_BUILD)
        #if defined(__GNUC__)
          #define GLAD_API_CALL __attribute__ ((dllexport)) extern
        #else
          #define GLAD_API_CALL __declspec(dllexport) extern
        #endif
      #else
        #if defined(__GNUC__)
          #define GLAD_API_CALL __attribute__ ((dllimport)) extern
        #else
          #define GLAD_API_CALL __declspec(dllimport) extern
        #endif
      #endif
    #elif defined(__GNUC__) && defined(GLAD_API_CALL_EXPORT_BUILD)
      #define GLAD_API_CALL __attribute__ ((visibility ("default"))) extern
    #else
      #define GLAD_API_CALL extern
    #endif
  #else
    #define GLAD_API_CALL extern
  #endif
#endif

#ifdef APIENTRY
  #define GLAD_API_PTR APIENTRY
#elif GLAD_PLATFORM_WIN32
  #define GLAD_API_PTR __stdcall
#else
  #define GLAD_API_PTR
#endif

#ifndef GLAPI
#define GLAPI GLAD_API_CALL
#endif

#ifndef GLAPIENTRY
#define GLAPIENTRY GLAD_API_PTR
#endif

#define GLAD_MAKE_VERSION(major, minor) (major * 10000 + minor)
#define GLAD_VERSION_MAJOR(version) (version / 10000)
#define GLAD_VERSION_MINOR(version) (version % 10000)

#define GLAD_GENERATOR_VERSION "2.0.0-beta"

typedef void (*GLADapiproc)(void);

typedef GLADapiproc (*GLADloadfunc)(const char *name);
typedef GLADapiproc (*GLADuserptrloadfunc)(void *userptr, const char *name);

typedef void (*GLADprecallback)(const char *name, GLADapiproc apiproc, int len_args, ...);
typedef void (*GLADpostcallback)(void *ret, const char *name, GLADapiproc apiproc, int len_args, ...);

#endif /* GLAD_PLATFORM_H_ */

#define EGL_ALPHA_FORMAT 0x3088
#define EGL_ALPHA_FORMAT_NONPRE 0x308B
#define EGL_ALPHA_FORMAT_PRE 0x308C
#define EGL_ALPHA_MASK_SIZE 0x303E
#define EGL_ALPHA_SIZE 0x3021
#define EGL_BACK_BUFFER 0x3084
#define EGL_BAD_ACCESS 0x3002
#define EGL_BAD_ALLOC 0x3003
#define EGL_BAD_ATTRIBUTE 0x3004
#define EGL_BAD_CONFIG 0x3005
#define EGL_BAD_CONTEXT 0x3006
#define EGL_BAD_CURRENT_SURFACE 0x3007
#define EGL_BAD_DISPLAY 0x3008
#define EGL_BAD_MATCH 0x3009
#define EGL_BAD_NATIVE_PIXMAP 0x300A
#define EGL_BAD_NATIVE_WINDOW 0x300B
#define EGL_BAD_PARAMETER 0x300C
#define EGL_BAD_SURFACE 0x300D
#define EGL_BIND_TO_TEXTURE_RGB 0x3039
#define EGL_BIND_TO_TEXTURE_RGBA 0x303A
#define EGL_BLUE_SIZE 0x3022
#define EGL_BUFFER_DESTROYED 0x3095
#define EGL_BUFFER_PRESERVED 0x3094
#define EGL_BUFFER_SIZE 0x3020
#define EGL_CLIENT_APIS 0x308D
#define EGL_CL_EVENT_HANDLE 0x309C
#define EGL_CL_EVENT_HANDLE_KHR 0x309C
#define EGL_COLORSPACE 0x3087
#define EGL_COLORSPACE_LINEAR 0x308A
#define EGL_COLORSPACE_sRGB 0x3089
#define EGL_COLOR_BUFFER_TYPE 0x303F
#define EGL_CONDITION_SATISFIED 0x30F6
#define EGL_CONDITION_SATISFIED_KHR 0x30F6
#define EGL_CONFIG_CAVEAT 0x3027
#define EGL_CONFIG_ID 0x3028
#define EGL_CONFORMANT 0x3042
#define EGL_CONTEXT_CLIENT_TYPE 0x3097
#define EGL_CONTEXT_CLIENT_VERSION 0x3098
#define EGL_CONTEXT_LOST 0x300E
#define EGL_CONTEXT_MAJOR_VERSION 0x3098
#define EGL_CONTEXT_MINOR_VERSION 0x30FB
#define EGL_CONTEXT_OPENGL_COMPATIBILITY_PROFILE_BIT 0x00000002
#define EGL_CONTEXT_OPENGL_CORE_PROFILE_BIT 0x00000001
#define EGL_CONTEXT_OPENGL_DEBUG 0x31B0
#define EGL_CONTEXT_OPENGL_FORWARD_COMPATIBLE 0x31B1
#define EGL_CONTEXT_OPENGL_PROFILE_MASK 0x30FD
#define EGL_CONTEXT_OPENGL_RESET_NOTIFICATION_STRATEGY 0x31BD
#define EGL_CONTEXT_OPENGL_ROBUST_ACCESS 0x31B2
#define EGL_CORE_NATIVE_ENGINE 0x305B
#define EGL_DEFAULT_DISPLAY EGL_CAST(EGLNativeDisplayType,0)
#define EGL_DEPTH_SIZE 0x3025
#define EGL_DISPLAY_SCALING 10000
#define EGL_DONT_CARE EGL_CAST(EGLint,-1)
#define EGL_DRAW 0x3059
#define EGL_EXTENSIONS 0x3055
#define EGL_FALSE 0
#define EGL_FOREVER 0xFFFFFFFFFFFFFFFF
#define EGL_FOREVER_KHR 0xFFFFFFFFFFFFFFFF
#define EGL_GL_COLORSPACE 0x309D
#define EGL_GL_COLORSPACE_LINEAR 0x308A
#define EGL_GL_COLORSPACE_SRGB 0x3089
#define EGL_GL_RENDERBUFFER 0x30B9
#define EGL_GL_TEXTURE_2D 0x30B1
#define EGL_GL_TEXTURE_3D 0x30B2
#define EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X 0x30B4
#define EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y 0x30B6
#define EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z 0x30B8
#define EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X 0x30B3
#define EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y 0x30B5
#define EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z 0x30B7
#define EGL_GL_TEXTURE_LEVEL 0x30BC
#define EGL_GL_TEXTURE_ZOFFSET 0x30BD
#define EGL_GREEN_SIZE 0x3023
#define EGL_HEIGHT 0x3056
#define EGL_HORIZONTAL_RESOLUTION 0x3090
#define EGL_IMAGE_PRESERVED 0x30D2
#define EGL_IMAGE_PRESERVED_KHR 0x30D2
#define EGL_LARGEST_PBUFFER 0x3058
#define EGL_LEVEL 0x3029
#define EGL_LOSE_CONTEXT_ON_RESET 0x31BF
#define EGL_LUMINANCE_BUFFER 0x308F
#define EGL_LUMINANCE_SIZE 0x303D
#define EGL_MATCH_NATIVE_PIXMAP 0x3041
#define EGL_MAX_PBUFFER_HEIGHT 0x302A
#define EGL_MAX_PBUFFER_PIXELS 0x302B
#define EGL_MAX_PBUFFER_WIDTH 0x302C
#define EGL_MAX_SWAP_INTERVAL 0x303C
#define EGL_MIN_SWAP_INTERVAL 0x303B
#define EGL_MIPMAP_LEVEL 0x3083
#define EGL_MIPMAP_TEXTURE 0x3082
#define EGL_MULTISAMPLE_RESOLVE 0x3099
#define EGL_MULTISAMPLE_RESOLVE_BOX 0x309B
#define EGL_MULTISAMPLE_RESOLVE_BOX_BIT 0x0200
#define EGL_MULTISAMPLE_RESOLVE_DEFAULT 0x309A
#define EGL_NATIVE_PIXMAP_KHR 0x30B0
#define EGL_NATIVE_RENDERABLE 0x302D
#define EGL_NATIVE_VISUAL_ID 0x302E
#define EGL_NATIVE_VISUAL_TYPE 0x302F
#define EGL_NONE 0x3038
#define EGL_NON_CONFORMANT_CONFIG 0x3051
#define EGL_NOT_INITIALIZED 0x3001
#define EGL_NO_CONTEXT EGL_CAST(EGLContext,0)
#define EGL_NO_DISPLAY EGL_CAST(EGLDisplay,0)
#define EGL_NO_IMAGE EGL_CAST(EGLImage,0)
#define EGL_NO_IMAGE_KHR EGL_CAST(EGLImageKHR,0)
#define EGL_NO_RESET_NOTIFICATION 0x31BE
#define EGL_NO_SURFACE EGL_CAST(EGLSurface,0)
#define EGL_NO_SYNC EGL_CAST(EGLSync,0)
#define EGL_NO_SYNC_KHR EGL_CAST(EGLSync,0)
#define EGL_NO_TEXTURE 0x305C
#define EGL_OPENGL_API 0x30A2
#define EGL_OPENGL_BIT 0x0008
#define EGL_OPENGL_ES2_BIT 0x0004
#define EGL_OPENGL_ES3_BIT 0x00000040
#define EGL_OPENGL_ES_API 0x30A0
#define EGL_OPENGL_ES_BIT 0x0001
#define EGL_OPENVG_API 0x30A1
#define EGL_OPENVG_BIT 0x0002
#define EGL_OPENVG_IMAGE 0x3096
#define EGL_PBUFFER_BIT 0x0001
#define EGL_PIXEL_ASPECT_RATIO 0x3092
#define EGL_PIXMAP_BIT 0x0002
#define EGL_READ 0x305A
#define EGL_RED_SIZE 0x3024
#define EGL_RENDERABLE_TYPE 0x3040
#define EGL_RENDER_BUFFER 0x3086
#define EGL_RGB_BUFFER 0x308E
#define EGL_SAMPLES 0x3031
#define EGL_SAMPLE_BUFFERS 0x3032
#define EGL_SIGNALED 0x30F2
#define EGL_SIGNALED_KHR 0x30F2
#define EGL_SINGLE_BUFFER 0x3085
#define EGL_SLOW_CONFIG 0x3050
#define EGL_STENCIL_SIZE 0x3026
#define EGL_SUCCESS 0x3000
#define EGL_SURFACE_TYPE 0x3033
#define EGL_SWAP_BEHAVIOR 0x3093
#define EGL_SWAP_BEHAVIOR_PRESERVED_BIT 0x0400
#define EGL_SYNC_CL_EVENT 0x30FE
#define EGL_SYNC_CL_EVENT_COMPLETE 0x30FF
#define EGL_SYNC_CL_EVENT_COMPLETE_KHR 0x30FF
#define EGL_SYNC_CL_EVENT_KHR 0x30FE
#define EGL_SYNC_CONDITION 0x30F8
#define EGL_SYNC_CONDITION_KHR 0x30F8
#define EGL_SYNC_FENCE 0x30F9
#define EGL_SYNC_FENCE_KHR 0x30F9
#define EGL_SYNC_FLUSH_COMMANDS_BIT 0x0001
#define EGL_SYNC_FLUSH_COMMANDS_BIT_KHR 0x0001
#define EGL_SYNC_PRIOR_COMMANDS_COMPLETE 0x30F0
#define EGL_SYNC_PRIOR_COMMANDS_COMPLETE_KHR 0x30F0
#define EGL_SYNC_REUSABLE_KHR 0x30FA
#define EGL_SYNC_STATUS 0x30F1
#define EGL_SYNC_STATUS_KHR 0x30F1
#define EGL_SYNC_TYPE 0x30F7
#define EGL_SYNC_TYPE_KHR 0x30F7
#define EGL_TEXTURE_2D 0x305F
#define EGL_TEXTURE_FORMAT 0x3080
#define EGL_TEXTURE_RGB 0x305D
#define EGL_TEXTURE_RGBA 0x305E
#define EGL_TEXTURE_TARGET 0x3081
#define EGL_TIMEOUT_EXPIRED 0x30F5
#define EGL_TIMEOUT_EXPIRED_KHR 0x30F5
#define EGL_TRANSPARENT_BLUE_VALUE 0x3035
#define EGL_TRANSPARENT_GREEN_VALUE 0x3036
#define EGL_TRANSPARENT_RED_VALUE 0x3037
#define EGL_TRANSPARENT_RGB 0x3052
#define EGL_TRANSPARENT_TYPE 0x3034
#define EGL_TRUE 1
#define EGL_UNKNOWN EGL_CAST(EGLint,-1)
#define EGL_UNSIGNALED 0x30F3
#define EGL_UNSIGNALED_KHR 0x30F3
#define EGL_VENDOR 0x3053
#define EGL_VERSION 0x3054
#define EGL_VERTICAL_RESOLUTION 0x3091
#define EGL_VG_ALPHA_FORMAT 0x3088
#define EGL_VG_ALPHA_FORMAT_NONPRE 0x308B
#define EGL_VG_ALPHA_FORMAT_PRE 0x308C
#define EGL_VG_ALPHA_FORMAT_PRE_BIT 0x0040
#define EGL_VG_COLORSPACE 0x3087
#define EGL_VG_COLORSPACE_LINEAR 0x308A
#define EGL_VG_COLORSPACE_LINEAR_BIT 0x0020
#define EGL_VG_COLORSPACE_sRGB 0x3089
#define EGL_WIDTH 0x3057
#define EGL_WINDOW_BIT 0x0004


#ifndef __khrplatform_h_
#define __khrplatform_h_

/*
** Copyright (c) 2008-2018 The Khronos Group Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and/or associated documentation files (the
** "Materials"), to deal in the Materials without restriction, including
** without limitation the rights to use, copy, modify, merge, publish,
** distribute, sublicense, and/or sell copies of the Materials, and to
** permit persons to whom the Materials are furnished to do so, subject to
** the following conditions:
**
** The above copyright notice and this permission notice shall be included
** in all copies or substantial portions of the Materials.
**
** THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
** CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
** TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
** MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.
*/

/* Khronos platform-specific types and definitions.
 *
 * The master copy of khrplatform.h is maintained in the Khronos EGL
 * Registry repository at https://github.com/KhronosGroup/EGL-Registry
 * The last semantic modification to khrplatform.h was at commit ID:
 *      67a3e0864c2d75ea5287b9f3d2eb74a745936692
 *
 * Adopters may modify this file to suit their platform. Adopters are
 * encouraged to submit platform specific modifications to the Khronos
 * group so that they can be included in future versions of this file.
 * Please submit changes by filing pull requests or issues on
 * the EGL Registry repository linked above.
 *
 *
 * See the Implementer's Guidelines for information about where this file
 * should be located on your system and for more details of its use:
 *    http://www.khronos.org/registry/implementers_guide.pdf
 *
 * This file should be included as
 *        #include <KHR/khrplatform.h>
 * by Khronos client API header files that use its types and defines.
 *
 * The types in khrplatform.h should only be used to define API-specific types.
 *
 * Types defined in khrplatform.h:
 *    khronos_int8_t              signed   8  bit
 *    khronos_uint8_t             unsigned 8  bit
 *    khronos_int16_t             signed   16 bit
 *    khronos_uint16_t            unsigned 16 bit
 *    khronos_int32_t             signed   32 bit
 *    khronos_uint32_t            unsigned 32 bit
 *    khronos_int64_t             signed   64 bit
 *    khronos_uint64_t            unsigned 64 bit
 *    khronos_intptr_t            signed   same number of bits as a pointer
 *    khronos_uintptr_t           unsigned same number of bits as a pointer
 *    khronos_ssize_t             signed   size
 *    khronos_usize_t             unsigned size
 *    khronos_float_t             signed   32 bit floating point
 *    khronos_time_ns_t           unsigned 64 bit time in nanoseconds
 *    khronos_utime_nanoseconds_t unsigned time interval or absolute time in
 *                                         nanoseconds
 *    khronos_stime_nanoseconds_t signed time interval in nanoseconds
 *    khronos_boolean_enum_t      enumerated boolean type. This should
 *      only be used as a base type when a client API's boolean type is
 *      an enum. Client APIs which use an integer or other type for
 *      booleans cannot use this as the base type for their boolean.
 *
 * Tokens defined in khrplatform.h:
 *
 *    KHRONOS_FALSE, KHRONOS_TRUE Enumerated boolean false/true values.
 *
 *    KHRONOS_SUPPORT_INT64 is 1 if 64 bit integers are supported; otherwise 0.
 *    KHRONOS_SUPPORT_FLOAT is 1 if floats are supported; otherwise 0.
 *
 * Calling convention macros defined in this file:
 *    KHRONOS_APICALL
 *    KHRONOS_GLAD_API_PTR
 *    KHRONOS_APIATTRIBUTES
 *
 * These may be used in function prototypes as:
 *
 *      KHRONOS_APICALL void KHRONOS_GLAD_API_PTR funcname(
 *                                  int arg1,
 *                                  int arg2) KHRONOS_APIATTRIBUTES;
 */

#if defined(__SCITECH_SNAP__) && !defined(KHRONOS_STATIC)
#   define KHRONOS_STATIC 1
#endif

/*-------------------------------------------------------------------------
 * Definition of KHRONOS_APICALL
 *-------------------------------------------------------------------------
 * This precedes the return type of the function in the function prototype.
 */
#if defined(KHRONOS_STATIC)
    /* If the preprocessor constant KHRONOS_STATIC is defined, make the
     * header compatible with static linking. */
#   define KHRONOS_APICALL
#elif defined(_WIN32)
#   define KHRONOS_APICALL __declspec(dllimport)
#elif defined (__SYMBIAN32__)
#   define KHRONOS_APICALL IMPORT_C
#elif defined(__ANDROID__)
#   define KHRONOS_APICALL __attribute__((visibility("default")))
#else
#   define KHRONOS_APICALL
#endif

/*-------------------------------------------------------------------------
 * Definition of KHRONOS_GLAD_API_PTR
 *-------------------------------------------------------------------------
 * This follows the return type of the function  and precedes the function
 * name in the function prototype.
 */
#if defined(_WIN32) && !defined(_WIN32_WCE) && !defined(__SCITECH_SNAP__)
    /* Win32 but not WinCE */
#   define KHRONOS_GLAD_API_PTR __stdcall
#else
#   define KHRONOS_GLAD_API_PTR
#endif

/*-------------------------------------------------------------------------
 * Definition of KHRONOS_APIATTRIBUTES
 *-------------------------------------------------------------------------
 * This follows the closing parenthesis of the function prototype arguments.
 */
#if defined (__ARMCC_2__)
#define KHRONOS_APIATTRIBUTES __softfp
#else
#define KHRONOS_APIATTRIBUTES
#endif

/*-------------------------------------------------------------------------
 * basic type definitions
 *-----------------------------------------------------------------------*/
#if (defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L) || defined(__GNUC__) || defined(__SCO__) || defined(__USLC__)


/*
 * Using <stdint.h>
 */
#include <stdint.h>
typedef int32_t                 khronos_int32_t;
typedef uint32_t                khronos_uint32_t;
typedef int64_t                 khronos_int64_t;
typedef uint64_t                khronos_uint64_t;
#define KHRONOS_SUPPORT_INT64   1
#define KHRONOS_SUPPORT_FLOAT   1
/*
 * To support platform where unsigned long cannot be used interchangeably with
 * inptr_t (e.g. CHERI-extended ISAs), we can use the stdint.h intptr_t.
 * Ideally, we could just use (u)intptr_t everywhere, but this could result in
 * ABI breakage if khronos_uintptr_t is changed from unsigned long to
 * unsigned long long or similar (this results in different C++ name mangling).
 * To avoid changes for existing platforms, we restrict usage of intptr_t to
 * platforms where the size of a pointer is larger than the size of long.
 */
#if defined(__SIZEOF_LONG__) && defined(__SIZEOF_POINTER__)
#if __SIZEOF_POINTER__ > __SIZEOF_LONG__
#define KHRONOS_USE_INTPTR_T
#endif
#endif

#elif defined(__VMS ) || defined(__sgi)

/*
 * Using <inttypes.h>
 */
#include <inttypes.h>
typedef int32_t                 khronos_int32_t;
typedef uint32_t                khronos_uint32_t;
typedef int64_t                 khronos_int64_t;
typedef uint64_t                khronos_uint64_t;
#define KHRONOS_SUPPORT_INT64   1
#define KHRONOS_SUPPORT_FLOAT   1

#elif defined(_WIN32) && !defined(__SCITECH_SNAP__)

/*
 * Win32
 */
typedef __int32                 khronos_int32_t;
typedef unsigned __int32        khronos_uint32_t;
typedef __int64                 khronos_int64_t;
typedef unsigned __int64        khronos_uint64_t;
#define KHRONOS_SUPPORT_INT64   1
#define KHRONOS_SUPPORT_FLOAT   1

#elif defined(__sun__) || defined(__digital__)

/*
 * Sun or Digital
 */
typedef int                     khronos_int32_t;
typedef unsigned int            khronos_uint32_t;
#if defined(__arch64__) || defined(_LP64)
typedef long int                khronos_int64_t;
typedef unsigned long int       khronos_uint64_t;
#else
typedef long long int           khronos_int64_t;
typedef unsigned long long int  khronos_uint64_t;
#endif /* __arch64__ */
#define KHRONOS_SUPPORT_INT64   1
#define KHRONOS_SUPPORT_FLOAT   1

#elif 0

/*
 * Hypothetical platform with no float or int64 support
 */
typedef int                     khronos_int32_t;
typedef unsigned int            khronos_uint32_t;
#define KHRONOS_SUPPORT_INT64   0
#define KHRONOS_SUPPORT_FLOAT   0

#else

/*
 * Generic fallback
 */
#include <stdint.h>
typedef int32_t                 khronos_int32_t;
typedef uint32_t                khronos_uint32_t;
typedef int64_t                 khronos_int64_t;
typedef uint64_t                khronos_uint64_t;
#define KHRONOS_SUPPORT_INT64   1
#define KHRONOS_SUPPORT_FLOAT   1

#endif


/*
 * Types that are (so far) the same on all platforms
 */
typedef signed   char          khronos_int8_t;
typedef unsigned char          khronos_uint8_t;
typedef signed   short int     khronos_int16_t;
typedef unsigned short int     khronos_uint16_t;

/*
 * Types that differ between LLP64 and LP64 architectures - in LLP64,
 * pointers are 64 bits, but 'long' is still 32 bits. Win64 appears
 * to be the only LLP64 architecture in current use.
 */
#ifdef KHRONOS_USE_INTPTR_T
typedef intptr_t               khronos_intptr_t;
typedef uintptr_t              khronos_uintptr_t;
#elif defined(_WIN64)
typedef signed   long long int khronos_intptr_t;
typedef unsigned long long int khronos_uintptr_t;
#else
typedef signed   long  int     khronos_intptr_t;
typedef unsigned long  int     khronos_uintptr_t;
#endif

#if defined(_WIN64)
typedef signed   long long int khronos_ssize_t;
typedef unsigned long long int khronos_usize_t;
#else
typedef signed   long  int     khronos_ssize_t;
typedef unsigned long  int     khronos_usize_t;
#endif

#if KHRONOS_SUPPORT_FLOAT
/*
 * Float type
 */
typedef          float         khronos_float_t;
#endif

#if KHRONOS_SUPPORT_INT64
/* Time types
 *
 * These types can be used to represent a time interval in nanoseconds or
 * an absolute Unadjusted System Time.  Unadjusted System Time is the number
 * of nanoseconds since some arbitrary system event (e.g. since the last
 * time the system booted).  The Unadjusted System Time is an unsigned
 * 64 bit value that wraps back to 0 every 584 years.  Time intervals
 * may be either signed or unsigned.
 */
typedef khronos_uint64_t       khronos_utime_nanoseconds_t;
typedef khronos_int64_t        khronos_stime_nanoseconds_t;
#endif

/*
 * Dummy value used to pad enum types to 32 bits.
 */
#ifndef KHRONOS_MAX_ENUM
#define KHRONOS_MAX_ENUM 0x7FFFFFFF
#endif

/*
 * Enumerated boolean type
 *
 * Values other than zero should be considered to be true.  Therefore
 * comparisons should not be made against KHRONOS_TRUE.
 */
typedef enum {
    KHRONOS_FALSE = 0,
    KHRONOS_TRUE  = 1,
    KHRONOS_BOOLEAN_ENUM_FORCE_SIZE = KHRONOS_MAX_ENUM
} khronos_boolean_enum_t;

#endif /* __khrplatform_h_ */
#ifndef __eglplatform_h_
#define __eglplatform_h_

/*
** Copyright 2007-2020 The Khronos Group Inc.
** SPDX-License-Identifier: Apache-2.0
*/

/* Platform-specific types and definitions for egl.h
 *
 * Adopters may modify khrplatform.h and this file to suit their platform.
 * You are encouraged to submit all modifications to the Khronos group so that
 * they can be included in future versions of this file.  Please submit changes
 * by filing an issue or pull request on the public Khronos EGL Registry, at
 * https://www.github.com/KhronosGroup/EGL-Registry/
 */

/*   */

/* Macros used in EGL function prototype declarations.
 *
 * EGL functions should be prototyped as:
 *
 * EGLAPI return-type EGLGLAD_API_PTR eglFunction(arguments);
 * typedef return-type (EXPGLAD_API_PTRP PFNEGLFUNCTIONPROC) (arguments);
 *
 * KHRONOS_APICALL and KHRONOS_GLAD_API_PTR are defined in KHR/khrplatform.h
 */

#ifndef EGLAPI
#define EGLAPI KHRONOS_APICALL
#endif

#ifndef EGLGLAD_API_PTR
#define EGLGLAD_API_PTR  KHRONOS_GLAD_API_PTR
#endif
#define EGLGLAD_API_PTRP EGLGLAD_API_PTR*

/* The types NativeDisplayType, NativeWindowType, and NativePixmapType
 * are aliases of window-system-dependent types, such as X Display * or
 * Windows Device Context. They must be defined in platform-specific
 * code below. The EGL-prefixed versions of Native*Type are the same
 * types, renamed in EGL 1.3 so all types in the API start with "EGL".
 *
 * Khronos STRONGLY RECOMMENDS that you use the default definitions
 * provided below, since these changes affect both binary and source
 * portability of applications using EGL running on different EGL
 * implementations.
 */

#if defined(EGL_NO_PLATFORM_SPECIFIC_TYPES)

typedef void *EGLNativeDisplayType;
typedef void *EGLNativePixmapType;
typedef void *EGLNativeWindowType;

#elif defined(_WIN32) || defined(__VC32__) && !defined(__CYGWIN__) && !defined(__SCITECH_SNAP__) /* Win32 and WinCE */
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN 1
#endif
#include <windows.h>

typedef HDC     EGLNativeDisplayType;
typedef HBITMAP EGLNativePixmapType;
typedef HWND    EGLNativeWindowType;

#elif defined(__EMSCRIPTEN__)

typedef int EGLNativeDisplayType;
typedef int EGLNativePixmapType;
typedef int EGLNativeWindowType;

#elif defined(__WINSCW__) || defined(__SYMBIAN32__)  /* Symbian */

typedef int   EGLNativeDisplayType;
typedef void *EGLNativePixmapType;
typedef void *EGLNativeWindowType;

#elif defined(WL_EGL_PLATFORM)

typedef struct wl_display     *EGLNativeDisplayType;
typedef struct wl_egl_pixmap  *EGLNativePixmapType;
typedef struct wl_egl_window  *EGLNativeWindowType;

#elif defined(__GBM__)

typedef struct gbm_device  *EGLNativeDisplayType;
typedef struct gbm_bo      *EGLNativePixmapType;
typedef void               *EGLNativeWindowType;

#elif defined(__ANDROID__) || defined(ANDROID)

struct ANativeWindow;
struct egl_native_pixmap_t;

typedef void*                           EGLNativeDisplayType;
typedef struct egl_native_pixmap_t*     EGLNativePixmapType;
typedef struct ANativeWindow*           EGLNativeWindowType;

#elif defined(USE_OZONE)

typedef intptr_t EGLNativeDisplayType;
typedef intptr_t EGLNativePixmapType;
typedef intptr_t EGLNativeWindowType;

#elif defined(USE_X11)

/* X11 (tentative)  */
#include <X11/Xlib.h>
#include <X11/Xutil.h>

typedef Display *EGLNativeDisplayType;
typedef Pixmap   EGLNativePixmapType;
typedef Window   EGLNativeWindowType;

#elif defined(__unix__)

typedef void             *EGLNativeDisplayType;
typedef khronos_uintptr_t EGLNativePixmapType;
typedef khronos_uintptr_t EGLNativeWindowType;

#elif defined(__APPLE__)

typedef int   EGLNativeDisplayType;
typedef void *EGLNativePixmapType;
typedef void *EGLNativeWindowType;

#elif defined(__HAIKU__)

#include <kernel/image.h>

typedef void              *EGLNativeDisplayType;
typedef khronos_uintptr_t  EGLNativePixmapType;
typedef khronos_uintptr_t  EGLNativeWindowType;

#elif defined(__Fuchsia__)

typedef void              *EGLNativeDisplayType;
typedef khronos_uintptr_t  EGLNativePixmapType;
typedef khronos_uintptr_t  EGLNativeWindowType;

#else
#error "Platform not recognized"
#endif

/* EGL 1.2 types, renamed for consistency in EGL 1.3 */
typedef EGLNativeDisplayType NativeDisplayType;
typedef EGLNativePixmapType  NativePixmapType;
typedef EGLNativeWindowType  NativeWindowType;


/* Define EGLint. This must be a signed integral type large enough to contain
 * all legal attribute names and values passed into and out of EGL, whether
 * their type is boolean, bitmask, enumerant (symbolic constant), integer,
 * handle, or other.  While in general a 32-bit integer will suffice, if
 * handles are 64 bit types, then EGLint should be defined as a signed 64-bit
 * integer type.
 */
typedef khronos_int32_t EGLint;


/* C++ / C typecast macros for special EGL handle values */
#if defined(__cplusplus)
#define EGL_CAST(type, value) (static_cast<type>(value))
#else
#define EGL_CAST(type, value) ((type) (value))
#endif

#endif /* __eglplatform_h */











struct AHardwareBuffer;
struct wl_buffer;
struct wl_display;
struct wl_resource;

typedef unsigned int EGLBoolean;
typedef unsigned int EGLenum;
typedef intptr_t EGLAttribKHR;
typedef intptr_t EGLAttrib;
typedef void *EGLClientBuffer;
typedef void *EGLConfig;
typedef void *EGLContext;
typedef void *EGLDeviceEXT;
typedef void *EGLDisplay;
typedef void *EGLImage;
typedef void *EGLImageKHR;
typedef void *EGLLabelKHR;
typedef void *EGLObjectKHR;
typedef void *EGLOutputLayerEXT;
typedef void *EGLOutputPortEXT;
typedef void *EGLStreamKHR;
typedef void *EGLSurface;
typedef void *EGLSync;
typedef void *EGLSyncKHR;
typedef void *EGLSyncNV;
typedef void (*__eglMustCastToProperFunctionPointerType)(void);
typedef khronos_utime_nanoseconds_t EGLTimeKHR;
typedef khronos_utime_nanoseconds_t EGLTime;
typedef khronos_utime_nanoseconds_t EGLTimeNV;
typedef khronos_utime_nanoseconds_t EGLuint64NV;
typedef khronos_uint64_t EGLuint64KHR;
typedef khronos_stime_nanoseconds_t EGLnsecsANDROID;
typedef int EGLNativeFileDescriptorKHR;
typedef khronos_ssize_t EGLsizeiANDROID;
typedef void (*EGLSetBlobFuncANDROID) (const void *key, EGLsizeiANDROID keySize, const void *value, EGLsizeiANDROID valueSize);
typedef EGLsizeiANDROID (*EGLGetBlobFuncANDROID) (const void *key, EGLsizeiANDROID keySize, void *value, EGLsizeiANDROID valueSize);
struct EGLClientPixmapHI {
    void  *pData;
    EGLint iWidth;
    EGLint iHeight;
    EGLint iStride;
};
typedef void (GLAD_API_PTR *EGLDEBUGPROCKHR)(EGLenum error,const char *command,EGLint messageType,EGLLabelKHR threadLabel,EGLLabelKHR objectLabel,const char* message);
#define PFNEGLBINDWAYLANDDISPLAYWL PFNEGLBINDWAYLANDDISPLAYWLPROC
#define PFNEGLUNBINDWAYLANDDISPLAYWL PFNEGLUNBINDWAYLANDDISPLAYWLPROC
#define PFNEGLQUERYWAYLANDBUFFERWL PFNEGLQUERYWAYLANDBUFFERWLPROC
#define PFNEGLCREATEWAYLANDBUFFERFROMIMAGEWL PFNEGLCREATEWAYLANDBUFFERFROMIMAGEWLPROC


#define EGL_VERSION_1_0 1
GLAD_API_CALL int SF_GLAD_EGL_VERSION_1_0;
#define EGL_VERSION_1_1 1
GLAD_API_CALL int SF_GLAD_EGL_VERSION_1_1;
#define EGL_VERSION_1_2 1
GLAD_API_CALL int SF_GLAD_EGL_VERSION_1_2;
#define EGL_VERSION_1_3 1
GLAD_API_CALL int SF_GLAD_EGL_VERSION_1_3;
#define EGL_VERSION_1_4 1
GLAD_API_CALL int SF_GLAD_EGL_VERSION_1_4;
#define EGL_VERSION_1_5 1
GLAD_API_CALL int SF_GLAD_EGL_VERSION_1_5;
#define EGL_KHR_cl_event2 1
GLAD_API_CALL int SF_GLAD_EGL_KHR_cl_event2;
#define EGL_KHR_fence_sync 1
GLAD_API_CALL int SF_GLAD_EGL_KHR_fence_sync;
#define EGL_KHR_image 1
GLAD_API_CALL int SF_GLAD_EGL_KHR_image;
#define EGL_KHR_image_base 1
GLAD_API_CALL int SF_GLAD_EGL_KHR_image_base;
#define EGL_KHR_reusable_sync 1
GLAD_API_CALL int SF_GLAD_EGL_KHR_reusable_sync;


typedef EGLBoolean (GLAD_API_PTR *PFNEGLBINDAPIPROC)(EGLenum api);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLBINDTEXIMAGEPROC)(EGLDisplay dpy, EGLSurface surface, EGLint buffer);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLCHOOSECONFIGPROC)(EGLDisplay dpy, const EGLint * attrib_list, EGLConfig * configs, EGLint config_size, EGLint * num_config);
typedef EGLint (GLAD_API_PTR *PFNEGLCLIENTWAITSYNCPROC)(EGLDisplay dpy, EGLSync sync, EGLint flags, EGLTime timeout);
typedef EGLint (GLAD_API_PTR *PFNEGLCLIENTWAITSYNCKHRPROC)(EGLDisplay dpy, EGLSyncKHR sync, EGLint flags, EGLTimeKHR timeout);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLCOPYBUFFERSPROC)(EGLDisplay dpy, EGLSurface surface, EGLNativePixmapType target);
typedef EGLContext (GLAD_API_PTR *PFNEGLCREATECONTEXTPROC)(EGLDisplay dpy, EGLConfig config, EGLContext share_context, const EGLint * attrib_list);
typedef EGLImage (GLAD_API_PTR *PFNEGLCREATEIMAGEPROC)(EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLAttrib * attrib_list);
typedef EGLImageKHR (GLAD_API_PTR *PFNEGLCREATEIMAGEKHRPROC)(EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLint * attrib_list);
typedef EGLSurface (GLAD_API_PTR *PFNEGLCREATEPBUFFERFROMCLIENTBUFFERPROC)(EGLDisplay dpy, EGLenum buftype, EGLClientBuffer buffer, EGLConfig config, const EGLint * attrib_list);
typedef EGLSurface (GLAD_API_PTR *PFNEGLCREATEPBUFFERSURFACEPROC)(EGLDisplay dpy, EGLConfig config, const EGLint * attrib_list);
typedef EGLSurface (GLAD_API_PTR *PFNEGLCREATEPIXMAPSURFACEPROC)(EGLDisplay dpy, EGLConfig config, EGLNativePixmapType pixmap, const EGLint * attrib_list);
typedef EGLSurface (GLAD_API_PTR *PFNEGLCREATEPLATFORMPIXMAPSURFACEPROC)(EGLDisplay dpy, EGLConfig config, void * native_pixmap, const EGLAttrib * attrib_list);
typedef EGLSurface (GLAD_API_PTR *PFNEGLCREATEPLATFORMWINDOWSURFACEPROC)(EGLDisplay dpy, EGLConfig config, void * native_window, const EGLAttrib * attrib_list);
typedef EGLSync (GLAD_API_PTR *PFNEGLCREATESYNCPROC)(EGLDisplay dpy, EGLenum type, const EGLAttrib * attrib_list);
typedef EGLSyncKHR (GLAD_API_PTR *PFNEGLCREATESYNC64KHRPROC)(EGLDisplay dpy, EGLenum type, const EGLAttribKHR * attrib_list);
typedef EGLSyncKHR (GLAD_API_PTR *PFNEGLCREATESYNCKHRPROC)(EGLDisplay dpy, EGLenum type, const EGLint * attrib_list);
typedef EGLSurface (GLAD_API_PTR *PFNEGLCREATEWINDOWSURFACEPROC)(EGLDisplay dpy, EGLConfig config, EGLNativeWindowType win, const EGLint * attrib_list);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLDESTROYCONTEXTPROC)(EGLDisplay dpy, EGLContext ctx);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLDESTROYIMAGEPROC)(EGLDisplay dpy, EGLImage image);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLDESTROYIMAGEKHRPROC)(EGLDisplay dpy, EGLImageKHR image);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLDESTROYSURFACEPROC)(EGLDisplay dpy, EGLSurface surface);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLDESTROYSYNCPROC)(EGLDisplay dpy, EGLSync sync);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLDESTROYSYNCKHRPROC)(EGLDisplay dpy, EGLSyncKHR sync);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLGETCONFIGATTRIBPROC)(EGLDisplay dpy, EGLConfig config, EGLint attribute, EGLint * value);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLGETCONFIGSPROC)(EGLDisplay dpy, EGLConfig * configs, EGLint config_size, EGLint * num_config);
typedef EGLContext (GLAD_API_PTR *PFNEGLGETCURRENTCONTEXTPROC)(void);
typedef EGLDisplay (GLAD_API_PTR *PFNEGLGETCURRENTDISPLAYPROC)(void);
typedef EGLSurface (GLAD_API_PTR *PFNEGLGETCURRENTSURFACEPROC)(EGLint readdraw);
typedef EGLDisplay (GLAD_API_PTR *PFNEGLGETDISPLAYPROC)(EGLNativeDisplayType display_id);
typedef EGLint (GLAD_API_PTR *PFNEGLGETERRORPROC)(void);
typedef EGLDisplay (GLAD_API_PTR *PFNEGLGETPLATFORMDISPLAYPROC)(EGLenum platform, void * native_display, const EGLAttrib * attrib_list);
typedef __eglMustCastToProperFunctionPointerType (GLAD_API_PTR *PFNEGLGETPROCADDRESSPROC)(const char * procname);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLGETSYNCATTRIBPROC)(EGLDisplay dpy, EGLSync sync, EGLint attribute, EGLAttrib * value);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLGETSYNCATTRIBKHRPROC)(EGLDisplay dpy, EGLSyncKHR sync, EGLint attribute, EGLint * value);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLINITIALIZEPROC)(EGLDisplay dpy, EGLint * major, EGLint * minor);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLMAKECURRENTPROC)(EGLDisplay dpy, EGLSurface draw, EGLSurface read, EGLContext ctx);
typedef EGLenum (GLAD_API_PTR *PFNEGLQUERYAPIPROC)(void);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLQUERYCONTEXTPROC)(EGLDisplay dpy, EGLContext ctx, EGLint attribute, EGLint * value);
typedef const char * (GLAD_API_PTR *PFNEGLQUERYSTRINGPROC)(EGLDisplay dpy, EGLint name);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLQUERYSURFACEPROC)(EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint * value);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLRELEASETEXIMAGEPROC)(EGLDisplay dpy, EGLSurface surface, EGLint buffer);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLRELEASETHREADPROC)(void);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLSIGNALSYNCKHRPROC)(EGLDisplay dpy, EGLSyncKHR sync, EGLenum mode);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLSURFACEATTRIBPROC)(EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint value);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLSWAPBUFFERSPROC)(EGLDisplay dpy, EGLSurface surface);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLSWAPINTERVALPROC)(EGLDisplay dpy, EGLint interval);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLTERMINATEPROC)(EGLDisplay dpy);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLWAITCLIENTPROC)(void);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLWAITGLPROC)(void);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLWAITNATIVEPROC)(EGLint engine);
typedef EGLBoolean (GLAD_API_PTR *PFNEGLWAITSYNCPROC)(EGLDisplay dpy, EGLSync sync, EGLint flags);

GLAD_API_CALL PFNEGLBINDAPIPROC sf_glad_eglBindAPI;
#define eglBindAPI sf_glad_eglBindAPI
GLAD_API_CALL PFNEGLBINDTEXIMAGEPROC sf_glad_eglBindTexImage;
#define eglBindTexImage sf_glad_eglBindTexImage
GLAD_API_CALL PFNEGLCHOOSECONFIGPROC sf_glad_eglChooseConfig;
#define eglChooseConfig sf_glad_eglChooseConfig
GLAD_API_CALL PFNEGLCLIENTWAITSYNCPROC sf_glad_eglClientWaitSync;
#define eglClientWaitSync sf_glad_eglClientWaitSync
GLAD_API_CALL PFNEGLCLIENTWAITSYNCKHRPROC sf_glad_eglClientWaitSyncKHR;
#define eglClientWaitSyncKHR sf_glad_eglClientWaitSyncKHR
GLAD_API_CALL PFNEGLCOPYBUFFERSPROC sf_glad_eglCopyBuffers;
#define eglCopyBuffers sf_glad_eglCopyBuffers
GLAD_API_CALL PFNEGLCREATECONTEXTPROC sf_glad_eglCreateContext;
#define eglCreateContext sf_glad_eglCreateContext
GLAD_API_CALL PFNEGLCREATEIMAGEPROC sf_glad_eglCreateImage;
#define eglCreateImage sf_glad_eglCreateImage
GLAD_API_CALL PFNEGLCREATEIMAGEKHRPROC sf_glad_eglCreateImageKHR;
#define eglCreateImageKHR sf_glad_eglCreateImageKHR
GLAD_API_CALL PFNEGLCREATEPBUFFERFROMCLIENTBUFFERPROC sf_glad_eglCreatePbufferFromClientBuffer;
#define eglCreatePbufferFromClientBuffer sf_glad_eglCreatePbufferFromClientBuffer
GLAD_API_CALL PFNEGLCREATEPBUFFERSURFACEPROC sf_glad_eglCreatePbufferSurface;
#define eglCreatePbufferSurface sf_glad_eglCreatePbufferSurface
GLAD_API_CALL PFNEGLCREATEPIXMAPSURFACEPROC sf_glad_eglCreatePixmapSurface;
#define eglCreatePixmapSurface sf_glad_eglCreatePixmapSurface
GLAD_API_CALL PFNEGLCREATEPLATFORMPIXMAPSURFACEPROC sf_glad_eglCreatePlatformPixmapSurface;
#define eglCreatePlatformPixmapSurface sf_glad_eglCreatePlatformPixmapSurface
GLAD_API_CALL PFNEGLCREATEPLATFORMWINDOWSURFACEPROC sf_glad_eglCreatePlatformWindowSurface;
#define eglCreatePlatformWindowSurface sf_glad_eglCreatePlatformWindowSurface
GLAD_API_CALL PFNEGLCREATESYNCPROC sf_glad_eglCreateSync;
#define eglCreateSync sf_glad_eglCreateSync
GLAD_API_CALL PFNEGLCREATESYNC64KHRPROC sf_glad_eglCreateSync64KHR;
#define eglCreateSync64KHR sf_glad_eglCreateSync64KHR
GLAD_API_CALL PFNEGLCREATESYNCKHRPROC sf_glad_eglCreateSyncKHR;
#define eglCreateSyncKHR sf_glad_eglCreateSyncKHR
GLAD_API_CALL PFNEGLCREATEWINDOWSURFACEPROC sf_glad_eglCreateWindowSurface;
#define eglCreateWindowSurface sf_glad_eglCreateWindowSurface
GLAD_API_CALL PFNEGLDESTROYCONTEXTPROC sf_glad_eglDestroyContext;
#define eglDestroyContext sf_glad_eglDestroyContext
GLAD_API_CALL PFNEGLDESTROYIMAGEPROC sf_glad_eglDestroyImage;
#define eglDestroyImage sf_glad_eglDestroyImage
GLAD_API_CALL PFNEGLDESTROYIMAGEKHRPROC sf_glad_eglDestroyImageKHR;
#define eglDestroyImageKHR sf_glad_eglDestroyImageKHR
GLAD_API_CALL PFNEGLDESTROYSURFACEPROC sf_glad_eglDestroySurface;
#define eglDestroySurface sf_glad_eglDestroySurface
GLAD_API_CALL PFNEGLDESTROYSYNCPROC sf_glad_eglDestroySync;
#define eglDestroySync sf_glad_eglDestroySync
GLAD_API_CALL PFNEGLDESTROYSYNCKHRPROC sf_glad_eglDestroySyncKHR;
#define eglDestroySyncKHR sf_glad_eglDestroySyncKHR
GLAD_API_CALL PFNEGLGETCONFIGATTRIBPROC sf_glad_eglGetConfigAttrib;
#define eglGetConfigAttrib sf_glad_eglGetConfigAttrib
GLAD_API_CALL PFNEGLGETCONFIGSPROC sf_glad_eglGetConfigs;
#define eglGetConfigs sf_glad_eglGetConfigs
GLAD_API_CALL PFNEGLGETCURRENTCONTEXTPROC sf_glad_eglGetCurrentContext;
#define eglGetCurrentContext sf_glad_eglGetCurrentContext
GLAD_API_CALL PFNEGLGETCURRENTDISPLAYPROC sf_glad_eglGetCurrentDisplay;
#define eglGetCurrentDisplay sf_glad_eglGetCurrentDisplay
GLAD_API_CALL PFNEGLGETCURRENTSURFACEPROC sf_glad_eglGetCurrentSurface;
#define eglGetCurrentSurface sf_glad_eglGetCurrentSurface
GLAD_API_CALL PFNEGLGETDISPLAYPROC sf_glad_eglGetDisplay;
#define eglGetDisplay sf_glad_eglGetDisplay
GLAD_API_CALL PFNEGLGETERRORPROC sf_glad_eglGetError;
#define eglGetError sf_glad_eglGetError
GLAD_API_CALL PFNEGLGETPLATFORMDISPLAYPROC sf_glad_eglGetPlatformDisplay;
#define eglGetPlatformDisplay sf_glad_eglGetPlatformDisplay
GLAD_API_CALL PFNEGLGETPROCADDRESSPROC sf_glad_eglGetProcAddress;
#define eglGetProcAddress sf_glad_eglGetProcAddress
GLAD_API_CALL PFNEGLGETSYNCATTRIBPROC sf_glad_eglGetSyncAttrib;
#define eglGetSyncAttrib sf_glad_eglGetSyncAttrib
GLAD_API_CALL PFNEGLGETSYNCATTRIBKHRPROC sf_glad_eglGetSyncAttribKHR;
#define eglGetSyncAttribKHR sf_glad_eglGetSyncAttribKHR
GLAD_API_CALL PFNEGLINITIALIZEPROC sf_glad_eglInitialize;
#define eglInitialize sf_glad_eglInitialize
GLAD_API_CALL PFNEGLMAKECURRENTPROC sf_glad_eglMakeCurrent;
#define eglMakeCurrent sf_glad_eglMakeCurrent
GLAD_API_CALL PFNEGLQUERYAPIPROC sf_glad_eglQueryAPI;
#define eglQueryAPI sf_glad_eglQueryAPI
GLAD_API_CALL PFNEGLQUERYCONTEXTPROC sf_glad_eglQueryContext;
#define eglQueryContext sf_glad_eglQueryContext
GLAD_API_CALL PFNEGLQUERYSTRINGPROC sf_glad_eglQueryString;
#define eglQueryString sf_glad_eglQueryString
GLAD_API_CALL PFNEGLQUERYSURFACEPROC sf_glad_eglQuerySurface;
#define eglQuerySurface sf_glad_eglQuerySurface
GLAD_API_CALL PFNEGLRELEASETEXIMAGEPROC sf_glad_eglReleaseTexImage;
#define eglReleaseTexImage sf_glad_eglReleaseTexImage
GLAD_API_CALL PFNEGLRELEASETHREADPROC sf_glad_eglReleaseThread;
#define eglReleaseThread sf_glad_eglReleaseThread
GLAD_API_CALL PFNEGLSIGNALSYNCKHRPROC sf_glad_eglSignalSyncKHR;
#define eglSignalSyncKHR sf_glad_eglSignalSyncKHR
GLAD_API_CALL PFNEGLSURFACEATTRIBPROC sf_glad_eglSurfaceAttrib;
#define eglSurfaceAttrib sf_glad_eglSurfaceAttrib
GLAD_API_CALL PFNEGLSWAPBUFFERSPROC sf_glad_eglSwapBuffers;
#define eglSwapBuffers sf_glad_eglSwapBuffers
GLAD_API_CALL PFNEGLSWAPINTERVALPROC sf_glad_eglSwapInterval;
#define eglSwapInterval sf_glad_eglSwapInterval
GLAD_API_CALL PFNEGLTERMINATEPROC sf_glad_eglTerminate;
#define eglTerminate sf_glad_eglTerminate
GLAD_API_CALL PFNEGLWAITCLIENTPROC sf_glad_eglWaitClient;
#define eglWaitClient sf_glad_eglWaitClient
GLAD_API_CALL PFNEGLWAITGLPROC sf_glad_eglWaitGL;
#define eglWaitGL sf_glad_eglWaitGL
GLAD_API_CALL PFNEGLWAITNATIVEPROC sf_glad_eglWaitNative;
#define eglWaitNative sf_glad_eglWaitNative
GLAD_API_CALL PFNEGLWAITSYNCPROC sf_glad_eglWaitSync;
#define eglWaitSync sf_glad_eglWaitSync





#ifdef __cplusplus
}
#endif
#endif

/* Source */
#ifdef SF_GLAD_EGL_IMPLEMENTATION
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef GLAD_IMPL_UTIL_C_
#define GLAD_IMPL_UTIL_C_

#ifdef _MSC_VER
#define GLAD_IMPL_UTIL_SSCANF sscanf_s
#else
#define GLAD_IMPL_UTIL_SSCANF sscanf
#endif

#endif /* GLAD_IMPL_UTIL_C_ */

#ifdef __cplusplus
extern "C" {
#endif



int SF_GLAD_EGL_VERSION_1_0 = 0;
int SF_GLAD_EGL_VERSION_1_1 = 0;
int SF_GLAD_EGL_VERSION_1_2 = 0;
int SF_GLAD_EGL_VERSION_1_3 = 0;
int SF_GLAD_EGL_VERSION_1_4 = 0;
int SF_GLAD_EGL_VERSION_1_5 = 0;
int SF_GLAD_EGL_KHR_cl_event2 = 0;
int SF_GLAD_EGL_KHR_fence_sync = 0;
int SF_GLAD_EGL_KHR_image = 0;
int SF_GLAD_EGL_KHR_image_base = 0;
int SF_GLAD_EGL_KHR_reusable_sync = 0;



PFNEGLBINDAPIPROC sf_glad_eglBindAPI = NULL;
PFNEGLBINDTEXIMAGEPROC sf_glad_eglBindTexImage = NULL;
PFNEGLCHOOSECONFIGPROC sf_glad_eglChooseConfig = NULL;
PFNEGLCLIENTWAITSYNCPROC sf_glad_eglClientWaitSync = NULL;
PFNEGLCLIENTWAITSYNCKHRPROC sf_glad_eglClientWaitSyncKHR = NULL;
PFNEGLCOPYBUFFERSPROC sf_glad_eglCopyBuffers = NULL;
PFNEGLCREATECONTEXTPROC sf_glad_eglCreateContext = NULL;
PFNEGLCREATEIMAGEPROC sf_glad_eglCreateImage = NULL;
PFNEGLCREATEIMAGEKHRPROC sf_glad_eglCreateImageKHR = NULL;
PFNEGLCREATEPBUFFERFROMCLIENTBUFFERPROC sf_glad_eglCreatePbufferFromClientBuffer = NULL;
PFNEGLCREATEPBUFFERSURFACEPROC sf_glad_eglCreatePbufferSurface = NULL;
PFNEGLCREATEPIXMAPSURFACEPROC sf_glad_eglCreatePixmapSurface = NULL;
PFNEGLCREATEPLATFORMPIXMAPSURFACEPROC sf_glad_eglCreatePlatformPixmapSurface = NULL;
PFNEGLCREATEPLATFORMWINDOWSURFACEPROC sf_glad_eglCreatePlatformWindowSurface = NULL;
PFNEGLCREATESYNCPROC sf_glad_eglCreateSync = NULL;
PFNEGLCREATESYNC64KHRPROC sf_glad_eglCreateSync64KHR = NULL;
PFNEGLCREATESYNCKHRPROC sf_glad_eglCreateSyncKHR = NULL;
PFNEGLCREATEWINDOWSURFACEPROC sf_glad_eglCreateWindowSurface = NULL;
PFNEGLDESTROYCONTEXTPROC sf_glad_eglDestroyContext = NULL;
PFNEGLDESTROYIMAGEPROC sf_glad_eglDestroyImage = NULL;
PFNEGLDESTROYIMAGEKHRPROC sf_glad_eglDestroyImageKHR = NULL;
PFNEGLDESTROYSURFACEPROC sf_glad_eglDestroySurface = NULL;
PFNEGLDESTROYSYNCPROC sf_glad_eglDestroySync = NULL;
PFNEGLDESTROYSYNCKHRPROC sf_glad_eglDestroySyncKHR = NULL;
PFNEGLGETCONFIGATTRIBPROC sf_glad_eglGetConfigAttrib = NULL;
PFNEGLGETCONFIGSPROC sf_glad_eglGetConfigs = NULL;
PFNEGLGETCURRENTCONTEXTPROC sf_glad_eglGetCurrentContext = NULL;
PFNEGLGETCURRENTDISPLAYPROC sf_glad_eglGetCurrentDisplay = NULL;
PFNEGLGETCURRENTSURFACEPROC sf_glad_eglGetCurrentSurface = NULL;
PFNEGLGETDISPLAYPROC sf_glad_eglGetDisplay = NULL;
PFNEGLGETERRORPROC sf_glad_eglGetError = NULL;
PFNEGLGETPLATFORMDISPLAYPROC sf_glad_eglGetPlatformDisplay = NULL;
PFNEGLGETPROCADDRESSPROC sf_glad_eglGetProcAddress = NULL;
PFNEGLGETSYNCATTRIBPROC sf_glad_eglGetSyncAttrib = NULL;
PFNEGLGETSYNCATTRIBKHRPROC sf_glad_eglGetSyncAttribKHR = NULL;
PFNEGLINITIALIZEPROC sf_glad_eglInitialize = NULL;
PFNEGLMAKECURRENTPROC sf_glad_eglMakeCurrent = NULL;
PFNEGLQUERYAPIPROC sf_glad_eglQueryAPI = NULL;
PFNEGLQUERYCONTEXTPROC sf_glad_eglQueryContext = NULL;
PFNEGLQUERYSTRINGPROC sf_glad_eglQueryString = NULL;
PFNEGLQUERYSURFACEPROC sf_glad_eglQuerySurface = NULL;
PFNEGLRELEASETEXIMAGEPROC sf_glad_eglReleaseTexImage = NULL;
PFNEGLRELEASETHREADPROC sf_glad_eglReleaseThread = NULL;
PFNEGLSIGNALSYNCKHRPROC sf_glad_eglSignalSyncKHR = NULL;
PFNEGLSURFACEATTRIBPROC sf_glad_eglSurfaceAttrib = NULL;
PFNEGLSWAPBUFFERSPROC sf_glad_eglSwapBuffers = NULL;
PFNEGLSWAPINTERVALPROC sf_glad_eglSwapInterval = NULL;
PFNEGLTERMINATEPROC sf_glad_eglTerminate = NULL;
PFNEGLWAITCLIENTPROC sf_glad_eglWaitClient = NULL;
PFNEGLWAITGLPROC sf_glad_eglWaitGL = NULL;
PFNEGLWAITNATIVEPROC sf_glad_eglWaitNative = NULL;
PFNEGLWAITSYNCPROC sf_glad_eglWaitSync = NULL;


static void sf_glad_egl_load_EGL_VERSION_1_0( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_VERSION_1_0) return;
    sf_glad_eglChooseConfig = (PFNEGLCHOOSECONFIGPROC) load(userptr, "eglChooseConfig");
    sf_glad_eglCopyBuffers = (PFNEGLCOPYBUFFERSPROC) load(userptr, "eglCopyBuffers");
    sf_glad_eglCreateContext = (PFNEGLCREATECONTEXTPROC) load(userptr, "eglCreateContext");
    sf_glad_eglCreatePbufferSurface = (PFNEGLCREATEPBUFFERSURFACEPROC) load(userptr, "eglCreatePbufferSurface");
    sf_glad_eglCreatePixmapSurface = (PFNEGLCREATEPIXMAPSURFACEPROC) load(userptr, "eglCreatePixmapSurface");
    sf_glad_eglCreateWindowSurface = (PFNEGLCREATEWINDOWSURFACEPROC) load(userptr, "eglCreateWindowSurface");
    sf_glad_eglDestroyContext = (PFNEGLDESTROYCONTEXTPROC) load(userptr, "eglDestroyContext");
    sf_glad_eglDestroySurface = (PFNEGLDESTROYSURFACEPROC) load(userptr, "eglDestroySurface");
    sf_glad_eglGetConfigAttrib = (PFNEGLGETCONFIGATTRIBPROC) load(userptr, "eglGetConfigAttrib");
    sf_glad_eglGetConfigs = (PFNEGLGETCONFIGSPROC) load(userptr, "eglGetConfigs");
    sf_glad_eglGetCurrentDisplay = (PFNEGLGETCURRENTDISPLAYPROC) load(userptr, "eglGetCurrentDisplay");
    sf_glad_eglGetCurrentSurface = (PFNEGLGETCURRENTSURFACEPROC) load(userptr, "eglGetCurrentSurface");
    sf_glad_eglGetDisplay = (PFNEGLGETDISPLAYPROC) load(userptr, "eglGetDisplay");
    sf_glad_eglGetError = (PFNEGLGETERRORPROC) load(userptr, "eglGetError");
    sf_glad_eglGetProcAddress = (PFNEGLGETPROCADDRESSPROC) load(userptr, "eglGetProcAddress");
    sf_glad_eglInitialize = (PFNEGLINITIALIZEPROC) load(userptr, "eglInitialize");
    sf_glad_eglMakeCurrent = (PFNEGLMAKECURRENTPROC) load(userptr, "eglMakeCurrent");
    sf_glad_eglQueryContext = (PFNEGLQUERYCONTEXTPROC) load(userptr, "eglQueryContext");
    sf_glad_eglQueryString = (PFNEGLQUERYSTRINGPROC) load(userptr, "eglQueryString");
    sf_glad_eglQuerySurface = (PFNEGLQUERYSURFACEPROC) load(userptr, "eglQuerySurface");
    sf_glad_eglSwapBuffers = (PFNEGLSWAPBUFFERSPROC) load(userptr, "eglSwapBuffers");
    sf_glad_eglTerminate = (PFNEGLTERMINATEPROC) load(userptr, "eglTerminate");
    sf_glad_eglWaitGL = (PFNEGLWAITGLPROC) load(userptr, "eglWaitGL");
    sf_glad_eglWaitNative = (PFNEGLWAITNATIVEPROC) load(userptr, "eglWaitNative");
}
static void sf_glad_egl_load_EGL_VERSION_1_1( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_VERSION_1_1) return;
    sf_glad_eglBindTexImage = (PFNEGLBINDTEXIMAGEPROC) load(userptr, "eglBindTexImage");
    sf_glad_eglReleaseTexImage = (PFNEGLRELEASETEXIMAGEPROC) load(userptr, "eglReleaseTexImage");
    sf_glad_eglSurfaceAttrib = (PFNEGLSURFACEATTRIBPROC) load(userptr, "eglSurfaceAttrib");
    sf_glad_eglSwapInterval = (PFNEGLSWAPINTERVALPROC) load(userptr, "eglSwapInterval");
}
static void sf_glad_egl_load_EGL_VERSION_1_2( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_VERSION_1_2) return;
    sf_glad_eglBindAPI = (PFNEGLBINDAPIPROC) load(userptr, "eglBindAPI");
    sf_glad_eglCreatePbufferFromClientBuffer = (PFNEGLCREATEPBUFFERFROMCLIENTBUFFERPROC) load(userptr, "eglCreatePbufferFromClientBuffer");
    sf_glad_eglQueryAPI = (PFNEGLQUERYAPIPROC) load(userptr, "eglQueryAPI");
    sf_glad_eglReleaseThread = (PFNEGLRELEASETHREADPROC) load(userptr, "eglReleaseThread");
    sf_glad_eglWaitClient = (PFNEGLWAITCLIENTPROC) load(userptr, "eglWaitClient");
}
static void sf_glad_egl_load_EGL_VERSION_1_4( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_VERSION_1_4) return;
    sf_glad_eglGetCurrentContext = (PFNEGLGETCURRENTCONTEXTPROC) load(userptr, "eglGetCurrentContext");
}
static void sf_glad_egl_load_EGL_VERSION_1_5( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_VERSION_1_5) return;
    sf_glad_eglClientWaitSync = (PFNEGLCLIENTWAITSYNCPROC) load(userptr, "eglClientWaitSync");
    sf_glad_eglCreateImage = (PFNEGLCREATEIMAGEPROC) load(userptr, "eglCreateImage");
    sf_glad_eglCreatePlatformPixmapSurface = (PFNEGLCREATEPLATFORMPIXMAPSURFACEPROC) load(userptr, "eglCreatePlatformPixmapSurface");
    sf_glad_eglCreatePlatformWindowSurface = (PFNEGLCREATEPLATFORMWINDOWSURFACEPROC) load(userptr, "eglCreatePlatformWindowSurface");
    sf_glad_eglCreateSync = (PFNEGLCREATESYNCPROC) load(userptr, "eglCreateSync");
    sf_glad_eglDestroyImage = (PFNEGLDESTROYIMAGEPROC) load(userptr, "eglDestroyImage");
    sf_glad_eglDestroySync = (PFNEGLDESTROYSYNCPROC) load(userptr, "eglDestroySync");
    sf_glad_eglGetPlatformDisplay = (PFNEGLGETPLATFORMDISPLAYPROC) load(userptr, "eglGetPlatformDisplay");
    sf_glad_eglGetSyncAttrib = (PFNEGLGETSYNCATTRIBPROC) load(userptr, "eglGetSyncAttrib");
    sf_glad_eglWaitSync = (PFNEGLWAITSYNCPROC) load(userptr, "eglWaitSync");
}
static void sf_glad_egl_load_EGL_KHR_cl_event2( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_KHR_cl_event2) return;
    sf_glad_eglCreateSync64KHR = (PFNEGLCREATESYNC64KHRPROC) load(userptr, "eglCreateSync64KHR");
}
static void sf_glad_egl_load_EGL_KHR_fence_sync( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_KHR_fence_sync) return;
    sf_glad_eglClientWaitSyncKHR = (PFNEGLCLIENTWAITSYNCKHRPROC) load(userptr, "eglClientWaitSyncKHR");
    sf_glad_eglCreateSyncKHR = (PFNEGLCREATESYNCKHRPROC) load(userptr, "eglCreateSyncKHR");
    sf_glad_eglDestroySyncKHR = (PFNEGLDESTROYSYNCKHRPROC) load(userptr, "eglDestroySyncKHR");
    sf_glad_eglGetSyncAttribKHR = (PFNEGLGETSYNCATTRIBKHRPROC) load(userptr, "eglGetSyncAttribKHR");
}
static void sf_glad_egl_load_EGL_KHR_image( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_KHR_image) return;
    sf_glad_eglCreateImageKHR = (PFNEGLCREATEIMAGEKHRPROC) load(userptr, "eglCreateImageKHR");
    sf_glad_eglDestroyImageKHR = (PFNEGLDESTROYIMAGEKHRPROC) load(userptr, "eglDestroyImageKHR");
}
static void sf_glad_egl_load_EGL_KHR_image_base( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_KHR_image_base) return;
    sf_glad_eglCreateImageKHR = (PFNEGLCREATEIMAGEKHRPROC) load(userptr, "eglCreateImageKHR");
    sf_glad_eglDestroyImageKHR = (PFNEGLDESTROYIMAGEKHRPROC) load(userptr, "eglDestroyImageKHR");
}
static void sf_glad_egl_load_EGL_KHR_reusable_sync( GLADuserptrloadfunc load, void* userptr) {
    if(!SF_GLAD_EGL_KHR_reusable_sync) return;
    sf_glad_eglClientWaitSyncKHR = (PFNEGLCLIENTWAITSYNCKHRPROC) load(userptr, "eglClientWaitSyncKHR");
    sf_glad_eglCreateSyncKHR = (PFNEGLCREATESYNCKHRPROC) load(userptr, "eglCreateSyncKHR");
    sf_glad_eglDestroySyncKHR = (PFNEGLDESTROYSYNCKHRPROC) load(userptr, "eglDestroySyncKHR");
    sf_glad_eglGetSyncAttribKHR = (PFNEGLGETSYNCATTRIBKHRPROC) load(userptr, "eglGetSyncAttribKHR");
    sf_glad_eglSignalSyncKHR = (PFNEGLSIGNALSYNCKHRPROC) load(userptr, "eglSignalSyncKHR");
}


static void sf_glad_egl_resolve_aliases(void) {
    if (sf_glad_eglClientWaitSync == NULL && sf_glad_eglClientWaitSyncKHR != NULL) sf_glad_eglClientWaitSync = (PFNEGLCLIENTWAITSYNCPROC)sf_glad_eglClientWaitSyncKHR;
    if (sf_glad_eglClientWaitSyncKHR == NULL && sf_glad_eglClientWaitSync != NULL) sf_glad_eglClientWaitSyncKHR = (PFNEGLCLIENTWAITSYNCKHRPROC)sf_glad_eglClientWaitSync;
    if (sf_glad_eglCreateSync == NULL && sf_glad_eglCreateSync64KHR != NULL) sf_glad_eglCreateSync = (PFNEGLCREATESYNCPROC)sf_glad_eglCreateSync64KHR;
    if (sf_glad_eglCreateSync64KHR == NULL && sf_glad_eglCreateSync != NULL) sf_glad_eglCreateSync64KHR = (PFNEGLCREATESYNC64KHRPROC)sf_glad_eglCreateSync;
    if (sf_glad_eglDestroyImage == NULL && sf_glad_eglDestroyImageKHR != NULL) sf_glad_eglDestroyImage = (PFNEGLDESTROYIMAGEPROC)sf_glad_eglDestroyImageKHR;
    if (sf_glad_eglDestroyImageKHR == NULL && sf_glad_eglDestroyImage != NULL) sf_glad_eglDestroyImageKHR = (PFNEGLDESTROYIMAGEKHRPROC)sf_glad_eglDestroyImage;
    if (sf_glad_eglDestroySync == NULL && sf_glad_eglDestroySyncKHR != NULL) sf_glad_eglDestroySync = (PFNEGLDESTROYSYNCPROC)sf_glad_eglDestroySyncKHR;
    if (sf_glad_eglDestroySyncKHR == NULL && sf_glad_eglDestroySync != NULL) sf_glad_eglDestroySyncKHR = (PFNEGLDESTROYSYNCKHRPROC)sf_glad_eglDestroySync;
}

static int sf_glad_egl_get_extensions(EGLDisplay display, const char **extensions) {
    *extensions = eglQueryString(display, EGL_EXTENSIONS);

    return extensions != NULL;
}

static int sf_glad_egl_has_extension(const char *extensions, const char *ext) {
    const char *loc;
    const char *terminator;
    if(extensions == NULL) {
        return 0;
    }
    while(1) {
        loc = strstr(extensions, ext);
        if(loc == NULL) {
            return 0;
        }
        terminator = loc + strlen(ext);
        if((loc == extensions || *(loc - 1) == ' ') &&
            (*terminator == ' ' || *terminator == '\0')) {
            return 1;
        }
        extensions = terminator;
    }
}

static GLADapiproc sf_glad_egl_get_proc_from_userptr(void *userptr, const char *name) {
    return (GLAD_GNUC_EXTENSION (GLADapiproc (*)(const char *name)) userptr)(name);
}

static int sf_glad_egl_find_extensions_egl(EGLDisplay display) {
    const char *extensions;
    if (!sf_glad_egl_get_extensions(display, &extensions)) return 0;

    SF_GLAD_EGL_KHR_cl_event2 = sf_glad_egl_has_extension(extensions, "EGL_KHR_cl_event2");
    SF_GLAD_EGL_KHR_fence_sync = sf_glad_egl_has_extension(extensions, "EGL_KHR_fence_sync");
    SF_GLAD_EGL_KHR_image = sf_glad_egl_has_extension(extensions, "EGL_KHR_image");
    SF_GLAD_EGL_KHR_image_base = sf_glad_egl_has_extension(extensions, "EGL_KHR_image_base");
    SF_GLAD_EGL_KHR_reusable_sync = sf_glad_egl_has_extension(extensions, "EGL_KHR_reusable_sync");

    return 1;
}

static int sf_glad_egl_find_core_egl(EGLDisplay display) {
    int major, minor;
    const char *version;

    if (display == NULL) {
        display = EGL_NO_DISPLAY; /* this is usually NULL, better safe than sorry */
    }
    if (display == EGL_NO_DISPLAY) {
        display = eglGetCurrentDisplay();
    }
#ifdef EGL_VERSION_1_4
    if (display == EGL_NO_DISPLAY) {
        display = eglGetDisplay(EGL_DEFAULT_DISPLAY);
    }
#endif
#ifndef EGL_VERSION_1_5
    if (display == EGL_NO_DISPLAY) {
        return 0;
    }
#endif

    version = eglQueryString(display, EGL_VERSION);
    (void) eglGetError();

    if (version == NULL) {
        major = 1;
        minor = 0;
    } else {
        GLAD_IMPL_UTIL_SSCANF(version, "%d.%d", &major, &minor);
    }

    SF_GLAD_EGL_VERSION_1_0 = (major == 1 && minor >= 0) || major > 1;
    SF_GLAD_EGL_VERSION_1_1 = (major == 1 && minor >= 1) || major > 1;
    SF_GLAD_EGL_VERSION_1_2 = (major == 1 && minor >= 2) || major > 1;
    SF_GLAD_EGL_VERSION_1_3 = (major == 1 && minor >= 3) || major > 1;
    SF_GLAD_EGL_VERSION_1_4 = (major == 1 && minor >= 4) || major > 1;
    SF_GLAD_EGL_VERSION_1_5 = (major == 1 && minor >= 5) || major > 1;

    return GLAD_MAKE_VERSION(major, minor);
}

static int gladLoadEGLUserPtr(EGLDisplay display, GLADuserptrloadfunc load, void* userptr) {
    int version;
    eglGetDisplay = (PFNEGLGETDISPLAYPROC) load(userptr, "eglGetDisplay");
    eglGetCurrentDisplay = (PFNEGLGETCURRENTDISPLAYPROC) load(userptr, "eglGetCurrentDisplay");
    eglQueryString = (PFNEGLQUERYSTRINGPROC) load(userptr, "eglQueryString");
    eglGetError = (PFNEGLGETERRORPROC) load(userptr, "eglGetError");
    if (eglGetDisplay == NULL || eglGetCurrentDisplay == NULL || eglQueryString == NULL || eglGetError == NULL) return 0;

    version = sf_glad_egl_find_core_egl(display);
    if (!version) return 0;
    sf_glad_egl_load_EGL_VERSION_1_0(load, userptr);
    sf_glad_egl_load_EGL_VERSION_1_1(load, userptr);
    sf_glad_egl_load_EGL_VERSION_1_2(load, userptr);
    sf_glad_egl_load_EGL_VERSION_1_4(load, userptr);
    sf_glad_egl_load_EGL_VERSION_1_5(load, userptr);

    if (!sf_glad_egl_find_extensions_egl(display)) return 0;
    sf_glad_egl_load_EGL_KHR_cl_event2(load, userptr);
    sf_glad_egl_load_EGL_KHR_fence_sync(load, userptr);
    sf_glad_egl_load_EGL_KHR_image(load, userptr);
    sf_glad_egl_load_EGL_KHR_image_base(load, userptr);
    sf_glad_egl_load_EGL_KHR_reusable_sync(load, userptr);

    sf_glad_egl_resolve_aliases();

    return version;
}

static int gladLoadEGL(EGLDisplay display, GLADloadfunc load) {
    return gladLoadEGLUserPtr(display, sf_glad_egl_get_proc_from_userptr, GLAD_GNUC_EXTENSION (void*) load);
}



#ifdef SF_GLAD_EGL

#ifndef GLAD_LOADER_LIBRARY_C_
#define GLAD_LOADER_LIBRARY_C_

#include <stddef.h>
#include <stdlib.h>

#if GLAD_PLATFORM_WIN32
#include <windows.h>
#else
#include <dlfcn.h>
#endif


static void* glad_get_dlopen_handle(const char *lib_names[], int length) {
    void *handle = NULL;
    int i;

    for (i = 0; i < length; ++i) {
#if GLAD_PLATFORM_WIN32
  #if GLAD_PLATFORM_UWP
        size_t buffer_size = (strlen(lib_names[i]) + 1) * sizeof(WCHAR);
        LPWSTR buffer = (LPWSTR) malloc(buffer_size);
        if (buffer != NULL) {
            int ret = MultiByteToWideChar(CP_ACP, 0, lib_names[i], -1, buffer, buffer_size);
            if (ret != 0) {
                handle = (void*) LoadPackagedLibrary(buffer, 0);
            }
            free((void*) buffer);
        }
  #else
        handle = (void*) LoadLibraryA(lib_names[i]);
  #endif
#else
        handle = dlopen(lib_names[i], RTLD_LAZY | RTLD_LOCAL);
#endif
        if (handle != NULL) {
            return handle;
        }
    }

    return NULL;
}

static void glad_close_dlopen_handle(void* handle) {
    if (handle != NULL) {
#if GLAD_PLATFORM_WIN32
        FreeLibrary((HMODULE) handle);
#else
        dlclose(handle);
#endif
    }
}

static GLADapiproc glad_dlsym_handle(void* handle, const char *name) {
    if (handle == NULL) {
        return NULL;
    }

#if GLAD_PLATFORM_WIN32
    return (GLADapiproc) GetProcAddress((HMODULE) handle, name);
#else
    return GLAD_GNUC_EXTENSION (GLADapiproc) dlsym(handle, name);
#endif
}

#endif /* GLAD_LOADER_LIBRARY_C_ */

struct _sf_glad_egl_userptr {
    void *handle;
    PFNEGLGETPROCADDRESSPROC get_proc_address_ptr;
};

static GLADapiproc sf_glad_egl_get_proc(void *vuserptr, const char* name) {
    struct _sf_glad_egl_userptr userptr = *(struct _sf_glad_egl_userptr*) vuserptr;
    GLADapiproc result = NULL;

    result = glad_dlsym_handle(userptr.handle, name);
    if (result == NULL) {
        result = GLAD_GNUC_EXTENSION (GLADapiproc) userptr.get_proc_address_ptr(name);
    }

    return result;
}

static void* _egl_handle = NULL;

static void* sf_glad_egl_dlopen_handle(void) {
#if GLAD_PLATFORM_APPLE
    static const char *NAMES[] = {"libEGL.dylib"};
#elif GLAD_PLATFORM_WIN32
    static const char *NAMES[] = {"libEGL.dll", "EGL.dll"};
#else
    static const char *NAMES[] = {"libEGL.so.1", "libEGL.so"};
#endif

    if (_egl_handle == NULL) {
        _egl_handle = glad_get_dlopen_handle(NAMES, sizeof(NAMES) / sizeof(NAMES[0]));
    }

    return _egl_handle;
}

static struct _sf_glad_egl_userptr sf_glad_egl_build_userptr(void *handle) {
    struct _sf_glad_egl_userptr userptr;
    userptr.handle = handle;
    userptr.get_proc_address_ptr = (PFNEGLGETPROCADDRESSPROC) glad_dlsym_handle(handle, "eglGetProcAddress");
    return userptr;
}

static void gladLoaderUnloadEGL() {
    if (_egl_handle != NULL) {
        glad_close_dlopen_handle(_egl_handle);
        _egl_handle = NULL;
    }
}

static int gladLoaderLoadEGL(EGLDisplay display) {
    int version = 0;
    void *handle = NULL;
    int did_load = 0;
    struct _sf_glad_egl_userptr userptr;

    did_load = _egl_handle == NULL;
    handle = sf_glad_egl_dlopen_handle();
    if (handle != NULL) {
        userptr = sf_glad_egl_build_userptr(handle);

        if (userptr.get_proc_address_ptr != NULL) {
            version = gladLoadEGLUserPtr(display, sf_glad_egl_get_proc, &userptr);
        }

        if (!version && did_load) {
            gladLoaderUnloadEGL();
        }
    }

    return version;
}

#endif /* SF_GLAD_EGL */

#ifdef __cplusplus
}
#endif

#endif /* SF_GLAD_EGL_IMPLEMENTATION */

