% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural-properties.R
\name{dfs}
\alias{dfs}
\title{Depth-first search}
\usage{
dfs(
  graph,
  root,
  mode = c("out", "in", "all", "total"),
  ...,
  unreachable = TRUE,
  order = TRUE,
  order.out = FALSE,
  parent = FALSE,
  dist = FALSE,
  in.callback = NULL,
  out.callback = NULL,
  extra = NULL,
  rho = parent.frame(),
  neimode = deprecated(),
  father = deprecated()
)
}
\arguments{
\item{graph}{The input graph.}

\item{root}{The single root vertex to start the search from.}

\item{mode}{For directed graphs specifies the type of edges to follow.
\sQuote{out} follows outgoing, \sQuote{in} incoming edges. \sQuote{all}
ignores edge directions completely. \sQuote{total} is a synonym for
\sQuote{all}. This argument is ignored for undirected graphs.}

\item{...}{These dots are for future extensions and must be empty.}

\item{unreachable}{Logical scalar, whether the search should visit the
vertices that are unreachable from the given root vertex (or vertices). If
\code{TRUE}, then additional searches are performed until all vertices are
visited.}

\item{order}{Logical scalar, whether to return the DFS ordering of the
vertices.}

\item{order.out}{Logical scalar, whether to return the ordering based on
leaving the subtree of the vertex.}

\item{parent}{Logical scalar, whether to return the parent of the vertices.}

\item{dist}{Logical scalar, whether to return the distance from the root of
the search tree.}

\item{in.callback}{If not \code{NULL}, then it must be callback function.
This is called whenever a vertex is visited. See details below.}

\item{out.callback}{If not \code{NULL}, then it must be callback function.
This is called whenever the subtree of a vertex is completed by the
algorithm. See details below.}

\item{extra}{Additional argument to supply to the callback function.}

\item{rho}{The environment in which the callback function is evaluated.}

\item{neimode}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This argument is deprecated from igraph 1.3.0; use
\code{mode} instead.}

\item{father}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}, use \code{parent} instead.}
}
\value{
A named list with the following entries:
\describe{
\item{root}{
Numeric scalar. The root vertex that was used as the starting point of the search.
}
\item{neimode}{
Character scalar. The \code{mode} argument of the function call.
Note that for undirected graphs this is always \sQuote{all}, irrespectively of the supplied value.
}
\item{order}{
Numeric vector. The vertex ids, in the order in which they were visited by the search.
}
\item{order.out}{
Numeric vector, the vertex ids, in the order of the completion of their subtree.
}
\item{parent}{
Numeric vector. The parent of each vertex, i.e. the vertex it was discovered from.
}
\item{father}{
Like parent, kept for compatibility for now.
}
\item{dist}{
Numeric vector, for each vertex its distance from the root of the search tree.
}
}

Note that \code{order}, \code{order.out}, \code{parent}, and \code{dist}
might be \code{NULL} if their corresponding argument is \code{FALSE}, i.e.
if their calculation is not requested.
}
\description{
Depth-first search is an algorithm to traverse a graph. It starts from a
root vertex and tries to go quickly as far from as possible.
}
\details{
The callback functions must have the following arguments:
\describe{
\item{graph}{
The input graph is passed to the callback function here.
}
\item{data}{
A named numeric vector, with the following entries:
\sQuote{vid}, the vertex that was just visited and
\sQuote{dist}, its distance from the root of the search tree.
}
\item{extra}{
The extra argument.
}
} The callback must return FALSE to continue the search or TRUE
to terminate it. See examples below on how to use the callback functions.
}
\examples{

## A graph with two separate trees
dfs(
  graph = make_tree(10) \%du\% make_tree(10),
  root = 1, mode = "out",
  unreachable = TRUE,
  order = TRUE,
  order.out = TRUE,
  parent = TRUE
)

## How to use a callback
f.in <- function(graph, data, extra) {
  cat("in:", paste(collapse = ", ", data), "\n")
  FALSE
}
f.out <- function(graph, data, extra) {
  cat("out:", paste(collapse = ", ", data), "\n")
  FALSE
}
tmp <- dfs(
  graph = make_tree(10),
  root = 1, mode = "out",
  in.callback = f.in, out.callback = f.out
)

## Terminate after the first component, using a callback
f.out <- function(graph, data, extra) {
  data["vid"] == 1
}
tmp <- dfs(
  graph = make_tree(10) \%du\% make_tree(10),
  root = 1,
  out.callback = f.out
)

}
\seealso{
\code{\link[=bfs]{bfs()}} for breadth-first search.

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{feedback_vertex_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{k_shortest_paths}()},
\code{\link{knn}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
