#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

TMP_TEST_DB=samples.db
TMP_DB_FILE=${TMP_DB_DIR}/samples.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_FILE} < tests/inputs/samples-r92.sql

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} < tests/inputs/samples-metadata-r92.sql
sqlite3 ${TMP_DB_META} "update description set dbname = '${TMP_DB_FILE_ABS}'"

export REQUEST_URI='/~saulius/restful/website/samples.db/lithology_img'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

(

perl -lne 'print "$_\r"' <<PART1
--------------------------b989696a28305e74
Content-Disposition: form-data; name="column:lithology_img:0.image"; filename="256px-Pure_Quartz_at_Senckenberg_Natural_History_Museum.jpg"
Content-Type: application/octet-stream

PART1

cat tests/inputs/images/256px-Pure_Quartz_at_Senckenberg_Natural_History_Museum.jpg
echo -e "\r"

perl -lne 'print "$_\r"' <<PART2
--------------------------b989696a28305e74
Content-Disposition: form-data; name="column:lithology_img:0.image"; filename="Serpentinite.JPG"
Content-Type: application/octet-stream

PART2

cat tests/inputs/images/Serpentinite.JPG
echo -e "\r"

perl -lne 'print "$_\r"' <<PART3
--------------------------b989696a28305e74
Content-Disposition: form-data; name="column:lithology_img:0.format"

JPG
--------------------------b989696a28305e74
Content-Disposition: form-data; name="column:lithology_img:0.format"

JPG
--------------------------b989696a28305e74
Content-Disposition: form-data; name="column:lithology_img:0.caption"

First
--------------------------b989696a28305e74
Content-Disposition: form-data; name="column:lithology_img:0.caption"

Second
--------------------------b989696a28305e74
Content-Disposition: form-data; name="column:lithology_img:0.uuid"

aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa
--------------------------b989696a28305e74
Content-Disposition: form-data; name="column:lithology_img:0.uuid"

aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaab
--------------------------b989696a28305e74
Content-Disposition: form-data; name="Save"

Save
--------------------------b989696a28305e74--
PART3

) \
    | ${INPUT_SCRIPT}

sqlite3 ${TMP_DB_FILE} 'select length(image), caption, format from lithology_img'

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
