# Dalli 5.0

This major version update contains several backwards incompatible changes.

## Breaking Changes

* **Ruby 3.3+ required** - Support for Ruby 3.1 and 3.2 has been dropped.
* **memcached 1.6+ required** - The meta protocol requires memcached 1.6 or later.
* **Binary protocol removed** - The `:protocol` option has been removed. Dalli 5.0 only supports the meta protocol.
* **SASL authentication removed** - The `:username` and `:password` options are no longer functional. The meta protocol does not support authentication.
* **Dalli::Protocol::Binary removed** - If you referenced this class directly, it no longer exists.

## Migration Guide

### 1. Update Ruby version

Ensure you're running Ruby 3.3 or later. JRuby and TruffleRuby are still supported.

### 2. Update memcached version

Ensure you're running memcached 1.6 or later. Earlier versions do not support the meta protocol.

### 3. Remove the :protocol option

The `:protocol` option is no longer needed and will emit a warning if provided:

```ruby
# Before (Dalli 4.x)
Dalli::Client.new(servers, protocol: :meta)

# After (Dalli 5.0)
Dalli::Client.new(servers)
```

### 4. Remove authentication options

If you were using SASL authentication with the binary protocol, this is no longer supported. You'll need to use network-level security instead:

```ruby
# Before (Dalli 4.x with binary protocol)
Dalli::Client.new(servers, username: 'user', password: 'pass')

# After (Dalli 5.0) - use network-level security
# Options include:
# - Firewall rules to restrict memcached access
# - VPN or private network isolation
# - memcached's TLS support for encryption (still supported via :ssl_context option)
Dalli::Client.new(servers)
```

### 5. Update Dalli::Protocol::Binary references

If you referenced `Dalli::Protocol::Binary` directly (unlikely), this class no longer exists:

```ruby
# Before
Dalli::Protocol::Binary

# After - there is only one protocol implementation
Dalli::Protocol::Meta
```

## Staying on Dalli 4.x

If you require SASL authentication or need to support older memcached versions, you can stay on the 4.x release series:

```ruby
# Gemfile
gem 'dalli', '~> 4.0'
```

The 4.x series will continue to receive security updates.

## New Features in 5.0

* **IO Performance** - CRuby users benefit from using Ruby's native `IO#read` with timeout support instead of a custom implementation.
* **Simplified codebase** - Removal of the binary protocol and SASL authentication makes the codebase smaller and easier to maintain.

## Features Added in 4.x (Available in 5.0)

If you're upgrading from Dalli 3.x, you'll also benefit from features added in 4.x:

* **`set_multi`** - Set multiple keys in a single pipelined operation
* **`delete_multi`** - Delete multiple keys in a single pipelined operation
* **`get_with_metadata`** - Retrieve values with CAS, hit status, and last access time
* **`fetch_with_lock`** - Thundering herd protection using meta protocol's recache semantics
* **OpenTelemetry tracing** - Automatic instrumentation when the OpenTelemetry SDK is present
